/*
DISPLAY.H
*/

#ifndef __DISPLAY_H
#define __DISPLAY_H


#include    "def.h"


#ifdef __WIN32__

#define DISPLAY_EN_SET
#define DISPLAY_EN_CLR

#define DISPLAY_RW_SET
#define DISPLAY_RW_CLR

#define DISPLAY_RS_SET          ;
#define DISPLAY_RS_CLR          ;

#define DisplayBacklighOn()
#define DisplayBacklighOff()

#define DYDATA(X)

#else
 #if RSR903

#define DISPLAY_EN_SET
#define DISPLAY_EN_CLR

#define DISPLAY_RW_SET
#define DISPLAY_RW_CLR

#define DISPLAY_RS_SET          ;
#define DISPLAY_RS_CLR          ;

#define DisplayBacklighOn()
#define DisplayBacklighOff()

#define DYDATA(X)

 #else

#define DISPLAY_EN_SET          { if( machineType == MACHINA_ROWE5900 ) FIO2CLR_bit.P2_2 = 1; else FIO2SET_bit.P2_2 = 1; }
#define DISPLAY_EN_CLR          { if( machineType == MACHINA_ROWE5900 ) FIO2SET_bit.P2_2 = 1; else FIO2CLR_bit.P2_2 = 1; }

//rsr675 con pic #define DISPLAY_EN_SET          { FIO2SET_bit.P2_2 = 1; }
//rsr675 con pic #define DISPLAY_EN_CLR          { FIO2CLR_bit.P2_2 = 1; }


#define DISPLAY_RW_SET          FIO2SET_bit.P2_1 = 1;
#define DISPLAY_RW_CLR          FIO2CLR_bit.P2_1 = 1;

#define DISPLAY_RS_SET          { if( machineType == MACHINA_ROWE5900 ) FIO2CLR_bit.P2_0 = 1; else FIO2SET_bit.P2_0 = 1; }
#define DISPLAY_RS_CLR          { if( machineType == MACHINA_ROWE5900 ) FIO2SET_bit.P2_0 = 1; else FIO2CLR_bit.P2_0 = 1; }

//rsr675 con pic #define DISPLAY_RS_SET          { FIO2SET_bit.P2_0 = 1; }
//rsr675 con pic #define DISPLAY_RS_CLR          { FIO2CLR_bit.P2_0 = 1; }

#define DisplayBacklighOn()     FIO2SET_bit.P2_7 = 1
#define DisplayBacklighOff()    FIO2CLR_bit.P2_7 = 1

#define DYDATA(X)               { if( machineType == MACHINA_ROWE5900 )                               \
                                    {FIO2CLR = ((X) & 0x0F) << 3; FIO2SET = ((~(X)) & 0x0F) << 3;}    \
                                  else                                                                \
                                    {FIO2SET = ((X) & 0x0F) << 3; FIO2CLR = ((~(X)) & 0x0F) << 3;}    \
                                }

//rsr675 con pic #define DYDATA(X)                     {FIO2SET = ((X) & 0x0F) << 3; FIO2CLR = ((~(X)) & 0x0F) << 3;}   

 #endif
#endif

#define COMMAND     0
#define DATA        1

#define LCDROW  1
#define LCDCOL  16




extern char bufferLCD[];

#if RSR903
#define         DispInit( )
#define         WriteRows( )
#define         WriteLCD( a, b )
#define         DispCursorSet(a, b)
#define         DispChar(a, b, c)
#define         DispStr( row,  col,  s)
#define         DispClrScr( )
#define         VisuaMenu( str)
#define         CursorBlink(  _row,  _col )
#define         CursorOn(  _row,  _col )
#define         CursorOff( )
#define         showPleaseWait(  msg )
#define         DisplayLock( delay )
#else
void            DispInit( void );
void            WriteRows( void );
void            WriteLCD( byte address, byte data );
void            DispCursorSet(unsigned char row, unsigned char col);
void            DispChar(unsigned char row, unsigned char col, char c);
void            DispStr(unsigned char row, unsigned char col, char *s);
void            DispClrScr(void);
void            VisuaMenu(char *str);
void            CursorBlink( unsigned char _row, unsigned char _col );
void            CursorOn( unsigned char _row, unsigned char _col );
void            CursorOff( void );
void            showPleaseWait( char *msg );
void            DisplayLock( unsigned int delay );
#endif



#endif
