#include "def.h"

void HeapSort( unsigned long *heap, int no )
{
    short i, j, c, root;
    unsigned long temp;
    
    for (i = 1; i < no; i++)
    {
        c = i;
        do
        {
            root = (c - 1) / 2;             
            if (heap[root] < heap[c])   /* to create MAX heap array */
            {
                temp = heap[root];
                heap[root] = heap[c];
                heap[c] = temp;
            }
            c = root;
        } while (c != 0);
    }
 
    for (j = no - 1; j >= 0; j--)
    {
        temp = heap[0];
        heap[0] = heap[j];    /* swap max element with rightmost leaf element */
        heap[j] = temp;
        root = 0;
        do 
        {
            c = 2 * root + 1;    /* left node of root element */
            if ( c < j-1 && (heap[c] < heap[c + 1]) )
                c++;
            if ( c < j && heap[root]<heap[c] )    /* again rearrange to max heap array */
            {
                temp = heap[root];
                heap[root] = heap[c];
                heap[c] = temp;
            }
            root = c;
        } while (c < j);
    } 
}

void indexedHeapSort( unsigned short *index, unsigned long *heap, int no )
{
    short i, j, c, root;
    unsigned long temp;
    
    for (i = 0; i < no; i++)
      *(index + i ) = i;
      
    for (i = 1; i < no; i++)
    {
        c = i;
        do
        {
            root = (c - 1) / 2;             
            if (heap[index[root]] < heap[index[c]])   /* to create MAX heap array */
            {
                temp = index[root];
                index[root] = index[c];
                index[c] = temp;
            }
            c = root;
        } while (c != 0);
    }
 
    for (j = no - 1; j >= 0; j--)
    {
        temp = index[0];
        index[0] = index[j];    /* swap max element with rightmost leaf element */
        index[j] = temp;
        root = 0;
        do 
        {
            c = 2 * root + 1;    /* left node of root element */
            if ( c < j-1 && (heap[index[c]] < heap[index[c + 1]]) )
                c++;
            if ( c < j && heap[index[root]] < heap[index[c]] )    /* again rearrange to max heap array */
            {
                temp = index[root];
                index[root] = index[c];
                index[c] = temp;
            }
            root = c;
        } while (c < j);
    } 
}

