/* RegolaTemperatura */

#include    "ram.h"
#include    "temperatura.h"
#include    "keyadc.h"
#include    "main.h"
#include    "keyboard.h"
#include    "event.h"

void            BuzzerOn( unsigned short _durata );

#define     base_tick 1000L       // frequenza interrupt 1000tick/sec
//#define     base_tick 17L       // frequenza interrupt 1000tick/sec

/*
int Tbase[] = {     0, 8854, 6849, 5735, 4958, 4356, 3861, 3436, 
                 3059, 2719, 2406, 2112, 1834, 1567, 1308, 1055,  
                  804,  553,   299,  40, -227, -508, -808,-1135,
                -1501,-1928, -2457,-3193 };
*/
int Tbase[] = {     0, 10332, 7792, 6409, 5456, 4724, 4125, 3614,
                 3165,  2760, 2388, 2042, 1715, 1402, 1099,  804,
                  512,   222,  -70, -368, -676, -997,-1339,-1710,
                -2124, -2604,-3196,-4013 };

dword compressoreOFF = 0, compressoreON = 0, lastTimeRead = 0, doorClosed = 0, fromReset = 0;

void RegolaTemperatura( void );
void testHealthTimer( void);
/*

  Rntc = 10k*exp( 4500*(1/(273,16+T)-1/(273.16+25))
  Req = Rntc // 47k
  ADC = 1024 * 5V * Req / ( 33k + Req ) / 3.3V ( see file ntc_AMS.ods )
  ADC / 32 is used to index a linear interpolation table
  Temp = TGAIN[ADC/32]*(ADC-ADC/32)+TBASE[ADC/32]

*/

void RegolaTemperatura( void )
{
    byte p;

    if( enTEMP( 0 ) )
    {
        Temperatura = 0;
        HealthProblem = HEALTH_NORM;
        return;
    }
    
    p = AD.conv[AD_2]>>5;
    if( p >= ( sizeof( Tbase )/sizeof( Tbase[0] )-2) )
    {                                                       // error, NTC unconnected
        outImage[OUT_COIN_BILL] &= ~0x80;
        Temperatura = 9999;
    }
    else
        Temperatura = ( (Tbase[p+1]-Tbase[p])*( AD.conv[AD_2] & 0x1F ) / 32 ) + Tbase[p];
#if TOK_TAKE
        Temperatura = Temperatura+135;                // Celsius, correggo errore di offset ( DEBUG )
#else    
//    if( NonVolatileSetup.TemperaturaUnit == Farheneit )
        Temperatura = Temperatura/10*18+3200+250;     // farhenheit, correggo errore di offset ( DEBUG )
#endif            
    testHealthTimer();
    
    if( machineType == MACHINA_USIGVC2 )
    {
        if( doorOpen() ) 
            outImage[OUT_COIN_BILL] &= ~0x40;
        else
            outImage[OUT_COIN_BILL] |=  0x40;
    }

    if( doorOpen() )
    {
        if( ( outImage[OUT_COIN_BILL] & 0x80 ) != 0 )
        {
            outImage[OUT_COIN_BILL] &= ~0x80;
            compressoreOFF = 3L*60L*base_tick;          // tempo minimo di disattivazione 3'
        }
        if( ( GetTickCount() - doorTimeClose ) > 3L*base_tick )
        {
            doorTimeClose = GetTickCount();             // Buzzer intermittente in caso di errore
            if( HealthProblem == HEALTH_FAIL )
                BuzzerOn( 200 );
        }
        doorClosed = 0;
        return;
    }
    else if( doorClosed == 0 )
    {
        if( HealthProblem == HEALTH_FAIL )
            InsertEvent( EVENT_HEALTH_TIMEOUT_OFF, 0x00 );
        HealthProblem = HEALTH_DOOR;                    // errore cancellato chiudedno la porta
        doorTimeClose = GetTickCount();
        doorClosed = 1;
    }
    
    if( compressoreOFF )
    {
        compressoreOFF--;
        compressoreON = 0;
        return;
    }

    if( ( outImage[OUT_COIN_BILL] & 0x80 ) != 0 )
    {
        compressoreON++;
        if( compressoreON > 60L*60L*base_tick)          // after 1h switch off 7.5'
        {
          outImage[OUT_COIN_BILL] &= ~0x80; 
          compressoreOFF = 15L*30L*base_tick;           // tempo minimo di disattivazione 7.5'
          return;
        }
    }
      
    if( Temperatura > ( NonVolatileSetup.Temperatura*100L        ) && ( outImage[OUT_COIN_BILL] & 0x80 ) == 0x00 )        /* attiva uscita 0F sopra setting*/
    {
        outImage[OUT_COIN_BILL] |= 0x80;
        compressoreOFF = 10L*base_tick;                // tempo minimo di attivazione 10"
    }
    if( Temperatura < ( NonVolatileSetup.Temperatura*100L - 400L ) && ( outImage[OUT_COIN_BILL] & 0x80 ) != 0x00 )        /* disattiva uscita 4F sotto setting*/  
    {
        outImage[OUT_COIN_BILL] &= ~0x80; 
        compressoreOFF = 3L*60L*base_tick;                // tempo minimo di disattivazione 3'
    }

    return;
}


extern char            editData[256];        // buffer edit dati menu.h
extern unsigned short  EditNumBox( unsigned char typeVar, unsigned char readOnly, byte _nDecimal );
extern byte            K_SX, K_DX, K_UP, K_DW, K_ESC, K_OK;


/*--------------------------------------------------------------------------
 | edTempSel:  program Temperatura
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edTempSel( unsigned char typeVar )
{
    *((DWORD *)editData) = NonVolatileSetup.Temperatura;
    if ( *((DWORD *)editData) > 99 )
        *((DWORD *)editData) = 99;

    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.Temperatura != *((DWORD *)editData) )
    {
        NonVolatileSetup.Temperatura = *((DWORD *)editData);
        saveSettings();
    }
    return K_OK;
}                                               //  edWinSel

/*--------------------------------------------------------------------------
 | enTEMP:   verify if temperature us regulated
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       temperature to regulate
 |      1       do not regulate
 +--------------------------------------------------------------------------*/

byte            enTEMP( unsigned char _typeVar )
{
    if ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 )
        return 0;
    return 1;
}                                               //  enTEMP


/*--------------------------------------------------------------------------
 | testHealthTimer:   NAMA regulation
 |                    The HealthProblem variable is set to the actual NAMA regulation status
 |                    HEALTH_DOOR after the door is closed, a 30' wait time
 |                    HEALTH_FAIL if failure to comply NAMA rules
 |                    There is a "fast" check for the temperature threshold : door open and T > 41F, HEALTH_FAIL is set
 |                              --------------
 | In:  void
 | Out: void
 |    
 +--------------------------------------------------------------------------*/
void  SetHealthProblem( void )
{
    if( HealthProblem != HEALTH_FAIL )
        InsertEvent( EVENT_HEALTH_TIMEOUT_ON, 0x00 );
    HealthProblem = HEALTH_FAIL;
}

void testHealthTimer( void)
{
    if( NonVolatileSetup.Temperatura <= 41 )              // no health test if set T > 41F
    {
        if( fromReset == 0 )                              // after 10" after power on
        {
//            if( GetTickCount() > 10L*base_tick )
            if( timeOFF == 0xFFFFFFFFL )
            {
                fromReset = 1;
                if( Temperatura >=  41*100L )             // if T >= 41F, error ( this is the 15' OFF TIMER substitute )
                {
                    SetHealthProblem() ;
                }
            }
            else if ( timeOFF != 0L )
            {
                fromReset = 1;
                if( timeOFF > 15L && Temperatura >= NonVolatileSetup.Temperatura*100L )
                {
                    SetHealthProblem() ;
                }
            }
        }
        else if( doorOpen() && Temperatura >=  41*100L )  // to easy NAMA testing, when DOOR is open test temperature, if > 41F immediare error
        {
            HealthProblem = HEALTH_FAIL;                  // il TEST NAMA non lascia traccia nell'audit
        }
        else if( !doorOpen() && HealthProblem == HEALTH_DOOR ) // wait time after door is closed
        {
            if( GetTickCount() - doorTimeClose > 30L*60L*base_tick )           
            {
                if( Temperatura <  41*100L )              // after wait time test T < 41F
                    HealthProblem = HEALTH_NORM;
                else
                {
                    SetHealthProblem() ;
                }
            }
            lastTimeRead = GetTickCount();
        }
        else if( Temperatura < NonVolatileSetup.Temperatura*100L )
        {
            lastTimeRead = GetTickCount();                // temperature is OK, reset health timeout 15'
        }
                                                          // after door wait, it T > Tset for 15', health problem
        else if( GetTickCount() - lastTimeRead > 15L*60L*base_tick )              
        {
            SetHealthProblem() ;
        }
    }
    else
    {
        if( HealthProblem == HEALTH_FAIL )
            InsertEvent( EVENT_HEALTH_TIMEOUT_OFF, 0x00 );
        HealthProblem = HEALTH_NORM;
    }
}
