//---------------------------------------------------------------------------

#pragma hdrstop

//---------------------------------------------------------------------------

#pragma argsused

#include <conio.h>
#include <ctype.h>
#include <io.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "crc16.h"

#define	hexbin(a)	(((a)<='9')?((a)-'0'):((a)-'A'+10))
#define binhex(a)	(((a)<= 9)?((a)+'0'):((a)-10+'A'))

typedef	unsigned char byte;
typedef unsigned int word;
typedef unsigned int WORD;
typedef unsigned long dword;
typedef unsigned long DWORD;

#define FIRMWARESTART   0x0000
#define FIRMWARE_VER    0x7FE0
#define FIRMWAREEND     0x7FF0

byte            firmware[512*1024];
FILE		    *fp, *fout;
word		    nbyte;

byte            flashIntelFile( DWORD _filelen );

void            outHex( FILE *_fout, char *_buf )
{
    int         i, crc, ver;
    char        outbuf[128];

    crc = 0;
    for ( i = 1; _buf[i] != '\0'; i += 2 )
    {
        sscanf( &_buf[i], "%2x", &ver );
        crc += ver;
    }
//    sprintf( outbuf, "%s%02X\x0d\x0a", _buf, (-crc)&0xFF );
    sprintf( outbuf, "%s%02X\n", _buf, (-crc)&0xFF );
    fprintf( _fout, "%s", outbuf );

    for ( i = 0; outbuf[i] != '\0'; i++ )
        crc_16( outbuf[i] );
}

int				main( int argv, char *argc[] )
{
	byte		i, inb;
	int			ch, ver;
	char		srec0[128], srec8[8+1], sbuf[256], *p;
	word		memCrc;
    dword       addr, hiaddr;


    printf("checksum #1.0.0\n" );
    printf("in:  %s\n", argc[1] );
    printf("out: %s\n", argc[2] );

    memset( firmware, 0xFF, sizeof(firmware) );

    if ( argv < 5 )
    {
        printf( "Usage: checksum <input_file> <output_file> <project> <version> [<definition>]\n" );
        return 1;
    }

	if( (fp=fopen(argc[1],"rb")) == NULL )
    {
        printf( "Unable to open input file: %s\n", argc[1] );
		return 2;
    }


    nbyte = 0;
    if ( strstr(argc[1],"bin") != NULL || strstr(argc[1],"Bin") != NULL || strstr(argc[1],"BIN") != NULL )
    {                                   // load binary file
        addr = FIRMWARESTART;
        while( !feof( fp) ) {
            if ( (ch=getc(fp)) == EOF )
                break;

            firmware[addr++] = (byte)ch;
            nbyte++;
        }
    }
    else
    {                                   // load intel hex
        flashIntelFile( filelength(fileno(fp)) );
    }

	fclose(fp);

// check memory options
    if ( argv > 5 )
    {
        clreol();
        for ( i = 5; i < argv; i++ )
        {
            printf( "opt: %s\n", argc[i] );
            // get address
            addr = 0;
            if ( sscanf( argc[i], "-m0x%lx=%[^\n]", &addr, sbuf ) != 2 )
                continue;
            //printf( "\t'%lx'='%s'\n", addr, sbuf );
            // get value
            if ( sbuf[0] == '0' && sbuf[1] == 'x' )
            {                           // hex
                p = &sbuf[0];
                while ( *p != '\0' )
                {
                    if ( *(p+0) != '0' || *(p+1) != 'x' )
                        break;
                    p += 2;
                    if ( isxdigit(*p) )
                    {
                        inb = (byte)((*p>='0'&&*p<='9')?(*p-'0'):(*p-'A'+10));
                        p++;
                    }
                    else
                        break;
                    if ( isxdigit(*p) )
                    {
                        inb = (byte)((inb<<4) + (*p>='0'&&*p<='9')?(*p-'0'):(*p-'A'+10));
                        p++;
                    }
                    else
                        break;
                    if ( *p == ',' )
                        p++;
                    firmware[addr++] = inb;
                }
            }
            else
            {                           // string copy
                strcpy( (char *)&firmware[addr], sbuf );
            }
        }
    }
//

	if( (fout=fopen(argc[2],"wb")) == NULL )
    {
        printf( "Unable to open output file: %s\n", argc[2] );
		return 2;
    }


    BCC = 0;
    for ( addr = FIRMWARESTART; addr < FIRMWAREEND; addr++ )
        crc_16(firmware[addr]);
    memCrc = BCC;

    ver = strlen(argc[3]);
    if ( ver > 8 )
        ver = 8;
    memset( srec8, ' ', 8 );
    memcpy( srec8, argc[3], ver );
    ver = atoi(argc[4]);
    sprintf( srec0, ":10008000%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%08lX",
                        srec8[0],srec8[1],srec8[2],srec8[3],srec8[4],srec8[5],srec8[6],srec8[7],
                            '0'+((ver/1000)%10),
                                '0'+((ver/ 100)%10),
                                    '0'+((ver/  10)%10),
                                        '0'+((ver/   1)%10),
                                            memCrc );
    outHex( fout, srec0 );


    BCC = 0;
    hiaddr = 0xFFFFFFFF;
    for ( addr = FIRMWARESTART; addr < FIRMWAREEND; addr += 16 )
    {
        inb = 0;
        sprintf( srec0, ":10%04X00", (addr&0xFFFF) );
        for ( i = 0; i < 16; i++ )
        {
            sprintf( &srec0[9+i*2], "%02X", firmware[addr+i] );
            if ( firmware[addr+i] != 0xFF )
                inb = 1;
        }
        if ( inb == 0 )
            continue;
        if ( (hiaddr&0xFFFF0000) != (addr&0xFFFF0000) )
        {
            hiaddr = addr;
            sprintf( srec8, ":02000004%04lX", ((addr>>16)&0xFFFF) );
            outHex( fout, srec8 );
        }
        outHex( fout, srec0 );
    }

    addr = FIRMWAREEND;
    if ( (hiaddr&0xFFFF0000) != (addr&0xFFFF0000) )
    {
        sprintf( srec8, ":02000004%04lX", ((addr>>16)&0xFFFF) );
        outHex( fout, srec8 );
    }

    ver = strlen(argc[3]);
    if ( ver > 8 )
        ver = 8;
    memset( srec8, ' ', 8 );
    memcpy( srec8, argc[3], ver );
    ver = atoi(argc[4]);
    sprintf( srec0, ":10%04lX00%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%08lX",
                        (addr&0xFFFF),
                            srec8[0],srec8[1],srec8[2],srec8[3],srec8[4],srec8[5],srec8[6],srec8[7],
                                '0'+((ver/1000)%10),
                                    '0'+((ver/ 100)%10),
                                        '0'+((ver/  10)%10),
                                            '0'+((ver/   1)%10),
                                                memCrc );
    outHex( fout, srec0 );



    printf("checksum(%X), bytes checked(%ld)\n", memCrc, nbyte );

    rewind(fout);
    addr = FIRMWARE_VER;
    sprintf( srec0, ":10%04lX00%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%04lX%04lX",
                        (addr&0xFFFF),
                            srec8[0],srec8[1],srec8[2],srec8[3],srec8[4],srec8[5],srec8[6],srec8[7],
                                '0'+((ver/1000)%10),
                                    '0'+((ver/ 100)%10),
                                        '0'+((ver/  10)%10),
                                            '0'+((ver/   1)%10),
                                                BCC,
                                                    memCrc );
    outHex( fout, srec0 );

	fclose(fout);

	return 0;
}
//---------------------------------------------------------------------------

/*--------------------------------------------------------------------------
 | intelHexConvert:
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            hex2bin( byte *_dest, byte *_source )
{
    *_dest = 0;
    if ( *_source >= '0' && *_source <= '9' )
        *_dest = (byte)((*_source-'0')<<4);
    else if ( *_source >= 'A' && *_source <= 'F' )
        *_dest = (byte)((*_source-'A'+10)<<4);
    else
        return 1;
    _source++;

    if ( *_source >= '0' && *_source <= '9' )
        *_dest |= (byte)(*_source-'0');
    else if ( *_source >= 'A' && *_source <= 'F' )
        *_dest |= (byte)(*_source-'A'+10);
    else
        return 1;
    
    return 0;
}

byte            intelHexConvert( byte *_dest, byte *_len, byte *_type, DWORD *_addr, byte *_source )
{
    byte        len, dato;

    do {
        if ( *_source == '\0' )
            return 1;
    }  while( *_source++ != ':' );

    if ( hex2bin( &len, _source ) != 0 )
        return 2;
    _source += 2;

    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_addr = dato<<8;
    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_addr |= dato;

    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_type = dato;

    *_len = 0;
    while( len-- > 0 )
    {
        if ( hex2bin( _dest++, _source ) != 0 )
            return 2;
        _source += 2;
        *_len = (byte)(*_len+1);
    }

    return 0;
}                                               //  intelHexConvert




/*---------------------------------------------------------------------------
 | FAT_getsFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte		    FAT_getsFile( byte *_buf, byte *_len )
{
	byte        i, dato;

    i = 0;
    *_buf = '\0';
    do {
        if ( (dato=(byte)getc(fp)) == (byte)EOF )
        {
            if ( i == 0 )
                return 1;
            *_len = i;
            return 0;
        }
        nbyte++;
        *_buf++ = dato;
        *_buf = '\0';
        i++;
        if ( i >= *_len )
            break;
    } while( dato >= ' ' );              // till cr/lf
    *_buf = '\0';
    *_len = i;
    return 0;
}                                               //  FAT_getsFile

byte            flashIntelFile( DWORD _filelen )
{
    byte        il, type, perc, oldperc, intelBuf[100], buflen;
    DWORD       baseAddr, destAddr, len;

                                        // verify checksum and load file
    len = 0;
    BCC = 0;
    oldperc = 0;
    while ( len < _filelen )
    {
        buflen = sizeof(intelBuf);
        if ( FAT_getsFile(intelBuf,&buflen) != 0 )
            return 1;
        len += buflen;

        if ( buflen < 2 )
            continue;
        
        if ( intelHexConvert(intelBuf,&il,&type,&destAddr,intelBuf) != 0 )
            return 2;                       // wrong intel format
        
        perc = (byte)((WORD)((100L*(DWORD)len)/(DWORD)_filelen));
        if ( perc != oldperc )
        {
            oldperc = perc;
            printf( "LOADING %3d %%  \r", perc );
        }

        if ( type == 4 )
        {                               // change base address
            baseAddr = (((DWORD)intelBuf[0]<<24)+(DWORD)intelBuf[1])<<16;
            continue;
        }
        if ( type != 0 )
            return 2;                   // wrong intel format

        memcpy( &firmware[baseAddr+destAddr], intelBuf, il );
    }

    if ( len != _filelen )
        return 3;
    return 0;
}                                               //  flashIntelFile

