/***************************************************************************
 ************************                       ****************************
 ************************         D E F         ****************************
 ************************                       ****************************
 ***************************************************************************/
#ifndef __DEF_H
#define __DEF_H


#define NUM_BLOCK_ARCHIVE   3
//#define __ESP
#define __USA

#define SETUP_VERSION       0xFB04      // this must be changed if memory map is changed

// DEBUG
#define BOARDTEST           1           // 1=enable board test
#define VERSIONE_642E       0           // 1=<=642E 0=>642E
#define TESTKEYBOARD        0           // 1=special keyboard test

#define MDB_DEBUG           0           // define if COMM1 used as MDB debug port
#define MDB_DEBUG_MMC       0           // replicate debug information on SD/MMC if available (MDB_DEBUG must be set to 1)
#define HOME_DEBUG          0           // test why homing doesn-t work
#define KEY_DEBUG           0           // test for AP113 analog keypad
#define SERIAL_PROTOCOL_DEB 0           // serial port protocol debug

// FUNCTIONS
#define MULTI_VEND          1           // 1=enable multivend
#define ANTI_V              0           // 1=antivandalism -- will conflict with Micromech Coin
#define DEX_BY_MODEM        1           // 1=longer timeout for modem communication
#define LED_DIMMING         1           // 1=activate led dimming
#define LED_DISPLAY_PRICE   1           // 1=digital display price
#define FULL_GROUPS_CONF    0           // 1=enale full groups configuration
#define SLAVE_MACHINE       1           // to enable on  VEIDOOR driving a slave machine
#define ENABLE_DISCOUNT     1
#define ENABLE_TAX_VISUA    1
#define PRODUCT_RECOGNITION 0
#define FULL_MOTOR          0
#define MIND_UCB_COMM4      1           // UCB-MIND communication enable su COM4
#define ENABLE_COMM1        0//0           // UCB-MIND communication enable su COM1 (must be enabled MIND_UCB_COMM4

#define TOK_TAKE            0
#define DECIMAL_PLACE       2           // standard version has 2 decimal point ! 0=jamaica

///////////////////////////////////////////////////////////////////////////////
//                          ALMOST NEVER USED
////////////////////////////
#define MODEM_HTTP          0 //1       // 1=modem
#define NODE_IDENTIFIER     0           // 1=set NODE IDENTIFIER on zigBee module
#define SERIAL_BILL_VALIDATOR   0       // 1=enable micromech/pulse bill validator for NAT147 interface board
#define ZIGBEE              0

///////////////////////////////////////////////////////////////////////////////
//                          SELECT ONLY ONE OF THIS VERSION
////////////////////////////
#define STANDARD_VERSION    1
#define DEMO_VERSION        0
#define RSR903              0
//#define BOOT                1
//#define BOOT2               1
///////////////////////////////////////////////////////////////////////////////
// only for slave RSR903
#define RSR903_MDB          RSR903+STANDARD_VERSION // TEST SLAVE
//#define RSR903_MDB          0

#ifdef BOOT
#undef  BOARDTEST
#define BOARDTEST           0           // 1=enable board test
#undef  MULTI_VEND
#undef  NODE_IDENTIFIER
#define MULTI_VEND          0           // 1=enable multivend
#define NODE_IDENTIFIER     0           // 1=set NODE IDENTIFIER on zigBee module
#undef  ENABLE_DISCOUNT
#define ENABLE_DISCOUNT     0
#undef  ENABLE_TAX_VISUA
#define ENABLE_TAX_VISUA    0
#undef  LED_DIMMING
#define LED_DIMMING         0           // 1=activate led dimming
#undef  LED_DISPLAY_PRICE
#define LED_DISPLAY_PRICE   0
#undef  MIND_UCB_COMM4
#define MIND_UCB_COMM4      0
#define MOTOR_SIMULATION    0           // 1=simulate motor presence
#else

#if STANDARD_VERSION
#undef  NODE_IDENTIFIER
#define NODE_IDENTIFIER     0 //1           // 1=set NODE IDENTIFIER on zigBee module TODO
#define MOTOR_SIMULATION    0           // 1=simulate motor presence
#endif

#if DEMO_VERSION
#define MOTOR_SIMULATION    1           // 1=simulate motor presence
#endif

#if RSR903
#undef  ENABLE_COMM1
#define ENABLE_COMM1        1           // UCB-MIND communication enable su COM1 (must be enabled MIND_UCB_COMM4
#undef  FULL_MOTOR
#define FULL_MOTOR          1
#undef  SLAVE_MACHINE
#define SLAVE_MACHINE       1
#define MOTOR_SIMULATION    0           // 1=simulate motor presence
#undef  LED_DIMMING
#define LED_DIMMING         0           // 1=digital display price

#endif // RSR903

#endif // BOOT

#define BOOTSTART                   0x0000L
#define BOOT_VER                    0x7FE0L
#define BOOTEND                     0x7FFFL
#define FIRMWARESTART               0x8000L
#define FIRMWARE_VER                0x80E0
#define FIRMWAREEND                 0x3FFFFL
#define VENDNAME                    0x8080L
#define FIRMWAREFILENAME            "RSR641AA"
#define FIRMWAREFILEEXTENSION       "HEX"

//#define DEBUG_MCI(a)    DispStr( 0, 0, a )
#define DEBUG_MCI(a)

#define ENABLE_BIT_DEFINITIONS
#include <ctype.h>
#ifdef  __WIN32__
#include    <windows.h>
#else
#include <inarm.h>

#include "io2368.h"
#endif

#ifndef	NULL
#define	NULL			0
#endif

#ifndef	TRUE
#define	TRUE			(1==1)
#endif
#ifndef	FALSE
#define	FALSE			(1==0)
#endif

#define	ms(a)				(a)
#ifndef min
#define	min(a,b)			((a)<(b)?(a):(b))
#endif
//#define	LOBYTE(a)			((byte)(a))

/*****************************************************************************/

typedef unsigned char   byte;           // 8-bit unsigned integer
typedef          char   sbyte;          // 8-bit integer
typedef unsigned short  word;           // 16-bit unsigned integer
typedef short           sword;          // 16-bit integer
typedef	unsigned long   dword;          // 32-bit unsigned integer
typedef	long		    sdword;         // 32-bit integer

#ifndef __WIN32__
typedef unsigned short  UINT;           // 16-bit unsigned integer
typedef unsigned char   BOOL;           //  8-bit unsigned char
#endif
typedef	unsigned long   _ULONG;         // 32-bit unsigned long
typedef	unsigned short  _USHORT;        // 16-bit unsigned short
typedef	         long   _LONG;          // 32-bit signed long
typedef	unsigned char   _BOOL;          //  8-bit unsigned char
typedef unsigned long   DWORD;          // 32-bit unsigned long
typedef long            SDWORD;         // 32-bit signed long
typedef unsigned short  WORD;           // 16-bit unsigned short
typedef short           SWORD;          // 16-bit signed short
typedef unsigned char   _UCHAR;         //  8-bit unsigned long
typedef char            _CHAR;          //  7-bit signed long

typedef	unsigned long   _Credito;       // usato per le valutazioni monetarie
typedef unsigned short  T_AMOUNT;


typedef struct {
    word        year;
    word        month;
    word        day;
    word        hour;
    word        min;
    word        sec;
} _dateTime;



//	DEFINIZIONE MACRO
/* convert 2 consecutive bytes to a unsigned short */
#define Cv2ushort(y,x)          (((unsigned short)(unsigned char)(x))|(((unsigned short)(unsigned char)(y))<<8))

/* Extract a short from a long */
#define	hiword(x)		((unsigned short)((x) >> 16))
#define	loword(x)		((unsigned short)(x))

#define	hitword(x)		((unsigned long)((x) >> 8))

#define	totword(x)		(((unsigned long)(x) << 8))

/* Extract a byte from a short */
#define	hibyte(x)		((unsigned char)((x) >> 8))
#define	lobyte(x)		((unsigned char)(x))

#define	us(a)			((unsigned int)( ((unsigned long)(a)) * 1))// * ((unsigned long)/1000L) / 1000L ))

#define BIT0            (1<< 0)
#define BIT1            (1<< 1)
#define BIT2            (1<< 2)
#define BIT3            (1<< 3)
#define BIT4            (1<< 4)
#define BIT5            (1<< 5)
#define BIT6            (1<< 6)
#define BIT7            (1<< 7)
#define BIT8            (1<< 8)
#define BIT9            (1<< 9)
#define BIT10           (1<<10)
#define BIT11           (1<<11)
#define BIT12           (1<<12)
#define BIT13           (1<<13)
#define BIT14           (1<<14)
#define BIT15           (1<<15)
#define BIT16           (1<<16)
#define BIT17           (1<<17)
#define BIT18           (1<<18)
#define BIT19           (1<<19)
#define BIT20           (1<<20)
#define BIT21           (1<<21)
#define BIT22           (1<<22)
#define BIT23           (1<<23)
#define BIT24           (1<<24)
#define BIT25           (1<<25)
#define BIT26           (1<<26)
#define BIT27           (1<<27)
#define BIT28           (1<<28)
#define BIT29           (1<<29)
#define BIT30           (1<<30)
#define BIT31           (1<<31)

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

#define	SI				  TRUE
#define	NO				  FALSE

#define	TEMPO_FISSO	1000
#define	TICK_5S			5000

#define	RXOCCUPATI	0x01
#define	TXLIBERI		0x02

#define	MAXLENIBUF	256
#define	MAXLENOBUF	256
#define	MAXLENCMD		64
#define	MAXCIFRE		(6+1)
#define	MAXKEYNUM    80
#define	forever()		for(;;)

#define	__STX				0x02
#define	__ETX				0x03
#define	__EOT				0x04
#define	__ENQ				0x05
#define	__ACK				0x06
#define	__CR				0x0D
#define	__DC1				0x11
#define	__NAK				0x15
#define	__ESC				0x1B
#define __FS                0x1C
#define	__US				0x1F

#define 	SOH	0x01
#define 	STX	0x02
#define 	ETX	0x03
#define 	EOT	0x04
#define 	ENQ	0x05
#define 	ACK	0x06
#define 	DLE	0x10
#define 	NAK	0x15
#define 	SYN	0x16
#define 	ETB	0x17


#ifdef  __WIN32__
#define __disable_interrupt()
#define __enable_interrupt()
#else
#define	GetTickCount()	timeMs
#endif

#define 	UCB	    0x01
#define 	RSR903C	0x02


#endif

