#include  "def.h"
#if ENABLE_DISCOUNT
#include  <ctype.h>
#include  <string.h>
#include "def.h"
#include "ram.h"
#include "hwinit.h"
#include "funzioni.h"

unsigned short  sels[MAXTRAY][MAXCOLUMN]; // must br < 256 bytes ( a flash write cycle )

struct  _DISCOUNT_PAR_ {
    DWORD   day;                                    //  0...  3(4)
    byte    nDays[MAXTRAY][MAXCOLUMN];              //  4...103(1*10*10)
    byte    nSelections[MAXTRAY][MAXCOLUMN];        //104...203(1*10*10)
                                                    //204
} sDiscountPar;                         // must be < 256 bytes ( a flash write cycle )

WORD    sDiscountPar_enDiscount[MAXTRAY];       //  0... 19(2*10)

void            discount_reload( byte _mode );
void            discount( _Credito *tot, byte s_tray, byte s_column );
byte            discount_test( _Credito *_amount, byte s_tray, byte s_column );
DWORD           SinceBigBang( byte _gg, byte _me, word _an );




/*--------------------------------------------------------------------------
 | discount_eraseCounter:erase all discount counters
 |                              --------------
 | In:
 | Out: 
 +--------------------------------------------------------------------------*/

void            discount_eraseCounter( void )
{
    memset( sels,       0xFF, sizeof(sels)    );
    EraseBlock( (DWORD)0x0007D000, 1 );     // erase discount records
    discount_reload(1);
    memset( sDiscountPar_enDiscount, 0, sizeof(sDiscountPar_enDiscount) );
}                                               //  discount_eraseCounter




/*--------------------------------------------------------------------------
 | discount_doorClose:door close 
 |                              --------------
 | In:
 | Out: 0       updated discount information
 |      1       no changes on discounts
 +--------------------------------------------------------------------------*/

byte            discount_doorClose( void )
{

    if ( NonVolatileSetup.discountDoorClear == 0x71 && NonVolatileSetup.discountFlag != DISCOUNT_DISABLED )
    {
//        memset( &sDiscountPar, 0xFF, sizeof(sDiscountPar) );
//        memset( sDiscountPar_enDiscount, 0, sizeof(sDiscountPar_enDiscount) );
//        EraseBlock( (DWORD)0x0007D000, 1 );
//        sDiscountPar.day = SinceBigBang( dateTime.day, dateTime.month, dateTime.year );
//        WriteFlash256( (void *)&sDiscountPar, m, 0 );                   // 1ms
//        WriteFlash256( (void *)&sDiscountPar_enDiscount, m+256, 0 );    // 1ms
//        memcpy( (void *)sels, (void *)(m+512), sizeof(sels) );
        discount_eraseCounter();
        return 0;
    }
    return 1;
}                                               //  discount_doorClose

void            discount_reload( byte _mode )
{
    DWORD       m;
    
    m = (DWORD)0x0007D000;
    memcpy( (void *)&sDiscountPar, (void *) m,      sizeof( sDiscountPar ) );
    if ( _mode )
        memcpy( (void *)&sDiscountPar_enDiscount, (void *) (m+256),      sizeof( sDiscountPar_enDiscount ) );
}

/*
Discounts : when a selection is not sold for NonVolatileSetup.discountDays1 a discount if NonVolatileSetup.discountPerc1 is applied.
            When a selection is not sold for NonVolatileSetup.discountDays1 a discount if NonVolatileSetup.discountPerc2 is applied. 
            To disable the discount, the discounted selection has be sold at least NonVolatileSetup.discountDaysReset times.

            For each selection there are two counter :  
            - nDays : counting the number of days the selection was not sold
            - nSelections : counting the number of sales made with the selection discounted

            To prevent writing too many data to the flash ( given the finite endurance ), the counting is divided in two phases:
            - each day, for each selection, there is a "bit counter", where the number of bits at '0' gives the number of
              made sales. Ths counter starts at 0xFFFF, after one selection is 0xFFFE, two 0xFFFC. In this way the counter can
              be written in the flash memory without makin erase ( which impacts endurance and has a long execution time )
            - once a day ( when the day number changes ), the selection whose "bit counter" is still 0xFFFF have no sales and the nDays is
              updates. The selection where the "bit counter" has some '0' value, the zeroes are counter and, if needed, the nSelections updated.
              After these updates, the flash is erased ( "bit counter" reset ) and the new nDays, nSelections stored in flash.
              The flash record also the date of the last update.
            If, for some reason, the flash record is not updated for a few days, the update assumes that, for selection with no sales, nDays
            is updates by the number of days from previous update; 
            for the selection having some sales, the sale date must be the last update date, meaning thet na sales have been done for the day following the
            last update: nDays is updates by the number of days from the day following the previous update; 
IN          : *tot : pounter to actual selection price
              s_tray, s_column : selection tray, column

            tot = NULL: special condition, force selection discount conditions

OUT         : -

*/

void            discount( _Credito *tot, byte s_tray, byte s_column )
{
    DWORD         m, td, ran;
    byte          i, j, k, oldDisc;
    unsigned long daysLeft;
    unsigned short us;
    _Credito      MaxSconto;

    if( s_tray > MAXTRAY || s_column > MAXCOLUMN )
        return;
    
    if( NonVolatileSetup.discountFlag == DISCOUNT_DISABLED )    // discount disabled
        return;
    
    if( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )    // discount machine
    {
        s_tray = DISCOUNT_TRAY;
        s_column = DISCOUNT_COLUMN;
    }

   
    m = (DWORD)0x0007D000;
    discount_reload(0);
// DEBUG        memcpy( (void *)sels,          (void *)(m+256), sizeof(sels) );
    
                                        // verify if was discounted, to discount in any case even if recalculated
    oldDisc = discount_test( &MaxSconto, s_tray, s_column );//MaxSconto: non usato

                                        // calculate the days from previous update
    if ( sDiscountPar.day != 0xFFFFFFFF )
        daysLeft = SinceBigBang( dateTime.day, dateTime.month, dateTime.year ) - sDiscountPar.day;
    else                              // there is no previos record, reset the record file
        daysLeft = 0;
    if ( sDiscountPar.day == 0xFFFFFFFF || daysLeft != 0 || tot == NULL )
    {
        for ( i = 0; i < MAXTRAY; i++ )
        {
            for ( j = 0; j < MAXCOLUMN; j++ )
            {
                k = 0;
                us = sels[i][j];
                while( us != 0xFFFF )
                {
                    us = ( ( us >> 1 ) | 0x8000 );
                    k++;
                    if( sDiscountPar.nSelections[i][j] != 0x00 )
                        sDiscountPar.nSelections[i][j]--;
                }
                if( k != 0 )
                {           // selection has being sold
                    if( ( 0xFF-sDiscountPar.nDays[i][j]) >= NonVolatileSetup.discountDays1 )
                    {         // a discount will apply
                        if( (0xFF-sDiscountPar.nSelections[i][j]) >= NonVolatileSetup.discountDaysReset )
                        {       // and enought discounted selection made to reset the discount
                            sDiscountPar.nDays[i][j] = 0xFF;
                            sDiscountPar.nSelections[i][j] = 0xFF;
                        }       // count how many discounted selections made
                    }         // discount will not apply, clear the discounted sales counter
                    else
                    {
                        sDiscountPar.nDays[i][j] = 0xFF;
                        sDiscountPar.nSelections[i][j] = 0xFF;
                    }
                    k = ( daysLeft != 0 )?1:0;
                }
                

                if( ( daysLeft - k ) >= (unsigned long)sDiscountPar.nDays[i][j] )
                    sDiscountPar.nDays[i][j] = 0x00;
                else
                    sDiscountPar.nDays[i][j] = sDiscountPar.nDays[i][j] - ( daysLeft - k );
            }
        }
        
                                    // genera elenco possibili sconti (pseudocasuale)
        memset( sDiscountPar_enDiscount, 0, sizeof(sDiscountPar_enDiscount) );
        if( NonVolatileSetup.discountFlag == DISCOUNT_SELECTION )
        {
            ran = T0TC;
            td = NonVolatileSetup.discountMaxSel;
            for ( i = 0; i < MAXTRAY*MAXCOLUMN; i++ )
            {
                ran += 23;
                j = ran%(MAXTRAY*MAXCOLUMN);
                if( (0xFF-sDiscountPar.nDays[j/MAXCOLUMN][j%MAXCOLUMN]) >= NonVolatileSetup.discountDays1 &&
                    (0xFF-sDiscountPar.nSelections[j/MAXCOLUMN][j%MAXCOLUMN]) < NonVolatileSetup.discountDaysReset )
                {
                    if ( td <= 0 )
                        break;                            
                    sDiscountPar_enDiscount[j/MAXCOLUMN] |= (0x01<<(j%MAXCOLUMN));
                    if ( valid_discount_selection(j/MAXCOLUMN,j%MAXCOLUMN) )
                    {                   // se tutte le condizioni sono valide, ok per sconto
                        if ( --td <= 0 )
                            break;
                    }
                    else
                    {                   // altrimenti disabilita e ripeti
                        sDiscountPar_enDiscount[j/MAXCOLUMN] &= ~(0x01<<(j%MAXCOLUMN));
                    }
                }
            }
        }
        else
        {                           // sconto per tutta la macchina    
            if( (0xFF-sDiscountPar.nDays[s_tray][s_column]) >= NonVolatileSetup.discountDays1 &&
                (0xFF-sDiscountPar.nSelections[s_tray][s_column]) < NonVolatileSetup.discountDaysReset )
                    sDiscountPar_enDiscount[s_tray] |= (0x01<<(s_column));
        }
            
                                    // memorizza
        EraseBlock( m, 1 );                               // 400ms
      
        sDiscountPar.day = SinceBigBang( dateTime.day, dateTime.month, dateTime.year );
        WriteFlash256( (void *)&sDiscountPar, m, 0 );     // 1ms
        WriteFlash256( (void *)&sDiscountPar_enDiscount, m+256, 0 );     // 1ms
        memcpy( (void *)sels, (void *)(m+512), sizeof(sels) );
   }
   
   if ( tot == NULL )
       return;                          // update only selections map
   
    // count number of sales for this seletion made from previous flash update 
    // sels[s_tray][s_column] <<= 1;   COUNT ONLY EFFECTIVE SELECTIONS see discount_count
// DEBUG        WriteFlash256( (void *)sels, m+512, 0 );           // 1ms
    
    // update number of sales for this seletion made from previous flash update
    us = sels[s_tray][s_column];
    while( us != 0xFFFF )
    {
        us = ( ( us >> 1 ) | 0x8000 );
        sDiscountPar.nSelections[s_tray][s_column]--;
    }

    // check if discount applies, and make new price
    if ( oldDisc || discount_test( &MaxSconto, s_tray, s_column ) )// this test to prevent that a discounted item (seen on the display) was disabled by a day-change
    {
        if( ( 0xFF-sDiscountPar.nDays[s_tray][s_column]) >= NonVolatileSetup.discountDays1 )
        {
            if( (0xFF-sDiscountPar.nSelections[s_tray][s_column]) < NonVolatileSetup.discountDaysReset )
            {
                MaxSconto = ( *tot * 50 / 100 + 2 )/5*5;        // sconto limite 50%
                if( ( 0xFF-sDiscountPar.nDays[s_tray][s_column]) >= NonVolatileSetup.discountDays2 )
                    *tot = ( *tot * (100-NonVolatileSetup.discountPerc2)/100 + 2 )/5*5;
                else
                    *tot = ( *tot * (100-NonVolatileSetup.discountPerc1)/100 + 2 )/5*5;
                if( *tot < MaxSconto )
                    *tot = MaxSconto;
            }
            else
                sDiscountPar_enDiscount[s_tray] &= ~(0x01<<(s_column));
        }
        else
            sDiscountPar_enDiscount[s_tray] &= ~(0x01<<(s_column));
    }
}

void            discount_count( byte s_tray, byte s_column )
{
    if( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )    // discount machine
    {
        s_tray = DISCOUNT_TRAY;
        s_column = DISCOUNT_COLUMN;
    }
    
        // count number of sales for this seletion made from previous flash update 
    sels[s_tray][s_column] <<= 1;
    
    sDiscountPar.nSelections[s_tray][s_column]--;
    if ( (0xFF-sDiscountPar.nDays[s_tray][s_column]) <  NonVolatileSetup.discountDays1 ||
         (0xFF-sDiscountPar.nSelections[s_tray][s_column]) >= NonVolatileSetup.discountDaysReset )
        sDiscountPar_enDiscount[s_tray] &= ~(0x01<<(s_column));

// DEBUG        WriteFlash256( (void *)sels, m+512, 0 );           // 1ms
}

byte            discount_test( _Credito *tot, byte s_tray, byte s_column )
{
    _Credito    MaxSconto;

    if( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )    // discount machine
    {
        s_tray = DISCOUNT_TRAY;
        s_column = DISCOUNT_COLUMN;
    }
    
//    if( (0xFF-sDiscountPar.nDays[s_tray][s_column]) >= NonVolatileSetup.discountDays1 &&
//        (0xFF-sDiscountPar.nSelections[s_tray][s_column]) <= NonVolatileSetup.discountDaysReset )
    if ( sDiscountPar_enDiscount[s_tray] & (0x01<<s_column) )
    {
        MaxSconto = ( *tot * 50 / 100 + 2 )/5*5;        // sconto limite 50%
        if( ( 0xFF-sDiscountPar.nDays[s_tray][s_column]) >= NonVolatileSetup.discountDays2 )
            *tot = ( *tot * (100-NonVolatileSetup.discountPerc2)/100 + 2 )/5*5;
        else
            *tot = ( *tot * (100-NonVolatileSetup.discountPerc1)/100 + 2 )/5*5;
        if( *tot < MaxSconto )
            *tot = MaxSconto;
        
       return TRUE;
    }
    return FALSE;
}

#endif
