/***************************************************************************
 ************************                       ****************************
 ************************     G R A P H I C S   ****************************
 ************************                       ****************************
 ***************************************************************************/
#define	__GRAPHICS_C

#define GRAPHICS_DEBUG  0
#define LOAD_WAV    0
#define PLAY_WAV    0
#define USE_TOUCH   0

#define IMAGE_DELAY (NonVolatileSetup.slideDelay*1000)




#include	<stdio.h>
#include	<string.h>
#include	"def.h"
#include	"display.h"
#include	"funzioni.h"
#include	"graphics.h"
#include	"keyboard.h"
#include	"hwinit.h"
#include	"main.h"
#include    "messaggi.h"
#include    "menu.h"
#include    "mmc.h"
#include	"ram.h"
#include	"timer.h"
#include    "mmd.c"

#include	"uart.h"



DWORD           mmdTads;
DWORD           mmdDads;
byte            mmdIads, mmdIavi;
DWORD           mmdImageAddress;
#if USE_TOUCH
byte            mmdItch, touchOn;
#endif
DWORD           mmdTtch;
byte            pal_tab[256][4];//palette
#if 1
byte            linebuffer[2048+32];//buffer linea
byte            imgline[640*2];//buffer linea
#else
byte            linebuffer[640*3];//buffer linea
#endif

#define resetDispStatus()   sendSSP0((byte *)"\xFF",1)




/*--------------------------------------------------------------------------
 | mmdLoadProg: display program loaded
 |                              --------------
 | In:
 | Out: 0       program loaded
 |      1       display not present
 |      2       program not loaded
 +--------------------------------------------------------------------------*/

byte            mmdLoadProg( void )
{
//#ifdef CCQ
#ifdef RETRY
    byte        retry, before, ch;
#endif
    dword       i;

#ifdef RETRY
    for ( retry = 3; retry > 0; retry-- )
    {
    // reset display ????
    PINSEL3 = 0x0000C305;               // 00000000
    IO1CLR  = BIT24;
    Delay(1100);
    IO1SET  = BIT24;
    PINSEL3 = 0x0003C305;               // 00000000
    Delay( 300);
    //
#endif
    byte    dato;

///    sendSSP0( (byte *)&mmdProg[0], 1 );
///    recvSSP0( &before, 1 );
                                        // check display presence
//    for ( retry = 5; retry > 0; retry-- )
//    {
//        sendSSP0( "\x66", 1 );
//        recvSSP0( &ch, 1 );
//        if ( ch == 0x99 )
//            break;
//    }
//    if ( retry == 0 )
//        return 1;


    for ( i = 0; i < sizeof(mmdProg); i++ )
    {
        dato = ~mmdProg[i];
        sendSSP0( (byte *)&dato, 1 );
        //TBD
//        recvSSP0( &ch, 1 );
//        if ( ch != 0x99 )
//            return 2;
    }


#ifdef RETRY
    Delay( 700);

    }
#endif

    Delay(100);
    resetDispStatus();

///    recvSSP0( &ch, 1 );
///    if ( ch == before )
///        return 1;

//#endif
    return 0;
}                                               //  mmdLoadProg




/*--------------------------------------------------------------------------
 | mmdEraseMemory:
 |
 | Cycle I/O[15:8]  I/O7    I/O6    I/O5    I/O4    I/O3    I/O2    I/O1    I/O0
 | First    LOW     CA7     CA6     CA5     CA4     CA3     CA2     CA1     CA0
 | Second   LOW     LOW     LOW     LOW     LOW     LOW     CA101   CA9     CA8
 | Third    LOW     BA7     BA6     PA5     PA4     PA3     PA2     PA1     PA0
 | Fourth   LOW     BA15    BA14    BA13    BA12    BA11    BA10    BA9     BA8
 | Fifth    LOW     LOW     LOW     LOW     LOW     LOW     LOW     LOW     BA16
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            mmdEraseMemory( dword _startAddr, dword _size )
{
    byte        cmd[5];
    dword       i;

    i = _startAddr/2048;
    if ( i > 2048*64 )
        return 1;

    for ( _size = (_size+(64*2048-1))/(64*2048); _size > 0; _size--, i += 64 )
    {
        cmd[0] = ND_ERASE_SETUP;//erase setup
        cmd[1] = (byte)  i;
        cmd[2] = (byte) (i>> 8);
        cmd[3] = (byte)((i>>16)&0x01);
        cmd[4] = 0xD0;//erase confirm
        sendSSP0( (byte *)cmd, 5 );
#if 1
        Delay(3);
#else
        for ( j = 0; j < 5; j++ )
        {
            Delay(1);
            flushSSP0();
            cmd[0] = ND_FLASH_STATUS;//read status
            sendSSP0( (byte *)cmd, 1 );
            recvSSP0( (byte *)cmd, 1 );
            if ( (cmd[0] & BIT6) )
            {
                if ( (cmd[0] & BIT0) )
                    return 1;//erase fail
                break;
            }
        }
#endif
    }

    return 0;
}                                               //  mmdEraseMemory




/*--------------------------------------------------------------------------
 | mmdReadData:
 |                              --------------
 | In:
 | Out: byte    0   ok
 |              1   no images
 |              2   image not found
 +--------------------------------------------------------------------------*/

#define MAX_READ_SSP    32

byte            mmdReadData( DWORD _addr, WORD _off, byte *_p, byte _size )
{
    char        txbuf[8+MAX_READ_SSP], rxbuf[8+MAX_READ_SSP], cpbuf[8+MAX_READ_SSP], retry;
    dword       page;

    if ( _size > MAX_READ_SSP )
        _size = MAX_READ_SSP;

    flushSSP0();

    page = _addr/2048;
    memset( txbuf, 0xFF, sizeof(txbuf) );
    txbuf[ 0] = ND_FLASH_READ;//page read 
    txbuf[ 1] = (byte)  _off;
    txbuf[ 2] = (byte) (_off>>8);
    txbuf[ 3] = (byte)  page;
    txbuf[ 4] = (byte) (page>> 8);
    txbuf[ 5] = (byte)((page>>16)&0x01);
    txbuf[ 6] = 0x30;
    for ( retry = 5; retry > 0; retry-- )
    {
        memset( rxbuf, 1, sizeof(rxbuf) );
        memset( cpbuf, 2, sizeof(cpbuf) );
        sendRecvSSP0( (byte *)txbuf, (byte *)rxbuf, 8+_size );
        Delay(3);
        sendRecvSSP0( (byte *)txbuf, (byte *)cpbuf, 8+_size );
        Delay(3);
        if ( memcmp(&rxbuf[8],&cpbuf[8],_size) == 0 )
            break;
    }
    if ( retry == 0 )
        return 1;

    if ( _p != NULL )
        memcpy( _p, &rxbuf[8], _size );

    return 0;
}                                               //  mmdReadData




/*--------------------------------------------------------------------------
 | mmdReadHeader:
 |                              --------------
 | In:
 | Out: byte    0   ok
 |              1   no images
 |              2   image not found
 +--------------------------------------------------------------------------*/

byte            mmdReadHeader( DWORD _addr, byte *_p )
{
#if 1
    flushSSP0();
    if ( mmdReadData( _addr, 0, _p, sizeof(disp_header) ) == 1 )
        return 1;
    if ( _p[0] != 0x50 || _p[1] != 0x51 || _p[2] != 0x52 || _p[3] != 0x53 )
        return 2;
    return 0;
#else
    char        i;

    flushSSP0();
//    txbuf[ 0] = 0xFF;//page read 
//    sendSSP0( (byte *)txbuf, 1 );
//    Delay(1);

    for ( i = 0; i < sizeof(disp_header)-4; i += 4 )
    {
        if ( mmdReadData( _addr, i/2, _p ) == 1 )
            return 1;
        if ( i == 0 && (_p[0]!=0x50||_p[1]!=0x51||_p[2]!=0x52||_p[3]!=0x53) )
            return 2;
        _p += 4;        
    }

    return 0;
#endif
}                                               //  mmdReadHeader




/*--------------------------------------------------------------------------
 | mmdCopyFlashToRam:
 |                              --------------
 | In:
 | Out: byte    0   ok
 |              1   no images
 |              2   image not found
 +--------------------------------------------------------------------------*/

byte            mmdCopyFlashToRam( DWORD _addr )
{
    char        buf[4];
    dword       page;

    if ( _addr == mmdImageAddress )
        return 0;

    Delay(1);
    page = _addr/2048;
    buf[0] = ND_COPY_FLASH2RAM;
    buf[1] = (byte)  page;
    buf[2] = (byte) (page>> 8);
    buf[3] = (byte)((page>>16)&0x01);
    sendSSP0( (byte *)buf, 4 );
    Delay(1);

    mmdImageAddress = _addr;

    return 0;
}                                               //  mmdCopyFlashToRam




/*--------------------------------------------------------------------------
 | mmdSearchImage:search an image in the display memory
 |                              --------------
 | In:
 | Out: byte    0   ok
 |              1   no image
 |              2   out of memory
 +--------------------------------------------------------------------------*/

byte            mmdSearchImage( byte _s_tray, byte _s_column, byte _show, dword *_addr )
{
    byte        resp;
    disp_header info;
    dword       startImageOffset;

    startImageOffset = 0*512*2048;
    do {
        memset( &info, 0xFF, sizeof(info) );
        resp = mmdReadHeader( startImageOffset, (byte *)&info );
#if GRAPHICS_DEBUG
        commPutChar( COMM1, 0x66 );
        commPutChar( COMM1, (byte)(startImageOffset>>24) );
        commPutChar( COMM1, (byte)(startImageOffset>>16) );
        commPutChar( COMM1, (byte)(startImageOffset>> 8) );
        commPutChar( COMM1, (byte)(startImageOffset    ) );
        commPutChar( COMM1, (byte)info.header[ 0] );
        commPutChar( COMM1, (byte)info.header[ 1] );
        commPutChar( COMM1, (byte)info.header[ 2] );
        commPutChar( COMM1, (byte)info.header[ 3] );
        commPutChar( COMM1, (byte)info.filename[ 0] );
        commPutChar( COMM1, (byte)info.filename[ 1] );
        commPutChar( COMM1, (byte)info.filename[ 2] );
        commPutChar( COMM1, (byte)info.filename[ 3] );
        commPutChar( COMM1, (byte)info.tray );
        commPutChar( COMM1, (byte)info.column );
        commPutChar( COMM1, 0x0D );
        Delay(16);
#endif        
        if ( resp == 0 )
        {            
            if ( info.tray == 0xFF && info.column == 0xFF )
            {
                if ( _addr != NULL )
                    *_addr = startImageOffset;
                return 1;
            }
            if ( info.tray == _s_tray && info.column == _s_column )
                break;
        }
        else if ( resp == 2 )
        {
            if ( info.header[0] == 0xFF && info.header[1] == 0xFF && 
                 info.header[2] == 0xFF && info.header[3] == 0xFF )
                break;
        }
        startImageOffset += 512*2048;
        if ( startImageOffset >= 2048L*(64*2048L) )
            return 2;
    } while ( -1 );
    if ( _show )
    {
        mmdCopyFlashToRam( startImageOffset+2048 );
        mmdDads = info.delay;
        mmdTads = GetTickCount();
    }
    if ( _addr != NULL )
        *_addr = startImageOffset;
    return 0;
}                                               //  mmdSearchImage




/*--------------------------------------------------------------------------
 | mmdEraseOneImage:erase images on MMD
 |
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            mmdEraseOneImage( dword _offset )
{
    DispStr( 0, 0, (char *)MSG_ATTESA );
    mmdEraseMemory( _offset, 2048*(480+1) );
    memset( &imageLib,   0,      sizeof(imageLib)    );
    mmdImageLibBuild();
    return 0;
}                                               //  mmdEraseOneImage




/*--------------------------------------------------------------------------
 | mmdEraseImages:erase images on MMD
 |
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            mmdEraseImages( byte _superUser )
{
    DispStr( 0, 0, (char *)MSG_ATTESA );
    mmdEraseMemory( 0, 2048*(2048*64) );           // erase flash
//EEE    mmdTestBadBlocks();
    memset( &imageLib,   0,      sizeof(imageLib)    );
#if 0
////
    {
    byte    data[8];
    dword   startImageOffset, page, i;
    
    i = 0;
    for ( startImageOffset = 0; startImageOffset < 2048L*(64L*2048L); startImageOffset += 2048L*512L )
    {
        memcpy ( linebuffer, &rawData[i++][0], 12 );

        Delay(5);
        page = startImageOffset/2048;
        data[0] = 0x00;
        data[1] = 0x00;
        data[2] = (byte)  page;
        data[3] = (byte) (page>> 8);
        data[4] = (byte)((page>>16)&0x01);

        sendSSP0( (byte *)"\x80", 1 );
        sendSSP0( (byte *)&data[0], 5 );
        sendSSP0( (byte *)linebuffer, 640*2/*2112*/ );
        sendSSP0( (byte *)"\x10", 1 );
        Delay(50);
    }
    }
////
#endif
    return 0;
}                                               //  mmdEraseImages




byte            bin2hex( byte *_dest, word _val, byte _len )
{
    while ( _len-- > 0 )
    {
        *_dest++ = "0123456789ABCDEF"[((_val>>(_len*4))&0xF)];
    }
    *_dest = '\0';

    return 0;
}

byte            sendHexData( byte *_p, byte _len, word _offset, byte _rectype, byte *_data )
{
    byte        *p, checksum, len;
    
    p = _p;
    checksum = 0x00;
    *p++ = ':';                         //record mark
    checksum += _len;
    bin2hex( p, _len, 2 );              //reclen
    p += 2;
    checksum += (byte)(_offset>>8);
    checksum += (byte)(_offset   );
    bin2hex( p, _offset, 4 );           //offset
    p += 4;
    checksum += _rectype;
    bin2hex( p, _rectype, 2 );          //rectype
    p += 2;
    while ( _len-- > 0 )
    {
        checksum += *_data;
        bin2hex( p, *_data++, 2 );      //ulba
        p += 2;
    }
    bin2hex( p, (byte)(0-checksum), 2 );          //checksum
    p += 2;
    *p++ = 0x0D;
    *p++ = 0x0A;
    *p = '\0';

    len = (byte)(p-_p);


    sendSSP0( (byte *)_p, len );


    return 0;
}

#define bmp_hdr ((bmp_fileheader_type *)data)
#define bmp_inf ((bmp_infoheader_type *)data)

#if LOAD_WAV
#define DATA_LINE   525
#define DATA_START  1
#else
#define DATA_LINE   480
#define DATA_START  480
#endif

byte            mmdLoadImages( byte _superUser )
{
#if 0
    sword       j, r;
#endif
    byte        retry, tray, column, imagesLoaded, *pB, *pW;
    byte        data[128], fname[32];
	uint32_t    pstart, psize, pos, size, dimX, dimY, pal_size;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;
    word        n, dataw, oldperc, perc;
    sword       h, w;
    uint32_t    successcount;
    dword       startImageOffset, addr, page;
    dword       dataCrc, flashCrc, flashData;
    disp_header *pDispHeader;

    memset( linebuffer, 0, sizeof(linebuffer) );
    DispStr( 0, 0, (char *)MSG_ATTESA );
    if ( mmcInit() != mmc_noerr )
    {
		DispStr( 0, 0, " NO MMC/SD FOUND" );
        return 2;
    }

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff )
    {
		DispStr( 0, 0, " PARTITION ERROR" );
		return 3;
	}

	if ( DFS_GetVolInfo(0, sector, pstart, &vi) )
    {
		DispStr( 0, 0, " VOLUME ERROR   " );
		return 4;
	}

    imagesLoaded = 0;
    startImageOffset = 0*512*2048;
    for ( n = 0; n <= (MMDTOTALBMP+MMDTOTALADS+MMDTOTALTCH); n++ )
    {
        if ( makeBMPfileName(n,&tray,&column,data) != 0 )
            continue;

        if ( DFS_OpenFile(&vi, data, DFS_READ, sector, &fi) != 0 )
            continue;
        pos = 0;

        strcpy ( (char *)fname, (char *)data );
        DispStr( 0, 0, (char *)fname );
#if LOAD_WAV
#else
        ////////////////////////////////////////////
        // image found
                                        // read file header and check file type
        successcount = sizeof(bmp_fileheader_type);
        if ( dosfs_getbFile( &fi, &pos, sector, data, &successcount ) != 0 )
            continue;//invalid
        if ( bmp_hdr->bfType[0] != 'B' || bmp_hdr->bfType[1] != 'M' )
            continue;
                                        // read info header and calculate size
        successcount = sizeof(bmp_infoheader_type);
        if ( dosfs_getbFile( &fi, &pos, sector, data, &successcount ) != 0 )
            continue;//invalid

        size     = bmp_inf->biSizeHH *0x1000000L+bmp_inf->biSizeHL *0x10000L+bmp_inf->biSizeLH *0x100L+bmp_inf->biSizeLL;
        if ( size != 40 || bmp_inf->biCompression != 0 )
            continue;//wrong file format

        pal_size = bmp_inf->biBitCountH*0x100+bmp_inf->biBitCountL;
        if ( pal_size != 24 && pal_size != 8 )
            continue;//wrong pal size
        dimX     = bmp_inf->biWidthHH *0x1000000L+bmp_inf->biWidthHL *0x10000L+bmp_inf->biWidthLH *0x100L+bmp_inf->biWidthLL;
        dimY     = bmp_inf->biHeightHH*0x1000000L+bmp_inf->biHeightHL*0x10000L+bmp_inf->biHeightLH*0x100L+bmp_inf->biHeightLL;
        if ( (dimX != 320 && dimY != 240) && (dimX != 640 && dimY != 480) )
            continue;//wrong image size

//        sprintf( (char *)data, "%d %d %d %ld ", dimX, dimY, pal_size, size );
//        DispStr( 0, 0, (char *)data );

        if ( dimX != 640 || dimY != 480 || pal_size != 24 )
        {
            sprintf( (char *)data, "%d %d %d %ld ", dimX, dimY, pal_size, size );
            DispStr( 0, 0, (char *)data );
            Delay(500);
            continue;//wrong image size, solo immagini 640x480 full color   
        }

        if ( pal_size == 24 )
            size = (dimX*3);//*dimY;
        else
        {
            successcount = sizeof(pal_tab);
            if ( dosfs_getbFile( &fi, &pos, sector, (uint8_t *)&pal_tab[0][0], &successcount ) != 0 )
                continue;//invalid
            size =  dimX   ;//*dimY;
        }
#endif

        for ( retry = 5; retry > 0; retry-- )
        {
            switch ( mmdSearchImage(tray,column,0,&addr) )
            {
                case 0: startImageOffset = addr;    break;      // image found
                case 1: startImageOffset = addr;    break;      // image not found
                default:                            continue;      // out of memory
            }
            mmdEraseMemory( startImageOffset, 2048*(DATA_LINE+1) );           // erase flash

            dataCrc = 0;
            oldperc = perc = 0;
            page = DATA_START+startImageOffset/2048;
            for ( h = 0; h < DATA_LINE; h++ )
            {
                perc = (100*h/DATA_LINE);
                if ( oldperc != perc )
                {
                    oldperc = perc;
                    sprintf( (char *)data, "%-11.11s %3d%%" , fname, perc );
                    DispStr( 0, 0, (char *)data );
                }

#if LOAD_WAV
                successcount = 640*2;        // read a dot line
                if ( dosfs_getbFile( &fi, &pos, sector, linebuffer, &successcount ) != 0 )
                    break;//invalid
#else
                successcount = 640*3;        // read a dot line
                if ( dosfs_getbFile( &fi, &pos, sector, linebuffer, &successcount ) != 0 )
                    break;//invalid
                pB = &linebuffer[0];
                pW = &linebuffer[0];
                for ( w = 0; w < 640; w++ )
                {
                    dataw = (((word)(*(pB+0)&0xF8))<<8) + (((word)(*(pB+1)&0xFC))<<3) + (((word)(*(pB+2)&0xF8))>> 3);
                    if ( dataw == 0 )
                        dataw = 1;
                    *pW++ = (byte)(dataw>>8);
                    *pW++ = (byte)(dataw   ); 
                    pB += 3;
                }
#endif

#if 1
                Delay(1);
#else
                for ( f = 0; f < 5; f++ )
                {
                    flushSSP0();
                    data[64] = ND_FLASH_STATUS;//read status
                    sendSSP0( (byte *)&data[64], 1 );
                    recvSSP0( (byte *)&data[64], 1 );
                    if ( (data[64] & BIT6) )
                    {// ready
                        if ( (data[64] & BIT0) )
                            break;//program page fail
                        break;
                    }
                    Delay(1);
                }
#endif
                data[64] = 0x00;
                data[65] = 0x00;
                data[66] = (byte)  page;
                data[67] = (byte) (page>> 8);
                data[68] = (byte)((page>>16)&0x01);
#if LOAD_WAV
                page++;
#else
                page--;
#endif
    
                sendSSP0( (byte *)"\x80", 1 );
                sendSSP0( (byte *)&data[64], 5 );
                sendSSP0( (byte *)linebuffer, 640*2/*2112*/ );
                sendSSP0( (byte *)"\x10", 1 );
                
                dataCrc += *((dword *)linebuffer);
            }        

            // write bitmap header
            Delay(5);
            page = startImageOffset/2048;
            data[64] = 0x00;
            data[65] = 0x00;
            data[66] = (byte)  page;
            data[67] = (byte) (page>> 8);
            data[68] = (byte)((page>>16)&0x01);
    
            pDispHeader = (disp_header *)&linebuffer[ 0];
            memset( linebuffer, 0, sizeof(linebuffer) );
            memcpy( &pDispHeader->header[ 0], "\x50\x51\x52\x53", 4 );
            pDispHeader->tray = tray;
            pDispHeader->column = column;
            pDispHeader->delay = 10000;
            memcpy( &pDispHeader->filename[ 0], fname, 12 );
            pDispHeader->dimX = dimX;
            pDispHeader->dimY = dimY;
            pDispHeader->palSize = pal_size;
    
            sendSSP0( (byte *)"\x80", 1 );
            sendSSP0( (byte *)&data[64], 5 );
            sendSSP0( (byte *)linebuffer, 640*2/*2112*/ );
            sendSSP0( (byte *)"\x10", 1 );
            dataCrc += *((dword *)linebuffer);
            Delay(5);
            //

                                        /////////////////////////////////////
                                        // verify write
            flashCrc = 0;
            for ( h = DATA_LINE; h >= 0; h-- )
            {
                if ( mmdReadData( startImageOffset+(h*2048), 0, (byte *)&flashData, 4 ) != 0 )
                    break;
                flashCrc += flashData;
            }
            resetDispStatus();
            if ( flashCrc == dataCrc )
                break;

                                        // sector wrong CRC, mark as invalid
            memset( linebuffer, 0, sizeof(linebuffer) );
            sendSSP0( (byte *)"\x80", 1 );
            sendSSP0( (byte *)&data[64], 5 );
            sendSSP0( (byte *)linebuffer, 640*2/*2112*/ );
            sendSSP0( (byte *)"\x10", 1 );
                                        // go to next segment
            startImageOffset += 2048*480;
            startImageOffset = (startImageOffset+0x1FFFF)&0xFFFE0000;// segment align
                                        // restart loading
            pos = 0;
            DFS_OpenFile( &vi, fname, DFS_READ, sector, &fi );
            successcount = sizeof(bmp_fileheader_type);
            dosfs_getbFile( &fi, &pos, sector, data, &successcount );
            successcount = sizeof(bmp_infoheader_type);
            dosfs_getbFile( &fi, &pos, sector, data, &successcount );
        }

        
#if GRAPHICS_DEBUG
        commPutChar( COMM1, 0xAA );
        commPutChar( COMM1, (byte)(startImageOffset>>24) );
        commPutChar( COMM1, (byte)(startImageOffset>>16) );
        commPutChar( COMM1, (byte)(startImageOffset>> 8) );
        commPutChar( COMM1, (byte)(startImageOffset    ) );
        commPutChar( COMM1, (byte)pDispHeader->header[ 0] );
        commPutChar( COMM1, (byte)pDispHeader->header[ 1] );
        commPutChar( COMM1, (byte)pDispHeader->header[ 2] );
        commPutChar( COMM1, (byte)pDispHeader->header[ 3] );
        commPutChar( COMM1, (byte)pDispHeader->filename[ 0] );
        commPutChar( COMM1, (byte)pDispHeader->filename[ 1] );
        commPutChar( COMM1, (byte)pDispHeader->filename[ 2] );
        commPutChar( COMM1, (byte)pDispHeader->filename[ 3] );
        commPutChar( COMM1, (byte)pDispHeader->tray );
        commPutChar( COMM1, (byte)pDispHeader->column );
        commPutChar( COMM1, 0x0D );
        Delay(16);
#endif        
//        sprintf( (char *)data, "%ld %d ", imageOffset, pages );
//        DispStr( 0, 0, (char *)data );
        DispStr( 0, 0, (char *)MSG_ATTESA );

        // memorizza offset immagine ed id
        imagesLoaded++;

        startImageOffset += 2048*480;
        startImageOffset = (startImageOffset+0x1FFFF)&0xFFFE0000;// segment align
    }
    if ( imagesLoaded == 0 )
        DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );// no images
    else
        mmdImageLibBuild();

    return 0;
}                                               //  mmdLoadImages


/*--------------------------------------------------------------------------
 | mmdRestartAds:restart advertising images
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            mmdRestartAds( void )
{
    mmdTads = GetTickCount();
    mmdDads = 10000;
    mmdIads = 0;
    mmdIavi = 0;
    mmdImageAddress = 0xFFFFFFFF;
}                                               //  mmdRestartAds




/*--------------------------------------------------------------------------
 | mmdShowAds:  show advertising messages
 |                              --------------
 | In:
 | Out: byte    0   image showed
 |              1   no images
 |              2   wait timeout
 |              3   no image
 +--------------------------------------------------------------------------*/

void            mmdTestTouch( void )
{
    char        txbuf[15], rxbuf[15];
#if USE_TOUCH
    char        cnt;
#endif

    if ( mmdStatus != 0 )
        return;                         // display and mmc not available
    
    if ( (GetTickCount()-mmdTtch) < 100 )
        return;
    mmdTtch = GetTickCount();


    flushSSP0();

    txbuf[ 0] = ND_STATUS_RESET;
    txbuf[ 1] = ND_STATUS_RESET;
    sendRecvSSP0( (byte *)txbuf, (byte *)rxbuf, 2 );
                                        // check if tilt sensor activated
    if ( (rxbuf[1] & 0x20) )
    {
        if ( enMMC_MMD(0) == 0 && mmdPhotoErr < 5 && NonVolatileSetup.sensitivity != 0 )
        {
            if ( saveMMCphoto() != 0 )
                mmdPhotoErr++;
            else
                mmdPhotoErr = 0;
            if ( doorOpen() )
                mmdPhotoErr = 5;            // if door open, capture only the first image than stop
            Delay(100);
        }
        clearPhoto();
        Delay(100);
    }
                                        // check if touch panel pressed
#if USE_TOUCH
    if ( (rxbuf[1] & 0x40) )
    {
        if ( touchOn == 0 )
        {
            touchOn++;
            mmdItch++;
            for ( cnt = 0; cnt < imageLib.cnt; cnt++ )
            {
                if ( imageLib.info[cnt].tray == MMDTOUCHBMP && imageLib.info[cnt].column == mmdItch )
                {
                    mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[cnt].startPage) );
                    mmdDads = 5000;
                    mmdTads = GetTickCount();
                    return;
                }
            }
            if ( cnt == imageLib.cnt )
            {
                if ( imageLib.logo != 0 )
                    mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[imageLib.logo-1].startPage) );
                mmdItch = 0;
            }
        }
    }
    else
    {
        if ( touchOn > 0 )
            touchOn--;
    }
#endif
}



byte            mmdPlayAvi( void )
{
    byte        cnt;
//    dword       startImageOffset;

    if ( mmdIavi == 0 && (GetTickCount()-mmdTads) < mmdDads/*5000*//*2*mmdDads*/ ) //20s
    {
        mmdTestTouch();
        return 2;// show logo
    }

    if ( (GetTickCount()-mmdTads) < mmdDads )
    {
        mmdTestTouch();
        return 0/*2*/;
    }

    if ( mmdIavi > MMDTOTALAVI )
    {
        mmdIavi = 0;
        mmdDads = 5000;
        if ( imageLib.logo != 0 )
            mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[imageLib.logo-1].startPage) );
        return 2;// show logo
    }

    if ( mmdIavi < 1 )
    {
#if PLAY_WAV
        startImageOffset = 0*512*2048;
        startImageOffset += (182 - 1)*0x100000L;
        mmdCopyFlashToRam( startImageOffset );
        mmdIavi = 1;
        Delay(100);// play WAV
#else
        mmdIavi = 1;
#endif
    }
/*    
    startImageOffset = 0*512*2048+2048;
    startImageOffset += (mmdIavi++ - 1)*0x100000L;

    mmdCopyFlashToRam( startImageOffset );
    mmdDads = 88;//68;//ms
    mmdTads = GetTickCount();
*/

    mmdIavi++;
    for ( cnt = 0; cnt < imageLib.cnt; cnt++ )
    {
        if ( imageLib.info[cnt].tray == MMDTRAYAVI && imageLib.info[cnt].column == (mmdIavi-1) )
        {
            mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[cnt].startPage) );
            mmdDads = 88;
            mmdTads = GetTickCount();
#if USE_TOUCH
            mmdItch = 0;
#endif
            return 0;
        }
    }

    return 0;
}


byte            mmdShowAds( void )
{
#if 0
                                        // wait timeout
    if ( (GetTickCount()-mmdTads) < mmdDads )
        return 2;
                                        //
    if ( mmdIads >= MMDTOTALADS )
        mmdIads = 0;
    if ( mmdSearchImage(MMDTRAYADS,mmdIads++,1,NULL) == 0 )
    {
        mmdDads = 50;//imageLib.info[cnt].delay;
        return 0;
    }

    mmdIads = 0;
    mmdTads = GetTickCount();
    mmdDads = 10000;//10s
    if ( mmdSearchImage(MMDTRAYLOG,0,1,NULL) == 0 )
        return 0;
    if ( imageLib.logo != 0 )
        mmdCopyFlashToRam( imageLib.info[imageLib.logo-1].offset );
    return 0;
#else
    byte        cnt, resp;

    if ( copyMMCphoto() )
        return 0;
    

    if ( NonVolatileSetup.animationMovie == 0x68 && mmdPlayAvi() == 0 )
        return 0;


    if ( imageLib.cnt == 0 )
    {
        mmdTestTouch();
        mmdCopyFlashToRam( 0 );
        return 0;
    }

    if ( imageLib.cnt > MAXIMAGES )
        return 1;// maybe 0xFF, no images loaded

    mmdTestTouch();
    if ( (GetTickCount()-mmdTads) < mmdDads )
        return 2;

    resp = 3;
    for ( cnt = 0; cnt < imageLib.cnt; cnt++ )
    {
        if ( imageLib.info[cnt].tray == MMDTRAYADS && mmdIads == imageLib.info[cnt].column )
        {
            mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[cnt].startPage) );
            mmdDads = IMAGE_DELAY;//50;//imageLib.info[cnt].delay;
            mmdTads = GetTickCount();
            resp = 0;
        }
    }
                                        // show logo if no other images available
    if ( resp == 3 && mmdIads == 0 && imageLib.logo != 0 )
        mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[imageLib.logo-1].startPage) );

    mmdIads += 1;                       // next image
    if ( mmdIads > MMDTOTALADS )
        mmdIads = 0;
    
    return resp;
#endif
}                                               //  mmdShowAds




void            mmdImageLibBuild( void )
{
//#ifdef CCQ
    byte        cnt, resp;
    disp_header info;
    dword       startImageOffset;
    char        txbuf[4], rxbuf[4], retry;

#if USE_TOUCH
    mmdItch = 0;
#endif
    mmdTtch = 0;
    
    Delay(100);
    flushSSP0();
    resetDispStatus();
    Delay(100);
////
    for ( retry = 10; retry > 0; retry-- )
    {
        flushSSP0();
        txbuf[ 0] = ND_STATUS_RESET;
        txbuf[ 1] = ND_STATUS_RESET;
        rxbuf[ 0] = ND_STATUS_RESET;
        rxbuf[ 1] = ND_STATUS_RESET;
        sendRecvSSP0( (byte *)txbuf, (byte *)rxbuf, 2 );
        if ( rxbuf[1] != 0xFF )
            break;
    }
    if ( retry == 0 )
    {
        mmdStatus = 1;                  // display not available
        return;
    }
////    

    setSensitivity();
    Delay(100);

    
#if GRAPHICS_DEBUG
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
#endif
    startImageOffset = 0*512*2048;
    do {
        memset( &info, 0xFF, sizeof(info) );
        resp = mmdReadHeader( startImageOffset, (byte *)&info );
#if GRAPHICS_DEBUG
        commPutChar( COMM1, 0x55 );
        commPutChar( COMM1, (byte)(startImageOffset>>24) );
        commPutChar( COMM1, (byte)(startImageOffset>>16) );
        commPutChar( COMM1, (byte)(startImageOffset>> 8) );
        commPutChar( COMM1, (byte)(startImageOffset    ) );
        commPutChar( COMM1, (byte)info.header[ 0] );
        commPutChar( COMM1, (byte)info.header[ 1] );
        commPutChar( COMM1, (byte)info.header[ 2] );
        commPutChar( COMM1, (byte)info.header[ 3] );
        commPutChar( COMM1, (byte)info.filename[ 0] );
        commPutChar( COMM1, (byte)info.filename[ 1] );
        commPutChar( COMM1, (byte)info.filename[ 2] );
        commPutChar( COMM1, (byte)info.filename[ 3] );
        commPutChar( COMM1, (byte)info.tray );
        commPutChar( COMM1, (byte)info.column );
        commPutChar( COMM1, 0x0D );
        Delay(16);
#endif
        if ( resp == 0 && (info.tray != 0xFF || info.column != 0xFF) )
        {
            resp = FALSE;
            for ( cnt = 0; cnt < imageLib.cnt; cnt++ )
            {                               // search and substitute with new data
                if ( imageLib.info[cnt].tray == info.tray && imageLib.info[cnt].column == info.column )
                {
                    //imageLib.info[cnt].delay = info.delay;
                    imageLib.info[cnt].startPage = ADDR2PAGE(startImageOffset);
                    resp = TRUE;
                    break;
                }
            }
            if ( imageLib.cnt == 0xFF )
                imageLib.cnt = 0;
            if ( resp == FALSE && imageLib.cnt < MAXIMAGES && (info.tray <= MMDTRAYLOG || info.tray == MMDTRAYAVI || info.tray == MMDTOUCHBMP) )
            {                               // no data, add to the structure
                imageLib.info[imageLib.cnt].tray = info.tray;
                imageLib.info[imageLib.cnt].column = info.column;
                imageLib.info[imageLib.cnt].startPage = ADDR2PAGE(startImageOffset);
                //imageLib.info[imageLib.cnt].delay = info.delay;
                if ( imageLib.info[imageLib.cnt].tray == MMDTRAYLOG )
                {
                    resetDispStatus();
                    Delay(80);
                    imageLib.logo = imageLib.cnt+1;
                    mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[imageLib.logo-1].startPage) );
                    Delay(80);//wait command to complete
                }
                imageLib.cnt++;
            }
        }

        startImageOffset += 512*2048;
    } while ( startImageOffset < 2048L*(64*2048L) );
    
//    if ( imageLib.logo != 0 )
//        mmdCopyFlashToRam( PAGE2ADDR(imageLib.info[imageLib.logo-1].startPage) );
//#endif

    return;
}                                               //  mmdImageLibBuild




/*--------------------------------------------------------------------------
 | mmdTestBadBlocks:
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            mmdTestBadBlocks( void )
{
    char        txbuf[15], rxbuf[15];
    DWORD       addr, page, bad, good;

    flushSSP0();

    bad = 0;
    good = 0;
    for ( addr = 0; addr < 2048*(2048*64); addr += 0x20000L )
    {
        page = addr/2048;
        txbuf[ 0] = ND_FLASH_READ;      //page read 
        txbuf[ 1] = 0x00;   ////
        txbuf[ 2] = 0x00;
        txbuf[ 3] = (byte)  page;
        txbuf[ 4] = (byte) (page>> 8);
        txbuf[ 5] = (byte)((page>>16)&0x01);
        txbuf[ 6] = 0x30;
        txbuf[ 7] = 0xFF;
        txbuf[ 8] = 0xFF;
        txbuf[ 9] = 0xFF;
        txbuf[10] = 0xFF;
        txbuf[11] = 0xFF;
        txbuf[12] = 0xFF;
        memset( rxbuf, 1, sizeof(rxbuf) );
        sendRecvSSP0( (byte *)txbuf, (byte *)rxbuf, 12 );
        Delay(3);

        if ( rxbuf[ 8] != 0xFF || rxbuf[9] != 0xFF || rxbuf[10] != 0xFF || rxbuf[11] != 0xFF )
            bad++;
        else
            good++;
    }
    
    sprintf( txbuf, "OK=%4d KO=%3d ", good, bad ); 
    DispStr( 0, 0, (char *)txbuf );
    Delay(2000);

    return 0;
}                                               //  mmdTestBadBlocks




/*--------------------------------------------------------------------------
 | setSensitivity:
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

const byte      sensitivityLevel[] =
{
    60,                                 // off
    30,                                 // low sensitivity
    20,                                 // medium
    10                                  // high
};

byte            setSensitivity( void )
{
    byte        txbuf[8];

    txbuf[ 0] = ND_SET_SENSITIVITY;
    if ( NonVolatileSetup.sensitivity <= 3 )
        txbuf[ 1] = sensitivityLevel[NonVolatileSetup.sensitivity];
    else
        txbuf[ 1] = sensitivityLevel[0];
    txbuf[ 2] = OFFSET_PHOTO;
    sendSSP0( (byte *)txbuf, 3);
    
    return 0;
}                                               //  setSensitivity
