/***************************************************************************
 ************************						****************************
 ************************		G R A P H I C S	****************************
 ************************						****************************
 ***************************************************************************/
#ifndef	__GRAPHICS_H
#define	__GRAPHICS_H




#include	"def.h"




//	Win 3.x BMP data structures

typedef struct
{
    byte        rgbBlue;
    byte        rgbGreen;
    byte        rgbRed;
    byte        rgbReserved;
}
bmp_rgbquad_type;

typedef	struct	{
			byte        bfType[2];
			byte        biSizeLL,biSizeLH,biSizeHL,biSizeHH;
			word        bfReserved1;
			word        bfReserved2;
			byte        bfOffBitsLL,bfOffBitsLH,bfOffBitsHL,bfOffBitsHH;
		}	bmp_fileheader_type;

typedef	struct	{
			byte        biSizeLL,biSizeLH,biSizeHL,biSizeHH;
			byte        biWidthLL, biWidthLH, biWidthHL, biWidthHH;
			byte        biHeightLL,biHeightLH,biHeightHL,biHeightHH;
			byte        biPlanesL, biPlanesH;
			byte        biBitCountL,biBitCountH;
			long        biCompression;
			byte        biSizeImageLL,biSizeImageLH,biSizeImageHL,biSizeImageHH;
			long        biXpelsPerMeter;
			long        biYpelsPerMeter;
			dword       biClrUsed;
			dword       biClrImportant;
		}	bmp_infoheader_type;

typedef struct  {
            byte        header[4];
            byte        tray, column;
            word        delay;
            char        filename[8+1+3];
            word        dimX, dimY, palSize;
        } disp_header;

enum ND_COMMANDS {
    ND_FLASH_READ       = 0x00,
    ND_COPY_FLASH2RAM   = 0x45,
    ND_RAM_READ         = 0x46,
    ND_SET_SENSITIVITY  = 0x47,
    ND_ERASE_SETUP      = 0x60,
    ND_FLASH_STATUS     = 0x70,
    ND_STATUS_RESET     = 0xFF,
};


#define OFFSET_PHOTO        0x01        // 0x00=display, 0x01=prima pagina dopo il display

#define PAGE2ADDR(a)    ( ((DWORD)(a)) * 0x20000L )
#define ADDR2PAGE(a)    ( ((DWORD)(a)) / 0x20000L )

byte            mmdLoadProg( void );
byte            mmdEraseImages( byte _superUser );
byte            mmdEraseOneImage( dword _offset );
byte            mmdEraseMemory( dword _startAddr, dword _size );
byte            mmdLoadImages( byte _superUser );
void            mmdRestartAds( void );
byte            mmdShowAds( void );
void            mmdImageLibBuild( void );
byte            mmdTestBadBlocks( void );
byte            mmdReadHeader( DWORD _addr, byte *_p );




#endif
