/* keyboard.h */
#ifndef __KEYBOARD_H
#define __KEYBOARD_H

#define TIMER_KEYBOARD  1000  // tout x pressioni consecutive tasto


#define K_A         1
#define K_B         2
#define K_C         3
#define K_D         4
#define K_E         5
#define K_F         6
#define K_G         7
#define K_H         8
#define K_I         9
#define K_J         10
#define K_K         11
#define K_L         12
#define K_M         13
#define K_N         14
#define K_O         15
#define K_P         16
#define K_Q         17
#define K_R         18
#define K_S         19
#define K_T         20
#define K_U         21
#define K_V         22
#define K_W         23
#define K_X         24
#define K_Y         25
#define K_Z         26

#define   K_0         40
#define   K_1         41
#define   K_2         42
#define   K_3         43
#define   K_4         44
#define   K_5         45
#define   K_6         46
#define   K_7         47
#define   K_8         48
#define   K_9         49
#define   K_00        50
#define   K_10        51
#define   K_11        52
#define   K_12        53
#define   K_13        54
#define   K_14        55

#define   K_AST       72
#define   K_ENTER     70
#define   K_RESET     71

#define   K_DOOR      72

extern const unsigned char tabKeyToAscii[];




///
#define KNULL       0

#define KST         K_CARTA2            // STORNO
#define KRC         K_R                 // RIAPERTURA CONTO
#define KRES                            // RESTO
#define KCC                             // CHIUSURA CONTO
#define KPLU        K_PLU               // SELEZIONE PLU
#define KPIU        K_PIU               // SOMMA
#define KCANC       K_C                 // CANCELLA
#define KMENO       K_MENO              // SOTTRAZIONE
#define KPER        K_PER               // MOLTIPLICAZIONE
#define KTP         K_TARAMAN           // TARA PREDETERMINATA
#define KIZ         K_ZERO              // IMPOSTA ZERO
#define KTAR        K_TARAUTO           // TARA
#define KBLOC       K_LOCK              // BLOCCO
#define KENTER      K_ENTER             // ENTER
#define KAC         K_CARTA1            // AVANZAMENTO CARTA
#define KCH         K_KEY               // CHIAVE     (ctrl-o)

#define K_TA        K_TARAUTO
#define K_TM        K_TARAMAN
#define K_MEN       K_MENO


#define KCLEAR      KCANC
#define KINS        KPER

#define KEY_MUX(a)  {FIO2SET = ((a)&0x07) << 8; FIO2CLR = ((~(a))&0x07) << 8;}




void            keyStart( void );
void            keyFlush( void );
byte            getKey( void );
void            filterKey( void );
void            ISRkey( void );
int             kbhit( void );
#ifndef __WIN32__
int             doorOpen( void );
int             MenuSwitch( void );
#endif //__WIN32__
void            putKey( byte _key );



#endif
