extern unsigned char   doorCount;
int evento_just_reset;
/*--------------------------------------------------------------------------
 |  main.c
 +--------------------------------------------------------------------------*/
//
// codifica -> LITTLE ENDIAN
// char  1 byte
// short 2 byte
// int 4 byte
// long 4 byte
//risorse impiegate:
//timer0 ->  T0MR2 azzeramento buzzer e timer 1ms
//timer1 ->  T1MR1 fasi motore stampante
//           T1MR0 strobe testina
//I2C0 -> display operatore + cliente, orologio
//PWM2 -> contrasto display custom LCD
//SPI0 -> testina di stampa
//SPI1 -> AD converter
//Aout -> contrasto modulo LCD
//
// simboli: xxx aggiungere parte di programma
//
// tempi misurati -> preparazione blocco 4k o 32k 50us
//                   cancellazione blocco 4k o 32k 400ms
//                   programmazione blocco 256 @4k o 32k 1,26m
//                   programmazione blocco 4096 @4k o 32k 18m4
//
#define __MAIN_C

#define TEST_ADC_KEYBOARD   0

/////////////////////////////////////////////////////////////////////////////
//#define BASE_BOARD_SELECTION
//#define TEST                          // base         // tastiera-display
#define BOARD_ROWE6800      0           // RSR676
#define BOARD_ROWE5900      0           // RSR675
#define BOARD_NAT147        0           // RSR642           RSR644
#define BOARD_AP113         0           // RSR654           RSR655
#define BOARD_NAT157        0           // RSR714           RSR718
#define BOARD_AP7000        0           // RSR715           RSR723
#define BOARD_LCM123        0           // RSR762
#define BOARD_AP123         0           // RSR765           RSR767
#define BOARD_VEIDOOR       1           // RSR765           RSR767
#define BOARD_NAT145        0           // RSR642           RSR644
#define BOARD_AMS39         0           // RSR857           RSR...
#define BOARD_VEI147        0           // RSR714           RSR873
#define BOARD_USIGVC2       0           // RSR885
#define BOARD_RSR903        0           // RSR903
#define BOARD_MERCHA6       0           // RSR921
#define BOARD_VED1000       0           // RSR714           RSR873
#define BOARD_VEILCM        0           // RSR765           RSR767
/////////////////////////////////////////////////////////////////////////////

#include  "def.h"
///////////////////////////////////////////////////////////////////////////////
#define BOOT_RELEASE        "0008"
    #if PRODUCT_RECOGNITION
        #if MOTOR_SIMULATION
            #define FIRWMARE_RELEASE    "0FnZ"
        #else
            #define FIRWMARE_RELEASE    "0R01"
        #endif
    #else
        #if MODEM_HTTP
            #if MOTOR_SIMULATION
                #define FIRWMARE_RELEASE    "01x1"
            #else
#if BIG_SCREEN
                #define FIRWMARE_RELEASE    "0B2B"
#else
                #define FIRWMARE_RELEASE    "012P"
#endif
            #endif
        #else
            #if MOTOR_SIMULATION
                #define FIRWMARE_RELEASE    "x321"
            #else
                #define FIRWMARE_RELEASE    " 321"
            #endif
        #endif
    #endif

#ifdef  __WIN32__
#define FLASH
#else
#define FLASH _Pragma("location=\"VENDNAME\"")
#endif

#include  <ctype.h>
#include  <stdio.h>
#include  <string.h>
#define ALLOCA_MEMORIA
#include "ram.h"
#include "hwinit.h"
#include "DISPLAY.H"
#include "crc16.h"
#include "fat.h"
#include "funzioni.h"
#include "graphics.h"
#include "lcd7seg.h"
#include "main.h"
#include "timer.h"
#include "keyboard.h"
#include "messaggi.h"
#include "menu.h"
#include "modem.h"
#include "optical.h"
#include "uart.h"
#include "ram.h"
#include "inizial.h"
#include "english.h"
#include "espana.h"
#include "event.h"
#include "ds2341.h"
#include "dex.h"
#include "mmc.h"
#include "test.h"
#include "zigbee.h"
//dosfs
#include "dosfs.h"
#include "temperatura.h"
//	uint8_t     sector[SECTOR_SIZE], fileName[SECTOR_SIZE];
//dosfs
byte            testIfMotorAvailable( byte _k, byte _an );
byte            forceEscrow = 0;
#ifdef  __WIN32__
#include  <io.h>
void            activateMotor( byte _tray, byte _column );
void            deactivateMotor( void );
#else  //__WIN32__
void            activateMotor( byte _tray, byte _column ) 
{
#if HOME_DEBUG//22=activate motor
                commPutChar( COMM1, 0x22 );
                commPutChar( COMM1, ((_tray&0x0f)<<4)|(_column&0x0f) );
#endif
}
void            deactivateMotor( void ) {}
#endif //__WIN32__
#ifdef BOOT
#define         enCOUPLING(a)   1 
#endif

#if LED_DIMMING
DWORD           tLED1, dutyLEDDefault, dutyLED2;
#define         LED_FULL_ON()   tLED1 = GetTickCount();dutyLED2 = dutyLEDDefault;
#define         LED_OFF()       dutyLED2 = 0;
#else
#define         LED_FULL_ON()
#define         LED_OFF()
#endif
DWORD           bucket_cnt = 0, to_flashing_led_on = 0, to_flashing_led_off = 0;

#if ANTI_V      // da verificare
DWORD           tLED1, dutyLEDDefault;
DWORD           tLED2, dutyLED2;
#endif
#if ENABLE_DISCOUNT
byte            discount_doorClose( void );
void            discount_reload( byte _mode );
void            discount( _Credito *tot, byte s_tray, byte s_column );
void            discount_count( byte s_tray, byte s_column );
extern unsigned short  sels[MAXTRAY][MAXCOLUMN];
#endif
extern struct S_SelectionData SelectionData;
extern byte     K_SX, K_DX, K_UP, K_DW, K_ESC, K_OK;

byte            show_temp = 0;
extern struct S_SelectionData SelectionData;
void  displayTempFail( char *buf );

#if SLAVE_MACHINE
extern byte SlaveTray, SlaveRow, SlaveStatus[MAX_MACHINE_NUM], SlaveSelectionStatus[MAX_MACHINE_NUM], SlaveForceReset, SlaveAddrOffset;
#endif
#ifdef MAPPA_MOTORI
static void  mappa_motori( byte kkk );
#endif

byte  cheskHostCashless( byte _machine, byte _tray, byte _column );   // modem.c
/*
 *  LOCAL FUNCTIONS
 */
void  displaySelection( char *buf_machine, char *buf_tray, char *buf_column, byte _machine, byte _tray, byte _column, char filler );

//EEE
struct S_SETUP {
  byte  Feature_Level;
  unsigned short Country_Currency_Code;
  byte  Scaling_Factor;
  byte  Decimal_Places;
  unsigned short Coin_Type_Routing;
  unsigned short Coin_Type_Credit[16];
};

struct S_TUBE_STATUS {
  unsigned short Tube_Full_Status;
  unsigned char  Tube_Status[16];
  unsigned char  Escrow_Status[16];
};

struct S_COIN_STATUS {
  unsigned short Coin_Enable;
  unsigned short Manual_Dispense_Enable;
};

struct S_LEVEL_THREE_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  unsigned short Software_Version;
  union {
    char  Optional_Features[4];
    struct {  // tengo conto dell'endianess, [0] e' LSB, [3] e' MSB
      unsigned long unusedH:24 ;
      unsigned long payout:1 ;
      unsigned long extended_diagnostic:1 ;
      unsigned long manual_fill:1 ;
      unsigned long FTL:1 ;
      unsigned long unusedL:4 ;
    }Options;
  };
};
extern struct S_CHANGE {
  struct S_SETUP Setup;
  struct S_TUBE_STATUS TubeStatus;
  struct S_COIN_STATUS CoinStatus;
  struct S_LEVEL_THREE_CAPABILITIES LevelTreeCapabilities;
} Change;
extern char           currencyString[3];
extern DWORD          GestioneMenuForcedByHost;
extern byte           exitMenuForcedByHost;

//EEE

#define N_K_ROWE    8
#define N_K_USI     7
#define N_K_AP113   10//EEE 16
#define N_K_LCM123  10//EEE 
#define N_K_AMS39   N_K_AP113
#define N_K_NAT147  16

#define N_AN_ROWE   10
#define N_AN_USI    10
#define N_AN_LCM123 10
#define N_AN_AMS39  10
#define N_AN_AP113   8
#define N_AN_NAT147  5
#define N_AN_MERCHA6 6

#define T_MAX_MOTOR 4000                // maximum timing for motor homing
#define T_MIN_MOTOR 1000                // minimum timing for motor off home

#define FALL_ANTIDEB 200                // antidebuunce start of drop sensor

#if PRODUCT_RECOGNITION
int showImage=0;
const char *prodRecogName[] = {
  "H1",//"DORITOSRED",//H1
  "H2",//"FRITOS",//H2
  "H3",//"PIZZARIAS",   //H3
  "H4",//"RUFFLES",  //H4
  "H5",//
  "H6",//
  "H7",//
  "H8",//
  "H9",//
  "H10",//
};
int prodRecogNum[10] = {
  1,
  1,
  2,
  3,
  4,
  1,
  1,
  2,
  3,
  4
};
int procRecogTray, procRecogCol;
void            newProdName( char *_str )
{
    int n;
    for ( n = 0; n < 10; n++ )
    {
        if ( strcmp(prodRecogName[n],_str) == 0 )
        {
            amount[0][procRecogCol] = amount[0]['H'-'A'][n+1];
            prodRecogNum[procRecogCol] = n+1;
            lpdRecalc();
            showImage=1+prodRecogNum[procRecogCol];
            return;
        }
    }
}
#endif

const struct {
    DWORD       tTimeout;
} tMaxMotor[TOTAL_MACHINE+1+2] =
{
    5000,   //AP113
    4000,   //NAT147
    4000,   //ROWE 5900
    4000,   //ROWE 6800
    4000,   //NAT157
    5000,   //AP7000
    5000,   //LCM123
    5000,   //AP123
    5000,   //VEIDOOR
    4000,   //NAT145
    4000,   //AMS39  -- da verificare
    4000,   //VEI147
    4000,   //USIGVC2  -- da verificare
    4000,   //MERCHAND6
    5000,   //VEILCM
    // see abilRemap
    4000,   //NAT145/13
    // SUBMACHINE
   28000,   // Dixie501e - changed 04.07.2013
   10000,   // VED1000       
};

const struct {
    byte r_k, r_an;
} abilRemap[TOTAL_MACHINE+1+1][MAXTRAY][MAXCOLUMN] =  // +1 is for submachine DIXIE501
{
    {//AP113
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 9,0},{ 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0}    },
    {    /*B*/   { 9,1},{ 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1}    },
    {    /*C*/   { 9,2},{ 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2}    },
    {    /*D*/   { 9,3},{ 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3}    },
    {    /*E*/   { 9,4},{ 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4}    },
    {    /*F*/   { 9,5},{ 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5}    },
    {    /*G*/   { 9,6},{ 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6}    },
    {    /*H*/   { 9,7},{ 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7}    },
    {    /*I*/   { 9,8},{ 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//NAT147
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 4,4},{ 5,4},{ 4,3},{ 5,3},{ 4,2},{ 5,2},{ 4,1},{ 5,1},{ 4,0},{ 5,0}    },
    {    /*B*/   { 6,4},{ 7,4},{ 6,3},{ 7,3},{ 6,2},{ 7,2},{ 6,1},{ 7,1},{ 6,0},{ 7,0}    },
    {    /*C*/   { 8,4},{ 9,4},{ 8,3},{ 9,3},{ 8,2},{ 9,2},{ 8,1},{ 9,1},{ 8,0},{ 9,0}    },
    {    /*D*/   {10,4},{11,4},{10,3},{11,3},{10,2},{11,2},{10,1},{11,1},{10,0},{11,0}    },
    {    /*E*/   {12,4},{13,4},{12,3},{13,3},{12,2},{13,2},{12,1},{13,1},{12,0},{13,0}    },
    {    /*F*/   {14,4},{15,4},{14,3},{15,3},{14,2},{15,2},{14,1},{15,1},{14,0},{15,0}    },
    {    /*G*/   { 2,4},{ 3,4},{ 2,3},{ 3,3},{ 2,2},{ 3,2},{ 2,1},{ 3,1},{ 2,0},{ 3,0}    },
    {    /*H*/   { 1,4},{ 0,4},{ 1,3},{ 0,3},{ 1,2},{ 0,2},{ 1,1},{ 0,1},{ 1,0},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

//    {//ROWE 5900 675A
//                  0      1      2      3      4      5      6      7      8      9
//    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
//    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,9},{ 0,8},{ 0,6},{ 0,7}    },
//    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,9},{ 1,8},{ 1,6},{ 1,7}    },
//    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,9},{ 2,8},{ 2,6},{ 2,7}    },
//    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,9},{ 3,8},{ 3,6},{ 3,7}    },
//    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
//    {    /*6*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,9},{ 4,8},{ 4,6},{ 4,7}    },
//    {    /*7*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,9},{ 5,8},{ 5,6},{ 5,7}    },
//    {    /*8*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,9},{ 6,8},{ 6,6},{ 6,7}    },
//    {    /*9*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,9},{ 7,8},{ 7,6},{ 7,7}    }
//    },

    {//ROWE 5900 675B
//                  0      1      2      3      4      5      6      7      8      9
    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*1*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,9},{ 7,8},{ 7,6},{ 7,7}    },
    {    /*2*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,9},{ 6,8},{ 6,6},{ 6,7}    },
    {    /*3*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,9},{ 5,8},{ 5,6},{ 5,7}    },
    {    /*4*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,9},{ 4,8},{ 4,6},{ 4,7}    },
    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*6*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,9},{ 3,8},{ 3,6},{ 3,7}    },
    {    /*7*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,9},{ 2,8},{ 2,6},{ 2,7}    },
    {    /*8*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,9},{ 1,8},{ 1,6},{ 1,7}    },
    {    /*9*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,9},{ 0,8},{ 0,6},{ 0,7}    }
    },

    {//ROWE 6800
//                  0      1      2      3      4      5      6      7      8      9
    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*1*/   { 0,7},{ 0,0},{ 0,2},{ 0,9},{ 0,8},{ 0,5},{ 0,4},{ 0,3},{ 0,1},{ 0,6}    },
    {    /*2*/   { 1,7},{ 1,0},{ 1,2},{ 1,9},{ 1,8},{ 1,5},{ 1,4},{ 1,3},{ 1,1},{ 1,6}    },
    {    /*3*/   { 2,7},{ 2,0},{ 2,2},{ 2,9},{ 2,8},{ 2,5},{ 2,4},{ 2,3},{ 2,1},{ 2,6}    },
    {    /*4*/   { 3,7},{ 3,0},{ 3,2},{ 3,9},{ 3,8},{ 3,5},{ 3,4},{ 3,3},{ 3,1},{ 3,6}    },
    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*6*/   { 4,7},{ 4,0},{ 4,2},{ 4,9},{ 4,8},{ 4,5},{ 4,4},{ 4,3},{ 4,1},{ 4,6}    },
    {    /*7*/   { 5,7},{ 5,0},{ 5,2},{ 5,9},{ 5,8},{ 5,5},{ 5,4},{ 5,3},{ 5,1},{ 5,6}    },
    {    /*8*/   { 6,7},{ 6,0},{ 6,2},{ 6,9},{ 6,8},{ 6,5},{ 6,4},{ 6,3},{ 6,1},{ 6,6}    },
    {    /*9*/   { 7,7},{ 7,0},{ 7,2},{ 7,9},{ 7,8},{ 7,5},{ 7,4},{ 7,3},{ 7,1},{ 7,6}    }
    },

    {//NAT157
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,0},{ 5,1},{ 4,1},{ 5,2},{ 4,2},{ 5,3},{ 4,3},{ 5,4},{ 4,4}    },
    {    /*B*/   { 3,0},{ 2,0},{ 3,1},{ 2,1},{ 3,2},{ 2,2},{ 3,3},{ 2,3},{ 3,4},{ 2,4}    },
    {    /*C*/   { 1,0},{ 0,0},{ 1,1},{ 0,1},{ 1,2},{ 0,2},{ 1,3},{ 0,3},{ 1,4},{ 0,4}    },
    {    /*D*/   { 6,0},{ 7,0},{ 6,1},{ 7,1},{ 6,2},{ 7,2},{ 6,3},{ 7,3},{ 6,4},{ 7,4}    },
    {    /*E*/   { 8,0},{ 9,0},{ 8,1},{ 9,1},{ 8,2},{ 9,2},{ 8,3},{ 9,3},{ 8,4},{ 9,4}    },
    {    /*F*/   {10,0},{11,0},{10,1},{11,1},{10,2},{11,2},{10,3},{11,3},{10,4},{11,4}    },
    {    /*G*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*H*/   {12,0},{12,1},{12,2},{12,3},{12,4},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*J*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//AP7000
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   {7, 4},{9, 4},{4, 4},{3, 4},{2, 4},{1, 4},{6, 4},{0, 4},{8, 4},{5, 4}    },
    {    /*B*/   {7, 5},{9, 5},{4, 5},{3, 5},{2, 5},{1, 5},{6, 5},{0, 5},{8, 5},{5, 5}    },
    {    /*C*/   {7, 2},{9, 2},{4, 2},{3, 2},{2, 2},{1, 2},{6, 2},{0, 2},{8, 2},{5, 2}    },
    {    /*D*/   {7, 3},{9, 3},{4, 3},{3, 3},{2, 3},{1, 3},{6, 3},{0, 3},{8, 3},{5, 3}    },
    {    /*E*/   {7, 6},{9, 6},{4, 6},{3, 6},{2, 6},{1, 6},{6, 6},{0, 6},{8, 6},{5, 6}    },
    {    /*F*/   {7, 0},{9, 0},{4, 0},{3, 0},{2, 0},{1, 0},{6, 0},{0, 0},{8, 0},{5, 0}    },
    {    /*G*/   {7, 1},{9, 1},{4, 1},{3, 1},{2, 1},{1, 1},{6, 1},{0, 1},{8, 1},{5, 1}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//LCM123
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 9,0},{ 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0}    },
    {    /*B*/   { 9,1},{ 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1}    },
    {    /*C*/   { 9,2},{ 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2}    },
    {    /*D*/   { 9,3},{ 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3}    },
    {    /*E*/   { 9,4},{ 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4}    },
    {    /*F*/   { 9,5},{ 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5}    },
    {    /*G*/   { 9,6},{ 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6}    },
    {    /*H*/   { 9,7},{ 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7}    },
    {    /*I*/   { 9,8},{ 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//AP123
//                  0      1      2      3      4      5      6      7      8      9
    {/*1*//*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {/*1*//*2*/  { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1},{ 9,1}    },
    {/*1*//*3*/  { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2},{ 9,2}    },
    {/*1*//*4*/  { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3},{ 9,3}    },
    {/*1*//*5*/  { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4},{ 9,4}    },
    {/*1*//*6*/  { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5},{ 9,5}    },
    {/*1*//*7*/  { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6},{ 9,6}    },
    {/*1*//*8*/  { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7},{ 9,7}    },
    {/*1*//*9*/  { 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8},{ 9,8}    },
    {/*1*//* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//VEIDOOR
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {    /*2*/  { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1},{ 9,1}    },
    {    /*3*/  { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2},{ 9,2}    },
    {    /*4*/  { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3},{ 9,3}    },
    {    /*5*/  { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4},{ 9,4}    },
    {    /*6*/  { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5},{ 9,5}    },
    {    /*7*/  { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6},{ 9,6}    },
    {    /*8*/  { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7},{ 9,7}    },
    {    /*9*/  { 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8},{ 9,8}    },
    {    /* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//NAT145/9
//                 10      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,4},{ 4,3},{ 4,2},{ 4,1},{ 5,4},{ 5,3},{ 5,2},{ 5,1},{ 4,0}    },
    {    /*B*/   { 7,0},{ 6,4},{ 6,3},{ 6,2},{ 6,1},{ 7,4},{ 7,3},{ 7,2},{ 7,1},{ 6,0}    },
    {    /*C*/   { 9,0},{ 8,4},{ 8,3},{ 8,2},{ 8,1},{ 9,4},{ 9,3},{ 9,2},{ 9,1},{ 8,0}    },
    {    /*D*/   {11,0},{10,4},{10,3},{10,2},{10,1},{11,4},{11,3},{11,2},{11,1},{10,0}    },
    {    /*E*/   {13,0},{12,4},{12,3},{12,2},{12,1},{13,4},{13,3},{13,2},{13,1},{12,0}    },
    {    /*F*/   {15,0},{14,4},{14,3},{14,2},{14,1},{15,4},{15,3},{15,2},{15,1},{14,0}    },
    {    /*G*/   { 0,0},{ 1,4},{ 1,3},{ 1,2},{ 1,1},{ 0,4},{ 0,3},{ 0,2},{ 0,1},{ 1,0}    },
    {    /*H*/   { 1,0},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
#if TOK_TAKE
 {//TOK TAKE
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{12,0},{13,0}    },
    {    /*2*/   { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{12,1},{13,1}    },
    {    /*3*/   { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{12,2},{13,2}    },
    {    /*4*/   { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{12,3},{13,3}    },
    {    /*5*/   { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{12,4},{13,4}    },
    {    /*6*/   { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{12,5},{13,5}    },
    {    /*7*/   { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{12,6},{13,6}    },
    {    /*8*/   { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{12,7},{13,7}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
#else
    {//AMS39
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,6},{ 0,7},{ 0,8},{ 0,9}    },
    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,6},{ 1,7},{ 1,8},{ 1,9}    },
    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,6},{ 2,7},{ 2,8},{ 2,9}    },
    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,6},{ 3,7},{ 3,8},{ 3,9}    },
    {    /*5*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,6},{ 4,7},{ 4,8},{ 4,9}    },
    {    /*6*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,6},{ 5,7},{ 5,8},{ 5,9}    },
    {    /*7*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,6},{ 6,7},{ 6,8},{ 6,9}    },
    {    /*8*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,6},{ 7,7},{ 7,8},{ 7,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
#endif    
    {//VEI147
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 5,0},{ 4,0},{ 5,1},{ 4,1},{ 5,2},{ 4,2},{ 5,3},{ 4,3},{ 5,4},{ 4,4}    },
    {    /*2*/   { 3,0},{ 2,0},{ 3,1},{ 2,1},{ 3,2},{ 2,2},{ 3,3},{ 2,3},{ 3,4},{ 2,4}    },
    {    /*3*/   { 1,0},{ 0,0},{ 1,1},{ 0,1},{ 1,2},{ 0,2},{ 1,3},{ 0,3},{ 1,4},{ 0,4}    },
    {    /*4*/   { 6,0},{ 7,0},{ 6,1},{ 7,1},{ 6,2},{ 7,2},{ 6,3},{ 7,3},{ 6,4},{ 7,4}    },
    {    /*5*/   { 8,0},{ 9,0},{ 8,1},{ 9,1},{ 8,2},{ 9,2},{ 8,3},{ 9,3},{ 8,4},{ 9,4}    },
    {    /*6*/   {10,0},{11,0},{10,1},{11,1},{10,2},{11,2},{10,3},{11,3},{10,4},{11,4}    },
    {    /*7*/   {12,0},{12,1},{12,2},{12,3},{12,4},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*8*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//USIGVC2
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,6},{ 0,7},{ 0,8},{ 0,9}    },
    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,6},{ 1,7},{ 1,8},{ 1,9}    },
    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,6},{ 2,7},{ 2,8},{ 2,9}    },
    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,6},{ 3,7},{ 3,8},{ 3,9}    },
    {    /*5*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,6},{ 4,7},{ 4,8},{ 4,9}    },
    {    /*6*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,6},{ 5,7},{ 5,8},{ 5,9}    },
    {    /*7*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,6},{ 6,7},{ 6,8},{ 6,9}    },
    {    /*8*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,6},{ 7,7},{ 7,8},{ 7,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
    
    {//MERCHAND6, to activate escrow you have to make selection [0,5]
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   {14,5},{13,5},{14,4},{13,4},{14,3},{13,3},{14,2},{13,2},{14,1},{13,1}    },
    {    /*2*/   {12,5},{11,5},{12,4},{11,4},{12,3},{11,3},{12,2},{11,2},{12,1},{11,1}    },
    {    /*3*/   {10,5},{ 9,5},{10,4},{ 9,4},{10,3},{ 9,3},{10,2},{ 9,2},{10,1},{ 9,1}    },
    {    /*4*/   { 8,5},{ 7,5},{ 8,4},{ 7,4},{ 8,3},{ 7,3},{ 8,2},{ 7,2},{ 8,1},{ 7,1}    },
    {    /*5*/   { 6,5},{ 5,5},{ 6,4},{ 5,4},{ 6,3},{ 5,3},{ 6,2},{ 5,2},{ 6,1},{ 5,1}    },
    {    /*6*/   { 4,5},{ 3,5},{ 4,4},{ 3,4},{ 4,3},{ 3,3},{ 4,2},{ 3,2},{ 4,1},{ 3,1}    },
    {    /*7*/   { 2,5},{ 1,5},{ 2,4},{ 1,4},{ 2,3},{ 1,3},{ 2,2},{ 1,2},{ 2,1},{ 1,1}    },
    {    /*8*/   { 0,5},{99,9},{99,9},{99,9},{99,9},{99,9},{14,0},{13,0},{12,0},{11,0}    }, // escrow motor
    {    /*9*/   {10,0},{ 9,0},{ 8,0},{ 7,0},{ 6,0},{ 5,0},{ 4,0},{ 3,0},{ 2,0},{ 1,0}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
    
    {//VEILCM
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {    /*2*/  { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1},{ 9,1}    },
    {    /*3*/  { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2},{ 9,2}    },
    {    /*4*/  { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3},{ 9,3}    },
    {    /*5*/  { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4},{ 9,4}    },
    {    /*6*/  { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5},{ 9,5}    },
    {    /*7*/  { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6},{ 9,6}    },
    {    /*8*/  { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7},{ 9,7}    },
    {    /*9*/  { 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8},{ 9,8}    },
    {    /* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },    

//MUST BE ALWAYS last machineMotor entry ( see checkMotorMap code, lines machineMotor = TOTAL_MACHINE )
    {//NAT145/13
//                 10      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,4},{ 4,3},{ 4,2},{ 4,1},{ 4,0},{ 5,4},{ 5,3},{ 5,2},{ 5,1}    },
    {    /*B*/   { 7,0},{ 6,4},{ 6,3},{ 6,2},{ 6,1},{ 6,0},{ 7,4},{ 7,3},{ 7,2},{ 7,1}    },
    {    /*C*/   { 9,0},{ 8,4},{ 8,3},{ 8,2},{ 8,1},{ 8,0},{ 9,4},{ 9,3},{ 9,2},{ 9,1}    },
    {    /*D*/   {11,0},{10,4},{10,3},{10,2},{10,1},{10,0},{11,4},{11,3},{11,2},{11,1}    },
    {    /*E*/   {13,0},{12,4},{12,3},{12,2},{12,1},{12,0},{13,4},{13,3},{13,2},{13,1}    },
    {    /*F*/   {15,0},{14,4},{14,3},{14,2},{14,1},{14,0},{15,4},{15,3},{15,2},{15,1}    },
    {    /*G*/   { 0,0},{ 1,4},{ 1,3},{ 1,2},{ 1,1},{ 1,0},{ 0,4},{ 0,3},{ 0,2},{ 0,1}    },
    {    /*H*/   { 1,0},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
    
    { // SUBMACHINE DIXIE501e
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {    /*2*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*3*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*4*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*5*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*6*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*7*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*8*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*9*/  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
};


#if RSR903
extern byte SlaveSelection;

#define VendoVue  0
#define BevMax    0
#define Evolution 0
#define Samba     0
#define Snakky    1
#define VEIDoor   0
#define FastCorp  0
#define GSnack    0
#define GDrink    0
#define Azkoyen   0
#define Wurlitzer 0

#define ON10  0x200
#define ON1   0x100
#define ON2   0x080
#define ON3   0x040
#define ON4   0x020
#define ON5   0x010
#define ON6   0x008
#define ON7   0x004
#define ON8   0x002
#define ON9   0x001
#define AllOFF 0x3FF

#if FastCorp
#define SlaveTimeout  40000
#define MapOff      ( ON1 | ON3 | ON6 | ON8 )  
dword MapKey[16]  = {            ON2 | ON3,               // 0
                      ON7 | ON6, ON7 | ON3, ON7 | ON1,    // 1,2,3
                      ON5 | ON6, ON5 | ON3, ON5 | ON1,    // 4,5,6
                      ON4 | ON5, ON4 | ON3, ON4 | ON1,    // 7,8,9
                      ON7 | ON8, ON5 | ON8, ON4 | ON8, ON2 | ON8, // A, B, C, D
                      ON2 | ON6,            ON2 | ON1 };  // *. #

#define MapTray()   FIO2CLR = MapKey[ s_tray + 10 ];
#endif

#if VEIDoor
#define SlaveTimeout  15000
#define MapOff      ( ON3 | ON4 | ON5 )  
dword MapKey[10]  = {            ON6 | ON4,               // 0
                      ON9 | ON5, ON9 | ON4, ON9 | ON3,    // 1,2,3
                      ON8 | ON5, ON8 | ON4, ON8 | ON3,    // 4,5,6
                      ON7 | ON5, ON7 | ON4, ON7 | ON3  }; // 7,8,9

#define MapTray()   FIO2CLR = MapKey[ 1 ];          /* DEBUG ONLY WILL STOP MAIN !! */  \
                    Delay(100);                     /* DEBUG ONLY WILL STOP MAIN !! */  \
                    FIO2SET = AllOFF;               /* DEBUG ONLY WILL STOP MAIN !! */  \
                    Delay(100);                     /* DEBUG ONLY WILL STOP MAIN !! */  \
                    FIO2CLR = MapKey[ s_tray + 1];  /* DEBUG ONLY WILL STOP MAIN !! */
#endif

#if Samba
#define SlaveTimeout  30000
#define MapOff      ( ON1 | ON2 | ON3 )  
dword MapKey[10]  = { ON8 | ON1,                          // 0
                      ON7 | ON1, ON7 | ON2, ON7 | ON3,    // 1,2,3
                      ON6 | ON1, ON6 | ON2, ON6 | ON3,    // 4,5,6
                      ON5 | ON1, ON5 | ON2, ON5 | ON3  }; // 7,8,9
#define MapTray()   FIO2CLR = MapKey[ s_tray + 1];
#endif

#if Snakky
#define SlaveTimeout  30000
#define MapOff      ( ON1 | ON2 | ON3 )  
dword MapKey[10]  = { ON8 | ON1,                          // 0
                      ON7 | ON1, ON7 | ON2, ON7 | ON3,    // 1,2,3
                      ON6 | ON1, ON6 | ON2, ON6 | ON3,    // 4,5,6
                      ON5 | ON1, ON5 | ON2, ON5 | ON3  }; // 7,8,9
#define MapTray()   FIO2CLR = MapKey[ s_tray + 1];
#endif

#if GSnack
#define SlaveTimeout  30000
#define MapOff      ( ON1 )  
dword MapKey[10]  = {     0    ,                          //
                      ON2 | ON1, ON3 | ON1, ON4 | ON1,    // 1,2,3
                      ON5 | ON1, ON6 | ON1, ON7 | ON1,    // 4,5,6
                      ON8 | ON1, ON9 | ON1,     0      }; // 7,8
#define MapTray()   if( s_tray < 6 ) FIO2CLR = MapKey[ 6 - s_tray ];
#endif

#if GDrink
#define SlaveTimeout  30000
#define MapOff      ( ON1 | ON3 | ON5 )  
dword MapKey[10]  = {            ON4 | ON1,               // 0
                      ON2 | ON3, ON2 | ON1, ON2 | ON5,    // 1,2,3
                      ON7 | ON3, ON7 | ON1, ON7 | ON5,    // 4,5,6
                      ON6 | ON3, ON6 | ON1, ON6 | ON5  }; // 7,8,9

#define MapTray()   FIO2CLR = MapKey[ s_tray ];
#endif

#if Azkoyen
#define SlaveTimeout  50000
#define MapOff      ( ON1 | ON2 )  
dword MapKey[12]  = { ON1 | ON5, ON1 | ON7, ON1 | ON4,    // A,B,C
                      ON1 | ON6, ON1 | ON3, ON2 | ON8,    // D,E,F
                      ON2 | ON5, ON2 | ON7, ON2 | ON4,    // G,H,I
                      ON1 | ON8, ON2 | ON6, ON2 | ON3  }; // J,*,#
#define MapTray()   FIO2CLR = MapKey[ s_tray ];
#endif

#if Wurlitzer
#define SlaveTimeout  30000
#define MapOff      ( ON5 | ON6 | ON7 )  
dword MapKey[12]  = { ON1 | ON5, ON2 | ON5, ON3 | ON5,    // 1,2,3
                      ON4 | ON5, ON1 | ON6, ON2 | ON6,    // 4,5,6
                      ON3 | ON6, ON4 | ON6, ON1 | ON7,    // 7,8,9
                      ON2 | ON7, ON3 | ON7, ON4 | ON7  }; // R,0,C
#define MapTray()   FIO2CLR = MapKey[ s_tray ];
#endif

#if VendoVue
#define SlaveTimeout  30000
#define MapOff      ( ON1 | ON2 | ON8 )  
dword MapKey[10]  = {            ON6 | ON1,               // 0
                      ON3 | ON8, ON3 | ON1, ON3 | ON2,    // 1,2,3
                      ON4 | ON8, ON4 | ON1, ON4 | ON2,    // 4,5,6
                      ON5 | ON8, ON5 | ON1, ON5 | ON2  }; // 7,8,9

#define MapTray()   FIO2CLR = MapKey[ s_tray ];
#endif

#if BevMax
#define SlaveTimeout  37000
#define MapOff      ( ON1 | ON2 | ON3 )  
dword MapKey[16]  = {                      ON8 | ON3,    // 0
                                ON4 | ON2, ON4 | ON3,    // 1,2
                                ON5 | ON2, ON5 | ON3,    // 3,4
                                ON6 | ON2, ON6 | ON3,    // 5,6
                                ON7 | ON2, ON7 | ON3,    // 7,8
                                ON8 | ON2,               // 9
                      ON4 | ON1,                         // A
                      ON5 | ON1,                         // B
                      ON6 | ON1,                         // C
                      ON7 | ON1,                         // D
                      ON8 | ON1,                         // E
                      ON9 | ON1                          // F
                    };

#define MapTray()   FIO2CLR = MapKey[ s_tray + 10 ];
#endif

#if Evolution

unsigned int SeqCounter;

#define MapOff      ( ON1 | ON2 | ON3 | ON4 )  
dword MapKey[24]  = {  0,
                       ON8 | ON4, ON8 | ON1, ON8 | ON3, ON8 | ON2, // 1,2,3,4
                       ON7 | ON4, ON7 | ON1, ON7 | ON3, ON7 | ON2, // 5,6,7,8
                       ON6 | ON4, ON6 | ON1, ON6 | ON3, ON6 | ON2, // 9,10,11,12
                       ON5 | ON4, ON5 | ON1, ON5 | ON3, ON5 | ON2, // 13,14,15,16
                       ON9 | ON4, ON9 | ON1, ON9 | ON3, ON9 | ON2, // 17,18,19,20
                       ON10| ON4, ON10| ON1, ON10| ON3             // 21,22,start
                    };

#define MapTray()   SeqCounter = ( 10*s_tray + s_column ) * 11; \
                    FIO2CLR = MapKey[ SeqKey[ SeqCounter++ ] ];

#define INSTA  10
#define MILK_  1
#define SUGAR  9
#define STRT_  5
#ifdef BOOT
#else
byte SeqKey[49*11] = {    1,     0,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // 110, SW1, MILK
                          2, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW2
                          3, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW3
                          4, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW4
                          5,     0,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW5
                          6, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW6
                          7, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW7
                          8, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW8
                          9,     0,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW9
                      INSTA, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW10
                         11, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // 120 SW11
                         12, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW12
                         13, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW13
                         14, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW14
                         15, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW15
                         16, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW16
                         17, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW17
                         18, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW18
                         19, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW19
                         20, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW20
                         21, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // 130 SW21
                         22, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // SW22
                      INSTA, STRT_,     0,     0,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee std.
                      INSTA, INSTA, STRT_,     0,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong
                      INSTA, INSTA, INSTA, STRT_,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee mild                     
                      INSTA, MILK_, STRT_,     0,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee std, normal milk
                      INSTA, INSTA, MILK_, STRT_,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong, normal milk
                      INSTA, INSTA, INSTA, MILK_, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee mild, normal milk
                      INSTA, MILK_, MILK_, STRT_,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee std, extra milk
                      INSTA, INSTA, MILK_, MILK_, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong, extra milk
                      INSTA, INSTA, INSTA, MILK_, MILK_, STRT_,     0,     0,     0,     0, 0,  // 140 Instant Coffee mild, extra milk
                      INSTA, SUGAR, STRT_,     0,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee std.,  sugar
                      INSTA, INSTA, SUGAR, STRT_,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong,  sugar
                      INSTA, INSTA, INSTA, SUGAR, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee mild,  sugar
                      INSTA, MILK_, SUGAR, STRT_,     0,     0,     0,     0,     0,     0, 0,  // Instant Coffee std, milk, sugar
                      INSTA, INSTA, MILK_, SUGAR, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong, milk, sugar
                      INSTA, INSTA, INSTA, MILK_, SUGAR, STRT_,     0,     0,     0,     0, 0,  // Instant Coffee mild, milk, sugar
                      INSTA, MILK_, MILK_, SUGAR, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee std, extra milk, sugar
                      INSTA, INSTA, MILK_, MILK_, SUGAR, STRT_,     0,     0,     0,     0, 0,  // Instant Coffee strong, extra milk, sugar
                      INSTA, INSTA, INSTA, MILK_, MILK_, SUGAR, STRT_,     0,     0,     0, 0,  // Instant Coffee mild, extra milk, sugar
                      INSTA, SUGAR, SUGAR, STRT_,     0,     0,     0,     0,     0,     0, 0,  // 150 Instant Coffee std., extra sugar
                      INSTA, INSTA, SUGAR, SUGAR, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee strong, extra sugar
                      INSTA, INSTA, INSTA, SUGAR, SUGAR, STRT_,     0,     0,     0,     0, 0,  // Instant Coffee mild, extra sugar
                      INSTA, MILK_, SUGAR, SUGAR, STRT_,     0,     0,     0,     0,     0, 0,  // Instant Coffee std, extra milk, extra sugar
                      INSTA, INSTA, MILK_, SUGAR, SUGAR, STRT_,     0,     0,     0,     0,  0,  // Instant Coffee strong, extra milk, extra sugar
                      INSTA, INSTA, INSTA, MILK_, SUGAR, SUGAR, STRT_,     0,     0,     0, 0,  // Instant Coffee mild, extra milk, extra sugar
                      INSTA, MILK_, MILK_, SUGAR, SUGAR, STRT_,     0,     0,     0,     0, 0,  // Instant Coffee std, no milk, extra sugar
                      INSTA, INSTA, MILK_, MILK_, SUGAR, SUGAR, STRT_,     0,     0,     0, 0,  // Instant Coffee strong, no milk, extra sugar
                      INSTA, INSTA, INSTA, MILK_, MILK_, SUGAR, SUGAR, STRT_,     0,     0, 0   // Instant Coffee mild, no milk, extra sugar
                    };
#endif
#define maxSel    (sizeof( SeqKey )/11 )
#endif
#endif


///////////////////////////////////////////////////////////////////////////////
#ifdef BOOT
#ifdef BOOT2
FLASH const char    vendName[] = "BOOT UPDATE     ";
FLASH const DWORD   baseLanguage = 0;
_Pragma("location=0x80E8") const char release[] = "RSR641  "BOOT_RELEASE;
#else
FLASH const char    vendName[16];
FLASH const DWORD   baseLanguage = 0;
_Pragma("location=0x7FE0") const char release[] = "RSR641  "BOOT_RELEASE;
#endif

char            *getBootVer( void )
{
    return (char *)release;
}

#else //BOOT
#ifdef __USA
FLASH const char    vendName[] = "VENDORS-EXCHANGE";
FLASH const DWORD   baseLanguage = 0;
#endif
#ifdef __ESP
FLASH const char    vendName[] = "    BIMBO  SA   ";
FLASH const DWORD   baseLanguage = 1;
#endif
#ifdef  __WIN32__
#else
_Pragma("location=0x80E8") const char fwRelease[4] = FIRWMARE_RELEASE;//firmware release
#endif

void            getFirmwareRelease( char *_buf )
{
#ifdef __WIN32__
#else
    if ( fwRelease[0] >= ' ' && fwRelease[0] && fwRelease[1] >= '0' && fwRelease[1] <= 'Z'  )
    {
        if( fwRelease[0] >= '0' )
            sprintf( _buf, "%8.8s#%c.%c.%c.%c", MachineTypeID, fwRelease[0], fwRelease[1], fwRelease[2], fwRelease[3] );
        else
            sprintf( _buf, "%8.8s  #%c.%c.%c",  MachineTypeID, fwRelease[1], fwRelease[2], fwRelease[3] );
    }
    else
        sprintf( _buf, " %8.8s  %5.5s", MachineTypeID, __TIME__ );
#endif
}

char            *getBootVer( void )
{
    return (char *)BOOT_VER;
}
#endif//BOOT
#if ENABLE_TAX_VISUA
struct {
    _Credito    tax, sale, total;
    dword       phase, hello;
} taxes;
#endif

#define PRINT_TAX_RECEIPT(a,b,c)

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////




extern  byte    stopInt;

byte            flagTimeDisable, lastTestTimeDisable, lastTestDiscount;
int             i;

DWORD           tTimeoutMaxMotor;
DWORD           initialInp;
DWORD           exeSaveSettings;
byte            nfront;
BOOL            inProgramm;

struct {
    byte        status;
    enum {  SELECTION_NO = 0,
            SELECTION_START,
            SELECTION_RETRY,
            SELECTION_HOMING,
            SELECTION_OK,
            SELECTION_FAILED,
            SELECTION_CHECK
    } SELECTION_MODES;
    dword       timeout;
} prodSel;
#define SET_SELECTION_STATUS(a)     {prodSel.status=(a);prodSel.timeout=GetTickCount();}
#define ON_SELECTING()              (prodSel.status != SELECTION_NO)
/* TODO TODO selection timeout 40000 must be aligned with the effective selection timeout ( which can change ), now is higher */
#define CHECK_SELECTION_STATUS()    {if( ON_SELECTING() && (GetTickCount()-prodSel.timeout) > 60000 ) prodSel.status=SELECTION_FAILED;}

unsigned int    timeBacklight;

byte            motorMap[N_K_MAX][N_AN_MAX];
byte            machineMotor;

const char * const *message;

extern word    ldpFlag[6];
extern word    ldpBlink[6];
extern byte    ldpCnt;


BOOL            testActiveMotor( byte _s_tray, byte _s_column)
{
#if RSR903
 #if Samba    // special for M&MS machine
    if( _s_column >= 8 )
        return FALSE;
    if( ( _s_tray == 0 || _s_tray == 1 ) && ( _s_column == 0 || _s_column == 2 || _s_column == 4 || _s_column == 6 ) )
        return FALSE;
    return TRUE;
 #else
  #if GSnack    // special for M&MS machine
    if( _s_tray > 5 || _s_column > 8 || _s_column == 0 ) 
        return FALSE;
    if( ( _s_tray == 0 || _s_tray == 1 ) && ( _s_column == 0 || _s_column == 2 || _s_column == 4 || _s_column == 6 ) )
        return FALSE;
    return TRUE;
  #else
    return TRUE;
  #endif
 #endif
#else
    byte        k, an;
    
    if ( machineType == MACHINA_MERCHA6 ) 
    {
        if ( _s_tray == 7 && _s_column == 0)
            return FALSE;
    }     
    GET_ACTIVE_MOTOR(k,an, _s_tray,_s_column);     
    if ( k == 99 || motorMap[k][an] == 0 )
        return FALSE;
    return TRUE;
#endif
}



/*--------------------------------------------------------------------------
 | programMachineType:program machine card
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            programMachineType( void )
{
    ///// write machine type
#ifndef BASE_BOARD_SELECTION
#if BOARD_ROWE6800
    memcpy( MachineTypeID, "ROWE6800", 9 ); // RSR676
#endif
#if BOARD_ROWE5900
    memcpy( MachineTypeID, "ROWE5900", 9 ); // RSR675
#endif
#if BOARD_NAT147
    memcpy( MachineTypeID, "NAT147\0\0", 9 );
#endif
#if BOARD_AP113
    memcpy( MachineTypeID, "AP113\0\0\0", 9 );
#endif
#if BOARD_NAT157
    memcpy( MachineTypeID, "NAT157\0\0", 9 );
#endif
#if BOARD_AP7000
    memcpy( MachineTypeID, "AP7000\0\0", 9 );
#endif
#if BOARD_LCM123
    memcpy( MachineTypeID, "LCM123\0\0", 9 );
#endif
#if BOARD_AP123
    memcpy( MachineTypeID, "AP123\0\0\0", 9 );
#endif
#if BOARD_VEIDOOR
    memcpy( MachineTypeID, "VEI-DOOR", 9 );
#endif
#if BOARD_NAT145
    memcpy( MachineTypeID, "NAT145\0\0", 9 );
#endif
#if BOARD_AMS39
    memcpy( MachineTypeID, "AMS39\0\0\0", 9 );
#endif
#if BOARD_VEI147
    memcpy( MachineTypeID, "VEI147\0\0", 9 );
#endif
#if BOARD_USIGVC2
    memcpy( MachineTypeID, "USIGVC2\0", 9 );
#endif
#if BOARD_MERCHA6
    memcpy( MachineTypeID, "MERCHA6\0", 9 );
#endif
#if BOARD_VED1000
    memcpy( MachineTypeID, "VED1000\0", 9 );
#endif   
#if BOARD_VEILCM
    memcpy( MachineTypeID, "VEILCM\0\0", 9 );
#endif
#endif
                                        // check machine type on mmc
    if ( mmcInit() == mmc_noerr )
    {
        if ( dosfs_findFile( "AP7000.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP7000\0\0", 9 );
        else if ( dosfs_findFile( "NAT147.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT147\0\0", 9 );
        else if ( dosfs_findFile( "NAT157.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT157\0\0", 9 );
        else if ( dosfs_findFile( "LCM123.UCB" ) == 0 )
            memcpy( MachineTypeID, "LCM123\0\0", 9 );
        else if ( dosfs_findFile( "AP123.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP123\0\0\0", 9 );
        else if ( dosfs_findFile( "AP113.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP113\0\0\0", 9 );
        else if ( dosfs_findFile( "VEI-DOOR.UCB" ) == 0 )
            memcpy( MachineTypeID, "VEI-DOOR", 9 );
        else if ( dosfs_findFile( "NAT145.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT145\0\0", 9 );
        else if ( dosfs_findFile( "AMS39.UCB" ) == 0 )
            memcpy( MachineTypeID, "AMS39\0\0\0", 9 );
        else if ( dosfs_findFile( "VEI147.UCB" ) == 0 )
            memcpy( MachineTypeID, "VEI147\0\0", 9 );
        else if ( dosfs_findFile( "USIGVC2.UCB" ) == 0 )
            memcpy( MachineTypeID, "USIVGC2\0", 9 );
        else if ( dosfs_findFile( "MERCHA6.UCB" ) == 0 )
            memcpy( MachineTypeID, "MERCHA6\0", 9 );
        else if ( dosfs_findFile( "VED1000.UCB" ) == 0 )
            memcpy( MachineTypeID, "VED1000\0", 9 );  
        else if ( dosfs_findFile( "VEILCM.UCB" ) == 0 )
            memcpy( MachineTypeID, "VEILCM\0\0", 9 );        
    }

    __disable_interrupt();
    WriteScratchpadDS2431( (unsigned char *)MachineTypeID, 0, 8);
    CopyScratchpadDS2431( 0 );
    ReadIDDS2431( );
    __enable_interrupt();
    return TRUE;
}                                               //  programMachineType




/*--------------------------------------------------------------------------
 | checkMachineType:verify type of machine programmed
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/
const char  VMCManufacturer[] = { "VEI" };  // see DEX file
char  VMCSerial[13];
char  VMCModel[13];
char  VMCSwRevision[3];

BOOL            checkMachineType( void )
{    
    char k;    
#if RSR903
    machineType = MACHINA_VEIDOOR;
    return TRUE;     
#endif
    VED1000_en = FALSE; 
    ReadIDDS2431( );    
    SubMachineType = 0;
    ////// select machine type
    if( strcmp( MachineTypeID, "NAT147") == 0 ) machineType = MACHINA_NAT147;
    else if( strcmp( MachineTypeID, "AP113"   ) == 0 ) machineType = MACHINA_AP113;
    else if( strcmp( MachineTypeID, "ROWE5900") == 0 ) machineType = MACHINA_ROWE5900;
    else if( strcmp( MachineTypeID, "ROWE6800") == 0 ) machineType = MACHINA_ROWE6800;
    else if( strcmp( MachineTypeID, "NAT157"  ) == 0 ) machineType = MACHINA_NAT157;
    else if( strcmp( MachineTypeID, "AP7000"  ) == 0 ) machineType = MACHINA_AP7000;
    else if( strcmp( MachineTypeID, "LCM123"  ) == 0 ) machineType = MACHINA_LCM123;
    else if( strcmp( MachineTypeID, "AP123"   ) == 0 ) machineType = MACHINA_AP123;
    else if( strcmp( MachineTypeID, "VEI-DOOR") == 0 ) machineType = MACHINA_VEIDOOR;
    else if( strcmp( MachineTypeID, "NAT145"  ) == 0 ) machineType = MACHINA_NAT145;
    else if( strcmp( MachineTypeID, "AMS39"   ) == 0 ) machineType = MACHINA_AMS39;
    else if( strcmp( MachineTypeID, "VEI147"  ) == 0 ) machineType = MACHINA_VEI147;
    else if( strcmp( MachineTypeID, "USIGVC2"  ) == 0 ) machineType = MACHINA_USIGVC2;
    else if( strcmp( MachineTypeID, "MERCHA6"  ) == 0 ) machineType = MACHINA_MERCHA6;
    else if( strcmp( MachineTypeID, "VED1000"  ) == 0 ) {
                                                        machineType = MACHINA_VEI147; 
                                                        VED1000_en = TRUE;   
    }
    else if( strcmp( MachineTypeID, "VEILCM"  ) == 0 ) machineType = MACHINA_VEILCM;
    else {
        machineType = MACHINA_UNKNOWN;
        return FALSE;
    }

    memset( VMCModel, 0x00, sizeof( VMCModel ));
    memcpy( VMCModel, MachineTypeID, 9 );
    for( k = 0; k < 12; k++ )
    {
        if( VMCModel[k] == 0 ) VMCModel[k] = ' ';
    }
    
    memset( VMCSerial, ' ', sizeof( VMCSerial ));
    memcpy( &VMCSerial[4], &SerialID[8], 9 );
#ifndef BOOT
    VMCSwRevision[0] = fwRelease[1];    
    VMCSwRevision[1] = fwRelease[2];    
    VMCSwRevision[2] = 0x00;    
#endif    
// test for Tok_TAKE    machineType = MACHINA_LCM123;
    ledMaskInitialization(machineType);
    return TRUE;
}                                               //  checkMachineType




/*--------------------------------------------------------------------------
 | checkTimeFrames:check if selection time locked
 |                              --------------
 | In:  _tray, _column      selection position
 | Out: TRUE    selection in timeframes
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/
byte            testTimeLockout( byte group );

BOOL            checkTimeFrames( byte _tray, byte _column )
{
    byte        i, j, dd;
    struct _TIMEFRAMES_ *p;
    
    dd = dateTime_weekDay;//weekDay( dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.min );

    j = _tray*10 + _column;
    for ( i = 0; i < MAXTIMEFRAMES; i++ )
    {
        p = &timeFrames[i];
        if ( p->weekDay != 0 && p->weekDay != dd )
            continue;
        if ( dateTime.hour < p->disable.hour )
            continue;
        if ( dateTime.hour == p->disable.hour && dateTime.min < p->disable.min )
            continue;
        if ( dateTime.hour > p->enable.hour )
            continue;
        if ( dateTime.hour == p->enable.hour && dateTime.min > p->enable.min )
            continue;
                                        // time is within range check group
        
        if ( p->group < MAXselGROUP )
        {            
            if ( group[_SEL_TIMEFRAMES].info[j] == p->group && group[_SEL_TIMEFRAMES].info[j] != 0)
                return TRUE;
        }
        else
            continue;        
    }

    if ( group[_SEL_LOCKOUT].info[j] == 0 || group[_SEL_LOCKOUT].info[j] > MAXTIMEDISABLE )    
        return FALSE;
    else                               // group found, check which selection to activate
        return( testTimeLockout( group[_SEL_LOCKOUT].info[j]+MAXTIMEDISABLE-1 ) == FALSE );   // see function edDisableLx in menu.c will assign group 5-9 to time 0-4
}                                               //  checkTimeFrames




/*--------------------------------------------------------------------------
 | selectionLocked:check if selection available or locked by exaust selection or health temperature problem
 |                              --------------
 | In:  _tray, _column      selection position
 | Out: TRUE    selection not available
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/

BOOL            selectionLocked( byte _tray, byte _column )
{
    byte j;
    
    if ( checkCoupling(_tray, _column) == TRUE)
        return TRUE;                    // only even selection if motor coupled
    if (checkNotConsecutiveCoupling(_tray, _column, 0) == TRUE)
        return TRUE;
    if ( nF.nFails[_tray][_column] >= MAX_SEL_FAILED &&
        ( enDrop[_tray][_column] == FALLSENSOR_3x ||
          enDrop[_tray][_column] == FALLSENSOR_3r ) )
        return TRUE;
    
    if ( machineType != MACHINA_AMS39 && machineType != MACHINA_USIGVC2  && machineType != MACHINA_MERCHA6)
        return FALSE;
    
    j = _tray*10+_column;
    if ( group[_SEL_HEALTH].info[j] == 0 && HealthProblem == HEALTH_FAIL )
        return TRUE;
    
    return FALSE;
}                                               //  selectionLocked




/*--------------------------------------------------------------------------
 | checkMotorGroupSelection:verify if the selection is a part of a group and
 |              change automatically from the group
 |                              --------------
 | In:  _tray, _column      selection position
 | Out:
 +--------------------------------------------------------------------------*/

void            checkMotorGroupSelection( byte *_tray, byte *_column, byte _update )
{
    byte        i, j, l, n, k, an;
    byte        s_tray, s_column;

    i = *_tray*10+*_column;
    if ( group[_SEL_UPFRONT].info[i] != 0 && group[_SEL_UPFRONT].info[i] != 0xff )
    {                           // group found, check which selection to activate                                
        for ( l = idxGroup[i], n = 0; n < MAXselGROUP; n++ )
        {                                       
            if (group[_SEL_UPFRONT].info[l] == group[_SEL_UPFRONT].info[i])
            {
                s_tray = (l/10)+1;
                s_column = (l%10)+1;
                
                if ( s_tray != 0 && s_column != 0 && s_tray != 0xFF && s_column != 0xFF )
                {
                    s_tray--;
                    s_column--;
                                    // check motor presence ...
                    if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    {
                        GET_ACTIVE_MOTOR(k,an, s_column,s_tray);
                    }
                    else
                    {
                        GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                    }
                    if ( k == 99 || motorMap[k][an] == 0 )
                    {                   // motor not present
                        l++;
                        if ( l >= MAXEntriesGroupSel )
                            l = 0;
                        continue;
                    }
    
                    if ( !checkTimeFrames( s_tray, s_column ) )
                    {
                        if ( !selectionLocked(s_tray,s_column) )
                        {                   // selection found, ok
                            if (_update == 0x01 )
                            {
                                l++;
                                if ( l >= MAXselGROUP )
                                    l = 0;
                                for ( j = 0; j < MAXselGROUP; j++ )
                                {
                                    if (group[_SEL_UPFRONT].info[j] == group[_SEL_UPFRONT].info[i])
                                        idxGroup[j] = l;
                                }  
                            }
                            *_tray = s_tray;
                            *_column = s_column;                                                            
                            return;
                        }
                    }
                }
            }
            l++;
            if ( l >= MAXselGROUP )
                l = 0;            
        }
    }
}                                               //  checkMotorGroupSelection




/*--------------------------------------------------------------------------
 | testKey:     read a key
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/

_UCHAR          testKey( void )
{
    if( kbhit() )                 //  TASTIERA
        return (_UCHAR)getKey();
    return 0;
}                                               //  testKey




/*--------------------------------------------------------------------------
 | checkMotorMap:verify motor map
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/
#if RSR903_MDB
void            testSels( void );
#endif

byte            checkMotorMap( void )
{
    byte        k, an, flag, iTray, n_an;
    DWORD       inp, tStartMotor;
    char        buf[20];
    
#if LED_DIMMING
    /* to prevent interaction of LED current with MOTOR current */
    DWORD       saveDimming;
    saveDimming = dutyLED2;
    LED_OFF();
#endif
    
#if RSR903
#if Evolution
    // enable selections from 110 to 159
    memset( motorMap, 0, sizeof(motorMap) );
    for( k = 0; k < 10; k++ )
      for( an = 0; an < 5; an++ )
        motorMap[k][an] = 1;
    motorMap[0][0] = 0;       // 110 disabled
    motorMap[9][4] = 0;       // 159 disabled
//    abilRemap[MAC][l][an]
#else
    memset( motorMap, 1, sizeof(motorMap) );
#endif
    machineMotor = machineType;
    return 1;
#endif

    lpdMode(0);
    getFirmwareRelease( buf );
    DispStr( 0, 0, buf );
    Delay(1000);

    inp = 0xFF;
    initialInp = inp;
    memset( motorMap, 0, sizeof(motorMap) );
    machineMotor = machineType;
    if( machineType == MACHINA_MERCHA6 )
      n_an = N_AN_MERCHA6;
    else
      n_an = N_AN_NAT147;

    k = 0;
    an = 0xFF;
    PWR_EN_ON();
    for ( ;; )
    {
        STOP_MOTORS();
#ifndef __WIN32__
        Delay(10);
#endif
        PWR_EN_ON();

        // attivando solo i catodi attivo INP0, INP2 in NAT147
        ATTIVA_CATODO( k );
        
        testMotorPresence = 0;
        if ( an != 0xFF )
        {
#ifndef __WIN32__
            Delay(50);
#endif
            __disable_interrupt();
            ATTIVA_ANODO( an );
            if ( machineType == MACHINA_NAT145  || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || 
                 machineType == MACHINA_AP113   || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || 
#if TOK_TAKE
                 machineType == MACHINA_VEIDOOR ||                                  machineType == MACHINA_VEI147 || 
#else
                 machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39  || machineType == MACHINA_VEI147 || 
#endif
                 machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM)
            {
//mmm
//                testMotorPresence = 1;//must be after START_MOTOR
                testMotorPresence = 2;
                testMotorHoming = 2;
            }
            __enable_interrupt();
        }

#if HOME_DEBUG//99=check motor map
        commPutChar( COMM1, 0x99 );
        commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
#ifndef __WIN32__
        Delay(4);
#endif
                                        // scansione anodi e catodi
        if ( an == 0xFF )
        {                           // test tray presence
            if ( machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 )
            {
                if ( INP0 == 1 && INP2 == 1 )
                {                   // no tray connected
                    for ( an = 0; an < n_an; an++ )
                        motorMap[k][an] = 0;
                    an = 0xFF;
                    k++;
                    if ( k >= N_K_NAT147 )
                        break;
                }
                else                // at least one motor connected on this tray
                    an = 0;         // start scan for motors connected
            }
            else
                an = 0;
        }
        else
        {                           // verifica presenza motori
            if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || 
#if TOK_TAKE
                 machineType == MACHINA_VEIDOOR                                 )
#else
                 machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 )
#endif
            {
                if ( IS_PWR_OFF() ) //if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( ( machineType == MACHINA_AMS39 && an >= N_AN_AMS39 ) ||
                     ( machineType != MACHINA_AMS39 && an >= N_AN_AP113 ) )
                {
                    an = 0;
                    k++;
                    if ( k >= N_K_AP113 )
                        break;
                }
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_USIGVC2 )
            {
                if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( an >= N_AN_ROWE  )
                {
                    an = 0;
                    k++;
                    if ( k >= N_K_ROWE )
                        break;
                }
            }
#if TOK_TAKE
            else if ( machineType == MACHINA_AMS39 )
#else
            else if ( machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM )
#endif
            {
                if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( an >= N_AN_LCM123  )
                {
                    an = 0;
                    k++;
#if TOK_TAKE
                    if ( k == 11 ) k++;
                    if ( k >= 14 )
#else
                    if ( k >= N_K_LCM123 )
#endif
                        break;
                }
            }
            else // machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 
            {
/**/
                if ( IS_PWR_OFF() ) 
                {
                    motorMap[k][an] = 1;
#if HOME_DEBUG//91=motor map=1
                    commPutChar( COMM1, 0x91 );
                    commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                }
                else
                {
#if HOME_DEBUG//90=motor map=0
                    commPutChar( COMM1, 0x90 );
                    commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                }
                an++;
                if ( an >= n_an )
                {
                    an = 0xFF;
                    k++;
                    if ( k >= N_K_NAT147 )
                        break;
                }
            }
        }
    }
   
    STOP_MOTORS();
       
    testMotorPresence = 0;

#if MOTOR_SIMULATION == 1
    memset( motorMap, 1, sizeof(motorMap) );
#endif
// 06.2012 #if FULL_MOTOR
// 06.2012     memset( motorMap, 1, sizeof(motorMap) );
// 06.2012 #endif

                                        // try to identify NAT145 from NAT146
    if ( machineType == MACHINA_NAT145 )
    {                                   // change machine type to 10 wide        
        flag = 0;
        for ( iTray = 0; iTray <= 5;iTray++ )
        {
            PWR_EN_ON();
            GET_ACTIVE_MOTOR(k,an, iTray,0);// test tray last position
            if ( testIfMotorAvailable(k,an) )
            {
                machineMotor = TOTAL_MACHINE;   // 5/10 wide NAT145
                flag = 1;
                break;
            }
            PWR_EN_ON();
            GET_ACTIVE_MOTOR(k,an, iTray,9);// test tray last-1 position
            if ( testIfMotorAvailable(k,an) )
            {
                machineMotor = TOTAL_MACHINE;   // 5/10 wide NAT145
                flag = 1;
                break;
            }
        }
        if ( flag == 0 )
        {                                   // 4/ 8 wide NAT146
            for ( k = 0; k < N_K_MAX; k++ )
                motorMap[k][0] = 0;
        }
    }

#if LED_DIMMING
    dutyLED2 = saveDimming;
#endif
    lpdMode(1);
    tStartMotor = tStartMotor;

                                        // count motors found
    iTray = 0;
    for ( k = 0; k < N_K_MAX; k++ )
    {
        for ( an = 0; an < N_AN_MAX; an++ )
        {
             if ( motorMap[k][an] )
                iTray++;
        }
    }
    
    if( machineType == MACHINA_VEIDOOR && iTray < 10 && motorMap[9][2] == 1 )
    {
      iTray = 9; // Dixie501e
      SubMachineType = SUB_DIXIE501E;
      motorMap[0][0] = 1;
      motorMap[1][0] = 1;
      motorMap[2][0] = 1;
      motorMap[3][0] = 1;
      motorMap[4][0] = 1;
      motorMap[5][0] = 1;
      motorMap[6][0] = 1;
      motorMap[7][0] = 1;
      motorMap[8][0] = 1;
      motorMap[9][2] = 0;
      machineMotor = SUB_DIXIE501E;
    }
    sprintf( buf, " OUTPUT TOT.:%3d", iTray );
    DispStr(0,0,buf);
    Delay(1000);
    DispStr( 0, 0, (char *)MSG_ATTESA );
    
#if RSR903_MDB
    testSels( );
#endif
      
    return 1;
}                                               //  checkMotorMap




/*--------------------------------------------------------------------------
 | testIfMotorAvailable:check motor availability
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/

byte            testIfMotorAvailable( byte _k, byte _an )
{
#if MOTOR_SIMULATION == 1
    return 1;
#else//MOTOR_SIMULATION
#if FULL_MOTOR
    return 1;
#endif
    byte        avail = 1;
    DWORD       tStartMotor;

    if ( machineType == MACHINA_NAT145 )
    {                                   // use AP113 method to verify motor availability
        PWR_EN_ON();
    }

    STOP_MOTORS();
#ifndef __WIN32__
    Delay(10);
#endif

    // attivando solo i catodi attivo INP0, INP2 in NAT147/NAT157
    ATTIVA_CATODO( _k );

    testMotorPresence = 0;
#ifndef __WIN32__
    Delay(50);
#endif
    __disable_interrupt();
    ATTIVA_ANODO( _an );
    
#if HOME_DEBUG//44=home motor test
    commPutChar( COMM1, 0x44 );
    commPutChar( COMM1, ((_k&0x0f)<<4)|(_an&0x0f) );
#endif
    
    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || 
         machineType == MACHINA_AP113  || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || 
#if TOK_TAKE
                                          machineType == MACHINA_MERCHA6 ) // DEBUG da verificare AMS39 e
#else
         machineType == MACHINA_AMS39  || machineType == MACHINA_MERCHA6 ) // DEBUG da verificare AMS39 e
#endif
    {
        testMotorPresence = 1;//must be after START_MOTOR     
        testMotorHoming = 2;
    }
    __enable_interrupt();


#ifndef __WIN32__
    Delay(4);
#endif
    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || 
#if TOK_TAKE
         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR                                 )
#else
         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 )
#endif
    {
        if ( IS_PWR_OFF() )
            avail = 1;
        else
            avail = 0;
    }
#if TOK_TAKE
    else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM || machineType == MACHINA_USIGVC2 || machineType == MACHINA_AMS39)
#else
    else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM || machineType == MACHINA_USIGVC2)
#endif
    {
        if ( AD.conv[AD_I_MOTORS] > 20 )
            avail = 1;
        else
            avail = 0;
    }
    else // machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 
    {
        if ( IS_PWR_OFF() )
            avail = 1;
    }
    STOP_MOTORS();
#ifndef __WIN32__
    Delay(3);
#endif
    PWR_EN_ON();
    testMotorPresence = 0;
    testMotorHoming = 0;
#ifndef __WIN32__
    Delay(10);
#endif

    tStartMotor = tStartMotor;
    return avail;
#endif//MOTOR_SIMULATION
}                                               //  testIfMotorAvailable




/*--------------------------------------------------------------------------
 | readMotorAvailability:verify if motor it's present or not
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            readMotorAvailability( byte _tray, byte _column )
{
    byte        k, an;
    
    GET_ACTIVE_MOTOR(k,an, _tray,_column);        
    if ( motorMap[k][an] == 0 )      
        return FALSE;  
    if ( checkCoupling(_tray, _column) == TRUE)
        return FALSE;
    if (checkNotConsecutiveCoupling(_tray, _column, 0) == TRUE)
        return FALSE;
    return TRUE;
}                                               //  readMotorAvailability




/*--------------------------------------------------------------------------
 | vendingCycle:verify if vending cycle
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            vendingCycle( void )
{
    return (stopInt == 1);
}                                               //  vendingCycle




/*--------------------------------------------------------------------------
 | programmingMode:verify if vending cycle
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            programmingMode( void )
{
    return inProgramm;
}                                               //  programmingMode




/*--------------------------------------------------------------------------
 | isTimedDisable:verify if machine disabled depending on timing
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

struct _DAY_TIME_ {
    word    val;
    byte    en;
};

static void     insTime( struct _DAY_TIME_ *_p, word _val, byte _en )
{
    byte        t;

    for ( t = 0; t < MAXTIMEDISABLE*2; t++, _p++ )
    {
        if ( _val < _p->val )
        {
            memmove( _p+1, _p, sizeof(struct _DAY_TIME_)*(MAXTIMEDISABLE*2-t-1) );
            _p->val = _val;
            _p->en  = _en; 
            return;
        }
    }
}

static word     convTime( byte _hour, byte _am_pm, byte _min )
{
    if ( _hour == 12 )
    {
        if ( _am_pm == 0 )
            return          _min;// morning, midnight
        else
            return _hour*60+_min;// afternoon, noon
    }
    return ((_hour+_am_pm)*60)+_min;
}

static BOOL     weekTestTimeDisable( byte abil, byte _weekDay, struct _TIMEDISABLE_ *ptimeDisable, byte numgroups )
{
    byte        d, e, j;
    word        actualTime, disTime, enTime;
    struct _TIMEDISABLE_ *pTd;
    struct _DAY_TIME_ dayTime[MAXTIMEDISABLE*2];

    if ( _weekDay >= 7 )
        e = 7;
    else
        e = _weekDay;
    
    for ( d = 0; d < e; d++ )           // find enables of the week
    {
        for ( j = 0, pTd = ptimeDisable; j < numgroups; j++, pTd++ )
        {
//            pTd = &timeDisable[j];
            if ( pTd->disable.weekDay > EVERYDAYS || pTd->disable.hour == 0 || pTd->disable.hour > 12 || pTd->disable.min > 59 )
                continue;           // time not set
            enTime = 0xFFFF;
            disTime = 0xFFFF;
            if ( (pTd->disable.weekDay == d                 ) ||
                 (pTd->disable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->disable.weekDay == EVERYDAYS         ) )
                disTime = convTime(pTd->disable.hour,pTd->disable.am_pm,pTd->disable.min);
            if ( (pTd->enable.weekDay == d                 ) ||
                 (pTd->enable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->enable.weekDay == EVERYDAYS         ) )
                enTime  = convTime(pTd->enable.hour, pTd->enable.am_pm, pTd->enable.min );
            
            if ( disTime == 0xFFFF && enTime == 0xFFFF )
                ;                       // no time variation
            else if ( disTime == 0xFFFF )
                abil = TRUE;            // enable sometimes
            else if ( enTime == 0xFFFF )
                abil = FALSE;           // disable sometimes
            else if ( disTime > enTime )
                abil = FALSE;           // disable at the end of the day
            else
                abil = TRUE;            // enable at the end of the day
        }
    }
    if ( _weekDay != 0xFF )
    {
        memset( &dayTime[0], 0xFF, sizeof(dayTime) );
        for ( j = 0, pTd = ptimeDisable; j < numgroups; j++, pTd++ )
        {
//            pTd = &timeDisable[j];
            if ( pTd->disable.weekDay > EVERYDAYS || pTd->disable.hour == 0 || pTd->disable.hour > 12 || pTd->disable.min > 59 )
                continue;           // time not set
            enTime = 0xFFFF;
            disTime = 0xFFFF;
            if ( (pTd->disable.weekDay == d                 ) ||
                 (pTd->disable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->disable.weekDay == EVERYDAYS         ) )
                disTime = convTime(pTd->disable.hour,pTd->disable.am_pm,pTd->disable.min);
            if ( (pTd->enable.weekDay == d                 ) ||
                 (pTd->enable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->enable.weekDay == EVERYDAYS         ) )
                enTime  = convTime(pTd->enable.hour ,pTd->enable.am_pm, pTd->enable.min );
            if ( disTime != 0xFFFF )
                insTime(&dayTime[0],disTime,0);
            if ( enTime != 0xFFFF )
                insTime(&dayTime[0],enTime,1);
        }
        
        actualTime = (dateTime.hour*60) + (dateTime.min);
        for ( j = 0; j < MAXTIMEDISABLE*2; j++ )
        {
            if ( dayTime[j].val == 0xFFFF || dayTime[j].en == 0xFF )
                break;
            if ( dayTime[j].val > actualTime )
                break;
            abil = dayTime[j].en;
        }
    }
    return abil;    
}

void            testTimeDisable( void )
{
    byte        abil;

    abil = TRUE;                        // start with enabled
    abil = weekTestTimeDisable( abil, 0xFF, &timeDisable[0], MAXTIMEDISABLE );
    abil = weekTestTimeDisable( abil, ((dateTime_weekDay>1)?(dateTime_weekDay-1):0), &timeDisable[0], MAXTIMEDISABLE );

    flagTimeDisable = abil;
}                                               //  testTimeDisable

BOOL            isTimedDisable( void )
{
    return (flagTimeDisable==FALSE);
}                                               //  isTimedDisable

byte            testTimeLockout( byte group )
{
    byte        abil;

    abil = TRUE;                        // start with enabled
    abil = weekTestTimeDisable( abil, 0xFF, &timeDisable[group], 1 );
    abil = weekTestTimeDisable( abil, ((dateTime_weekDay>1)?(dateTime_weekDay-1):0), &timeDisable[group], 1 );
    return( abil );
}



/*--------------------------------------------------------------------------
 | setLedDimming:set led dimming mask, genera segnale PWM uniformemente distrubuito
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

dword           setLedDimming( dword percDimming )
{
#if LED_DIMMING
    byte        i;
    dword     acc, dim;

    dim = 0x00000000; 
    if ( percDimming > 95 )
        dim = 0xFFFFFFFF;
    else if ( percDimming != 0 )
    {
        for ( i = 0, acc = 0; i < 32; i ++ )
        {
            dim <<= 1;
            acc += percDimming;
            if( acc >= 100 )
            {
                acc = acc - 100;
                dim++;
            }
        }
    }
    return( dim );
#else
    return( 0 );
#endif
}                                               //  setLedDimming




/*--------------------------------------------------------------------------
 | testSaveSettings:verify save setting conditions
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            testSaveSettings( void )
{
    if ( exeSaveSettings == 1 )
    {                               // save changed settings on main
        exeSaveSettings = 0;
        saveAmount();
        saveGroup();
        saveSettings();
    }
}                                               // testSaveSettings




/*--------------------------------------------------------------------------
 | currencyStr: convert currency value to string
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

char            *currencyStr( _Credito _money, byte _size )
{
    static char strCurr[16];

    if ( posVirgola == 2 )
        sprintf( strCurr, "%*ld.%02ld", _size-3, _money/100, _money%100 );
    else
        sprintf( strCurr, "%*ld", _size, _money );

    return strCurr;
}                                               // currencyStr

#ifdef BOOT
void getFileExtension(char *_ext, char *_fileName)
{
    while(*_fileName != 0x00)
        _fileName++;
    if(*(_fileName-4) == '.')
        memcpy(_ext, _fileName-3, 3);
    else
        memset(_ext, 0x00, 3);
}

//void memDump(void)
//{
//    char i, c;    
//    char *addr;
//    
//    addr = BOOTSTART;
//    i = 0;
//    do{
//        if((byte)((*addr>>4)&0x0f) >= 0 && (byte)((*addr>>4)&0x0f) <= 9)
//            c = (byte)((*addr>>4)&0x0f)+0x30;
//        if((byte)((*addr>>4)&0x0f) >= 0x0a && (byte)((*addr>>4)&0x0f) <= 0x0f)
//            c = (byte)((*addr>>4)&0x0f)-0x0a+0x41;
//        commPutChar( COMM4, c ); 
//        if((byte)((*addr   )&0x0f) >= 0 && (byte)((*addr   )&0x0f) <= 9)
//            c = (byte)((*addr   )&0x0f)+0x30;
//        if((byte)((*addr   )&0x0f) >= 0x0a && (byte)((*addr   )&0x0f) <= 0x0f)
//            c = (byte)((*addr   )&0x0f)-0x0a+0x41;        
//        commPutChar( COMM4, c ); 
//        commPutChar( COMM4, ' ' ); 
//        if (i == 15 )
//        {       
//            commPutChar( COMM4, 0x0D );
//            commPutChar( COMM4, 0x0A );
//            i = 0;
//        }
//        else 
//            i++;
//
////        commPutChar( COMM4, (byte)(*addr) );
//        Delay(25);
//        addr++;
//    } while (addr < (void*)(0x0000100));
//    commPutChar( COMM4, 0x0D );
//    commPutChar( COMM4, 0x0A );
//    commPutChar( COMM4, 0x0D );
//    commPutChar( COMM4, 0x0A );
//}
#endif //BOOT
/*--------------------------------------------------------------------------
 | main:        main program
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/
//eee
//DWORD testtempo, testimmagine;

#ifdef  __WIN32__
int             mainVEI( void )
#else
int             main( void )
#endif
{
#ifdef BOOT
#ifdef BOOT2
    byte        resp;
    char        fileName[100], ext[3], i, err_chk;
    WORD        cluster;
    DWORD       filelen;   
#else    
    byte        resp, ch, buf[16], rxi;
    char        fileName[100], ext[3], i, err_chk, err_flashCrc, str[32];
    WORD        cluster, flashCrc;
    DWORD       filelen;
    void        (*firmwareEntryPoint)( void );  
#endif    
#else
    byte        kkk, k, an, nread, doorIsOpen, LCDmsg, flag, inpMask, fHomePos;
    byte        alt_k, alt_an;
    byte        s_machine, s_tray, s_column, last_s_tray, last_s_column;
    DWORD       tsinc, tMsgDelay, tStartFall, tTimeoutFall, tStartMotor, tTimeoutMotor, tLCDtimer, tPartialSelection, mask, inp, tEndFall, tHomePos, tTimeoutHomePos;
    DWORD       tReadDate;
    byte        nTestFall;

    _Credito    money, tot;
    char        buf[20];
#endif
    DWORD       tled;
#if ANTI_V
    byte        oldXY;
    DWORD       tiltXY, frontXY, tiltON;
    byte        oldIR;
#endif
#if LED_DIMMING
    DWORD       tiltIR;
#endif

    testMode = 0x00000000;
    flagTimeDisable = 0;
    lastTestTimeDisable = 0xFF;
    lastTestDiscount = 0xFF;
    
    cashless_active_addr = 0xff;
    cashless_idx = 0;
    cashless_disabled = 0xff;
    maxBills = 0;
                                        // select machine, before all
    HardwareInit();
    // DEX - MDB DEBUG port
#ifdef BOOT
    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 );
#else    
  #if MODEM_HTTP
    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
  #else
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
  #endif
#endif    

    // ZIGBEE or SLAVE MDB port
    commCfgPort( COMM2, Baud9600, WordLength8, ParitySelNone, StopBit1 );

    // MicroMech init
#ifndef __WIN32__
    FIO3CLR_bit.P3_26 = 1;   // switch MDB/Micromach to Micromach
#endif

#ifndef BOOT    
    commCfgPort( COMM3, Baud600, WordLength8, ParitySelNone, StopBit1 );
#if MIND_UCB_COMM4
  #if ENABLE_COMM1
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM1 );
  #else
    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM4 );
  #endif
#endif
#if RSR903
    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 ); // MDB Slave
#endif   
    LED_OFF();
    InitSlavesStatus();
    machine_address = GetMachineAddress();
    STOP_MOTORS();
    startCredit();
    money = 0;
    tot = 0;
// 07.02.2011    doorIsOpen = FALSE;
    doorIsOpen = 0xAA;    // 07.02.2011, neither TRUE or FALSE after power on
#endif //BOOT

    switch ( baseLanguage )
    {
        case 1:     message = &textEspana[0];               break;
        default:    message = &textEnglish[0];              break;
    }
    timeBacklight = GetTickCount();
    DisplayBacklighOn();
    DispClrScr();
    LcdErase(TUTTI);
    if ( isprint(vendName[0]) && isprint(vendName[1]) && vendName[0] != '<' && vendName[1] != '<' && vendName[2] != '<' )
        DispStr( 0, 0, (char*)vendName );
    else
        DispStr( 0, 0, (char *)MSG_ATTESA );

    BuzzerOn(500);
#ifdef BOOT
#ifdef BOOT2  
    sprintf( &bufferLCD[0], "BOOT UPDATE     " );
    DispStr( 0, 0, bufferLCD );    
#else    
    strcpy( bufferLCD, &MENU_82[2] );
    sprintf( &bufferLCD[8], "  #%c.%c.%c", release[9], release[10], release[11] );
    DispStr( 0, 0, bufferLCD );
#endif
#endif    

    nPasscode = 0;
#ifndef BOOT    
                                        // memory initialize
    memset( usable,     0xFF, sizeof(usable)    );
    memset( &nF,        0,    sizeof(nF)        );
    memset( enDrop,     0,    sizeof(enDrop)    );
    memset( group,      0,    sizeof(group)     );
    memset( grp_price,  0,    sizeof(grp_price) );
    memset( amount,     0,    sizeof(amount)    );
    memset( idxGroup,   0,    sizeof(idxGroup)  );// da dove prendo questo valore?????
    posVirgola = 0;
#endif //BOOT    
#if ENABLE_DISCOUNT
    memset( sels,       0xFF, sizeof(sels)    );    // DEBUG
#endif

#ifdef TEST
    saveSettings();
    {
extern dword AuditData[AUDIT_DATA_SIZE];
    memset( AuditData,0,  sizeof(AuditData) );
    saveAudit();
    }
#endif
    loadSettings();
#ifndef BOOT
    exeSaveSettings = 0;
    if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 1;
    setContrastLCD( NonVolatileSetup.contrasto_lcd );
#if TESTKEYBOARD == 0
//    mmdRestartAds();
    loadAmount();
    loadGroup();
    loadAudit();
#endif
#else
    if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 1;
    setContrastLCD( NonVolatileSetup.contrasto_lcd );
#endif

//EEE
    posVirgola = DECIMAL_PLACE;
//EEE

//#if 0
//    // DEX - MDB DEBUG port  >>>>>>>>>> spostato sopra >>>>>>>>>>>>>>>>>
//  #if MODEM_HTTP
//    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
//  #else
//    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
//  #endif
//
//    // ZIGBEE port
//    commCfgPort( COMM2, Baud9600, WordLength8, ParitySelNone, StopBit1 );
//
//    // MicroMech init
//#ifndef __WIN32__
//    FIO3CLR_bit.P3_26 = 1;   // switch MDB/Micromach to Micromach
//#endif
//    commCfgPort( COMM3, Baud600, WordLength8, ParitySelNone, StopBit1 );
//#if MIND_UCB_COMM4
//  #if ENABLE_COMM1
//    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
//    hostInit( COMM1 );
//  #else
//    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 );
//    hostInit( COMM4 );
//  #endif
//#endif
//#endif

#ifdef TEST
#ifdef BASE_BOARD_SELECTION
    //############# 
    char en_inc;
    
    PINMODE3 = 0x30C00000;// 00110000 11000000 00000000 00000000
    
    const char * const machineModel[TOTAL_MACHINE+1] = {  
                                       "ROWE6800",
                                       "ROWE5900",
                                       "NAT147\0\0",
                                       "AP113\0\0\0",
                                       "NAT157\0\0",
                                       "AP7000\0\0",
                                       "LCM123\0\0",
                                       "AP123\0\0\0",
                                       "VEI-DOOR",
                                       "NAT145\0\0",
                                       "AMS39\0\0\0",
                                       "VEI147\0\0",
                                       "USIGVC2\0",
                                       "MERCHA6\0",
                                       "VED1000\0",
                                       "VEILCM\0\0"
    };
    k = 0;
    en_inc = FALSE;
    do {
        if (IO1PIN_bit.P1_27 == FALSE)
            en_inc = TRUE;
        if (en_inc == TRUE) 
        {
            if (IO1PIN_bit.P1_27 == TRUE)
            {
                en_inc = FALSE;
                BuzzerOn(100);
                if (k < TOTAL_MACHINE)
                    k++;
                else
                    k = 0;
            }
        }      
        DispStr( 0, 0, (char*)machineModel[k] );
    } while( IO1PIN_bit.P1_30 == FALSE );
    BuzzerOn(500);    
    memcpy( MachineTypeID, machineModel[k], 9 );
#endif    
    programMachineType();
    do {
        getFirmwareRelease( buf );
        DispStr( 0, 0, buf );
        Delay(1000);
        BuzzerOn(100);
        DispStr( 0, 0, " HW REL. FORCED " );
        Delay(1000);
        
        checkMachineType();
        for( i = 0; i < machineType; i++ )
        {
            IO1CLR_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
            Delay(400);
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
            Delay(400);
        }
        
    } while(-1);
#endif


#ifdef BOOT

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
////////////// boot loader (firmware upgrade, program launch) ////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//rego:;// provare senza MMC !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! o file errati  
    Delay(500);
    err_chk = 0;
#ifndef BOOT2
    err_flashCrc = FALSE;    
    flashCrc = calcBootloaderCrc();   
    if ( flashCrc != (  ( ((WORD)(*((byte *)BOOTEND-1))) <<8 )  +  ((WORD)(*((byte *)BOOTEND)))  ) )   
        err_flashCrc = TRUE;
#endif    
    if ( mmcInit() == mmc_noerr )
    {                
        FAT_init();
        for ( i = 1; i <= 250; i++ )
        {
            resp = FAT_getFileName( i, fileName, &cluster, &filelen );
            getFileExtension(ext, fileName);
            if ( resp == 3 )
                continue;
            if ( resp != 0 )
                break;
#ifdef BOOT2 
            if ( memcmp(fileName,"RSR641BOOTCHK", 13) == 0 && memcmp(ext,FIRMWAREFILEEXTENSION, 3) == 0)
#else                                    
            if ( memcmp(fileName,FIRMWAREFILENAME, 8) == 0 && memcmp(ext,FIRMWAREFILEEXTENSION, 3) == 0)
#endif                
            {                
retryMmcDownload:;                
                DispStr( 0, 0, (char *)MSG_FW_LOADING );
                NonVolatileSetup.downloadStatus = flashIntelFile( cluster, filelen );
                saveSettings();
                switch ( NonVolatileSetup.downloadStatus )
                {
                    case 0:     DispStr( 0, 0, (char *)MSG_FW_LOADED );                                     
                                break;
                    case 1:     DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
                                break;
                    case 2:     DispStr( 0, 0, (char *)MSG_FW_FILE_FORM );
                                break;                    
                    case 3:     DispStr( 0, 0, (char *)MSG_FW_SIZE_ERR );
                                break;                    
                    case 4:     DispStr( 0, 0, (char *)MSG_FW_CHK_ERR );                                
                                BuzzerOn(100);
                                Delay(500);
                                BuzzerOn(100);
                                err_chk++;
                                Delay(2000);
                                if (err_chk < 3)
                                    goto retryMmcDownload; 
                                break;                                
                    case 99:    DispStr( 0, 0, (char *)MSG_FW_OK );                                               
                                break;
                    default:    DispStr( 0, 0, (char *)MSG_FW_FLASH_FILE ); break;
                }                
                break;
            }
        }
    }
#ifndef BOOT2    
launch:;
                              // if a good firmware, jump on it      
    switch(NonVolatileSetup.downloadStatus)
    {
        case FW_DWN_REQ:
            goto serialDownloadReq;
        case FW_DWN_FAIL:
            goto serialDownloadStart;     
    }
    if ( (checkFirmware() == 0) && (err_flashCrc == FALSE || memcmp((byte *)0x8080, "BOOT UPDATE     ", 16) == 0) && (err_chk < 3))
    {
                              // if a good firmware, jump on it      
        __disable_interrupt();       
        firmwareEntryPoint = (void (*)())FIRMWARESTART;             
        (*firmwareEntryPoint)();
    }      
    else {
        DispStr( 0, 0, (char *)MSG_FW_CHK_ERR );
serialDownloadStart:;          
        while ( 1 )
        {          
            while (commGetChar(COMM4,&ch) == COMM_RX_EMPTY);
            if ( ch == STX )
            {
               rxi = 0;
               memset(buf, 0x00, sizeof(buf));
            }
            if ( (rxi+1) < sizeof(buf) )
                buf[rxi++] = toupper(ch);
            buf[rxi] = '\0';
            if ( (ch == '\x0A') && rxi > 2 ) 
            {
                if ( memcmp(&buf[1],"BOOT STATUS?\x0D\x0A",14) == 0 ) 
                {
                    commPutChar( COMM4, STX );
                    sprintf(str, "BOOT STATUS %03d\x0D\x0A\x00", NonVolatileSetup.downloadStatus);
                    commPutStr( COMM4, (byte*)str );
                }                
                if ( memcmp(&buf[1],"LOAD?\x0D\x0A",7) == 0 )
                {  
                    BuzzerOn(500);
serialDownloadReq:;  
                    NonVolatileSetup.downloadStatus = FW_DWN_FAIL;
                    saveSettings();
                    NonVolatileSetup.downloadStatus = serialFlashIntelFile();
                    saveSettings();
                    switch ( NonVolatileSetup.downloadStatus )
                    {
                        case 0:     DispStr( 0, 0, (char *)MSG_FW_LOADED );
                                    goto launch;
                        case 2:     DispStr( 0, 0, (char *)MSG_FW_FILE_FORM );                            
                                    break;
                        case 4:     DispStr( 0, 0, (char *)MSG_FW_CHK_ERR );                           
                                    break;
                    }                    
                }
            }
        }
    }
#endif    
                                        // else error
    while( 1 )
    {
                                        // LED blinking
        tled = GetTickCount()%400;
        if ( tled < 200 )
        {                                   // off
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else
        {                                   // red
            IO1CLR_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
    }

#else//BOOT

    
    stopInt = 1;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
////////////////////////// main program //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#ifndef __WIN32__
    DispStr( 0, 0, (char *)vendName );
    Delay(500);
    getFirmwareRelease( buf );
    DispStr( 0, 0, buf );
#endif

#if BOARDTEST
    //#########################################################################
    testBoard();
#endif    
    
    keyStart();//stopInt = 0;
#ifndef __WIN32__
    Delay(500);                         // set maximum A/D value

    IO1SET_bit.P1_25 = 1;
    IO1CLR_bit.P1_26 = 1;
#endif

//////////////////////////////////////////////////////////////////////////////
// verify motor map reading back current

    checkMotorMap();
/*####################################################
    do {
    checkMotorMap();
    i = 0;
    memset( buf, '0', 16 );
    for( k = 0; k < N_K_MAX; k++ )
      for( an = 0; an < N_AN_MAX; an++ ) {
        if( motorMap[k][an] ) {
          buf[i++] = ( k > 10 ) ? k - 10 + 'A': k+'0';
          buf[i++] = an + '0';
          buf[i++] = ' ';
        }
      }
    sprintf( buf+13, "%03d", AD.conv[AD_2] );
    DispStr( 0, 0, buf );
    while( !doorOpen() );
    } while( i != 0 );
 ####################################################*/
        
    ChangerSetTubeValue();
    
//////////////////////////////////////////////////////////////////////////////
// product selection
    lpdInit();
    lpdRecalc();
    resetAdv();
    initMdbError();
    initExactChangeInserEvent();             
//    mmdRestartAds();
//eee
//    testtempo = GetTickCount();


    tTimeoutMaxMotor = tMaxMotor[machineMotor].tTimeout;
    
    if (VED1000_en == TRUE) 
        tTimeoutMaxMotor = tMaxMotor[MACHINA_VED1000].tTimeout;
    
    SET_SELECTION_STATUS(SELECTION_NO);
    
    k = 0xFF;
    an = 0xFF;
    s_machine = 0xFF;
    s_tray = 0xFF;
    s_column = 0xFF;
    inp = 0;
    initialInp = inp;
    tsinc = 0;
    tMsgDelay = 0;
    nread = 0;
    nfront = 0;
    testVend = 0;
    tTimeoutFall = tTimeoutMaxMotor + 1000; tStartFall = 0;
    tTimeoutMotor = tTimeoutMaxMotor;

    timeOFF = 0L;
    if(  enTEMP( 0 ) == 0 ) 
    {
      timeOFF = testTimeOff( );
      {
          sprintf( buf, " timeoff %4dh%02d", timeOFF/60, timeOFF%60 );
          DispStr(0,0,buf);
      }   
    }
    recvDate(&dateTime);
    tReadDate = GetTickCount();
    InsertEvent( EVENT_POWER_UP, 0 );
    tLCDtimer = GetTickCount(); LCDmsg = 0;
    tPartialSelection = 0;
    inProgramm = FALSE;

    if ( doorOpen() )
        cash = 0;
                                        // loop main sempre eseguito
#if ANTI_V
    tiltXY = 0;
    frontXY = 0;
    tiltON = 0;
    oldIR = ((IO1PIN & BIT23)!=0x00) ? 1 : 0;
#endif
#if LED_DIMMING
    tiltIR = 0;

    dutyLEDDefault = 0xFFFFFFFF;        // set by PC, default is full intensity
    LED_FULL_ON();
#endif
    oldProxSensor = PROX_SENSOR();
    deltaProxSensor = 0;

    testMMCpresence();
    BuzzerOn(500);

#if ENABLE_COMM1
#else
 #if MODEM_HTTP
    if ( !modemVerify() )
    {
        commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    }
    else
    {
        DispStr(0,0,"  MODEM READY   ");
        Delay(1000);
    }
    if ( zigbeeTest(COMM2) == 0 )
    {
        DispStr(0,0,"  ZIGBEE READY  ");
        Delay(1000);
    }
 #endif
#endif
    
#if MOTOR_SIMULATION == 1
    BuzzerOn(500);
    DispStr(0,0," MOTOR SIMULATOR");
    Delay(2000);
#endif
#if MDB_DEBUG
    BuzzerOn(500);
    DispStr(0,0,"--MDBline DEBUG-");
    Delay(2000);
#endif
#if MIND_UCB_COMM4
//    BuzzerOn(500);
//    DispStr(0,0,"--MIND-UCB-COMM-");
//    Delay(2000);
#endif

                                        // check versions
    InitGestioneMenu();
    if ( NonVolatileSetup.setupVersion != SETUP_VERSION )
    {
        k = 0;
        an = edToggle( &k, 0, 1, (char *)MENU_NEWFWn, (char *)MENU_NEWFWy );
        if ( an == K_OK && k == 1 )
            menuInitialization(0);
        if ( NonVolatileSetup.setupVersion != SETUP_VERSION )
            saveSettings();
    }

                                        // >>>>>>>>>>>>>>>>>>>>>>>>>>>>> MAIN LOOP
    PWR_EN_ON();
    while( 1 )
    {
        mmcLogData();                   // log data on mmc if available
        lpdMode(1);
        lpdUpdate();
        GetMasterSlavesMaxPrice();
#if ANTI_V
        i =  ((IO1PIN & (BIT29|BIT30))!=0x00) ? 1 : 0;
        if ( i != oldXY )
        {
            oldXY = i;
            frontXY++;
            tiltXY = GetTickCount();
        }
        else
        {
            if ( tiltXY != 0 && (GetTickCount()-tiltXY) > 500 )
            {
                if ( frontXY >= 2 )
                {
                    outImage[OUT_COIN_BILL] = 0x00;// attiva uscita
                    BuzzerOn(10);
                    tiltON = GetTickCount();
                }
                frontXY = 0;
                tiltXY = 0;
            }
        }
        if( tiltON != 0 && (GetTickCount()-tiltON) > 1000 )
        {
            outImage[OUT_COIN_BILL] = 0xFF;
            tiltON = 0;
        }
////////
        i = ((IO1PIN & BIT23)!=0x00) ? 1 : 0;
        if ( i != oldIR )
        {
            oldIR = i;
            tiltIR = GetTickCount();
        }
        else
        {
            if ( tiltIR != 0 && (GetTickCount()-tiltIR) > 250 )
            {
                BuzzerOn(50);
                tiltIR = 0;
//
                tLED1 = GetTickCount();
                tLED2 = GetTickCount();
                dutyLED2 = 0;
//
            }
        }
        if ( tLED1 != 0 && (GetTickCount()-tLED1) > 3000 )
        {
            tLED1 = 0;
        }
        if ( tLED2 != 0 && (GetTickCount()-tLED2) > 60000 )
        {
            tLED2 = 0;
            dutyLED2 = dutyLEDDefault;
        }
#endif
#if LED_DIMMING
        // detect a moving object in front of the machine
        if ( PROX_SENSOR() )
        {
            if ( tiltIR != 0 && (GetTickCount()-tiltIR) > 250 ) // antidebounce
            {
                tiltIR = 0;
                LED_FULL_ON();
                if ( oldProxSensor == 0 )   deltaProxSensor = 1;
                oldProxSensor = 1;
            }
        }
        else
        {
            tiltIR = GetTickCount();
            oldProxSensor = 0;
        }
        // when no moving object detected for some time, dim LEDS
        // if dutyLEDDefault is different from full scale, it was changed by PC, use the PC value
        if ( NonVolatileSetup.timeDimming != 0 && dutyLEDDefault == 0xFFFFFFFFL )
        {
            if ( tLED1 != 0 && (GetTickCount()-tLED1) > (NonVolatileSetup.timeDimming*1000) )
            {
                tLED1 = 0;
                dutyLED2 = setLedDimming( NonVolatileSetup.percDimming );
            }
        }
        else
        {
            LED_FULL_ON();
        }
#endif
        startMDB();

        /*
            UPDATE RTC from external chip
        */
        if ( (GetTickCount()-tReadDate) >= 1000 )
        {
            tReadDate = GetTickCount();
            recvDate(&dateTime);
            dateTime_weekDay = weekDay( dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.min );
            flag = FALSE;
            if ( dateTime.min != lastTestTimeDisable )
            {
                testTimeDisable();
                lastTestTimeDisable = dateTime.min;
                flag = TRUE;
            }
            if ( dateTime.day != lastTestDiscount )
            {
                discount( NULL, 1, 1 );
                resetAdv();
                lastTestDiscount = dateTime.day;
                flag = TRUE;
            }
            if ( flag )
                lpdRecalc();
        }

        /*
            UPDATE status of DOOR OPEN/CLOSE
        */
        flag = doorOpen();
        if ( flag != doorIsOpen )
            testMMCpresence();          // door status changed, re-check mmc
        if ( flag )
        {                               // door opened
            if ( doorIsOpen == FALSE )
            {
                InsertEvent( EVENT_DOOR_OPEN, 0 );
                hostStatus(HOST_DOOR_OPEN);
                {
                  dword to_door;
                  
                  to_door = GetTickCount();
                  do{
                    hostManager();
                  }while(GetTickCount()-to_door < 2000);                  
                }
                memset( &nF, 0x00, sizeof(nF.nFails) );   // unlock all selections
                if( enHome( 0 ) == 0 && ( NonVolatileSetup.DropHome & 0x01 ) )
                  homeMotors( 0 );
                saveSettings();
#if MODEM_HTTP
                if ( modemData.present )
                    modemSend = 1;      // send data through modem
                else if ( zigbeeData.avail && !DEXtransfer() )
                    zigbeeDexRequest(); // send data with zigbee request
#endif
            }
            doorIsOpen = TRUE;
        }
        else
        {                               // door closed
            if ( doorIsOpen == TRUE )
            {
                InsertEvent( EVENT_DOOR_CLOSE, 0 );
                hostStatus(HOST_DOOR_CLOSE);
                checkMotorMap();
                ChangerSetTubeValue();
                ChangerReadTubeStatus();
                discount_doorClose();
                PWR_EN_ON();
            }
            doorIsOpen = FALSE;
            testVend = 0;
        }
#if MODEM_HTTP
        if ( modemSend )
        {
            modemSend = 0;
            modemTransfer("test");
            modemReceive = 0;
        }
        modemManager();
#endif
        hostManager();

        /*
            LED blinking as "alive" status
        */
#ifndef __WIN32__
#if RSR903
        tled = GetTickCount()%2000;
        if ( tled < 1000 )
        {
            IO1SET_bit.P1_26 = 1;
        }
        else
        {
            IO1CLR_bit.P1_26 = 1;
        }
        IO1SET_bit.P1_25 = 1;   // see MDB interrupt
#else
        tled = GetTickCount()%5000;
        if ( tled < 1000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else if ( tled < 2000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1CLR_bit.P1_26 = 1;
        }
        else if ( tled < 3000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else if ( tled < 4000 )
        {
            IO1CLR_bit.P1_25 = 1;           
            IO1SET_bit.P1_26 = 1;
        }
        else
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
#endif
#endif
        if ( GetTickCount() != tsinc )
        {                               // every ms
        /*
            HANDLE PRODUCT SENSOR
        */
            tsinc = GetTickCount();
            flag = 0;                   //  28.07.2010, stop motore
                                        // verifica se selezione completata (cosa
                                        // succede se si effettua una nuova selezione
            if ( tStartFall != 0 && (GetTickCount()-tStartFall) > FALL_ANTIDEB ) // prima che sia terminata tutta la sequenza)
            {
                if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_OFF )
                {                       // sensor disable, wait for home position
                    RESET_FALL_FAILS(last_s_tray,last_s_column);                   
                    tStartFall = 0;
                    SET_SELECTION_STATUS(SELECTION_HOMING);
                }
                else
                {                       // check sensor status
                    if ( (GetTickCount()-tStartFall) < tTimeoutFall &&
                         ((enDrop[last_s_tray][last_s_column] == FALLSENSOR_2tto && (GetTickCount()-tHomePos) < tTimeoutHomePos) || fHomePos == TRUE)
                    )
                    {                   // wait for a product falling in the tTimeoutFall after motor start
                        if ( FALL_SENSOR )
                        {
                            if( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t || 
                               (enDrop[last_s_tray][last_s_column] == FALLSENSOR_2tto && nTestFall > 0)
                            )
                            {
                                if ( (GetTickCount()-tStartFall) > 250 )//added to avoid motor stop when fall_sensor is always activated
                                    flag = 1; // stop motor, selection OK
                            }
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            tEndFall = GetTickCount();
                            SET_SELECTION_STATUS(SELECTION_OK);
                            bucket_cnt = NonVolatileSetup.ledOnTimeOut*1000;
                            to_flashing_led_on = NonVolatileSetup.flashingLedOn*1000;
                        }
                    }
                    else
                    {                   // tStartFall elapsed
                        if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t)
                        {               // stop motor and set EVENT_SELECTION_FAILED
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                            flag = 1;
                        }
                        else if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_5s)
                        {               // only set EVENT_SELECTION_FAILED
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                        }
                        else if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_3x )
                        {               // count failures, and after MAX_SEL_FAILED selection is no more available
                            INC_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                        }
                        else // FALLSENSOR_3r, FALLSENSOR_3n, FALLSENSOR_2tto
                        {               // retry selection, count failures, and after MAX_SEL_FAILED5 selection is no more available
                            INC_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;                            
                            if ( ((enDrop[last_s_tray][last_s_column] == FALLSENSOR_3r || enDrop[last_s_tray][last_s_column] == FALLSENSOR_3n) &&  nTestFall >= MAX_SEL_FAILED5 ) ||
                                 (enDrop[last_s_tray][last_s_column] == FALLSENSOR_2tto &&  nTestFall >= MAX_SEL_FAILED1 )
                            )
                            {
                                SET_SELECTION_STATUS(SELECTION_FAILED);
                            }
                            else
                            {           // retry positioning, running motors for 150ms
                                GET_ACTIVE_MOTOR(k,an, last_s_tray,last_s_column);
                                GET_ALTERNATE_MOTOR(alt_k,alt_an, last_s_tray,last_s_column);

                                tStartFall = GetTickCount();
                                nTestFall++;
                                RESTART_CURRENT_CALCULATION();
                                STOP_MOTORS();

                                if (enDrop[last_s_tray][last_s_column] == FALLSENSOR_2tto)
                                {   
                                    START_MOTOR(k,an,tTimeoutMaxMotor);
                                    START_ALTERNATE_MOTOR(alt_k,alt_an);       
                                    tTimeoutHomePos = 5000;
                                    tTimeoutFall = tTimeoutMotor+tTimeoutHomePos;                                    
                                }
                                else {
                                    START_MOTOR(k,an, (VED1000_en == TRUE)?800:150 );
                                    START_ALTERNATE_MOTOR(alt_k,alt_an);                                    
                                    tTimeoutFall = tTimeoutMotor + 2000;
                                }
                                SET_SELECTION_STATUS(SELECTION_RETRY);
                            }
                        }
                    }
                }
            }

#if HOME_DEBUG//88=tick
            __disable_interrupt();
            commPutChar( COMM1, 0x88 );
            commPutChar( COMM1, GetTickCount() );
            __enable_interrupt();
#endif
        /*
            HANDLE SELECTION MOTOR START/STOP
        */
#if RSR903
            if ( RUNNING_MOTOR(k,an) )
            {
 #if Evolution
                flag = 0;
                if( s_tray == 0 && ( s_column == 0 || s_column == 4 || s_column == 8 ) )
                {
                    flag = 1; FIO2SET = AllOFF;
                }
                else
                {
                    if( (GetTickCount()-tStartMotor) > 10000 )    { flag = 1; FIO2SET = AllOFF; }   // durata della selezione ??
                    else if( (GetTickCount()-tStartMotor) > 500 && SeqKey[ SeqCounter ] != 0 )
                                                                  {
                                                                    FIO2SET = AllOFF; FIO2CLR = MapKey[ SeqKey[ SeqCounter++ ] ];
                                                                    tStartMotor = GetTickCount();
                                                                  }
                    else if( (GetTickCount()-tStartMotor) > 250 ) { FIO2SET = MapOff; };                 
                }
 #else
                flag = 0;
                if( (GetTickCount()-tStartMotor) > SlaveTimeout )  { FIO2SET = AllOFF; flag = 2; }     // selection tiemout BEVMAX
//                else if( (GetTickCount()-tStartMotor) > 2000 )  { if( SlaveSelection )          // timeout to receive VEND REQUEST
                else if( (GetTickCount()-tStartMotor) > 3000 )  { if( SlaveSelection )          // timeout to receive VEND REQUEST              
                                                                      flag = ( SlaveSelection & 0x0F );
                                                                  else 
                                                                      flag = 2;
                                                                  if( flag ) FIO2SET = AllOFF;   // terminate selection ( RUNNING_MOTORS tests FIO2SET )
                                                                }
//                else if( (GetTickCount()-tStartMotor) > 900 )  FIO2SET = MapOff;                 
//                else if( (GetTickCount()-tStartMotor) > 600 )  { FIO2SET = AllOFF; FIO2CLR = MapKey[ s_column ]; }
//                else if( (GetTickCount()-tStartMotor) > 300 )  FIO2SET = MapOff;
                else if( (GetTickCount()-tStartMotor) > 1500 )  FIO2SET = MapOff;                 
                else if( (GetTickCount()-tStartMotor) > 1000 )  { FIO2SET = AllOFF; FIO2CLR = MapKey[ s_column ]; }
                else if( (GetTickCount()-tStartMotor) >  500 )  FIO2SET = MapOff;                              
#endif
#else
#if SLAVE_MACHINE
#define SLAVE_SELECTION_TIMEOUT 30000
            if( SlaveTray != 0xFF )
            {  
                if( ((GetTickCount()-tStartMotor) > SLAVE_SELECTION_TIMEOUT ) ||  // timeout
                    ( SlaveStatus[s_machine-1] == 0 ) ||                     // slave disconnected
                    ( SlaveSelectionStatus[s_machine-1] == 2 ) )             // selection OK
                {
                    SET_SELECTION_STATUS(SELECTION_OK);
                    k = 0xFF;
                    an = 0xFF;
                    s_machine = 0xFF;
                    s_tray = 0xFF;
                    s_column = 0xFF;
                    SlaveTray = 0xFF;
                    nfront = 0;
                    nread = 0;
                    keyFlush();
                    if( (GetTickCount()-tStartMotor) > SLAVE_SELECTION_TIMEOUT )
                         SlaveForceReset = 1;
                }
                else if( SlaveSelectionStatus[s_machine-1] == 3 )
                {
                    SET_SELECTION_STATUS(SELECTION_FAILED);
                    k = 0xFF;
                    an = 0xFF;
                    s_machine = 0xFF;
                    s_tray = 0xFF;
                    s_column = 0xFF;
                    SlaveTray = 0xFF;
                    nfront = 0;
                    nread = 0;
                    keyFlush();
                }
            }
#endif
            if ( RUNNING_MOTOR(k,an) )
            {
                // cerca fronte
                if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                {
                    mask = ~inImage[2];
                }
                else
                {
                    if ( SubMachineType == SUB_DIXIE501E )
                        mask = INP0;
                    else
                        mask = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi;
                    nfront = 0xFF;      // disable test motor off (attention, not fixed for NAT147/NAT157 coupling motor)
                }
                // fronte di salita
// 28.07.2010                flag = 0;
                       // aspetta che il motore parta   &&   ( verifica variazione ingressi    ||    se supera il timeout ), ferma tutto
 #if MOTOR_SIMULATION == 0
  #if FULL_MOTOR
                if ( (GetTickCount()-tStartMotor) > 5*((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2 || machineType == MACHINA_VEILCM)?600:300) && 
                     ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) > 5*tTimeoutMotor) )   // do not test HOMING
  #else
   #if TOK_TAKE
                if ( (GetTickCount()-tStartMotor) > ((machineType==MACHINA_AMS39  || machineType==MACHINA_USIGVC2)?600:300) && 
   #else
                if ( (GetTickCount()-tStartMotor) > ((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2 || machineType == MACHINA_VEILCM)?600:300) && 
   #endif
                     ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) >   tTimeoutMotor) )   // do not test HOMING
  #endif
 #endif
                {                           // stop motor
 #if MOTOR_SIMULATION == 0
                    if ( ++nread > 10 )
 #else
                    if ( ++nread > 100 )
 #endif
                    {
                        if ( (GetTickCount()-tStartMotor) > tTimeoutMotor )
                            flag = 2;// not at home
                        else
                        {
                            // se modo drop sensor FALLSENSOR_2t aspetta 2 giri prima di fermarlo se non cade prodotto
                            if( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t && motorTurns == 0 )  
                            {
                                motorTurns++ ;
                                nread = 0;
                                inp = mask;
                                tStartMotor = GetTickCount();
                                tStartFall = GetTickCount() - (FALL_ANTIDEB+11); // restart fall sensor timeout
                            }
                            // altrimenti verifica per fermare il motore
                            else
                            {
///// TEST39                                if ( inpMask == 0xFF || inpMask == 0x01 || inpMask == 0x04 || ((mask^inp)& mask & inpMask ) == inpMask )
                                if ( inpMask == 0xFF || ((mask^inp)& mask & inpMask ) == inpMask )
                                {
                                    flag = 1;// home position, stop
                                    if (enDrop[last_s_tray][last_s_column] == FALLSENSOR_2tto)
                                    {
                                        tHomePos = GetTickCount();
                                        fHomePos = FALSE;
                                    }
                                }
                                else 
                                {           // check which input is at home, and wait for the other
                                    if ( ((mask^inp)& mask & inpMask ) == 0x01 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = k;    // exchange line on NAT157
                                        else
                                            kkk = alt_k;
                                        inpMask = 0x04;
                                        STOP_SINGLE_MOTOR(kkk);                                        
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x04 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = alt_k;// exchange line on NAT157
                                        else
                                            kkk = k;
                                        inpMask = 0x01;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x40 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x40;
                                        outImage[OUT_AN0_AN7] |= 0x55;
                                        inpMask = 0x20;
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x20 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x80;
                                        outImage[OUT_AN0_AN7] |= 0xAA;
                                        inpMask = 0x40;
                                    }
                                    nread = 0;
                                    inp = mask;
                                }
                            }
                        }
                    }
                }
 #if MOTOR_SIMULATION == 0
                else
                {
                    nread = 0;
                    inp = mask;
                                        // check when off home, if always the same
                                        // input, after timeout give error
                                        // if input changed, wait for antidebounce
                    if ( nfront != 0xFF )
                    {                       // !!!! only on ROWE, fix for NAT147/NAT157 if coupling motor
                        if ( initialInp == inp )
                        {
                            nfront = 0;
  #if FULL_MOTOR
                            if ( (GetTickCount()-tStartMotor) > 5*T_MIN_MOTOR )
  #else
                            if ( (GetTickCount()-tStartMotor) > T_MIN_MOTOR )
  #endif
                            {               //disable selection
                                flag = 2;
                                DISABLE_MOTOR_MAP(k,an);
                                DISABLE_MOTOR_MAP(alt_k,alt_an);
                            }
                        }
                        else
                        {
                            if ( ++nfront > 10 )
                                nfront = 0xFF;// out of home, ok !!! disable test
                        }
                    }
                }
 #endif
#endif
                if ( flag )
                {
                    if ( flag == 2 )
                    {                   // not at home, what we have to do ?
                        if ( prodSel.status == SELECTION_HOMING )
                            SET_SELECTION_STATUS(SELECTION_FAILED);                       
                    }
                    else
                    {
                        if ( prodSel.status == SELECTION_HOMING )
                        {
                            SET_SELECTION_STATUS(SELECTION_OK);
                            bucket_cnt = NonVolatileSetup.ledOnTimeOut*1000;   
                            to_flashing_led_on = NonVolatileSetup.flashingLedOn*1000;
                        }                      
                    }
                    STOP_MOTORS();
                    k = 0xFF;
                    an = 0xFF;
                    s_machine = 0xFF;
                    s_tray = 0xFF;
                    s_column = 0xFF;
                    nfront = 0;
                    nread = 0;
                    keyFlush();
#if PRODUCT_RECOGNITION
Delay(300);
commPutChar( COMM1, 'G' );
commPutChar( COMM1, 'O' );
commPutChar( COMM1, '\x0d' );
#endif
                }
            }                           // if ( RUNNING_MOTOR(k,an) )
        }  // if ( GetTickCount() != tsinc )

                                        // delete partial selection after 20s
        if ( tPartialSelection != 0 && (GetTickCount()-tPartialSelection) > 20000 )
        {
            s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
            tPartialSelection = 0;
        }

        // show error message : tMsgDelay is not zero to lock machine when dsiplaying error messages
        if ( tMsgDelay != 0 )
        {
            resetAdv();
            if ( (GetTickCount()-tMsgDelay) < 3000 )
                continue;
            tMsgDelay = 0;
        }

        // lock selection if motor running or drop sensor enabled           
        kkk = testKey();
        if ( ON_SELECTING() || RUNNING_MOTOR(k,an) )
        {
            kkk = 0;
            stopInt = 1;
        }
        else
            stopInt = 0;                                                                  
                                        // check for a new selection 
        if ( ( kkk != 0 && (s_tray == 0xFF || s_column == 0xFF ) ) ||   // keyboard
             ( hostSelection( &s_machine, &s_tray, &s_column, &tot ) == 0 ) ) // host PC
        {
            LED_FULL_ON();
#ifdef MAPPA_MOTORI
            mappa_motori( kkk );
#endif
            // input selezione
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || 
                 machineType == MACHINA_VEI147 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ||
                 machineType == MACHINA_VEILCM )
            {
                if ( s_machine == 0xFF && ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ) ) s_machine = 1;  // not used in AMS39 only from keybird but used from Host
                if ( s_machine == 0xFF )
                {
#if SLAVE_MACHINE
                    if ( kkk == K_1 || kkk == K_2 || kkk == K_3 || kkk == K_4 )
#else
                    if ( kkk == K_1 )
#endif
                    {
                        s_machine = kkk - K_0;
                        tPartialSelection = GetTickCount();
                    }
                }
                else
                {
                    if ( s_tray == 0xFF )
                    {
                        if ( kkk >= K_1 && kkk <= K_9 )
                        {
                            s_tray = kkk - K_1;
                            tPartialSelection = GetTickCount();
                        }
                        if ( kkk == K_0 && enTEMP( 0 )== 0 && show_temp == 0 )
                            show_temp = 1;
                        else
                            show_temp = 0;         
                    }
                    else if ( kkk >= K_0 && kkk <= K_9 )
                    {
                        s_column = kkk - K_0;
                        tPartialSelection = GetTickCount();
                    }
                }
                if ( kkk == K_RESET )
                {
                    s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
                    tPartialSelection = 0;
                }
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            {
                s_machine = 1;
                if ( kkk >= K_0 && kkk <= K_9 && s_column == 0xFF )
                {
                    s_column = kkk - K_0;
                    tPartialSelection = GetTickCount();
                }
                else if ( kkk >= K_1 && kkk <= K_9 )
                {
                    s_tray = kkk - K_0;
                    tPartialSelection = GetTickCount();
                }
                if( kkk == K_RESET )
                {
                    s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
                    tPartialSelection = 0;
                }
            }
            else
            {
                s_machine = 1;
                if ( kkk >= K_A && kkk <= K_I )
                {
                    s_tray = kkk - K_A;
                    tPartialSelection = GetTickCount();
                }
                if ( kkk >= K_0 && kkk <= K_9 )
                {
                    s_column = kkk - K_0;
                    tPartialSelection = GetTickCount();
                 }
            }
#if SLAVE_MACHINE
            if ( s_tray != 0xFF && s_column != 0xFF && s_machine != 1 )
            {         
                if (s_machine <= MAX_MACHINE_NUM)
                {
                  if( kkk != 0 )    tot = amount[s_machine-1][s_tray][s_column];   // if selection is from keyboard, otherwise price is coming from HOST
                  if( SlaveStatus[s_machine-1] == 0 )
                  {                           // ... not available
                      hostStatus(HOST_SELECTION_UNAVAIL);
                      InsertEvent( EVENT_SELECTION_UNAVAIL, s_tray*100+s_column );
                      k = 0xFE;
                      an = 0;
                  }
                  else
                  {
                      if( kkk != 0 && cheskHostCashless(  s_machine, s_tray, s_column ) != 0 ) // manual selection
                      {
                          k = 0xFF;  an = 0xFF;
                      }
                      else
                      {
                          SelectionData.price = tot;
                          SET_SELECTION_STATUS(SELECTION_CHECK);
                          pay_selection_start( tot, s_machine, s_tray, s_column );
                          k = 0xFD;  an = 0xFF; // wait selection price enable
                          tPartialSelection = 0;
                      }
                  }
                }
                else {
                    SET_SELECTION_STATUS(SELECTION_OK);
                    InsertEvent( EVENT_SELECTION_START, tot );
                    SelectionData.machine = s_machine;
                    SelectionData.tray = s_tray;
                    SelectionData.column = s_column; 
                    SelectionData.price = tot;                    
                    InsertEvent( EVENT_SELECTION_OK, tot );
                    SET_SELECTION_STATUS(SELECTION_NO);
                    hostStatus(HOST_SELECTION_OK);                    
                    k = 0xFF;
                    an = 0xFF;
                    s_machine = 0xFF;               
                    s_tray = 0xFF;
                    s_column = 0xFF;        
                    tMsgDelay = GetTickCount(); // start timer to display error messages for a fized amount of time                            
                }
            }

            if ( s_tray != 0xFF && s_column != 0xFF && s_machine == 1 )
#else
            if ( s_tray != 0xFF && s_column != 0xFF )
#endif
            {                           // a new selection has been activated                      
                if( kkk != 0 )    tot = amount[0][s_tray][s_column];   // if selection is from keyboard, otherwise price is ccoming from HOST
#if HOME_DEBUG//00=selection
    __disable_interrupt();
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, ((s_tray&0x0f)<<4)|(s_column&0x0f) );
    __enable_interrupt();
#endif
                tPartialSelection = 0;
                if( forceEscrow ) 
                {
                    last_s_tray = s_tray;
                    last_s_column = s_column;
                    SelectionData.machine = 1;
                    // this is a fake selection, do not manage cash data even when the selection will fail
                    SelectionData.tray = s_tray;
                    SelectionData.column = s_column;
                    SelectionData.payedCashless1= 0; SelectionData.payedCashless2 = 0; SelectionData.payedCash = 0;
                    SelectionData.askCash = 0; SelectionData.askCashless1 = 0; SelectionData.askCashless2 = 0;
                    goto MoveEscrowMotor;
                }
                                        // check group selection automatic change
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    checkMotorGroupSelection(&s_column,&s_tray, 0);
                else
                    checkMotorGroupSelection(&s_tray,&s_column, 0);
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    flag = checkTimeFrames( s_column, s_tray );
                else
                    flag = checkTimeFrames( s_tray, s_column );
                if ( flag || isTimedDisable() )
                {
                    hostStatus(HOST_SELECTION_LOCKED);
                    InsertEvent( EVENT_SELECTION_UNAVAIL, s_tray*100+s_column );
                    k = 0xFE;
                    an = 3;
                }
                else
                {
                                        // check motor presence ...
                    GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                    GET_ALTERNATE_MOTOR(alt_k,alt_an, s_tray,s_column);                             
#if PRODUCT_RECOGNITION
                    procRecogTray = s_tray;
                    procRecogCol = s_column;
                    if ( s_tray == 8 && s_column == 9 )
                    {
                        commPutChar( COMM1, 'I' );
                        commPutChar( COMM1, '9' );
                        commPutChar( COMM1, '\x0d' );
                    }
#endif
// 06.2012 #if FULL_MOTOR
// 06.2012     memset( motorMap, 1, sizeof(motorMap) );
// 06.2012 #endif

                    if (  k == 99 || motorMap[k][an] == 0 ) 
                    {                           // ... not available
                        hostStatus(HOST_SELECTION_UNAVAIL);
                        InsertEvent( EVENT_SELECTION_UNAVAIL, s_tray*100+s_column );
                        k = 0xFE;
                        an = 0;
                    }
                    else                        // ... drive motor
                    {
                        last_s_tray = s_tray;
                        last_s_column = s_column;
                                        // verify if selection locked
                        if ( selectionLocked(last_s_tray,last_s_column) )
                        {
                            hostStatus(HOST_SELECTION_LOCKED);
                            InsertEvent( EVENT_SELECTION_UNAVAIL, s_tray*100+s_column );
                            k = 0xFE;
                            an = 1;
                        }
                        else
                        {
                            if ( SubMachineType == SUB_DIXIE501E )
                            {
                                ATTIVA_CATODO( k );
                                Delay( 20 );
                                i = INP2;
                                STOP_MOTORS();
                            } 
                            if( ( SubMachineType != SUB_DIXIE501E && motorMap[k][an] == 0 ) ||  // VERIFICARE se necessario test motori DEBUG!                            
                                ( SubMachineType == SUB_DIXIE501E && !i ) )
                            {
                                hostStatus(HOST_SELECTION_UNAVAIL);
                                InsertEvent( EVENT_SELECTION_UNAVAIL, s_tray*100+s_column );
                                k = 0xFE;
                                an = 0;
                            }
                            else
                            {
                                        // test if amount available
                                if ( testVend == 0x68 )
                                    tot = 0;                                
                                SelectionData.price = tot;
#if ENABLE_DISCOUNT
                                discount( &tot, s_tray, s_column );
                                lpdRecalc();
#endif
#if ANTI_V
                                if ( tLED2 != 0 )
                                {
                                    tot = tot * 90 / 100;
                                    tot = ((tot+4)/5)*5;
                                }
                                tLED2 = 0;
#endif
#if ENABLE_TAX_VISUA
                                if ( tot != 0 )
                                {
                                    taxes.tax = (tot*NonVolatileSetup.percTax/10000);
                                    taxes.sale = tot-taxes.tax;
                                    taxes.total = tot;
                                    if ( taxes.tax == 0 )
                                        taxes.phase = GetTickCount()-2000;
                                    else
                                        taxes.phase = GetTickCount();
                                }
#endif
#if PRODUCT_RECOGNITION
commPutChar( COMM1, s_tray+'A' );
commPutChar( COMM1, s_column+'0' );
commPutChar( COMM1, '\x0d' );
#endif                                
                                if( kkk != 0 && cheskHostCashless(  s_machine, s_tray, s_column ) != 0 ) // manual selection
                                {
                                    k = 0xFF; an = 0xFF;  // terminate
                                    tPartialSelection = GetTickCount(); // timeout for Cashless anwer
                                }
                                else
                                {                                
                                    SET_SELECTION_STATUS(SELECTION_CHECK);
                                    pay_selection_start( tot, 1, s_tray, s_column );
                                    k = 0xFD;  an = 0xFF; // wait selection price enable
                                }
                            }
                        }
                    }
                }
            }
        }

        // wait selection price enable
#if RSR903
        if ( k == 0xFD && an == 0xFF && !RUNNING_MOTOR(k,an) ) {
#else
 #if SLAVE_MACHINE
        if ( k == 0xFD && an == 0xFF && SlaveTray == 0xFF ) {
 #else
        if ( k == 0xFD && an == 0xFF ) {
 #endif
#endif
            switch( pay_selection( &tot ) ) {
                        // ok
                case 0: 
#if ENABLE_DISCOUNT
                        discount_count( s_tray, s_column );
                        lpdRecalc();
#endif                                                
#if SLAVE_MACHINE
                        if( s_machine != 1 )
                        {                         
                            SlaveTray = s_tray;  SlaveRow = s_column;
                            SlaveAddrOffset = s_machine;
                            tStartMotor = GetTickCount();
                            tStartFall = 0;     // not use DROP sensor
                            InsertEvent( EVENT_SELECTION_START, tot );
                            hostStatus(HOST_SELECTION_START);                        
                            
                            sprintf( bufferLCD, "  -Slave %02x%02X-  ", SlaveTray, SlaveRow  );
                            DispStr( 0, 0, bufferLCD );
                            Delay(1000);
                            break;                               
                        }
#endif
MoveEscrowMotor:        InsertEvent( EVENT_SELECTION_START, tot );
                        tStartFall = GetTickCount();
                        tTimeoutFall = tTimeoutMaxMotor + 1000;
                        tTimeoutHomePos = 2000;
                        fHomePos = TRUE;
                        nTestFall = 0;
                        hostStatus(HOST_SELECTION_START);                        
#if RSR903
                        MapTray();
                        tStartMotor = GetTickCount();
                        tTimeoutMotor = 20000;
                        SlaveSelection = 0x00;
#else
                        if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                            checkMotorGroupSelection(&s_column,&s_tray, 1);
                        else
                            checkMotorGroupSelection(&s_tray,&s_column, 1);                         
                        RESTART_CURRENT_CALCULATION();
                        STOP_MOTORS();
                        GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                        GET_ALTERNATE_MOTOR(alt_k,alt_an, s_tray,s_column);
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an);
#endif
                        activateMotor(s_tray,s_column);
                        SET_SELECTION_STATUS(SELECTION_START);
                        break;
                
                        // fail
                case 1: k = 0xFE;  an = 2;
                        hostStatus(HOST_SELECTION_COST);
                        SET_SELECTION_STATUS(SELECTION_NO);
                        break;
                        // wait
                default: break;
            }

        }
/*
        Display working informations
*/
        // if selection failed, show failure message
        if ( k == 0xFE )
        {
            if ( an == 2 )
            {
                if ( posVirgola == 2 )
                    sprintf( buf, (char *)MSG_SEL_PRICE, tot/100, tot%100 );
                else
                    sprintf( buf, (char *)" SEL.PRICE %5ld", tot );
            }
            else if (an==1||an==3)  sprintf( buf, (char *)MSG_SEL_LOCKED );
            else                    sprintf( buf, (char *)MSG_NOT_AVAILABLE );
            k = 0xFF;
            an = 0xFF;
            s_machine = 0xFF;               
            s_tray = 0xFF;
            s_column = 0xFF;        
            tMsgDelay = GetTickCount(); // start timer to display error messages for a fized amount of time
        }
        // handle standby messages
        else
        {
            cheskHostCashless( s_machine, s_tray, s_column );
            // Prepare display amount if any amount available but no selection made
            if ( money != 0 && s_machine == 0xFF && s_tray == 0xFF && s_column == 0xFF )
            {
                if ( money == ID_TOKEN )
                    sprintf( buf, " FREE VEND TOKEN" );
                else
                    sprintf( buf, " AMOUNT   %s", currencyStr(money,6) );
                i = 1;  // msg_ID
            }
            // Prepare display "Selection - - -", no selecon made
            else if( s_machine == 0xFF && s_tray == 0xFF && s_column == 0xFF )
            {
                sprintf( buf, (char *)MSG_SELECT );
                if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM)
                    buf[11] = '-';
                displayTempFail( buf );
                i = 2;  // msg_ID
            }
            else if( show_temp )
            {
                if( HealthProblem == HEALTH_DOOR )
#if TOK_TAKE
                    sprintf( buf, " %02dmin Temp=%3dC", 30 - (GetTickCount() - doorTimeClose )/(60L*1000L), Temperatura/100 );
#else
                    sprintf( buf, " %02dmin Temp=%3dF", 30 - (GetTickCount() - doorTimeClose )/(60L*1000L), Temperatura/100 );
#endif
                else
                    sprintf( buf, " TEMPERAT.  %3dF", Temperatura/100 );                  
//                if( NonVolatileSetup.Temperatura > 32 )
//                    buf[15] = 'F';
                tLCDtimer = GetTickCount();
                i = 4;  // msg_ID
            }
            // Prepare display "Selection X Y Z", when selection is inputted
            else
            {
                sprintf( buf, (char *)MSG_SELECT );
                displaySelection( &buf[11], &buf[13], &buf[15], s_machine, s_tray, s_column, '_' );
                displayTempFail( buf );
                i = 3;  // msg_ID
                tLCDtimer = GetTickCount();
            }

            if( LCDmsg != i ) // if msg_ID is changed, a new message need to be displayed immediately ( at least for some time )
            {
                LCDmsg = i;
                tLCDtimer = GetTickCount();
            }
            else if( ( GetTickCount() - tLCDtimer ) > 2000 && ChangerExactChange() != 0 )
            {
                sprintf( buf, (char *)MSG_EXACT_CHANGE );
#if 0
                // debug start EEE
                if( ( GetTickCount() - tLCDtimer ) > 4000 )
                  sprintf( buf, "%1d(%1d %1d %1d) %2d.%02d", ChangerExactChange(), ChangerTubes(0), ChangerTubes(1), ChangerTubes(2), ChangeTubeValue()/100, ChangeTubeValue()%100 );
                if( ( GetTickCount() - tLCDtimer ) > 6000 ) tLCDtimer = GetTickCount();
                // debug end
#else
                if( ( GetTickCount() - tLCDtimer ) > 4000 ) tLCDtimer = GetTickCount();
#endif
            }
#if 0
            // debug start EEE
            if( ( GetTickCount() - tLCDtimer ) > 2000 && ChangerExactChange() == 0 )
            {
                sprintf( buf, "%1d(%1d %1d %1d) %2d.%02d", ChangerExactChange(), ChangerTubes(0), ChangerTubes(1), ChangerTubes(2), ChangeTubeValue()/100, ChangeTubeValue()%100 );
                if( ( GetTickCount() - tLCDtimer ) > 4000 ) tLCDtimer = GetTickCount();
            }
            // debug end
#endif
        }
#if ANTI_V
//        if( tiltON != 0 && (GetTickCount()-tiltON) < 1000 )
//        {
//            strcpy( buf, (char *)"  TILT!         " );
//        }
//        else
//            tiltON = 0;
#endif
#if 0
if( ( GetTickCount() - tLCDtimer ) > 4000 )
{
buf[ 0] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>>12)&0x0F];
buf[ 1] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>> 8)&0x0F];
buf[ 2] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>> 4)&0x0F];
buf[ 3] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing    )&0x0F];
for( i = 0; i < 16-4; i++ )
{
    buf[ 4+i] = Change.TubeStatus.Tube_Status[i]+'0';
}
if( ( GetTickCount() - tLCDtimer ) > 6000 ) tLCDtimer = GetTickCount();//EEE
}
#endif

                                        // show adverting message
        showAdv( ((LCDmsg==2)&&(tMsgDelay==0)), buf );
// 2011.05.27        mmdShowAds();
        
        if ( isTimedDisable() )
            sprintf( buf, (char *)MSG_MACH_DISABLED );

#if ENABLE_TAX_VISUA
        if ( taxes.phase != 0 )
        {
            tMsgDelay = 0;
            if ( (GetTickCount()-taxes.phase) < 1000 )
                sprintf( buf, " SALE  %3.3s%s", currencyString, currencyStr(taxes.sale,6) );
            else if ( (GetTickCount()-taxes.phase) < 2000 )
                            // " TAX      $xx.xx"
                sprintf( buf, " TAX   %3.3s%s", currencyString, currencyStr(taxes.tax,6) );
            else if ( (GetTickCount()-taxes.phase) < 5000 )
                sprintf( buf, " TOTAL %3.3s%s", currencyString, currencyStr(taxes.total,6) );
            else
                taxes.phase = 0;
            if ( taxes.hello != 0 )
                taxes.hello = GetTickCount();// delayed message
        }
        else if ( taxes.hello != 0 )
        {
            tMsgDelay = 0;
            if ( (GetTickCount()-taxes.hello) < 1000 )
                sprintf( buf, "    Thank you   " );
            else if ( (GetTickCount()-taxes.hello) < 2000 )
                sprintf( buf, " Have a nice day" );
            else
                taxes.hello = 0;
        }
#endif

//DEB_EN();
//buf[ 0] = ' ';
//buf[ 1] = '0'+((dateTime.min/10)%10);
//buf[ 2] = '0'+((dateTime.min/ 1)%10);
//buf[ 3] = ':';
//buf[ 4] = '0'+((dateTime.sec/10)%10);
//buf[ 5] = '0'+((dateTime.sec/ 1)%10);
//buf[ 6] = ' ';

#if TEST_ADC_KEYBOARD
buf[ 0] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/1000)%10);//AP113
buf[ 1] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/ 100)%10);
buf[ 2] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/  10)%10);
buf[ 3] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/   1)%10);
buf[ 4] = '-';
buf[ 5] = '0'+((ADkey.maxAn/ 100)%10);
buf[ 6] = '0'+((ADkey.maxAn/  10)%10);
buf[ 7] = '0'+((ADkey.maxAn/   1)%10);
buf[ 8] = '-';
buf[ 9] = '0'+((ADkey.lastAn/ 100)%10);
buf[10] = '0'+((ADkey.lastAn/  10)%10);
buf[11] = '0'+((ADkey.lastAn/   1)%10);
buf[12] = '-';
buf[13] = '0'+((AD.conv[AD_2]/ 100)%10);
buf[14] = '0'+((AD.conv[AD_2]/  10)%10);
buf[15] = '0'+((AD.conv[AD_2]/   1)%10);
#endif
        DispStr( 0, 0, buf );

                                        // verifica completamento selezione
        CHECK_SELECTION_STATUS();
        if ( prodSel.status == SELECTION_OK && !(RUNNING_MOTOR(k,an)) )        
        {
            if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_OFF || (GetTickCount()-tEndFall) > 500  )
            {            
                if( forceEscrow ) {
                    InsertEvent( EVENT_FORCE_ESCROW, 0 );
                    forceEscrow = 0;
                }
                else
                    InsertEvent( EVENT_SELECTION_OK, tot );
                SET_SELECTION_STATUS(SELECTION_NO);
                hostStatus(HOST_SELECTION_OK);
#if ENABLE_TAX_VISUA
                taxes.hello = GetTickCount();
#endif
            }
        }
        else if ( prodSel.status == SELECTION_FAILED )
        {
            InsertEvent( EVENT_SELECTION_FAILED, tot );
            SET_SELECTION_STATUS(SELECTION_NO);
            hostStatus(HOST_SELECTION_FAILED);
        }        
//eee     
                                        // gestione pagamenti
        money = Credit();
        // memorizza NAMA rule failure, if there is a change
        i = HealthProblem;
        if( HealthProblem == HEALTH_DOOR ) i = HEALTH_NORM;
        if( nF.HealthProblem != i )
        {
            nF.HealthProblem = i;
            saveSettings();
        }
        Audit();
        preparaDEX( );
        
        hostMoney(money);
                                        // gestione programmazione
        if ( !ON_SELECTING() )
        {
            if ( MenuSwitch() || GestioneMenuForcedByHost )
            {

#if 0
{//dosfs
    byte        resp;
	uint32_t    pstart, psize;
	uint8_t     pactive, ptype;
    WORD        cluster;
    DWORD       filelen, ttime;
	VOLINFO     vi;
	FILEINFO    fi;
	DIRINFO     di;
	DIRENT      de;
    DWORD       successcount;

    if ( mmcInit() == mmc_noerr )
    {
#if 0
    FAT_init();
    for ( i = 1; i <= 250; i++ )
    {
        resp = FAT_getFileName( i, (char *)fileName, &cluster, &filelen );
        if ( resp == 3 )
            continue;
        if ( resp != 0 )
            break;
         DispStr( 0, 0, (char *)fileName );
#if 1
        if ( strcmp((char *)fileName,"VISUA11.BMP") == 0 )
        {
            if ( FAT_openFile(cluster,filelen) == 0 )
            {
                DispStr( 0, 0, (char *)MSG_FW_LOADING );
                ttime = GetTickCount();
                filelen = 0;
                do {
                    resp = 100;
                    if ( FAT_getsFile(sector,&resp) != 0 )
                        break;
                    filelen += resp;
                } while( resp != 0 );
                sprintf( (char *)fileName, "%6ld  %6ld  ", (GetTickCount()-ttime), filelen );
                DispStr( 0, 0, (char *)fileName);
            }
        }
#endif
    }
#endif
	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if (pstart == 0xffffffff) {
		DispStr( 0, 0, "Cannot find first partition\n");
//		return -1;
	}

//	printf("Partition 0 start sector 0x%-08.8lX active %-02.2hX type %-02.2hX size %-08.8lX\n", pstart, pactive, ptype, psize);

	if (DFS_GetVolInfo(0, sector, pstart, &vi)) {
		DispStr( 0, 0, "Error getting volume information\n");
//		return -1;
	}

#if 1
// File read test
	if ( DFS_OpenFile(&vi, "VISUA11.BMP", DFS_READ, sector, &fi) == 0 ) 
    {
        ttime = GetTickCount();
        filelen = 0;
        do {
            if ( DFS_ReadFile(&fi, sector, fileName, &successcount, SECTOR_SIZE) )
                break;
            filelen += successcount;
        } while(successcount!=0);
        sprintf( fileName, "%6ld  %6ld  ", (GetTickCount()-ttime), filelen );
        DispStr( 0, 0, fileName);
    }
#endif
#if 0
//------------------------------------------------------------
// File write test
	if ( DFS_OpenFile(&vi, "PROVA.TXT", DFS_WRITE, sector, &fi) == 0 ) 
    {
        strcpy( fileName, "Hello world!\r\n" );
        DFS_WriteFile( &fi, sector, fileName, &successcount, strlen(fileName) );
    }

//------------------------------------------------------------
// File read test
	if (DFS_OpenFile(&vi, "PROVA.TXT", DFS_READ, sector, &fi)) {
////		printf("error opening file\n");
		return -1;
	}
    
    do {
        DFS_ReadFile(&fi, sector, fileName, &successcount, 16);
		DispStr( 0, 0, fileName);
    } while(successcount!=0);
#endif
    
/*
	// At this point, if our path was MYDIR/MYDIR2/FILE.EXT, filename = "FILE    EXT" and
	// tmppath = "MYDIR/MYDIR2".
	di.scratch = sector;
	if (DFS_OpenDir(&vi, "/", &di))
		DispStr( 0, 0, " DFS_NOTFOUND ");

	while (!DFS_GetNext(&vi, &di, &de)) {
		DispStr( 0, 0, de.name );
    }
*/    
    }//no_err
}
#endif
                inProgramm = TRUE;
                stopInt = 0;
                hostStatus(HOST_PROGRAMMING);
                GestioneMenu();
                discount( NULL, 1, 1 );
                lpdRecalc();
                resetAdv();
//                mmdRestartAds();
                hostStatus(HOST_STATUS_READY);
                lastTestTimeDisable = 0xFF;
                inProgramm = FALSE;
            }
        }
        testSaveSettings();
    }
#endif//BOOT

}                                               //  main


/*--------------------------------------------------------------------------
 | enHome:   verify if motors home position can be checked
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       motors homing position can be checked
 |      1       motors homing position cannot be checked
 +--------------------------------------------------------------------------*/

byte            enHome( unsigned char _typeVar )
{
#if TOK_TAKE
    if (                                  machineType == MACHINA_USIGVC2 || machineType == MACHINA_VEILCM )
#else
    if ( machineType == MACHINA_LCM123 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_VEILCM )
#endif
        return 1;
    return 0;
}                                               //  enHome

/*--------------------------------------------------------------------------
 | loadSettings:load the settings from permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            initialSettings( void )
{
    memset( &NonVolatileSetup, 0x00, sizeof(NonVolatileSetup) );
    memset( &nF,        0x00,   sizeof(nF)          );
    memset( enDrop,     0x00,   sizeof(enDrop)      );
    memset( timeDisable,0,      sizeof(timeDisable) );

    NonVolatileSetup.setSingleVend = 1;//single vending
    NonVolatileSetup.slideDelay = 10;
    NonVolatileSetup.setFillTube = 0x68;//tube fill:no
    NonVolatileSetup.DropHome = 1;      // YES
    NonVolatileSetup.percDimming = 100;
    NonVolatileSetup.Temperatura = 50;
}

void            loadSettings( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("set.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1, sizeof(data1)  );
    read( fileno(fin), &NonVolatileSetup, sizeof(NonVolatileSetup) );
    read( fileno(fin), nF,     sizeof(nF)     );
    read( fileno(fin), enDrop, sizeof(enDrop) );
    read( fileno(fin), &data2, sizeof(data2)  );

    if ( data1 != 0x11112222 || data2 != 0x33334444 )
    {
        memset( &NonVolatileSetup, 0, sizeof(NonVolatileSetup) );
        memset( &nF,    0,   sizeof(nF)     );
        memset( enDrop, 0,   sizeof(enDrop) );

        NonVolatileSetup.setSingleVend = 1;//single vending
        HealthProblem = nF.HealthProblem;
    }
    if ( enCOUPLING(0) != 0 )
        memset( NonVolatileSetup.motorCoupled, 0, sizeof(NonVolatileSetup.motorCoupled) );

    fclose(fin);
                                #else
    DWORD       m;
    char        marca[16];

    m = (DWORD)0x79000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp( marca, MEM_MARKER, 16 ) != 0 )
    {
        initialSettings();
        HealthProblem = nF.HealthProblem;
        return;
    }
    m += 256;
    memcpy( &NonVolatileSetup, (void *)m, sizeof(NonVolatileSetup) );
    m += 256;
    memcpy( &nF, (void *)m, sizeof(nF) );
    HealthProblem = nF.HealthProblem;
    m += 256;
    memcpy( enDrop, (void *)m, sizeof(enDrop) );
    m += 256;

    if ( enCOUPLING(0) != 0 )
        memset( NonVolatileSetup.motorCoupled, 0, sizeof(NonVolatileSetup.motorCoupled) );
    if ( NonVolatileSetup.slideDelay == 0 )
        NonVolatileSetup.slideDelay = 10;
#ifndef BOOT    
    discount_reload(1);
#endif    
                                #endif
}                                               //  loadSettings




/*--------------------------------------------------------------------------
 | saveSettings:save the settings on permanent memory
 |                              -------------
 |              mapping 0x79000     MEM_MARKER
 |                      0x79100     NonVolatileSetup
 |                      0x79200     nF
 |                      0x79300     enDrop
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveSettings( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("set.bin","wb")) == NULL )
        return;

    data1 = 0x11112222;
    data2 = 0x33334444;
    write( fileno(fin), &data1, sizeof(data1)  );
    write( fileno(fin), &NonVolatileSetup, sizeof(NonVolatileSetup) );
    write( fileno(fin), &nF,    sizeof(nF) );
    write( fileno(fin), enDrop, sizeof(enDrop) );
    write( fileno(fin), &data2, sizeof(data2)  );

    fclose(fin);
                                #else
    byte        fChanged;
    DWORD       m;
    char        marca[16];

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x79000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp(marca,MEM_MARKER,16) != 0 )
        fChanged = TRUE;
    m += 256;
    NonVolatileSetup.setupVersion = SETUP_VERSION;
    if ( memcmp(&NonVolatileSetup,(void *)m,sizeof(NonVolatileSetup)) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&nF,(void *)m,sizeof(nF)) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(enDrop,(void *)m,sizeof(enDrop)) != 0 )
        fChanged = TRUE;
    m += 256;

    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x79000;
    EraseBlock( m, 1 );
    memcpy( marca, MEM_MARKER, 16 );
    WriteFlash256( marca,  m, sizeof(marca) );                          m += 256;       // 0x0000, 0x00FF
    WriteFlash256( &NonVolatileSetup, m, sizeof(NonVolatileSetup) );    m += 256;       // 0x0100, 0x01FF
    WriteFlash256( &nF,    m, sizeof(nF)     );                         m += 256;       // 0x0200, 0x02FF
    WriteFlash256( enDrop, m, sizeof(enDrop) );                         m += 256;       // 0x0300, 0x03FF
    
    InsertEvent( EVENT_PROGRAMMING_OPTION_SAVING, 0 );
                                #endif
}                                               //  saveSettings




/*--------------------------------------------------------------------------
 | loadAmount:  load the amount from permanent memory 0x78000-0x78FFF 4kb
 |              mapping 0x78000     MEM_MARKER
 |                      0x78100     usable
 |                      0x78200     groups x MAXGROUP
 |                      0x78C00     amount prices selections 000-99
 |                      0x78D00     amount prices selections 100-199
 |                      0x78E00     reserved for amount prices selections 200-299
 |                      0x78F00     reserved for amount prices selections 300-399
 |
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            loadAmount( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("mem.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1,      sizeof(data1)   );
    read( fileno(fin), usable,      sizeof(usable)  );
    read( fileno(fin), group,       sizeof(group)   );
    read( fileno(fin), amount,      sizeof(amount)  );
    read( fileno(fin), &data2,      sizeof(data2)   );

    if ( data1 != 0x11223344 || data2 != 0x55667788 )
    {
        memset( usable,     0xFF,   sizeof(usable)  );
        memset( group,      0,      sizeof(group)   );
        memset( amount,     0,      sizeof(amount)  );
    }

    fclose(fin);
                                #else
    byte        i, j, k;
    DWORD       m;
    char        marca[16];

    m = (DWORD)0x78000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp( marca, MEM_MARKER, 16 ) != 0 )
        return;
    m += 256;
    memcpy( usable, (void *)m, sizeof(usable) );
    m += 256;
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if ( i == 0 )
            memcpy( &grp_price,  (void *)m, sizeof(grp_price)  );
        m += 256;
    }
    memcpy( &amount[0][0][0], (void *)m, sizeof(amount)/MAX_MACHINE_NUM );
    m += 256;
    memcpy( &amount[1][0][0], (void *)m, sizeof(amount)/MAX_MACHINE_NUM );
    m += 256;
    memcpy( &amount[2][0][0], (void *)m, sizeof(amount)/MAX_MACHINE_NUM );
    m += 256;
    memcpy( &amount[3][0][0], (void *)m, sizeof(amount)/MAX_MACHINE_NUM );    
  
    
    for( k=0; k < MAX_MACHINE_NUM; k++ )
    {
        localmaxprice[k] = 0; 
        localminprice[k] = 0xFFFF;
        for ( i = 0; i < MAXTRAY; i++ )
        {
            for ( j = 0; j < MAXCOLUMN; j++ )
            {   
                if ( amount[k][i][j] > localmaxprice[k] && amount[k][i][j] != 0xffff )  localmaxprice[k] = amount[k][i][j];
                if ( amount[k][i][j] < localminprice[k]                              )  localminprice[k] = amount[k][i][j];
            }
        }
    }
    GetMasterSlavesMaxPrice();
                                #endif
}                                               //  loadAmount




/*--------------------------------------------------------------------------
 | saveAmount:  save the amount on permanent memory, see loadAmount
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveAmount( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("mem.bin","wb")) == NULL )
        return;

    data1 = 0x11223344;
    data2 = 0x55667788;
    write( fileno(fin), &data1,     sizeof(data1)       );
    write( fileno(fin), usable,     sizeof(usable)      );
    write( fileno(fin), group,      sizeof(group)       );
    write( fileno(fin), amount,     sizeof(amount)      );
    write( fileno(fin), &data2,     sizeof(data2)       );

    fclose(fin);
                                #else
    byte        i, j, k, fChanged;
    DWORD       m;
    char        marca[16];

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x78000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp(marca,MEM_MARKER,16) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(usable,(void *)m,sizeof(usable)) != 0 )
        fChanged = TRUE;
    m += 256;
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if ( memcmp(&group[i],(void *)m,sizeof(group[0])) != 0 )
            fChanged = TRUE;
        m += 256;
    }
    if ( memcmp(&amount[0][0][0],(void *)m,sizeof(amount)/MAX_MACHINE_NUM) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&amount[1][0][0],(void *)m,sizeof(amount)/MAX_MACHINE_NUM) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&amount[2][0][0],(void *)m,sizeof(amount)/MAX_MACHINE_NUM) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&amount[3][0][0],(void *)m,sizeof(amount)/MAX_MACHINE_NUM) != 0 )
        fChanged = TRUE;
    m += 256;    
    
    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x78000;
    EraseBlock( m, 1 );

    memcpy( marca, MEM_MARKER,16 );
    WriteFlash256( marca, m, sizeof(marca) );               m += 256;       // 0x0000, 0x00FF
    WriteFlash256( usable, m, sizeof(usable) );             m += 256;       // 0x0100, 0x01FF
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if (i == 0)
            WriteFlash256( &grp_price,  m, sizeof(grp_price) );   
        m += 256;                                                           // 0x0200, 0x0BFF
    }
//#if SLAVE_MACHINE
    WriteFlash256( &amount[0][0][0], m, sizeof(amount)/MAX_MACHINE_NUM ); m += 256;       // 0x0C00, 0x0CFF
    WriteFlash256( &amount[1][0][0], m, sizeof(amount)/MAX_MACHINE_NUM ); m += 256;       // 0x0D00, 0x0DFF
    WriteFlash256( &amount[2][0][0], m, sizeof(amount)/MAX_MACHINE_NUM ); m += 256;       // 0x0E00, 0x0EFF
    WriteFlash256( &amount[3][0][0], m, sizeof(amount)/MAX_MACHINE_NUM ); m += 256;       // 0x0F00, 0x0FFF
    
    InsertEvent( EVENT_PROGRAMMING_OPTION_SAVING, 0 );
    
//#else
//    WriteFlash256( amount, m, sizeof(amount) );             m += 256;       // 0x0C00, 0x0CFF
//#endif
                                #endif
    for( k=0; k < MAX_MACHINE_NUM; k++ )
    {
        localmaxprice[k] = 0; 
        localminprice[k] = 0xFFFF;
        for ( i = 0; i < MAXTRAY; i++ )
        {
            for ( j = 0; j < MAXCOLUMN; j++ )
            {   
                if ( amount[k][i][j] > localmaxprice[k]  && amount[k][i][j] != 0xffff )  localmaxprice[k] = amount[k][i][j];
                if ( amount[k][i][j] < localminprice[k]                               )  localminprice[k] = amount[k][i][j];
            }
        }
    }
    GetMasterSlavesMaxPrice();

}                                               //  saveAmount




/*--------------------------------------------------------------------------
 | loadGroup:  load the gruops from permanent memory
 |                              --------------
 |              mapping 0x7C000     MEM_MARKER
 |                      0x7C100     selGroup x MAXGROUP
 |                      0x7CB00     timeFrames
 |                      0x7CC00     timeDisable
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            loadGroup( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("memGroup.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1,      sizeof(data1)       );
    read( fileno(fin), &selGroup,   sizeof(selGroup)    );
    read( fileno(fin), &timeFrames, sizeof(timeFrames)  );
    read( fileno(fin), &timeDisable,sizeof(timeDisable) );
    read( fileno(fin), &data2,      sizeof(data2)       );

    if ( data1 != 0x11223344 || data2 != 0x55667788 )
    {
        memset( selGroup,   0,      sizeof(selGroup)    );
        memset( timeFrames, 0,      sizeof(timeFrames)  );
        memset( timeDisable,0,      sizeof(timeDisable) );
    }

    fclose(fin);
                                #else
    byte        i;
    DWORD       m;

    m = (DWORD)0x7C000;
    memset( group,          0, sizeof(group) );
    for ( i = 0; i < MAXGROUP; i++ )
    {
        memcpy( &group[i],  (void *)m, sizeof(group[0])  );
        m += 256;
    }
    memcpy( &timeDisable[0], (void *)m, sizeof(timeDisable)  );
    m += 256;
    memcpy( &timeFrames[0], (void *)m, sizeof(timeFrames)  );
    m += 256;
                                #endif
}                                               //  loadGroup




/*--------------------------------------------------------------------------
 | saveGroup:  save the amount on permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveGroup( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("memGroup.bin","wb")) == NULL )
        return;

    data1 = 0x11223344;
    data2 = 0x55667788;
    write( fileno(fin), &data1,     sizeof(data1)       );
    write( fileno(fin), selGroup,   sizeof(selGroup)    );
    write( fileno(fin), timeFrames, sizeof(timeFrames)  );
    write( fileno(fin), timeDisable,sizeof(timeDisable) );
    write( fileno(fin), &data2,     sizeof(data2)       );

    fclose(fin);
                                #else
    byte        i, fChanged;
    DWORD       m;

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x7C000;
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if ( memcmp(&group[i],(void *)m,sizeof(group[0])) != 0 )
            fChanged = TRUE;
        m += 256;
    }
    if ( memcmp(&timeFrames[0],(void *)m,sizeof(timeFrames)) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&timeDisable[0],(void *)m,sizeof(timeDisable)) != 0 )
        fChanged = TRUE;
    m += 256;

    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x7C000;
    EraseBlock( m, 1 );

    for ( i = 0; i < MAXGROUP; i++ )
    {
        WriteFlash256( &group[i],  m, sizeof(group[0]) );               m += 256;       // 0x0000, 0x09FF
    }
    WriteFlash256( &timeDisable[0], m, sizeof(timeDisable) );           m += 256;       // 0x0A00, 0x0AFF
    WriteFlash256( &timeFrames[0],  m, sizeof(timeFrames) );            m += 256;       // 0x0B00, 0x0BFF
    
    InsertEvent( EVENT_PROGRAMMING_OPTION_SAVING, 0 );

                                #endif
}                                               //  saveGroup




/*--------------------------------------------------------------------------
 | homeMotors:  homing motors
 |                              --------------
 | In:  all     0   check if motor at home don't move
 |              1   force motor homing
 | Out:
 +--------------------------------------------------------------------------*/

void            homeMotors( char all )
{
#ifndef __WIN32__
    char        i, r, j, k, an, buf[17], kkk;
    char        alt_k, alt_an;
    DWORD       tsinc, tStartMotor, inp, mask, oldmask, debcnt, tTimeoutMotor, inpMask;
#if FULL_MOTOR
// 06.2012     memset( motorMap, 1, sizeof(motorMap) );
    return ;
#endif
#if TOK_TAKE
#else
    if ( machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM)
#endif
        return;                         // LCM123 doesn't home motors !
    
#if LED_DIMMING
    DWORD       saveDimming;
    saveDimming = dutyLED2;
    LED_OFF();
#endif
    lpdMode(0);
    for( r = 0; r < 10; r++ )
    {
        for( j = 0; j < 10; j++ )
        {
            GET_ACTIVE_MOTOR(k,an, r,j);
            if( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
            {
                alt_k = alt_an = 0xFF;
            }
            else
            {
                GET_ALTERNATE_MOTOR(alt_k,alt_an, r,j);
            }
            if ( ( k < N_K_MAX ) && ( an < N_AN_MAX ) && ( motorMap[k][an] != 0 ) )
            {
                PWR_EN_ON();

                sprintf( buf, "HOMING X:%2d Y:%2d", k, an );
                DispStr( 0, 0, buf );
                Delay(30);  // delay between motor activation

                if( machineType == MACHINA_USIGVC2 )    // there is no HONE posiztion switch
                {
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                }
                else if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) // verificare || machineType == MACHINA_USIGVC2
                {
                    ATTIVA_ANODO( an );
                    Delay(4);
                    if( ( inImage[2] & ( 1 << ( 7 - k ) ) ) == 0 )
                    {
                        STOP_MOTORS();
                        continue;
                    }
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                    START_ALTERNATE_MOTOR(alt_k,alt_an);
                }
                else if( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 || 
                         machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123 || machineType == MACHINA_NAT157 || 
                         machineType == MACHINA_AP123  || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || 
                         machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM)
                {                    
                    if ( all == 0 )
                    {                   // check if motor homed
#if HOME_DEBUG//55=home motor test
                        commPutChar( COMM1, 0x55 );
                        commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                        __disable_interrupt();
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an);
                        testMotorHoming = 2;//must be after START_MOTOR
                        __enable_interrupt();
                        Delay(4);
                        if ( IS_PWR_OFF() )
                        {
                            STOP_MOTORS();    // already at home ( tested at interrupt ), do nothing
                            Delay(4);
                            testMotorHoming = 0;
                            PWR_EN_ON();
                            continue;
                        }
                        testMotorHoming = 0;
                        if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || 
                             machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM || machineType == MACHINA_AMS39 )
                        {
                            RESTART_CURRENT_CALCULATION();
                            START_MOTOR(k,an,tTimeoutMaxMotor);
                            START_ALTERNATE_MOTOR(alt_k,alt_an);
                        }
                    }
                    else
                    {                   // force motor homing
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an);
                    }
                }
                oldmask = inp;
                debcnt = 0;

                              // cerca fronte
                tsinc = GetTickCount();
                do
                {
                    while( GetTickCount() == tsinc );   // every ms
                    tsinc = GetTickCount();

                    if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    {
                        mask = ~inImage[2];
                    }
                    else
                    {
                        if ( SubMachineType == SUB_DIXIE501E )
                            mask = INP0;
                        else
                            mask = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi;
                    }
                    if ( (GetTickCount()-tStartMotor) < ((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2 || machineType == MACHINA_VEILCM)?600:300) )
                        inp = mask;

                    if( mask == oldmask )
                    {
                        if( debcnt >= 25 )
                        {
#if MOTOR_SIMULATION == 0
                            if ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) > tTimeoutMotor )
#endif
                            {                           // stop motor
                                if ( inpMask == 0xFF || ((mask^inp)& mask & inpMask ) == inpMask )
                                {
                                    STOP_MOTORS();
                                    k = 0xFF; an = 0xFF;
                                }
                                else 
                                {           // check which input is at home, and wait for the other
                                    if ( ((mask^inp)& mask & inpMask ) == 0x01 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = k;    // exchange line on NAT157
                                        else
                                            kkk = alt_k;
                                        inpMask = 0x04;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x04 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = alt_k;// exchange line on NAT157
                                        else
                                            kkk = k;
                                        inpMask = 0x01;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x40 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x40;
                                        outImage[OUT_AN0_AN7] |= 0x55;
                                        inpMask = 0x20;
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x20 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x80;
                                        outImage[OUT_AN0_AN7] |= 0xAA;
                                        inpMask = 0x40;
                                    }
                                    debcnt = 0;
                                }
                            }
                            inp = mask;                              
                        }
                        else
                            debcnt++;
                    }
                    else
                        debcnt = 0;

                    oldmask = mask;

                } while( RUNNING_MOTOR(k,an) );
#if MOTOR_SIMULATION == 0
                Delay(200);  // delay between motor activation
#endif
            }
        }
    }
    
#if LED_DIMMING
    dutyLED2 = saveDimming;
#endif
    lpdMode(1);
#endif
}                                               //  homeMotors

void  displayTempFail( char *buf )
{
    if( HealthProblem == HEALTH_FAIL )
    {
        if( doorOpen() )
            sprintf( buf, (char *)MSG_TEMP_FAIL );
        else
            buf[8] = '*';
    }
}

#ifdef MAPPA_MOTORI
static void  mappa_motori( byte kkk )
{
    byte  k;
    char  buf[20];
    byte  mask;

            if ( ( kkk == K_AST && machineType != MACHINA_ROWE5900 && machineType != MACHINA_ROWE6800 && doorOpen() ) ||
                 ( kkk == K_RESET && ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) && doorOpen() ) )
            {
                // visualizzazione mappa dei motori
                sprintf( buf, "MOTOR MAP---    " );
                DispStr(0,0,buf);
                while( testKey() == 0 )
                    ;
                for ( k = 0; ;  )
                {
                    if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123 || 
                         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR )
                        sprintf( buf, "K%02d   %c%c%c%c%c%c%c%c  ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.',
                                                motorMap[k][5]?'X':'.',
                                                motorMap[k][6]?'X':'.',
                                                motorMap[k][7]?'X':'.' );
                    if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
                        sprintf( buf, "K%02d  %c%c%c%c%c%c%c%c%c%c ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.',
                                                motorMap[k][5]?'X':'.',
                                                motorMap[k][6]?'X':'.',
                                                motorMap[k][7]?'X':'.',
                                                motorMap[k][8]?'X':'.',
                                                motorMap[k][9]?'X':'.' );
                    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || 
                        machineType == MACHINA_MERCHA6 ) // MACHINA_MERCHA6 ... DEBUG : ha 6 colonne a 15 righe !!
                        sprintf( buf, "K%02d   %c %c %c %c %c  ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.' );
                    DispStr(0,0,buf);

                    if ( (kkk=testKey()) != 0 )
                        k++;
                    if ( ( ( machineType == MACHINA_AP113    || machineType == MACHINA_AP7000   || machineType == MACHINA_LCM123 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEILCM ) && k >= N_K_AP113 ) ||
                         ( ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AMS39) && k >= N_K_ROWE ) ||
                         ( ( machineType == MACHINA_NAT145   || machineType == MACHINA_NAT147   || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 )&& k >= N_K_NAT147 ) )
                        break;
                }
                // visualizzazione mappa ingressi
                do {
                    k = 7; mask = inImage[2];
                    do {
                        buf[k]=(mask&0x01)+'0';
                        mask >>= 1;
                    }while( k-- != 0 );
                    k = 15; mask = inImage[3];
                    do {
                        buf[k]=(mask&0x01)+'0';
                        mask >>= 1;
                    }while( k-- != 8 );
                    DispStr(0,0,buf);
                } while( testKey() == 0 );
            }
}
#endif

/*
* testMotors : called by a menu function to check motor; each motor is moved to its home position
 */
void            testMotors( void )
{
#ifndef __WIN32__
    char        k, an, buf[17], kkk, timeout_error, retry_motor;
    char        alt_k, alt_an;
    byte        s_tray, s_column;
    DWORD       tsinc, tStartMotor, inp, mask, oldmask, debcnt, tTimeoutMotor, inpMask;


    
#if LED_DIMMING
    DWORD       saveDimming;
    saveDimming = dutyLED2;
    LED_OFF();
#endif
    s_column = 0xff;
    s_tray = 0xff;
    k = 0xff;
    an = 0xff;
    
    timeout_error = FALSE;
    retry_motor = FALSE;
    
    do {
            kkk = testKey();
            if (kkk != 0) 
            {
                if (kkk == K_SX)
                    return;
                if (timeout_error == TRUE) 
                {
                    timeout_error = FALSE;
                    retry_motor = TRUE;
                }
            }
                
            if ( RUNNING_MOTOR(k,an) || timeout_error == TRUE )
                continue;
            if (retry_motor == FALSE)
            {    
                if (s_column < MAXCOLUMN)
                    s_column++;
                if (s_column == MAXCOLUMN) {                    
                    s_column = 0;
                    s_tray++;
                    if ( s_tray >= MAXTRAY) 
                        return;
                } 
                if (s_column == 0xff && s_tray == 0xff)
                {
                    s_column = 0;
                    s_tray = 0;
                } 
            }
            else
                retry_motor = FALSE;
            
            GET_ACTIVE_MOTOR(k,an,s_tray,s_column);           
            
            if( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
            {
                alt_k = alt_an = 0xFF;
            }
            else
            {
                GET_ALTERNATE_MOTOR(alt_k,alt_an,s_tray,s_column);
            }
            if ( ( k > N_K_MAX ) || ( an > N_AN_MAX ) )
            {
                k = 0xff;
                an = 0xff;
                continue;
            }
            sprintf( buf, (char *)MSG_SELECT );
            displaySelection( &buf[11], &buf[13], &buf[15], 1, s_tray, s_column, ' ' );
            DispStr( 0, 0, buf );                
            Delay(500);  // delay between motor activation    

            if ( ( motorMap[k][an] != 0 ) )
            {
                PWR_EN_ON();                

                if( machineType == MACHINA_USIGVC2 )    // there is no HONE posiztion switch
                {
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                }
                else if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) // verificare || machineType == MACHINA_USIGVC2
                {
//                    ATTIVA_ANODO( an );
//                    Delay(4);
//                    if( ( inImage[2] & ( 1 << ( 7 - k ) ) ) == 0 )
//                    {
//                        STOP_MOTORS();
//                        continue;
//                    }
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                    START_ALTERNATE_MOTOR(alt_k,alt_an);
                }
                else if( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 || 
                         machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123 || machineType == MACHINA_NAT157 || 
                         machineType == MACHINA_AP123  || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || 
                         machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM)
                {                    
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                    START_ALTERNATE_MOTOR(alt_k,alt_an);
                }
                oldmask = inp;
                debcnt = 0;

                              // cerca fronte
                tsinc = GetTickCount();
                do
                {
                    while( GetTickCount() == tsinc );   // every ms
                    tsinc = GetTickCount();

                    if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    {
                        mask = ~inImage[2];
                    }
                    else
                    {
                        if ( SubMachineType == SUB_DIXIE501E )
                            mask = INP0;
                        else
                            mask = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi;
                    }
                    if ( (GetTickCount()-tStartMotor) < ((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2 || machineType == MACHINA_VEILCM)?600:300) )
                        inp = mask;                    
                    
                    if( (GetTickCount()-tStartMotor) > tTimeoutMotor )
                        timeout_error = TRUE;
                    
                    if( mask == oldmask || timeout_error == TRUE)
                    {
                        if( debcnt >= 25 )
                        {
#if MOTOR_SIMULATION == 0
                            if ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) > tTimeoutMotor )                           
#endif
                            {                           // stop motor
                                if ( inpMask == 0xFF || ((mask^inp)& mask & inpMask ) == inpMask )
                                {
                                    STOP_MOTORS();
                                    k = 0xFF; an = 0xFF;                                    
                                }
                                else 
                                {           // check which input is at home, and wait for the other
                                    if ( ((mask^inp)& mask & inpMask ) == 0x01 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = k;    // exchange line on NAT157
                                        else
                                            kkk = alt_k;
                                        inpMask = 0x04;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x04 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = alt_k;// exchange line on NAT157
                                        else
                                            kkk = k;
                                        inpMask = 0x01;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x40 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x40;
                                        outImage[OUT_AN0_AN7] |= 0x55;
                                        inpMask = 0x20;
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x20 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x80;
                                        outImage[OUT_AN0_AN7] |= 0xAA;
                                        inpMask = 0x40;
                                    }
                                    debcnt = 0;
                                }
                            }
                            inp = mask;                              
                        }
                        else
                            debcnt++;
                    }
                    else
                        debcnt = 0;

                    oldmask = mask;

                } while( RUNNING_MOTOR(k,an) );
#if MOTOR_SIMULATION == 0
                Delay(200);  // delay between motor activation
#endif
            }
            else {
                sprintf( buf, (char *)MSG_NOT_AVAILABLE );
                k = 0xff;
                an = 0xff;
                DispStr( 0, 0, buf );
                Delay(500);              
            }
    } while (s_tray < 10);
    
#if LED_DIMMING
    dutyLED2 = saveDimming;
#endif
    
#endif
}                                               //  testMotors

BOOL            verifySelectionRunning( void )
{
    if( ON_SELECTING() )
        return TRUE;
    else
        return FALSE;
}

void  displaySelection( char *buf_machine, char *buf_tray, char *buf_column, byte _machine, byte _tray, byte _column, char filler )
{
    char *pCh;
    // format 3 digit : machine ( 1..), tray ( 1.. ), column ( 0.. )
    if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM )
    {
      *buf_machine = ( _machine == 0xFF )?filler:( _machine+'0');
      *buf_tray    = ( _tray == 0xFF )   ?filler:( _tray+'1');
      *buf_column  = ( _column == 0xFF ) ?filler:( _column+'0');
    }
    // format 2 digit : tray ( 1.. ) column ( 0.. )
    else if ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 )
    {           
      *buf_tray    = ( _tray == 0xFF )   ?filler:( _tray+'1');
      *buf_column  = ( _column == 0xFF ) ?filler:( _column+'0');                
/* MANDA IL CASO DEBUG ????
      if ( s_tray < MAXTRAY-1 )     
                    buf[13] = s_tray+'1';
                else {
                    buf[13] = '1';
                    buf[14] = '0';
                }
*/
    }
    // format 2 digit : column ( 0.. ) tray ( 0.. )
    else if (  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
    {
      *buf_column    = ( _tray == 0xFF )   ?filler:( _tray+'0');
      *buf_tray      = ( _column == 0xFF ) ?filler:( _column+'0');
    }
    // format : letter, number  Tray ( A,B,C,D,E,F,G,H.J,K ), number ( 1..10 )
    else
    {
        pCh = (buf_column-2);  // lease space for 2 decimal units ( 00..10 )
        *pCh    = ( _tray == 0xFF )   ?filler:( _tray+'A');
        if(  (machineType == MACHINA_NAT157 || machineType == MACHINA_NAT147 ) && ( *pCh == 'I' ||*pCh == 'J' ) )
            (*pCh)++; // salta I e passa a J, K
        *buf_column  = ( _column == 0xFF ) ?filler:( _column+'0');
        if ( (machineType == MACHINA_NAT145 || machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123) && _column == 0 )
            *(buf_column-1) = '1';
        else
            *(buf_column-1) = ' ';
    }
}

