/***************************************************************************
 ************************						****************************
 ************************		M A I N    		****************************
 ************************						****************************
 ***************************************************************************/
#ifndef	__MAIN_H
#define	__MAIN_H



#include    "def.h"



#define GET_ACTIVE_MOTOR(_k,_an, _tray,_col)                                \
        _k  = abilRemap[machineMotor][_tray][_col].r_k;                     \
        _an = abilRemap[machineMotor][_tray][_col].r_an;

#define GET_ALTERNATE_MOTOR(_k,_an, _tray,_col)                             \
        if ( (machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 )&& NonVolatileSetup.motorCoupled[_tray][_col] != 0 ) \
        {                                                                   \
            _k  = abilRemap[machineMotor][_tray][NonVolatileSetup.motorCoupled[_tray][_col]].r_k;            \
            _an = abilRemap[machineMotor][_tray][NonVolatileSetup.motorCoupled[_tray][_col]].r_an;           \
            if ( _k == 99 || motorMap[_k][_an] == 0 )                       \
                _k = _an = 0xFF;                                            \
        }                                                                   \
        else                                                                \
        {                                                                   \
            _k = _an = 0xFF;                                                \
        }

#define RESTART_CURRENT_CALCULATION()                                       \
        memset( &current[0], 0, sizeof(current) );                          \
        for ( i = 0; i < N_ICAMP; i++ )                                     \
        {                                                                   \
            current[0].camp[i] = 80;                                        \
            current[1].camp[i] = 80;                                        \
        }                                                                   \
        current[0].totCamp = 80*N_ICAMP;                                    \
        current[1].totCamp = 80*N_ICAMP;                                    \
        INPi = 0x60;                                                       

#if MOTOR_SIMULATION

#define START_MOTOR(_k,_an,_t)                                              \
        motorTurns = 0;                                                     \
        testMotorHoming = 0;                                                \
        tStartMotor = GetTickCount();                                       \
        tTimeoutMotor = _t;                                                 \
        inp = (machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )?(~inImage[2]):((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi ; \
        initialInp = inp;                                                   \
        inpMask = 0xFF;                                                     \
        nfront = 0;

#else

#define START_MOTOR(_k,_an,_t)                                              \
        motorTurns = 0;                                                     \
        testMotorHoming = 0;                                                \
        tStartMotor = GetTickCount();                                       \
        tTimeoutMotor = _t;                                                 \
        inp = (machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )?(~inImage[2]):((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi ; \
        initialInp = inp;                                                   \
        inpMask = 0xFF;                                                     \
        nfront = 0;                                                         \
        ATTIVA_CATODO( _k );                                                \
        if (  SubMachineType == SUB_DIXIE501E )   {                         \
            Delay( 20 );                                                    \
            ATTIVA_CATODO( 9 );                                             \
            inp = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi ;          \
        }                                                                   \
        if ( _an != 0xFF ) {                                                \
            if( _an <= 7 )                                                  \
                outImage[OUT_AN0_AN7  ] &= ~(0x01<< _an);                   \
            else if( _an <= 9 )                                             \
                outImage[OUT_SG8_SG15 ] &= ~(0x40<<(_an-8));                \
        }

#endif

#define START_ALTERNATE_MOTOR(_k,_an)                                       \
        if ( _k < N_K_MAX && _an < N_AN_MAX )                               \
        {                                                                   \
            inpMask = ( machineType == MACHINA_AMS39 )?(0x20 | 0x40 ):(0x01 | 0x04); \
            ATTIVA_CATODO( _k );                                            \
            if ( _an != 0xFF ) {                                            \
                if( _an <= 7 )                                               \
                    outImage[OUT_AN0_AN7  ] &= ~(0x01<< _an);                \
                else if( _an <= 9 )                                          \
                    outImage[OUT_SG8_SG15 ] &= ~(0x40<<(_an-8));             \
            }                                                               \
        } /* will use the same TIMEOUT ste by th epreviuos START_MOTOR(_k,_an,_t) */

#define STOP_SINGLE_MOTOR(_k)                                               \
        if ( _k <= 7 )                                                      \
            outImage[OUT_SG0_SG7  ] &= (0xFF- (0x01<< _k)   );              \
        else                                                                \
            outImage[OUT_SG8_SG15 ] &= (0xFF- (0x01<<(_k-8)));

#define STOP_MOTORS()                                                       \
        if( SubMachineType == SUB_DIXIE501E ) {                             \
            STOP_SINGLE_MOTOR( 9 );                                         \
            Delay( 20 );                                                    \
        }                                                                   \
        outImage[OUT_AN0_AN7  ] = 0xFF;                                     \
        outImage[OUT_SG0_SG7  ] = 0x00;                                     \
        outImage[OUT_SG8_SG15 ] =( ( machineType == MACHINA_ROWE5900 ||     \
                                     machineType == MACHINA_AMS39    ||     \
                                     machineType == MACHINA_USIGVC2    )? 0xC0:0x00 ); \
        tStartMotor = 0;                                                    \
        nfront = 0xFF;                                                      \
        deactivateMotor();


#define AUX_LED_ON()                                                        \
        outImage[OUT_AN0_AN7]   &= ~( LED2_MASK_AA | LED3_MASK_AA );        \
        outImage[OUT_SG8_SG15 ] &= ~( LED2_MASK_AK | LED3_MASK_AK );        \
        outImage[OUT_SG8_SG15 ] |=  ( LED2_MASK_KK | LED3_MASK_KK );

#define AUX_LED_OFF()                                                       \
        outImage[OUT_AN0_AN7 ]  |=  ( LED2_MASK_AA | LED3_MASK_AA );        \
        outImage[OUT_SG8_SG15 ] |=  ( LED2_MASK_AK | LED3_MASK_AK );        \
        outImage[OUT_SG8_SG15 ] &= ~( LED2_MASK_KK | LED3_MASK_KK );

#if RSR903
#define RUNNING_MOTOR(_k,_an)                                               \
        ( ( FIO2PIN & 0x3FF ) != 0x3FF )
#else
#define RUNNING_MOTOR(_k,_an)                                               \
        (_k != 0xFF && _an != 0xFF)
#endif

#define DISABLE_MOTOR_MAP(_k,_an)                                           \
        if ( _k < N_K_MAX && _an < N_AN_MAX )                               \
            motorMap[_k][_an] = 0;

#define RESET_FALL_FAILS(_tray,_column)                                     \
        nF.nFails[_tray][_column] = 0;                                      \
        saveSettings();

#define INC_FALL_FAILS(_tray,_column)                                       \
        if ( nF.nFails[_tray][_column] < MAX_SEL_FAILED )                   \
            nF.nFails[_tray][_column] += 1;                                 \
        saveSettings();

/*
#define ATTIVA_CATODO( _k )                                                 \
        if ( _k <= 7 )                                                      \
          outImage[OUT_SG0_SG7  ] |=  (0x01<< _k);                          \
        else                                                                \
          outImage[OUT_SG8_SG15 ] |=  (0x01<<(_k-8));

#define ATTIVA_ANODO( _an )                                                 \
        if( _an <= 7 )                                                      \
          outImage[OUT_AN0_AN7  ] &= ~(0x01<< _an);                         \
        else if( _an <= 9 )                                                 \
          outImage[OUT_SG8_SG15 ] &= ~(0x40<<(_an-8));
*/
extern byte nfront;
extern DWORD    exeSaveSettings;
extern const char fwRelease[4];

char            *getBootVer( void );
_UCHAR          testKey( void );
void            getFirmwareRelease( char *_buf );
BOOL            programMachineType( void );
BOOL            checkMachineType( void );
void            initialSettings( void );
void            loadSettings( void );
void            saveSettings( void );
void            loadAmount( void );
void            saveAmount( void );
void            loadGroup( void );
void            saveGroup( void );
void            homeMotors( char all );
void            testMotors( void );
BOOL            programmingMode( void );
BOOL            vendingCycle( void );
BOOL            isTimedDisable( void );
dword           setLedDimming( dword percDimming );
void            deactivateMotor( void );
BOOL            readMotorAvailability( byte _tray, byte _column );
BOOL            verifySelectionRunning( void );

void memDump(void);


#endif
