/***************************************************************************
 ************************						****************************
 ************************	  M C I . H	        ****************************
 ************************						****************************
 ***************************************************************************/
#ifndef	__MCI_H
#define	__MCI_H

#ifdef __MCI_C
#define typemci
#else
#define typemci extern
#endif




/* SD/MMC Command list, per MMC spec. SD Memory Card Spec. Simplified version */
#define GO_IDLE_STATE		0		/* GO_IDLE_STATE(MMC) or RESET(SD) */
#define SEND_OP_COND		1		/* SEND_OP_COND(MMC) or ACMD41(SD) */
#define ALL_SEND_CID		2		/* ALL SEND_CID */
#define SET_RELATIVE_ADDR	3		/* SET_RELATE_ADDR */
#define SET_ACMD_BUS_WIDTH	6
#define SELECT_CARD			7		/* SELECT/DESELECT_CARD */
#define SEND_IF_COND        8
#define SEND_CSD			9		/* SEND_CSD */
#define STOP_TRANSMISSION	12		/* Stop either READ or WRITE operation */
#define SEND_STATUS			13		/* SEND_STATUS */
#define SET_BLOCK_LEN		16		/* SET_BLOCK_LEN */
#define READ_SINGLE_BLOCK	17		/* READ_SINGLE_BLOCK */
#define WRITE_BLOCK			24		/* WRITE_BLOCK */
#define SEND_APP_OP_COND	41		/* ACMD41 for SD card */		
#define APP_CMD				55		/* APP_CMD, the following will a ACMD */

#define     OCR_INDEX_HC        0x40000000L
#define     OCR_INDEX           0x00200000L
//EEE#define OCR_INDEX			0x00FF8000
// #define OCR_INDEX			0x00000000
// #define OCR_INDEX			1 << 23 

#define CARD_STATUS_ACMD_ENABLE		BIT5
#define CARD_STATUS_RDY_DATA		BIT8
#define CARD_STATUS_CURRENT_STATE	(0x0F << 9)
#define CARD_STATUS_ERASE_RESET		BIT13

#define SLOW_RATE			1
#define NORMAL_RATE			2

#define CARD_UNKNOWN		0
#define MMC_CARD			1
#define SD_CARD				2
#define SDHC_CARD           4

#define MCLKDIV_SLOW		0x31
#define MCLKDIV_NORMAL		1//3//0x7

#define DATA_TIMER_VALUE	0x10000

#define EXPECT_NO_RESP		0
#define EXPECT_SHORT_RESP	1
#define EXPECT_LONG_RESP	2

/* For the SD card I tested, the minimum block length is 512 */
/* For MMC, the restriction is loose, due to the variety of SD and MMC
card support, ideally, the driver should read CSD register to find the 
speed and block length for the card, and set them accordingly. */
/* In this driver example, it will support both MMC and SD cards, it
does read the information by send SEND_CSD to poll the card status,
but, it doesn't configure them accordingly. this is not intended to 
support all the SD and MMC card. */ 

/* DATA_BLOCK_LEN table
	DATA_BLOCK_LEN			Actual Size( BLOCK_LENGTH )
	11						2048
	10						1024
	9						512
	8						256
	7						128
	6						64
	5						32
	4						16
	3						8
	2						4
	1						2
*/

/* To simplify the programming, please note that, BLOCK_LENGTH is a multiple 
of FIFO_SIZE */
#define DATA_BLOCK_LEN		9	/* Block size field in DATA_CTRL */
#define BLOCK_LENGTH		(1 << DATA_BLOCK_LEN)
								/* for SD card, 128, the size of the flash */
								/* card is 512 * 128 = 64K */
#if SECTOR_SIZE != 512
#undef  SECTOR_SIZE
#define SECTOR_SIZE         BLOCK_LENGTH
#endif

#define BLOCK_NUM			0x80		
#define FIFO_SIZE			16

#define BUS_WIDTH_1BIT		0
#define BUS_WIDTH_4BITS		10

/* MCI Status register bit information */
#define MCI_CMD_CRC_FAIL	BIT0
#define MCI_DATA_CRC_FAIL	BIT1
#define MCI_CMD_TIMEOUT		BIT2
#define MCI_DATA_TIMEOUT	BIT3
#define MCI_TX_UNDERRUN		BIT4
#define MCI_RX_OVERRUN		BIT5
#define MCI_CMD_RESP_END	BIT6
#define MCI_CMD_SENT		BIT7
#define MCI_DATA_END		BIT8
#define MCI_START_BIT_ERR	BIT9
#define MCI_DATA_BLK_END	BIT10
#define MCI_CMD_ACTIVE		BIT11
#define MCI_TX_ACTIVE		BIT12
#define MCI_RX_ACTIVE		BIT13
#define MCI_TX_HALF_EMPTY	BIT14
#define MCI_RX_HALF_FULL	BIT15
#define MCI_TX_FIFO_FULL	BIT16
#define MCI_RX_FIFO_FULL	BIT17
#define MCI_TX_FIFO_EMPTY	BIT18
#define MCI_RX_FIFO_EMPTY	BIT19
#define MCI_TX_DATA_AVAIL	BIT20
#define MCI_RX_DATA_AVAIL	BIT21

/* Error code on the command response. */
#define INVALID_RESPONSE	0xFFFFFFFF




DWORD           MCI_Init( void );
DWORD           MCI_CardInit( void );
void            Set_MCIClock( DWORD ClockRate );
DWORD           MCI_Go_Idle_State( void );
DWORD           MCI_Send_OP_Cond( void );
DWORD           MCI_Send_ACMD_OP_Cond( void );
void            MCI_SendCmd( DWORD CmdIndex, DWORD Argument, DWORD ExpectResp, DWORD AllowTimeout );
DWORD           MCI_GetCmdResp( DWORD ExpectCmdData, DWORD ExpectResp, DWORD *CmdResp );
DWORD           MCI_Send_ACMD( void );
DWORD           MCI_Check_CID( void );
DWORD           MCI_Set_Address( void );
DWORD           MCI_Send_CSD( void *_csd );
DWORD           MCI_Select_Card( void );
DWORD           MCI_Set_BlockLen( DWORD blockLength );
DWORD           MCI_CheckStatus( void );
DWORD           MCI_Send_Stop( void );
DWORD           MCI_Send_Status( void );
DWORD           MCI_Read_Block( DWORD blockNum, byte *_block, int *_size );
DWORD           MCI_Write_Block( DWORD blockNum, byte *_block, int *_size );
DWORD           MCI_Send_Read_Block( DWORD blockNum );
DWORD           MCI_Send_Write_Block( DWORD blockNum );
DWORD           MCI_Send_ACMD_Bus_Width( DWORD buswidth );




#undef	typemci
#endif
