/*
  MENU.C
*/

#include <stdio.h>
#include <string.h>

#include "def.h"
#include "ds2341.h"
#include "hwinit.h"
#include "ram.h"
#include "KEYBOARD.H"
#include "LCD7SEG.H"
#include "display.h"
#include "event.h"
#include "funzioni.h"
#include "graphics.h"
#include "main.h"
#include "timer.h"
#include "messaggi.h"
#include "modem.h"
#include "menu.h"
#include "mmc.h"
#include "optical.h"
#include "inizial.h"
#include "ram.h"
#include "uart.h"
extern dword AuditData[AUDIT_DATA_SIZE];

/* main.c */
void  displaySelection( char *buf_machine, char *buf_tray, char *buf_column, byte _machine, byte _tray, byte _column, char filler );

#define NUM_LEVEL            5

typedef struct __DEFAULT_NUMBER{
  unsigned long address;
  unsigned long min;
  unsigned long max;
  unsigned char nCifre;
  unsigned char nByte;
}DEFAULT_NUMBER;
const DEFAULT_NUMBER defNumber [];

typedef struct __DEFAULT_TEXT{
  unsigned long address;
  unsigned char typeText;
  unsigned char nByte;
}DEFAULT_TEXT;
const DEFAULT_TEXT defText [];

const DEFAULT_TEXT defText [] = {
  {                                          0, 0,  0},
};

void            testSaveSettings( void );

void            selection( char key, byte *tray, byte *column );
void            selectDisplay( byte *tray, byte *column );
static void     selectDisplayPos( byte *tray, byte *column, byte pos );
byte            getKeymenu( byte esc );
unsigned short  EditNumBox(unsigned char typeVar, unsigned char readOnly, byte _nDecimal );
void            VisuaNumBox(unsigned char typeVar, const char *message);
unsigned short  edSetLockout( unsigned char grp, unsigned char typeVar );
#if SLAVE_MACHINE
byte            SlaveMAchineNumber = 0;
#endif



const REFLISTBOX refListBox[3];

char            editData[256];        // buffer edit dati
char            tempMsg[40];
char            EditNumBoxModificato;

byte            superUser;
byte            K_SX, K_DX, K_UP, K_DW, K_ESC, K_OK;
DWORD           GestioneMenuForcedByHost = 0;
byte            exitMenuForcedByHost = FALSE;

                                    //  AP113       NAT147      ROWE5900    ROWE6800    NAT157  AP7000  LCM123  AP123   VEIDOOR     NAT145      AMS39   VEI147   USIGVC2 MERCHAND6  VEILCM
const byte tab_K_SX [TOTAL_MACHINE] = { K_D,        K_D,        K_5,        K_5,        K_D,    K_D,    K_A,    K_4,    K_4,        K_D,        K_4,    K_4,     K_4    ,K_4      , K_4         };
const byte tab_K_DX [TOTAL_MACHINE] = { K_C,        K_F,        K_7,        K_7,        K_F,    K_C,    K_C,    K_6,    K_6,        K_C,        K_6,    K_6,     K_6    ,K_6      , K_6         };
const byte tab_K_UP [TOTAL_MACHINE] = { K_A,        K_B,        K_2,        K_2,        K_B,    K_A,    K_B,    K_2,    K_2,        K_A,        K_2,    K_2,     K_2    ,K_2      , K_2         };
const byte tab_K_DW [TOTAL_MACHINE] = { K_B,        K_H,        K_0,        K_0,        K_H,    K_B,    K_F,    K_8,    K_8,        K_B,        K_8,    K_8,     K_8    ,K_8      , K_8         };
const byte tab_K_ESC[TOTAL_MACHINE] = { K_AST,      K_AST,      K_RESET,    K_RESET,    K_AST,  K_AST,  K_AST,  K_RESET,K_RESET,    K_AST,      K_RESET,K_RESET, K_RESET,K_RESET  , K_RESET     };
const byte tab_K_OK [TOTAL_MACHINE] = { K_ENTER,    K_ENTER,    K_RESET,    K_RESET,    K_ENTER,K_14,   K_ENTER,K_RESET,K_RESET,    K_ENTER,    K_RESET,K_RESET, K_RESET,K_RESET  , K_RESET     };
// numerico liberi: K_1, K_3, K_9

extern struct _DISCOUNT_PAR_ sDiscountPar; 

void            InitGestioneMenu( void )
{
    K_SX = tab_K_SX[machineType];
    K_DX = tab_K_DX[machineType];
    K_UP = tab_K_UP[machineType];
    K_DW = tab_K_DW[machineType];
    K_ESC = tab_K_ESC[machineType];
    K_OK = tab_K_OK[machineType];
}


// gestione dei menu
void            GestioneMenu( void )
{
    unsigned short i;
//    unsigned short j;
    unsigned char key;
    unsigned char level;
    const MENU  *menu[NUM_LEVEL];
//    const MENU  *temp;
    DWORD       number;

    DispStr( 0, 0, (char *)MSG_ATTESA );
    testMMCpresence();

    LcdErase(TUTTI);

    InitGestioneMenu();
    
    if ( NonVolatileSetup.passcode > (dword)0x0000 && NonVolatileSetup.passcode < (dword)0xFFFF )
    {
        DispStr( 0, 0, (char *)IN_PASSCODE );
        *((DWORD *)editData) = 0;
        if ( EditNumBox(POSPRICE, 0, 0) == K_SX )
        {
            nPasscode = 0;
            return;
        }
                                        // check global passcode
        if ( NonVolatileSetup.passcode != *((DWORD *)editData) )
        {
            if ( (nPasscode == 0 && *((DWORD *)editData) == PASSWORD_BACKDOOR_1) ||
                 (nPasscode == 1 && *((DWORD *)editData) == PASSWORD_BACKDOOR_2) ||
                 (nPasscode == 2 && *((DWORD *)editData) == PASSWORD_BACKDOOR_3) )
                nPasscode++;
            if ( nPasscode != 3 )
                return;
        }
        nPasscode = 0;                  // password OK
        menu[0] = &n1000;
    }
    else {
                                        // passwordAudit input
        if ( NonVolatileSetup.passcodeAudit > (dword)0x0000 && NonVolatileSetup.passcodeAudit < (dword)0xFFFF )
        {
            DispStr( 0, 0, (char *)IN_PASSCODE );
            *((DWORD *)editData) = 0;
            if ( EditNumBox(POSPRICE, 0, 0) == K_SX )
            {
                nPasscode = 0;
                return;
            }
                                            // check global passcode
            if ( NonVolatileSetup.passcodeAudit != *((DWORD *)editData) )
            {
                if ( (nPasscode == 0 && *((DWORD *)editData) == PASSWORD_BACKDOOR_1) ||
                     (nPasscode == 1 && *((DWORD *)editData) == PASSWORD_BACKDOOR_2) ||
                     (nPasscode == 2 && *((DWORD *)editData) == PASSWORD_BACKDOOR_3) )
                {
                    nPasscode++;
                    if ( nPasscode != 3 )
                        return;             // passwordAudit enabled, all backddor has been inserted correct
                    else
                    {
                        nPasscode = 0;      // passwordAudit enabled, some of the backdoor password enabled, but not all of them
                        menu[0] = &n9000;
                    }
                }
                else
                    menu[0] = &n9001;       // passwordAudit enabled, but no correct password inserted, only aduit enabled
            }
            else
            {                               // passwordAudit is inserted, enable full menu
                nPasscode = 0;
                menu[0] = &n9000;
            }
        }
        else
        {                                   // no passwrod is enabled
            nPasscode = 0;
            menu[0] = &n9000;
        }
    }
    

                                        // menu' selection
    level = 0;
    superUser = FALSE;
    number = 0;
//    VisuaNumMenu( (char*)menu[level]->ptrMex );
    VisuaMenu( (char*)message[menu[level]->ptrNum] );
    while(1){
        testSaveSettings();

        if ( (menu[level] -> ptrFunc != (word(*)(unsigned long param1))ListBox &&
              menu[level] -> ptrFunc != (word(*)(unsigned long param1))EditTextBox &&
              menu[level] -> ptrFunc != (word(*)(unsigned long param1))edValoreAudit &&
              menu[level] -> ptrFunc != (word(*)(unsigned long param1))recvDate &&
              menu[level] -> ptrFunc != NULL) ||
              (menu[level] -> ptrFunc == 0 && menu[level] -> ptrData == 0) || key == 0 )
        {
            if( (key=getKeymenu(K_SX)) == K_SX && level == 0 )
            {
                GestioneMenuForcedByHost = 0;
                break;   // esce dal menu se livello = 0
            }
        }
        if ( key != 0 )
        {
            if ( key >= K_0 && key <= K_9 )             // operator's password
            {
                number = ((number%10000)*10)+(key-K_0);
                if ( number == PASSWORD_ID )
                {                                       // enable super-user activities
                    number = 0;
                    superUser = TRUE;
                    BuzzerOn(1000);
                }
                else if ( number == PASSWORD_INITIALIZE && superUser )
                {                                       // intialization function
                    number = 0;
                    menuInitialization(0);
                }
                else if ( number == PASSWORD_DEX )
                {                                       // intialization function
                    number = 0;
                    menuFullDex(0);
                }
            }
            else
                number = 0;
            if ( key == K_UP )                          // arrow up
            {
                for ( i = 0; i < 10; i++ )
                {
                    menu[level] = menu[level]->menuPrec;
                    if ( menu[level]->ptrEnable == NULL || (menu[level]->ptrEnable(menu[level]->ptrData)) == 0 )
                        break;
                }
            }
            else if ( key == K_DW )                     // arrow down
            {
                for ( i = 0; i < 10; i++ )
                {
                    menu[level] = menu[level]->menuSucc;
                    if ( menu[level]->ptrEnable == NULL || (menu[level]->ptrEnable(menu[level]->ptrData)) == 0 )
                        break;
                }
            }
            else if ( key == K_DX || key == K_OK )      // enter menu'
            {
/*
EXEC_FUNCTION:
*/
                if(menu[level] -> menuEnter != NULL){   // se esiste un sottomenu
                  if(menu[level] -> ptrFunc != 0 && (menu[level] -> ptrFunc(menu[level] -> ptrData)) == K_OK){ // sottomenu con accesso
                      menu[level + 1] = menu[level] -> menuEnter;
                      level++;
                  }
                  else if(menu[level] -> ptrFunc == 0){
                        menu[level + 1] = menu[level] -> menuEnter;
                        level++;
                  }
                }
                else if(menu[level] -> ptrFunc != 0 && menu[level] -> ptrFunc != (word(*)(unsigned long param1))EditTextBox){
                    key = menu[level] -> ptrFunc(menu[level] -> ptrData);
                    if(key == K_OK) menu[level] = menu[level] -> menuSucc;
                    else if(key == K_C) level--;
                }
            }
            else if((key == K_SX || key == K_C) && level != 0) {//esce dal menu'
                level--;
            }
            else if(key >= K_0 && key <= K_9 /*EEE&&  menu[level] -> menuEnter != 0*/){
/*
                for(i = 0, j = key - K_0 + '0', temp = menu[level]; i < 10; i++){
                    if( message[temp -> ptrNum][level] == j ) break;
                    else                           temp =  temp -> menuSucc;
                }
                if(i < 10){ // dopo aver selezionato il menu eseguo il comando
                    menu[level] = temp;
                    key = K_OK;
                    goto EXEC_FUNCTION;
                }
*/
            }
            if ( menu[level] -> menuEnter == NULL )
            {
//                VisuaNumMenu((char*)menu[level] -> ptrMex);
                if(menu[level] -> ptrFunc == (word(*)(unsigned long))ListBox){ // list box
                    do {
                        strcpy(tempMsg, message[menu[level]->ptrNum] );
                        strcat(tempMsg,"\n");
                        key = i = ListBox(menu[level] -> ptrData);
                    } while(i == (K_C | 0x100) || i == (K_SX | 0x100));
                    if(key == K_OK) key = K_DW;                // punta alla voce successiva
                }
                else if(menu[level] -> ptrFunc == (word(*)(unsigned long))EditTextBox){  // edit text box
                    do {
                        strcpy(tempMsg, message[menu[level]->ptrNum] );
                        key = i = EditTextBox(menu[level] -> ptrData, 0);
                    } while(i == (K_C | 0x100) || i == (K_SX | 0x100));
                    if(key == K_OK) key = K_DW;                // punta alla voce successiva
                }
                else if(menu[level] -> ptrData != 0 && ( menu[level] -> ptrFunc == 0 ||
                                                         menu[level] -> ptrFunc == (word(*)(unsigned long))recvDate ) ) {    // num box
                    do {
                        strcpy(tempMsg, &message[menu[level]->ptrNum][level+1] );
                        DispStr( 0, 0, tempMsg );
                        key = i = EditNumBox(menu[level] -> ptrData, 0, 0/*posVirgola*/);
                    } while(i == (K_C | 0x100) || i == (K_SX | 0x100));
                    if ( key == K_OK )
                    {
                        if ( menu[level] == menu[level] -> menuSucc )
                        {
                            key = K_SX;                 // esci dal menu'
                            saveSettings();
                        }
                        else
                            key = K_DW;                 // punta alla voce successiva
                    }
                    if ( key == K_ESC )
                        key = K_SX;
                }
                else if ( menu[level] -> ptrFunc != NULL ) {  // user function
                    VisuaMenu((char*)message[menu[level]->ptrNum] );
                    key = menu[level] -> ptrFunc(menu[level] -> ptrData);
                    if(menu[level] -> ptrFunc == (word(*)(unsigned long))edValoreAudit)
                    {
                        if( key != K_DW && key != K_UP ) level--;
                    }
                    else
                      level--;
                    VisuaMenu((char*)message[menu[level]->ptrNum]);
                }
                else{
                    DispClrScr();
                    VisuaMenu((char*)message[menu[level]->ptrNum]);
                }
            }
            else{
//                VisuaNumMenu((char*)menu[level] -> ptrMex);
                VisuaMenu((char*)message[menu[level]->ptrNum]);
            }
        }
    }
    CursorOff();
}

// sceglie 1 parametro dalla lista proposta scelta con value
// fa riferimento alla tabella refListBox per leggere i dati delle variabili
// fa la ricerca della prima voce relativa alla lettera selezionata. Le voci devono avere la prima lettera maiuscola
// (mentre quella di default minuscola
// restituisce il tasto premuto + 0x100 se uscito durante l'editing
unsigned short ListBox(unsigned long value)
{
#if 0
  unsigned short i,j;
  unsigned char key;
  unsigned char indexVoice;
  unsigned char keyAscii;

  if(refListBox[value].bitMask == 0){
    indexVoice = *refListBox[value].ptrVar;
    if((value == ZONA_CALIBRAZIONE || value == ZONA_DESTINAZIONE) && *refListBox[value].ptrVar == 0) indexVoice = 58;  // default milano
  }
  else{
    j = refListBox[value].bitMask;
    i = *((short*)refListBox[value].ptrVar) & refListBox[value].bitMask;
    for( ; (j & 1) == 0; i >>= 1, j >>= 1);
    indexVoice = i;
  }
  DispClrScr();
  VisuaMenu(tempMsg);
  strcpy(tempMsg,refListBox[value].string[indexVoice]);
  DispStr(1,0,tempMsg);
  while((key = getKeymenu( K_ESC )) == 0);
  if( key == K_ESC ) return 0;    // debug
  if(key == K_DX || (key >= K_PLU1 && key <= K_PLU30)){
    do{
      if(key != 0){
        if(key == K_DW){
            if(indexVoice < (refListBox[value].size - 1)) indexVoice++;      // freccia su
            else                                          indexVoice = 0;
        }
        else if(key == K_UP){
            if(indexVoice != 0) indexVoice--;      // freccia giu
            else                indexVoice = refListBox[value].size - 1;
        }
        else if(key >= K_PLU1 && key <= K_PLU26){
          keyAscii = tabKeyToAscii[key];
          for(i = 1, j = 999; i < (refListBox[value].size - 1); i++){
            if(((char)refListBox[value].string[i][0]) >= 'A' && ((char)refListBox[value].string[i][0]) <= 'Z' &&
               ((char)refListBox[value].string[i][0]) >= keyAscii && ((char)refListBox[value].string[i][0] - keyAscii) < j){
              key = i;
              j = ((char)refListBox[value].string[i][0]) - keyAscii;
            }
          }
          if(j != 999) indexVoice = key;
        }
        strcpy(tempMsg, MSG_VALUE);
        strcpy(tempMsg + 8,refListBox[value].string[indexVoice]);
        VisuaMenu(tempMsg);
      }
    }while((key = getKeymenu( K_SX )) != K_C && key != K_SX && key != K_OK);
    if(key == K_OK){
      if(refListBox[value].bitMask == 0)
        *refListBox[value].ptrVar = indexVoice;
      else{   // gestione flag
        j = refListBox[value].bitMask;
        i = indexVoice;
        for( ; (j & 1) == 0; i <<= 1, j >>= 1);
        *((short*)refListBox[value].ptrVar) &= ~refListBox[value].bitMask;
        *((short*)refListBox[value].ptrVar) |=  i;
      }
    }
  }
  else{
    if(key == K_OK || key == K_SX) return(key);
    if(key == K_C) return(K_SX);
    return(key);
  }
  return(key | 0x100);
#else
    return 0;
#endif
}

const DEFAULT_NUMBER defNumber [] = {
  {                                                0,       0,                   0, 0, 0                                    },
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // POSPRICE = 1,
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // TRAYPRICE
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPPRICE
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // ALLPRICE
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPPROG
  {(unsigned long) ((DWORD*)&NonVolatileSetup.fallSensorMode),0,                 6, 1, sizeof(DWORD)                        },  // FALLPROG
  {(unsigned long)&((_dateTime*)editData) -> day,           1,                  31, 2, sizeof(((_dateTime*)editData) -> day)},  // giorno
  {(unsigned long)&((_dateTime*)editData) -> month,         1,                  12, 2, sizeof(((_dateTime*)editData) -> month)},// mese
  {(unsigned long)&((_dateTime*)editData) -> year,       2006,                2050, 4, sizeof(((_dateTime*)editData) -> year)}, // anno
  {(unsigned long)&((_dateTime*)editData) -> hour,          0,                  23, 2, sizeof(((_dateTime*)editData) -> hour)}, // ore
  {(unsigned long)&((_dateTime*)editData) -> min,           0,                  59, 2, sizeof(((_dateTime*)editData) -> min)},  // minuti
  {(unsigned long)&((_dateTime*)editData) -> sec,           0,                  59, 2, sizeof(((_dateTime*)editData) -> sec)},  // secondi
  {(unsigned long) ((DWORD*)editData),                      0,                   1, 1, sizeof(DWORD)                        },  // TOGGLEPROG
  {(unsigned long)&(editData[0]),                           0,                  99, 2, sizeof(long)                         },  // ID_VEN           id venditore
  {(unsigned long)&(editData[sizeof(long)]),                0,              999999, 6, sizeof(long)                         },  // PIN_VEN          pin vnditore
  {(unsigned long)&(editData[0]),                           0,                  99, 2, MSG_ADV_LEN                          },  // ADV_MSG
  {(unsigned long)&(editData[0]),                           0,                  99, 2, sizeof(DWORD)                        },  // ADV_DELAY
  {(unsigned long)&(editData[0]),                           0,                   9, 1, sizeof(DWORD)                        },  // ADV_SPEED
  {(unsigned long) ((DWORD*)editData),                      0,                9999, 4, sizeof(DWORD)                        },  // GROUPSEL
  {(unsigned long)&(editData[0]),                           0,                  99, 2, sizeof(DWORD)                        },  // SETHORARIOS
  {(unsigned long)&(editData[0]),                           0,                  99, 2, MSG_ADV_LEN                          },  // ASSET_ID
  {(unsigned long)&(editData[0]),                           0,                  99, 2, MSG_ADV_LEN                          },  // SETTINGS_ID
  {(unsigned long)&(editData[0]),                           0,                 100, 3, sizeof(DWORD)                        },  // PERC_DIMMING
  {(unsigned long)&(editData[0]),                           0,                3000, 3, sizeof(DWORD)                        },  // TIME_DIMMING
  {(unsigned long)&(editData[0]),                           0,                   3, 1, sizeof(DWORD)                        },  // SENSITIVITY 
  {(unsigned long) ((DWORD*)editData),                      0,                9999, 4, sizeof(DWORD)                        },  // PASSWORD
  {(unsigned long)&(editData[0]),                           0,                   9, 1, sizeof(DWORD)                        },  // DISABLE_DAY
  {(unsigned long)&(editData[0]),                           0,                  99, 1, sizeof(DWORD)                        },  // DISABLE_HHMM
  {(unsigned long)&(editData[0]),                           0,                5000, 4, sizeof(DWORD)                        },  // PERC_TAX
  {(unsigned long)&(editData[0]),                          50,                 500, 3, sizeof(DWORD)                        },  // WIN_VALUE
  {(unsigned long)&(editData[0]),                           0,                  99, 2, sizeof(DWORD)                        },  // TEMP_VALUE
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPHEALTH
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // POSPRICE_S1
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // TRAYPRICE_S1
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPPRICE_S1
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // ALLPRICE_S1
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // POSPRICE_S2
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // TRAYPRICE_S2
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPPRICE_S2
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // ALLPRICE_S2
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // POSPRICE_S3
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // TRAYPRICE_S3
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // GROUPPRICE_S3
  {(unsigned long) ((DWORD*)editData),                      0,   MAXSELECTIONPRICE, 5, sizeof(DWORD)                        },  // ALLPRICE_S3
  {(unsigned long) ((DWORD*)editData),                      0,                  16, 2, sizeof(DWORD)                        },  // MAX_NUM_SEL  
};


// chiamata dai menu per editare i parametri
void VisuaNumBox(unsigned char typeVar, const char *message)
{
  strcpy(tempMsg, message);
  EditNumBox(typeVar,0,0);
}

void Reformat(char *Cq, unsigned char typeVar, byte _nDecimal )
{
  char i,k,l;

  k = l = strlen(Cq);
  *(Cq + defNumber[typeVar].nCifre + 1) = 0;
  for(i = 0; i <= defNumber[typeVar].nCifre; i++){
    if( _nDecimal > i){
      if(l != 0){
        *(Cq + defNumber[typeVar].nCifre - i) = *(Cq + k - i - 1);
        l--;
      }
      else
        *(Cq + defNumber[typeVar].nCifre - i) = '0';
    }
    else if( _nDecimal == i)
      *(Cq + defNumber[typeVar].nCifre - i) = '.';
    else{
      if(*(Cq + defNumber[typeVar].nCifre - i + 1) == '.' && l == 0) *(Cq + defNumber[typeVar].nCifre - i) = '0';
      else if(l != 0){
        *(Cq + defNumber[typeVar].nCifre - i) = *(Cq + k - i);
        l--;
      }
      else
        *(Cq + defNumber[typeVar].nCifre - i) = ' ';
    }
  }
}

// edita un numero (deve essere inserito in defNumber), mentre il mex in tempMsg
unsigned short  EditNumBox( unsigned char typeVar, unsigned char readOnly, byte _nDecimal )
{
    unsigned long valore;
    unsigned long valore1;
    unsigned long maxValore1;
    char        bufCifra[16], key;
    unsigned char dataReady;
    unsigned char nDigit;
    char        primaRiga[LCDCOL+1];

    valore = 0;
    EditNumBoxModificato = 0;
    memcpy( &valore, (char*)defNumber[typeVar].address, defNumber[typeVar].nByte );

    memcpy( primaRiga, bufferLCD, LCDCOL);
    primaRiga[LCDCOL] = '\0';

    DispClrScr();
    if ( _nDecimal == 0 )
        sprintf( tempMsg, "%*d", defNumber[typeVar].nCifre, valore );
    else
    {
        sprintf( tempMsg, "%d", valore );
        Reformat( tempMsg, typeVar, _nDecimal );
    }
    strcpy( &primaRiga[LCDCOL-strlen(tempMsg)], tempMsg );
    DispStr( 0, 0, primaRiga );

    nDigit = 0;
    while( (key = getKeymenu( K_ESC )) == 0 );
    if( key == K_ESC ) return 0;    // debug
    dataReady = 1;

    if ( readOnly == 0 && (key >= K_0 && key <= K_9) || key == K_DX )
    {
        for ( nDigit = defNumber[typeVar].nCifre, maxValore1 = 1; nDigit != 0; nDigit-- )
            maxValore1 *= 10;
        do {
//          if(key == K_DX && ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 || 
//                              machineType == MACHINA_AP7000 || machineType == MACHINA_NAT157 ) ) {         
            valore1 = valore;
            for(valore1 = valore, nDigit = 0; valore1 != 0; nDigit++, valore1 /= 10);
            valore1 = valore;
//          }
//          else{
//            valore = valore1 = 0;
//            nDigit = 0;
//            EditNumBoxModificato = 1;
//          }
          do{
            if( key >= K_0 && key <= K_9 && defNumber[typeVar].nCifre == 1 && defNumber[typeVar].max != 9 )
            {
                if ( (unsigned long)(key-K_0) < defNumber[typeVar].min || (unsigned long)(key-K_0) > defNumber[typeVar].max )
                    key = 0;
            }
            if(key != 0){
              if( key >= K_0 && key <= K_9){
                if(nDigit < defNumber[typeVar].nCifre){
                  nDigit++;
                  valore = valore * 10 + key - K_0;
                }
                valore1 = valore1 * 10 + key - K_0;
                EditNumBoxModificato = 1;
              }
              else if(key == K_C){
                if(valore == 0){
                  key = K_SX;
                  break;
                }
                valore = valore1 = 0;
                nDigit = 0;
                EditNumBoxModificato = 1;
              }
//              else if ( key == K_SX )
//              {
//                  if(valore != 0) nDigit--;
//                  else            break;
//                  valore /= 10;
//                  valore1 /= 10;
//              }
              else if ( key == K_ESC && ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 || 
                                          machineType == MACHINA_AP7000 || machineType == MACHINA_NAT157 ) )
              {
                  break;
              }
              else if(key == K_00){
                if(valore < 1000000 && nDigit < defNumber[typeVar].nCifre){
                  valore *= 10;
                  nDigit++;
                  if(valore < 1000000 && nDigit < defNumber[typeVar].nCifre){
                    valore *= 10;
                    nDigit++;
                  }
                }
                valore1 *= 100;
              }
              DispClrScr();
              valore1 = valore1 % maxValore1;
              valore = valore1;
                if ( _nDecimal == 0 )
                    sprintf( bufCifra, "%*d", defNumber[typeVar].nCifre, valore );
                else{
                    sprintf( bufCifra, "%d", valore1 );
                    Reformat( bufCifra, typeVar, _nDecimal );
                }
                strcpy( &primaRiga[LCDCOL-strlen(bufCifra)], bufCifra );
                DispStr( 0, 0, primaRiga );
            }
          }while((key = getKeymenu( K_OK )) != K_OK);
          if(key == K_OK){
            if(defNumber[typeVar].min != defNumber[typeVar].max){
              if(valore > defNumber[typeVar].max){
                VisuaMenu((char*)MSG_MAX_VALORE);
                valore = valore1 = defNumber[typeVar].max;
                valore1 = valore;
                Delay(2000);
                dataReady = 0;
//                key = K_DX;
                keyFlush();
              }
              else if(valore < defNumber[typeVar].min && (typeVar != WIN_VALUE || valore != 0)){
                VisuaMenu((char*)MSG_MIN_VALORE);
                valore = valore1 = defNumber[typeVar].min;
                valore1 = valore;
                Delay(2000);
                dataReady = 0;
//                key = K_DX;
                keyFlush();
              }
              else
                dataReady = 1;
            }
            if(dataReady != 0)
              memcpy((char*)defNumber[typeVar].address, &valore, defNumber[typeVar].nByte);
          }
        }while(dataReady == 0);
    }
    else{
        if ( key == K_OK || key == K_SX )    return key;
        if ( key == K_C )                       return K_SX;
        return key;
    }
    return (key | 0x100);
}

#define TESTO  0
#define CIFRE  1

unsigned short EditTextBox(unsigned long typeVar, unsigned char readOnly)
{
#if 0
  unsigned char key,keyAscii,cursor,display,i,keyLock;
  char *j;
  char msg[40];
  char primaRiga[LCDCOL+1];

  keyLock = 1;
  strcat(tempMsg,"\n");
  i = strlen(tempMsg);
  if(typeVar == TPLUBARCODE){
    sprintf(tempMsg + i, "%08ld", *((unsigned long*)&(((PLU*)editData) -> barCode[0])));
    sprintf(tempMsg + i + 8, "%04d", *((unsigned short*)&(((PLU*)editData) -> barCode[4])));
    tempMsg[i + 8 + 4] = 0;
    memcpy(msg, &tempMsg[i], 13);
  }
  else if(typeVar == VAL_BARCODE){
    sprintf(tempMsg + i, "%07ld", *((unsigned long*)defText[typeVar].address));
    memcpy(msg, &tempMsg[i], 8);
  }
  else{
    for(i = 0; tempMsg[i] != 0; i++);
    for(key = 0, j = (char*)defText[typeVar].address; *j != 0 && key < defText[typeVar].nByte; key++, j++, i++)
      tempMsg[i] = *j;
      tempMsg[i] = 0;
  }
  DispClrScr();
  VisuaMenu(tempMsg);
  memcpy( primaRiga, bufferLCD, LCDCOL);
  primaRiga[LCDCOL] = '\0';
  while((key = getKeymenu( K_ESC)) == 0);
  if( key == K_ESC ) return 0;  // debug
  if(typeVar != TPLUBARCODE && typeVar != VAL_BARCODE){
    memset(msg, ' ', defText[typeVar].nByte);
    *(msg + defText[typeVar].nByte) = 0;
    for(i = 0; i < defText[typeVar].nByte && *((char*)defText[typeVar].address + i) != 0; i++)
      *(msg + i) = *((char*)defText[typeVar].address + i);
  }
  if(readOnly == 0 && key != 0 && ((key >= K_PLU1 && key < K_PLU30) || (key >= K_0 && key <= K_9) || key == K_PLU30 || key == K_DX || key == K_00 || key == 0x41 || key == 0x42)){
    cursor = 0;
    if(key == K_DX) cursor = 0xFF;
    else memset(msg, 0, sizeof(msg));
    display = 0;
    DispCursorSet(1, cursor);
    do{
      if(key == K_PLU30){
        if(keyLock == 0) keyLock = 1;
        else             keyLock = 0;
      }
      if(keyLock == 0) CursorState(CURSON);
      else             CursorState(CURSON|CURSBL);
      if(key != 0 && key != K_OK && key != K_PLU30){

        keyAscii = tabKeyToAscii[key];
        if(keyLock == 0 && keyAscii >= 'A' && keyAscii <= 'Z') keyAscii = keyAscii - ('A' - 'a');
        if(cursor < defText[typeVar].nByte &&
           ((keyAscii >= '0' && keyAscii <= '9' && defText[typeVar].typeText == CIFRE) ||
            (((keyAscii >= '0' && keyAscii <= '9') || (keyAscii >= 'A' && keyAscii <= 'Z') ||
             (keyAscii >= 'a' && keyAscii <= 'z') ||
              (key >= K_PLU24 && key <= K_PLU30)) && defText[typeVar].typeText == TESTO))){
          msg[cursor++] = keyAscii;
          if((cursor - display) >= LCDCOL) display++;
        }
        else if(key == 0x41){
          msg[cursor++] = '.';
          if((cursor - display) >= LCDCOL) display++;
        }
        else if(key == 0x42){
          msg[cursor++] = '\'';
          if((cursor - display) >= LCDCOL) display++;
        }
        else if(key == K_00 && cursor < defText[typeVar].nByte){
          msg[cursor++] = '0';
          if((cursor - display) >= LCDCOL) display++;
          DispCursorSet(1, cursor - display);
          if((cursor - display) >= LCDCOL) display++;
          if(cursor < defText[typeVar].nByte) msg[cursor++] = '0';
        }
        else if(key == K_DX){  // avanti
          if(cursor == 0xFF) cursor = 0;
          else{
            if(cursor < (defText[typeVar].nByte - 1) && msg[cursor] != 0){
              cursor++;
              if((cursor - display) >= LCDCOL) display++;
            }
          }
        }
        else if(key == K_SX){  // cursore indietro
          if(cursor > 0){
            if(cursor > display) cursor--;
            else{
              cursor--;
              display--;
            }
          }
          else break;
        }
        else if(key == K_C){ // backspace
          for(i = 0; i < defText[typeVar].nByte && (msg[i] == ' ' || msg[i] == 0); i++);
          if(msg[i] == ' ' || msg[i] == 0){
            key = K_SX;
            break;
          }
          for(i=0;i<defText[typeVar].nByte;i++) msg[i] = ' ';
          cursor = 0;
          display = 0;
        }
        DispClrScr();
        DispStr(0,0,primaRiga);
        DispStr(1,0,&msg[display]);
        DispCursorSet(1, cursor - display);
      }
      if(key == K_PLU30){
        DispClrScr();
        DispStr(0,0,primaRiga);
        DispStr(1,0,&msg[display]);
        DispCursorSet(1, cursor - display);
      }
    }while((key = getKeymenu( K_ESC )) != K_OK);
    CursorState(CURSOF);
    if(key == K_OK){
      if(typeVar == TPLUBARCODE){
        for(i = 0; i < 12 && msg[i] != ' ' && msg[i] != 0; i++);
        msg[i] = 0;
        if(i  <= 4){
          *((unsigned short*)&((PLU*)editData) -> barCode[4]) = (unsigned short)_atoi(&msg[0],4);
          *((unsigned long*)&((PLU*)editData) -> barCode[0]) = (unsigned long) 0;
        }
        else{
          *((unsigned short*)&((PLU*)editData) -> barCode[4]) = (unsigned short)_atoi(&msg[i-4],4);
          msg[i-4] = 0;
          *((unsigned long*)&((PLU*)editData) -> barCode[0]) = (unsigned long) _atoi(&msg[0],8);
        }
      }
      else if(typeVar == VAL_BARCODE){
        for(i = 0; i < 7 && msg[i] != ' ' && msg[i] != 0; i++);
        msg[i] = 0;
        *((unsigned long*)defText[typeVar].address) = (unsigned long)_atoi(&msg[0],7);
      }
      else{
        for(i = 0; i < defText[typeVar].nByte && msg[i] == ' '; i++);
        if(msg[i] != ' ' && msg[i] != 0) strcpy((char*)defText[typeVar].address,msg);
        else                             *((char*)defText[typeVar].address) = 0;
      }
    }
  }
  else{
    if(key == K_OK || key == K_SX) return(key);
    if(key == K_C) return(K_SX);
    return(key);
  }
  return(key | 0x100);
#endif
  return 0;
}




/*--------------------------------------------------------------------------
 | edToggle...: toggle variable setting value
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

byte            edToggleY_N( char *_msg_NO, char *_msg_YES )
{
    byte        key, f;

    f = 0;
    DispStr( 0, 0, (char *)_msg_NO );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return FALSE;
        if ( key != K_OK )
        {
            f ^= 0x01;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)_msg_NO );
            else
                DispStr( 0, 0, (char *)_msg_YES );
        }
    } while ( key != K_OK );
    return (f == 0x00)?FALSE:TRUE;
}                                               //  edToggleY_N

unsigned short  edToggle( byte *_var, byte _val1, byte _val2, char *_msg1, char *_msg2 )
{
    unsigned char key;

    if ( *_var != _val2 )
        DispStr( 0, 0, (char *)_msg1 );
    else
        DispStr( 0, 0, (char *)_msg2 );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            if ( *_var == _val2 )
            {
                *_var = _val1;
                DispStr( 0, 0, _msg1 );
            }
            else
            {
                *_var = _val2;
                DispStr( 0, 0, _msg2 );
            }
        }
    } while ( key != K_OK );

    return K_OK;
}                                               //  edToggle




/*--------------------------------------------------------------------------
 | edPasscode:  set the new password to access all menu
 |              set password to enter ONLY audit menu
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edPasscode( unsigned char typeVar )
{
    if ( typeVar == PASSWORD )
    {
        DispStr( 0, 0, (char *)IN_PASSCODE );

        *((DWORD *)editData) = 0;
    
        if ( EditNumBox(typeVar, 0, 0) == K_SX )
            return K_SX;
        if ( *((DWORD *)editData) != ADVANCED_PASSWORD )
            return K_SX;
        return K_OK;
    }
    
                                        // read new passcode
    DispStr( 0, 0, bufferLCD );
    *((DWORD *)editData) = NonVolatileSetup.passcode;
    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.passcode != *((DWORD *)editData) && 
         edToggleY_N( (char *)MSG_NO, (char *)MSG_YES ) ) 
    {                                   // program passcode
        NonVolatileSetup.passcode = *((DWORD *)editData);
        saveSettings();
        return K_OK;
    }
    DispStr( 0, 0, (char *)MENU_122 );
    *((DWORD *)editData) = NonVolatileSetup.passcodeAudit;
    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.passcodeAudit != *((DWORD *)editData) &&
        edToggleY_N( (char *)MSG_NO, (char *)MSG_YES ) )
    {                                   // program passcode_1
      NonVolatileSetup.passcodeAudit = *((DWORD *)editData);
      saveSettings();
    }    
    return K_OK;
}                                               //  edPasscode




/*--------------------------------------------------------------------------
 | edSetSelGroup:  program a group
 |                              --------------
 | In:  grp                 group value
 |      grp_index           index of struct group
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

#define VISUA_SEL()    displaySelection( &bufferLCD[ 5], &bufferLCD[ 6], &bufferLCD[ 7], 1, i-1, j-1, '_' ); \
                DispStr( 0, 0, bufferLCD );

#define VISUA_GROUP()                                                       \
                bufferLCD[13] = '0'+group[grpIndex].info[n]/10;             \
                bufferLCD[14] = '0'+group[grpIndex].info[n]%10;             \
                DispStr( 0, 0, bufferLCD );

unsigned short  edSetSelGroup( unsigned char grpIndex )
{
    unsigned char key;
    byte        i, j, g, n, newIns;
    char buf[32];
    struct _GROUP_ *p;


    p = &group[grpIndex];
    memcpy(buf, bufferLCD, sizeof(buf));
    
    do {
        i = 0;
        j = 0;
        g = 0;
        VISUA_SEL();
        do {
                                            // selection
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || 
                 machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ||
                 machineType == MACHINA_VEILCM )
            {
                if( (key = getKeymenu( K_SX )) == 0)
                    continue;
                if ( key == K_OK )
                    return key;                
                if ( key >= K_1 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_1)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_0 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            {
                if( (key = getKeymenu( K_SX )) == 0)
                    continue;
                if ( key == K_OK )
                    return key;                
                if ( key >= K_0 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_0)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_1 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else
            {
                if( (key = getKeymenu( K_ESC )) == 0)
                    continue;
                if ( key == K_OK )
                   return key;
                if ( key >= K_A && key <= K_K )
                {
                    i = (key-K_A)+1;
                    if ( newIns )
                        j = 0;
                    newIns = 0;
                }
                if ( key >= K_0 && key <= K_9 )
                {
                    j = (key-K_0)+1;
                    if ( newIns )
                        i = 0;
                    newIns = 0;
                }
            }
            VISUA_SEL();
            if (i != 0 && j != 0 && newIns == 0)            
            {
                if ( i != 0 && j != 0 && usable[i-1][j-1] == 0 )
                {                           // not available
                    i = 0;
                    j = 0;
                    VISUA_SEL()
                    BuzzerOn(500);
                }
                else
                {
                    n = (i-1)*10+(j-1);
                    VISUA_GROUP()
                    BuzzerOn(500);
                    break;
                }
            }        
        } while( -1 );
        
        do {
            if( (key = getKeymenu( K_ESC )) == 0)
                continue;
            if ( key == K_OK )
                break;
            if ( key >= K_0 && key <= K_9 ) {
                g = (key-K_0);
                p->info[n] = (p->info[n]%10)*10+g;
            }
            VISUA_GROUP();
        } while( key != K_ESC );
    
        saveGroup();       
        
        strcpy(bufferLCD, buf);
        
    } while ( -1 );
}

/*--------------------------------------------------------------------------
 | edSetGroup:  program a group
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetGroup( unsigned char typeVar )
{
    byte            i;
    unsigned short  ret;
    
    if ((ret = edSetSelGroup(_GROUP_SEL)) != K_SX) 
    {
        for ( i = 0; i < MAXselGROUP; i++ )
            setGroupAmount(i);
        saveAmount();
    }
    return ret;
}                                               //  edSetGroup

/*--------------------------------------------------------------------------
 | setGroupAmount: set the price of selection
 |                              --------------
 | In:  _n                  selection index
 | Out:
 +--------------------------------------------------------------------------*/

void            setGroupAmount( byte _n )
{
    byte        i, r, c;

    for ( i = 0; i < MAXselGROUP; i++ )
    {
        if ( group[_GROUP_SEL].info[i] != _n )
            continue;
        
        r = i/10;
        c = i%10;
        
        if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            amount[0][c][r] = grp_price[_n];
        else
            amount[0][r][c] = grp_price[_n];
    }
}

/*--------------------------------------------------------------------------
 | edSetGroupPrice: set the price of a group
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetGroupPrice( unsigned char typeVar )
{
    byte        igroup, k;
    unsigned char key;
    char buf[16];

    
    memcpy(buf, bufferLCD, 16);   
    do {
        igroup = 0;
        k = 0;
        DispStr( 0, 0, bufferLCD );
        do {
            if( (key = getKeymenu( K_ESC )) == 0)
                continue;
            if ( key == K_OK )    
                return key; 
            if ( key >= K_0 && key <= K_9 ) {
                igroup = (igroup%10)*10+(key-K_0);
                k++;
                if ( k == 1 )
                {
                    bufferLCD[3] = '_';
                    bufferLCD[4] = '0'+igroup;
                }
                else {
                    bufferLCD[3] = '0'+igroup/10;
                    bufferLCD[4] = '0'+igroup%10;
                }
                DispStr( 0, 0, bufferLCD );                
            }
        } while( k < 2 );
                                        // test amount
        if (igroup == 0)
            return K_SX;
        
        *((DWORD *)editData) = grp_price[igroup];

        if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )            
            return K_SX;
                                        // set amount
        grp_price[igroup] = *((DWORD *)editData);
        setGroupAmount(igroup);
        saveAmount();
                
        memcpy(bufferLCD, buf, 16);
        
    } while( -1 );       
}

/*--------------------------------------------------------------------------
 | edSetGroupUpfront: set upfront group
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/
#define VIS_SEL_UPFRONT() displaySelection( &bufferLCD[13], &bufferLCD[14], &bufferLCD[15], 1, i-1, j-1, '_' ); \
                          DispStr( 0, 0, bufferLCD );

unsigned short  edSetGroupUpfront( unsigned char typeVar )
{
    unsigned char key;
    byte        i, j, g, n, newIns;
    char buf[32];
    struct _GROUP_ *p;


    p = &group[_SEL_UPFRONT];
    i = 0;
    j = 0;
    n = 0;

    do {
        g = 1;
        bufferLCD[ 0] = '0'+g/10;
        bufferLCD[ 1] = '0'+g%10;        
        VIS_SEL_UPFRONT();
        do {
            if( (key = getKeymenu( K_SX )) == 0)
                continue;
            if ( key == K_OK )
            {
                memcpy(buf, bufferLCD, sizeof(buf));
                break;
            }
            if ( key == K_UP ) 
            {
                if (g >= MAXselGROUP-1) 
                    g = 1;
                else
                    g++;
            }
            if ( key == K_DW )
            {
                if (g == 1) 
                    g = MAXselGROUP-1;
                else
                    g--;
            }
            bufferLCD[ 0] = '0'+g/10;
            bufferLCD[ 1] = '0'+g%10;
            DispStr( 0, 0, bufferLCD );       
        } while( -1 );
        
        do {
                                            // selection
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || 
                 machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ||
                 machineType == MACHINA_VEILCM )
            {
                if( (key = getKeymenu( K_SX )) == 0)
                    continue;
                if ( key == K_OK )
                {
                    saveGroup();
                    return K_OK;
                }
                if ( key >= K_1 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_1)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_0 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            {
                if( (key = getKeymenu( K_SX )) == 0)
                    continue;
                if ( key == K_OK )
                {
                    saveGroup();
                    return K_OK;
                }
                if ( key >= K_0 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_0)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_1 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else
            {
                if( (key = getKeymenu( K_ESC )) == 0)
                    continue;
                if ( key == K_OK )
                {
                   saveGroup();
                   return K_OK;
                }
                if ( key >= K_A && key <= K_K )
                {
                    i = (key-K_A)+1;
                    if ( newIns )
                        j = 0;
                    newIns = 0;
                }
                if ( key >= K_0 && key <= K_9 )
                {
                    j = (key-K_0)+1;
                    if ( newIns )
                        i = 0;
                    newIns = 0;
                }
            }
            VIS_SEL_UPFRONT();      
            if (i != 0 && j != 0 && newIns == 0)            
            {
                n = (i-1)*10+(j-1);
                p->info[n] = g;
                BuzzerOn(500);
                Delay(1000);
                i = 0;
                j = 0;
                VIS_SEL_UPFRONT();
            }           
        } while( -1 );        
    } while ( -1 );
}

/*--------------------------------------------------------------------------
 | resetGroupUpfront: set upfront group
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  resetGroupUpfront( unsigned char typeVar )
{
    if( edToggleY_N( (char *)MENU_6161, (char *)MENU_6162 ) )
    {
        memset(&group[_SEL_UPFRONT], 0x00, sizeof(group[_SEL_UPFRONT]));
        BuzzerOn(500);
    }
    return K_OK;
}

/*--------------------------------------------------------------------------
 | edSetGroupTimeframes: set the price of a group
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetGroupTimeframes( unsigned char typeVar )
{
    return edSetSelGroup(_SEL_TIMEFRAMES);     
}


/*--------------------------------------------------------------------------
 | edSetHours:  program a group's timeframe
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

static void     dispTfNum( byte _tf, byte _mode )
{
    if ( _tf == 0xFF )
    {
        bufferLCD[3] = '_';
        bufferLCD[4] = '_';
        WriteRows();
        CursorBlink( 0, 3 );
        return;
    }
    bufferLCD[3] = (_tf/10)+'0';
    if ( _mode == 1 )
    {
        bufferLCD[4] = '_';
        WriteRows();
        CursorBlink( 0, 4 );
    }
    else
    {
        bufferLCD[4] = (_tf%10)+'0';
        WriteRows();
        CursorOff();
    }
}

static void     dispTfGroup( byte _gr, byte _mode )
{
    if ( _gr > MAXselGROUP )
    {
        bufferLCD[8] = '_';
        bufferLCD[9] = '_';
        WriteRows();
        CursorBlink( 0, 8 );
        return;
    }
    bufferLCD[8] = (_gr/10)+'0';
    if ( _mode == 1 )
    {
        bufferLCD[9] = '_';
        WriteRows();
        CursorBlink( 0, 9 );
    }
    else
    {
        bufferLCD[9] = (_gr%10)+'0';
        WriteRows();
        CursorOff();
    }
}

static void     dispTfDay( byte _d, byte _mode )
{
    if ( _d > 7 )
    {
        bufferLCD[8] = '_';
        WriteRows();
        CursorBlink( 0, 8 );
        return;
    }
    bufferLCD[8] = _d+'0';
    WriteRows();
    CursorOff();
}

static void     dispTfHour( byte _hh, byte _mm, byte _mode )
{
    if ( _hh > 23 )
    {
        bufferLCD[11] = '_';
        bufferLCD[12] = '_';
    }
    else
    {
        bufferLCD[11] = (_hh/10)+'0';
        if ( _mode != 1 )
            bufferLCD[12] = (_hh%10)+'0';
        else
            bufferLCD[12] = '_';
    }
    if ( _mm > 59 )
    {
        bufferLCD[14] = '_';
        bufferLCD[15] = '_';
    }
    else
    {
        if ( _mode == 0 || _mode > 2 )
            bufferLCD[14] = (_mm/10)+'0';
        else
            bufferLCD[14] = '_';
        if ( _mode == 0 || _mode > 3 )
            bufferLCD[15] = (_mm%10)+'0';
        else
            bufferLCD[15] = '_';
    }
    WriteRows();
    if ( _mode == 0 )
        CursorBlink( 0, 11 );
    else if ( _mode == 1 )
        CursorBlink( 0, 12 );
    else if ( _mode == 2 )
        CursorBlink( 0, 14 );
    else if ( _mode == 3 )
        CursorBlink( 0, 15 );
    else
        CursorOff();

}


unsigned short  edSetHours( unsigned char typeVar )
{
    unsigned char key;
    byte        i, tf, ndigit;
    struct _TIMEFRAMES_ *p;
    struct _TIMEFRAMES_TIME_ *pt;


    DispStr( 0, 0, bufferLCD );


    i = 0;
    tf = 0xFF;
    ndigit = 0;
    dispTfNum( tf, ndigit );
    do {
        if(   machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123 ||
              machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || 
              machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM )
        {
            if( (key = getKeymenu( K_DOOR )) == 0)
                continue;
            if ( key == K_DOOR )
                break;
        }
        else
        {
            if( (key = getKeymenu( K_ESC )) == 0)
                continue;
            if ( key == K_ESC || key == K_SX )
                break;
        }

        switch( i )
        {
            case 0:                     // select starting timeframes
                if ( key >= K_0 && key <= K_9 )
                {
                    if ( ndigit == 0 )
                        tf = (key-K_0)*10;
                    else
                        tf += (key-K_0);

                    ndigit++;
                    if ( tf > MAXTIMEFRAMES )
                    {
                        tf = 0;
                        ndigit = 0;
                    }

                    dispTfNum( tf, ndigit );
                }
                if ( key == K_OK && tf == 0xFF )
                    return K_OK;
                if ( ndigit == 2 || (key == K_OK && tf < MAXTIMEFRAMES) )
                {
                    p = &timeFrames[tf];
                    i++;
                    ndigit = 0;
                    strcpy( bufferLCD, (char *)MENU_6152 );
                    dispTfNum( tf, 2 );
                    dispTfGroup( p->group, ndigit );
                }
                break;

            case 1:                     // set group
                if ( ndigit == 0 )
                {
                    if ( key >= K_0 && key <= K_9 )
                    {
                        p->group = (key-K_0)*10;
                        bufferLCD[8] = (key-K_0)+'0';
                        ndigit++;
                        dispTfGroup( p->group, ndigit );
                    }

                }
                else
                {
                    if ( key >= K_0 && key <= K_9 )
                    {
                        p->group += (key-K_0);
                        ndigit++;
                        dispTfGroup( p->group, ndigit );
                        Delay(1000);
                        key = K_OK;
                    }
                }            
                if ( key == K_OK && p->group > 0 && p->group < MAXselGROUP )
                {
                    if ( ndigit == 1 )
                    {                   // clear selection
                        dispTfGroup( 0xFF, 0xFF );
clearTF:;
                        p->group = 0xFF;
                        p->disable.hour = 0xFF;
                        p->disable.min = 0xFF;
                        p->enable.hour = 0xFF;
                        p->enable.min = 0xFF;
                        BuzzerOn(500);
                        Delay(1000);
                        goto nextTF;
                        //break;
                    }
                    i++;
                    ndigit = 0;
                    strcpy( bufferLCD, (char *)MENU_6153 );
                    dispTfNum( tf, 2 );
                    dispTfDay( p->weekDay, ndigit );
                }
                break;

            case 2:                     // set day
                if ( key >= K_0 && key <= K_7 )
                {
                    p->weekDay = (key-K_0);
                    dispTfDay( p->weekDay, ndigit );
//                    BuzzerOn(500);
                    Delay(1000);
                    key = K_OK;
                }
                if ( key == K_OK )
                {
                    if ( p->weekDay > 7 )
                    {
                        dispTfDay( p->weekDay, 0xFF );
                        goto clearTF;
                    }
                    i++;
                    ndigit = 0;
                    strcpy( bufferLCD, (char *)MENU_6154 );
                    dispTfNum( tf, 2 );
                    pt = &p->disable;
                    dispTfHour( pt->hour, pt->min, ndigit );
                }
                break;

            case 3:                     // set start hour
            case 4:                     // set stop hour
                if ( ndigit == 0 )
                {                       // 10th hour
                    if ( key >= K_0 && key <= K_2 )
                    {
                        pt->hour = (key-K_0)*10;
                        pt->min = 0;
                        ndigit++;
                        dispTfHour( pt->hour, pt->min, ndigit );
                    }
                }
                else if ( ndigit == 1 )
                {                       // hour
                    if ( (pt->hour >= 20 && key >= K_0 && key <= K_3) ||
                         (pt->hour <  20 && key >= K_0 && key <= K_9) )
                    {
                        pt->hour = ((pt->hour/10)*10) + (key-K_0);
                        ndigit++;
                        dispTfHour( pt->hour, pt->min, ndigit );
                    }
                }
                else if ( ndigit == 2 )
                {                       // 10th minutes
                    if ( key >= K_0 && key <= K_5 )
                    {
                        pt->min = (key-K_0)*10;
                        ndigit++;
                        dispTfHour( pt->hour, pt->min, ndigit );
                    }
                }
                else
                {                       // minutes
                    if ( key >= K_0 && key <= K_9 )
                    {
                        pt->min = ((pt->min/10)*10) + (key-K_0);
                        ndigit++;
                        dispTfHour( pt->hour, pt->min, ndigit );
//                        BuzzerOn(500);
                        Delay(1000);
                        key = K_OK;
                    }
                }
                if ( pt->hour > 23 || pt->min > 59 )
                {
                    ndigit = 0;
                    pt->hour = 0;
                    pt->min = 0;
                }
                if ( key == K_OK )
                {
                    if ( ndigit == 1 && pt->hour == 0 )
                    {
                        dispTfHour( 0xFF, 0xFF, 0xFF );
                        goto clearTF;
                    }
                    if ( i == 3 )
                    {
                        i++;
                        ndigit = 0;
                        strcpy( bufferLCD, (char *)MENU_6155 );
                        dispTfNum( tf, 2 );
                        pt = &p->enable;
                        dispTfHour( pt->hour, pt->min, ndigit );
                    }
                    else
                    {
nextTF:;
                        i = 0;
                        if(   machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123 ||
                              machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || 
                              machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM )
                            tf = MAXTIMEFRAMES;//end
                        else
                        {
                            tf++;
                            ndigit = 0;
                            strcpy( bufferLCD, (char *)MENU_6151 );
                            dispTfNum( tf, ndigit );
                        }
                    }
                }
                break;
        }

    } while( (tf < MAXTIMEFRAMES && tf <= 99) || tf == 0xFF );

    saveGroup();

    return K_OK;
}                                               //  edSetHours


/*--------------------------------------------------------------------------
 | edSingPrice: set the price of a single selection
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

void    SetSlaveMAchineNumber(unsigned char typeVar)
{
    switch (typeVar) {
        case POSPRICE:
        case TRAYPRICE:
        case GROUPPRICE:
        case ALLPRICE:  
            SlaveMAchineNumber = 0;
            break;
        case POSPRICE_S1:
        case TRAYPRICE_S1:
        case GROUPPRICE_S1:
        case ALLPRICE_S1:  
            SlaveMAchineNumber = 1;
            break;
        case POSPRICE_S2:
        case TRAYPRICE_S2:
        case GROUPPRICE_S2:
        case ALLPRICE_S2:  
            SlaveMAchineNumber = 2;
            break;
        case POSPRICE_S3:
        case TRAYPRICE_S3:
        case GROUPPRICE_S3:
        case ALLPRICE_S3:  
            SlaveMAchineNumber = 3;
            break; 
        default:
            SlaveMAchineNumber = 0;
            break;        
    }
}

/*--------------------------------------------------------------------------
 | edSingPrice: set the price of a single selection
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSingPrice( unsigned char typeVar )
{
    unsigned char key;
    byte        tray, column;

    SetSlaveMAchineNumber(typeVar);       
    
    tray = 0xFF; column = 0xFF;

    if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM )
        selectDisplay( &tray, &column );
    else
        DispStr( 0, 0, bufferLCD );
                                        // select tray/column
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        
        selection( key, &tray, &column );
        selectDisplay( &tray, &column );

        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF || column == 0xFF );
                                        // read amount
    for( ; tray < MAXTRAY; tray++ )
    {
        for( ; column < MAXCOLUMN; column++ )
        {
            if ( SlaveMAchineNumber == 0 && usable[tray][column] == 0 )
                continue;
            selectDisplay( &tray, &column );

            if ( usable[tray][column] == 0 )
                continue;
            selectDisplay( &tray, &column );
            *((DWORD *)editData) = amount[SlaveMAchineNumber][tray][column];
            if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )
                return K_SX;
                                        // set amount
            amount[SlaveMAchineNumber][tray][column] = *((DWORD *)editData);
            saveAmount();
            lpdRecalc();
        }
    }
    return K_OK;
}                                               //  edSingPrice




/*--------------------------------------------------------------------------
 | edTrayPrice: set the price of a tray
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

byte            testTray( byte _i )
{
    byte        column;

    for ( column = 0; column < MAXCOLUMN; column++ )
    {
        if ( usable[_i][column] != 0 )
            return 0xFF;
    }

    return 0;
}

unsigned short  edTrayPrice( unsigned char typeVar )
{
    byte        tray, j;
    unsigned char key;
                                        // select tray
    
    SetSlaveMAchineNumber(typeVar);
    
    DispStr( 0, 0, bufferLCD );
    tray = 0xFF;
    selectDisplay( &tray, NULL );
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        
        selection( key, &tray, NULL );
        selectDisplay( &tray, NULL );
        if ( tray != 0xFF  )
        {
            if ( testTray(tray) == 0 )
            {                           // not available
                tray = 0xFF;
                selectDisplay( &tray, NULL );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF );

                                        // test amount
    for( ; tray < MAXTRAY; tray++ )
    {
        if ( SlaveMAchineNumber == 0 && testTray(tray) == 0 )
            continue;

        selectDisplay( &tray, NULL );
        *((DWORD *)editData) = amount[SlaveMAchineNumber][tray][0];
        for ( j = 1; j < MAXCOLUMN; j++ )
        {
            if ( amount[SlaveMAchineNumber][tray][j] != (T_AMOUNT)(*((DWORD *)editData)) )
            {
                *((DWORD *)editData) = 0;
                break;
            }
        }

        if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )
            return K_SX;
                                        // set amount
        for ( j = 0; j < MAXCOLUMN; j++ )
            amount[SlaveMAchineNumber][tray][j] = *((DWORD *)editData);
        
        saveAmount();
        lpdRecalc();
        if ( tray == 8 && (machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM) )
            break;
    }
    return K_OK;
}                                               //  edTrayPrice


/*--------------------------------------------------------------------------
 | edAllPrice:  set the machine with all the same price
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edAllPrice( unsigned char typeVar )
{
    byte        i, j, k;
    DWORD       oldAmount;

    SetSlaveMAchineNumber(typeVar);
                                        // test amount
    *((DWORD *)editData) = amount[0][0][0];
    for ( j = 0; j < MAXTRAY; j++ )
    {
        for ( i = 0; i < MAXCOLUMN; i++ )
        {
            for ( k = 0; k < MAX_MACHINE_NUM; k++ )
            {
                if ( amount[k][j][i] != (T_AMOUNT)(*((DWORD *)editData)) )
                {
                    *((DWORD *)editData) = 0;
                    j = MAXTRAY;
                    k = 2;
                    break;
                }
            }
        }
    }

    oldAmount = *((DWORD *)editData);

    if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )
        return K_SX;

    if ( oldAmount == *((DWORD *)editData) && oldAmount != 0 )
        return K_OK;                    // nothing to do

    if ( !edToggleY_N( (char *)MSG_NO, (char *)MSG_YES ) )
        return K_OK;

                                        // set amount
    for ( j = 0; j < MAXTRAY; j++ )
    {
        for ( i = 0; i < MAXCOLUMN; i++ )
            ( amount[SlaveMAchineNumber][j][i] = *((DWORD *)editData));
    }

    saveAmount();
    lpdRecalc();
    return K_OK;
}                                               //  edAllPrice




/*--------------------------------------------------------------------------
 | edToggleSel: toggle selection status from locked to unlocked and vice-versa
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edToggleSel( unsigned char typeVar )
{
    unsigned char key;
    byte        tray, column, f;

    DispStr( 0, 0, bufferLCD );

                                        // select tray/column
    tray = 0xFF;
    column = 0xFF;
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, &column );
        selectDisplay( &tray, &column );
        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF || column == 0xFF );

                                        // toggle selection
    for( ; tray < MAXTRAY; tray++ )
    {
        for( ; column < MAXCOLUMN; column++ )
        {
            if ( usable[tray][column] == 0 )
                continue;
            selectDisplay( &tray, &column );
            f = (nF.nFails[tray][column] >= MAX_SEL_FAILED) ? 0x80 : 0x81;

            do {
                if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
                    continue;
                if ( key == K_SX )
                    return K_SX;
                if ( key != K_OK )
                {
                    f = (f^0x01)&0x7F;
                    if ( f == 0x00 )
                        strcpy( bufferLCD, MENU_4a1a );
                    else
                        strcpy( bufferLCD, MENU_4a1b );
                    selectDisplay( &tray, &column );
                }
            } while ( key != K_OK );

            if ( f == 0x00 )
                nF.nFails[tray][column] = 0;
            else
                nF.nFails[tray][column] = MAX_SEL_FAILED;
            saveSettings();
        }
    }
    return K_OK;
}                                               //  edToggleSel




/*--------------------------------------------------------------------------
 | edDropMachine: toggle selection status from locked to unlocked and vice-versa
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDropMachine( unsigned char typeVar )
{
#if 1
    *((DWORD *)editData) = NonVolatileSetup.fallSensorMode;

    if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.fallSensorMode != *((DWORD *)editData) )
    {
        memset( enDrop, NonVolatileSetup.fallSensorMode, sizeof( enDrop ) );
        saveSettings();
    }
    return K_OK;
#else
    unsigned char key;
    byte        tray, column, f;

    if( EditNumBoxModificato != 0 )
    {
        memset( enDrop, NonVolatileSetup.fallSensorMode, sizeof( enDrop ) );
    }
    DispStr( 0, 0, bufferLCD );
                                        // select tray/column
    tray = 0xFF;
    column = 0xFF;
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, &column );
        selectDisplay( &tray, &column );
        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF || column == 0xFF );
    bufferLCD[15] = enDrop[tray][column] + '0';
    DispStr( 0, 0, bufferLCD );

                                        // program drop mode
    for( ; tray < MAXTRAY; tray++ )
    {
        for( ; column < MAXCOLUMN; column++ )
        {
            if ( usable[tray][column] == 0 )
                continue;
            f = enDrop[tray][column];
            bufferLCD[15] = f + '0';
            selectDisplay( &tray, &column );

            do {
                if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
                    continue;
                if ( key == K_SX )
                    return K_SX;
                if ( key >= K_0 && key <= K_4 )
                {
                    f = key - K_0;
                    bufferLCD[15] = f + '0';
                    selectDisplay( &tray, &column );
                }
            } while ( key != K_OK );

            enDrop[tray][column] = f;
            saveSettings();
        }
    }
    return K_OK;
#endif
}                                               //  edDropMachine




/*--------------------------------------------------------------------------
 | edDropSel: toggle selection status from locked to unlocked and vice-versa
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDropSel( unsigned char typeVar )
{
#if 1
    unsigned char key;
    byte        tray, column, f;

    DispStr( 0, 0, bufferLCD );
                                        // select tray/column
    tray = 0xFF;
    column = 0xFF;
    do {
        if ( (key=getKeymenu(K_ESC)) == 0 )
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, &column );
        selectDisplay( &tray, &column );
        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF || column == 0xFF );
    bufferLCD[15] = enDrop[tray][column] + '0';
    DispStr( 0, 0, bufferLCD );

                                        // modify selection
    for( ; tray < MAXTRAY; tray++ )//non resettando column, fa solo una riga e poi esce......va bene cosi'
    {
        for( ; column < MAXCOLUMN; column++ )
        {
            if ( usable[tray][column] == 0 )
                continue;
            f = enDrop[tray][column];
            bufferLCD[15] = f + '0';
            selectDisplay( &tray, &column );

            do {
                if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
                    continue;
                if ( key == K_SX && (K_SX < K_0 || K_SX > K_9) )
                    return K_SX;
                if ( key == K_0 || key == (K_0+NonVolatileSetup.fallSensorMode) )
                {
                    f = key - K_0;
                    bufferLCD[15] = f + '0';
                    selectDisplay( &tray, &column );
                }
            } while ( key != K_OK );

            enDrop[tray][column] = f;
            saveSettings();
        }
    }
    return K_OK;
#else
    unsigned char key;
    byte        tray, column, f;

    if( EditNumBoxModificato != 0 )
    {
        memset( enDrop, NonVolatileSetup.fallSensorMode, sizeof( enDrop ) );
    }
    DispStr( 0, 0, bufferLCD );
                                        // select tray/column
    tray = 0xFF;
    column = 0xFF;
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, &column );
        selectDisplay( &tray, &column );
        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF || column == 0xFF );
    bufferLCD[15] = enDrop[tray][column] + '0';
    DispStr( 0, 0, bufferLCD );

                                        // program drop mode
    for( ; tray < MAXTRAY; tray++ )
    {
        for( ; column < MAXCOLUMN; column++ )
        {
            if ( usable[tray][column] == 0 )
                continue;
            f = enDrop[tray][column];
            bufferLCD[15] = f + '0';
            selectDisplay( &tray, &column );

            do {
                if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
                    continue;
                if ( key == K_SX )
                    return K_SX;
                if ( key >= K_0 && key <= K_4 )
                {
                    f = key - K_0;
                    bufferLCD[15] = f + '0';
                    selectDisplay( &tray, &column );
                }
            } while ( key != K_OK );

            enDrop[tray][column] = f;
            saveSettings();
        }
    }
    return K_OK;
#endif
}                                               //  edDropSel




/*--------------------------------------------------------------------------
 | edDate: toggle selection status from locked to unlocked and vice-versa
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDate( unsigned char typeVar )
{
    memset( editData, 0, sizeof(_dateTime) );
    recvDate( (_dateTime*)editData );
    memcpy ( &editData[sizeof(_dateTime)], editData, sizeof(_dateTime) );

    DispStr( 0, 0, (char *)&MENU_521[3] );  EditNumBox(SET_DAY, 0, 0);      if ( !doorOpen() )          return K_SX;
    DispStr( 0, 0, (char *)&MENU_522[3] );  EditNumBox(SET_MONTH, 0, 0);    if ( !doorOpen() )          return K_SX;
    DispStr( 0, 0, (char *)&MENU_523[3] );  EditNumBox(SET_YEAR, 0, 0);     if ( !doorOpen() )          return K_SX;
    DispStr( 0, 0, (char *)&MENU_524[3] );  EditNumBox(SET_HOUR, 0, 0);     if ( !doorOpen() )          return K_SX;
    DispStr( 0, 0, (char *)&MENU_525[3] );  EditNumBox(SET_MIN, 0, 0);      if ( !doorOpen() )          return K_SX;
    if ( memcmp( &editData[sizeof(_dateTime)], editData, sizeof(_dateTime) ) != 0 )
    {                                   // date changed, update clock
        ((_dateTime*)editData)->sec = 0;
        sendDate((_dateTime*)editData);        
        recvDate(&dateTime);
    }
    return K_OK;
}                                               //  edDate




/*--------------------------------------------------------------------------
 | edToggleAll: toggle all machine selection
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/
/*
unsigned short  edToggleAll( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = 0x81;
    do {
        if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f = (f^0x01)&0x7F;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_451a );
            else
                DispStr( 0, 0, (char *)MENU_451b );
        }
    } while ( key != K_OK );

    if ( f != 0x00 ) {
        memset( &nF, 0x00, sizeof(nF.nFails) );
        saveSettings();
    }

    return K_OK;
}                                               //  edToggleAll

*/



/*--------------------------------------------------------------------------
 | edMotorHome: position alla motors on their home position
 |              clear any locked selection status
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edMotorHome( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = 0x81;
    do {
        if( (key = getKeymenu( K_SX )) == 0 && f < 0x80 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f = (f^0x01)&0x7F;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_4c1a );
            else
                DispStr( 0, 0, (char *)MENU_4c1b );
        }
    } while ( key != K_OK );

    if ( f != 0x00 ) {
        homeMotors( 1 );
        memset( &nF, 0x00, sizeof(nF.nFails) );   // unlock all selections
        saveSettings();
    }

    return K_OK;
}                                               //  edMotorHome




/*--------------------------------------------------------------------------
 | edSetContrasto : set LCD contrast
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetContrasto( unsigned char typeVar )
{
    unsigned char key;

    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key == K_UP ) NonVolatileSetup.contrasto_lcd += 5;
        if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 100;
        if( NonVolatileSetup.contrasto_lcd < 5 ) NonVolatileSetup.contrasto_lcd = 5;
        if ( key == K_DW ) NonVolatileSetup.contrasto_lcd -= 5;
        setContrastLCD( NonVolatileSetup.contrasto_lcd );
    } while ( key != K_OK );

    saveSettings();

    return K_OK;
}                                               //  edSetContrasto




/*--------------------------------------------------------------------------
 | edSetSingleVend: set Single vend mode
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetSingleVend( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    // debug : uitle fun funzione che aggiunge solo YES/NO per le selezioni toggle
    f = NonVolatileSetup.setSingleVend & 0x01;
    if ( f == 0x00 )
        DispStr( 0, 0, (char *)MENU_641a );
    else
        DispStr( 0, 0, (char *)MENU_641b );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f = (f^0x01)&0x7F;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_641a );
            else
                DispStr( 0, 0, (char *)MENU_641b );
        }
    } while ( key != K_OK );

    NonVolatileSetup.setSingleVend = f;
    saveSettings();

    return K_OK;
}                                               //  edSetSingleVend




/*--------------------------------------------------------------------------
 | edSetEscrow : set Escrow mode
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetEscrow( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = NonVolatileSetup.setEscrow;
    if ( f > 2 ) f = 0;
    if ( f == 0x00 )
        DispStr( 0, 0, (char *)MENU_531a );
    else if ( f == 0x01 )
        DispStr( 0, 0, (char *)MENU_531b );
    else
        DispStr( 0, 0, (char *)MENU_531c );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            if ( ++f > 2 ) f = 0;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_531a );
            else if ( f == 0x01 )
                DispStr( 0, 0, (char *)MENU_531b );
            else
                DispStr( 0, 0, (char *)MENU_531c );
        }
    } while ( key != K_OK );

    NonVolatileSetup.setEscrow = f;
    saveSettings();

    return K_OK;
}                                               //  edSetEscrow




/*--------------------------------------------------------------------------
 | edSetForceVend: enable test vend in main function
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetForceVend( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = NonVolatileSetup.setForceVend;
    if ( f != 0x69 )
        DispStr( 0, 0, (char *)MENU_541a );//no
    else
        DispStr( 0, 0, (char *)MENU_541b );//yes
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            if ( f == 0x69 )
            {
                f = 0x00;
                DispStr( 0, 0, (char *)MENU_541a );
            }
            else
            {
                f = 0x69;
                DispStr( 0, 0, (char *)MENU_541b );
            }
        }
    } while ( key != K_OK );

    if ( f != NonVolatileSetup.setForceVend )
    {
        NonVolatileSetup.setForceVend = f;
        saveSettings();
    }

    return K_OK;
}                                               //  edSetForceVend




/*--------------------------------------------------------------------------
 | edFillTube: set Escrow mode
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edFillTube( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = NonVolatileSetup.setFillTube;
    if ( f == 0x68 )
        DispStr( 0, 0, (char *)MENU_561 );
    else
        DispStr( 0, 0, (char *)MENU_562 );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f = (f==0x68)?0:0x68;
            if ( f == 0x68 )
                DispStr( 0, 0, (char *)MENU_561 );// no tube fill
            else
                DispStr( 0, 0, (char *)MENU_562 );// tube fill
        }
    } while ( key != K_OK );

    NonVolatileSetup.setFillTube = f;
    saveSettings();

    return K_OK;
}                                               //  edFillTube




///*--------------------------------------------------------------------------
// | edAnimation: set animation mode (slide or movie)
// |                              --------------
// | In:  typeVar             type of var to be inputed
// | Out: unsigned short      return key
// +--------------------------------------------------------------------------*/
//
//unsigned short  edAnimation( unsigned char typeVar )
//{
//    unsigned char key;
//    byte        f;
//
//    f = NonVolatileSetup.animationMovie;
//    if ( f == 0x68 )
//        DispStr( 0, 0, (char *)MENU_6a1b );
//    else
//        DispStr( 0, 0, (char *)MENU_6a1a );
//    do {
//        if( (key = getKeymenu( K_SX )) == 0 )
//            continue;
//        if ( key == K_SX )
//            return K_SX;
//        if ( key != K_OK )
//        {
//            f = (f==0x68)?0x00:0x68;
//            if ( f == 0x68 )
//                DispStr( 0, 0, (char *)MENU_6a1b );// movie
//            else
//                DispStr( 0, 0, (char *)MENU_6a1a );// slide
//        }
//    } while ( key != K_OK );
//
//    NonVolatileSetup.animationMovie = f;
//    saveSettings();
//
//    return K_OK;
//}                                               //  edAnimation
//
//
//
//
///*--------------------------------------------------------------------------
// | edSlideTime: set animation mode
// |                              --------------
// | In:  typeVar             type of var to be inputed
// | Out: unsigned short      return key
// +--------------------------------------------------------------------------*/
//
//unsigned short  edSlideTime( unsigned char typeVar )
//{
//    unsigned char key;
//    byte        f;
//
//    f = NonVolatileSetup.slideDelay;
//    if ( f != 10 && f != 15 && f != 20 )
//        f = 10;
//    strcpy ( bufferLCD, (char *)MENU_6a21 );
//    sprintf( &bufferLCD[LCDCOL-2], "%2d", f );
//    DispStr( 0, 0, (char *)bufferLCD );
//    do {
//        if( (key = getKeymenu( K_SX )) == 0 )
//            continue;
//        if ( key == K_SX )
//            return K_SX;
//        if ( key != K_OK )
//        {
//            f = (f==10)?15:(f==15?20:10);
//            sprintf( &bufferLCD[LCDCOL-2], "%2d", f );
//            DispStr( 0, 0, (char *)bufferLCD );
//        }
//    } while ( key != K_OK );
//
//    NonVolatileSetup.slideDelay = f;
//    saveSettings();
//
//    return K_OK;
//}                                               //  edSlideTime




/*--------------------------------------------------------------------------
 | edTubeValue: set the new value for the tube count on the old coin mechanism
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edTubeValue( unsigned char typeVar )
{
    *((DWORD *)editData) = (DWORD)NonVolatileSetup.tubeValue;

    if ( EditNumBox(typeVar, 0, posVirgola) == K_SX )
        return K_SX;
                                // set amount
    NonVolatileSetup.tubeValue = (_Credito)( *((DWORD *)editData) );
    saveSettings();

    return K_OK;
}                                               //  edTubeValue




/*--------------------------------------------------------------------------
 | edTubeValue: set the new value for the tube count on the old coin mechanism
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

static void     dispTdDay( byte _d )
{
    if ( _d >= 9 )
        strcpy( &bufferLCD[9], MENU_67a+9 );
    else
        strcpy( &bufferLCD[9], message[_MENU_MON+_d] );
    WriteRows();
    CursorOff();
}

static void     dispTdHour( byte _hh, byte _mm, byte _am_pm, byte _digit, byte _modeHHMM )
{
    if ( ( _hh > 12 && _modeHHMM == 0 ) ||( _hh > 59 && _modeHHMM == 1 ) || _hh == 0 )
    {
        bufferLCD[ 9] = '_';
        bufferLCD[10] = '_';
    }
    else
    {
        bufferLCD[ 9] = (_hh/10)+'0';
        if ( _digit != 1 )
            bufferLCD[10] = (_hh%10)+'0';
        else
            bufferLCD[10] = '_';
    }
    
    if ( _mm > 59 )
    {
        bufferLCD[12] = '_';
        bufferLCD[13] = '_';
    }
    else
    {
        if ( _digit == 0 || _digit > 2 )
            bufferLCD[12] = (_mm/10)+'0';
        else
            bufferLCD[12] = '_';
        if ( _digit == 0 || _digit > 3 )
            bufferLCD[13] = (_mm%10)+'0';
        else
            bufferLCD[13] = '_';
    }
    
    if( _modeHHMM == 0 )
    {
      if ( _am_pm == 0 || _am_pm == 0xFF )  // 0xFF : memory NON initialized
            bufferLCD[14] = 'A';
        else
            bufferLCD[14] = 'P';
        bufferLCD[15] = 'M';
    }
    WriteRows();
    if ( _digit == 0 )
        CursorBlink( 0,  9 );
    else if ( _digit == 1 )
        CursorBlink( 0, 10 );
    else if ( _digit == 2 )
        CursorBlink( 0, 12 );
    else if ( _digit == 3 )
        CursorBlink( 0, 13 );
    else if ( _digit == 4 )
        CursorBlink( 0, 14 );
    else
        CursorOff();
}

unsigned short  edDisableTx( byte _num, byte _typeVar )
{
    unsigned char key;
    byte        i, ndigit, j;
    struct _TIMEDISABLE_ *p;
    struct _TIMEDISABLE_TIME_ *pd;


    p = &timeDisable[_num];
    pd = &p->disable;
    strcpy ( bufferLCD, (char *)MENU_67a );
    dispTdDay( pd->weekDay );

    i = 0;
    ndigit = 0;
    do {
        if (   machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123 ||
               machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || 
               machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM )
        {
            if ( (key=getKeymenu(K_DOOR)) == 0 )
                continue;
            if ( key == K_DOOR )
                break;
        }
        else
        {
            if ( (key=getKeymenu(K_ESC)) == 0 )
                continue;
            if ( key == K_ESC || key == K_SX )
                break;
        }

        switch( i )
        {
            case 0:                     // set day  ... disable
            case 2:                     //          ... enable
                if ( key != K_OK && key != K_ESC )
                {
                    if ( pd->weekDay >= 8 )
                        pd->weekDay = 0;
                    else
                        pd->weekDay++;
                    dispTdDay( pd->weekDay );
                }
                if ( key == K_OK )
                {
                    if ( pd->weekDay >= 9 )
                        return K_OK;
                    i++;
                    ndigit = 0;
                    if ( pd == &p->enable )
                        strcpy( bufferLCD, (char *)MENU_67d );
                    else
                        strcpy( bufferLCD, (char *)MENU_67b );
                    dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                }
                break;

            case 1:                     // set time ... disable
            case 3:                     //          ... enable
                if ( ndigit == 0 )
                {                       // 10th hour
                    if ( key >= K_0 && key <= K_1 )
                    {
                        pd->hour = (key-K_0)*10;
                        pd->min = 0;
                        pd->am_pm = 0;
                        ndigit++;
                        dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                    }
                }
                else if ( ndigit == 1 )
                {                       // hour
                    if ( (pd->hour >= 10 && key >= K_0 && key <= K_2) ||
                         (pd->hour <  10 && key >= K_1 && key <= K_9) )
                    {
                        pd->hour = ((pd->hour/10)*10) + (key-K_0);
                        ndigit++;
                        dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                    }
                }
                else if ( ndigit == 2 )
                {                       // 10th minutes
                    if ( key >= K_0 && key <= K_5 )
                    {
                        pd->min = (key-K_0)*10;
                        ndigit++;
                        dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                    }
                }
                else if ( ndigit == 3 )
                {                       // minutes
                    if ( key >= K_0 && key <= K_9 )
                    {
                        pd->min = ((pd->min/10)*10) + (key-K_0);
                        ndigit++;
                        dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                    }
                }
                else
                {                       // am_pm
                    if ( key != K_OK && key != K_ESC )
                    {
                        if ( pd->am_pm == 0 )
                            pd->am_pm = 12;
                        else
                            pd->am_pm = 0;
                        dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                    }
                }
                if ( (pd->hour+pd->am_pm-1) > 23 || pd->min > 59 )
                {
                    ndigit = 0;
                    pd->hour = 0;
                    pd->min = 0;
                    pd->am_pm = 0;
                    dispTdHour( pd->hour, pd->min, pd->am_pm, ndigit, 0 );
                }
                if ( key == K_OK )
                {
                    if ( ndigit == 1 && pd->hour == 0xFF )
                    {
                        dispTdHour( 0xFF, 0xFF, 0xFF, 0xFF, 0 );
                        break;
                    }
                    i++;
                    if ( i == 2 )
                    {
                        ndigit = 0;
                        pd = &p->enable;
                        strcpy( bufferLCD, (char *)MENU_67c );
                        dispTdDay( pd->weekDay );
                    }
                    else if ( i == 4 )
                    {                   // clear ?
                        if ( edToggleY_N( (char *)MENU_65e, (char *)MENU_65f ) )
                        {
                            memset( p, 0xFF, sizeof(struct _TIMEDISABLE_) );                           
                            if ( _num >= 5 )
                            {
                                for( j=0; j<MAXselGROUP; j++ )
                                {
                                    if ( group[_SEL_LOCKOUT].info[j] == _num-4 )
                                        group[_SEL_LOCKOUT].info[j] = 0;
                                }
                                saveGroup();
                            }
                            
                        }
                        i++;
                    }
                }
                break;
        }

    } while( i < 5 );

    saveGroup();

    return K_OK;
}                                               //  edDisableTx

unsigned short  edDisableT1( unsigned char typeVar )
{
    return edDisableTx( 0, typeVar );
}                                               //  edDisableT1

unsigned short  edDisableT2( unsigned char typeVar )
{
    return edDisableTx( 1, typeVar );
}                                               //  edDisableT2

unsigned short  edDisableT3( unsigned char typeVar )
{
    return edDisableTx( 2, typeVar );
}                                               //  edDisableT3

unsigned short  edDisableT4( unsigned char typeVar )
{
    return edDisableTx( 3, typeVar );
}                                               //  edDisableT4

unsigned short  edDisableT5( unsigned char typeVar )
{
    return edDisableTx( 4, typeVar );
}                                               //  edDisableT5

/*--------------------------------------------------------------------------
 | edPercDimm:  program dimming sensor perc
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/
#if LED_DIMMING
extern DWORD          dutyLED2;
#endif

unsigned short  edPercDimm( unsigned char typeVar )
{
#if LED_DIMMING
    *((DWORD *)editData) = NonVolatileSetup.percDimming;
    if ( *((DWORD *)editData) > 100 )
        *((DWORD *)editData) = 100;

    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.percDimming != *((DWORD *)editData) )
    {
        NonVolatileSetup.percDimming = *((DWORD *)editData);
        saveSettings();
    }
    dutyLED2 = setLedDimming( NonVolatileSetup.percDimming );
#endif
    return K_OK;
}                                               //  edPercDimm




/*--------------------------------------------------------------------------
 | edTimeDimm:  program dimming sensor timing
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edTimeDimm( unsigned char typeVar )
{
    unsigned char key;
    byte        ndigit, _min, _sec;

    _min = NonVolatileSetup.timeDimming/60;
    _sec = NonVolatileSetup.timeDimming%60;
      
    dispTdHour( _min, _sec, 0, 0, 1 );

    ndigit = 0;
    do {
        if (   machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123  ||
               machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39  || machineType == MACHINA_VEI147 || 
               machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM )
        {
            if ( (key=getKeymenu(K_DOOR)) == 0 )
                continue;
            if ( key == K_DOOR )
                break;
        }
        else
        {
            if ( (key=getKeymenu(K_ESC)) == 0 )
                continue;
            if ( key == K_ESC || key == K_SX )
                break;
        }
        
        if ( ndigit == 0 )
        {                       // 10th min
            if ( key >= K_0 && key <= K_2 )
            {
                _min = (key-K_0)*10;
                _sec = 0;
                ndigit++;
                dispTdHour( _min, _sec, 0, ndigit, 1 );
            }
        }
        else if ( ndigit == 1 )
        {                       // hour
            if ( key >= K_0 && key <= K_9 )
            {
                _min = ((_min/10)*10) + (key-K_0);
                ndigit++;
                dispTdHour( _min, _sec, 0, ndigit, 1 );
            }
        }
        else if ( ndigit == 2 )
        {                       // 10th min
            if ( key >= K_0 && key <= K_5 )
            {
                _sec = (key-K_0)*10;
                ndigit++;
                dispTdHour( _min, _sec, 0, ndigit, 1 );
            }
        }
        else if ( ndigit == 3 )
        {                       // minutes
            if ( key >= K_0 && key <= K_9 )
            {
                _sec = ((_sec/10)*10) + (key-K_0);
                ndigit++;
                dispTdHour( _min, _sec, 0, ndigit, 1 );
            }
        }

        if ( _min > 29 || _sec > 59 )
        {
            ndigit = 0;
            _min = 0;
            _sec = 0;
            dispTdHour( _min, _sec, 0, 0, 1 );
        }
    }while( key != K_OK);

    if ( NonVolatileSetup.timeDimming != _min*60+_sec )
    {
        NonVolatileSetup.timeDimming = _min*60+_sec;
        saveSettings();
    }
    return K_OK;
}                                               //  edTimeDimm


/*--------------------------------------------------------------------------
 | dispSelSec:set time in seconds (0-59)
 |                              --------------
 | In:  *_sec               time variable pointer
        *_msg               message displayed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  dispSelSec( byte *_sec, char *_msg)
{
    unsigned char key;
    
    strcpy ( bufferLCD, _msg );
    bufferLCD[12] = *_sec/10+0x30;
    bufferLCD[13] = *_sec%10+0x30;
    DispStr( 0, 0, bufferLCD );
    do {
        if( (key = getKeymenu( K_SX )) == 0)
            continue;
        if ( key >= K_0 && key <= K_9 )
        {                                
            if ((*_sec*10 + (key-K_0)) < 60)
               *_sec = *_sec*10 + (key-K_0); 
            else
               *_sec = (key-K_0);
            bufferLCD[12] = *_sec/10+0x30;
            bufferLCD[13] = *_sec%10+0x30;
            DispStr( 0, 0, bufferLCD );
        }            
    }while( key != K_ESC && key != K_OK);
    return K_OK;
}


/*--------------------------------------------------------------------------
 | edFlashing:program flashing on/off rate and timeout
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edFlashing( unsigned char typeVar )
{    
    byte        _on, _off, _timeOut;  

    _on = NonVolatileSetup.flashingLedOn;
    _off = NonVolatileSetup.flashingLedOff;
    _timeOut = NonVolatileSetup.ledOnTimeOut;
    
    dispSelSec( &_on, (char *)MENU_6221a);
    dispSelSec(&_off, (char *)MENU_6222a);
    dispSelSec( &_timeOut, (char *)MENU_6223a);

    if ( NonVolatileSetup.flashingLedOn != _on ||  
         NonVolatileSetup.flashingLedOff != _off ||
         NonVolatileSetup.ledOnTimeOut != _timeOut   )
    {
        NonVolatileSetup.flashingLedOn = _on;
        NonVolatileSetup.flashingLedOff = _off;
        NonVolatileSetup.ledOnTimeOut = _timeOut;
        saveSettings();
    }
    return K_OK;
}


/*--------------------------------------------------------------------------
 | edSteady:set steady led timeout
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSteady( unsigned char typeVar )
{    
    byte        _timeOut;  

    _timeOut = NonVolatileSetup.ledOnTimeOut;
    
    dispSelSec( &_timeOut, (char *)MENU_6211a);

    if ( NonVolatileSetup.flashingLedOn != 0 ||  
         NonVolatileSetup.flashingLedOff != 0 ||
         NonVolatileSetup.ledOnTimeOut != _timeOut   )
    {
        NonVolatileSetup.flashingLedOn = 0;
        NonVolatileSetup.flashingLedOff = 0;
        NonVolatileSetup.ledOnTimeOut = _timeOut;
        saveSettings();
    }
    return K_OK;
}


/*--------------------------------------------------------------------------
 | enLed:disable led flashing 
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  enLed( unsigned char typeVar )
{    
    byte        key;
    
    DispStr( 0, 0, (char *)MENU_6231a );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return FALSE;
    } while ( key != K_OK );    
    NonVolatileSetup.flashingLedOn = 0;
    NonVolatileSetup.flashingLedOff = 0;
    NonVolatileSetup.ledOnTimeOut = 0;     
    saveSettings();
    return K_OK;
}

/*--------------------------------------------------------------------------
 | edTrayCoupling:program tray coupling
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edTrayCoupling( unsigned char typeVar )
{
#if 1    
    unsigned char key;
    char        selNO[LCDCOL+1], selYES[LCDCOL+1];
    byte        tray, column, f, resp, coupled_column, old_coupled_column;

    if (VED1000_en == TRUE) 
        memcpy ( bufferLCD, (char *)MENU_571c, 16 );

    DispStr( 0, 0, bufferLCD );
                                        // select tray/column
    tray = 0xFF; column = 0xFF;    
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, &column );
        if ( (column&0x01) == 0x01 )
            column = 0xFF;              // select only even column
        selectDisplay( &tray, &column );
        if ( tray != 0xFF && column != 0xFF )
        {
            if ( usable[tray][column] == 0 )
            {                           // not available
                tray = 0xFF;
                column = 0xFF;
                selectDisplay( &tray, &column );
                BuzzerOn(500);
                Delay(2000);
            }
        }                
    } while( tray == 0xFF || column == 0xFF );
    
    if (VED1000_en == TRUE) 
    {
        for( ; tray < MAXTRAY; tray++ )
        {
            for( ; column < MAXCOLUMN; column += 2 )
            {
                if ( usable[tray][column] == 0 )
                    continue;
                if (checkNotConsecutiveCoupling(tray, column, 0) == TRUE)
                    continue;
                selectDisplay( &tray, &column );                                        
                if (NonVolatileSetup.motorCoupled[tray][column] != 0)
                                            // coupling set
                    coupled_column = NonVolatileSetup.motorCoupled[tray][column];
                else                        // no coupling set
                    coupled_column = 0xFF;
                old_coupled_column = coupled_column;
                                            // display selection coupled
                selectDisplayPos( &tray, &coupled_column, 13 );            
                do {
                    if( (key = getKeymenu( K_SX )) == 0)
                        continue;    
                    if ( key == K_SX )
                        return K_SX;                
                    selection( key, &tray, &coupled_column );                                        
                    if ( (coupled_column&0x01) != 0x01 || 
                         (checkCoupling(tray, coupled_column) == TRUE && NonVolatileSetup.motorCoupled[tray][column] != coupled_column) ||
                         (coupled_column < column) ||
                         (checkNotConsecutiveCoupling(tray, column, coupled_column) == TRUE)
                       )
                                            // selection is even or already coupled or less than master column or between an
                                            // already programmed master-slave column
                        coupled_column = 0xFF; 
                    selectDisplayPos( &tray, &coupled_column, 13 );
                } while( key != K_OK);                      
                
                strcpy ( selNO, (char *)MENU_571d );
                strcpy ( selYES, (char *)MENU_571e );                            
                memcpy ( selNO, bufferLCD, 4 );
                memcpy ( selYES, bufferLCD, 4 );            
                memcpy ( selNO+8, bufferLCD+12, 4 );
                memcpy ( selYES+8, bufferLCD+12, 4 ); 
                if ( old_coupled_column != coupled_column) {
                                            // coupled selection changed
                    if ( edToggleY_N( selNO, selYES ) ) {
                        if (coupled_column != 0xFF) {
                            NonVolatileSetup.motorCoupled[tray][column] = coupled_column;
                            column = coupled_column-1;
                        }
                        else
                            NonVolatileSetup.motorCoupled[tray][column] = 0;
                        saveSettings();
                    } 
                }                
                strcpy ( bufferLCD, (char *)MENU_571c );
            }
        }
    }
    else {
        strcpy ( selNO, (char *)MENU_571a );
        strcpy ( selYES, (char *)MENU_571b );
        for( ; tray < MAXTRAY; tray++ )
        {        
            for( ; column < MAXCOLUMN; column += 2 )
            {
                if ( usable[tray][column] == 0 )
                    continue;
                selectDisplay( &tray, &column );
                memcpy ( selNO, bufferLCD, 5 );
                memcpy ( selYES, bufferLCD, 5 );
        
                f = (NonVolatileSetup.motorCoupled[tray][column]?NonVolatileSetup.motorCoupled[tray][column]-column:0);
                if ( (resp=edToggle( &f, 0, 1, selNO, selYES )) != K_OK )
                    return resp;
    
                NonVolatileSetup.motorCoupled[tray][column] = (f?column+1:0);
                saveSettings();
            }
        }
    }
    return K_OK;
#else
    byte        tray, f, resp;
    char        selNO[LCDCOL+1], selYES[LCDCOL+1];
    unsigned char key;
                                        // select tray
    DispStr( 0, 0, bufferLCD );
    tray = 0xFF;
    selectDisplay( &tray, NULL );
    do {
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        if ( key == K_ESC )
            return K_ESC;
        selection( key, &tray, NULL );
        selectDisplay( &tray, NULL );
        if ( tray != 0xFF  )
        {
            if ( testTray(tray) == 0 )
            {                           // not available
                tray = 0xFF;
                selectDisplay( &tray, NULL );
                BuzzerOn(500);
                Delay(2000);
            }
        }
    } while( tray == 0xFF );

                                        // test amount
    for( ; tray < MAXTRAY; tray++ )
    {
        if ( testTray(tray) == 0 )
            continue;

        selectDisplay( &tray, NULL );
        strcpy ( selNO, (char *)MENU_571a );
        memcpy ( selNO, bufferLCD, 5 );
        strcpy ( selYES, (char *)MENU_571b );
        memcpy ( selYES, bufferLCD, 5 );

        f = NonVolatileSetup.trayCoupled[tray];
        if ( (resp=edToggle( &f, 0, 1, selNO, selYES )) != K_OK )
            return resp;

        NonVolatileSetup.trayCoupled[tray] = f;
        saveSettings();
    }
    return K_OK;
#endif
}                                               //  edTrayCoupling


/*--------------------------------------------------------------------------
 | edLoadFile:  select the file name for loading settings
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edLoadFile( unsigned char typeVar )
{
    unsigned short resp;
    byte        f;
    unsigned char key;

    if ( (key=edString(SETTINGS_ID)) != K_OK )
        return key;

    f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_721a, (char *)MENU_721b )) != K_OK )
        return resp;

    key = K_OK;
    if ( f == 1 )
    {
        if ( loadMMCsettings(superUser) )
            while( (key=getKeymenu(K_ESC)) == 0 );
    }
    
    return key;
}                                               //  edLoadFile

unsigned short  edSaveFile( unsigned char typeVar )
{
    unsigned short resp;
    byte        f;
    unsigned char key;

    if ( (key=edString(SETTINGS_ID)) != K_OK )
        return key;

    f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_731a, (char *)MENU_731b )) != K_OK )
        return resp;

    key = K_OK;
    if ( f == 1 )
    {
        if ( saveMMCsettings(superUser) )
            while( (key=getKeymenu(K_ESC)) == 0 );
    }

    return key;
}                                               //  edSaveFile

/*--------------------------------------------------------------------------
 | edSetTestMotors: enable test vend in main function
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/
unsigned short  edSetTestMotors( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = 0x00;
    DispStr( 0, 0, (char *)MENU_861a );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            if ( f == 0x68 )
            {
                f = 0x00;
                DispStr( 0, 0, (char *)MENU_861a );
            }
            else
            {
                f = 0x68;
                DispStr( 0, 0, (char *)MENU_861b );
            }
        }
    } while ( key != K_OK );
    
    if (f == 0x68)
        testMotors();

    return K_OK;   
}                                               //  edSetTestMotors


/*--------------------------------------------------------------------------
 | edSetTestVend: enable test vend in main function
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSetTestVend( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = testVend;
    if ( f != 0x68 )
        DispStr( 0, 0, (char *)MENU_811a );
    else
        DispStr( 0, 0, (char *)MENU_811b );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            if ( f == 0x68 )
            {
                f = 0x00;
                DispStr( 0, 0, (char *)MENU_811a );
            }
            else
            {
                f = 0x68;
                DispStr( 0, 0, (char *)MENU_811b );
            }
        }
    } while ( key != K_OK );

    testVend = f;

    return K_OK;
}                                               //  edSetTestVend

/*--------------------------------------------------------------------------
 | edAudClr : clear audit values
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edAudClr( unsigned char typeVar )
{
    if( edToggleY_N( (char *)MENU_951a, (char *)MENU_951b ) )
    {
        AuditData[EA302] = dateTime.year*10000 + dateTime.month*100 + dateTime.day;
        AuditData[EA303] = dateTime.hour*10000 + dateTime.min*100 + dateTime.sec;
        AuditData[SE01] = 0;
        InsertEvent1( EVENT_AUDIT_READOUT, AuditData[EA302], AuditData[EA303] );
        Audit( );
    }

    return K_OK;
}                                               //  edAudClr




/*--------------------------------------------------------------------------
 | edAudErase:  erase audit
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edAudErase( unsigned char typeVar )
{
    if ( !edToggleY_N( (char *)MSG_NO, (char *)MSG_YES ) )
        return K_OK;

    initAudit();

    return K_OK;
}                                               //  edAudErase




/*--------------------------------------------------------------------------
 | edValoreAudit : visualizza valore audit
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edWaitKey( void )
{
    unsigned char key;

    DispStr( 0, 0, bufferLCD );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
    } while ( key != K_DW && key != K_UP );
    return key;
}

unsigned short  edValoreAudit( unsigned long typeVar )
{
    if ( posVirgola == 2 && (typeVar & 0x8000) )
        sprintf( &bufferLCD[8], "%5ld.%02ld", AuditData[typeVar&0x7FFF]/100, AuditData[typeVar&0x7FFF]%100 );
    else
        sprintf( &bufferLCD[8], "%8ld", AuditData[typeVar&0x7FFF] );
    return edWaitKey();
}                                               //  edValoreAudit




/*--------------------------------------------------------------------------
 | edShowRelease:show firmware release
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edShowRelease( unsigned long typeVar )
{
#ifdef __WIN32__
    if ( typeVar == 0 )
        sprintf( bufferLCD, " %8.8s  %5.5s", "NO BOOT", __TIME__ );
    else
        sprintf( bufferLCD, " %8.8s  %5.5s", "EMULATOR", __TIME__ );
#else
    char        *p;

    if ( typeVar == 0 )
    {
        p = (char *)(BOOT_VER);
        if ( *(p+8) >= '0' && *(p+8) <= '9' )
            sprintf( &bufferLCD[8], "  #%c.%c.%c", *(p+9), *(p+10), *(p+11) );
        else
            sprintf( &bufferLCD[8], "  #x.x.x" );
    }
    else
    {
        getFirmwareRelease( bufferLCD );
    }
#endif
    return edWaitKey();
}                                               //  edShowRelease




/*--------------------------------------------------------------------------
 | edShowSerialNum:show hardware serial number
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edShowSerialNum( unsigned long typeVar )
{
#ifdef __WIN32__
    sprintf( bufferLCD, " S.N.:  xxxxxxxx" );
#else
    sprintf( bufferLCD, " S.N. : %s", &SerialID[8] );
#endif
    return edWaitKey();
}                                               //  edShowSerialNum

/*--------------------------------------------------------------------------
 | edDropSensorTest:drop sensor test
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDropSensorTest( unsigned long typeVar )
{
    unsigned char key;
    
    do {
        if (FALL_SENSOR )
            BuzzerOn(50);
        
        if( (key = getKeymenu( K_ESC )) == 0)
            continue;
        return key;;                     
    }while (-1);
}                                               //  edShowSerialNum

/*--------------------------------------------------------------------------
 |  selection : analize key entry and set tray/column to follow the machine
 |              dependent semantics
 |                              --------------
 | In:          char key, byte *tray, byte *column
 | Out:
 +--------------------------------------------------------------------------*/

void  selection( char key, byte *tray, byte *column )
{
    if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39  || 
         machineType == MACHINA_VEI147 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ||
         machineType == MACHINA_VEILCM )
    {
        if ( key >= K_1 && key <= K_9 && tray != NULL && *tray == 0xFF )
            *tray = (key-K_1);
        else if ( key >= K_0 && key <= K_9 && column != NULL )
            *column = (key-K_0);
    }
    else if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
    {
        if ( key >= K_0 && key <= K_9 && column != NULL && *column == 0xFF )
            *column = (key-K_0);
        else if ( key >= K_1 && key <= K_9 )
            *tray = (key-K_0);
    }
    else
    {
        if ( key >= K_A && key <= K_K )
            *tray = (key-K_A);
        if ( key >= K_0 && key <= K_9 && column != NULL )
            *column = (key-K_0);
    }
}

static void  selectDisplayPos( byte *tray, byte *column, byte pos )
{
    if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR  || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM )
    {
#if SLAVE_MACHINE
        if( SlaveMAchineNumber == 0xFF )
            bufferLCD[pos++] = '_';
        else
            bufferLCD[pos++] = '1'+SlaveMAchineNumber;
#else
        bufferLCD[pos++] = '1';
#endif
        if ( tray == NULL )
            bufferLCD[pos] = '*';
        else if ( *tray == 0xFF )
            bufferLCD[pos] = '_';
        else
            bufferLCD[pos] = '1'+*tray;
        pos++;
        if ( column == NULL )
            bufferLCD[pos] = '*';
        else if ( *column == 0xFF )
            bufferLCD[pos] = '_';
        else
            bufferLCD[pos] = '0'+*column;
    }
    else if (  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
    {
        if ( *tray == 0xFF )
            bufferLCD[pos+2] = '_';
        else
            bufferLCD[pos+2] = '0'+*tray;
    
        if ( column == NULL )
            bufferLCD[pos] = '*';
        else if ( *column == 0xFF )
            bufferLCD[pos] = '_';
        else
            bufferLCD[pos] = '0'+*column;
    }
    else if (  machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6)
    {
        if ( *tray == 0xFF )
            bufferLCD[pos] = '_';
        else {
            if (*tray < 9)
                bufferLCD[pos] = '1'+*tray;
            else {
                bufferLCD[pos  ] = '1';
                bufferLCD[pos+1] = '0';
            }
        }
    
        pos += 2;
        if ( column == NULL )
            bufferLCD[pos] = '*';
        else if ( *column == 0xFF )
            bufferLCD[pos] = '_';
        else
            bufferLCD[pos] = '0'+*column;
    }
    else
    {
        if ( *tray == 0xFF )
            bufferLCD[pos] = '_';
        else
        {
            bufferLCD[pos] = 'A'+*tray;
            if ( (machineType == MACHINA_NAT157 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 ) && *tray >= 8 )
                bufferLCD[pos] += 1;// salta I e passa a J
        }
    
        if ( column == NULL )
            bufferLCD[pos+2] = '*';
        else if ( *column == 0xFF )
            bufferLCD[pos+2] = '_';
        else
        {
            bufferLCD[pos+2] = '0'+*column;
            if ( (machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123) && *column == 0 )
                bufferLCD[pos+1] = '1';
            else
                bufferLCD[pos+1] = ' ';
        }
    }
    DispStr( 0, 0, bufferLCD );
}


void  selectDisplay( byte *tray, byte *column )
{
      selectDisplayPos( tray, column, 1 );
}



/*--------------------------------------------------------------------------
 | getKeymenu:  gestione uscita automatica dal menu: ogni menu indica il tasto 
 |              da usare per effettuare l'uscita. Chiudendo la porta si esce dai menu
 |              exit when closing the door
 |              exit after 30" if no command coming from the HOST in the HOST forced programming mode
 |                              --------------
 | In:  esc     menu escape key
 | Out: byte    return key
 +--------------------------------------------------------------------------*/

byte            getKeymenu( byte esc )
{
    byte key;

    lpdUpdate();
    hostManager();

    if ( (key=getKey()) != 0 && key != K_AST )  
      return key;
    if ( (((GestioneMenuForcedByHost != 0) && (GetTickCount() - GestioneMenuForcedByHost > 30000)) || exitMenuForcedByHost == TRUE) ||
         (!doorOpen() && GestioneMenuForcedByHost == 0) 
    ) 
    {
      GestioneMenuForcedByHost = 0;
      exitMenuForcedByHost = FALSE;
      return esc;
    }
    return 0;
}                                               //  getKeymenu




/*--------------------------------------------------------------------------
 | edString:    string input
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

const byte    * const t9_char[10] = {
    /* 0*/" 0\x1\x2",
    /* 1*/",.:;1",
    /* 2*/"ABC2",
    /* 3*/"DEF3",
    /* 4*/"GHI4",
    /* 5*/"JKL5",
    /* 6*/"MNO6",
    /* 7*/"PQRS7",
    /* 8*/"TUV8",
    /* 9*/"WXYZ9",
};

const byte    * const t9_num[10] = {
    /* 0*/"0 \x1\x2",
    /* 1*/"1,.:;",
    /* 2*/"2ABC",
    /* 3*/"3DEF",
    /* 4*/"4GHI",
    /* 5*/"5JKL",
    /* 6*/"6MNO",
    /* 7*/"7PQRS",
    /* 8*/"8TUV",
    /* 9*/"9WXYZ",
};

#define KEY_TOUT    3000

unsigned short  edString( unsigned char typeVar )
{
    unsigned char key;
    byte        i, keyLock, cursorPos, textPos, thisKey, lastKey, len, fixedLen, left, right;
    byte        insMode, findFile, blink;
    byte        * * t9;
    char        dispBuffer[LCDCOL+1], fixedText[8+1];
    DWORD       timer;
	uint32_t    pstart, psize;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;

    insMode = 0;
    findFile = 0;
    if ( typeVar == ADV_MSG )
    {
        t9 = (byte * *)&t9_char[0];
        len = MSG_ADV_LEN;
        fixedLen = 5;
        memcpy( fixedText, &MENU_311[3], fixedLen );

        memset ( editData, ' ', len );
        for ( i = 0; i < len && NonVolatileSetup.adv.msg[i] != '\0'; i++ )
        {
            if ( NonVolatileSetup.adv.msg[i] > ' ' && NonVolatileSetup.adv.msg[i] < 0xFF )
                editData[i] = NonVolatileSetup.adv.msg[i];
        }
    }
    else if ( typeVar == ASSET_ID )
    {
        t9 = (byte * *)&t9_num[0];
        len = ASSET_ID_LEN;
        fixedLen = 4;
        memcpy( fixedText, &MENU_551[3], fixedLen );

        memset ( editData, ' ', len );
        for ( i = 0; i < len && NonVolatileSetup.assetID[i] != '\0'; i++ )
        {
            if ( NonVolatileSetup.assetID[i] > ' ' && NonVolatileSetup.assetID[i] < 0xFF )
                editData[i] = NonVolatileSetup.assetID[i];
        }
    }
    else if ( typeVar == SETTINGS_ID )
    {
        t9 = (byte * *)&t9_num[0];
        len = SETTINGS_ID_LEN;
        fixedLen = 4;
        memcpy( fixedText, &MENU_551[3], fixedLen );

        memset ( editData, ' ', len );
        for ( i = 0; i < len && NonVolatileSetup.settingsID[i] != '\0'; i++ )
        {
            if ( NonVolatileSetup.settingsID[i] > ' ' && NonVolatileSetup.settingsID[i] < 0xFF )
                editData[i] = NonVolatileSetup.settingsID[i];
        }
//mmm        
//        insMode = 1;
        if ( mmcInit() == mmc_noerr )
            findFile = 1;
        else
            findFile = 0;
    }
    else
        return K_SX;
    fixedText[fixedLen] = '\0';
    editData[len] = '\0';


    left = 0;
    right = 0;
    timer = 0;
    blink = 0;
    thisKey = 0;
    lastKey = 0;
    keyLock = 0;
    cursorPos = 0xFF;
    textPos = 0;
    do {
        if ( timer != 0 && (GetTickCount()-timer) > KEY_TOUT )
        {
            lastKey = 0;
            thisKey = 0;
            if ( editData[textPos+cursorPos] == '\x1' )
            {
                editData[textPos+cursorPos] = ' ';
                left = 1;
            }
            else if ( editData[textPos+cursorPos] == '\x2' )
            {
                memset( &editData[textPos+cursorPos],  ' ', strlen( &editData[textPos+cursorPos] ) );
                key = K_A;//update video
            }
            else
                right = 1;
            timer = 0;
        }
        else
        {
            key = getKeymenu(K_OK);
            if (  machineType != MACHINA_ROWE5900 && machineType != MACHINA_ROWE6800 && machineType != MACHINA_AP123 &&
                  machineType != MACHINA_VEIDOOR && machineType != MACHINA_AMS39 && machineType != MACHINA_VEI147 && 
                  machineType != MACHINA_USIGVC2 && machineType != MACHINA_MERCHA6 && machineType != MACHINA_VEILCM )
            {
                if ( key == K_SX )
                    left = 1;
                if ( key == K_DX )
                    right = 1;
            }
        }
        if ( key == 0 && cursorPos != 0xFF && left == 0 && right == 0 )
        {
            if ( findFile )
            {
                if ( (GetTickCount()%1000) < 500  )
                {
                    if ( blink )
                    {
                        memset( &dispBuffer[fixedLen+cursorPos], ' ', LCDCOL-(fixedLen+cursorPos) );
                        DispStr( 0, 0, dispBuffer );
                        if ( keyLock == 0 )
                            CursorOn( 0, fixedLen+cursorPos );
                        else
                            CursorBlink( 0, fixedLen+cursorPos );
                    }
                    blink = 0;
                    continue;
                }
            }
            else
                continue;
        }
        if ( key == K_OK )
            break;
        if ( key == K_ESC )
            return K_SX;

        if ( key != 0 )
            keyLock = 1;
        if ( cursorPos == 0xFF )
            cursorPos = 0;

        if ( key >= K_0 && key <= K_9 )
        {
            blink = 0;
            if ( insMode )
            {                           // se insert mode, cancella testo inserito
                memset ( editData, ' ', len );
                insMode = 0;
            }

            timer = GetTickCount();
            if ( timer == 0 )
                timer--;                // non zero
            if ( key == lastKey )
            {
                thisKey++;
                if ( t9[key-K_0][thisKey] == '\0' )
                    thisKey = 0;
                editData[textPos+cursorPos] = t9[key-K_0][thisKey];
            }
            else
            {
                thisKey = 0;
                if ( lastKey != 0 )
                {
                    if ( (textPos+cursorPos) < (len-1) )
                    {
                        if ( cursorPos < (LCDCOL-fixedLen-2) || (fixedLen+len) <= LCDCOL )
                            cursorPos++;
                        else
                            textPos++;
                    }
                }
                lastKey = key;
                editData[textPos+cursorPos] = t9[key-K_0][thisKey];
            }
        }
        if ( right && (textPos+cursorPos) < (len-1) )
        {
            blink = 0;
            if ( editData[textPos+cursorPos] == '\x1' )
                editData[textPos+cursorPos] = ' ';
            else if ( editData[textPos+cursorPos] == '\x2' )
                memset( &editData[textPos+cursorPos],  ' ', strlen( &editData[textPos+cursorPos] ) );
            
            if ( cursorPos < (LCDCOL-fixedLen-2) || (fixedLen+len) <= LCDCOL )
                cursorPos++;
            else
                textPos++;
            lastKey = 0;
            timer = 0;
        }
        if ( left && (textPos+cursorPos) > 0 )
        {
            blink = 0;
            if ( editData[textPos+cursorPos] == '\x1' )
                editData[textPos+cursorPos] = ' ';
            else if ( editData[textPos+cursorPos] == '\x2' )
                memset( &editData[textPos+cursorPos],  ' ', strlen( &editData[textPos+cursorPos] ) );

            if ( cursorPos > 0 )
                cursorPos--;
            else
                textPos--;
            lastKey = 0;
            timer = 0;
        }

        if ( findFile && key != 0 )
        {                               // get complete file name
                // Obtain pointer to first partition on first (only) unit
            pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
            if ( pstart != 0xffffffff ) 
            {
                if ( DFS_GetVolInfo(0, sector, pstart, &vi) == 0 ) 
                    DFS_FindFile(&vi, (uint8_t *)editData, textPos+cursorPos+((timer!=0)?1:0), "CSV", 3, sector, &fi);
                else
                    findFile = 0;
            }
            else
                findFile = 0;
        }

        if ( textPos < fixedLen )
        {
            strcpy( dispBuffer, &fixedText[textPos] );
            memcpy( &dispBuffer[strlen(dispBuffer)], editData, LCDCOL-strlen(dispBuffer) );
            if ( (fixedLen+len) > LCDCOL )
                dispBuffer[LCDCOL-1] = '>';
        }
        else
        {
            memcpy( dispBuffer, &editData[textPos-fixedLen], LCDCOL );
            if ( (textPos-fixedLen) > 0 )
                dispBuffer[0] = '<';
            if ( textPos == (len-10) )
                dispBuffer[LCDCOL-1] = '#';
            else
                dispBuffer[LCDCOL-1] = '>';
        }
        dispBuffer[LCDCOL] = '\0';
        if ( !blink )
        {
            DispStr( 0, 0, dispBuffer );
            if ( keyLock == 0 )
                CursorOn( 0, fixedLen+cursorPos );
            else
                CursorBlink( 0, fixedLen+cursorPos );
        }
        blink = 1;

        right = 0;
        left = 0;
    } while ( key != K_OK );
    CursorOff();

    if ( typeVar == ADV_MSG )
        memcpy( NonVolatileSetup.adv.msg, editData, sizeof(NonVolatileSetup.adv.msg) );
    else if ( typeVar == ASSET_ID )
    {
        memcpy( NonVolatileSetup.assetID, editData, sizeof(NonVolatileSetup.assetID) );
    }
    else if ( typeVar == SETTINGS_ID )
        memcpy( NonVolatileSetup.settingsID, editData, sizeof(NonVolatileSetup.settingsID) );
    saveSettings();

    return K_OK;
}                                               //  edString




/*--------------------------------------------------------------------------
 | edDelay:     program advertising message start delay
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDelay( unsigned char typeVar )
{
    DispStr( 0, 0, bufferLCD );

    if ( NonVolatileSetup.adv.tout > 99 )
        *((DWORD *)editData) = 0;
    else
        *((DWORD *)editData) = NonVolatileSetup.adv.tout;

    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( *((DWORD *)editData) > 99 )
        NonVolatileSetup.adv.tout = 0;
    else
        NonVolatileSetup.adv.tout = *((DWORD *)editData);
    saveSettings();

    return K_OK;
}                                               //  edDelay




/*--------------------------------------------------------------------------
 | edSpeed:     program advertising message visualization speed
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edSpeed( unsigned char typeVar )
{
    DispStr( 0, 0, bufferLCD );

    if ( NonVolatileSetup.adv.speed > 9 )
        *((DWORD *)editData) = 5;
    else
        *((DWORD *)editData) = NonVolatileSetup.adv.speed;

    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( *((DWORD *)editData) > 9 )
        NonVolatileSetup.adv.speed = 5;
    else
        NonVolatileSetup.adv.speed = *((DWORD *)editData);
    saveSettings();

    return K_OK;
}                                               //  edSpeed



/*--------------------------------------------------------------------------
 | enCOUPLING:  enable motor coupling on NAT147 and NAT157 and AMS39 and VEI147
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       coupling available
 |      1       coupling NOT available
 +--------------------------------------------------------------------------*/

byte            enCOUPLING( unsigned char _typeVar )
{
    if (   machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 
        || machineType == MACHINA_AMS39  || machineType == MACHINA_VEI147 
        || machineType == MACHINA_MERCHA6 )   // VERIFICARE || machineType == MACHINA_USIGVC2
        return 0;
    else
        return 1;//error
}                                               //  enCOUPLING




/*--------------------------------------------------------------------------
 | enMMC_SD:    verify if MMC/SD available to enable operation on the memory
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       mmc/sd available
 |      1       mmc/sd NOT available
 +--------------------------------------------------------------------------*/

byte            enMMC_SD( unsigned char _typeVar )
{
    if ( mmcPresent == TRUE )
        return 0;
    else
        return 1;
}                                               //  enMMC_SD




/*--------------------------------------------------------------------------
 | enMMD:       verify if the display is connected
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       display available
 |      1       display not available
 +--------------------------------------------------------------------------*/

byte            enMMD( unsigned char _typeVar )
{
    if ( mmdStatus == 0 )
        return 0;
    else
        return 1;
}                                               //  enMMD




/*--------------------------------------------------------------------------
 | enMMC_MMD:   verify if MMC/SD available to enable operation on the memory
 |              and the display is connected
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       mmc/sd and display available
 |      1       mmc/sd NOT available
 |      2       display not available
 +--------------------------------------------------------------------------*/

byte            enMMC_MMD( unsigned char _typeVar )
{
    if ( mmcPresent == TRUE )
    {
        if ( mmdStatus == 0 )
            return 0;
        else
            return 2;
    }
    else
        return 1;
}                                               //  enMMC_MMD




/*--------------------------------------------------------------------------
 | enSUPERUSER: enable function after superuser password
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 1       normal
 |      0       superuser
 +--------------------------------------------------------------------------*/

byte            enSUPERUSER( unsigned char _typeVar )
{
    return (superUser?0:1);
}                                               //  enSUPERUSER




/*--------------------------------------------------------------------------
 | menuInitialization:ask to initialize the board
 |              - INIT CONFIGURATION
 |              - INIT PRICES
 |              - INIT IMAGES
 |              - INIT DEX
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 1       normal
 |      0       superuser
 +--------------------------------------------------------------------------*/
#if ENABLE_DISCOUNT
extern unsigned short  sels[MAXTRAY][MAXCOLUMN];
void            discount_reload( byte _mode );
void            discount_eraseCounter( void );
#endif

void     initGroups( void )
{
    memset( group,      0x00,   sizeof(group)       );
    memset( grp_price,  0x00,   sizeof(grp_price)   );
	memset( idxGroup,   0x00,   sizeof(idxGroup)    );
	memset( timeFrames, 0x00,   sizeof(timeFrames)  );
}

unsigned short  menuInitialization( unsigned char _typeVar )
{
    unsigned short resp;
    byte        f, i, j, k;
    byte        cpAssetID[ASSET_ID_LEN+1];    // dex asset ID

                                        // init configuration
    f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_CONFn, (char *)MENU_CONFy )) != K_OK )
        return resp;
    if ( f == 1 )
    {
        memcpy( cpAssetID, NonVolatileSetup.assetID, sizeof(NonVolatileSetup.assetID) );
        initialSettings();
        initGroups();
        if ( cpAssetID[0] >= ' ' && cpAssetID[0] < 0xFF )
            memcpy( NonVolatileSetup.assetID, cpAssetID, sizeof(NonVolatileSetup.assetID) );
        saveSettings();
        saveGroup();
#if ENABLE_DISCOUNT
        discount_eraseCounter();
#endif
    }

                                        // init price
    f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_PRICEn, (char *)MENU_PRICEy )) != K_OK )
        return resp;
    if ( f == 1 )
    {
        memset( usable,     0xFF,   sizeof(usable)      );
        for (i=0;i<MAX_MACHINE_NUM;i++) {
            for (j=0;j<MAXTRAY;j++) {
                for (k=0;k<MAXCOLUMN;k++) {
                    amount[i][j][k] = 900;
                }
            }            
        }
        initGroups();
        saveAmount();
        saveGroup();
    }

                                        // init dex
    f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_DEXn, (char *)MENU_DEXy )) != K_OK )
        return resp;
    if ( f == 1 )
    {
        initAudit();
    }
    
    return K_OK;
}                                               //  menuInitialization




/*--------------------------------------------------------------------------
 | menuFullDex: ask if send full selection list on DEX data 
 |              - INIT CONFIGURATION
 |              - INIT PRICES
 |              - INIT IMAGES
 |              - INIT DEX
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 1       normal
 |      0       superuser
 +--------------------------------------------------------------------------*/

unsigned short  menuFullDex( unsigned char _typeVar )
{
    unsigned short resp;
    byte        f;
    
                                        // init configuration
    if ( NonVolatileSetup.fullDexSelection == 0x6A )
        f = 1;
    else
        f = 0;
    if ( (resp=edToggle( &f, 0, 1, (char *)MENU_FULLNOn, (char *)MENU_FULLNOy )) != K_OK )
        return resp;
    if ( f == 1 )
    {
        if ( !edToggleY_N( (char *)MSG_NO, (char *)MSG_YES ) )
            return K_OK;
        NonVolatileSetup.fullDexSelection = 0x6A;
    }
    else
        NonVolatileSetup.fullDexSelection = 0x00;
           
    saveSettings();

    return K_OK;
}                                               //  menuFullDex

/*--------------------------------------------------------------------------
 | edDropHome : set homing mode mode
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDropHome( unsigned char typeVar )
{
    unsigned char key;
    byte        f;

    f = NonVolatileSetup.DropHome & 0x01;
    if ( f == 0x00 )
        DispStr( 0, 0, (char *)MENU_511ca );
    else
        DispStr( 0, 0, (char *)MENU_511cb );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f = (f^0x01)&0x7F;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_511ca );
            else
                DispStr( 0, 0, (char *)MENU_511cb );
        }
    } while ( key != K_OK );

    NonVolatileSetup.DropHome = f;
    saveSettings();

    return K_OK;
}                                               //  edDropHome

/*--------------------------------------------------------------------------
 | edAudSD : store DEX on SD CARD
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/
byte            storeDEXfile( byte _ch );

unsigned short  edAudSD( unsigned char typeVar )
{
    unsigned char key;
    byte        f = 0;

    DispStr( 0, 0, (char *)MENU_95a1a );
    do {
        if( (key = getKeymenu( K_SX )) == 0 )
            continue;
        if ( key == K_SX )
            return K_SX;
        if ( key != K_OK )
        {
            f ^= 0x01;
            if ( f == 0x00 )
                DispStr( 0, 0, (char *)MENU_95a1a );
            else
                DispStr( 0, 0, (char *)MENU_95a1b );
        }
    } while ( key != K_OK );

    if( f )
    {
        // store on SD CARD
        if( storeDEXfile( 0 ) != 0 )
          Delay(2000);      // for any error, wait some time to display the error message
    }
    return K_OK;
}                                               //  edAudSD

/*--------------------------------------------------------------------------
 | edPercTax:  program tax value
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edPercTax( unsigned char typeVar )
{
    *((DWORD *)editData) = NonVolatileSetup.percTax;
    if ( *((DWORD *)editData) > 9999 )
        *((DWORD *)editData) = 9999;

    if ( EditNumBox(typeVar, 0, 2) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.percTax != *((DWORD *)editData) )
    {
        NonVolatileSetup.percTax = *((DWORD *)editData);
        saveSettings();
    }
    return K_OK;
}                                               //  edPercTax


/*--------------------------------------------------------------------------
 | edWinSel:  program WinValue
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edWinSel( unsigned char typeVar )
{
    *((DWORD *)editData) = NonVolatileSetup.WinValue;
    if ( *((DWORD *)editData) > 500 )
        *((DWORD *)editData) = 500;

    if ( EditNumBox(typeVar, 0, 0) == K_SX )
        return K_SX;

    if ( NonVolatileSetup.WinValue != *((DWORD *)editData) )
    {
        NonVolatileSetup.WinValue = *((DWORD *)editData);
        saveSettings();
    }
    return K_OK;
}                                               //  edWinSel




/*--------------------------------------------------------------------------
 | edDayMach:   program discountDaysMachine
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

unsigned short  edDayMach( unsigned char typeVar )
{
    char        bsave = 0, key, stato = 0;
    WORD        *pdiscount = &NonVolatileSetup.discountFlag;

    CursorOff();
    do {

        switch( stato )
        {
          case 0:
                strcpy ( bufferLCD, (char *)MENU_6b11 );
                if ( *pdiscount >= 4 )  *pdiscount = 0;
                strcpy( &bufferLCD[9], message[_MENU_6b12+*pdiscount] );
                WriteRows();
                if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123 ||
                     machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || 
                     machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM )
                {
                    if ( (key=getKeymenu(K_DOOR)) == 0 )
                        continue;
                    if ( key == K_DOOR )
                        break;
                }
                else
                {
                    if ( (key=getKeymenu(K_ESC)) == 0 )
                        continue;
                    if ( key == K_ESC || key == K_SX )
                        break;
                }
                
                if ( key == K_UP )
                {
                    if ( *pdiscount >= 3 )
                        *pdiscount = 0;
                    else
                        (*pdiscount)++;
                    bsave = 1;
                }
                if( key == K_DW )
                {
                    if ( *pdiscount == 0 )
                        *pdiscount = 3;
                    else
                        (*pdiscount)--;
                    bsave = 1;
                }
                if( key == K_OK )
                {
                    key = 0;      // to prevent exit from menu on MACHINA_ROWE5900, MACHINA_ROWE6800, MACHINA_AP123, MACHINA_VEIDOOR.
                    if (*pdiscount == 1 || *pdiscount == 2)
                        stato++; 
                    else {
                        key = K_SX;
                        stato = 8;
                    }
                }
                break;
            
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
                DispStr( 0, 0, (char *)message[_MENU_6b1+stato-1] );
                *((DWORD *)editData) = (DWORD)*(pdiscount+stato);
                if (stato != 5) 
                    key = EditNumBox(typeVar, 0, 0);
                else                  
                    key = EditNumBox(MAX_NUM_SEL, 0, 0);
                
                if ( *(pdiscount+stato) != (WORD)*((DWORD *)editData) )
                {
                    *(pdiscount+stato) = (WORD)*((DWORD *)editData);
                    bsave = 1;
                }
exitFromMenu:;
                if( key == 0 )                                      // exit from menu
                {
                    if( ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AP123 ||
                          machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || 
                          machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 || machineType == MACHINA_VEILCM ) && stato != 7 )
                        key = K_DW;        // exit from menu on MACHINA_ROWE5900, MACHINA_ROWE6800, MACHINA_AP123, MACHINA_VEIDOOR, MACHINA_VEI147 only on menu 5
                    else
                        key = K_SX;
                }
                if( key == K_OK || key == K_DW || key == K_ESC )    // step next entry
                {
                    key = 0;      // to prevent exit from menu on MACHINA_ROWE5900, MACHINA_ROWE6800, MACHINA_AP123, MACHINA_VEIDOOR, MACHINA_VEI147
                    stato++;
                }
                if( key == K_UP && stato > 0 )                      // step previous entry
                    stato--;
                break;
        case 7:
                key = getKeymenu( K_SX );
                if( key == K_OK || key == K_DW || key == K_ESC || key == K_UP )
                {
                    goto exitFromMenu;
                }
                if ( key != 0 )
                {
                    bsave ^= 0x80;
                    if ( NonVolatileSetup.discountDoorClear == 0x71 )
                        NonVolatileSetup.discountDoorClear = 0x00;
                    else
                        NonVolatileSetup.discountDoorClear = 0x71;
                }
                if ( NonVolatileSetup.discountDoorClear == 0x71 )
                    DispStr( 0, 0, (char *)MENU_6b7b );// door clear discount counter
                else
                    DispStr( 0, 0, (char *)MENU_6b7a );// 
                break;               
        }

    } while(  key != K_DOOR && key != K_ESC && key != K_SX && stato < 8 );
    
    if ( NonVolatileSetup.discountFlag == DISCOUNT_CLEAR )
    {
         NonVolatileSetup.discountPerc1 = 0;
         NonVolatileSetup.discountDays1 = 0;
         NonVolatileSetup.discountPerc2 = 0;
         NonVolatileSetup.discountDays2 = 0;
         NonVolatileSetup.discountDaysReset = 0;
         NonVolatileSetup.discountMaxSel = 0; 
         bsave = 0x80;
         discount_eraseCounter();
         memset(&sDiscountPar, 0xff, sizeof(&sDiscountPar));
    }
    if ( bsave ) saveSettings();
    lpdRecalc();
    
    return K_OK;
}                                               //  edDayMach




/*--------------------------------------------------------------------------
 | edSetLockout:  program edSetLockout
 |                              --------------
 | In:  grp                 group value
 |      grp_index           group index
 | Out: unsigned short      return key
 +--------------------------------------------------------------------------*/

#define VIS_SEL()     displaySelection( &bufferLCD[13], &bufferLCD[14], &bufferLCD[15], 1, i-1, j-1, '_' ); \
                      DispStr( 0, 0, bufferLCD );

unsigned short  edSetLockout( unsigned char grp, unsigned char grp_index )
{
    unsigned char key;
    byte        i, j, n, newIns;
    struct _GROUP_ *p;

    do {
        p = &group[grp_index];
        i = 0;
        j = 0;
        VIS_SEL();        
        do {
                                            // selection
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || 
                 machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 || machineType == MACHINA_MERCHA6 ||
                 machineType == MACHINA_VEILCM )
            {
                if( (key = getKeymenu( K_ESC )) == 0)
                    continue;
                if ( key == K_ESC )
                    return K_OK;                
                if ( key == K_OK )
                    break;                
                if ( key >= K_1 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_1)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_0 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            {
                if( (key = getKeymenu( K_ESC )) == 0)
                    continue;
                if ( key == K_ESC)
                    return K_OK;                
                if ( key == K_OK )
                    break;                
                if ( key >= K_0 && key <= K_9 && (i == 0x00 || i == 0xFF || newIns) )
                {
                    i = (key-K_0)+1;
                    j = 0;
                    newIns = 0;
                }
                else if ( key >= K_1 && key <= K_9 )
                    j = (key-K_0)+1;
            }
            else
            {
                if( (key = getKeymenu( K_ESC )) == 0)
                    continue;
                if ( key == K_ESC )
                    return K_OK;
                if ( key == K_OK )
                    return K_OK;               
                if ( key >= K_A && key <= K_K )
                {
                    i = (key-K_A)+1;
                    if ( newIns )
                        j = 0;
                    newIns = 0;
                }
                if ( key >= K_0 && key <= K_9 )
                {
                    j = (key-K_0)+1;
                    if ( newIns )
                        i = 0;
                    newIns = 0;
                }
            }
            VIS_SEL();
            if (i != 0 && j != 0 && newIns == 0 && usable[i-1][j-1] != 0 )            
            {
                n = (i-1)*10+(j-1);
                BuzzerOn(500);
                break;
            }        
        } while( -1 );  
        p->info[n] = grp;
        saveGroup();
    } while( -1 ); 
}                                               //  edSetLockout

unsigned short  edDisableL1( unsigned char typeVar )
{
    if (edSetLockout( 1, _SEL_LOCKOUT ) == K_OK)
        return edDisableTx( 5, typeVar );
    return FALSE;
}                                               //  edDisableT1

unsigned short  edDisableL2( unsigned char typeVar )
{
    if (edSetLockout( 2, _SEL_LOCKOUT ) == K_OK)
        return edDisableTx( 6, typeVar );
    return FALSE;
}                                               //  edDisableT2

unsigned short  edDisableL3( unsigned char typeVar )
{
    if (edSetLockout( 3, _SEL_LOCKOUT ) == K_OK)
        return edDisableTx( 7, typeVar );
    return FALSE;
}                                               //  edDisableT3

unsigned short  edDisableL4( unsigned char typeVar )
{
    if (edSetLockout( 4, _SEL_LOCKOUT ) == K_OK)
        return edDisableTx( 8, typeVar );
    return FALSE;
}                                               //  edDisableT4

unsigned short  edDisableL5( unsigned char typeVar )
{
    if (edSetLockout( 5, _SEL_LOCKOUT ) == K_OK)
        return edDisableTx( 9, typeVar );
    return FALSE;
}                                               //  edDisableT5

unsigned short  edSetHealth( unsigned char typeVar )
{
    edSetLockout( 1, _SEL_HEALTH );
    return K_ESC;
}                                               //  edSetHealth

unsigned short  edResetHealth( unsigned char typeVar )
{
    if( edToggleY_N( (char *)MENU_6f5, (char *)MENU_6f4 ) )
    {
        memset(&group[_SEL_HEALTH], 0x00, sizeof(group[_SEL_HEALTH]));
        BuzzerOn(500);
        saveGroup();        
    }
    return K_OK;
} 


