/***************************************************************************
 ************************						****************************
 ************************		M O D E M      	****************************
 ************************						****************************
 ***************************************************************************/
#define	__MODEM_C




#include    <stdio.h>
#include    <string.h>
#include    "def.h"
#include    "dex.h"
#include    "ds2341.h"
#include    "display.h"
#include    "funzioni.h"
#include    "keyboard.h"
#include    "main.h"
#include    "menu.h"
#include    "modem.h"
#include    "ram.h"
#include    "timer.h"
#include    "uart.h"
#include    "event.h"
#include    "temperatura.h"

extern  _Credito        card;
extern  _Credito        BillEscrow;

byte        getSelectionParam( byte *_data, byte *_i, byte *_j, byte _reverse, byte machineForm );
byte        memicmp( byte *_str1, char *_str2, byte _len );
void        (*bootEntryPoint)( void );
#if ENABLE_DISCOUNT
void discount( _Credito *tot, byte s_tray, byte s_column );
#endif
#if SLAVE_MACHINE
extern byte SlaveStatus[MAX_MACHINE_NUM];
extern byte sels_map_slaves[MAX_MACHINE_NUM][13];
#endif

#if LED_DIMMING
extern  DWORD   dutyLEDDefault;
#endif

#if MODEM_TRANSFER

struct _MODEM_DATA_ modemData;
byte modemReceive, modemSend;

byte        modemString ( DWORD _timeout, char *_ans, word _size );
byte        modemCommand( char *_cmd, DWORD _timeout, char *_ans, word _size );
byte        modemAnswer ( byte _mode, DWORD _timeout, char *_ans, word _size );

BOOL            testActiveMotor( byte _s_tray, byte _s_column);
BOOL            selectionLocked( byte _tray, byte _column );

extern char LCD2serial[17];

char key_by_serial;


/*--------------------------------------------------------------------------
 | modemInit:   init modem communication
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            modemInit( byte _channel )
{
    memset( &modemData, 0, sizeof(modemData) );
    modemData.comPort = _channel;
    modemReceive = 0;
    modemSend = 0;
    return 0;
}                                               //  modemInit




/*--------------------------------------------------------------------------
 | modemVerify: verify modem presence
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            modemVerify( void )
{
    byte        retry, ch, answ[32];
    
    for ( retry = 2; retry > 0; retry-- )
    {
        while( commGetChar(modemData.comPort,&ch) != COMM_RX_EMPTY )
            Delay(4);
    
        commPutChar(modemData.comPort,'A');
        commPutChar(modemData.comPort,'T');
        commPutChar(modemData.comPort,'E');
        commPutChar(modemData.comPort,'0');
        commPutChar(modemData.comPort,'\x0D');

        if ( modemCommand( NULL, 500, (char *)answ, sizeof(answ) ) == 0 )
            return (modemData.present=1);
    }

    return (modemData.present=0);
}                                               //  modemVerify




/*--------------------------------------------------------------------------
 | modemManager:check modem messages
 |                              --------------
 | In:
 | Out: 0       modem on use
 |      1       modem on hold
 +--------------------------------------------------------------------------*/

byte            modemSMScommand( char *_buf )
{
    char        *p;
    byte        i;
    
    modemData.command = 0;
    
    p = _buf;
    for ( i = 0; i < 255 && *p != '\0'; i++, p++ )
        *p = toupper(*p);
    if ( strstr(_buf,"READ") != NULL )
        modemData.command = 0;
    else if ( strstr(_buf,"SEND_PRICE") != NULL )
        modemData.command = 1;
    else if ( strstr(_buf,"SEND_CONFIG") != NULL )
        modemData.command = 2;
    return 0;
}                                               //  modemSMScommand




/*--------------------------------------------------------------------------
 | modemManager:check modem messages
 |                              --------------
 | In:
 | Out: 0       modem on use
 |      1       modem on hold
 +--------------------------------------------------------------------------*/

byte            modemManager( void )
{
#if MODEM_HTTP
    byte        ch, retry;
    char        *p, buf[32];
    
    if ( modemReceive == 0 )
        return 1;

    while ( commGetChar(modemData.comPort,&ch) == COMM_NO_ERR )
    {
        modemData.lastrx = GetTickCount();
        if ( (modemData.rxi+2) < sizeof(modemData.rxbuf) )
            modemData.rxbuf[modemData.rxi++] = toupper(ch);
        modemData.rxbuf[modemData.rxi] = '\0';

        if ( ch == LF || (ch == CR && modemData.rxi > 2) )
        {
            if ( (p=strstr(modemData.rxbuf,"CMTI")) != NULL )
            {                           // ricevuto un SMS
                if ( (p=strchr(p,',')) == NULL )
                    continue;
                ch = atoi(p+1);
                                        // leggi SMS numero 'ch'
                BuzzerOn(50);
                sprintf( buf, "AT+CMGR=%d\x0d", ch );
                modemCommand( buf, 0, modemData.rxbuf, 0 );//send command
                BuzzerOn(50);
                for ( retry = 3; retry > 0; retry-- )
                {
                    if ( modemString( 4000, modemData.rxbuf, sizeof(modemData.rxbuf) ) != 0 ){//read "REC UNREAD"
                        BuzzerOn(500);
                        continue;
                    }
                    BuzzerOn(50);
                    if ( strstr( modemData.rxbuf, "UNREAD" ) != NULL )
                        break;
                }
                if ( modemString( 2000, modemData.rxbuf, sizeof(modemData.rxbuf) ) == 0 ){//read text
                    modemSMScommand(modemData.rxbuf);
                    BuzzerOn(50);
                    modemString( 1000, modemData.rxbuf, sizeof(modemData.rxbuf) );//read <cr><lf>
                    BuzzerOn(50);
                    modemString( 1000, modemData.rxbuf, sizeof(modemData.rxbuf) );//read ok
                }
                                        // delete SMS numero 'ch'
                BuzzerOn(50);
                sprintf( buf, "AT+CMGD=%d\x0d", ch );
                modemCommand( buf, 4000, modemData.rxbuf, sizeof(modemData.rxbuf) );
                
                modemSend = 1;
            }
        }
    }

    if ( modemData.lastrx != 0 && (GetTickCount()-modemData.lastrx) > 10000 )
    {
        modemReceive = 0;
        modemData.lastrx = 0;
        modemData.rxi = 0;
        return 1;
    }
    return 0;
#else
    return 1;
#endif
}                                               //  modemManager




/*--------------------------------------------------------------------------
 | modemUpdate:   check modem messages
 |                              --------------
 | In:
 | Out: 0       modem on use
 |      1       modem on hold
 +--------------------------------------------------------------------------*/

byte            modemUpdate( void )
{
#if MODEM_HTTP
    if ( modemReceive )
        return 0;
    return 1;
#else
    return 1;
#endif
}                                               //  modemUpdate




/*--------------------------------------------------------------------------
 | modemString:receive string from modem
 |                              --------------
 | In:
 | Out: 0       OK or CONNECT
 |      1       error
 +--------------------------------------------------------------------------*/

byte            modemString( DWORD _timeout, char *_ans, word _size )
{
    DWORD       tm;
    byte        rLen, ch;

    if ( _size == 0 )
        return 0;
    rLen = 0;
    memset( _ans, 0, _size );
    tm = GetTickCount();
    while ( (GetTickCount()-tm) < _timeout )
    {
        if ( commGetChar(modemData.comPort,&ch) == COMM_NO_ERR )
        {
            _timeout = 4000;
            tm = GetTickCount();

            if ( ch == LF )
                continue;
            if ( rLen < _size )
                _ans[rLen++] = toupper(ch);
            if ( ch == CR )
            {
                _ans[rLen] = '\0';
                DispStr( 0, 0, (char *)_ans );
                return 0;
            }
        }
    }

    return 1;
}                                               //  modemString




byte            modemAnswer ( byte _mode, DWORD _timeout, char *_ans, word _size )
{
    DWORD       tm;
    byte        rLen, ch, *p;

    rLen = 0;
    memset( _ans, 0, _size );
    tm = GetTickCount();
    while ( (GetTickCount()-tm) < _timeout )
    {
        if ( commGetChar(modemData.comPort,&ch) == COMM_NO_ERR )
        {
            _timeout = 4000;
            tm = GetTickCount();

            if ( ch == LF || (ch == CR && rLen <= 1) )
                continue;
            if ( rLen < _size )
                _ans[rLen++] = (_mode==2)?ch:(toupper(ch));
            if ( ch == CR )
            {
                _ans[rLen] = '\0';
                if ( _mode )
                    return 0;

                DispStr( 0, 0, (char *)_ans );
                if ( strstr( (char *)_ans, "OK" ) != NULL || 
                     strstr( (char *)_ans, "HOSTIF" ) != NULL || 
                     strstr( (char *)_ans, "ICCID" ) != NULL )
                    return 0;
                if ( strstr( (char *)_ans, "CONNECT" ) != NULL )
                    return 0;
                if ( strstr( (char *)_ans, "ERROR" ) != NULL || strstr( (char *)_ans, "NO CARRIER" ) != NULL )
                {
                    while ( (p=(byte *)strchr((char *)_ans,'\x0D')) != NULL )
                        *p = ' ';
                    _ans[16] = '\0';
                    DispStr( 0, 0, (char *)_ans );
                    Delay(4000);
                    return 2;
                }
            }
        }
    }

    return 1;    
}                                       //  modemAnswer




/*--------------------------------------------------------------------------
 | modemCommand:send command to modem and wait reply with OK or CONNECT
 |                              --------------
 | In:
 | Out: 0       OK or CONNECT
 |      1       error
 +--------------------------------------------------------------------------*/

byte            modemCommand( char *_cmd, DWORD _timeout, char *_ans, word _size )
{
    byte        ch, *p;

    if ( _cmd != NULL )
    {
        while( commGetChar(modemData.comPort,&ch) != COMM_RX_EMPTY )
            Delay(4);
    
        strcpy( (char *)_ans, _cmd );
        if ( (p=(byte *)strchr((char *)_ans,'\x0D')) != NULL )
            *p = ' ';
        _ans[16] = '\0';
        DispStr( 0, 0, (char *)_ans );
    
        BuzzerOn(50);
        while( *_cmd != '\0' )
            commPutChar(modemData.comPort,*_cmd++);
    }

    if ( _size == 0 )
        return 0;
    return modemAnswer ( 0, _timeout, _ans, _size );
}                                               //  modemCommand




/*--------------------------------------------------------------------------
| modemTransfer:    send DEX file to the host
 |                              --------------
 | In:
 | Out: 0       transfer ok
 |      1       modem not available
 +--------------------------------------------------------------------------*/

extern word DEXChars;

char    *modemCommands[] = {
#if FTP
            "ate0\x0d",
            "at+wopen=1\x0d",
            "at+wipcfg=1\x0d",
            "at+wipbr=1,6\x0d",
            "at+wipbr=2,6,11,\"isp.cingular\"\x0d",
            "at+wipbr=4,6,0\x0d",
            "at+wipcreate=4,1,\"66.73.62.161\",21,\"rsr\",\"vending\"\x0d",
            "at+wipfile=4,1,2,\"./filename.txt\"\x0d",        //upload file "filename.txt"
            "at+wipclose=4,1\x0d",

            "at+wipfile=4,1,1,\"./filename.txt\"\x0d",        //download file "filename.txt"
#else
#if MULTITECH
            "ate0\x0d",
            "at+wopen=1\x0d",
            "at+wipcfg=1\x0d",
            "at+wipbr=1,6\x0d",
//            "at+wipbr=2,6,11,\"ibox.tim.it\"\x0d",
            "at+wipbr=2,6,11,\"isp.cingular\"\x0d",
            "at+wipbr=4,6,0\x0d",
            "at+wipcreate=5,1\x0d",
            "at+wipfile=5,1,4,\"http://www.wvtpro.com:8101/dexdata/test.ashx\"\x0d",        //upload file "filename.txt"
            "at+wipclose=5,1\x0d",

            "at+wipfile=5,1,1,\"http://209.254.21.226:302\"\x0d",        //download file "filename.txt"
#else//Enfora
            "ATE0\x0d",
            "AT$HOSTIF=2\x0d",//TCP client
            "AT$PADCMD=1B\x0d",//PAD mode command
            "AT$PADFWD=04\x0d",//FORWARD CHARACTER TO ETX
            "AT$ICCID?x0d",
            "AT$ATDT \"WWW.WVTPRO.COM\",8100\x0d",        //upload file "filename.txt"
            "POST /DataServer/test.ashx HTTP/1.0\x0d",
            "Content-Length: ",

            "+++\x0d",
#endif
#endif
            NULL
};

#ifdef DEX_FILE_TEST
byte dexFile[405+1] =
{
    0x44, 0x58, 0x53, 0x2A, 0x56, 0x45, 0x45, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x2A, 0x56, 
    0x41, 0x2A, 0x56, 0x30, 0x2F, 0x36, 0x2A, 0x31, 0x0D, 0x0A, 0x53, 0x54, 0x2A, 0x30, 0x30, 0x31, 
    0x2A, 0x30, 0x30, 0x30, 0x31, 0x0D, 0x0A, 0x49, 0x44, 0x31, 0x2A, 0x30, 0x30, 0x46, 0x37, 0x38, 
    0x41, 0x36, 0x45, 0x2A, 0x56, 0x45, 0x45, 0x36, 0x34, 0x31, 0x2A, 0x30, 0x31, 0x30, 0x32, 0x2A, 
    0x2A, 0x2A, 0x34, 0x20, 0x37, 0x20, 0x36, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x0D, 0x0A, 
    0x45, 0x41, 0x33, 0x2A, 0x31, 0x30, 0x2A, 0x32, 0x30, 0x30, 0x38, 0x31, 0x32, 0x30, 0x34, 0x2A, 
    0x31, 0x35, 0x35, 0x38, 0x30, 0x31, 0x2A, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
    0x30, 0x2A, 0x32, 0x30, 0x30, 0x38, 0x31, 0x32, 0x30, 0x34, 0x2A, 0x31, 0x35, 0x34, 0x34, 0x35, 
    0x36, 0x0D, 0x0A, 0x56, 0x41, 0x31, 0x2A, 0x30, 0x2A, 0x32, 0x31, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 
    0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 0x31, 0x2A, 0x2A, 0x0D, 0x0A, 
    0x43, 0x41, 0x32, 0x2A, 0x30, 0x2A, 0x32, 0x31, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 
    0x33, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 
    0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 0x34, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 
    0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 0x35, 0x2A, 0x31, 0x2A, 0x31, 0x30, 0x35, 0x0D, 0x0A, 0x43, 
    0x41, 0x36, 0x2A, 0x31, 0x35, 0x2A, 0x31, 0x30, 0x31, 0x0D, 0x0A, 0x43, 0x41, 0x39, 0x2A, 0x30, 
    0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 0x31, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x43, 0x41, 
    0x31, 0x35, 0x2A, 0x30, 0x0D, 0x0A, 0x42, 0x41, 0x31, 0x2A, 0x2A, 0x0D, 0x0A, 0x44, 0x41, 0x31, 
    0x2A, 0x2A, 0x0D, 0x0A, 0x50, 0x41, 0x31, 0x2A, 0x41, 0x31, 0x2A, 0x30, 0x0D, 0x0A, 0x50, 0x41, 
    0x32, 0x2A, 0x31, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x50, 0x41, 0x33, 0x2A, 0x30, 
    0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x50, 0x41, 0x31, 0x2A, 0x42, 0x32, 0x2A, 0x30, 
    0x0D, 0x0A, 0x50, 0x41, 0x32, 0x2A, 0x32, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 
    0x50, 0x41, 0x33, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x0D, 0x0A, 0x45, 0x41, 0x31, 
    0x2A, 0x45, 0x47, 0x53, 0x2A, 0x32, 0x30, 0x30, 0x38, 0x31, 0x32, 0x30, 0x34, 0x2A, 0x31, 0x35, 
    0x35, 0x31, 0x35, 0x33, 0x0D, 0x0A, 0x47, 0x38, 0x35, 0x2A, 0x44, 0x30, 0x36, 0x30, 0x0D, 0x0A, 
    0x53, 0x45, 0x2A, 0x32, 0x34, 0x2A, 0x30, 0x30, 0x30, 0x31, 0x0D, 0x0A, 0x44, 0x58, 0x45, 0x2A, 
    0x31, 0x2A, 0x31, 0x0D, 0x0A, 0x00
} ;
#endif

byte            sendAndRetry( char *_msg, char *_ans, word _size )
{
    byte        retry, oldbuf[LCDCOL+1];

    Delay(500);
    for ( retry = 2; retry > 0; retry-- )
    {
        if ( modemCommand( _msg, 10000, _ans, _size ) == 0 )
            break;
        BuzzerOn(2000);
    }
    if ( retry == 0 )
    {
        memcpy( oldbuf, bufferLCD, LCDCOL+1 );
        memset( &oldbuf[LCDCOL-3], '?', 3 );
        for ( retry = 0; retry < 3; retry++ )
        {
            DispStr( 0, 0, " ERROR MODEM INI" );
            Delay(1000);
            DispStr( 0, 0, (char *)oldbuf );
            Delay(500);
            BuzzerOn(1000);
        }
        return 1;
    }

    return 0;
}

byte            modemTransfer( char *_fname )
{
#if MULTITECH
    byte        retry, ncmd, oldbuf[LCDCOL+1];
#if 0
    byte        *p;
#endif

    BuzzerOn(50);
    for ( ncmd = 0; ncmd < 9; ncmd++ )
    {
        Delay(500);
        for ( retry = 2; retry > 0; retry-- )
        {
            if ( modemCommand( modemCommands[ncmd], (ncmd==0)?4000:10000 ) == 0 )
                break;
            BuzzerOn(1000);
        }
        if ( retry == 0 )
        {
            memcpy( oldbuf, bufferLCD, LCDCOL+1 );
            memset( &oldbuf[LCDCOL-3], '?', 3 );
            for ( retry = 0; retry < 3; retry++ )
            {
                if ( ncmd == 0 )
                    DispStr( 0, 0, " NO MODEM PRESEN" );
                else
                    DispStr( 0, 0, " ERROR MODEM INI" );
                Delay(1000);
                DispStr( 0, 0, (char *)oldbuf );
                Delay(500);
                BuzzerOn(1000);
            }
//            return 1;
        }

        BuzzerOn(50);
        if ( ncmd == 7 ) 
        {                               // connected, file transfer
#ifdef DEX_FILE_TEST
            for( p = dexFile; *p != '\0'; p++ )
                commPutChar(modemData.comPort,*p);
#else
            sendDEXfile(modemData.comPort);
#endif
            modemCommand( "\x03", 6000 );//send ETX
            BuzzerOn(50);
        }
    }
#else//Enfora
    
    byte        ncmd;
    char        *p, answ[256], mach_id[32], i;
    DWORD       timeout;

    if ( !modemData.present )
        return 0;
    
    modemReceive = 1;

    if ( sendAndRetry( "ATE0\x0d", answ, sizeof(answ) ) != 0 )              return 1;
    if ( sendAndRetry( "AT$HOSTIF?\x0d", answ, sizeof(answ) ) != 0 )        return 1;
    ncmd = 0;
    if ( (p=strstr(answ,"HOSTIF")) != NULL )
        ncmd = atoi(p+7);
    if ( ncmd != 2 )
    {                                   // set module
        if ( sendAndRetry( "AT$HOSTIF=2\x0d", answ, sizeof(answ) ) != 0 )   return 1;
        if ( sendAndRetry( "AT$PADCMD=1B\x0d", answ, sizeof(answ) ) != 0 )  return 1;
        if ( sendAndRetry( "AT$PADFWD=04\x0d", answ, sizeof(answ) ) != 0 )  return 1;
        if ( sendAndRetry( "AT$ICCID?\x0d", answ, sizeof(answ) ) != 0 )     return 1;
    }
                                        // send file
#if MODEM_NEW_SRVR
    if ( sendAndRetry( "ATDT \"WWW.WVTPROHANDLER.COM\",8100\x0d", answ, sizeof(answ) ) != 0 )
        return 1;
#else
    if ( sendAndRetry( "ATDT \"WWW.WVTPRO.COM\",8100\x0d", answ, sizeof(answ) ) != 0 )
        return 1;
#endif
    BuzzerOn(50);

    modemCommand( NULL, 4000, answ, sizeof(answ) );//CONNECT ?
    BuzzerOn(50);
    Delay(1000);

    if ( modemData.command == 1 || modemData.command == 2 )
    {
        DispStr( 0, 0, " SEND POST CMD  " );
        if ( modemData.command == 1 )
            sprintf( &answ[64], "POST /DataServer/iniprices.ashx HTTP/1.0\x0d\x0a" );
        else
            sprintf( &answ[64], "POST /DataServer/iniconfig.ashx HTTP/1.0\x0d\x0a" );
        modemCommand( &answ[64], 0, answ, 0 );
        sprintf( mach_id, "VEI%s-%s\x0d\x0a", &SerialID[8], MachineTypeID );

        sprintf( &answ[64], "Content-Length: %d\x0d\x0a", strlen(mach_id)+2 );
        modemCommand( &answ[64], 0, answ, 0 );
        modemCommand( "\x0d\x0a", 0, answ, 0 );

        modemCommand( mach_id, 0, answ, 0 );
        modemCommand( "\x0d\x0a", 0, answ, 0 );

//        Delay(9100);

        for ( timeout = GetTickCount(); (GetTickCount()-timeout) < 20000; ) 
        {
            if ( modemAnswer ( 2, 1000, answ, sizeof(answ) ) == 0 )
            {
                DispStr( 0, 0, answ );
                if ( strstr(answ,"NO CARRIER") != NULL )
                    break;
                else
                    loadConfigString( (byte *)answ, 1, machineType, TRUE );
            }
        }

    }
    else
    {
        
        DispStr( 0, 0, " CALCULATE DEX  " );
        sendDEXfile(0xFF);// verify file length
        if ( DEXChars == 0 )
            DEXChars = 7;
        DispStr( 0, 0, " SEND POST CMD  " );
#if MODEM_NEW_SRVR
        sprintf( &answ[64], "POST /DataServer/upload.ashx HTTP/1.0\x0d\x0a" );
#else
        sprintf( &answ[64], "POST /DataServer/%s.ashx HTTP/1.0\x0d\x0a", _fname );
#endif
        modemCommand( &answ[64], 0, answ, 0 );
        sprintf( &answ[64], "Content-Length: %d\x0d\x0a", DEXChars+4 );
        modemCommand( &answ[64], 0, answ, 0 );
        modemCommand( "\x0d\x0a", 0, answ, 0 );
        
        DispStr( 0, 0, " SEND DEX FILE  " );
        if ( DEXChars != 7 )
            sendDEXfile(modemData.comPort);
        else
            modemCommand( "hello\x0d\x0a", 0, answ, 0 );
        DispStr( 0, 0, " FINISH         " );
        modemCommand( "\x0d\x0a", 0, answ, 0 );
        modemCommand( "\x0d\x0a", 0, answ, 0 );
    
        for ( i = 20; i > 0; i-- )
        {
            if ( modemAnswer ( 1, 1000, answ, sizeof(answ) ) == 0 )
            {
                DispStr( 0, 0, answ );
                Delay(500);
                if ( i > 4 )
                    i = 4;
            }
        }
    }
    
    Delay(2100);
    BuzzerOn(50);
    modemCommand( "+++", 4000, answ, sizeof(answ) );
    BuzzerOn(50);

#endif
    
#if FTP
    DispStr( 0, 0, " MODEM FTP OK   " );
#else
    DispStr( 0, 0, " MODEM HTTP OK  " );
#endif

    modemReceive = 0;
    modemData.lastrx = 0;
    modemData.rxi = 0;
    Delay(4000);

    return 0;
}                                               //  modemTransfer

#endif


#if MIND_UCB_COMM4

struct _HOST_DATA_  hostData;


/*--------------------------------------------------------------------------
 | hostInit:    init modem communication
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            hostInit( byte _channel )
{
    memset( &hostData, 0, sizeof(hostData) );
    hostData.comPort = _channel;
    return 0;
}                                               //  hostInit




/*--------------------------------------------------------------------------
 | hostManager: check host messages
 |                              --------------
 | In:
 | Out: 0       host on use
 |      1       host on hold
 +--------------------------------------------------------------------------*/
extern byte forceEscrow;
extern const char  VMCManufacturer[];
extern char  VMCSerial[13];
extern char  VMCModel[13];
extern char  VMCSwRevision[3];
byte  HostCashless = 0;
byte  HostCashless_machine = 0, HostCashless_tray = 0xFF, HostCashless_column = 0xFF;

extern struct S_EVENT sEvent[], *pEventW;
struct S_EVENT *pEventHostR = sEvent;   // 20.06.2014

byte            hostManager( void )
{
    byte        ch, i, j, len;
    char        selID[12], *pCh, *pSrc;
    byte        idx, mask, k;
    long        ll;

    while ( commGetChar(hostData.comPort,&ch) == COMM_NO_ERR )
    {
        hostData.lastrx = GetTickCount();
        if ( ch == STX )
            hostData.rxi = 0;
        if ( (hostData.rxi+2) < sizeof(hostData.rxbuf) )
            hostData.rxbuf[hostData.rxi++] = toupper(ch);
        hostData.rxbuf[hostData.rxi] = '\0';
#if SERIAL_PROTOCOL_DEB                     
        if ( (ch == LF) && hostData.rxi > 2 )          
        {
            Delay(5);
#else            
        if ( (ch == LF || ch == CR) && hostData.rxi > 2 ) 
        {
#endif            
            len = hostData.rxi;
            hostData.rxi = 0;
            /* PRICE ? */
            if ( memicmp((byte *)&hostData.rxbuf[1],"price?",6) == 0 )
            {                           // ricevuto un comando di lettura status
                hostData.present = 1;
                if ( getSelectionParam((byte *)&hostData.rxbuf[7],&i,&j,0, MACHINA_VEIDOOR) == 0 )
                {
                    hostData.tray = i;
                    hostData.column = j;
                    hostData.price = amount[slave_mac-1][i][j];
                    hostData.discounted = hostData.price;
#if ENABLE_DISCOUNT
                    discount( &hostData.discounted, i, j );
#endif
                    hostStatus(HOST_READ_PRICE);
                }
                else
                    hostStatus(HOST_COMMAND_UNKNOWN);
            }
            /* STATUS? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"status?",7) == 0 )
            {                           // ricevuto un comando di lettura status
                hostData.present = 1;
                hostStatus(HOST_READ_STATUS);
            }
            /* SELL; */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"sell;",5) == 0 )
            {                           // ricevuto un comando di selezione
                if ( verifySelectionRunning() == TRUE )
                    return 0;
                hostData.present = 1;
                if ( getSelectionParam((byte *)&hostData.rxbuf[6],&i,&j,0, MACHINA_VEIDOOR) == 0 )
                {
                    hostData.tray = i;
                    hostData.column = j;
                    hostData.select = 1;
                    hostData.cashlessprice = 0;
                    if( ( hostData.price = cpyUint32Param( (byte *)&hostData.rxbuf[7], 0, 99999 ) ) == 0xFFFFFFFF )
                    {
                        if ( slave_mac <= MAX_MACHINE_NUM ) 
                            hostData.price = amount[slave_mac-1][i][j];
                        else
                            hostData.price = 0;
                    }
                    else
                    {
                        pCh = strchr( &hostData.rxbuf[7], ';' );  // skip price
                        pCh++;
                        if( ( pCh = (char *)strchr( pCh, ';' )) != NULL )
                        {
                            if( ( hostData.cashlessprice = cpyUint32Param( (byte*)pCh, 0, 99999 ) ) == 0xFFFFFFFF )
                                hostData.cashlessprice = 0;
                        }
                    }
                    HostCashless = 0;   // reset any Externl cashless pending request
                }
                else
                    hostStatus(HOST_COMMAND_UNKNOWN);
            }
#if ENABLE_DISCOUNT
            /* DISCOUNT? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"discount?",9) == 0 )
            {                           // ricevuto un comando lista sconti
                hostData.present = 1;
                //
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "discount" );
                for( i = 0; i < MAXTRAY; i++)
                {
                    for( j = 0; j < MAXCOLUMN; j++)
                    {
                        if( valid_discount_selection( i, j ) == TRUE )
                        {
                            if ( selection2ASCII((char *)selID, 0, i, j, 0, MACHINA_VEIDOOR ) != NULL )
                            {
                                commPutChar( hostData.comPort, ';' );
                                commPutStr ( hostData.comPort, (byte*)selID );
                            }
                        }
                    }
                }
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
#endif
            /* SELS? */ /* max lengh of the answer 1023 bytes, which is the serial buffer size */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"sels?",5) == 0 )
            {                           // ricevuto un comando lista motori collegati 07.02.2012
                hostData.present = 1;
                //
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "sels" );
                for( i = 0; i < MAXTRAY; i++)
                {
                    for( j = 0; j < MAXCOLUMN; j++)
                    {
                        if( testActiveMotor(i,j) == TRUE )
                        {
                            if ( checkCoupling(i, j) == FALSE && checkNotConsecutiveCoupling(i, j, 0) == FALSE )    
                            {    
                                if ( selection2ASCII((char *)selID, 0,i, j, 0, MACHINA_VEIDOOR) != NULL )
                                {
                                    commPutChar( hostData.comPort, ';' );
                                    commPutStr ( hostData.comPort, (byte*)selID );
                                }
                            }
                        }
                    }
                }
#if SLAVE_MACHINE
                for( k = 1; k < MAX_MACHINE_NUM; k++)
                {
                    if( SlaveStatus[k] != 0 )
                    {
                        idx = 0; mask = 0x01;
                        for( i = 0; i < MAXTRAY; i++)
                        {
                            for( j = 0; j < MAXCOLUMN; j++)
                            {
                                if( sels_map_slaves[k][idx] & mask )
                                {
                                    if ( selection2ASCII((char *)selID, k,i, j, 0, MACHINA_VEIDOOR) != NULL )
                                    {
                                        commPutChar( hostData.comPort, ';' );
                                        commPutStr ( hostData.comPort, (byte*)selID );                                        
                                    }
                                    
                                }
                                if( mask & 0x80 ) 
                                {
                                    mask = 0x01;
                                    idx++;
                                }
                                else
                                    mask <<= 1;                                
                            }
                        }
                    }
                }
#endif
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
            /* DISABLED? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"disabled?",9) == 0 )
            {                           // ricevuto un comando lista selezioni disabilitate 05.03.2012
                hostData.present = 1;
                //
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "disabled" );
                for( i = 0; i < MAXTRAY; i++)
                {
                    for( j = 0; j < MAXCOLUMN; j++)
                    {
                        if( testActiveMotor(i,j) == TRUE && selectionLocked(i,j) == TRUE )
                        {
                            if ( selection2ASCII((char *)selID, 0, i, j, 0, MACHINA_VEIDOOR) != NULL )
                            {
                                commPutChar( hostData.comPort, ';' );
                                commPutStr ( hostData.comPort, (byte*)selID );
                            }
                        }
                    }
                }
                commPutChar( hostData.comPort, ';' );                
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
            /* ESCROW */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"escrow",6) == 0 )
            {                           // ricevuto un comando Refund 05.03.2012
                if ( verifySelectionRunning() == TRUE )
                    return 0;                
                hostData.present = 1;              
                commPutChar( hostData.comPort, STX );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
                if(  machineType == MACHINA_MERCHA6 ) { // check is a selection is running !!
                    hostData.tray = 7;                  // the motor will activare the coin level
                    hostData.column = 0;                // the ESCTOW EVENT will be activaed by the Coin Changer
                    hostData.select = 1;
                    hostData.price = 0;
                    slave_mac = 1;
                    enDrop[7][0] = FALLSENSOR_OFF;     // drop sensor MUST be inactive                     
                    forceEscrow = 1;
                }
                else {
                    InsertEvent( EVENT_ESCROW, 0 );     // force escrow
                }

            }
            /* FUNDS? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"funds?",6) == 0 )
            {                           // ricevuto un comando cashvelue 05.03.2012
                hostData.present = 1;
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "funds;" );
                commPutDecimal( hostData.comPort, (cash+BillEscrow), 5 );
                commPutChar( hostData.comPort, ';' );
                commPutDecimal( hostData.comPort, card, 5 );
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
            /* READ? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"read?",5) == 0 )
            {                           // send full configuration file 08.03.2012
                hostData.present = 1;
                if ( vendingCycle() )
                    hostStatus(HOST_READ_STATUS);
                else
                {
                    commPutChar( hostData.comPort, STX );
                    commPutStr ( hostData.comPort, "read;" );
                    commPutChar( hostData.comPort, CR );
                    commPutChar( hostData.comPort, LF );
                    sendSettings(TRUE,NULL,MACHINA_VEIDOOR);
                    hostPutChar( ETX ); /*commPutChar non fa retry*/
/*                  commPutChar( hostData.comPort, STX );
                    commPutStr ( hostData.comPort, "end;" );
                    commPutChar( hostData.comPort, CR );
                    commPutChar( hostData.comPort, LF );    12.10.2012 */
                }
            }
#if LED_DIMMING
            /* LED: */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"LED;",4) == 0 )
            {                           // ricevuto un comando LED; 09.04.2012
                hostData.present = 1;
                dutyLEDDefault = setLedDimming( cpyUint32Param( (byte *)&hostData.rxbuf[4], 0, 100 ) );               
                commPutChar( hostData.comPort, STX );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
#endif
            /* DEX? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"DEX?",4) == 0 )
            {                           // ricevuto un comando DEX? 09.04.2012
                hostData.present = 1;                
                commPutChar( hostData.comPort, STX );
		        sendDEXfile( hostData.comPort );
            }
            /* REV? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"REV?",4) == 0 )
            {                           // ricevuto un comando REV? 09.04.2012
                hostData.present = 1;             
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "rev;" );
                commPutStr ( hostData.comPort, (byte *)MachineTypeID );
                commPutChar( hostData.comPort, '-' );
                commPutChar( hostData.comPort, fwRelease[0] );
                commPutChar( hostData.comPort, fwRelease[1] );
                commPutChar( hostData.comPort, fwRelease[2] );
                commPutChar( hostData.comPort, fwRelease[3] );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
            /* MAXCREDIT */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"MAXCREDIT;",10) == 0 )
            {                           // ricevuto un comando MAXCREDIT 09.30.2012
                maxCredit = cpyUint32Param( (byte *)&hostData.rxbuf[10], 0, 65500 );
                if( NonVolatileSetup.maxCreditFromPC != maxCredit )
                {
                    NonVolatileSetup.maxCreditFromPC = maxCredit;
                    saveSettings();
                }                
		if( maxCredit < maxPrice ) maxCredit = maxPrice;

                if( ( ll = cpyUint32Param( (byte *)&hostData.rxbuf[11], 0, 65500 ) ) == 0xFFFFFFFF )
                    maxBills = 0;
                else
                    maxBills = (T_AMOUNT)ll;
                
                commPutChar( hostData.comPort, STX );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
#if SLAVE_MACHINE
            /* SLAVES? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"SLAVES?",7) == 0 )
            {                           // ricevuto un comando SLAVES? 13.01.20123
                hostData.present = 1;                
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "slaves;" );
                commPutChar( hostData.comPort, ( SlaveStatus[0] == 0)?' ':'1' );
                commPutChar( hostData.comPort, ( SlaveStatus[1] == 0)?'0':'1' );
                commPutChar( hostData.comPort, ( SlaveStatus[2] == 0)?'0':'1' );
                commPutChar( hostData.comPort, ( SlaveStatus[3] == 0)?'0':'1' );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }
#endif
            /* KEY; */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"KEY;",4) == 0 )
            {                           // ricevuto un comando KEY? 24.09.2013
                getKeyParam(&hostData.rxbuf[5]);
                    
                hostData.present = 1;             
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "display;" );
                commPutStr ( hostData.comPort, (byte*)LCD2serial );
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );
            }   
            /* LOAD? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"LOAD?",5) == 0 )
            {                           // ricevuto un comando LOAD? 03.10.2013
                NonVolatileSetup.downloadStatus = FW_DWN_REQ;
                saveSettings();
                __disable_interrupt();
                bootEntryPoint = (void (*)())BOOTSTART;
                (*bootEntryPoint)();                
            }   
            /* EVENTS? */
            else if ( memicmp((byte *)&hostData.rxbuf[1],"EVENTS?",7) == 0 )
            {                           // ricevuto un comando EVENTS? 20.06.2014
                commPutChar( hostData.comPort, STX );
                commPutStr ( hostData.comPort, "events;" );
                while ( pEventHostR != pEventW )
                {
                    i = pEventHostR->event;
                    commPutDecimal( hostData.comPort, i, 2 );
                    commPutChar( hostData.comPort, 'v' );
                    ll = pEventHostR->val;
                    commPutDecimal( hostData.comPort, ll, 5 );
                    commPutChar( hostData.comPort, ';' );
                    if ( ++pEventHostR >= &sEvent[16] )   pEventHostR = sEvent;
                }
                commPutChar( hostData.comPort, CR );
                commPutChar( hostData.comPort, LF );                
            }   
#define REMOTE_CASHLESS
#ifdef REMOTE_CASHLESS
            else if ( memicmp((byte *)&hostData.rxbuf[1],"CASHLESS;",9) == 0 )
            {                           // ricevuto un comando CASHLESS
                if( len >= (10+3+12+12+2+8) )
                {
                    pSrc =&(hostData.rxbuf[10]);
                    pCh = CashlessManufacturer_Code( 2 ); i = 0;
                      while( i < 3 && *pSrc != CR && *pSrc != LF )    { *pCh++ = *pSrc++; i++;  }
                    
                    pCh = CashlessSerial_Number( 2 ); i = 0;
                      while( i < 12 && *pSrc != CR && *pSrc != LF )   { *pCh++ = *pSrc++; i++; }
                    
                    pCh = CashlessTuning_Revision( 2 ); i = 0;
                      while( i < 12 && *pSrc != CR && *pSrc != LF )   { *pCh++ = *pSrc++; i++; }
                    /*
                    unsigned short  *CashlessSoftware_Version( 2 )
                    while( *pSrc != CR && *pSrc != LF )     { *pCh++ = *pSrc++; i++; }
                        
                    char CL_Optional_Features[8];
                    while( *pSrc != CR && *pSrc != LF )     { *pCh++ = *pSrc++; i++; }
                    */ 
                    // transmitt  ... attenzione tutti i dati debbono essere ASCII !!!
                    commPutChar( hostData.comPort, STX );
                    commPutStr ( hostData.comPort, "VMC;" );
                    commPutStr ( hostData.comPort, (byte *)VMCManufacturer );
                    commPutStr ( hostData.comPort, (byte *)VMCSerial );
                    commPutStr ( hostData.comPort, (byte *)VMCModel );
                    memcpy( selID, VMCSwRevision, 2 ); selID[2] = 0x00;
                    commPutStr ( hostData.comPort, (byte*)selID );
                    commPutDecimal( hostData.comPort, maxPrice, 6 );
                    commPutChar( hostData.comPort, CR );
                    commPutChar( hostData.comPort, LF );
                    HostCashless = 1;
                }
                else {
                    commPutChar( hostData.comPort, STX );
                    commPutStr ( hostData.comPort, "VMC;" );
                    commPutChar( hostData.comPort, CR );
                    commPutChar( hostData.comPort, LF );
                    HostCashless = 0;
                }
            }
#endif
            /* any other comand */
            else
            {
                if ( loadConfigString( (byte *)&hostData.rxbuf[1], 1, MACHINA_VEIDOOR, TRUE ) == 0 )
                {
                                        // risposta valore di una variabile di configurazione 05.03.2012
                    if( hostData.rxbuf[1] != 0x00 )
                        commPutStr ( hostData.comPort, (byte *)hostData.rxbuf ); 
                    hostData.present = 1;
                    hostStatus(HOST_COMMAND_OK);
                }
                else
                    hostStatus(HOST_COMMAND_UNKNOWN);
            }
        }
    }

    if ( hostData.lastrx != 0 && (GetTickCount()-hostData.lastrx) > 10000 )
    {
        hostData.lastrx = 0;
        hostData.rxi = 0;
        return 1;
    }
    return 0;
}                                               //  hostManager


byte  cheskHostCashless( byte _machine, byte _tray, byte _column )
{
      HostCashless_machine = _machine;
      HostCashless_tray = _tray;
      HostCashless_column = _column;
      return ( HostCashless );
}

/*--------------------------------------------------------------------------
 | hostStatus:  check host messages
 |                              --------------
 | In:
 | Out: 0       host on use
 |      1       host on hold
 +--------------------------------------------------------------------------*/
extern DWORD          GestioneMenuForcedByHost;
extern byte           exitMenuForcedByHost;

byte            hostStatus( byte _stat )
{
    byte        f, stat;
    
    f = 0;
    stat = 0xFF;
    switch ( _stat )
    {
        case HOST_STATUS_READY:     hostData.status = 0;                        break;
        case HOST_EXACT_CHANGE:     hostData.status = 1;                        break;
//        case HOST_SELECTION_START:  hostData.status = 2;    f = 1;  stat = '2'; break;
        case HOST_SELECTION_START:                          f = 1;  stat = '2'; break;
        case HOST_SELECTION_OK:                             f = 1;  stat = '3'; break;
        case HOST_SELECTION_FAILED:                         f = 1;  stat = '4'; break;
        case HOST_SELECTION_LOCKED:                         f = 1;  stat = '5'; break;
        case HOST_SELECTION_UNAVAIL:                        f = 1;  stat = '6'; break;
        case HOST_SELECTION_COST:                           f = 1;  stat = '7'; break;
        case HOST_DOOR_OPEN:        hostData.door = 1;                          break;
        case HOST_PROGRAMMING:      hostData.status = 8;                        break;
        case HOST_DOOR_CLOSE:       hostData.door = 0;                          break;
        case HOST_COMMAND_UNKNOWN:                          f = 1;  stat = 'U'; break;
        case HOST_COMMAND_OK:                               f = 1;  stat = 'K'; break;
        default:                                            f = 1;              break;
    }
  
    if ( hostData.present == 0 )
        return 1;
    
    if ( f )
    {
        if ( stat == 0xFF )
        {
            stat = '0'+hostData.status;
            if ( hostData.status == 0 && ChangerExactChange() != 0 )
                stat = '1';             // send exact change condition
        }
        commPutChar( hostData.comPort, STX );
        if ( _stat == HOST_READ_PRICE )
        {
            commPutStr ( hostData.comPort, "price;" );
            commPutDecimal( hostData.comPort, hostData.price, 5 );
            commPutChar( hostData.comPort, ';' );
            commPutDecimal( hostData.comPort, hostData.discounted, 5 );
            commPutChar( hostData.comPort, ';' );
        }
        else
            commPutStr ( hostData.comPort, "status;" );
        if ( stat == 'K' )
            commPutChar( hostData.comPort, 'O' );
        else
        {
            if( doorOpen() )
                commPutChar( hostData.comPort, '1' );
            else
                commPutChar( hostData.comPort, '0' );
        }
        commPutChar( hostData.comPort, stat );
        commPutChar( hostData.comPort, ';' );
        if ( hostData.money == ID_TOKEN )
            commPutStr ( hostData.comPort, "99999" );
        else
        {
            commPutDecimal( hostData.comPort, hostData.money, 5 );
        }
        if ( _stat != HOST_READ_PRICE )
        {
            if( !enTEMP( 0 ) )
            {
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, 'F' );
                commPutChar( hostData.comPort, '0'+((Temperatura/10000)%10) );
                commPutChar( hostData.comPort, '0'+((Temperatura/ 1000)%10) );
                commPutChar( hostData.comPort, '0'+((Temperatura/  100)%10) );
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, 'H' );
                commPutChar( hostData.comPort, '0'+HealthProblem );
            }
            commPutChar( hostData.comPort, ';' );
            commPutChar( hostData.comPort, 'S' );
            commPutChar( hostData.comPort, '0'+deltaProxSensor );
            deltaProxSensor = 0;
            if( HostCashless )
            {
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, 'R' );
                if( HostCashless_tray != 0xFF && HostCashless_column != 0xFF )
                {
                    commPutChar( hostData.comPort, '1' );
                    commPutChar( hostData.comPort, '1'+HostCashless_tray );
                    commPutChar( hostData.comPort, '0'+HostCashless_column );
                }
                else
                {
                    commPutChar( hostData.comPort, '_' );
                    commPutChar( hostData.comPort, '_' );
                    commPutChar( hostData.comPort, '_' );
                }
            }
            if( GestioneMenuForcedByHost )
            {
                commPutChar( hostData.comPort, ';' );
                commPutChar( hostData.comPort, 'P' );
            }
        }
        commPutChar( hostData.comPort, CR );
        commPutChar( hostData.comPort, LF );
    }

    return 0;
}                                               //  hostStatus




/*--------------------------------------------------------------------------
 | hostSelection:simulate selection from host
 |                              --------------
 | In:
 | Out: 0       selection available
 |      1       nothing to do
 +--------------------------------------------------------------------------*/

byte            hostSelection( byte *_machine, byte *_tray, byte *_column, _Credito *_tot )
{
    if ( hostData.select == 1 )
    {
#if SLAVE_MACHINE
        *_machine = slave_mac;
#endif
        if ( machineType == MACHINA_AP123 )
            *_machine = 1;
        *_tray = hostData.tray;
        *_column = hostData.column;
        *_tot = hostData.price;
        hostData.select = 0;
        return 0;
    }
    
    return 1;
}                                               //  hostSelection



void            hostMoney( _Credito _val )
{
    hostData.money = _val;
}


#endif
