/***************************************************************************
 ************************						****************************
 ************************		R A M			****************************
 ************************						****************************
 ***************************************************************************/
#ifndef	__RAM_H
#define	__RAM_H

#include	"def.h"
#ifdef	typeo
#undef	typeo
#endif
#ifdef	ALLOCA_MEMORIA
#define	typeo
#else
#define	typeo	extern
#endif
#include "fat.h"



//                   1234567890123456
#define MEM_MARKER  "RSR641 v. 1.0.0 "

#define N_K_MAX     16
#define N_AN_MAX    10




/*************************************************************************/
/*************************************************************************/

typeo   byte    mmdStatus;              // ==0: display available
                                        // !=0: display not available

typeo   byte    mmdPhotoErr;            // consecutive photo write error

typeo   byte    mmcPresent;             // TRUE: mmc/sd in slot
                                        // FALSE: mmc/sd not available

typeo   DWORD   testMode;

typeo   byte    testVend;

typeo   byte    nPasscode;

typeo	struct	_AD {
	byte        ch;				        // canale su cui effettuare la conversione
	word        conv[8];			    // valore convertito canali A/D
} AD;
#define AD_I_MOTORS     0
#define AD_MON_VH       1
#define AD_2            2

typeo   byte    INPi;

#define N_ICAMP 128
typeo struct {
    byte        iCamp;
    sword       camp[N_ICAMP];
    sdword      totCamp;
} current[2]; ////// TEST39

typeo struct _keyTimer {
    byte        _1ms;
    byte        _32ms;
} keyTimer;

typeo struct _ADkey {
    byte        iMax;
    dword       totMax;
    word        valMax[128];

    byte        lastKey;
    word        nCamp, maxAn, lastAn;
} ADkey;


typeo   unsigned int    inImage[4];     // nota: usato solo il byte basso
typeo   word    outImage[4];            // nota: usato solo il byte basso
#define OUT_SG8_SG15    1
#define OUT_SG0_SG7     2
#define OUT_AN0_AN7     3
#define OUT_COIN_BILL   0

typeo   byte    testMotorHoming, testMotorPresence, motorTurns;




        /*+-------------------------------------+*/
        /*| dati macchina                       |*/
        /*+-------------------------------------+*/

typeo   byte    machineType;            // be carefull, used as array index...
#define MACHINA_AP113     0
#define MACHINA_NAT147    1
#define MACHINA_ROWE5900  2
#define MACHINA_ROWE6800  3
#define MACHINA_NAT157    4
#define MACHINA_AP7000    5
#define MACHINA_LCM123    6
#define MACHINA_AP123     7
#define MACHINA_VEIDOOR   8
#define MACHINA_NAT145    9
#define MACHINA_AMS39     10
#define MACHINA_VEI147    11
#define MACHINA_USIGVC2   12
#define MACHINA_MERCHA6   13
#define MACHINA_VEILCM    14
#define TOTAL_MACHINE     15
#define MACHINA_UNKNOWN   255
typeo   byte    SubMachineType;          // be carefull, used as array index...
typeo   byte    VED1000_en;
#define SUB_DIXIE501E     TOTAL_MACHINE+1
#define MACHINA_VED1000   TOTAL_MACHINE+2

#define MAX_MACHINE_NUM    4  
#define MAXGROUP    10                  // massima dimensione dipende da flash ( vedi main.c funzione saveAmount )
#define MAXTRAY     10
#define MAXCOLUMN   10
#define MAXselGROUP 100
#define MAXEntriesTimeDisable 25        // deve essere inferiore a MAXselGROUP
#define MAXEntriesGroupSel 5            // deve essere inferiore a MAXselGROUP

#define MAXTIMEDISABLE  5
#define MAXGROUPNUM     3
#define MAXSELECTIONPRICE   65499
                                        // row/column flag enable
typeo   byte    usable[MAXTRAY][MAXCOLUMN];
                                        // row/column selection counter error, other fails
typeo   struct _FAILS_ {
    byte    nFails[MAXTRAY][MAXCOLUMN];
    byte    HealthProblem;
    // 256-201 bytes for futire Failures to be stored in nonvolatile memory
}nF;
                                        // row/column selection enable drop
typeo   byte    enDrop[MAXTRAY][MAXCOLUMN];

// group of price

#define	_GROUP_SEL				    0
#define	_SEL_UPFRONT				1
#define	_SEL_LOCKOUT				2
#define	_SEL_HEALTH 				3
#define	_SEL_TIMEFRAMES				4

typeo   struct _GROUP_ {
    char    info[MAXselGROUP];
} group[MAXGROUP];                        // group of price

typeo   T_AMOUNT grp_price[MAXselGROUP];

typeo   byte    idxGroup[MAXselGROUP];     // index of active selection

                                        // selection amount
typeo   T_AMOUNT amount[MAX_MACHINE_NUM][MAXTRAY][MAXCOLUMN], maxPrice, minPrice, localmaxprice[MAX_MACHINE_NUM], localminprice[MAX_MACHINE_NUM];
typeo   T_AMOUNT maxCredit;             // max accepted credit 30.09.2012
typeo   T_AMOUNT maxBills;              // max accepted bills 18.12.2014

#define MAXTIMEFRAMES   40

typeo   struct _TIMEFRAMES_ {
    byte        group;
    byte        weekDay;
    struct _TIMEFRAMES_TIME_ {
        byte        hour;
        byte        min;
    } disable;
    struct _TIMEFRAMES_TIME_ enable;
} timeFrames[MAXTIMEFRAMES];            // selection disable timeframes


typeo   struct _TIMEDISABLE_ {
    struct _TIMEDISABLE_TIME_ {
        byte        weekDay;
#define WEEKDAYS    7
#define EVERYDAYS   8
        byte        hour;
        byte        min;
        byte        am_pm;
    } disable;
    struct _TIMEDISABLE_TIME_ enable;
} timeDisable[2*MAXTIMEDISABLE];        // machine(tot=5,idx=0..4) disable time frames + ...
                                        // ... selection(tot=5,idx=5..9) disable timeframes

                                        // n. of decimal places
typeo   byte    posVirgola;



#define MSG_ADV_LEN     50
#define ASSET_ID_LEN    12
#define SETTINGS_ID_LEN 8

typeo   struct _SETUP_ {
    dword   passcode;                   // programming passcode
    dword   fallSensorMode;             // fall sensor function mode
    dword   contrasto_lcd;              // LCD contrast value
    byte    setEscrow;                  // set escrow
    byte    setSingleVend;              // set single vending

    struct {
        dword   tout;                   // advertising timeout
        byte    speed;                  // message shift speed
        byte    msg[MSG_ADV_LEN+1];     // advertaising message
    } adv;

    byte    assetID[ASSET_ID_LEN+1];    // dex asset ID

    byte    setForceVend;               // 0x69=force vend

    byte    setFillTube;                // 0x68=no tube fill

    byte    settingsID[SETTINGS_ID_LEN+1]; // settings file name ID

    dword   percDimming;
    dword   timeDimming;
    
    byte    motorCoupled[MAXTRAY][MAXCOLUMN];

//    dword   sensitivity;
    dword   maxCreditFromPC;

    word    setupVersion;

    _Credito tubeValue;
    
    byte    animationMovie;
    byte    slideDelay;
    
    byte    fullDexSelection;           // 0x6A=send full dex data
    
    byte    DropHome;                   // 25.07.2010
    
    dword   percTax;                    // 24.07.2010
    dword   WinValue;                   // 24.07.2010
    dword   passcodeAudit;              // programming passcode 1
    
    word    discountFlag, discountPerc1, discountDays1, discountPerc2, discountDays2, discountDaysReset, discountMaxSel; // 24.07.2010
#define DISCOUNT_DISABLED   0
#define DISCOUNT_MACHINE    1
#define DISCOUNT_SELECTION  2
#define DISCOUNT_CLEAR      3
#define DISCOUNT_TRAY       0
#define DISCOUNT_COLUMN     0
    word    discountDoorClear;          // 07.04.2011
    word    Temperatura;                // 19.03.2011
    byte    flashingLedOn;              // 16.04.2013
    byte    flashingLedOff;             // 16.04.2013
    byte    ledOnTimeOut;               // 19.04.2013
    byte    downloadStatus;             // 09.04.2014    
    byte    reserved[256-254];

} NonVolatileSetup;
// maximun structure size is 256 bytes !!!!


#define FALLSENSOR_OFF  0   // sensor disabled
#define FALLSENSOR_5s   1   // fixed time fall sensor, do not set error
#define FALLSENSOR_3x   2   // 3 consecutive error, set error
#define FALLSENSOR_3r   3   // 3 consecutive error, 5 retry, set error
#define FALLSENSOR_3n   4   // 3 consecutive error, 5 retry, do not set error
#define FALLSENSOR_2t   5   // two turns when product will not fall
#define FALLSENSOR_2tto 6   // two turns spaced with timeouts
typeo   _Credito cash;
typeo   byte  slave_mac;


        /*+-------------------------------------+*/
        /*| orologio                            |*/
        /*+-------------------------------------+*/

typeo _dateTime dateTime;
typeo byte      dateTime_weekDay;




		/*+-------------------------------------+*/
		/*| timer								|*/
		/*+-------------------------------------+*/

typeo	unsigned char prescaler;		// prescaler per temporizzatori
typeo volatile dword timeMs;				// contatore up da 1 ms
typeo volatile dword countDown;			// contatore down a passi di 1ms
typeo   unsigned char oldProxSensor;
typeo   unsigned char deltaProxSensor;




		/*+-------------------------------------+*/
		/*| buffer comunicazione MMC/SD         |*/
		/*+-------------------------------------+*/

typeo   byte    sector[SECTOR_SIZE];



		/*+-------------------------------------+*/
		/*| led flashing                        |*/
		/*+-------------------------------------+*/

typeo   byte    LED1_MASK_AA;
typeo   byte    LED1_MASK_AK;
typeo   byte    LED1_MASK_KK;
typeo   byte    LED2_MASK_AA;
typeo   byte    LED2_MASK_AK;
typeo   byte    LED2_MASK_KK;
typeo   byte    LED3_MASK_AA;
typeo   byte    LED3_MASK_AK;
typeo   byte    LED3_MASK_KK;


		/*+-------------------------------------+*/
		/*| address machine                     |*/
		/*+-------------------------------------+*/

typeo   byte    machine_address;


		/*+-------------------------------------+*/
		/*| boot status                         |*/
		/*+-------------------------------------+*/

enum {  FW_LOADED = 0,
        FW_NO_OPEN,
        FW_FILE_FORM,
        FW_SIZE_ERR,
        FW_CHK_ERR, 
        FW_OK = 99,
        FW_DWN_REQ = 0xA5,
        FW_DWN_FAIL,
}; 

		/*+-------------------------------------+*/
		/*| test                                |*/
		/*+-------------------------------------+*/

typeo   char en_test_seriale;

typeo   char cashless_idx, cashless_active_addr, cashless_disabled;

typeo   char UCB_903C;

#undef	typeo
#endif
