//---------------------------------------------------------------------------
#include <conio.h>
#include <stdio.h>
#pragma hdrstop
#include <windows.h>

#include "RS232.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
__fastcall Rs232::Rs232(char ComPort,char *Par) {
  char NomeSer[10];
  BOOL Ok;

  sprintf(NomeSer,"COM%d",ComPort);

  /* Settaggio Time Out */
  TimeOut.ReadIntervalTimeout        =MAXDWORD;
  TimeOut.ReadTotalTimeoutMultiplier =0;
  TimeOut.ReadTotalTimeoutConstant   =1000;
  TimeOut.WriteTotalTimeoutMultiplier=0;
  TimeOut.WriteTotalTimeoutConstant  =0;

  /* Alcuni parametri della funzione sono obbligatori per l'apertura della seriale
     vedi documentazione in MS HELP */
//  if ((SerialPort=CreateFile(NomeSer,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,
//				  FILE_FLAG_OVERLAPPED,NULL))==INVALID_HANDLE_VALUE){
  if ((SerialPort=CreateFile(NomeSer,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,
  				  NULL,NULL))==INVALID_HANDLE_VALUE){
	cprintf( "ErrCode:%ld\n", (long) GetLastError());
	return;
  }
  GetCommState( SerialPort,&CommCfg );

  Ok = BuildCommDCB(Par,&CommCfg);

  if(Ok){
	/* Configurazione parametri seriale */
	CommCfg.fBinary = true;
//	CommCfg.fOutxCtsFlow = true;
	CommCfg.fOutxCtsFlow = false;
	CommCfg.fOutxDsrFlow = false;
	CommCfg.fNull = false;
	CommCfg.fOutX = false;
	CommCfg.fInX = false;
	CommCfg.fDtrControl = DTR_CONTROL_DISABLE;
//	CommCfg.fRtsControl = RTS_CONTROL_DISABLE;
	CommCfg.fRtsControl = RTS_CONTROL_ENABLE;
	if( SetCommState(SerialPort,&CommCfg)==false )
	  return;
  }
  else
     return;

  /*  Settaggio  del timeout della seriale  */
  if (SetCommTimeouts(SerialPort,&TimeOut)==false)
     return;

  /*  Settaggio della lunghezza dei buffer di input e di output */
  if (SetupComm(SerialPort,2048,128)==false)
     return;
}

//---------------------------------------------------------------------------
__fastcall Rs232::~Rs232(){
  CloseHandle(SerialPort);  /* Distruttore dell' HANDLE dell'oggetto seriale */
}
//---------------------------------------------------------------------------
bool __fastcall Rs232::TestComm(void){
  /* Controllo se SerialPort e` stata aperta con successo
	 possiede un'Handle valido */
  if( SerialPort==INVALID_HANDLE_VALUE )
	return false;
  return true;
}
//---------------------------------------------------------------------------
int __fastcall Rs232::ReadComm( char *Buf, int NumByte ){
  DWORD ByteRead=0;
  if( ReadFile(SerialPort,Buf,NumByte,&ByteRead,NULL)==false )
	return(0);
  return( ByteRead );
}

//---------------------------------------------------------------------------
bool __fastcall Rs232::WriteComm( char *_buf, int _numByte ){
	DWORD		NumScritti;
	char		buf;

	if( _buf == NULL ) {
		_buf = &buf;
		_numByte = 1;
	}
	if( WriteFile(SerialPort,_buf,_numByte,&NumScritti,NULL) == false )
		return false;
	return true;
}


