//---------------------------------------------------------------------------
#ifndef RS232H
#define RS232H
//---------------------------------------------------------------------------
#endif

#ifdef __BUILDING_THE_DLL
#define __EXPORT_TYPE __export
#else
#define __EXPORT_TYPE __import
#endif

#define	bool	unsigned char
#ifndef	true
#define	true	(1==1)
#endif
#ifndef	false
#define	false	(1==0)
#endif

#define	EOT		0x04
#define ETX     0x03
#define STX     0x02
#define ACK     0x06
#define NAK     0x15


class __EXPORT_TYPE Rs232{
  public:
  HANDLE  SerialPort;	/*  Handle del file associato alla seriale  */
  OVERLAPPED  Over;     /*  Struttura che permette di gestire il file in
  				            modo OVERLAPPED         */
  COMMTIMEOUTS TimeOut; /*  Struttura che serve per settare il
                            timeout della seriale   */

  DCB	CommCfg;		    /*  Struttura che contiene i parametri
                            di funzionamento della seriale  */


  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Costruttore della classe RS232									 + */
  /* + ComPort numero della porta seriale da aprire						 + */
  /* + Par parametri di apertura  "Speed parity data stop"	es "9600 n 8 1"*/
  /* --------------------------------------------------------------------- */
  __fastcall Rs232( char ComPort, char *Par );

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Distruttore della classe RS232									 + */
  /* --------------------------------------------------------------------- */
  __fastcall ~Rs232();

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Procedura che testa se l'apertura della seriale ha avuto successo + */
  /* + Ritorna true in caso si seriale aperta, false in caso d'errore    + */
  /* --------------------------------------------------------------------- */
  bool __fastcall TestComm(void);

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Procedura che legge NumByte caratteri dalla seriale mette in Buf  + */
  /* --------------------------------------------------------------------- */
  int __fastcall ReadComm( char *Buf, int NumByte );
  /* --------------------------------------------------------------------- */

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Procedura che invia i caratteri memorizzati in Buf sulla seriale  + */
  /* + NumByte indica il numero di caratteri da spedire				     + */
  /* --------------------------------------------------------------------- */
  bool __fastcall WriteComm( char *Buf, int NumByte );
  /* --------------------------------------------------------------------- */

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* + Procedura che testa se l'apertura della seriale ha avuto successo + */
  /* + Ritorna TRUE in caso d'errore e FALSE se ha fallito				 + */
  /* --------------------------------------------------------------------- */
  bool __fastcall ErrComm(void);
  /* --------------------------------------------------------------------- */
};
