//---------------------------------------------------------------------------
#include <vcl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#pragma hdrstop

#include "sender.h"
#include "rs232.h"
#include "MonitorGest.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
bool forceClose = false;
void		RxMonitor( void );
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	StdConf->ItemIndex = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SelectClick(TObject *Sender)
{
	if( OpenDialog1->Execute() ) {
		FName->Text = OpenDialog1->FileName;
	}


}
//---------------------------------------------------------------------------

char			buffer[64];
char			*serMode( void )
{
	long		baud;
	char		parity;
	char		data;

	switch( Form1->BaudRate->ItemIndex ) {
		case 1:		baud = 19200; 	break;
		case 2:		baud = 38400;	  break;
		case 3:		baud = 57600;	  break;
		case 4:		baud = 115200;	break;
		default:	baud = 9600;	  break;
	}
	switch( Form1->Parity->ItemIndex ) {
		case 1:		parity = 'E';	break;
		case 2:		parity = 'O';	break;
		default:	parity = 'N';	break;
	}
	switch( Form1->DataBit->ItemIndex ) {
		case 1:		data = '7';		break;
		default:	data = '8';		break;
	}
	sprintf( buffer, "baud=%ld parity=%c data=%c stop=1", baud, parity, data );
	return buffer;
}

void __fastcall TForm1::UploadClick(TObject *Sender)
{
	char		        buffer[256], sTmp[32], ackNack;
	TFileStream	    *inpFile;
  bool            fRec;
	int			        i, j, retry;
  unsigned int    tOut;
	long		        totRetry, totError;
	Rs232		        *com;
	DWORD		        now, sTm, aTm;

	forceClose = false;

	com = new Rs232( (char)(COMnumber->ItemIndex+1), serMode() );
	if( com == NULL ) {
		Application->MessageBox( "Unable to open serial port", "Error", MB_OK );
		return;
	}


	ProgressBar1->Position = 0;
	try {
		inpFile = new TFileStream( FName->Text, fmOpenRead | fmShareExclusive );
	}
	catch (...)
	{
		Application->MessageBox( "Unable to open input file", "Error", MB_OK );
		delete com;
		return;
	}

	if( StdConf->ItemIndex == RSR275 ) {
		com->WriteComm( " ", 1 );
		sTm = GetTickCount();
		while( (GetTickCount()-sTm) < 100 );
		com->WriteComm( "\x0d", 1 );
		sTm = GetTickCount();
		while( (GetTickCount()-sTm) < 100 )
			com->ReadComm( &buffer[0], 1 );
	}

	NumRetry->Text = 0;
	NumError->Text = 0;
	ProgressBar1->Max = inpFile->Size;
	ProgressBar1->Visible = true;
	SRecord->Visible = true;
	NumRetry->Visible = true;
	NumError->Visible = true;
	TxTimer->Visible = true;
	Label1->Visible = true;
	Label2->Visible = true;
	TxStop->Visible = true;

	sTm = GetTickCount();
	Select->Enabled = false;
	Upload->Enabled = false;
	j = 0;
	totRetry = 0;
	totError = 0;
  fRec = true;
  memset(buffer, 0x0, sizeof(buffer));
	while( !forceClose ) {
		i = inpFile->Read( &buffer[j], 1 );
		if( i == 0 )
			break;
		if( buffer[j] != 0x0A ) {
			j++;
			if( j >= sizeof(buffer) )
				j = 0;
			continue;
		}
		buffer[j+1] = '\0';

		for( retry = 0; retry < 5 && !forceClose; retry++ ) {
			com->WriteComm( buffer, j+1 );
			SRecord->Text = buffer;
			ProgressBar1->Position = inpFile->Position;
			Application->ProcessMessages();

      if ( fRec )
        tOut = 160000;

//			for( now = GetTickCount(); (GetTickCount()-now) < 5000 && !forceClose; ) {
			for( now = GetTickCount(); (GetTickCount()-now) < tOut && !forceClose; ) {
				if( com->ReadComm( &ackNack, 1 ) != 0 ) {
          if ( fRec ) {
            fRec = false;
            tOut = 5000;
          }  
					if( ackNack == 0x06 ) {
						retry = 100;
						break;
					}
					if( ackNack == 0x15 )
						break;
				}
				Application->ProcessMessages();

				aTm = (GetTickCount()-sTm)/1000;
				sprintf( sTmp, "%02d:%02d", aTm/60, aTm%60 );
				TxTimer->Text = sTmp;
			}
      if ( fRec ) {
        fRec = false;
        tOut = 5000;
      }
			if( retry == 100 )
				break;
			totRetry++;
			NumRetry->Text = totRetry;
		}
		if( retry == 5 ) {
			totError++;
			NumError->Text = totError;
		}

		ProgressBar1->Position = inpFile->Position;
		Application->ProcessMessages();
		j = 0;
    memset(buffer, 0x0, sizeof(buffer));
	}
	Select->Enabled = true;
	Upload->Enabled = true;

	TxStop->Visible = false;
	Label1->Visible = false;
	Label2->Visible = false;
//	TxTimer->Visible = false;
	SRecord->Visible = false;
	ProgressBar1->Visible = false;
	NumRetry->Visible = false;
	NumError->Visible = false;
	delete inpFile;
	delete com;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
	forceClose = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StdConfClick(TObject *Sender)
{
	switch( StdConf->ItemIndex ) {
		case RSR275:
			BaudRate->ItemIndex = 0;	//  9600
			Parity->ItemIndex =   1;	// even
			DataBit->ItemIndex =   0;	// 8 bit
			OpenDialog1->InitialDir = "c:\\rsr\\275___~1";
			Form1->Height = 367;
			break;

		case RSR271:
			OpenDialog1->InitialDir = "c:\\rsr\\rsr271\\cpu";
		case RSR362:
			BaudRate->ItemIndex = 3;	// 57600
			Parity->ItemIndex =   0;	// none
			DataBit->ItemIndex =   0;	// 8 bit
			if( StdConf->ItemIndex == RSR362 )
				OpenDialog1->InitialDir = "c:\\rsr\\362___~1";
			Form1->Height = 321;
			break;

		case RSR364:
			BaudRate->ItemIndex = 0;	//  9600
			Parity->ItemIndex =   1;	// even
			DataBit->ItemIndex =   0;	// 8 bit
			OpenDialog1->InitialDir = "c:\\rsr\\364___~1";
			Form1->Height = 291;
			break;
	}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TxStopClick(TObject *Sender)
{
	forceClose = true;
	
}
//---------------------------------------------------------------------------
void __fastcall	TForm1::bottOff( void )
{
}
//---------------------------------------------------------------------------
void __fastcall	TForm1::bottOn( void )
{
}
//---------------------------------------------------------------------------




int				cnv2bin( char *_fname )
{
	char		fname_in[256], fname_out[256], *p;
	int			i, j;
	FILE		*fin, *fout;

	strcpy( fname_in, _fname );
	if( (fin=fopen(fname_in,"r")) == NULL )
		return -1;

	strcpy( fname_out, fname_in );
	if( (p=strrchr(fname_out,'.')) == NULL )
		strcat( fname_out, ".bin" );
	else
		strcpy( p, ".bin" );
	if( (fout=fopen(fname_out,"wb")) == NULL )
		return -1;

	while( !feof(fin) ) {
		if( (j=fscanf( fin, "%02X", &i )) == EOF )
			break;
		if( j == 0 )
			break;
		fprintf( fout, "%c", i );
	}

	fflush( fout );
	fclose( fout );
	fclose( fin );
	return 0;
}




void __fastcall TForm1::EnMonitorClick(TObject *Sender)
{
	if( SerMonitor->Visible == true ) {
//		SerMonitor->FormClose();
		SerMonitor->Visible = false;

		Select->Enabled = true;
		Upload->Enabled = true;

		SRecord->Visible = false;
		TxStop->Visible = false;

	}
	else {
		Select->Enabled = false;
		Upload->Enabled = false;

		SerMonitor->VisuaMode->ItemIndex = 0;
		SerMonitor->Visible = true;
		
		SerMonitor->RxMonitor();

		SerMonitor->Visible = false;

		Select->Enabled = true;
		Upload->Enabled = true;

		SRecord->Visible = false;
		TxStop->Visible = false;
	}
}
//---------------------------------------------------------------------------




const unsigned short crc16_rev_table[256] =
{   0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
    0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
    0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
    0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
    0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
    0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
    0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
    0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
    0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
    0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
    0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
    0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
    0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
    0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
    0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
    0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
    0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
    0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
    0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
    0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
    0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
    0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
    0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
    0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
    0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
    0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
    0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
    0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
    0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
    0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
    0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
    0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};

#pragma section

unsigned short Crc( unsigned char *ucpBuf, unsigned short nSize)
{
    register unsigned short x;
    register unsigned short crc;
    unsigned short i;

    crc = 0xFFFF;                   /* start with all 1's for a reverse CRC */

    for( i = 0; i < nSize; ++i)
    /* process each character in the message - 2 steps per char only! */
    {
        x = crc ^ ucpBuf[i];
        crc = (crc >> 8) ^ crc16_rev_table[x & 0x00FF];
    }
    i = crc>>8;
    crc <<= 8;
    crc += i;
    return(crc);
}



void __fastcall TForm1::Button1Click(TObject *Sender)
{
	char		buffer[256], sTmp[32], *p;
	FILE	    *inpFile;
	TFileStream	*outFile;
	int			i, j, k;
    unsigned short crc;
	Rs232		*com;
	DWORD		sTm, aTm, rTm;


	if( !OpenDialog2->Execute() )
        return;


	if( !SaveDialog1->Execute() )
        return;


    try {
        if( (inpFile=fopen(OpenDialog2->FileName.c_str(),"r")) == NULL )
            throw 0;
    }
    catch (...)
    {
        Application->MessageBox( "Unable to open input file", "Error", MB_OK );
        return;
    }


    try {
        outFile = new TFileStream( SaveDialog1->FileName, fmOpenWrite	| fmCreate | fmShareExclusive );
    }
    catch (...)
    {
        Application->MessageBox( "Unable to open output file", "Error", MB_OK );
        fclose(inpFile);
        return;
    }


    forceClose = false;

    com = new Rs232( (char)(COMnumber->ItemIndex+1), serMode() );
    if( com == NULL ) {
        Application->MessageBox( "Unable to open serial port", "Error", MB_OK );
        delete outFile;
        fclose(inpFile);
        return;
    }

    TxTimer->Visible = true;
    TxStop->Visible = true;
    SRecord->Visible = true;

    bottOff();

    j = 0;
    sTm = GetTickCount();
    Select->Enabled = false;
    Upload->Enabled = false;
    while( !forceClose && !feof(inpFile) ) {
                                        // scrive stringa
        k = fscanf( inpFile, "%[^\n]\n", buffer );
        if( k == 0 )
            break;

        k = 0;
        p = buffer;
        while( sscanf( p, "%x", &i ) ) {
            sTmp[k++] = i;

            if( (p=strchr(p,' ')) == NULL )
                break;

            p++;
        }

        crc = Crc( sTmp, k );
        sTmp[k+0] = (char)(crc>>8);
        sTmp[k+1] = (char)crc;
        com->WriteComm( sTmp, k+2 );
        Application->ProcessMessages();

                                        // legge risposta
        rTm = GetTickCount();
        while( !forceClose && (GetTickCount()-rTm) < 500 ) {
            if( (i=com->ReadComm( &buffer[0], 1 )) != 0 ) {
                outFile->Write( &buffer[0], i );
                rTm = GetTickCount();
                j++;
            }

            Application->ProcessMessages();
        }

        sprintf( sTmp, "%d", j );
        SRecord->Text = sTmp;

        aTm = (GetTickCount()-sTm)/1000;
        sprintf( sTmp, "%02d:%02d", aTm/60, aTm%60 );
        TxTimer->Text = sTmp;
    }

    Select->Enabled = true;
    Upload->Enabled = true;

    bottOn();

    SRecord->Visible = false;
    TxStop->Visible = false;
    fclose(inpFile);
    delete com;
    delete outFile;
    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
	char		buffer[256], buftx[256], sTmp[256], *p;
	FILE	    *inpFile;
	TFileStream	*outFile;
	int			i, j, k, n;
    unsigned short crc;
	Rs232		*com;
	DWORD		sTm, aTm, rTm;


	if( !OpenDialog2->Execute() )
        return;


	if( !SaveDialog1->Execute() )
        return;


    try {
        if( (inpFile=fopen(OpenDialog2->FileName.c_str(),"r")) == NULL )
            throw 0;
    }
    catch (...)
    {
        Application->MessageBox( "Unable to open input file", "Error", MB_OK );
        return;
    }


    try {
        outFile = new TFileStream( SaveDialog1->FileName, fmOpenWrite	| fmCreate | fmShareExclusive );
    }
    catch (...)
    {
        Application->MessageBox( "Unable to open output file", "Error", MB_OK );
        fclose(inpFile);
        return;
    }


    forceClose = false;

    com = new Rs232( (char)(COMnumber->ItemIndex+1), serMode() );
    if( com == NULL ) {
        Application->MessageBox( "Unable to open serial port", "Error", MB_OK );
        delete outFile;
        fclose(inpFile);
        return;
    }



    TxTimer->Visible = true;
    TxStop->Visible = true;
    SRecord->Visible = true;

    bottOff();

    j = 0;
    sTm = GetTickCount();
    Select->Enabled = false;
    Upload->Enabled = false;
	ProgressBar1->Position = 0;
	ProgressBar1->Max = filelength(fileno(inpFile));
	ProgressBar1->Visible = true;
    while( !forceClose && !feof(inpFile) ) {
        ProgressBar1->Position = ftell(inpFile);
                                        // scrive stringa
        k = fscanf( inpFile, "%[^\n]\n", buffer );
        if( k == 0 )
            break;

        sprintf( buftx, "%s%c%c", buffer, 0x0d, 0x0a );
retrasm:
        com->WriteComm( buftx, strlen(buftx) );
        Application->ProcessMessages();

                                        // legge risposta
        n = 0;
        rTm = GetTickCount();
        while( !forceClose && (GetTickCount()-rTm) < 400 ) {
            if( (i=com->ReadComm( &buffer[n], 1 )) != 0 ) {
                outFile->Write( &buffer[n], i );
                if( buffer[n] == 0x0a )
                {
                    if( buffer[0] == 0x15 && buffer[1] == 0x0d && buffer[2] == 0x0a )
                        goto retrasm;
                    break;
                }
                rTm = GetTickCount();
                j++;
                n++;
            }

            Application->ProcessMessages();
        }

        sprintf( sTmp, "%d", j );
        SRecord->Text = sTmp;

        aTm = (GetTickCount()-sTm)/1000;
        sprintf( sTmp, "%02d:%02d", aTm/60, aTm%60 );
        TxTimer->Text = sTmp;


        rTm = GetTickCount();
        while( !forceClose && (GetTickCount()-rTm) < 100 )
            Application->ProcessMessages();

    }

    Select->Enabled = true;
    Upload->Enabled = true;

    bottOn();

	ProgressBar1->Visible = false;
    SRecord->Visible = false;
    TxStop->Visible = false;
    fclose(inpFile);
    delete com;
    delete outFile;

}
//---------------------------------------------------------------------------

