/*--------------------------------------------------------------------------
 |  test.c
 +--------------------------------------------------------------------------*/
#define __TEST_C

#include    <stdio.h>
#include    <string.h>
#include    "def.h"
#include    "device.h"
#include    "display.h"
#include    "hwinit.h"
#include    "lcd7seg.h"
#include    "lpc_vic.h"
#include    "keyadc.h"
#include    "keyboard.h"
#include    "main.h"
#include    "menu.h"
#include    "mmc.h"
#include    "ram.h"
#include    "test.h"
#include    "timer.h"
#include    "uart.h"
#include    "temperatura.h"
#include    "funzioni.h"

extern byte     keyledpwm;

#if BOARDTEST

void  Delay_50( void )
{
      Delay(50);
}

void  Delay_200( void )
{
      Delay(200);
}

extern  byte    stopInt;

void            DispBuf( char *s )
{
    DispStr( 0, 0, s );
}


/*--------------------------------------------------------------------------
| enableTest:   enable test board
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            enableTest ( void )
{
    byte        pin[4];
    DWORD       oldsel;

    
#if 1
    oldsel = IO0DIR;
    IO0DIR |=  BIT17;
    IO0DIR &= ~BIT18;
    SETRTS_MAXSTREAM();         Delay_50();          pin[0] = CTS_MAXSTREAM();
    CLRRTS_MAXSTREAM();         Delay_50();          pin[1] = CTS_MAXSTREAM();
    SETRTS_MAXSTREAM();         Delay_50();          pin[2] = CTS_MAXSTREAM();
    CLRRTS_MAXSTREAM();         Delay_50();          pin[3] = CTS_MAXSTREAM();
    IO0DIR = oldsel;
#else
    oldsel = PINSEL9;    
    PINSEL9 = 0x00000000;               // tutti I/O generici
    FIO4DIR = BIT28;                    // 28:uscite, 29: ingressi

    FIO4SET = BIT28;            Delay_50();          pin[0] = ((FIO4PIN&BIT29)!=0);
    FIO4CLR = BIT28;            Delay_50();          pin[1] = ((FIO4PIN&BIT29)!=0);
    FIO4SET = BIT28;            Delay_50();          pin[2] = ((FIO4PIN&BIT29)!=0);
    FIO4CLR = BIT28;            Delay_50();          pin[3] = ((FIO4PIN&BIT29)!=0);

    PINSEL9 = oldsel;
#endif

    if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
        return TRUE;

    return FALSE;
}                                               //  enableTest




/*--------------------------------------------------------------------------
 | testBoardType:verify if board type programmed to in initialize display
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void			(*restart)();

BOOL            testBoardType ( void )
{
    byte        i;
    
    ////// select machine type
    if ( machineType < TOTAL_MACHINE )
        return TRUE;
/*
    if( machineType == MACHINA_NAT147   ||
        machineType == MACHINA_AP113    ||
        machineType == MACHINA_ROWE5900 ||
        machineType == MACHINA_ROWE6800 || 
        machineType == MACHINA_NAT157   || 
        machineType == MACHINA_AP7000   ||
        machineType == MACHINA_AP123    ||
        machineType == MACHINA_LCM123   ||
        machineType == MACHINA_VEIDOOR  ||
        machineType == MACHINA_NAT145   ||
        machineType == MACHINA_AMS39    ||
        machineType == MACHINA_VEI147   || 
        machineType == MACHINA_USIGVC2  )
        return TRUE;
*/
    DispBuf( "WRONG BOARD TYPE" );
    for ( i = 0; i < 5; i++ )
    {                                   // segnala errore nella base-board
        BuzzerOn(200);
        Delay(500);
    }
    if ( !testGSM() )                   // ulteriore verifica prima di programmare
        while(-1);
    programMachineType();               // programma il tipo di macchina
    checkMachineType();

	restart = (void * )0;
	(*restart)();
    
    return FALSE;
}                                               //  testBoardType




/*--------------------------------------------------------------------------
 | testDisplay: test display, and backlight
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testDisplay ( void )
{
    byte        i;
                                        // test display functionality
    DispBuf( "<=TEST DISPLAY=>" );
                                        // test contrast regulation
    if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 1;
    for ( i = 0; i < 100; i++ )
    {
        setContrastLCD( (i+NonVolatileSetup.contrasto_lcd)%100 );
        Delay(10);
    }
    while ( i-- > 0 )
    {
        setContrastLCD( (i+NonVolatileSetup.contrasto_lcd)%100 );
        Delay(10);
    }
    
    return TRUE;
}                                               //  testDisplay




/*--------------------------------------------------------------------------
 | testAnalog:  test analog input reading display contrast output
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testAnalog ( void )
{
    word        rd0, rd50, rd100;
                                        // test display functionality
    DispBuf( "TEST ANALOG INP." );
    do {
                                        // test contrast regulation
        setContrastLCD( 0 );
        Delay(100);
        rd0 = AD.conv[AD_2];
        setContrastLCD( 50 );
        Delay(100);
        rd50 = AD.conv[AD_2];
        setContrastLCD( 100 );
        Delay(100);
        rd100 = AD.conv[AD_2];
        setContrastLCD(1);
        
        if ( rd0 > 20 || rd50 < 180 || rd50 > 220 || rd100 < 360 || rd100 > 440 )
        {
            BuzzerOn(10);
            DispBuf( "TEST ANALOG:FAIL" );
            Delay(1000);
        }
        else
            break;
    } while ( -1 );
    
    DispBuf( "TEST ANALOG: OK " );
    Delay_200( );
    
    return TRUE;
}                                               //  testAnalog




/*--------------------------------------------------------------------------
 | testBattery: check battery functionality
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testBattery ( void )
{
    byte        i;
                                        // test battery functionality
    recvDate(&dateTime);
    if ( dateTime.year < 2008 || 
         dateTime.year > 2020 || 
         dateTime.month == 0  ||
         dateTime.month > 12  ||
         dateTime.day   == 0  ||
         dateTime.day   > 31 )
    {
        DispBuf( "BATTERY:  FAIL  " );
        for ( i = 0; i < 10; i++ )
        {
            BuzzerOn(10);
            Delay_200( );
        }
        while( (testKey()) == KNULL );                
    }
    else
    {
        DispBuf( "TEST BATTERY: OK" );
//        BuzzerOn(50);
        Delay_200( );
    }

    return TRUE;
}                                               //  testBattery




/*--------------------------------------------------------------------------
 | testBuzzer:  test buzzer
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testBuzzer ( void )
{
    byte        i;
    
    DispBuf( "TEST BUZZER:    " );
    for ( i = 0; i < 3; i++ )
    {
        BuzzerOn(10);
        Delay_200( );
    }
    
    return TRUE;
}                                               //  testBuzzer




/*--------------------------------------------------------------------------
 | testLED:     test bicolor led
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testLED ( void )
{
    byte        i, j;
    
    DispBuf( "<===TEST LED===>" );
//    BuzzerOn(50);
    
    for ( j = 0; j <= 3; j++ )
    {
        for ( i = 0; i < 2; i ++ )
        {
            if ( (j&0x01) )     IO1CLR_bit.P1_25 = 1;
            if ( (j&0x02) )     IO1CLR_bit.P1_26 = 1;
            Delay_200( );
    
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
            Delay_200( );
        }
    }    

    return TRUE;
}                                               //  testLED




/*--------------------------------------------------------------------------
 | testKeyboard:test keyboard
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

struct _TAB_KEYS_ {
    char    *str;
    byte    kval;
};

const  struct _TAB_KEYS_ tabKeyRowe5900[] = {
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyAP113[] = {
    {"  A  ",K_A     }, {"  B  ",K_B     }, {"  C  ",K_C     },
    {"  D  ",K_D     }, {"  E  ",K_E     }, {"  F  ",K_F     },
    {"  G  ",K_G     }, {"  H  ",K_H     }, {"  J  ",K_AST   },
    {"  K  ",K_ENTER },
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {" 10  ",K_0     },  
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyNAT147[] = {
    {"  A  ",K_A     }, {"  B  ",K_B     }, {"  C  ",K_C     },
    {"  D  ",K_D     }, {"  E  ",K_E     }, {"  F  ",K_F     },
    {"  G  ",K_G     }, {"  H  ",K_H     }, {"  I  ",K_I     },
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  *  ",K_AST   }, {"  0  ",K_0     }, {"ENTER",K_ENTER },  
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyAP7000[] = {
    {"  A  ",K_A     }, {"  B  ",K_B     }, {"  C  ",K_C     },
    {"  D  ",K_D     }, {"  E  ",K_E     }, {"  F  ",K_F     },
    {"  G  ",K_G     }, 
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {" 10  ",K_0     }, {" 11  ",K_11    }, {" 12  ",K_12    },
    {" 13  ",K_13    }, {" 14  ",K_14    },
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyAP123[] = {
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyLCM123[] = {
    {"  A  ",K_A     }, {"  B  ",K_B     }, {"  C  ",K_C     }, {"  D  ",K_D     }, 
    {"  E  ",K_E     }, {"  F  ",K_F     }, {"  G  ",K_G     }, {"  H  ",K_H     },
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     }, {"  4  ",K_4     }, 
    {"  5  ",K_5     }, {"  6  ",K_6     }, {"  7  ",K_7     }, {"  8  ",K_8     }, 
    {"  9  ",K_9     }, {"  0  ",K_0     }, {" up  ",K_AST   }, {" dn  ",K_ENTER },
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyVEIDOOR[] = {
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyNAT145[] = {
    {"  A  ",K_A     }, {"  B  ",K_B     }, {"  C  ",K_C     }, {"  D  ",K_D     }, {"  E  ",K_E     }, {"  F  ",K_F     }, {"  G  ",K_G     }, 
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     }, {"  4  ",K_4     }, {"  5  ",K_5     }, 
    {"  6  ",K_6     }, {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     }, {" 10  ",K_0     }, {"  *  ",K_AST   }, {"ENTER",K_ENTER },  
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyAMS39[] = {
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyUSIGVC2[] = {
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  *  ",K_RESET }, {"  0  ",K_0     }, {"  #  ",K_ENTER },
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyMERCHA6[] = {                // DEBUG DA VEDERE
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const  struct _TAB_KEYS_ tabKeyVEILCM[] = {                 // da verificare
    {"  1  ",K_1     }, {"  2  ",K_2     }, {"  3  ",K_3     },
    {"  4  ",K_4     }, {"  5  ",K_5     }, {"  6  ",K_6     },
    {"  7  ",K_7     }, {"  8  ",K_8     }, {"  9  ",K_9     },
    {"  0  ",K_0     }, {"RESET",K_RESET }, 
    {0,      KNULL   },
};

const struct _TAB_KEYS_ *pTabKeys[] = {
        tabKeyAP113,                    // #define MACHINA_AP113     0
        tabKeyNAT147,                   // #define MACHINA_NAT147    1
        tabKeyRowe5900,                 // #define MACHINA_ROWE5900  2
        tabKeyRowe5900,                 // #define MACHINA_ROWE6800  3
        tabKeyNAT147,                   // #define MACHINA_NAT157    4
        tabKeyAP7000,                   // #define MACHINA_AP7000    5
        tabKeyLCM123,                   // #define MACHINA_LCM123    6
        tabKeyAP123,                    // #define MACHINA_AP123     7
        tabKeyVEIDOOR,                  // #define MACHINA_VEIDOOR   8
        tabKeyNAT145,                   // #define MACHINA_NAT145    9
        tabKeyAMS39,                    // #define MACHINA_AMS39     10
        tabKeyNAT147,                   // #define MACHINA_VEI147    11
        tabKeyUSIGVC2,                  // #define MACHINA_USIGVC2   12
        tabKeyMERCHA6,                  // #define MACHINA_MERCHA6   13
        tabKeyVEILCM                    // #define MACHINA_VEILCM    14
};

BOOL            testKeyboard ( void )
{
    byte        i, kkk;
    char        buf[20];
    struct _TAB_KEYS_ const *p;

    if ( machineType > TOTAL_MACHINE )
        return FALSE;

    p = pTabKeys[machineType];

    for ( i = 0; p->kval != KNULL; i++, p++ )
    {
        keyledpwm = 0;
        sprintf( buf, "PRESS KEY: %s", p->str );
        DispBuf( buf );
        do {
            kkk = testKey();
            if ( kkk == KNULL )
                continue;
            if ( kkk == p->kval )
                break;
            BuzzerOn(200);
        } while( -1 );
        keyledpwm = 15;
        Delay_200( );
        testKey();
    }
    
    return TRUE;
}                                               //  testKeyboard




/*--------------------------------------------------------------------------
 | testKeyScan: check keyboard scan key
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testKeyScan ( void )
{
    byte    row;
    char    str[LCDCOL+1];

    for ( row = 0; row < 8; row++ ) 
    {
        KEY_MUX(row);
        Delay(20);
        if ( (inImage[3]^(0x01<<row)) != 0xFF )
        {
            BuzzerOn( 10 );
            sprintf( str, "TEST CN4-%2d & %2d", 11+row, 19+row );
            DispBuf( str );
            Delay(1000);
            row = 0xFF;
            continue;
        }
    }

    return TRUE;
}                                               //  testKeyScan




/*--------------------------------------------------------------------------
 | testSerial:  test buzzer
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

const  byte testString[] = "Hi!";//max 8 char

BOOL            testSerial ( byte _ch )
{
    byte        i, j;
    char        buf[20];

    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 )
        outImage[OUT_COIN_BILL] &= ~0x10;//send

    sprintf( buf, "TEST COMM%d:     ", _ch );
    DispBuf( buf );

    en_test_seriale = TRUE;
    
    do {
        commRxFlash( _ch );
        memset( buf, 0, sizeof(buf) );
        for ( i = 0, j = 0; testString[i] != '\0'; i++ )
        {
            commPutChar( _ch, testString[i] );
            Delay(100);           
            if ( commGetChar( _ch, (byte *)&buf[j] ) == COMM_NO_ERR )
                j++;
        }

        if ( strcmp( (char *)testString, (char *)buf ) ==  0 )
            break;

        sprintf( buf, "TEST COMM%d: FAIL", _ch );
        DispBuf( buf );
    } while( -1 );
    
    sprintf( buf, "TEST COMM%d:  OK ", _ch );
    DispBuf( buf );
    Delay_200( );
    
    en_test_seriale = FALSE;
    
    return TRUE;
}                                               //  testSerial




/*--------------------------------------------------------------------------
| testRTS_CTS_maxStream: test RTS/CTS MaxStream signal
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            DelayShort( void )
{
    Delay(40);
}

BOOL            testRTS_CTS_maxStream ( void )
{
    byte        cts[4];

    IO0DIR  = 0x7C7A85F0;               // 01111100 01111010 10000101 11110000
    
    DispBuf( "TEST RTS/CTS:   " );
//    BuzzerOn(50);

    do {
        SETRTS_MAXSTREAM();         DelayShort();          cts[0] = CTS_MAXSTREAM();
        CLRRTS_MAXSTREAM();         DelayShort();          cts[1] = CTS_MAXSTREAM();
        SETRTS_MAXSTREAM();         DelayShort();          cts[2] = CTS_MAXSTREAM();
        CLRRTS_MAXSTREAM();         DelayShort();          cts[3] = CTS_MAXSTREAM();
        
        if ( cts[0] == cts[2] && cts[1] == cts[3] && cts[0] != cts[1] )
            break;

        DispBuf( "TEST RTSCTS:FAIL" );
        BuzzerOn(10);
        Delay(500);
    } while(-1);
    
    DispBuf( "TEST RTS/CTS: OK" );
    Delay_200( );
    return TRUE;
}                                               //  testRTS_CTS_maxStream




/*--------------------------------------------------------------------------
| testSPI0:     check SPI0
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testSPI0( void )
{
    byte        miso[4];

    if ( machineType == MACHINA_USIGVC2 )
        return TRUE;
    
    PINSEL3 &= ~0x0003C300;
    IO1DIR  |=  0x01100000;             // 00000001 00010000 00000000 00000000
    IO1DIR  &= ~0x00800000;             // 00000000 80000000 00000000 00000000

    
    DispBuf( "TEST SPI0:      " );

    do {
        SPI0_MOSI_LOW();        DelayShort();          miso[0] = SPI0_MISO();
        SPI0_MOSI_HIGH();       DelayShort();          miso[1] = SPI0_MISO();
        SPI0_MOSI_LOW();        DelayShort();          miso[2] = SPI0_MISO();
        SPI0_MOSI_HIGH();       DelayShort();          miso[3] = SPI0_MISO();
        
        if ( miso[0] == miso[2] && miso[1] == miso[3] && miso[0] != miso[1] )
            break;

        DispBuf( "MISO/MOSI: FAIL " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);
    

    do {
        SPI0_CLK_LOW();         DelayShort();          miso[0] = SPI0_SCL1();
        SPI0_CLK_HIGH();        DelayShort();          miso[1] = SPI0_SCL1();
        SPI0_CLK_LOW();         DelayShort();          miso[2] = SPI0_SCL1();
        SPI0_CLK_HIGH();        DelayShort();          miso[3] = SPI0_SCL1();
        SPI0_CLK_LOW();
        
        if ( miso[0] == miso[2] && miso[1] == miso[3] && miso[0] != miso[1] )
            break;

        DispBuf( "SCK/SCL1:  FAIL " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);
    
    DispBuf( "TEST SPI0:  OK  " );
    Delay_200( );
    return TRUE;
        
}                                               //  testSPI0




/*--------------------------------------------------------------------------
| testGSM:      test GSM
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testGSM ( void )
{
    byte        pin[4];

    PINSEL9 = 0x00000000;               // tutti I/O generici
    FIO4DIR = BIT28;                    // 28:uscite, 29: ingressi

    IO1DIR  = BIT27|BIT29|0x07500000;   // 27 e 29:uscite, 28 e 30: ingressi

    DispBuf( "TEST GSM:       " );

    do {
        FIO4SET = BIT28;            DelayShort();          pin[0] = ((FIO4PIN&BIT29)!=0);
        FIO4CLR = BIT28;            DelayShort();          pin[1] = ((FIO4PIN&BIT29)!=0);
        FIO4SET = BIT28;            DelayShort();          pin[2] = ((FIO4PIN&BIT29)!=0);
        FIO4CLR = BIT28;            DelayShort();          pin[3] = ((FIO4PIN&BIT29)!=0);
        
        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "GSMtx/rx:  FAIL " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);

    do {
        IO1SET = BIT27;             DelayShort();          pin[0] = ((IO1PIN&BIT28)!=0);
        IO1CLR = BIT27;             DelayShort();          pin[1] = ((IO1PIN&BIT28)!=0);
        IO1SET = BIT27;             DelayShort();          pin[2] = ((IO1PIN&BIT28)!=0);
        IO1CLR = BIT27;             DelayShort();          pin[3] = ((IO1PIN&BIT28)!=0);
        
        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "GSM27/28:  FAIL " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);

    do {
        IO1SET = BIT29;             DelayShort();          pin[0] = ((IO1PIN&BIT30)!=0);
        IO1CLR = BIT29;             DelayShort();          pin[1] = ((IO1PIN&BIT30)!=0);
        IO1SET = BIT29;             DelayShort();          pin[2] = ((IO1PIN&BIT30)!=0);
        IO1CLR = BIT29;             DelayShort();          pin[3] = ((IO1PIN&BIT30)!=0);
        
        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "GSM29/30:  FAIL " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);
    
    DispBuf( "TEST GSM:   OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testGSM




/*--------------------------------------------------------------------------
 | testDateTime:check I2C communication and date/time
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testDateTime ( BOOL _force )
{
    byte        i, kkk;
    char        buf[20];

    DispBuf( "TEST DATE/TIME: " );
//    BuzzerOn(50);

    recvDate(&dateTime);
    if ( dateTime.year < 2008 || 
         dateTime.year > 2020 || 
         dateTime.month == 0  ||
         dateTime.month > 12  ||
         dateTime.day   == 0  ||
         dateTime.day   > 31 )
    {
        if ( _force == FALSE )
        {
            BuzzerOn(500);
    
            i = 0;
            strcpy( buf, "01/01/2008 00:00" );
            do {
                DispBuf( buf );
                CursorBlink( 0, i );
                while( (kkk=testKey()) == KNULL );
                if ( kkk >= K_0 && kkk <= K_9 )
                {                           // inserimento data/ora
                    buf[i++] = '0'+(kkk-K_0);
                    if ( i == 2 || i == 5 || i == 10 || i == 13 )
                        i++;
                    if ( i > 15 )
                        i = 0;
                }
                if ( kkk == K_ENTER || kkk == K_RESET || kkk == K_G )
                {
                    dateTime.day   = atoi(&buf[ 0]);
                    dateTime.month = atoi(&buf[ 3]);
                    dateTime.year  = atoi(&buf[ 6]);
                    dateTime.hour  = atoi(&buf[11]);
                    dateTime.min   = atoi(&buf[14]);
                    if ( dateTime.day == 0 || dateTime.day > 31 ||
                         dateTime.month == 0 || dateTime.month > 12 ||
                         dateTime.year < 2008 ||   
                         dateTime.hour > 23 ||
                         dateTime.min > 59 )
                    {
                        BuzzerOn(500);
                        i = 0;
                    }
                    else
                        break;
                }
            } while( -1 );
            CursorOff();
        }
        else
        {
            dateTime.day = 1;
            dateTime.month = 1;
            dateTime.year = 2009;
            dateTime.hour = 0;
            dateTime.min = 0;
            dateTime.sec = 0;
        }
        sendDate( &dateTime );
    }

    DispBuf( "TEST DATE/TIME: " );
    do {
        recvDate(&dateTime);
        i = dateTime.sec;
        Delay(3000);
        recvDate(&dateTime);
        if ( dateTime.sec >= i )
            i = dateTime.sec-i;
        else
            i = dateTime.sec+60-i;
    
        if ( i >= 2 && i <= 4 )
            break;

        DispBuf( "DATE/TIME: FAIL " );
        BuzzerOn(10);
    } while(-1);

    DispBuf( "DATE/TIME:  OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testDateTime




/*--------------------------------------------------------------------------
 | testDoor:    test door status
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testDoor ( void )
{
    byte        i, j;

//    BuzzerOn(50);

    j = 0;
    for ( i = 0 ; i < 5; )
    {
        if ( doorOpen() )
        {
            DispBuf( "CLOSE DOOR   (1)" );
            if ( j == 2 )
                j = 3;
            else
                j = 1;
            if ( i == 3 )
                break;
        }
        else
        {
            DispBuf( "OPEN DOOR    (0)" );
            if ( j == 1 )
                j = 3;
            else
                j = 2;
        }
        if ( j == 3 )
        {
            i++;
            j = 0;
        }
    }
    DispBuf( "TEST DOOR:  OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testDoor




/*--------------------------------------------------------------------------
 | testFallSensor:test fall sensor
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

const BOOL      enFallSensor[] = 
{
    TRUE,                               // #define MACHINA_AP113     0  *
    TRUE,                               // #define MACHINA_NAT147    1  *
    TRUE,                               // #define MACHINA_ROWE5900  2  *
    FALSE,                              // #define MACHINA_ROWE6800  3
    TRUE,                               // #define MACHINA_NAT157    4  *
    TRUE,                               // #define MACHINA_AP7000    5  *
    TRUE,                               // #define MACHINA_LCM123    6  *
    TRUE,                               // #define MACHINA_AP123     7  *
    TRUE,                               // #define MACHINA_VEIDOOR   8  *
    TRUE,                               // #define MACHINA_NAT145    9  *
    TRUE,                               // #define MACHINA_AMS39     10 *
    TRUE,                               // #define MACHINA_VEI147    11 *
    FALSE,                              // #define MACHINA_USIGVC2   12
    FALSE,                              // #define MACHINA_MERCHA6   13
    TRUE,                               // #define MACHINA_VEILCM    14 *
};

BOOL            testFallSensor ( void )
{
    byte        i, j;

    if ( machineType > TOTAL_MACHINE || enFallSensor[machineType] == FALSE )
        return TRUE;
/*
    if ( machineType != MACHINA_VEIDOOR && 
         machineType != MACHINA_AP123 && 
         machineType != MACHINA_AP113 && 
         machineType != MACHINA_LCM123 && 
         machineType != MACHINA_NAT145 && 
         machineType != MACHINA_NAT147 && 
         machineType != MACHINA_AP7000 && 
         machineType != MACHINA_NAT157 &&
         machineType != MACHINA_AMS39  &&
         machineType != MACHINA_VEI147 )
        return TRUE;
*/
    
    j = 0;
    for ( i = 0 ; i < 3; )
    {
        if ( FALL_SENSOR && j == 0 )
        {
            i++;
            DispBuf( "WAIT            " );
            Delay(500);
            j = 1;
        }
        else
        {
            if ( !FALL_SENSOR )
                j = 0;
            DispBuf( "TEST FALL SENSOR" );
        }
    }
    DispBuf( "FALL SENSOR:OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testFallSensor




/*--------------------------------------------------------------------------
 | testMenuSwitch:    test door status
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testMenuSwitch ( void )
{
    byte        i, j;

//    BuzzerOn(50);

    j = 0;
    for ( i = 0 ; i < 4; )
    {
        if ( MenuSwitch() )
        {
            DispBuf( "REL. MENU SWITCH" );
            if ( j == 2 )
                j = 3;
            else
                j = 1;
        }
        else
        {
            DispBuf( "PRESS MENU SWITC" );
            if ( j == 1 )
                j = 3;
            else
                j = 2;
            if ( i == 2 )
                break;
        }
        if ( j == 3 )
        {
            i++;
            j = 0;
        }
    }
    DispBuf( "MENU SWITCH: OK " );
    Delay_200( );
    return TRUE;
}                                               //  testMenuSwitch




/*--------------------------------------------------------------------------
 | testI_O:     test complete I/O functionality
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

const struct { 
    byte        an;
    byte        k;
    byte        mask0,mask1;
} tabAN_K[] = {
    {   0,      0,      0x01,0x00   },  // 0
    {   1,      1,      0x02,0x00   },  // 1
    {   2,      2,      0x04,0x00   },  // 2
    {   3,      3,      0x08,0x00   },  // 3
    {   4,      4,      0x10,0x00   },  // 4
    {   5,      5,      0x20,0x00   },  // 5
    {   9,      6,      0x40,0x00   },  // 6
    {   8,      7,      0x80,0x00   },  // 7
    {   7,      0xFF,   0x00,0x10   },  // 8
    {   6,      0xFF,   0x00,0x10   },  // 9
    {   0xFF,   0xFF,   0x00,0x10   },  // 0
};

BOOL            testI_O ( void )
{
    byte        i, image[3][2], fail, mask, an;
    char        buf[20];
    DWORD       tStartMotor;

    STOP_MOTORS();

    if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 )  // || machineType == MACHINA_MERCHA6  da verificare
    {
        // AN...
        for ( i = 0; i <= 15; i++ )
        {
            if ( i == 12 )
                continue;//12 doesn't exist
            sprintf( buf, "TEST I/O%2d:     ", i );
            DispBuf( buf );

            if ( i == 0 )
                mask = 0x04;
            else if ( i == 1 )
                mask = 0x02;
            else if ( i == 2 )
                mask = 0x20;
            else if ( i == 3 )
                mask = 0x10;
            else
                mask = 0;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x80;// tutto disattivo deve essere 1
            image[0][1] = inImage[2]&mask;

            // attiva catodo
            ATTIVA_CATODO( i );
            Delay(30);
            image[1][0] = inImage[2]&0x80;// attiva catodo diventa 0
            for ( fail = 0; fail < 100 && image[1][0] != 0x00; fail++ )
            {
//                BuzzerOn(5);
                Delay_50();
                image[1][0] = inImage[2]&0x80;
            }

            // attiva anodo
            if( i <= 4 )
            {
                outImage[OUT_AN0_AN7  ] &= ~(0x01<< i);
                Delay(30);
                image[2][0] = inImage[2]&0x80;// attiva anodo ridiventa 1
                image[1][1] = inImage[2]&mask;
            }   

            PWR_EN_OFF();
            STOP_MOTORS();

            fail = FALSE;
            if( i <= 4 )
            {
                if ( image[0][0] != 0x80 || image[1][0] != 0x00 || image[2][0] != 0x80 || 
                     (mask != 0x00 && (image[0][1] != 0x00 || image[1][1] != mask) ) )
                    fail = TRUE;
            }
            else
            {
                if ( image[0][0] != 0x80 || image[1][0] != 0x00 )
                    fail = TRUE;
            }
            if ( fail )
            {
                sprintf( buf, "%d %2x  %2x  %2x   ", i, image[0][0], image[1][0], image[2][0] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i--;//i = 0xFF;
            }

        }
    }
    else if ( machineType == MACHINA_AP7000 )
    {
        // AN...
        for ( i = 0; i <= 9; i++ )
        {
            sprintf( buf, "TEST I/O%2d:     ", i );
            DispBuf( buf );

            outImage[OUT_SG8_SG15 ] = 0xC0;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x20;// tutto disattivo deve essere 1

            // attiva catodo
            ATTIVA_CATODO( i );

            Delay(30);
            image[1][0] = inImage[2]&0x20;// attiva catodo diventa 0
            for ( fail = 0; fail < 100 && image[1][0] != 0x00; fail++ )
            {
//                BuzzerOn(5);
                Delay_50();
                image[1][0] = inImage[2]&0x20;
            }

            // attiva anodo
            ATTIVA_ANODO( i );
            Delay(30);
            image[2][0] = inImage[2]&0x20;// attiva anodo ridiventa 1

            PWR_EN_OFF();
            STOP_MOTORS();
            outImage[OUT_SG8_SG15 ] = 0xC0;
            Delay(10);

            fail = FALSE;
            if ( image[0][0] != 0x20 || image[1][0] != 0x00 || image[2][0] != 0x20 )
                fail = TRUE;
            if ( fail )
            {
                sprintf( buf, "%d %2x  %2x  %2x   ", i, image[0][0], image[1][0], image[2][0] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i--;//i = 0xFF;
            }

        }
    }
    else if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 )
    {
        // AN...
        for ( i = 0; i <= 13; i++ )
        {
            sprintf( buf, "TEST I/O%2d:     ", i );
            DispBuf( buf );

            outImage[OUT_SG8_SG15 ] = 0xC0;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x04;// tutto disattivo deve essere 1

            // attiva catodo
            ATTIVA_CATODO( i );
            Delay(100);
            image[1][0] = inImage[2]&0x04;// attiva catodo diventa 0


#if VERSIONE_642E
            an = i;
#else
            if ( i == 5 || i == 6 )
                an = 9;// non collegato
            else if ( i == 7 || i == 8 || i == 9 )
                an = i-2;
            else
                an = i;
#endif
            // attiva anodo
            ATTIVA_ANODO( an );
            Delay(100);
            image[2][0] = inImage[2]&0x04;// attiva anodo ridiventa 1

            PWR_EN_OFF();
            STOP_MOTORS();

            fail = FALSE;
            if ( i != 5 && i != 6 && i <= 9 )
            {
                if ( image[0][0] != 0x04 || image[1][0] != 0x00 || image[2][0] != 0x04 )
                    fail = TRUE;
            }
            else
            {
                if ( image[0][0] != 0x04 || image[1][0] != 0x00 || image[2][0] != 0x00 )
                    fail = TRUE;
            }
            if ( fail )
            {
                sprintf( buf, "%d %2x%2x%2x%2x%2x%2x ", i, image[0][0],image[0][1], image[1][0],image[1][1], image[2][0],image[2][1] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i--;//i = 0xFF;
            }

        }
    }
    else if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_LCM123 ||  machineType == MACHINA_VEILCM )
    {
        // AN...
        for ( i = 0; i <= 9; i++ )
        {
            sprintf( buf, "TEST I/O%2d:     ", i+1 );
            DispBuf( buf );

            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x04;// tutto disattivo deve essere 1

            // attiva catodo
            ATTIVA_CATODO( i );
            Delay(100);
            image[1][0] = inImage[2]&0x04;// attiva catodo diventa 0

            // attiva anodo
            if( i <= 7 )
                outImage[OUT_AN0_AN7  ] &= ~(0x01<< i);
            Delay(100);
            image[2][0] = inImage[2]&0x04;// attiva anodo ridiventa 1

            PWR_EN_OFF();
            STOP_MOTORS();

            fail = FALSE;
            if ( i <= 7 )
            {
                if ( image[0][0] != 0x04 || image[1][0] != 0x00 || image[2][0] != 0x04 )
                    fail = TRUE;
            }
            else
            {
                if ( image[0][0] != 0x04 || image[1][0] != 0x00 || image[2][0] != 0x00 )
                    fail = TRUE;
            }
            if ( fail )
            {
                sprintf( buf, "%d %2x%2x%2x%2x%2x%2x ", i, image[0][0],image[0][1], image[1][0],image[1][1], image[2][0],image[2][1] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i = 0xFF;
            }

        }
    }
    else if ( machineType == MACHINA_AMS39 )
    {
        // AN...
        for ( i = 0; i <= 10; i++ )
        {
            sprintf( buf, "TEST I/O%2d:     ", i );
            DispBuf( buf );

            outImage[OUT_SG8_SG15 ] = 0xC0;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x04;// tutto disattivo deve essere 1

            // attiva catodo
            ATTIVA_CATODO( (( i > 7 )?i+3:i ) );
            Delay(100);
            image[1][0] = inImage[2]&0x04;// attiva catodo diventa 0

            // attiva anodo
            if( i < 10 )
            {
                ATTIVA_ANODO( i );
                Delay(100);
                image[2][0] = inImage[2]&0x04;// attiva catodo diventa 1
            }
            else
                image[2][0] = 0x04;

            PWR_EN_OFF();
            STOP_MOTORS();

            if ( image[0][0] != 0x04 || image[1][0] != 0x00 || image[2][0] != 0x04 )
            {
                sprintf( buf, "%d %2x%2x%2x ", i, image[0][0], image[1][0], image[2][0] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i--;//i = 0xFF;
            }
        }      
    }
    else if ( machineType == MACHINA_USIGVC2 )
    {
        // AN...
        for ( i = 0; i < 10; i++ )
        {
            testMode = 0x47681022;
            countDown = 30000;//30s
            
            sprintf( buf, "TEST I/O%2d:     ", i );
            DispBuf( buf );

            outImage[OUT_COIN_BILL] = 0xC0;
            outImage[OUT_SG8_SG15 ] = 0xC0;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2]&0x01;// tutto disattivo deve essere 1

            // attiva catodo
            if ( i == 8 )
                outImage[OUT_COIN_BILL] = 0x80;
            else if ( i == 9 )
                outImage[OUT_COIN_BILL] = 0x40;
            else
                ATTIVA_CATODO( (( i == 7 )?11:i ) );
            Delay(100);
            image[1][0] = inImage[2]&0x01;// attiva catodo diventa 0

            // attiva anodo
            ATTIVA_ANODO( i );
            Delay(100);
            image[2][0] = inImage[2]&0x01;// attiva catodo diventa 1

            PWR_EN_OFF();
            STOP_MOTORS();
            outImage[OUT_COIN_BILL] = 0x00;

            if ( image[0][0] != 0x01 || image[1][0] != 0x00 || image[2][0] != 0x01 )
            {
                sprintf( buf, "%d %2x%2x%2x ", i, image[0][0], image[1][0], image[2][0] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i--;//i = 0xFF;
            }
/*eee            
            i--;//i = 0xFF;
            Delay_200( );
            eee*/
        }      
    }
    else  // ROWE
    {
        // AN...
        for ( i = 0; i <= 9; i++ )
        {
            sprintf( buf, "TEST I/O%2d:     ", i+1 );
            DispBuf( buf );

            outImage[OUT_COIN_BILL] = 0xFF;
            PWR_EN_ON();
            Delay(100);
            image[0][0] = inImage[2];
            image[0][1] = inImage[3];
            //
            if( tabAN_K[i].an <= 7 )
                outImage[OUT_AN0_AN7  ] &= ~(0x01<< tabAN_K[i].an);
            else
                outImage[OUT_SG8_SG15 ] &= ~(0x40<<(tabAN_K[i].an-8));
            Delay(100);
            image[1][0] = inImage[2];
            image[1][1] = inImage[3];
    #if 0
            sprintf( buf, "AN%d = %2x%2x%2x%2x  ", i, inImage[0], inImage[1], inImage[2], inImage[3] );
            DispBuf( buf );
            while( testKey() == KNULL );
    #endif
            
            if ( tabAN_K[i].k != 0xFF )
            {
                if ( tabAN_K[i].k <= 7 )
                    outImage[OUT_SG0_SG7  ] |=  (0x01<< tabAN_K[i].k);
                else
                    outImage[OUT_SG8_SG15 ] |=  (0x01<<(tabAN_K[i].k-8));
            }
            Delay(100);
            image[2][0] = inImage[2];
            image[2][1] = inImage[3];
            PWR_EN_OFF();
    #if 0
            sprintf( buf, "AN%d = %2x%2x%2x%2x  ", i, inImage[0], inImage[1], inImage[2], inImage[3] );
    //            sprintf( buf, "%d %2x%2x%2x%2x%2x%2x ", i, image[0][0],image[0][1], image[1][0],image[1][1], image[2][0],image[2][1] );
            DispBuf( buf );
    #endif
            STOP_MOTORS();
    #if 0
            while( testKey() == KNULL );
    #endif
            fail = FALSE;
            if ( tabAN_K[i].k != 0xFF )
            {
                if ( image[0][0] != 0x00                || (image[0][1]&BIT4)   != 0x00              || 
                     image[1][0] != tabAN_K[i].mask0    || (image[1][1]&BIT4)   != tabAN_K[i].mask1  || 
                     image[2][0] != 0x00                || (image[2][1]&BIT4)   != 0x00 )
                    fail = TRUE;
            }
            else
            {
                if ( image[0][0] != 0x00                || (image[0][1]&BIT4) != 0x00              || 
                     image[1][0] != tabAN_K[i].mask0    || (image[1][1]&BIT4) != tabAN_K[i].mask1  || 
                     image[2][0] != tabAN_K[i].mask0    || (image[2][1]&BIT4) != tabAN_K[i].mask1 )
                    fail = TRUE;
            }
            if ( fail )
            {
                sprintf( buf, "%d %2x%2x%2x%2x%2x%2x ", i, image[0][0],image[0][1], image[1][0],image[1][1], image[2][0],image[2][1] );
                DispBuf( buf );
                BuzzerOn(200);
                while( testKey() == KNULL );                
                i = 0xFF;
            }
        }
    }


    DispBuf( "TEST I/O:   OK  " );
    Delay_200( );
    tStartMotor = tStartMotor;
    return TRUE;
}                                               //  testI_O




/*--------------------------------------------------------------------------
 | testAN_K:    test complete I/O functionality
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testAN_K ( void )
{
    byte        i, image[3][2], fail;
    char        buf[20];
    DWORD       tStartMotor;

    STOP_MOTORS();

    // AN...
    for ( i = 0; i <= 13; i++ )
    {
        sprintf( buf, "TEST I/O%2d:     ", i );
        DispBuf( buf );

        outImage[OUT_SG8_SG15 ] = 0xC0;
        PWR_EN_ON();
        Delay(25);
        image[0][0] = (IO1PIN & BIT19)?1:0; // tutto disattivo deve essere 1
        image[0][1] = (IO1PIN & BIT18)?1:0; // tutto disattivo deve essere o

        // attiva catodo
        ATTIVA_CATODO( i );
        Delay(25);
        image[1][0] = (IO1PIN & BIT19)?1:0;  // attiva catodo diventa 0
        image[1][1] = (IO1PIN & BIT18)?1:0;  // attiva catodo diventa 1

        // attiva anodo
        ATTIVA_ANODO( i );
        Delay(25);
        image[2][0] = (IO1PIN & BIT19)?1:0;  // attiva anodo ridiventa 1
        image[2][1] = (IO1PIN & BIT18)?1:0;  // attiva anodo ridiventa 0

        PWR_EN_OFF();
        STOP_MOTORS();

        fail = FALSE;
        if ( i <= 9 )
        {
            if ( image[0][0] != 1 || image[1][0] != 0 || image[2][0] != 1 ||
                 image[0][1] != 0 || image[1][1] != 1 || image[2][1] != 0    )
                fail = TRUE;
        }
        else
        {
            if ( image[0][0] != 1 || image[1][0] != 0 || image[2][0] != 0 ||
                 image[0][1] != 0 || image[1][1] != 1 || image[2][1] != 1    )
                fail = TRUE;
        }
        if ( fail )
        {
            sprintf( buf, "K%02d - %d%d %d%d %d%d  ", i, image[0][0],image[0][1], image[1][0],image[1][1], image[2][0],image[2][1] );
            DispBuf( buf );
            BuzzerOn(10);
            Delay(1000);
            i--;
        }
    }

    DispBuf( "TEST I/O:   OK  " );
    Delay_200( );
    tStartMotor = tStartMotor;
    return TRUE;
}                                               //  testAN_K




/*--------------------------------------------------------------------------
 | testMICROMECH:check micromech I/O
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/
extern dword compressoreOFF;

const char tabMICRO_AP113[8][6] = {
    {   '1','1','/','1','4','\0'    },
    {   '1','1','/','1','3','\0'    },
    {   '1','1','/','1','2','\0'    },
    {   '1','1','/','7',' ','\0'    },
    {   '1','1','/','9',' ','\0'    },
    {   '1','1','/','8',' ','\0'    },
    {   '1','1','/','1','5','\0'    },
    {   '6','/','6',' ',' ','\0'    },
};

static BOOL testPin( byte _mask1, byte _mask2, byte *_pin, byte _mask )
{
    outImage[OUT_COIN_BILL] = _mask1;   Delay(20);  _pin[0] = inImage[2]&_mask;
    outImage[OUT_COIN_BILL] = _mask2;   Delay(20);  _pin[1] = inImage[2]&_mask;
    outImage[OUT_COIN_BILL] = _mask1;   Delay(20);  _pin[2] = inImage[2]&_mask;
    outImage[OUT_COIN_BILL] = _mask2;   Delay(20);  _pin[3] = inImage[2]&_mask;
    
    if ( _pin[0] == _pin[2] && _pin[1] == _pin[3] && _pin[0] != _pin[1] )
        return TRUE;
    return FALSE;
}

BOOL            testMICROMECH ( void )
{
    byte        i, pin[4];
    char        buf[20];

    if ( machineType == MACHINA_USIGVC2 )
        return TRUE;
    
    testMode = 0x47681022;
    countDown = 30000;//30s

    if ( machineType == MACHINA_NAT157 ||  machineType == MACHINA_VEI147 || machineType == MACHINA_MERCHA6 ) // || machineType == MACHINA_MERCHA6 da verificare
    {
        for ( i = 0; i < 8; i++ )
        {
            sprintf( buf, "TEST %d: CN7/CN18 ", i );
            DispBuf( buf );
            do {
                if ( testPin( (BIT0<<i), 0x00, &pin[0], (i==7)?0x40:0x08 ) )
                    break;

                sprintf( buf, "%02x >>> %02x %02x %02x ", (BIT0<<i), pin[0], pin[1], pin[2] );
                DispBuf( buf );
                BuzzerOn(10);
                Delay(500);
            } while(-1);
        }
    }
    else if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP7000 )
    {
        for ( i = 0; i < 8; i++ )
        {
            sprintf( buf, "TEST %d: CN5/CN10", i );
            DispBuf( buf );
            if ( (machineType == MACHINA_NAT145||machineType == MACHINA_NAT147 ) && i == 4 )
                continue;//salta test send e data
            if ( machineType == MACHINA_AP7000 && (i == 6 || i == 7) )
                continue;//salta test send e data
            do {
                if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 )
                {
                    if ( testPin( (BIT0<<i), 0x00, &pin[0], (i==5)?0x01:((i==6)?0x80:((i==7)?0x02:0x08) ) ) )
                        break;
                }
                else
                {
                    if ( testPin( (BIT0<<i), 0x00, &pin[0], 0x08 ) )
                        break;
                }

                sprintf( buf, "%02x %02x %02x %s", pin[0], pin[1], pin[2], tabMICRO_AP113[i] );
                DispBuf( buf );
                BuzzerOn(10);
                Delay(500);
            } while(-1);
        }
    }
    else if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_LCM123 || machineType == MACHINA_VEIDOOR )
    {
        DispBuf( "TEST CN11/14:   " );
        for ( i = 0; i < ((machineType==MACHINA_AP123||machineType==MACHINA_VEIDOOR)?7:8); i++ )
        {
            do {
                if ( i == 6 && machineType == MACHINA_LCM123 )
                {
                    outImage[OUT_SG8_SG15 ] ^=(0x01<<(10-8)); Delay_50();      pin[0] = inImage[2]&0x08;
                    outImage[OUT_SG8_SG15 ] ^=(0x01<<(10-8)); Delay_50();      pin[1] = inImage[2]&0x08;
                    outImage[OUT_SG8_SG15 ] ^=(0x01<<(10-8)); Delay_50();      pin[2] = inImage[2]&0x08;
                    outImage[OUT_SG8_SG15 ] ^=(0x01<<(10-8)); Delay_50();      pin[3] = inImage[2]&0x08;
                }
                else
                {
                    outImage[OUT_COIN_BILL] = 0x00+(BIT0<<i); Delay_50();      pin[0] = inImage[2]&0x08;
                    outImage[OUT_COIN_BILL] = 0x00;           Delay_50();      pin[1] = inImage[2]&0x08;
                    outImage[OUT_COIN_BILL] = 0x00+(BIT0<<i); Delay_50();      pin[2] = inImage[2]&0x08;
                    outImage[OUT_COIN_BILL] = 0x00;           Delay_50();      pin[3] = inImage[2]&0x08;
                }
        
                if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
                    break;
        
//                sprintf( buf, "TEST CN%s:FAI", tabMICRO_AP113[i] );
                sprintf( buf, "%02x %02x %02x %s", pin[0], pin[1], pin[2], tabMICRO_AP113[i] );
                DispBuf( buf );
                BuzzerOn(10);
                Delay(500);
            } while(-1);
            sprintf( buf, "TEST CN%s: OK", tabMICRO_AP113[i] );
            DispBuf( buf );
        }
    }
    else if ( machineType == MACHINA_AMS39 )
    {
       compressoreOFF = 10000L;     // impedisce gestione uscita compressora da parte dell'interupt
       DispBuf( "TEST CN7/16/17  " );
       do {
            i = 1;
            BuzzerOn(10);
            Delay(500);
            outImage[OUT_COIN_BILL] = 0x00; Delay_50();      pin[0] = inImage[2]&0x0A;
            if( ( pin[0] & 0x02 ) != 0x02 )  { DispBuf( "TEST CN7/1: FAIL" ); continue; }
            if( ( pin[0] & 0x08 ) != 0x08 )  { DispBuf( "TEST CN7/4: FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x02; Delay_50();      pin[0] = inImage[2]&0x0A; // CN16/7 - CN7/1
            if( pin[0] != 0x02 )  { DispBuf( "TEST CN16/7:FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x04; Delay_50();      pin[0] = inImage[2]&0x0A; // CN16/2 - CN7/1
            if( pin[0] != 0x02 )  { DispBuf( "TEST CN16/2:FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x08; Delay_50();      pin[0] = inImage[2]&0x0A; // CN16/6 - CN7/1
            if( pin[0] != 0x02 )  { DispBuf( "TEST CN16/6:FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x10; Delay_50();      pin[0] = inImage[2]&0x0A; // CN16/4 - CN7/1
            if( pin[0] != 0x02 )  { DispBuf( "TEST CN16/4:FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x80; Delay_50();      pin[0] = inImage[2]&0x0A; // CN17/6 - CN7/4 - CN7/1
            if( pin[0] != 0x00 )  { DispBuf( "TEST CN17/6:FAIL" ); continue; }
            outImage[OUT_COIN_BILL] = 0x00;
            i = 0;
        } while( i );
        DispBuf( "TESTCN7/16/17:OK" );
    }
    else {  // ROWE
////
        DispBuf( "TEST CN7/1:     " );
        do {
            outImage[OUT_COIN_BILL] = 0x7F; Delay_50();      pin[0] = inImage[3]&0x20;
            outImage[OUT_COIN_BILL] = 0xFF; Delay_50();      pin[1] = inImage[3]&0x20;
            outImage[OUT_COIN_BILL] = 0x7F; Delay_50();      pin[2] = inImage[3]&0x20;
            outImage[OUT_COIN_BILL] = 0xFF; Delay_50();      pin[3] = inImage[3]&0x20;
            
            if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
                break;
    
            DispBuf( "TEST CN7/1: FAIL" );
            BuzzerOn(10);
            Delay(500);
        } while(-1);
        DispBuf( "TEST CN7/1:  OK " );
////
        DispBuf( "TEST CN7/2:     " );
        do {
            outImage[OUT_COIN_BILL] = 0xBF; Delay_50();      pin[0] = inImage[3]&0x02;
            outImage[OUT_COIN_BILL] = 0xFF; Delay_50();      pin[1] = inImage[3]&0x02;
            outImage[OUT_COIN_BILL] = 0xBF; Delay_50();      pin[2] = inImage[3]&0x02;
            outImage[OUT_COIN_BILL] = 0xFF; Delay_50();      pin[3] = inImage[3]&0x02;
    
            if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
                break;
    
            DispBuf( "TEST CN7/2: FAIL" );
            BuzzerOn(10);
            Delay(500);
        } while(-1);
        DispBuf( "TEST CN7/2:  OK " );
////
        DispBuf( "TEST CN10/1:    " );
        for ( i = 0; i < 6; i++ )
        {
            do {
                outImage[OUT_COIN_BILL] = 0xC0+(BIT0<<i); Delay_50();      pin[0] = inImage[3]&0x08;
                outImage[OUT_COIN_BILL] = 0xC0;           Delay_50();      pin[1] = inImage[3]&0x08;
                outImage[OUT_COIN_BILL] = 0xC0+(BIT0<<i); Delay_50();      pin[2] = inImage[3]&0x08;
                outImage[OUT_COIN_BILL] = 0xC0;           Delay_50();      pin[3] = inImage[3]&0x08;
        
                if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
                    break;
        
                sprintf( buf, "TEST CN10/%d:FAIL", i+1 );
                DispBuf( buf );
                BuzzerOn(10);
                Delay(500);
            } while(-1);
            sprintf( buf, "TEST CN10/%d: OK ", i+1 );
            DispBuf( buf );
        }
////
    }

    DispBuf( "TEST COIN:  OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testMICROMECH




/*--------------------------------------------------------------------------
 | testDIG_I_O: check micromech I/O
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

const byte      tabDig_I_O[8][2] = 
{
    {   BIT0,   BIT3    },
    {   BIT1,   BIT2    },
    {   BIT2,   BIT1    },
    {   BIT3,   BIT0    },
    {   BIT4,   BIT7    },
    {   BIT5,   BIT6    },
    {   BIT6,   BIT5    },
    {   BIT7,   BIT4    },
};

BOOL            testDIG_I_O ( void )
{
    byte        i, pin[4];
    char        buf[LCDCOL+1];

                                        // CN4 PIN49-PIN48
    do {
        IO0SET = BIT29;             Delay(20);          pin[0] = ((IO0PIN&BIT0)!=0);
        IO0CLR = BIT29;             Delay(20);          pin[1] = ((IO0PIN&BIT0)!=0);
        IO0SET = BIT29;             Delay(20);          pin[2] = ((IO0PIN&BIT0)!=0);
        IO0CLR = BIT29;             Delay(20);          pin[3] = ((IO0PIN&BIT0)!=0);

        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "TEST CN4-48 & 49" );
        BuzzerOn(10);
        Delay(500);
    } while(-1);

                                        // CN4 PIN50-PIN46
    do {
        IO0SET = BIT30;             Delay(20);          pin[0] = ((IO1PIN&BIT21)!=0);
        IO0CLR = BIT30;             Delay(20);          pin[1] = ((IO1PIN&BIT21)!=0);
        IO0SET = BIT30;             Delay(20);          pin[2] = ((IO1PIN&BIT21)!=0);
        IO0CLR = BIT30;             Delay(20);          pin[3] = ((IO1PIN&BIT21)!=0);

        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "TEST CN4-46 & 50" );
        BuzzerOn(10);
        Delay(500);
    } while(-1);

                                        // segnali micromech    
    for ( i = 0; i < 8; i++ )
    {
        sprintf( buf, "TEST CN4 %2d & %2d", 27+i, 35+i );
        DispBuf( buf );
        do {
            if ( testPin( tabDig_I_O[i][0], 0x00, &pin[0], tabDig_I_O[i][1] ) )
                break;

            BuzzerOn(10);
            sprintf( buf, "TEST CN4 %2d & %2d", 27+i, 35+i );
//            Delay(500);
//            outImage[OUT_COIN_BILL] = tabDig_I_O[i][0];   DelayShort(); 
//            sprintf( buf, "%02x%02x%02x > %02x %02x %02x ", tabDig_I_O[i][0], tabDig_I_O[i][1], inImage[2], pin[0], pin[1], pin[2] );
            DispBuf( buf );
            Delay(500);
        } while(-1);
    }

    DispBuf( "TEST COIN:  OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testDIG_I_O




/*--------------------------------------------------------------------------
 | testSDcard:  verifica funzionamento SD card
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            testSDcard ( void )
{
    byte        pin[8];

    IO0SET = BIT30;
    IO0SET = BIT29;
    DispBuf( "TEST SDcard:card" );
    if ( mmcInit() == mmc_noerr )
    {
        DispBuf( "TEST SDcard:OK  " );
        Delay_200( );
        return TRUE;
    }
                                        // test SD card with PIN

	PCONP &= ~BIT28;                    // disable MCI
    Delay_50();
    PINSEL4 = 0x00000000;
    PINSEL1 = 0x01654001;
    IO0DIR  = 0x7C6E85F0;               // 01111100 01101110 10000101 11110000
    IO0CLR = BIT30;
    IO0CLR = BIT29;
    IO0CLR = BIT22;
    IO0CLR = BIT19;
    DispBuf( "TEST SDcard:pin " );
/*
                                        // CN1 PIN2-PIN4
    do {
        IO0SET = BIT21;             Delay(20);          pin[0] = ((IO0PIN&BIT20)!=0);
        IO0CLR = BIT21;             Delay(20);          pin[1] = ((IO0PIN&BIT20)!=0);
        IO0SET = BIT21;             Delay(20);          pin[2] = ((IO0PIN&BIT20)!=0);
        IO0CLR = BIT21;             Delay(20);          pin[3] = ((IO0PIN&BIT20)!=0);

        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "TEST CN1- 2 & 4 " );
//        BuzzerOn(100);
        Delay(500);
    } while(-1);
*/
                                        // CN1 PIN7-PIN8
    do {
        IO0SET = BIT22;             Delay(20);          pin[0] = ((FIO2PIN&BIT11)!=0);
        IO0CLR = BIT22;             Delay(20);          pin[1] = ((FIO2PIN&BIT11)!=0);
        IO0SET = BIT22;             Delay(20);          pin[2] = ((FIO2PIN&BIT11)!=0);
        IO0CLR = BIT22;             Delay(20);          pin[3] = ((FIO2PIN&BIT11)!=0);

        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] )
            break;

        DispBuf( "TEST CN1- 7 & 8 " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);
                                        // CN1 PIN1-PIN5-PIN9
    do {
        IO0SET = BIT19;             Delay(20);          pin[0] = ((FIO2PIN&BIT12)!=0);          pin[4] = ((FIO2PIN&BIT13)!=0);
        IO0CLR = BIT19;             Delay(20);          pin[1] = ((FIO2PIN&BIT12)!=0);          pin[5] = ((FIO2PIN&BIT13)!=0);
        IO0SET = BIT19;             Delay(20);          pin[2] = ((FIO2PIN&BIT12)!=0);          pin[6] = ((FIO2PIN&BIT13)!=0);
        IO0CLR = BIT19;             Delay(20);          pin[3] = ((FIO2PIN&BIT12)!=0);          pin[7] = ((FIO2PIN&BIT13)!=0);

        if ( pin[0] == pin[2] && pin[1] == pin[3] && pin[0] != pin[1] &&
             pin[4] == pin[6] && pin[5] == pin[7] && pin[4] != pin[5] )
            break;

        DispBuf( "TEST CN1- 1&5&9 " );
        BuzzerOn(10);
        Delay(500);
    } while(-1);

    DispBuf( "TEST SDcard:OK  " );
    Delay_200( );
    return TRUE;
}                                               //  testSDcard


/*--------------------------------------------------------------------------
 | testNTC:   test temperature sensor
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            testNTC ( void )
{
    char        buf[20];

    if( machineType == MACHINA_AMS39 )
    {
        do {
            sprintf( buf, " TEMPERAT.  %3dF", Temperatura/100 );                  
            DispBuf( buf );
            Delay(500);
        } while( Temperatura < 32L*100L || Temperatura > 120L*100L );
        DispBuf( "TEST NTC: OK    " );
        Delay_200( );
    }
    else if( machineType == MACHINA_USIGVC2 )
    {
        countDown = 0;
        do {
            sprintf( buf, " TEMP.1     %3dF", Temperatura/100 );                  
            DispBuf( buf );
            Delay(500);
        } while( Temperatura < 65L*100L || Temperatura > 95L*100L );
        do {
            sprintf( buf, " TEMP.2     %3dF", Temperatura/100 );                  
            DispBuf( buf );
            Delay(500);
        } while( Temperatura < 95L*100L || Temperatura > 125L*100L );
        DispBuf( "TEST NTC: OK    " );
        Delay_200( );
    }
}

/*--------------------------------------------------------------------------
 | testDiodi:   test diodi rsr765
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            testDiodi ( void )
{
//    char i;
    dword time, to;	
    
//    i = 0x00;
    time = timeMs;
    to = 5000;
    if( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEILCM ) 
    {
        DispBuf( "TEST DIODES:    " );
        IO1DIR  = 0x075C0000;               // 00000111 01011100 00000000 00000000    
        do {    
                if (timeMs != time) {
                    time = timeMs;
                    to--;
                }                    
                if (to%1000 < 500) 
                {
                    IO1SET_bit.P1_18 = 1;
                    IO1CLR_bit.P1_19 = 1;
                }
                else {
                    IO1CLR_bit.P1_18 = 1;
                    IO1SET_bit.P1_19 = 1;
                }
                if (to == 0)
                {
                    DispBuf( "TEST DIODES: OK " );
                    IO1DIR  = 0x07500000;               // 00000111 01010000 00000000 00000000
                    Delay(2000);
                    break;
                }
        } while(-1);    
    }
}


/*--------------------------------------------------------------------------
 | testBoard:   full board test
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#if ENABLE_DISCOUNT
void            discount_eraseCounter( void );
#endif

void            testBoard ( void )
{
    byte        cpAssetID[ASSET_ID_LEN+1], i, j, k, kkk;    // dex asset ID
    
    // verifica multimedia card: gia' fatto
#if TESTKEYBOARD
    testMode = 0x47681022;
    stopInt = 0;
    testBoardType();
    testDisplay();
    testKeyboard();// verifica anche livelli analogici !
    DispBuf( "TEST COMPLETED! " );
    while(-1);
#endif

    if ( !enableTest() )
        return;
    Delay(1000);
    testMode = 0x47681022;
    countDown = 30000;//30s
    stopInt = 0;

    testBoardType();
#if 0
    testDisplay();
    testBuzzer();
    testKeyboard();
    testMenuSwitch();
#else
    testDisplay();
    testBattery();
    testBuzzer();
    testLED();
    testSerial(COMM1);
// test alimentazione su CN8
    testRTS_CTS_maxStream();
    testSerial(COMM2);
// test CTS e RTS modulo xBee
    testSerial(COMM3);// collaudo MDB
    testGSM();
    testSPI0();
    testKeyboard();
    testDateTime(FALSE);
    testFallSensor();
    testMenuSwitch();
    testDoor();
    testI_O();
    testMICROMECH();
    testNTC();
    testDiodi();
#endif

    
    DispBuf( "RESTORE FACT SET" );
    while( (kkk=testKey()) == KNULL );  
    if (kkk == K_ENTER) 
    {
        memcpy( cpAssetID, NonVolatileSetup.assetID, sizeof(NonVolatileSetup.assetID) );
        initialSettings();
        initGroups();
        if ( cpAssetID[0] >= ' ' && cpAssetID[0] < 0xFF )
            memcpy( NonVolatileSetup.assetID, cpAssetID, sizeof(NonVolatileSetup.assetID) );
        saveSettings();
        saveGroup();
#if ENABLE_DISCOUNT
        discount_eraseCounter();
#endif
        memset( usable,     0xFF,   sizeof(usable)      );
        for (i=0;i<MAX_MACHINE_NUM;i++) {
            for (j=0;j<MAXTRAY;j++) {
                for (k=0;k<MAXCOLUMN;k++) {
                    amount[i][j][k] = 900;
                }
            }            
        }
        initGroups();
        saveAmount();
        saveGroup(); 
        initAudit();        
    }
        
    
    DispBuf( "TEST COMPLETED! " );
    
    
    while(-1);
}                                               //  testBoard







/*--------------------------------------------------------------------------
 | testIfJEEG:  CPU board test
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            msDelay( DWORD _ms )
{
    _ms *= 100000L;
    while( _ms-- > 0 )
        ;
}

BOOL            testIfJEEG ( void )
{
    byte        in16[6], in17[6];
    
    PINSEL10= 0x00000000;               // 00000000 00000000 00000000 00000000

    PINSEL1 = 0x01656A80;               // 00000001
                                        // xx         31 nc
                                        //   xx       30 port
                                        //     xx     29 port
                                        //       xx   28 scl0
                                        // 01100101
                                        // xx         27 sda0
                                        //   xx       26 aout
                                        //     xx     25 ad0.2 : tastiera esterna
                                        //       xx   24 ad0.1 : pwr mon
                                        // 01101010
                                        // xx         23 ad0.0 : imotor
                                        //   xx       22 mcidat0
                                        //     xx     21 mcipwr
                                        //       xx   20 mcicmd
                                        // 10000000
                                        // xx         19 mciclk
                                        //   xx       18 port                   CTS maxstream
                                        //     xx     17 port                   RTS maxstream
                                        //       xx   16 rxd1

    PINSEL0 = 0x005A8050;               // 00000000
                                        // xx         15 txd1
                                        //   xx       14 nc
                                        //     xx     13 nc
                                        //       xx   12 nc
                                        // 01011010
                                        // xx         11 rxd2
                                        //   xx       10 txd2
                                        //     xx     09 spi1 mosi
                                        //       xx   08 spi1 miso
                                        // 10000000
                                        // xx         07 spi sck
                                        //   xx       06 port                   spi0 mosi key
                                        //     xx     05 port                   spi0 miso key
                                        //       xx   04 port                   spi0 sck key
                                        // 01010000
                                        // xx         03 rxd0
                                        //   xx       02 txd0
                                        //     xx     01 port                   iic1 sck
                                        //       xx   00 port                   iic1 sda
    IO0DIR  = 0x7C7C85F0;               // 01111100 01111100 10000101 11110000
    IO0CLR  = 0xF3FFFF7F;               // 11111100 11111111 11111111 01111111
    IO0SET  = 0x00000080;               // 00000000 00000000 00000000 10000000

    IO0CLR = BIT15|BIT18;   msDelay(2); in16[0] = (IO0PIN & BIT16)?1:0; in17[0] = (IO0PIN & BIT17)?1:0;
    IO0SET = BIT18;         msDelay(2); in16[1] = (IO0PIN & BIT16)?1:0; in17[1] = (IO0PIN & BIT17)?1:0;
    IO0CLR = BIT15|BIT18;   msDelay(2); in16[2] = (IO0PIN & BIT16)?1:0; in17[2] = (IO0PIN & BIT17)?1:0;
    IO0SET = BIT15;         msDelay(2); in16[3] = (IO0PIN & BIT16)?1:0; in17[3] = (IO0PIN & BIT17)?1:0;
    IO0CLR = BIT15|BIT18;   msDelay(2); in16[4] = (IO0PIN & BIT16)?1:0; in17[4] = (IO0PIN & BIT17)?1:0;
    if ( in16[0] != 0 || in17[0] != 0 ||
         in16[1] != 1 || in17[1] != 0 ||
         in16[2] != 0 || in17[2] != 0 ||
         in16[3] != 0 || in17[3] != 1 ||
         in16[4] != 0 || in17[4] != 0 )
        return FALSE;

    return TRUE;
}                                               //  testIfJEEG







/*--------------------------------------------------------------------------
 | testCPU:     CPU board test
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

extern word            durataBuzzer;

void            SHORT_TIMER0_ISR( void )
{
#ifndef __WIN32__

    T0IR |= 0XFF;


    if ( durataBuzzer != 0 )
    {
        if ( --durataBuzzer == 0 )
            PWM1PCR = 0x0000;                   // 00100100  pwm2 out disabled
    }

    ADend();                            // A/D channel read
    timeMs++;                       // delay time
    if( countDown != 0 ) countDown--;	 // contatore down fino a zero da 1 ms

    ReadRx(inImage, 4);
    LOAD_SR();                          // latch nuovo ingresso
    OE_OUT_ENABLE();                    // abilita i dati inviati al precedente interrupt
    LATCH_OUT_SET();
    LATCH_OUT_CLR();
    sendSPI1( outImage, 4 ); // DEBUG : effettua invio e attende prossimo interrupt per attivare uscite !!

    AD0CR = 0x01200F04;                 // start conversion

    VICAddress = 0;                     // Clear interrupt in VIC.
#endif
}                                               //  TIMER0_ISR



void            testCPU ( void )
{
    char        buf[LCDCOL+1];
                                        // VERIFY IF CONDITION VALID .........
    if ( !testIfJEEG() )
        return;

                                        // INITIALIZATION ....................
    InitIOPorts();
                                        // Timer 0 interrupt
    VIC_SetVectoredIRQ(SHORT_TIMER0_ISR,VIC_Slot4,VIC_TIMER0);
    VIC_EnableInt(1<<VIC_TIMER0);
//  init timer
    T0TCR = 0X03;                       // counter reset
    T0IR  = 0XFF;                       // clear int flag
    T0CTCR = 0;                         //  00000000
                                        //        00  every rising PCLK
                                        //      00    -
                                        //  0000      -
    T0TC = 0;                           // clear counter
    T0PR = 0;                           // count@timer_clock
    T0PC = 0;                           // clear prescaler
    T0MCR = 0x00C0;                     // 00000000 11000000
                                        //        0 11        reset + int on TMR2
    T0MR2 = T_PERIODIC*(TIMER_CLOCK/1000)/1000; // 1000 us
    T0CCR = 0;
    T0EMR = 0X0100;                     //  00000001 00000000 out = 0
                                        //  0000             -
                                        //      00           EMC3 off
                                        //        01         EMC2 low out
                                        //          00       EMC1 off
                                        //            00     EMC0 off
                                        //              0000 -
    T0TCR = 0X01;                            // start counter
////
    InitTimer1();
    InitTimer2();
    LcdIIC0Init();
    AdcCpuInit();
    initSPI1();
    initSPI0();
    initSSP0();
    InitPwmTimer();
    lampOn();
    __enable_interrupt();
    machineType = MACHINA_ROWE5900;
    setContrastLCD(1);
    contrastInit();
    DispInit();
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    FIO3CLR_bit.P3_26 = 1;   // switch MDB/Micromach to MDB
    commCfgPort( COMM3, Baud600, WordLength8, ParitySelNone, StopBit1 );

                                        // START TEST ........................
    testDisplay();
    testAnalog();
    testBattery();
    testBuzzer();
    testLED();
    testSerial(COMM1);
    testSerial(COMM3);// collaudo MDB
    testGSM();
    testSPI0();
    testKeyScan();
    testDateTime(TRUE);
    testAN_K();
    testDIG_I_O();
    testSDcard();

//    do {
//    DispBuf( "TEST HIGH       " );
//    Delay(1000);
//    FIO3SET = BIT26;   // switch Micromach
//    testSerial(COMM3);
//    Delay(1000);
//
//    DispBuf( "TEST LOW        " );
//    Delay(1000);
//    FIO3CLR = BIT26;   // switch MDB
//    testSerial(COMM3);
//    Delay(1000);
//    } while(-1);
//    FIO3CLR = BIT26;   // switch MDB

    do {
        BuzzerOn( 100 );
        DispBuf( "TEST COMPLETED!!" );
        Delay(1000);
        getFirmwareRelease( buf );
        DispBuf( buf );
        Delay(1000);
    } while(-1);
}                                               //  testCPU

#endif
