#include <string.h>
#include	"def.h"
#include "ram.h"
#include "hwinit.h"
#include "keyadc.H"
#include "lcd7seg.h"
#ifndef __WIN32__
#include "LPC_Vic.h"
#endif
#include "keyboard.h"
#include "device.h"
#include "main.h"
#include "timer.h"
#include "display.h"
#include "optical.h"
#include "uart.h"
#include "dex.h"



#define BUZZER_PIN   0X00010000
#define BUZZER_OUT   IO0DIR |=  BUZZER_PIN
#define BUZZER_IN    IO0DIR &=  BUZZER_PIN
#define BUZZER_ONE   IO0SET  =  BUZZER_PIN
#define BUZZER_ZERO  IO0CLR  =  BUZZER_PIN

extern unsigned char power;
extern unsigned int timeBacklight;
extern byte     parallelBillEscrow;

unsigned long random;
dword to_aux_led_on;
extern void RegolaTemperatura( void );

word            durataBuzzer;
short timerKeyb;            // per menu funzioni

/*
#define TIMEBASE 300

unsigned short music[] = {
                           n__DO  ,TIMEBASE,
                           n__RE  ,TIMEBASE,
                           n__MI  ,TIMEBASE,
                           n__DO  ,TIMEBASE,
                           n__DO  ,TIMEBASE,
                           n__RE  ,TIMEBASE,
                           n__MI  ,TIMEBASE,
                           n__DO  ,TIMEBASE,
                           n__MI  ,TIMEBASE,
                           n__FA  ,TIMEBASE,
                           n__SOL ,TIMEBASE*2,
                           n__MI  ,TIMEBASE,
                           n__FA  ,TIMEBASE,
                           n__SOL ,TIMEBASE*2,
                           n__SOL ,TIMEBASE/2,
                           n__LA  ,TIMEBASE/2,
                           n__SOL ,TIMEBASE/2,
                           n__FA  ,TIMEBASE/2,
                           n__MI  ,TIMEBASE,
                           n__DO  ,TIMEBASE,
                           n__SOL ,TIMEBASE/2,
                           n__LA  ,TIMEBASE/2,
                           n__SOL ,TIMEBASE/2,
                           n__FA  ,TIMEBASE/2,
                           n__MI  ,TIMEBASE,
                           n__DO  ,TIMEBASE,
                           n__RE  ,TIMEBASE,
                           n_SOL  ,TIMEBASE,
                           n__DO  ,TIMEBASE*2,
                           n__RE  ,TIMEBASE,
                           n_SOL  ,TIMEBASE,
                           n__DO  ,TIMEBASE*2,
                         };

void            PlaySound(void)
{
  unsigned char i;

  for(i=0;music[i] != 0;i+=2){
    BuzzerOn(music[i+1],music[i]);
    while(durataBuzzer != 0);
  }
}
*/


short GetTmrKeyb(void)
{
  return(timerKeyb);
}

void ResetTmrKeyb(void)
{
  timerKeyb = 0;
}

unsigned short Randomize(void)
{
  return(1 + (random % 999));
}




/*--------------------------------------------------------------------------
 | InitTimer0:  attiva timer
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            InitTimer0( void )
{
#ifndef __WIN32__
    // Timer 0 interrupt
    VIC_SetVectoredIRQ(TIMER0_ISR,VIC_Slot4,VIC_TIMER0);
    VIC_EnableInt(1<<VIC_TIMER0);


//  init timer
    T0TCR = 0X03;                       // counter reset
    T0IR  = 0XFF;                       // clear int flag
    T0CTCR = 0;                         //  00000000
                                        //        00  every rising PCLK
                                        //      00    -
                                        //  0000      -
    T0TC = 0;                           // clear counter
    T0PR = 0;                           // count@timer_clock
    T0PC = 0;                           // clear prescaler
    T0MCR = 0x00C0;                     // 00000000 11000000
                                        //        0 11        reset + int on TMR2
    T0MR2 = T_PERIODIC*(TIMER_CLOCK/1000)/1000; // 1000 us
    T0CCR = 0;
    T0EMR = 0X0100;                     //  00000001 00000000 out = 0
                                        //  0000             -
                                        //      00           EMC3 off
                                        //        01         EMC2 low out
                                        //          00       EMC1 off
                                        //            00     EMC0 off
                                        //              0000 -
#endif
#ifndef BOOT
    keyStart();
#endif

    memset( &current, 0, sizeof(current) );

#ifndef __WIN32__
    T0TCR = 0X01;                            // start counter
#endif
}                                               //  InitTimer0

void            InitTimer1( void )
{
#ifndef __WIN32__
//  init timer
        T1TCR = 0X03;                       // counter reset
        T1IR  = 0XFF;                       // clear int flag
        T1CTCR = 0;                         //  00000000
                                            //        00  every rising PCLK
                                            //      00    -
                                            //  0000      -
        T1TC = 0;                           // clear counter
        T1PR = 0;                           // TIMER_CLOCK
        T1PC = 0;                           // clear prescaler
        T1MCR = 0x0000;                     // 00000000 00000000
        T1MR3 = 0;
        T1CCR = 0;
        T1EMR = 0X0000;                     //  00000001 00000000 out = 0
                                            //  0000             -
                                            //      00           EMC3 off
                                            //        00         EMC2 off
                                            //          00       EMC1 off
                                            //            00     EMC0 off
                                            //              0000 -
//        T1TCR = 0X01;                            // start counter
#endif
}                                               //  InitTimer1

void            InitTimer2( void )
{
#if RSR903==0
 #ifndef __WIN32__
//  init timer
        T2TCR = 0X03;                       // counter reset
        T2IR  = 0XFF;                       // clear int flag
        T2CTCR = 0;                         //  00000000
                                            //        00  every rising PCLK
                                            //      00    -
                                            //  0000      -
        T2TC = 0;                           // clear counter
        T2PR = 2000*(TIMER_CLOCK/1000)/1000;                           // TIMER_CLOCK
        T2PC = 0;                           // clear prescaler
        T2MCR = 0x0000;                     // 00000000 00000000
        T2MR3 = 0;
        T2CCR = 0;
        T2EMR = 0X0000;                     //  00000001 00000000 out = 0
                                            //  0000             -
                                            //      00           EMC3 off
                                            //        00         EMC2 off
                                            //          00       EMC1 off
                                            //            00     EMC0 off
                                            //              0000 -
        T2TCR = 0X01;                            // start counter
 #endif
#endif
}                                               //  InitTimer2

/*--------------------------------------------------------------------------
 | BuzzerOn:    attiva buzzer per il tempo specificato
 |                              --------------
 | In:  _durata tempo attivazione buzzer in ms
 | Out:
 +--------------------------------------------------------------------------*/

void            BuzzerOn( unsigned short _durata )
{
#ifndef __WIN32__
    durataBuzzer = _durata;
    PWM1PCR = 0x0400;                   // 00100100  pwm2 out enabled
#endif
}                                               //  BuzzerOn




// lettura del tempo (0:0xFFFF)

// attende un ritardo in ms
void            Delay( unsigned int _delay )
{
    unsigned int timeStart;

    timeStart = GetTickCount();
    while( (GetTickCount() - timeStart) < _delay )
    {
/*
#ifndef BOOT
        if ( _delay > 5 )
            lpdUpdate();
#endif */     
        mmcLogData();      
    }
}




/***************************************************************************
 TIMER0_ISR:		gestione timer variabile
 ***************************/
static dword    isrLen = 0L;
#if 0
static word     iOff = 0, iMin = 0, iMax1 = 0, iMax2 = 0;
#else
static word               iMin = 0, iMax1 = 0, iMax2 = 0;
#endif

//static sword    ica=0, wca[128]=0;
//#define campiona(a) wca[ica]=(a);ica=(ica==127)?0:ica+1;

#define ADch0conv(a,b)                  AD0CR = a;                          \
                                        for ( i = 0; i < 20; i++ )          \
                                        {                                   \
                                            b = ADDR0;                      \
                                            if ( (b & 0x80000000) )         \
                                                break;                      \
                                        }
#if LED_DIMMING
extern  DWORD   dutyLED2;
static  DWORD   maskLED = 0L;
#endif
extern  DWORD   bucket_cnt, to_flashing_led_on, to_flashing_led_off;

word            iConv[32];
#define OFF_CAMP    2
#define MAX_CAMP    16

extern const byte    escrowMask[TOTAL_MACHINE][2];
byte         keyledpwm = 15;    // USIGVC2
static dword to_flashing_led;

void	        TIMER0_ISR( void )
{
#ifndef __WIN32__
    byte        i, j, measureCurrent, anymotor;
    sword       iMotor;
    dword       startCount, startLoad, startISR;
    volatile dword       adImot, adImot2;
    //// TEST
    word        outmasks[4];

    T0IR |= 0XFF;
    startISR = T0TC;
#ifdef BOOT
        if ( durataBuzzer != 0 )
    {
        if ( --durataBuzzer == 0 )
            PWM1PCR = 0x0000;                   // 00100100  pwm2 out disabled
    }

    timeMs++;                       // delay time
    if( random > 9999 ) random = 1;
    if( timerKeyb < TIMER_KEYBOARD ) timerKeyb++;
    if( countDown != 0 ) countDown--;	 // contatore down fino a zero da 1 ms
    if( exeSaveSettings > 1 ) exeSaveSettings--;
    LATCH_OUT_SET();  LATCH_OUT_CLR();
    OE_OUT_ENABLE();                    // abilita i dati inviati, che sono dati di reset
#else //BOOT
                                        // current measure to test motor presence
                                        // NAT157 do this only with gum/mint to check presence (not homing)
    measureCurrent = ( ( machineType == MACHINA_NAT145 || machineType == MACHINA_MERCHA6 )                                  && testMotorPresence != 0 ) || 
// moodifica 7.3.7   ( ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 ) && outImage[OUT_SG8_SG15] == 0x10 && testMotorPresence != 0 );
                     ( ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 ) && outImage[OUT_SG8_SG15] == 0x10 && testMotorPresence == 2 );  // 7.3..7
    startCount = 0;
    if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000  || 
         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || 
         measureCurrent )
    {
        if ( !IS_PWR_OFF() &&
             outImage[OUT_AN0_AN7  ] != 0xFF &&
            (outImage[OUT_SG0_SG7  ] != 0x00 || outImage[OUT_SG8_SG15 ] != 0x00) )
        {
            PWR_EN_OFF();               // disable motor power
            startCount = T0TC;
        }
    }
#if TOK_TAKE
#else //TOK_TAKE
    else if ( machineType == MACHINA_AMS39 ) // aggiungere machineType == MACHINA_USIGVC2
    {
        if ( !IS_PWR_OFF() &&
            ( outImage[OUT_AN0_AN7  ] != 0xFF || ( outImage[OUT_SG8_SG15 ] & 0xC0 ) != 0xC0 )&&
            ( outImage[OUT_SG0_SG7  ] != 0x00 || ( outImage[OUT_SG8_SG15 ] & 0x3f ) != 0x00 ) )
        {
            PWR_EN_OFF();               // disable motor power
            startCount = T0TC;
        }
    }
#endif //TOK_TAKE    
// warning: there is a max 110 us time from this point ........THIS>>

    ADend();                            // A/D channel read
    if ( timeMs & 0x01 )
        random++;

    if ( timeBacklight == 0 || (GetTickCount() - timeBacklight) > (unsigned int)TIMEBACKLIGHT )
    {
//        DisplayBacklighOff();
        timeBacklight = 0;
    }

    if ( durataBuzzer != 0 )
    {
        if ( --durataBuzzer == 0 )
            PWM1PCR = 0x0000;                   // 00100100  pwm2 out disabled
    }

    timeMs++;                       // delay time
    if( random > 9999 ) random = 1;
    if( timerKeyb < TIMER_KEYBOARD ) timerKeyb++;
    if( countDown != 0 ) countDown--;	 // contatore down fino a zero da 1 ms
    if( exeSaveSettings > 1 ) exeSaveSettings--;

    if ( machineType == MACHINA_USIGVC2 )
    {
        if( ( timeMs & 0x0F ) > keyledpwm )
            outImage[OUT_COIN_BILL] &= ~0x20;
        else
            outImage[OUT_COIN_BILL] |=  0x20;
    }
    ReadRx(inImage, 4);
    LOAD_SR();                          // latch nuovo ingresso
    OE_OUT_ENABLE();                    // abilita i dati inviati al precedente interrupt
    LATCH_OUT_SET();  LATCH_OUT_CLR();
    startLoad = T0TC;
#if LED_DIMMING
    if ( testMode != 0x47681022 )
    {
        // LED 1, dimming
        if ( dutyLED2&maskLED )
        {
            outImage[OUT_AN0_AN7 ] &= ~LED1_MASK_AA;
            outImage[OUT_SG8_SG15] &= ~LED1_MASK_AK;
            outImage[OUT_SG8_SG15] |=  LED1_MASK_KK;
        }
        else {
            outImage[OUT_AN0_AN7 ] |=  LED1_MASK_AA;
            outImage[OUT_SG8_SG15] |=  LED1_MASK_AK;
            outImage[OUT_SG8_SG15] &= ~LED1_MASK_KK;
        }
        maskLED >>= 1;
        if ( maskLED == 0 )
            maskLED = 0x80000000L;
        
        // LED 2, 3 VEND_BUCKET
        if( bucket_cnt ) {
            bucket_cnt--;
            if ( NonVolatileSetup.flashingLedOn == 0 || NonVolatileSetup.flashingLedOff == 0 )
            {
                AUX_LED_ON();
            }
            else {
                if(to_flashing_led_off)
                {
                  to_flashing_led_off--;
                  AUX_LED_OFF();
                  if (to_flashing_led_off == 0 )
                      to_flashing_led_on = NonVolatileSetup.flashingLedOn*1000;                  
                }
                else {
                    if(to_flashing_led_on)
                    {
                      to_flashing_led_on--;
                      AUX_LED_ON();
                      if (to_flashing_led_on == 0)
                          to_flashing_led_off = NonVolatileSetup.flashingLedOff*1000;
                    }
                }
            }            
        }
        else {
            AUX_LED_OFF();
            to_flashing_led = timeMs;   // reset flashing led timer
            to_flashing_led_off = 0;
            to_flashing_led_on = 0;  
        }        
        
    }

#endif //LED_DIMMING
    if ( testMode != 0x47681022 && escrowMask[machineType][1] != 0x00 )
    {
        if ( parallelBillEscrow )
            outImage[escrowMask[machineType][0]] &= ~escrowMask[machineType][1];
        else
            outImage[escrowMask[machineType][0]] |=  escrowMask[machineType][1];
    }
    anymotor = 1;
#if TOK_TAKE
#else //TOK_TAKE
    if( machineType == MACHINA_AMS39 )
    {                           // To handle motor couplig, check homing for even motor and odd motor on alternate interrupt cycles
        outmasks[OUT_COIN_BILL] = outImage[OUT_COIN_BILL];
        if( timeMs & 0x01 )
        {
          outmasks[OUT_SG8_SG15] = outImage[OUT_SG8_SG15] | 0x80;
          outmasks[OUT_SG0_SG7] = outImage[OUT_SG0_SG7];
          outmasks[OUT_AN0_AN7] = outImage[OUT_AN0_AN7] | 0xAA;
        }
        else
        {
          outmasks[OUT_SG8_SG15] = outImage[OUT_SG8_SG15] | 0x40;
          outmasks[OUT_SG0_SG7] = outImage[OUT_SG0_SG7];
          outmasks[OUT_AN0_AN7] = outImage[OUT_AN0_AN7] | 0x55;
        }
        if ( outmasks[OUT_AN0_AN7  ] != 0xFF || ( outmasks[OUT_SG8_SG15 ] & 0xC0 ) != 0xC0 )
            anymotor = 1;
        else
            anymotor = 0;
        sendSPI1( outmasks, 4 );
    }
    else
#endif //TOK_TAKE
        sendSPI1( outImage, 4 ); // DEBUG : effettua invio e attende prossimo interrupt per attivare uscite !!

    filterKey();                        // keyboard filtering
    ISRkey();

// warning: ... to >>THIS point
                                        // aggiorna immagine uscite motori AP113
    if ( startCount )
    {
// wait 110us power off: actually the firmware wait 60us in the next loop, what can we do ?
        for ( i = 0; i < 1000; i++ )
        {
            if ( (T0TC-startCount) > 110*(TIMER_CLOCK/1000)/1000 )   // wait power off
                break;
        }
        ADch0conv(0x01200201,adImot);   // start a dummy conversion
//        ADch0conv(0x01200F01,adImot);   // start a dummy conversion
        ADch0conv(0x01200201,adImot);   // read minimum value (power off)

        iMin   = ((iMin  + ((adImot & 0x0000FFC0) >> 6)) /  2);
        iMotor = iMin;
        AD.conv[AD_I_MOTORS] = ((AD.conv[AD_I_MOTORS]+iMin)/2);
        startCount = T0TC-startCount;
        
        {
        LATCH_OUT_SET(); LATCH_OUT_CLR(); // activate motor to test
        if( !testMotorHoming )
            sendSPI1( outImage, 4 );      // use convertion time to load runningmotor configuration
        if( anymotor && testMotorHoming ) --testMotorHoming;
        }
        PWR_EN_ON();                      // enable motor power
        iMax1 = 0;                        // and store MAX_CAMP current measurements
        ADch0conv(0x01200201,adImot);
        for ( j = 0; j < MAX_CAMP; j++ )
        {
            AD0CR = 0x01200201;
            iMax2   = ((adImot  & 0x0000FFC0) >> 6);
            iConv[j+OFF_CAMP] = iMax2;
            if ( iMax2 > iMax1 )
                iMax1 = iMax2;
            for ( i = 0; i < 20; i++ )         
            {                                   
                adImot = ADDR0;                      
                if ( (adImot & 0x80000000) )
                    break;                      
            }
        }
        iMotor = (sword)iMax1-(sword)iMotor;
        AD.conv[AD_I_MOTORS] = ((AD.conv[AD_I_MOTORS]+iMax1)/2);

        if ( testMotorHoming )
        {
            if ( anymotor && --testMotorHoming == 0 )
            {
                if ( !testMotorPresence )
                {
                    if ( iConv[2+OFF_CAMP] > 100 && iConv[3+OFF_CAMP] > 100 )
                        iMotor = 100;//in posizione
                    else
                        iMotor = 0;// fuori home
                }
#if HOME_DEBUG //11=measure current
                commPutChar( COMM1, 0x11 );
                commPutChar( COMM1, (byte)(iConv[2+OFF_CAMP]) );
                commPutChar( COMM1, (byte)(iConv[3+OFF_CAMP]) );
//                commPutChar( COMM1, (byte)(iMotor>>8) );
//                commPutChar( COMM1, (byte)(iMotor   ) );
#endif //HOME_DEBUG
// scheda di test
// test motor map:
//      - motors at home:       250
//      - motor not at home:    222            
// check motor existence:
//      - motors at home:       240
//      - motor not at home:    240            
//
                if ( iMotor > 35 )    // out=16...37, home=208...220 // precedente 80
                {                       
                    PWR_EN_OFF();     // motor at home
//campiona(11111);
                }
                else
                {
//campiona(22222);
                }
            }
        }
        else
        {
                // new: picco con 2 punti oltre il valore precedente e successivo della corrente
            iMax1 = 0;
            for ( j = 0; j < MAX_CAMP-OFF_CAMP-1; j++ )
            {
                if ( iConv[j+OFF_CAMP+0] > iConv[j+0] && iConv[j+OFF_CAMP+0] > iConv[j+OFF_CAMP*2+1] &&
                     iConv[j+OFF_CAMP+1] > iConv[j+0] && iConv[j+OFF_CAMP+1] > iConv[j+OFF_CAMP*2+1] )
                {
                    iMax2 = (iConv[j+OFF_CAMP+0]+iConv[j+OFF_CAMP+1])/2-((iConv[j+0]+iConv[j+OFF_CAMP*2+1])/2);
                    if ( iMax2 > iMax1 )
                        iMax1 = iMax2;
                }
            }
            iMotor = iMax1;

            if( machineType == MACHINA_AMS39 ) i = timeMs & 0x01; else i = 0; // to handle motor coupling
            if ( current[i].iCamp >= (N_ICAMP-1) )
                current[i].iCamp = 0;
            else
                current[i].iCamp++;
            current[i].totCamp -= current[i].camp[current[i].iCamp];
            current[i].camp[current[i].iCamp] = iMotor;
            current[i].totCamp += current[i].camp[current[i].iCamp];
            if( machineType == MACHINA_AMS39 )    // leggendo solo ogni 2 interrupt, raddoppia ogni singola lettura
            {
                if ( current[i].iCamp >= (N_ICAMP-1) )
                    current[i].iCamp = 0;
                else
                    current[i].iCamp++;
                current[i].totCamp -= current[i].camp[current[i].iCamp];
                current[i].camp[current[i].iCamp] = iMotor;
                current[i].totCamp += current[i].camp[current[i].iCamp];
            }
#if HOME_DEBUG//33=peak current
            commPutChar( COMM1, 0x33 );
            commPutChar( COMM1, (byte)((current[i].totCamp/N_ICAMP)>>1) );
#endif //HOME_DEBUG
// scheda di test
// test motor homing:
//      - motors at home:       5
//      - motor not at home:    80            
//
            if ( (current[i].totCamp/N_ICAMP) > 40 )
                INPi |=  ( 0x20 << i );
            if ( (current[i].totCamp/N_ICAMP) < 20 )
                INPi &= ~( 0x20 << i );
//campiona((current[i].totCamp/i));
            LATCH_OUT_SET();  LATCH_OUT_CLR();    // enable active motor
        }
    }
    else
    {
        ADch0conv(0x01200F01,adImot);   // read value
        AD.conv[AD_I_MOTORS]    = ((AD.conv[AD_I_MOTORS]        + ((adImot & 0x0000FFC0) >> 6)) /  2);
#if TOK_TAKE
        if ( machineType == MACHINA_AMS39 &&
#else //TOK_TAKE
        if ( ( machineType == MACHINA_LCM123 || machineType == MACHINA_VEILCM )&&
#endif //TOK_TAKE
             !IS_PWR_OFF() &&
             outImage[OUT_AN0_AN7  ] != 0xFF &&
            (outImage[OUT_SG0_SG7  ] != 0x00 || outImage[OUT_SG8_SG15 ] != 0x00) )
        {
            if ( AD.conv[AD_I_MOTORS] > 80 )
            {
                if ( current[0].iCamp > 50 )
                    INPi = 0;
                else
                    current[0].iCamp++;
            }
            if ( AD.conv[AD_I_MOTORS] < 40 )
            {
                INPi = 0x20;
                current[0].iCamp = 0;
            }
        }
        if ( machineType == MACHINA_USIGVC2 &&
             !IS_PWR_OFF() &&
            ( outImage[OUT_AN0_AN7  ] != 0xFF || ( outImage[OUT_SG8_SG15 ] & 0xC0 ) != 0xC0 )&&
            ( outImage[OUT_SG0_SG7  ] != 0x00 || ( outImage[OUT_SG8_SG15 ] & 0x3f ) != 0x00 ) )
        {
            if ( AD.conv[AD_I_MOTORS] > 80 )
            {
                if ( current[0].iCamp > 50 )
                    INPi = 0;
                else
                    current[0].iCamp++;
            }
            if ( AD.conv[AD_I_MOTORS] < 40 )
            {
                INPi = 0x20;
                current[0].iCamp = 0;
            }
        }
    }

    AD0CR = 0x01200204;                 // start dummy conversion

    if ( 
        (testMode != 0x47681022 || countDown == 0) )
    {                                   // test mode disable local bus
        MicroMech();
        BillParallel();
        MDB();
        DEX();
    }

    if ( ( machineType == MACHINA_NAT145 || 
           machineType == MACHINA_NAT147 || 
           machineType == MACHINA_NAT157 || 
           machineType == MACHINA_VEI147 || 
           machineType == MACHINA_MERCHA6 ) && testMotorHoming && !measureCurrent )
    {
        if ( --testMotorHoming == 0 )
        {                               // first interrupt: load configuration, second interrupt: latch (before) and test (now)
            for ( i = 0; i < 3000; i++ )
            {
                if ( (T0TC-startLoad) > 150*(TIMER_CLOCK/1000)/1000 )//150us delay
                    break;
            }

            if ( testMotorPresence )
            {
#if HOME_DEBUG//66=inp0,inp2
                commPutChar( COMM1, 0x66 );
                commPutChar( COMM1, (byte)((INP0==1?0x10:0x00)||(INP2==1?0x01:0x00)) );
#endif //HOME_DEBUG
                if ( INP0 == 1 || INP2 == 1 )
                {                       // motor is present ( NAT147 )
                    PWR_EN_OFF();
                }
                testMotorPresence = 0;
            }
            else
            {
#if HOME_DEBUG//77=inp0,inp2
                commPutChar( COMM1, 0x77 );
                commPutChar( COMM1, (byte)((INP0==1?0x10:0x00)||(INP2==1?0x01:0x00)) );
#endif //HOME_DEBUG
                if ( INP0 == 1 && INP2 == 1 )         
                {                       // motor is already HOME ( NAT147 )
                    PWR_EN_OFF();
                }
            }
        }
    }
 
    if ( (testMode != 0x47681022 || countDown == 0) )
        RegolaTemperatura(); 
    
    if ( T0TC - startISR > isrLen )
        isrLen = T0TC - startISR;
    AD0CR = 0x01200F04;                 // start conversion
#endif // BOOT
    VICAddress = 0;                     // Clear interrupt in VIC.
#endif // __WIN32__
}                                               //  TIMER0_ISR

void            lampOn( void )
{
    DisplayBacklighOn();
    timeBacklight = GetTickCount();
}
