/*
uart.h
*/

#ifndef	__UART_H
#define	__UART_H


#ifdef  __UART_C
    #define typeu
#else
    #define typeu   extern
#endif



#include    "def.h"




#define FIFODEEP    16

#define CR          0x0D
#define LF          0x0A

/* Uart line control register bit descriptions */
#define LCR_WORDLENTH_BIT         0
#define LCR_STOPBITSEL_BIT        2
#define LCR_PARITYENBALE_BIT      3
#define LCR_PARITYSEL_BIT         4
#define LCR_BREAKCONTROL_BIT      6
#define LCR_DLAB_BIT              7

/* Uart Interrupt Identification */
#define IIR_RSL                   0x3
#define IIR_RDA                   0x2
#define IIR_CTI                   0x6
#define IIR_THRE                  0x1

/* Uart Interrupt Enable Type*/
#define IER_RBR                   0x1
#define IER_THRE                  0x2
#define IER_RLS                   0x4

/* Uart Fifo control register */
#define FCR_FIFOEN                0x1
#define FCR_FIFORXR               0x2
#define FCR_FIFOTXR               0x4

/* Uart Receiver Errors*/
#define RC_FIFO_OVERRUN_ERR       0x1
#define RC_OVERRUN_ERR            0x2
#define RC_PARITY_ERR             0x4
#define RC_FRAMING_ERR            0x8
#define RC_BREAK_IND              0x10

 // Word Lenth type
typedef enum {
    Baud600 = 0,
    Baud9600,
    Baud19200,
    Baud38400,
    Baud57600,
    Baud115200,
    Baud230400,
    Baud460800,
    Baud921600
} LPC_Uart_Baud_t;

 // Word Lenth type
typedef enum {
    WordLength5 = 0,
    WordLength6,
    WordLength7,
    WordLength8
} LPC_Uart_WordLenth_t;

// Parity Select type
typedef enum {
    ParitySelOdd = 0,
    ParitySelEven,
    ParitySelStickHigh,
    ParitySelEvenLow,
    ParitySelNone
} LPC_Uart_ParitySelect_t;

// data Stop bit
typedef enum {
    StopBit1 = 0,
    StopBit2
} LPC_Uart_StopBit_t;

// FIFO Rx Trigger Level type
typedef enum {
    FIFORXLEV0 = 0,	// 0x1
    FIFORXLEV1,		// 0x4
    FIFORXLEV2,		// 0x8
    FIFORXLEV3		// 0xe
} LPC_Uart_FIFORxTriggerLevel_t;

// Send and Receive data method mode
typedef enum {
    POLLING_MODE = 0,	
    INTERRUPT_MODE
} LPC_Uart_MethodMode_t;




#define nCOMM           4
#define COMM1           0
#define COMM2           1
#define COMM3           2
#define COMM3_MDB       4   // solo per inizializzazione
#define COMM4           3

#define COMM_BUF        1024

#define COMM_NO_ERR     0
#define COMM_BAD_CH     1
#define COMM_RX_EMPTY   2
#define COMM_TX_FULL    3
#define COMM_BAD_PARAM  4


typedef struct {
    byte    flag;                       // bit 0: buffer overflow
    word    r, w;
    byte    buf[COMM_BUF];
} _RING_BUF_;

typeu   _RING_BUF_  commIbuf[nCOMM];
typeu   _RING_BUF_  commObuf[nCOMM];

typeu   struct {
    BOOL    FIFOenable;
} commConfig[nCOMM];

#if SLAVE_MACHINE
enum  eSlaveStatus {  SLAVE_RESET = 0,
                      SLAVE_SETUP,
                      SLAVE_POLL,
                      SLAVE_SELECTION,
                   };
#endif


byte            commCfgPort( byte _ch, LPC_Uart_Baud_t _baud, LPC_Uart_WordLenth_t _bits, LPC_Uart_ParitySelect_t _parity, LPC_Uart_StopBit_t _stops );
byte            commRxFlash( byte _ch );
byte            commRxIntDis( byte _ch );
byte            commRxIntEn( byte _ch );
byte            commTxIntDis( byte _ch );
byte            commTxIntEn( byte _ch );
byte            commGetChar( byte _ch, byte *_data );
byte            commPutChar( byte _ch, byte _data );
void            commPutStr( byte _ch, byte *_str );
void            commPutDecimal( byte _ch, unsigned long val, byte len );
BOOL            commIsEmpty( byte _ch );
BOOL            commIsFull( byte _ch );
BOOL            UART_readTxBuf( _RING_BUF_ *_p, byte *_txReg );
void            UART0_ISR( void );
void            UART1_ISR( void );
void            UART2_ISR( void );
void            UART3_ISR( void );
void            TIMER3_ISR( void );

byte            zigBee_NI( byte *_assetID );

void            startCredit( void );
void            MDB( void );
void            MicroMech( void );
byte            BillParallel( void );
void            startMDB( void );
byte            MDBsafeMode( void );
#if MDB_DEBUG_MMC
byte            mmcLogData( void );
#else
#define         mmcLogData()
#endif

_Credito        Credit( void );
void            pay_selection_start( _Credito tot, byte s_machine, byte s_l, byte s_n );
byte            pay_selection( _Credito *tot );

// classe Changer
word            ChangerTubes( byte tube );
word            ChangerTubesEscrow( byte tube );
byte            ChangerExactChange( void );
_Credito        ChangeTubeValue( void );
void            ChangerSetTubeValue( void );
char            *ChangerManufacturer_Code( void );
char            *ChangerSerial_Number( void );
char            *ChangerTuning_Revision( void );
void            ChangerReadTubeStatus( void );

// classe Cashless
char            *CashlessManufacturer_Code( byte id );
char            *CashlessSerial_Number( byte id );
char            *CashlessTuning_Revision( byte id );
unsigned short  *CashlessSoftware_Version( byte id );

// classe Bill
char            *BillManufacturer_Code( void );
char            *BillSerial_Number( void );
char            *BillTuning_Revision( void );

// slave index/addr
byte            GetSlaveAddr( byte slave );
byte            GetSlaveIndex( byte addr );

#define ID_TOKEN    0xFFFF

#endif
