/***************************************************************************
 ************************						****************************
 ************************		Z I G B E E    	****************************
 ************************						****************************
 ***************************************************************************/
#define	__ZIGBEE_C




#include    <stdio.h>
#include    <string.h>
#include    "def.h"
#include    "dex.h"
#include    "ds2341.h"
#include    "display.h"
#include    "modem.h"
#include    "zigbee.h"
#include    "ram.h"
#include    "timer.h"
#include    "uart.h"




#define DEBUG_ZIGBEE_DISPLAY 0


#if ZIGBEE

struct  _ZIGBEE_DATA_ zigbeeData;

byte zigbeeReceive, zigbeeSend;
int             Do_dex( byte _ch );
extern  char    *field[500];




/*--------------------------------------------------------------------------
 | zigbeeTest:  check zigbee module presence
 |                              --------------
 | In:
 | Out: 0       module found 
 |      1       module not ready
 +--------------------------------------------------------------------------*/

byte            zigbeeCommandMode( void )
{
    byte        retry;
    
    for ( retry = 0; retry < 3; retry++ )
    {
        if ( zigbeeCommand( "+++", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 0 )
            return 0;
        if ( zigbeeCommand( "AT\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 0 )
            return 0;
        Delay(1200);
    }
    return 1;
}

byte            zigbeeTest( byte _channel )
{
    char        wrcmd[32];
        
    zigbeeInit(_channel);
    if ( zigbeeCommandMode() )
        return 1;

    zigbeeData.avail = 1;
    if ( zigbeeCommand( "ATVR\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 1 )
    {
//        if ( memcmp(zigbeeData.rxbuf,"1047",4) == 0 || memcmp(zigbeeData.rxbuf,"1041",4) == 0 )
            zigbeeData.avail = 2;   // coordinatore
    }

    if ( zigbeeCommand( "ATNI\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 1 )
    {
        strcpy(  wrcmd, "VEI        -        " );
        memcpy( &wrcmd[3], &SerialID[8], 8 ); 
        memcpy( &wrcmd[12], MachineTypeID, 8 );
//        strncpy( (char *)wrcmd, &SerialID[8], 8 );
//        strncat( (char *)wrcmd, (char*)NonVolatileSetup.assetID, 12 );
        if ( memcmp(zigbeeData.rxbuf,wrcmd,strlen(wrcmd)) != 0 )
            zigBee_NI((byte *)wrcmd);
    }
    zigbeeCommand( "ATCN\x0D", 500, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) );

    return 0;
}                                               //  zigbeeTest




/*--------------------------------------------------------------------------
 | zigbeeInit:  zigbee data structure init
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            zigbeeInit( byte _channel )
{
    memset( &zigbeeData, 0, sizeof(zigbeeData) );
    zigbeeData.comPort = _channel;
    zigbeeReceive = 0;
    zigbeeSend = 0;
    return 0;
}                                               //  zigbeeInit




/*--------------------------------------------------------------------------
 | zigbeeCommand:send command to zigbee and wait reply with OK or CONNECT
 |                              --------------
 | In:
 | Out: 0       OK or CONNECT
 |      1       error
 +--------------------------------------------------------------------------*/

byte            zigbeeCommand( char *_cmd, DWORD _timeout, char *_ans, word _size )
{
    DWORD       tm;
    byte        rLen, ch, *p;

    if ( _cmd != NULL )
    {
        while( commGetChar(zigbeeData.comPort,&ch) != COMM_RX_EMPTY )
            Delay(4);

#if DEBUG_ZIGBEE_DISPLAY
        strcpy( (char *)_ans, _cmd );
        if ( (p=(byte *)strchr((char *)_ans,'\x0D')) != NULL )
            *p = ' ';
        _ans[16] = '\0';
        DispStr( 0, 0, (char *)_ans );

        BuzzerOn(50);
#endif
        while( *_cmd != '\0' )
            commPutChar(zigbeeData.comPort,*_cmd++);
    }

    if ( _size == 0 )
        return 0;
    rLen = 0;
    memset( _ans, 0, _size );
    tm = GetTickCount();
    while ( (GetTickCount()-tm) < _timeout )
    {
        if ( commGetChar(zigbeeData.comPort,&ch) == COMM_NO_ERR )
        {
            _timeout = 4000;
            tm = GetTickCount();

            if ( ch == LF || (ch == CR && rLen <= 1) )
                continue;
            if ( rLen < _size )
                _ans[rLen++] = toupper(ch);
            if ( ch == CR )
            {
                _ans[rLen] = '\0';
#if DEBUG_ZIGBEE_DISPLAY
                DispStr( 0, 0, (char *)_ans );
#endif
                if ( strstr( (char *)_ans, "OK" ) != NULL || 
                     strstr( (char *)_ans, "HOSTIF" ) != NULL || 
                     strstr( (char *)_ans, "ICCID" ) != NULL )
                    return 0;
                if ( strstr( (char *)_ans, "CONNECT" ) != NULL )
                    return 0;
                if ( strstr( (char *)_ans, "ERROR" ) != NULL || strstr( (char *)_ans, "NO CARRIER" ) != NULL )
                {
                    while ( (p=(byte *)strchr((char *)_ans,'\x0D')) != NULL )
                        *p = ' ';
                    _ans[16] = '\0';
#if DEBUG_ZIGBEE_DISPLAY
                    DispStr( 0, 0, (char *)_ans );
#endif
                    Delay(4000);
                    return 2;
                }
                return 1;
            }
        }
    }

    return 3;
}                                               //  zigbeeCommand




/*--------------------------------------------------------------------------
 | zigbeeManager:check zigbee module status
 |                              --------------
 | In:
 | Out: 0       modem on use
 |      1       modem on hold
 +--------------------------------------------------------------------------*/

#define exitAll 0
void            debugga( char *_str );
void WriteComm( char *_a, char _b)
{
    while( _b-- > 0 )
        commPutChar(zigbeeData.comPort,*_a++);
}
#define ReadComm(a,b)   (commGetChar(zigbeeData.comPort,(byte *)a)==COMM_NO_ERR)

//---------------------------------------------------------------------------
BOOL            waitOK( DWORD _timeout )
{
    int         i;
    char        ch, answer[128];
    DWORD       now;

    now = GetTickCount();
    for ( i = 0; i < 128; )
    {
        if ( exitAll || (GetTickCount()-now) > _timeout )
        {
            return FALSE;
        }
        if ( ReadComm( &ch, 1 ) )
        {
            now = GetTickCount();
            if ( ch == 0x0D || ch == 0x0A )
            {
                if ( i == 2 && memcmp( answer, "OK", 2 ) == 0 )
                    break;
                continue;
            }
            answer[i++] = ch;
        }
    }
    return TRUE;
}

//---------------------------------------------------------------------------

char        listModule[32][16], iListModule;

byte            zigbeeManager( void )
{
    byte        retry, tipo, nmodule, status;
    int         tout, i, j;
    DWORD       timeout, now;
    char        ch, answer[256], highaddr[16], lowaddr[16], nodename[32];

    if ( zigbeeData.avail != 2 )
        return 0;
                                        ///////////////////////////////////////
                                        // imposta in modo comandi
    if ( zigbeeCommandMode() )
        return 1;
                                        ///////////////////////////////////////
                                        // leggi timeout node discovery
    debugga( "Read timeout..." );
    timeout = 10000;
    if ( zigbeeCommand( "ATNT\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 1 )
    {
        sscanf( zigbeeData.rxbuf, "%x", &tout );
        timeout += tout*100;
    }
                                        ///////////////////////////////////////
                                        // ricerca moduli presenti in rete
    debugga( "Network discovery..." );
    zigbeeCommand( "ATND\x0D\0x0A", 2000, zigbeeData.rxbuf, 0 );

                                        ///////////////////////////////////////
                                        // attende doppio a capo per finire
    tipo = 0;
    nmodule = 0;
    status = 0;
    now = GetTickCount();
    memset( highaddr, 0, sizeof(highaddr) );
    memset( lowaddr,  0, sizeof(lowaddr)  );
    memset( nodename, 0, sizeof(nodename) );
    iListModule = 0;
    for ( i = 0; i < 256; )
    {
        if ( (GetTickCount()-now) > timeout )
        {
            debugga( "...timeout" );
            break;
        }
                                        // read byte
        if ( ReadComm( &ch, 1 ) )
        {
            now = GetTickCount();
            if ( ch == 0x0D || ch == 0x0A )
            {
                status++;
                if ( status == 1 && i == 0 )
                    break;
                if ( status == 2 )
                {
                    memcpy( highaddr, answer, 8 );
                    if ( strlen(answer) == 16 )
                    {
                        memcpy( lowaddr, &answer[8], 8 );
                        tipo = 1;
                    }
                }
                if ( status == 3 && strlen(answer) > 1 )
                {
                    if ( strlen(lowaddr) < 8 )
                        memcpy( lowaddr,  answer, 8 );
                    else
                        strcpy( nodename, answer );
                }
                if ( status == 4 )
                {
                    if ( strlen(answer) > 1 && strlen(nodename) == 0 && tipo == 0 )
                        strcpy( nodename, answer );
//                    if ( strlen(nodename) > 0 )
//                        ListModule->AddItem((String)highaddr+(String)"-"+(String)lowaddr+(String)" ("+(String)nodename+(String)")",NULL);
//                    else
//                        ListModule->AddItem((String)highaddr+(String)"-"+(String)lowaddr,NULL);
                    if ( modemData.ucbID[0] == '*' || strstr(nodename,modemData.ucbID) != NULL )
                    {
                        if ( iListModule < 32 )
                        {
                            memcpy( &listModule[iListModule][0], highaddr, 8 );
                            memcpy( &listModule[iListModule][8], lowaddr, 8 );
                            iListModule++;
                        }
                    }
//
                    memset( highaddr, 0, sizeof(highaddr) );
                    memset( lowaddr,  0, sizeof(lowaddr)  );
                    memset( nodename, 0, sizeof(nodename) );
                    nmodule++;
                    tipo = 0;
                }
                if ( status == 10 )
                    status = 0;
                i = 0;
                memset( answer, 0, sizeof(answer) );
                continue;
            }

            answer[i++] = ch;
        }
    }


                                        ///////////////////////////////////////
                                        // leggi dati
    if ( nmodule != 0 )
    {
        for ( i = 0; i < nmodule; i++ )
        {
            for ( j = 0; j < i; j++ )
            {
                if ( memcmp(&listModule[j][0],&listModule[i][0],16) == 0 )//ListModule->Items->Strings[j] == ListModule->Items->Strings[i] )
                    break;
            }
            if ( j != i )
            {
                debugga( "======================================================" );
                debugga( "Duplicate node: skip '"/*+ListModule->Items->Strings[i]+*/"'" );
                continue;//duplicate node
            }
//
            Delay(500);
            debugga( "======================================================" );
            debugga( "Reading from "/*+ListModule->Items->Strings[i]+*/" ..." );
            Delay(500);

            for ( retry = 0; retry < 3; retry++ )
            {
                debugga( "Entering command mode..." );
                WriteComm( "AT\x0D", 3 );
                if ( waitOK(1000) || exitAll )
                    break;

                Delay(1100);
                WriteComm( "+++", 3 );
                if ( waitOK(2000) || exitAll )
                    break;

                Delay(2000);
            }
            if ( retry == 3 || exitAll )
            {
                return 1;
            }

                                        ///////////////////////////////////////
                                        // imposta indirizzo alto
            strcpy( answer, "ATDH=" );
            memcpy( &answer[5], &listModule[j][0], 8 );
            answer[13] = 0x0D;
            WriteComm( answer, 14 );
            if ( ! waitOK(6000) )
            {
                return 2;
            }

                                        ///////////////////////////////////////
                                        // imposta indirizzo basso
            strcpy( answer, "ATDL=" );
            memcpy( &answer[5], &listModule[j][8], 8 );
            answer[13] = 0x0D;
            WriteComm( answer, 14 );
            if ( ! waitOK(6000) )
            {
                return 3;
            }

                                        ///////////////////////////////////////
                                        // imposta in modo trasparente
            strcpy( answer, "ATCN\x0D" );
            WriteComm( answer, 5 );
            waitOK(6000);

            Do_dex(zigbeeData.comPort);
#ifdef  EXTENDED_FILENAME
            if ( field[2] != NULL && memcmp(field[2],"ID1*",4) == 0 )
            {
                memcpy( answer, &field[2][4], 11 );
                answer[11] = '\0';
            }
            else
#endif
                strcpy( answer, "test" );
            modemTransfer(answer);

                                        // enter command mode
            Delay(6000);
            WriteComm( "+++", 3 );
            if ( ! waitOK(6000) )
            {
                return 1;
            }

        }
    }
    return 0;
}




/*--------------------------------------------------------------------------
 | zigbeeDexRequest:send to zigbee coordinator request for dex data
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            zigbeeDexRequest( void )
{
    char        i, str[48], sh[10], sl[10], *p;

    if ( zigbeeCommandMode() == 0 )
    {
        sh[0] = sl[0] = '\0';
        if ( zigbeeCommand( "ATSH\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 1 )
        {
            if ( (p=strchr(zigbeeData.rxbuf,0x0D)) != NULL )
                *p = '\0';
            strncpy( (char *)sh, zigbeeData.rxbuf, 9 );
        }
        if ( zigbeeCommand( "ATSL\x0D\0x0A", 2000, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) ) == 1 )
        {
            if ( (p=strchr(zigbeeData.rxbuf,0x0D)) != NULL )
                *p = '\0';
            strncpy( (char *)sl, zigbeeData.rxbuf, 9 );
        }
        zigbeeCommand( "ATCN\x0D", 500, zigbeeData.rxbuf, sizeof(zigbeeData.rxbuf) );
        
        i = sprintf( str, "\x02read[%s,%s]\x0D", sh, sl );
    }
    else
        i = sprintf( str, "\x02read(%8.8s)\x0D", &SerialID[8] );
    
    WriteComm( str, i );
    return 0;
}                                               //  zigbeeDexRequest
#endif
