/*
  LCDMODULE.C
*/

#include    <string.h>
#include    "display.h"
#include    "def.h"
#include    "timer.h"
#include    "ram.h"

void DelayLCD(unsigned short);

// buffer temporaneo messaggi
char bufferLCD[32];
char LCD2serial[17];

#if RSR903
#else

/*--------------------------------------------------------------------------
 | DispInit:    inizializza display LCD
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            DispInit( void )
{
    DISPLAY_RW_CLR;
    DISPLAY_EN_CLR;
    DISPLAY_RS_CLR;

    DYDATA(0x03);
    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    Delay(6);

    DYDATA(0x03);
    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    Delay(6);

    DYDATA(0x03);
    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    Delay(6);

    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    DelayLCD(1200);

    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    DelayLCD(1200);

    DYDATA(0x02);
    DISPLAY_EN_SET;
    DelayLCD(20);
    DISPLAY_EN_CLR;
    DelayLCD(1200);

    WriteLCD(COMMAND, 0x28);     // DL = 0 N = 2 e F = 0
    DelayLCD(1200);
    WriteLCD(COMMAND, 0x08);     // Dy = 0ff Curs = 0ff Blink = 0ff
    DelayLCD(1200);
    WriteLCD(COMMAND, 0x06);     // ID increment Shift off
    DelayLCD(1200);
    WriteLCD(COMMAND, 0x0C);     // Dy = 1 on
    DelayLCD(1200);
                                 // load symbol <-, 0x01
    WriteLCD(COMMAND, 0x48);    WriteLCD( DATA, 0x00 );
    WriteLCD(COMMAND, 0x49);    WriteLCD( DATA, 0x04 );
    WriteLCD(COMMAND, 0x4A);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x4B);    WriteLCD( DATA, 0x1F );
    WriteLCD(COMMAND, 0x4C);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x4D);    WriteLCD( DATA, 0x04 );
    WriteLCD(COMMAND, 0x4E);    WriteLCD( DATA, 0x00 );
    WriteLCD(COMMAND, 0x4F);    WriteLCD( DATA, 0x00 );
                                 // load symbol >>, 0x02
    WriteLCD(COMMAND, 0x50);    WriteLCD( DATA, 0x00 );
    WriteLCD(COMMAND, 0x51);    WriteLCD( DATA, 0x14 );
    WriteLCD(COMMAND, 0x52);    WriteLCD( DATA, 0x0A );
    WriteLCD(COMMAND, 0x53);    WriteLCD( DATA, 0x05 );
    WriteLCD(COMMAND, 0x54);    WriteLCD( DATA, 0x0A );
    WriteLCD(COMMAND, 0x55);    WriteLCD( DATA, 0x14 );
    WriteLCD(COMMAND, 0x56);    WriteLCD( DATA, 0x00 );
    WriteLCD(COMMAND, 0x57);    WriteLCD( DATA, 0x00 );
                                 // load symbol  , 0x03
    WriteLCD(COMMAND, 0x58);    WriteLCD( DATA, 0x06 );
    WriteLCD(COMMAND, 0x59);    WriteLCD( DATA, 0x09 );
    WriteLCD(COMMAND, 0x5A);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x5B);    WriteLCD( DATA, 0x1E );
    WriteLCD(COMMAND, 0x5C);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x5D);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x5E);    WriteLCD( DATA, 0x1F );
    WriteLCD(COMMAND, 0x5F);    WriteLCD( DATA, 0x00 );
                                 // load symbol Euro , 0x04
    WriteLCD(COMMAND, 0x60);    WriteLCD( DATA, 0x06 );
    WriteLCD(COMMAND, 0x61);    WriteLCD( DATA, 0x09 );
    WriteLCD(COMMAND, 0x62);    WriteLCD( DATA, 0x1c );
    WriteLCD(COMMAND, 0x63);    WriteLCD( DATA, 0x08 );
    WriteLCD(COMMAND, 0x64);    WriteLCD( DATA, 0x1c );
    WriteLCD(COMMAND, 0x65);    WriteLCD( DATA, 0x09 );
    WriteLCD(COMMAND, 0x66);    WriteLCD( DATA, 0x06 );
    WriteLCD(COMMAND, 0x67);    WriteLCD( DATA, 0x00 );
}                                               //  DispInit




/*--------------------------------------------------------------------------
 | WriteRows:   visualizza il contenuto dei buffer LCD
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/


void            WriteRows( void )
{
    byte        ncar;

    memset(LCD2serial, 0x00, sizeof(LCD2serial));
    memcpy(LCD2serial, bufferLCD, sizeof(LCD2serial)-1);
#if LCDROW == 1
    DispCursorSet( 0, 0 );
    for ( ncar = 0; ncar < LCDCOL/2; ncar++ )
        WriteLCD( DATA, bufferLCD[ncar] );
    DispCursorSet( 0, LCDCOL/2 );
    for (         ; ncar < LCDCOL  ; ncar++ )
        WriteLCD( DATA, bufferLCD[ncar] );
#else
    DispCursorSet( 0, 0 );
    for ( ncar = 0; ncar < LCDCOL; ncar++ )
        WriteLCD( DATA, bufferLCD[ncar] );
    DispCursorSet( 1, 0 );
    for ( ; ncar < 2 * LCDCOL; ncar++ )
        WriteLCD( DATA, bufferLCD[ncar] );
#endif
}                                               //  WriteRows



// Scrive 1 byte nel modulo LCD
// se addr =0 comando
// se addr =1 dato
void            WriteLCD( byte address, byte data )
{
    DISPLAY_EN_CLR;
    DYDATA(data >> 4);                  // I nibble con RS RW EN = 0
    if(address != 0) DISPLAY_RS_SET
    else             DISPLAY_RS_CLR
    DelayLCD(2);                        // 600n
    DISPLAY_EN_SET;
    DelayLCD(2);                        // 600n
    DISPLAY_EN_CLR;
    DelayLCD(1);                        // 300n
    DYDATA(data & 0x0F);   // II nibble con RS RW EN = 0
    DelayLCD(2);                        // 600n
    DISPLAY_EN_SET;
    DelayLCD(2);                        // 600n
    DISPLAY_EN_CLR;
    DelayLCD(900);                      // 100u
}

// Posiziona il cursore alle coordinate della variabile xy
void            DispCursorSet( unsigned char row, unsigned char col )
{
#if LCDROW == 1
    if ( col >= LCDCOL/2 )
        WriteLCD( COMMAND, 0x80 + 0x40 + (col-LCDCOL/2) );
    else
        WriteLCD( COMMAND, 0x80 + col );
#else
    if ( row == 0 )
        WriteLCD( COMMAND, 0x80 + col );
    else
        WriteLCD( COMMAND, 0x80 + 0x40 + col );
#endif
}

// Stampa un carattere sull'LCD puntata da ptrStr (usata solo nel test lcd)
void DispChar(unsigned char row, unsigned char col, char c)
{
  DispCursorSet(row, col);
  WriteLCD(DATA, c);
}

unsigned int timeEnable;
unsigned int durata;




// Stampa un carattere sull'LCD puntata da ptrStr
// mode = 0 new row
// mode = 1 overwrite
void            DispStr( unsigned char row, unsigned char col, char *s )
{
    char ncar;

    if ( (GetTickCount() - timeEnable) > durata )
    {
        ncar = row * LCDCOL + col;
        for( ; col < LCDCOL; col++, ncar++)
        {
            if(*s != 0 && *s != '\n')
            {
                bufferLCD[ncar] = *s;
                s++;
            }
            else
                bufferLCD[ncar] = ' ';
        }        
    }
    WriteRows();
}




// Cancella l'LCD
void            DispClrScr( void )
{
  if((GetTickCount() - timeEnable) > durata){
    memset(bufferLCD, ' ', sizeof(bufferLCD));
    DispStr(0,0,bufferLCD);
    DispStr(1,0,bufferLCD);
  }
}




// Cursore lampeggia
void            CursorBlink( unsigned char _row, unsigned char _col )
{
    WriteLCD(COMMAND,0x0F);
    DispCursorSet( _row, _col );
}




// Cursore acceso
void            CursorOn( unsigned char _row, unsigned char _col )
{
    WriteLCD(COMMAND,0x0E);
    DispCursorSet( _row, _col );
}




// Cursore off
void            CursorOff( void )
{
    WriteLCD(COMMAND,0x0C);
}




// ritarda l'LCD
void            DelayLCD( unsigned short data )
{
    unsigned int i;

    for( i = data; i != 0; i-- );
}


// visualizza mex menu
// copia il mex nel buffer poi rvisualizza il suo contenuto
void VisuaMenu(char *str)
{
  unsigned char col, ncar;

  if((GetTickCount() - timeEnable) > durata){
    while(*str >= '0' && *str <= '9') str++;  // evita il numero del livello
    ncar = 0;
    for(col = 0; col < LCDCOL; str++, col++, ncar++){
      if(*str != 0 && *str != '\n') bufferLCD[ncar] = *str;
      else{
        bufferLCD[ncar] = ' ';
        str--;
      }
    }
    if(*str != 0){
      str++;
      for(col = 0; col < LCDCOL; str++, col++, ncar++){
        if(*str != 0 && *str != '\n') bufferLCD[ncar] = *str;
        else{
          bufferLCD[ncar] = ' ';
          str--;
        }
      }
    }
    WriteRows();
  }
}


void showPleaseWait(char *str)
{
  VisuaMenu(str);
}

void            DisplayLock(unsigned int delay)
{
    timeEnable = GetTickCount();
    durata = delay;
}

#endif // RSR903
