/***************************************************************************
 ************************						****************************
 ************************		F U N Z I O N I	****************************
 ************************						****************************
 ***************************************************************************/
#define	__FUNZIONI_C




#include	<ctype.h>
#include	<stdio.h>
#ifdef	__BORLANDC__
#include	<mem.h>
#else
#include	<string.h>
#endif
#include	"def.h"
#include	"ds2341.h"
#include	"crc16.h"
#include	"display.h"
#include	"dosfs.h"
#include	"fat.h"
#include	"funzioni.h"
#include	"graphics.h"
#include	"hwinit.h"
#include	"keyboard.h"
#include	"main.h"
#include	"messaggi.h"
#include	"modem.h"
#include	"mmc.h"
#include	"ram.h"
#include	"timer.h"
#include	"uart.h"
#ifdef BOOT
// SOLO PER EVITARE ERRORI DI COMPILAZIONE //
struct  _HOST_DATA_ {
    BOOL    present;
    byte    status;
    byte    door;
    byte    comPort;
    byte    rxi;
    char    rxbuf[256];
    byte    tray, column, select;
    _Credito money, price, discounted, cashlessprice;
    DWORD   lastrx;
}  hostData;
#else
extern struct _HOST_DATA_  hostData;
#endif

extern byte SlaveStatus[MAX_MACHINE_NUM];
extern const unsigned char tabKeyRemap[TOTAL_MACHINE][MAXKEYNUM];

/* from MENU.c */
byte            enCOUPLING( unsigned char _typeVar );

static word     iSavePhoto;
static DWORD    addrSavePhoto;
static FILEINFO fiSavePhoto;
static VOLINFO  viSavePhoto;
byte            discount_test( _Credito *_amount, byte s_tray, byte s_column );
BOOL            selectionLocked( byte _tray, byte _column );
BOOL            checkTimeFrames( byte _tray, byte _column );
BOOL            testActiveMotor( byte _s_tray, byte _s_column);


void ATTIVA_CATODO( byte _k ) 
{
        if ( _k <= 7 )
          outImage[OUT_SG0_SG7  ] |=  (0x01<< _k);
        else
          outImage[OUT_SG8_SG15 ] |=  (0x01<<(_k-8));
}

void ATTIVA_ANODO( byte _an )
{
        if( _an <= 7 )
          outImage[OUT_AN0_AN7  ] &= ~(0x01<< _an);
        else if( _an <= 9 )
          outImage[OUT_SG8_SG15 ] &= ~(0x40<<(_an-8));
}

/****************************************************************************
 memclr:		pulisce un'area di memoria
								--------------
 In:
 Var:
 Out:
 Call:
 ***************************/

void			memclr( void *_mem, short _size )
{
	memset( (char *)_mem, 0, _size );
}												//	memclr




/****************************************************************************
 _atoi:		    converte in intero un numero predefinito di byte
								--------------
 In:    _str    puntatore alla stringa da convertire
        _len    dimensione massimo della stringa
 Var:
 Out:   int     valore convertito
 Call:
 ***************************/

int			    _atoi( char *_str, short _len )
{
    int         sign, i;

    i = 0;
    sign = 1;
	while( _len-- > 0 ) {
        if( *_str == '-' )
            sign = -1;
        if( *_str == '-' || *_str == '+' ) {
            _str++;
            continue;
        }
        if( !isdigit(*_str) )
            break;

        i = i*10 + (*_str++ - '0');
    }

    return sign*i;
}												//	_atoi




/****************************************************************************
 _itoa:		    converte in intero un numero predefinito di byte
								--------------
 In:    _str    puntatore alla stringa da convertire
        _len    dimensione massimo della stringa
        _val    valore da convertire
 Out:
 ***************************/

void		    _itoa( char *_str, short _len, unsigned short _val )
{
    _str += (_len-1);

    while( _len-- > 0 ) {
        *_str-- = '0'+(_val%10);
        _val /= 10;
    }
}												//	_itoa

const unsigned char tabhex[16] = { '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F' };




/*-----------------------------------------------------------------------*

Name            _longtoa - converts a long to a character string

Usage           char * _longtoa (long value, char *strP, int radix,
                                        char maybeSigned, char hexStyle);

Prototype in    _printf.h

Description     This function converts a long value to a  null-terminated string
                and  stores the result in  string strP.

                radix specifies the base to be used in converting value. it
                must be between  2 and 36 (inclusive).

                maybeSigned is treated as a boolean. If false then value is
                treated  as unsigned  long and  no sign  will be  placed in
                *strP.

                hexStyle  may take  the values  'a' or  'A' and  determines
                whether lower or  upper case alphabetics are used  when the
                radix is 11 or greater.

                Note: The space  allocated for string must be  large enough
                to hold the returned  string including the terminating null
                character (\0).  itoa can return  up to 17  bytes; ltoa and
                ultoa, up to 33 bytes.

Return value    pointer to the string

*------------------------------------------------------------------------*/

char * _longtoa ( long value, char *strP, int radix,
                        char maybeSigned, char hexStyle )
{
    char        buf [34];
    char        c, *p, *bufp;

    p = strP;

    /* If the requested radix is invalid, generate an empty result.
     */
    if (radix >= 2 && radix <= 36)
    {

        /* If the value is signed and less than zero, generate a minus sign.
         */
        if (value < 0 && maybeSigned != 0)
        {
            *p++ = '-';
            value = -value;
        }

        /* Now loop, taking each digit as modulo radix, and reducing the value
         * by dividing by radix, until the value is zeroed.  Note that
         * at least one loop occurs even if the value begins as 0,
         * since we want "0" to be generated rather than "".
         */
        bufp = buf;
        for (;;)
        {
            *bufp++ = (char)((unsigned long)value % radix);
            if ((value = (unsigned long)value / radix) == 0)
                break;
        }

        /* The digits in the buffer must now be copied in reverse order into
         * the target string, translating to ASCII as they are moved.
         */
        while (bufp != buf)
        {
            if ((c = *--bufp) < 10)
                *p++ = (char)(c + '0');
            else
                *p++ = (char)((c - 10) + hexStyle);
        }
    }

    /* terminate the output string with a zero.
     */
    *p = '\0';
    return (strP);          /* return a pointer to the string */
}




/*--------------------------------------------------------------------------
 | isBlank:     check if a string is empty
 |                              --------------
 | In:  _str    string pointer
 | Out: BOOL    TRUE    string is blank
 |              FALSE   string isn't empty
 +--------------------------------------------------------------------------*/

BOOL            isBlank( char *_str )
{
    while( *_str != '\0' )
    {
        if ( *_str++ != ' ' )
            return FALSE;
    }
    return TRUE;
}                                               //  isBlank




/*--------------------------------------------------------------------------
 +--------------------------------------------------------------------------*/


 

/*--------------------------------------------------------------------------
 | testMMCpresence:verify MMC/SD presence
 |                              --------------
 | In:
 | Out: TRUE    mmc/sd available
 |      FALSE   mmc/sd NOT available
 +--------------------------------------------------------------------------*/

byte            testMMCpresence( void )
{
#if MDB_DEBUG_MMC
    if ( mmcPresent == TRUE )
        return mmcPresent;
#endif
    mmdPhotoErr = 0;
    if ( mmcInit() == mmc_noerr )
        mmcPresent = TRUE;
    else
        mmcPresent = FALSE;
    return mmcPresent;
}                                               //  testMMCpresence




DWORD           tAdv;
byte            iAdv;
#if ENABLE_DISCOUNT
DWORD           tDis;
#endif


 

/*--------------------------------------------------------------------------
 | resetAdv:    reset advertising message
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            resetAdv( void )
{
    tAdv = GetTickCount();
    iAdv = 0;
#if ENABLE_DISCOUNT
    tDis = GetTickCount();
#endif
}                                               //  resetAdv


/*--------------------------------------------------------------------------
 | showAdv:     show advertising message or discounted products
 |                              --------------
 | In:  _str    string pointer
 | Out: BOOL    TRUE    string is blank
 |              FALSE   string isn't empty
 +--------------------------------------------------------------------------*/

#if ENABLE_DISCOUNT
byte            valid_discount_selection( byte _s_tray, byte _s_column )
{
    byte        flag;
    _Credito    amount;
    
    if ( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )
    {                                   // whole machine disable
        if ( !discount_test( &amount, DISCOUNT_TRAY, DISCOUNT_COLUMN ) )
            return FALSE;               // discounted ?
        if ( isTimedDisable() )
            return FALSE;               // tests time disable
        return TRUE;
    }

                                        // discounted ?
    if ( !discount_test( &amount, _s_tray, _s_column ) )
        return FALSE;
                                        // motor available ?
    if ( !testActiveMotor(_s_tray,_s_column) )
        return FALSE;
                                        // selection not locked ?
    if ( selectionLocked(_s_tray,_s_column) )
        return FALSE;
                                        // time available ?
    if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
        flag = checkTimeFrames( _s_column, _s_tray );
    else
        flag = checkTimeFrames( _s_tray, _s_column );
    if ( flag || isTimedDisable() )
        return FALSE;
    
    return TRUE;
}
#endif

void            showAdv( BOOL _flag, char *_disp )
{
    int         len;
#if ENABLE_DISCOUNT
    BOOL        startIdx;
    char        selID[8];
    static byte iTray = 0, iColumn = 0;
#endif
    
    if ( !_flag )
    {
        resetAdv();
        return;
    }
    
    
#if ENABLE_DISCOUNT
    if ( iTray == 0 && iColumn == 0 )
        startIdx = TRUE;
    else
        startIdx = FALSE;
    if ( tDis != 0 && (NonVolatileSetup.discountFlag == DISCOUNT_MACHINE || NonVolatileSetup.discountFlag == DISCOUNT_SELECTION) )
    {// motor coupled ? selection upfront ?
#define ON_SALE_SHOW_DELAY      (4*1000)
        if ( (GetTickCount()-tDis) > ON_SALE_SHOW_DELAY )// wait 4 sec. SELECT - - - and Exact Change
        {
            if ( valid_discount_selection( iTray, iColumn ) )
            {                           // show item if discounted
                if ( (GetTickCount()-tDis) < (6*1000) )
                {                 
                    //memset( _disp, ' ', LCDCOL );
                    if ( selection2ASCII((char *)selID, 0, iTray, iColumn, 1, machineType ) != NULL )
                    {
                        if ( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )                   
                            sprintf( _disp, " ALL ON SALE NOW" );
                        else
                            sprintf( _disp, " ON SALE NOW:%s", selID );
                        return;
                    }
                }
                                        // next selection
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                {
                    iTray++;
                    if ( iTray >= MAXTRAY )
                    {
                        iTray = 0;
                        iColumn++;
                        if ( iColumn >= MAXCOLUMN )
                            iColumn = 0;
                    }
                  
                }
                else {
                    iColumn++;
                    if ( iColumn >= MAXCOLUMN )
                    {
                        iColumn = 0;
                        iTray++;
                        if ( iTray >= MAXTRAY )
                            iTray = 0;
                    }
                }
                
            }

            _flag = FALSE;
            if ( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )
            {                           // with machine discount, only one test nedded
                iTray = 0;
                iColumn = 0;
                if ( valid_discount_selection( iTray, iColumn ) )
                    tDis = GetTickCount();// if still on discount, restart timer
                else
                    tDis = 0;           // else disable discount
                return;
            }
            else
            {
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                {                    
                    for ( iColumn %= MAXCOLUMN; iColumn < MAXCOLUMN; iColumn++ )
                    {
                        for ( iTray %= MAXTRAY; iTray < MAXTRAY; iTray++ )
                        {
                            if ( valid_discount_selection( iTray, iColumn ) )
                            {
                                _flag = TRUE;
                                break;
                            }
                        }
                        if ( iTray >= MAXTRAY )
                            iTray = 0; 
                        if ( _flag )
                            break;
                    }
                    if ( iColumn >= MAXCOLUMN )
                        iColumn = 0;                    
                }
                else {
                    for ( iTray %= MAXTRAY; iTray < MAXTRAY; iTray++ )
                    {
                        for ( iColumn %= MAXCOLUMN; iColumn < MAXCOLUMN; iColumn++ )
                        {
                            if ( valid_discount_selection( iTray, iColumn ) )
                            {
                                _flag = TRUE;
                                break;
                            }
                        }
                        if ( iColumn >= MAXCOLUMN )
                            iColumn = 0;
                        if ( _flag )
                            break;
                    }
                    if ( iTray >= MAXTRAY )
                        iTray = 0;
                }
            }
                                        // test if found
            if ( _flag )
                tDis = GetTickCount()-ON_SALE_SHOW_DELAY-1;
            else 
            {
                if ( iTray == 0 && iColumn == 0 )
                {
                    if ( startIdx )
                        tDis = 0;       // disable discount visua
                    else
                        tDis = GetTickCount();// restart timer
                }
            }
        }
    }
    else 
#endif
    if ( NonVolatileSetup.adv.tout != 0 )
    {
        if ( (GetTickCount()-tAdv) > (NonVolatileSetup.adv.tout*1000) )
        {
            memset( _disp, ' ', LCDCOL );
            if ( NonVolatileSetup.adv.speed == 0 )
            {
                for ( len = sizeof(NonVolatileSetup.adv.msg)-2; len > 0; len-- )
                {
                    if ( NonVolatileSetup.adv.msg[len] != ' ' )
                        break;
                }
                if ( len < LCDCOL )
                    memcpy( _disp+(LCDCOL/2-len/2), NonVolatileSetup.adv.msg, len+1 );
                else
                    memcpy( _disp, NonVolatileSetup.adv.msg, LCDCOL );
                if ( (GetTickCount()-tAdv) > (NonVolatileSetup.adv.tout*1000)*2 )
                    resetAdv();
                return;
            }
            
            if ( iAdv < LCDCOL )
                memcpy( &_disp[LCDCOL-iAdv], NonVolatileSetup.adv.msg, iAdv );
            else
                memcpy( _disp, &NonVolatileSetup.adv.msg[iAdv-LCDCOL], LCDCOL );
            if ( iAdv > MSG_ADV_LEN )
                memset( &_disp[MSG_ADV_LEN-(iAdv-LCDCOL)], ' ', iAdv-MSG_ADV_LEN );
            if ( (GetTickCount()-tAdv) > ((NonVolatileSetup.adv.tout*1000)+(11-NonVolatileSetup.adv.speed)*100) )//shift display
            {
                tAdv += (11-NonVolatileSetup.adv.speed)*100;//shift display
                iAdv++;
                if ( iAdv > LCDCOL && (NonVolatileSetup.adv.msg[iAdv-LCDCOL] == '\0' || (iAdv-LCDCOL) >= MSG_ADV_LEN || isBlank((char *)&NonVolatileSetup.adv.msg[iAdv-LCDCOL])) )
                {
                    iAdv = 0;
                    resetAdv();
                }
            }
        }
    }
}                                               //  showAdv




/*--------------------------------------------------------------------------
 | intelHexConvert:
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            hex2bin( byte *_dest, byte *_source )
{
    *_dest = 0;
    if ( *_source >= '0' && *_source <= '9' )
        *_dest = (*_source-'0')<<4;
    else if ( *_source >= 'A' && *_source <= 'F' )
        *_dest = (*_source-'A'+10)<<4;
    else
        return 1;
    _source++;

    if ( *_source >= '0' && *_source <= '9' )
        *_dest |= (*_source-'0');
    else if ( *_source >= 'A' && *_source <= 'F' )
        *_dest |= (*_source-'A'+10);
    else
        return 1;
    
    return 0;
}

byte            intelHexConvert( byte *_dest, byte *_len, byte *_type, DWORD *_addr, byte *_source )
{
    byte        len, dato;

    do {
        if ( *_source == '\0' )
            return 1;
    }  while( *_source++ != ':' );

    if ( hex2bin( &len, _source ) != 0 )
        return 2;
    _source += 2;

    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_addr = dato<<8;
    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_addr |= dato;

    if ( hex2bin( &dato, _source ) != 0 )
        return 2;
    _source += 2;
    *_type = dato;

    *_len = 0;
    while( len-- > 0 )
    {
        if ( hex2bin( _dest++, _source ) != 0 )
            return 2;
        _source += 2;
        *_len = *_len+1;
    }

    return 0;
}                                               //  intelHexConvert


#define FLASHSECTOR(a)  ( ((a)<0x08000)?((a)/0x01000): ( ((a)<0x78000)?((a)/0x08000+7):((a-0x78000)/0x01000+22) ) )

void            setProtectedSector( byte *_sectorErase )
{
#ifdef BOOT2                                                                             
    *(_sectorErase+FLASHSECTOR(0x08000)) = 2;// 0x08000-0x0FFFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x10000)) = 2;// 0x10000-0x17FFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x18000)) = 2;// 0x18000-0x1FFFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x20000)) = 2;// 0x20000-0x27FFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x28000)) = 2;// 0x28000-0x2FFFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x30000)) = 2;// 0x30000-0x37FFF  boot protected            
    *(_sectorErase+FLASHSECTOR(0x38000)) = 2;// 0x38000-0x3FFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x40000)) = 2;// 0x40000-0x47FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x48000)) = 2;// 0x48000-0x4FFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x50000)) = 2;// 0x50000-0x57FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x58000)) = 2;// 0x58000-0x5FFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x60000)) = 2;// 0x60000-0x67FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x68000)) = 2;// 0x68000-0x6FFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x70000)) = 2;// 0x70000-0x7FFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x78000)) = 2;// 0x78000-0x78FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x79000)) = 2;// 0x79000-0x79FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7A000)) = 2;// 0x7A000-0x7AFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7B000)) = 2;// 0x7B000-0x7BFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7C000)) = 2;// 0x7C000-0x7CFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7D000)) = 2;// 0x7D000-0x7DFFF  boot protected             
#else                                                                                    
    *(_sectorErase+FLASHSECTOR(0x00000)) = 2;// 0x00000-0x00FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x01000)) = 2;// 0x01000-0x01FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x02000)) = 2;// 0x02000-0x02FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x03000)) = 2;// 0x03000-0x03FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x04000)) = 2;// 0x04000-0x04FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x05000)) = 2;// 0x05000-0x05FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x06000)) = 2;// 0x06000-0x06FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x07000)) = 2;// 0x07000-0x07FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x78000)) = 2;// 0x78000-0x78FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x79000)) = 2;// 0x79000-0x79FFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7A000)) = 2;// 0x7A000-0x7AFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7B000)) = 2;// 0x7B000-0x7BFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7C000)) = 2;// 0x7C000-0x7CFFF  boot protected             
    *(_sectorErase+FLASHSECTOR(0x7D000)) = 2;// 0x7D000-0x7DFFF  boot protected             
                                          // 0x7E000-0x7FFFF  USED BY LPC2368 boot loader
#endif                                                                                    
}

byte    erase(byte *_sectorErase, DWORD _baseAddr, DWORD _destAddr)
{
    DWORD       eraseAddr;
    
    if ( *(_sectorErase+FLASHSECTOR(_baseAddr+_destAddr)) == 2 )
        return 1;// sector protected continue     
    if ( *(_sectorErase+FLASHSECTOR(_baseAddr+_destAddr)) == 0 )
    {                   // erase sector
#ifdef BOOT2
        if ( (_baseAddr+_destAddr) <= BOOTEND )
        {
            for ( eraseAddr = BOOTSTART; eraseAddr <= BOOTEND; eraseAddr += 0x1000 )
            {
                *(_sectorErase+FLASHSECTOR(eraseAddr)) = 1;
                EraseBlock( eraseAddr, 1 );
            }
        }            
#else            
        if ( (_baseAddr+_destAddr) >= FIRMWARESTART && (_baseAddr+_destAddr) <= FIRMWAREEND )
        {
            for ( eraseAddr = FIRMWARESTART; eraseAddr <= FIRMWAREEND; eraseAddr += 0x8000 )
            {
                *(_sectorErase+FLASHSECTOR(eraseAddr)) = 1;
                EraseBlock( eraseAddr, 1 );
            }
        }
#endif            
        else
        {
            *(_sectorErase+FLASHSECTOR(_baseAddr+_destAddr)) = 1;
            EraseBlock( _baseAddr+_destAddr, 1 );
        }
    }      
    return 0;
}

byte            flashIntelFile( WORD _cluster, DWORD _filelen )
{
    char        buf[20], i;
    byte        il, type, perc, oldperc, intelBuf[100], buflen, flBlock[256];
#ifdef BOOT2    
    WORD        fileCrc, flSize, flashCrc;
#else
    WORD        fileCrc, destCrc, flSize, flashCrc;
#endif    
    DWORD       baseAddr, destAddr, progAddr, len, startPos, flash_signature, crp;
    byte        sectorErase[28];   

    memset( sectorErase, 0, sizeof(sectorErase) );
    setProtectedSector( sectorErase );
   
    if ( FAT_openFile(_cluster,_filelen) != 0 )
        return 1;                       // unable to open file
 
                                        // read first line: program, version, checksum
    buflen = sizeof(intelBuf);
    if ( FAT_getsFile(intelBuf,&buflen) != 0 )
        return 1;
    if ( intelHexConvert(intelBuf,&il,&type,&destAddr,intelBuf) != 0 )
        return 2;                       // wrong intel format
    if ( il != 16 )
        return 2;                       // wrong intel format
    fileCrc = (((WORD)intelBuf[12]<<8)+(WORD)intelBuf[13]);
#ifndef BOOT2    
    destCrc = (((WORD)intelBuf[14]<<8)+(WORD)intelBuf[15]); 
    flashCrc = calcFirmwareCrc();
    if ( flashCrc == destCrc &&
         flashCrc == (  ( ((WORD)(*((byte *)FIRMWAREEND-1L))) <<8 )  +  ((WORD)(*((byte *)FIRMWAREEND)))  ) &&
         memcmp( intelBuf, ((byte *)(FIRMWAREEND-0xFL)), 12 ) == 0 &&
         intelBuf[14] == *((byte *)(FIRMWAREEND-0x1L)) &&
         intelBuf[15] == *((byte *)(FIRMWAREEND-0x0L)) )
        return 99;                      // file not changed, exit
#endif   
    startPos = buflen;

                                        // verify file checksum 
    len = startPos;
    BCC = 0;
    perc = oldperc = 0;   
#ifdef BOOT2     
    progAddr = BOOTSTART;   
#else//BOOT2
    progAddr = FIRMWARESTART;           // dest block address
#endif//BOOT2          // dest block address  
    flSize = 0;                         // program buffer size
    memset(flBlock,0xFF,sizeof(flBlock));// program buffer
    while ( len < _filelen )
    {
        buflen = sizeof(intelBuf);
        if ( FAT_getsFile(intelBuf,&buflen) != 0 )
            return 1;
        len += buflen;
        
        perc = (WORD)((100L*(DWORD)len)/(DWORD)_filelen);
        if ( perc != oldperc )
        {
            oldperc = perc;
            sprintf( buf, MSG_FW_CHECK_PERC, perc );
            DispStr( 0, 0, buf );
        }

        for( il = 0; il < buflen; il++ )
            crc_16(intelBuf[il]);
    }
    
    if ( BCC != fileCrc )
        return 4;   
                                        // load file
    FAT_openFile(_cluster,_filelen);//rewind
    buflen = sizeof(intelBuf);
         
    if ( FAT_getsFile(intelBuf,&buflen) != 0 )
        return 1;                       // skip first row     
    
    BCC = 0;
    perc = oldperc = 0;
#ifdef BOOT2     
    progAddr = BOOTSTART;   
#else//BOOT2
    progAddr = FIRMWARESTART;           // dest block address
#endif//BOOT2 
    len = startPos;    
    flSize = 0;                         // program buffer size
    memset(flBlock,0xFF,sizeof(flBlock));// program buffer
    while ( len < _filelen )
    {
        buflen = sizeof(intelBuf);
        if ( FAT_getsFile(intelBuf,&buflen) != 0 )
            return 1;
        len += buflen;
       
        if ( intelHexConvert(intelBuf,&il,&type,&destAddr,intelBuf) != 0 )
            return 2;                       // wrong intel format

        perc = (WORD)((100L*(DWORD)len)/(DWORD)_filelen);
        if ( perc != oldperc )
        {
            oldperc = perc;
            sprintf( buf, MSG_FW_LOAD_PERC, perc );
            DispStr( 0, 0, buf );
        }

        if ( type == 4 )
        {                               // change base address
            baseAddr = (((DWORD)intelBuf[0]<<24)+(DWORD)intelBuf[1])<<16;
            continue;
        }
        if ( type != 0 )
            return 2;                   // wrong intel format       

//        if ( sectorErase[FLASHSECTOR(baseAddr+destAddr)] == 2 )
//            continue;       // sector protected
//
//        if ( sectorErase[FLASHSECTOR(baseAddr+destAddr)] == 0 )
//        {                   // erase sector
//           sectorErase[FLASHSECTOR(baseAddr+destAddr)] = 1;
//           EraseBlock( baseAddr+destAddr, 1 );
//        }
        if (erase(sectorErase, baseAddr, destAddr) == 1)
            continue;       

        if ( (baseAddr+destAddr) >= (progAddr+sizeof(flBlock)) )
        {                               // write buffer
#ifdef BOOT2            
            if (progAddr == 0x00000000)
            {
                flash_signature = 0;
                for(i=0;i<8;i++)
                {
                    flash_signature += (((dword)flBlock[3+i*4])<<24)+
                                       (((dword)flBlock[2+i*4])<<16)+
                                       (((dword)flBlock[1+i*4])<< 8)+
                                       (((dword)flBlock[0+i*4])    );
                }
                flash_signature = ~(flash_signature);
                flBlock[20] = (byte)(flash_signature    );
                flBlock[21] = (byte)(flash_signature>> 8);
                flBlock[22] = (byte)(flash_signature>>16);
                flBlock[23] = (byte)(flash_signature>>24);                
            } 
             
#endif            
            WriteFlash256( flBlock, progAddr, 0 );            
//crp2
#ifdef BOOT2             
            if (progAddr == 0x00000000)
            {            
                memset(flBlock, 0xFF, sizeof(flBlock));
                crp = 0x87654321;
                flBlock[252] = (byte)(crp    );
                flBlock[253] = (byte)(crp>> 8);
                flBlock[254] = (byte)(crp>>16);
                flBlock[255] = (byte)(crp>>24);
                WriteFlash256( flBlock, 0x00000100, 0 );                
            }  
#endif            
//crp2             
            progAddr = ((baseAddr+destAddr)/256)*256;            
            memset(flBlock,0xFF,sizeof(flBlock));// program buffer
        }
        memcpy( &flBlock[destAddr%sizeof(flBlock)], intelBuf, il );
        flSize += il;
        
#ifdef BOOT2 
        if ( (baseAddr+destAddr) == 0x7FFF )
            break;
#else        
        if ( (baseAddr+destAddr) == 0x3FFF0 )
            break;
#endif         
    }    
    if ( flSize != 0 )
    {
        WriteFlash256( flBlock, progAddr, 0 );
    }

    if ( len != _filelen )
        return 3;

#ifdef BOOT2
    __disable_interrupt();
    MEMMAP_bit.MAP = USER_FLASH;
    flashCrc = calcBootloaderCrc();
    MEMMAP_bit.MAP = USER_RAM;
    __enable_interrupt();    
    if ( flashCrc != (  ( ((WORD)(*((byte *)BOOTEND-1))) <<8 )  +  ((WORD)(*((byte *)BOOTEND)))  ) )
        return 4;    
#else    
    flashCrc = calcFirmwareCrc();
    if ( flashCrc != destCrc || 
         flashCrc != (  ( ((WORD)(*((byte *)FIRMWAREEND-1))) <<8 )  +  ((WORD)(*((byte *)FIRMWAREEND)))  ) )
        return 4;
#endif    
    return 0;
}                                               //  flashIntelFile

void            sendAck( void )
{
    commPutChar( COMM4, 0x0D );
    commPutChar( COMM4, 0x0A );    
}

byte            serialFlashIntelFile( void )
{
    char        buf[20], err;
    byte        il, type, intelBuf[100], flBlock[256], ch;
    WORD        fileCrc, destCrc, flSize, flashCrc;
    DWORD       baseAddr, destAddr, progAddr, ijk, x, y, to_disp;
    byte        sectorErase[28];

    
    err = FALSE;
    memset( sectorErase, 0, sizeof(sectorErase) );
    setProtectedSector( sectorErase );    

    BCC = 0;
    progAddr = FIRMWARESTART;           // dest block address
    flSize = 0;                         // program buffer size
    memset(flBlock,0xFF,sizeof(flBlock));// program buffer
    x = 0; y = 0; to_disp = 0;    
    memcpy(buf, "serial loading  ", 16);        
    sendAck();
    while ( -1 )
    {
        while (commGetChar(COMM4,&ch) == COMM_RX_EMPTY);
        if ( ch == '!' )
            break;
        if ( ch == ':' )
        {
            ijk = 0;
            memset(intelBuf, 0x00, sizeof(intelBuf));
        }
        if ( ijk < sizeof(intelBuf)-1 )
            intelBuf[ijk++] = ch;                    
        if ( ch != 0x0A )                            
            continue;      
        
        if ( x == 0)
        {
            if ( intelHexConvert(intelBuf,&il,&type,&destAddr,intelBuf) != 0 )
                return 2;                       // wrong intel format
            if ( il != 16 )
                return 2;                       // wrong intel format
            fileCrc = (((WORD)intelBuf[12]<<8)+(WORD)intelBuf[13]);
            destCrc = (((WORD)intelBuf[14]<<8)+(WORD)intelBuf[15]);          
            x++;
            sendAck();
            continue;
        }
        
        for( il = 0; il < ijk; il++ )
            crc_16(intelBuf[il]);        

        if ( intelHexConvert(intelBuf,&il,&type,&destAddr,intelBuf) != 0 )
            return 2;         
        
        if (GetTickCount() - to_disp > 333)
        {
            y++;
            to_disp = GetTickCount();            
            switch (y%3)
            {
                case 0:
                    buf[15] = '|';
                    break;
                case 1:
                    buf[15] = '/';
                    break;
                case 2:
                    buf[15] = '-';
                    break;          
            }
            DispStr( 0, 0, buf );
        }
        
        if ( type == 4 )
        {                               // change base address
            baseAddr = (((DWORD)intelBuf[0]<<24)+(DWORD)intelBuf[1])<<16;
            sendAck();
            continue;
        }
        if ( type != 0 )
            return 2;                   // wrong intel format  
        
//        if ( sectorErase[FLASHSECTOR(baseAddr+destAddr)] == 2 )
//        {
//            sendAck();
//            continue;       // sector protected
//        }
//        if ( sectorErase[FLASHSECTOR(baseAddr+destAddr)] == 0 )
//        {                   // erase sector
//            sectorErase[FLASHSECTOR(baseAddr+destAddr)] = 1;
//            EraseBlock( baseAddr+destAddr, 1 );
//        }
        
        if (erase(sectorErase, baseAddr, destAddr) == 1)
            continue;

        if ( (baseAddr+destAddr) >= (progAddr+sizeof(flBlock)) )
        {                               // write buffer          
            WriteFlash256( flBlock, progAddr, 0 );
            progAddr = ((baseAddr+destAddr)/256)*256;
            memset(flBlock,0xFF,sizeof(flBlock));// program buffer
        }
        memcpy( &flBlock[destAddr%sizeof(flBlock)], intelBuf, il );
        flSize += il; 
        sendAck();       
        
        if ( (baseAddr+destAddr) == 0x3FFF0 )
            break;
    }
//ultimo record...
    
    if ( flSize != 0 )
    {
        WriteFlash256( flBlock, progAddr, 0 );
    }

    if ( BCC != fileCrc )
          err = TRUE;  
    
    flashCrc = calcFirmwareCrc();
    if ( err == TRUE ||
         flashCrc != destCrc || 
         flashCrc != (  ( ((WORD)(*((byte *)FIRMWAREEND-1))) <<8 )  +  ((WORD)(*((byte *)FIRMWAREEND)))  ) )
    {
        commPutChar( COMM4, NAK );
        sendAck();           
        return 4;
    }
    return 0;
}                                               //  serialFlashIntelFile


/*--------------------------------------------------------------------------
 | calcBootloaderCrc:calculate bootloader checksum
 |                              --------------
 | In:
 | Out: DWORD   firmware CRC-16 
 +--------------------------------------------------------------------------*/

DWORD           calcBootloaderCrc( void )
{
    DWORD       progAddr;

    BCC = 0;
    for ( progAddr = BOOTSTART; progAddr < (BOOTEND-0xF); progAddr++ )
    {
        if (progAddr>=0x00000014 && progAddr<=0x00000017)
            crc_16(0xFF);
//crp2      
        else if (progAddr>=0x000001FC && progAddr<=0x000001FF)
            crc_16(0xFF);
//crp2        
        else
            crc_16(*((byte *)progAddr));          
    }   
    return BCC;
}                                               //  calcFirmwareCrc
/*--------------------------------------------------------------------------
 | calcFirmwareCrc:calculate firmware checksum
 |                              --------------
 | In:
 | Out: DWORD   firmware CRC-16 
 +--------------------------------------------------------------------------*/

DWORD           calcFirmwareCrc( void )
{
    DWORD       progAddr;

    BCC = 0;    
    for ( progAddr = FIRMWARESTART; progAddr < (FIRMWAREEND-0xF); progAddr++ )
        crc_16(*((byte *)progAddr));   
    return BCC;
}                                               //  calcFirmwareCrc




/*--------------------------------------------------------------------------
 | checkFirmware:verify firmware checksum
 |                              --------------
 | In:
 | Out: 0       firmware ok
 |      1       firmware error
 +--------------------------------------------------------------------------*/

byte            checkFirmware( void )
{
    DWORD       flashCrc;

    flashCrc = calcFirmwareCrc();
    if ( (WORD)flashCrc != (  ( ((WORD)(*((byte *)FIRMWAREEND-1))) <<8 )  +  ((WORD)(*((byte *)FIRMWAREEND)))  ) )
        return 1;
    return 0;
}                                               //  checkFirmware




/*--------------------------------------------------------------------------
 | weekDay:     calculate day of week
 |                              --------------
 | In:
 | Out: 1..7    day of week
 +--------------------------------------------------------------------------*/

DWORD           SinceBigBang( byte gg, byte me, word an )
{
	DWORD       aa, a;

    if ( an < 1900 )
    {
    	if( an > 50 )
	    	aa = an+(long) 1900L;
    	else
	    	aa = an+(long) 2000L;
    }
    else
        aa = an;
	a = (long) 365L*aa + 31*(me-1) + gg;
	if( me > 2 )
		a = a-(((me-1)*4+27)/10);
	else
		aa--;
	a = a + aa/4 - aa/100 + aa/400;
	return a;
}												//	SinceBigBang

byte			weekDay( byte gg, byte me, word an, byte hh, byte mi )
{
	DWORD       a, kd;

	a = SinceBigBang( gg, me, an );
	kd = (( (DWORD)(a - (DWORD) 694325L + (DWORD)(( hh + mi/60) / 24) )) % (DWORD) 7L);
	return (byte)(kd+1);
}												//	weekDay




/*--------------------------------------------------------------------------
 | loadMMCsettings:save settings to MMC/SD
 |                              --------------
 | In:
 | Out: 0       ok
 |      1       file name not present
 |      2       no mmc/sd found
 |      3       partition error
 |      4       volume error
 |      5       file not present
 +--------------------------------------------------------------------------*/

char            *selection2ASCII( char *_buf, byte _machine_addr, byte _tray, byte _column, byte _reverse, byte machineForm )
{
    if ( machineForm == MACHINA_AP123 || machineForm == MACHINA_VEIDOOR || machineForm == MACHINA_VEI147 || machineForm == MACHINA_VEILCM )
    {
        if ( _tray >= 9 || _column > 9 || _machine_addr > 3 )
            return NULL;
        _buf[0] = '1'+_machine_addr;
        _buf[1] = '1'+_tray;
        _buf[2] = '0'+_column;
        _buf[3] = '\0';
    }
    else if ( machineForm == MACHINA_ROWE5900 || machineForm == MACHINA_ROWE6800 )
    {
        if ( _machine_addr > 0 )
            return NULL;
        if (_reverse)
        {
            _buf[0] = '0'+_column;
            _buf[1] = '0'+_tray;
            _buf[2] = '\0';            
        }
        else {
            _buf[0] = '0'+_tray;
            _buf[1] = '0'+_column;
            _buf[2] = '\0';
        }
    }
    else if ( machineForm == MACHINA_AMS39 || machineForm == MACHINA_USIGVC2 || machineForm == MACHINA_MERCHA6 )
    {
        if ( _machine_addr > 0 )
            return NULL;
        _buf[0] = '1'+_tray;
        _buf[1] = '0'+_column;
        _buf[2] = '\0';
    }    
    else
    {
        if ( _machine_addr > 0 )
            return NULL;        
        if ( (machineForm == MACHINA_NAT157 || machineForm == MACHINA_NAT147 || machineForm == MACHINA_AP113 ) && _tray >= 8 )
            _tray += 1;// salta I e passa a J
        _buf[0] = 'A'+_tray;
        if ( (machineForm == MACHINA_AP113 || machineForm == MACHINA_AP7000 || machineForm == MACHINA_LCM123) && _column == 0 )
        {
            _buf[1] = '1';
            _buf[2] = '0';
            _buf[3] = '\0';
        }
        else
        {
            _buf[1] = '0'+_column;
            _buf[2] = '\0';
        }
    }
    return _buf;
}                                               //  selection2ASCII




/*--------------------------------------------------------------------------
 | loadMMCsettings:save settings to MMC/SD
 |                              --------------
 | In:
 | Out: 0       ok
 |      1       file name not present
 |      2       no mmc/sd found
 |      3       partition error
 |      4       volume error
 |      5       file not present
 +--------------------------------------------------------------------------*/
byte            getSelectionParam( byte *_data, byte *_i, byte *_j, byte _reverse, byte machineFormat )
{
#if 1
    byte        *p = _data, tray, col;
    if ( machineFormat == MACHINA_AP123 || machineFormat == MACHINA_VEIDOOR || machineFormat == MACHINA_VEI147 || machineFormat == MACHINA_VEILCM )
    {
#if SLAVE_MACHINE
        slave_mac = *p++ - '0';
        if( slave_mac < 1 || slave_mac > MAX_MACHINE_NUM+1 ) // +1 referred to the shelf product 5xx
            return 1;
#else
        slave_mac = 1;
        if ( *p++ != '1' )
            return 1;
#endif
        tray = *p++;
        col = *p;
        if ( !isdigit(tray) )
            return 2;
        if ( !isdigit(col) )
            return 3;
        *_i = tray-'1';
        *_j = col-'0';        
    }
    else if ( machineFormat == MACHINA_ROWE5900 || machineFormat == MACHINA_ROWE6800 || 
              machineFormat == MACHINA_AMS39 || machineFormat == MACHINA_USIGVC2 || machineFormat == MACHINA_MERCHA6 )
    {
        slave_mac = 1;
        if ( _reverse && machineFormat != MACHINA_AMS39 ) // VERIFICARE MACHINA_USIGVC2
        {
            tray = *p++;
            col = *p;
        }
        else
        {
            col = *p++;
            tray = *p;
        }
        if ( tray < '0' || tray > ('0'+MAXTRAY) )
            return 2;
        if ( col < '0' || col > ('0'+MAXCOLUMN) )
            return 3;
        *_i = tray-'0';
        *_j = col-'0';
    }
    else
    {
        slave_mac = 1;
        tray = *p++;
        col = atoi((char *)p);
        if ( tray < 'A' || tray > ('A'+MAXTRAY) )
            return 2;
        if ( (machineFormat == MACHINA_AP113 || machineFormat == MACHINA_AP7000 || machineFormat == MACHINA_LCM123) && col == 10 )
            col = 0;
        if ( col >= MAXCOLUMN )
            return 3;
        if ( (machineFormat == MACHINA_NAT157 || machineFormat == MACHINA_NAT147 || machineFormat == MACHINA_AP113 ) && tray >= 'J' )
            tray -= 1;// salta I e passa a J
        *_i = tray-'A';
        *_j = col;
    }
    return 0;
#else
    char        *p1, *p2;
    
    p1 = strchr( (char *)_data, '.' );
    p2 = strchr( (char *)_data, ';' );
    if ( p1 == NULL || p2 == NULL || p1 > p2 )
        return 1;
    p1++;
    if ( *p1 < 'A' || *p1 > ('A'+MAXTRAY) )
        return 2;
    *_i = *p1-'A';
    p1++;
    *_j = atoi(p1)-1;
    if ( *_j >= MAXCOLUMN )
        return 3;
    return 0;
#endif
}

DWORD           cpyUint32Param( byte *_data, DWORD _min, DWORD _max )
{
    char        *p;
    DWORD       val;

    p = strchr( (char *)_data, ';' );
    if ( p == NULL )
        return 0xFFFFFFFF;
    val = (DWORD)atol(p+1);
    if ( _min != _max )
    {
        if ( val <= _min )
            return _min;
        if ( val >= _max )
            return _max;
    }
    return val;
}

byte            cpyStringParam( byte *_msg, byte *_data, byte _len )
{
    char        *p;

    if ( _len == 0 )
        return 0;
    p = strchr( (char *)_data, ';' );
    if ( p == NULL )
        return 1;
    _len--;
    strncpy( (char *)_msg, p+1, _len );
    while ( _len-- > 0 )
    {
        if ( *_msg < ' ' )
            *_msg = ' ';
        _msg++;
    }
    return 0;
}

byte            loadMMCsettings( byte _superUser )
{
    byte        data[128];
	uint32_t    pstart, psize, pos;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;
    uint32_t    successcount;

    DispStr( 0, 0, (char *)MSG_ATTESA );
    if ( NonVolatileSetup.settingsID[0] <= ' ' || NonVolatileSetup.settingsID[0] > 0x7F )
    {
		DispStr( 0, 0, " PROGR.FILE NAME" );
        return 1;
    }
    memset( data, 0, sizeof(data) );
    strcpy( (char *)data, (char *)NonVolatileSetup.settingsID );
    if ( data[8] <= ' ' )
        strcpy( (char *)&data[8], ".CSV" );
    
    if ( mmcInit() != mmc_noerr )
    {
		DispStr( 0, 0, " NO MMC/SD FOUND" );
        return 2;
    }

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff ) 
    {
		DispStr( 0, 0, " PARTITION ERROR" );
		return 3;
	}

	if ( DFS_GetVolInfo(0, sector, pstart, &vi) ) 
    {
		DispStr( 0, 0, " VOLUME ERROR   " );
		return 4;
	}

	if ( DFS_OpenFile(&vi, data, DFS_READ, sector, &fi) != 0 ) 
    {
		DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
		return 3;
    }
    pos = 0;

    successcount = sizeof(data);
    
    memset(group,0x00,sizeof(group));
    while( dosfs_getsFile( &fi, &pos, sector, data, &successcount ) == 0 )
    {
        loadConfigString(data,_superUser,machineType,FALSE);
        successcount = sizeof(data);
    }
    saveAmount();
    saveSettings();

    return 0;
}                                               // loadMMCsettings




/*--------------------------------------------------------------------------
 | loadConfigString:manage string from configuration file
 |                              --------------
 | In:
 | Out: 0       ok
 |      1       not present
 +--------------------------------------------------------------------------*/

byte            memicmp( byte *_str1, char *_str2, byte _len )
{
    byte        ch1, ch2;
    
    while ( _len-- > 0 )
    {
        ch1 = toupper(*_str1++);
        ch2 = toupper(*_str2++);
        if ( ch1 != ch2 )
            return 1;
    }
    return 0;
}

byte            loadConfigString( byte *_data, byte _superUser, byte machineFormat, byte _enAsset )
{
    byte        i, j, k;
    int         a1,a2,a3,a4,a5,a6,a7;
    byte        r, c, *p;
    DWORD       val;
        
    if ( memicmp( _data, "sel.", 4 ) == 0 )
    {
        if ( getSelectionParam(&_data[4],&i,&j,0, machineFormat ) == 0 )
            amount[slave_mac-1][i][j] = cpyUint32Param( _data, 0, MAXSELECTIONPRICE );
        exeSaveSettings = 5000;
    }
    else if ( _superUser )
    {
             if ( memicmp( _data, "adv.msg",       7 ) == 0 )    cpyStringParam( NonVolatileSetup.adv.msg, _data, sizeof(NonVolatileSetup.adv.msg) );
        else if ( memicmp( _data, "adv.delay",     9 ) == 0 )    NonVolatileSetup.adv.tout = cpyUint32Param( _data, 0, 99 );
        else if ( memicmp( _data, "adv.speed",     9 ) == 0 )    NonVolatileSetup.adv.speed = cpyUint32Param( _data, 0, 9 );
        else if ( memicmp( _data, "gp.G",          4 ) == 0 )     
        {
            i = atoi((char *)&_data[4]);            
            if ( i < MAXselGROUP )
                grp_price[i] = cpyUint32Param( _data, 0, MAXSELECTIONPRICE );
        }
        else if ( memicmp( _data, "gs.G0",         5 ) == 0 )     
        {
            i = atoi((char *)&_data[5]);
            if ( i < MAXselGROUP )
            {
                p = _data;
                for ( j = 0; j < MAXselGROUP; j++ )
                {
                    p = (byte *)strchr( (char *)p, ';' );
                    if ( p == NULL )
                        break;
                    p++;
                    if ( getSelectionParam(p,&r,&c,1, machineFormat) != 0 )
                        break;
                    j = r*10+c;
                    group[_GROUP_SEL].info[j] = i+1;
                }
            }
        }
        else if ( memicmp( _data, "gt.G1",         5 ) == 0 )     
        {
            i = atoi((char *)&_data[5]);                            
            if ( i < MAXselGROUP )
            {
                p = _data;
                for ( j = 0; j < MAXselGROUP; j++ )
                {
                    p = (byte *)strchr( (char *)p, ';' );
                    if ( p == NULL )
                        break;
                    p++;
                    if ( getSelectionParam(p,&r,&c,1, machineFormat) != 0 )
                        break;
                    j = r*10+c;
                    group[_SEL_TIMEFRAMES].info[j] = i+1;
                }
            }
        }
        else if ( memicmp( _data, "tf.",           3 ) == 0 )     
        {
            i = sscanf( (char *)&_data[3], "%d;G%d;%d;0;%d.%d;%d.%d",&a1,&a2,&a3,&a4,&a5,&a6,&a7);
            if ( i == 7 && a1 < MAXTIMEFRAMES )
            {
                timeFrames[a1].group = a2;
                timeFrames[a1].weekDay = a3;
                timeFrames[a1].disable.hour = a4;
                timeFrames[a1].disable.min = a5;
                timeFrames[a1].enable.hour = a6;
                timeFrames[a1].enable.min = a7;
            }
        }
        else if ( memicmp( _data, "dropSensor",   10 ) == 0 )
        {
            NonVolatileSetup.fallSensorMode = cpyUint32Param( _data, 0, 4 );
            memset( enDrop, NonVolatileSetup.fallSensorMode, sizeof( enDrop ) );
        }
        else if ( memicmp( _data, "ds.",           3 ) == 0 )
        {
            if ( getSelectionParam(&_data[3],&i,&j,0, machineFormat ) == 0 )
                enDrop[i][j] = cpyUint32Param( _data, 0, 4 );
        }
        else if ( memicmp( _data, "set.escrow",   10 ) == 0 )     {val = cpyUint32Param(_data,0,0); NonVolatileSetup.setEscrow = (val==0||val==2)?val:1;}
        else if ( memicmp( _data, "set.forceVend",10 ) == 0 )     NonVolatileSetup.setForceVend = (cpyUint32Param(_data,0,0)==0)?0:0x69;
        else if ( memicmp( _data, "set.fillTube", 10 ) == 0 )     NonVolatileSetup.setFillTube = (cpyUint32Param(_data,0,0)==0)?0x68:0;
        else if ( memicmp( _data, "set.percDimming", 15 ) == 0 )  NonVolatileSetup.percDimming = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.timeDimming", 15 ) == 0 )  NonVolatileSetup.timeDimming = cpyUint32Param(_data,0,30*60);
//        else if ( memicmp( _data, "set.sensitivity", 15 ) == 0 )  NonVolatileSetup.sensitivity = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.motorCoupled.", 17 ) == 0 )
        {
            if ( getSelectionParam(&_data[17],&i,&j,0, machineFormat) == 0 )
                if ( VED1000_en == FALSE )
                    NonVolatileSetup.motorCoupled[i][j] = (cpyUint32Param(_data,0,1)?j+1:0);
                else
                    NonVolatileSetup.motorCoupled[i][j] = cpyUint32Param(_data,0,9);
        }
                                        // release 2.    
        else if ( memicmp( _data, "set.setSingleVend", 17 ) == 0 )NonVolatileSetup.setSingleVend = (cpyUint32Param(_data,0,0)==0)?0:1;
        else if ( memicmp( _data, "set.tubeValue", 13 ) == 0 )    NonVolatileSetup.tubeValue = cpyUint32Param(_data,0,9999);
        else if ( memicmp( _data, "set.DropHome", 12 ) == 0 )     NonVolatileSetup.DropHome = cpyUint32Param(_data,0,1);
        else if ( memicmp( _data, "set.percTax",  11 ) == 0 )     NonVolatileSetup.percTax = cpyUint32Param(_data,0,9999);
        else if ( memicmp( _data, "set.WinValue", 12 ) == 0 )     NonVolatileSetup.WinValue = cpyUint32Param(_data,0,499);
        else if ( memicmp( _data, "set.discountFlag", 16 ) == 0 ) NonVolatileSetup.discountFlag = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountPerc1", 17) == 0 ) NonVolatileSetup.discountPerc1 = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountDays1", 17) == 0 ) NonVolatileSetup.discountDays1 = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountPerc2", 17) == 0 ) NonVolatileSetup.discountPerc2 = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountDays2", 17) == 0 ) NonVolatileSetup.discountDays2 = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountDaysR", 17) == 0 ) NonVolatileSetup.discountDaysReset = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountMaxSel", 18) == 0 ) NonVolatileSetup.discountMaxSel = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.discountDoorClear", 21) == 0 ) NonVolatileSetup.discountDoorClear = (cpyUint32Param(_data,0,0)==1)?0x71:0;
        else if ( memicmp( _data, "set.Temperatura", 15) == 0 ) { if( _data[15] != '?' ) NonVolatileSetup.Temperatura = cpyUint32Param(_data,0,99);
                                                                  else { 
                                                                    sprintf( (char *)&_data[15], ";%ld\r\n", NonVolatileSetup.Temperatura ); 
                                                                    return 0;
                                                                  }
                                                                }      
        else if ( memicmp( _data, "td.disable.", 11 ) == 0 )
        {
            i = sscanf( (char *)&_data[11], "%d;%d,%d,%d,%d",&a1,&a2,&a3,&a4,&a5);
            if ( i == 5 && a1 < sizeof(timeDisable)/sizeof(struct _TIMEDISABLE_) )
            {
                timeDisable[a1].disable.weekDay = a2;
                timeDisable[a1].disable.hour = a3;
                timeDisable[a1].disable.min = a4;
                timeDisable[a1].disable.am_pm = a5;
            }
        }
        else if ( memicmp( _data, "td.enable.", 10 ) == 0 )
        {
            i = sscanf( (char *)&_data[10], "%d;%d,%d,%d,%d",&a1,&a2,&a3,&a4,&a5);
            if ( i == 5 && a1 < sizeof(timeDisable)/sizeof(struct _TIMEDISABLE_) )
            {
                timeDisable[a1].enable.weekDay = a2;
                timeDisable[a1].enable.hour = a3;
                timeDisable[a1].enable.min = a4;
                timeDisable[a1].enable.am_pm = a5;
            }
        }
        else if ( memicmp( _data, "selLockout.", 11 ) == 0 || memicmp( _data, "selUpfront.", 11 ) == 0 )
        {
            i = atoi((char *)&_data[11]);
            if ( memicmp( _data, "selLockout.", 11 ) == 0 )
                k = _SEL_LOCKOUT;
            else
                k = _SEL_UPFRONT;  
            if ( i < MAXselGROUP )
            {            
                p = _data;
                for ( j = 0; j < MAXselGROUP; j++ )
                {
                    p = (byte *)strchr( (char *)p, ';' );
                    if ( p == NULL )
                        break;
                    p++;
                    if ( getSelectionParam(p,&r,&c,1, machineFormat) != 0 )
                        break;
                    j = r*10+c;
                    group[k].info[j] = i+1;
                }
            }
        }
        else if ( memicmp( _data, "selHealth.", 10 ) == 0 )
        {
            i = atoi((char *)&_data[10]);
            if ( i < MAXselGROUP )
            {            
                p = _data;
                for ( j = 0; j < MAXselGROUP; j++ )
                {
                    p = (byte *)strchr( (char *)p, ';' );
                    if ( p == NULL )
                        break;
                    p++;
                    if ( getSelectionParam(p,&r,&c,1, machineFormat) != 0 )
                        break;
                    j = r*10+c;
                    group[_SEL_HEALTH].info[j] = i+1;
                }
            }
        }
        else if ( _enAsset && memicmp( _data, "assetID;", 8 ) == 0 )
        {
            memset( NonVolatileSetup.assetID, 0, sizeof(NonVolatileSetup.assetID) );
            for ( j = 0; j < sizeof(NonVolatileSetup.assetID)-1; j++ )
            {
                if ( isalnum(_data[8+j]) )
                    NonVolatileSetup.assetID[j] = _data[8+j];
                else
                    break;
            }
        }
        else if ( memicmp( _data, "set.ledOnTimeOut", 16 ) == 0 )  NonVolatileSetup.ledOnTimeOut = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.flashingLedOn", 17 ) == 0 )  NonVolatileSetup.flashingLedOn = cpyUint32Param(_data,0,100);
        else if ( memicmp( _data, "set.flashingLedOff", 18 ) == 0 )  NonVolatileSetup.flashingLedOff = cpyUint32Param(_data,0,100);
        else    
            return 1;//skip
        exeSaveSettings = 5000;
    }
    *_data = 0;
    return 0;
}                                               //  loadConfigString




/*--------------------------------------------------------------------------
 | saveMMCsettings:save settings to MMC/SD
 |                              --------------
 | In:
 | Out: 0       ok
 |      1       file name not present
 |      2       no mmc/sd found
 |      3       partition error
 |      4       volume error
 |      5       file not present
 +--------------------------------------------------------------------------*/

void            hostPutChar( byte _str )
{
    int         retry;
    
    for ( retry = 0; retry < 5; retry++ )          
    {
        if ( commPutChar( hostData.comPort, _str ) == COMM_NO_ERR )
            break;
        Delay(20);
    }
}                                               //  commPutStr

void            hostPutStr( byte *_str )
{
    while ( *_str != '\0' )
    {
        hostPutChar( *_str );
        _str++;
    }
}                                               //  commPutStr

static void     xxx_write( FILEINFO *_fi, byte *_data, int _len )
{
    uint32_t    successcount;

    if ( _fi == NULL )
    {
        hostPutChar( STX );
        hostPutStr ( _data );
    }
    else
        DFS_WriteFile( _fi, sector, _data, &successcount, _len );
}

static void     saveMMCdata( FILEINFO *_fi, byte *_data, char *_fmt, dword _value )
{
    sprintf( (char *)_data, _fmt, _value );
    xxx_write( _fi, _data, strlen((char *)_data) );
}

void            writeGroupSel( byte grp_index, byte *str, byte _machineType, FILEINFO *_fi )
{
    byte        f, sel_grp[MAXselGROUP];    
    word        q, j, k;
    byte        data[512], selID[8];    
    
    k = 0;
    f = 0;
    memset(sel_grp, 0, sizeof(sel_grp));
    for ( q = 0; q < MAXselGROUP; q++ )
    {
        if ( (group[grp_index].info[q] == 0) || (group[grp_index].info[q] == 0xFF) )
            continue;
        if (sel_grp[q] == 0) 
        {
            if ( selection2ASCII( (char *)selID, 0, q/10, q%10, 1, _machineType  ) == NULL )
                continue;           
            if ( !f )
            {
                if (grp_index == _GROUP_SEL || grp_index == _SEL_TIMEFRAMES) 
                    k = sprintf( (char *)data, "%s%d", str, group[grp_index].info[q]-1);
                else 
                    k = sprintf( (char *)data, "%s.%d", str, group[grp_index].info[q]-1);
                 f = 1;
            }       
            sel_grp[q] = 1;
            k += sprintf( (char *)&data[k], ";%s", selID );           
            for ( j = q+1; j < MAXselGROUP; j++ )
            {
                if (group[grp_index].info[q] == group[grp_index].info[j] && sel_grp[j] == 0)
                {
                    sel_grp[j] = 1;
                    if ( selection2ASCII( (char *)selID, 0, j/10, j%10, 1, _machineType  ) == NULL )
                        continue;
                    k += sprintf( (char *)&data[k], ";%s", selID );
                }
            }
        }
        if ( f )
        {
            k += sprintf( (char *)&data[k], "\r\n" );
            xxx_write( _fi, data, k );
            k = 0;
            f = 0;
            memset(data, 0, sizeof(data));
        }
    }
}

byte            sendSettings( byte _superUser, FILEINFO *_fi, byte _machineType )
{
    char        *p;
    byte        i, j, k;
    byte        data[64], selID[8];
    struct _TIMEDISABLE_ *pTd;

//header
    strcpy( (char *)data, "CSV;1.0.0\r\n" );
    xxx_write( _fi, data, strlen((char *)data) );
//machine name
    sprintf( (char *)data, "machine;%s\r\n", MachineTypeID );
    xxx_write( _fi, data, strlen((char *)data) );
    p = getBootVer();
    sprintf( (char *)data, "boot;#%c.%c.%c\r\n", *(p+9), *(p+10), *(p+11) );
    xxx_write( _fi, data, strlen((char *)data) );
    p = (char *)(FIRMWARE_VER);
    sprintf( (char *)data, "firmware;#%c.%c.%c.%c\r\n", *(p+8), *(p+9), *(p+10), *(p+11) );
    xxx_write( _fi, data, strlen((char *)data) );
    sprintf( (char *)data, "assetID;%s\r\n", NonVolatileSetup.assetID );
    xxx_write( _fi, data, strlen((char *)data) );
    sprintf( (char *)data, "ddmmyyyy;%d/%d/%d %d:%d\r\n", dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.min );
    xxx_write( _fi, data, strlen((char *)data) );
//selection prices
    strcpy( (char *)data, "selection;value\r\n" );
    xxx_write( _fi, data, strlen((char *)data) );
    for( k = 0; k < MAX_MACHINE_NUM; k ++ )
    {
      for ( i = 0; i < MAXTRAY; i++ )
      {
        if ( i == 0 && (_machineType == MACHINA_ROWE5900 || _machineType == MACHINA_ROWE6800) )
            continue;
        for ( j = 0; j < MAXCOLUMN; j++ )
        {
            if ( selection2ASCII( (char *)selID, k, i, j, 0, _machineType  ) == NULL )
                continue;
            sprintf( (char *)data, "sel.%s;%d\r\n", selID, amount[k][i][j] );
            xxx_write( _fi, data, strlen((char *)data) );
        }
      }
    }   
    if ( _superUser )
    {
//ads
        sprintf( (char *)data, "adv.msg;%s\r\n", NonVolatileSetup.adv.msg );
        xxx_write( _fi, data, strlen((char *)data) );
        sprintf( (char *)data, "adv.delay;%d\r\n", NonVolatileSetup.adv.tout );
        xxx_write( _fi, data, strlen((char *)data) );
        sprintf( (char *)data, "adv.speed;%d\r\n", NonVolatileSetup.adv.speed );
        xxx_write( _fi, data, strlen((char *)data) );
//group
        strcpy( (char *)data, "group;amount\r\n" );
        xxx_write( _fi, data, strlen((char *)data) );
        for ( i = 0; i < MAXselGROUP; i++ )
        {
            sprintf( (char *)data, "gp.G%d;%d\r\n", i, grp_price[i] );
            xxx_write( _fi, data, strlen((char *)data) );
        }
    //edSetGroup
        strcpy( (char *)data, "priceGroup;selections\r\n" );
        xxx_write( _fi, data, strlen((char *)data) );    
        writeGroupSel(_GROUP_SEL, "gs.G0", _machineType, _fi);
        strcpy( (char *)data, "selGroup;selections\r\n" );
        xxx_write( _fi, data, strlen((char *)data) ); 
        writeGroupSel(_SEL_TIMEFRAMES, "gt.G1", _machineType, _fi);
    //edSetHours
//timeframes
        strcpy( (char *)data, "timeframe;group;day;off;on\r\n" );
        xxx_write( _fi, data, strlen((char *)data) );
        for ( i = 0; i < MAXTIMEFRAMES; i++ )
        {
            sprintf( (char *)data, "tf.%d;G%d;%d;0;%02d.%02d;%02d.%02d\r\n", i, timeFrames[i].group, timeFrames[i].weekDay, 
                                    timeFrames[i].disable.hour, timeFrames[i].disable.min,
                                    timeFrames[i].enable.hour,  timeFrames[i].enable.min );
            xxx_write( _fi, data, strlen((char *)data) );
        }

//machine settings
        strcpy( (char *)data, "setting;value\r\n" );
        xxx_write( _fi, data, strlen((char *)data) );
        sprintf( (char *)data, "dropSensor;%d\r\n", NonVolatileSetup.fallSensorMode );
        xxx_write( _fi, data, strlen((char *)data) );
        for ( i = 0; i < MAXTRAY; i++ )
        {
            for ( j = 0; j < MAXCOLUMN; j++ )
            {
                if ( enDrop[i][j] == NonVolatileSetup.fallSensorMode )
                    continue;
//                sprintf( (char *)data, "ds.%c%d;%d\r\n", 'A'+i, j+1, enDrop[i][j] );
                if ( selection2ASCII((char *)selID,0,i,j,0, _machineType ) == NULL )
                    continue;
                sprintf( (char *)data, "ds.%s;%d\r\n", selID, enDrop[i][j] );
                xxx_write( _fi, data, strlen((char *)data) );
            }
        }
        saveMMCdata( _fi, data, "set.escrow;%ld\r\n", (NonVolatileSetup.setEscrow==0||NonVolatileSetup.setEscrow==2)?NonVolatileSetup.setEscrow:1 );
        saveMMCdata( _fi, data, "set.forceVend;%ld\r\n", (NonVolatileSetup.setForceVend!=0x69)?0:1 );
        saveMMCdata( _fi, data, "set.fillTube;%ld\r\n", (NonVolatileSetup.setFillTube==0x68)?0:1 );

        saveMMCdata( _fi, data, "set.percDimming;%ld\r\n", NonVolatileSetup.percDimming );
        saveMMCdata( _fi, data, "set.timeDimming;%ld\r\n", NonVolatileSetup.timeDimming );
//n/a        saveMMCdata( _fi, data, "set.sensitivity;%ld\r\n", NonVolatileSetup.sensitivity );

        if (  enCOUPLING( 0 ) == 0 )
        {
            for ( i = 0; i < MAXTRAY; i++ )
            {
                for ( j = 0; j < MAXCOLUMN; j += 2 )
                {
//                    sprintf( (char *)data, "set.motorCoupled.%c%d;%d\r\n", 'A'+i, j+1, NonVolatileSetup.motorCoupled[i][j] );
                    if ( selection2ASCII((char *)selID,0,i,j,0, _machineType ) == NULL )
                        continue;
                    sprintf( (char *)data, "set.motorCoupled.%s;%d\r\n", selID, NonVolatileSetup.motorCoupled[i][j] );
                    xxx_write( _fi, data, strlen((char *)data) );
                }
            }
        }
                                        // release 2.
        saveMMCdata( _fi, data, "set.setSingleVend;%ld\r\n", NonVolatileSetup.setSingleVend );
        saveMMCdata( _fi, data, "set.tubeValue;%ld\r\n", NonVolatileSetup.tubeValue );
        saveMMCdata( _fi, data, "set.DropHome;%ld\r\n", NonVolatileSetup.DropHome );
        saveMMCdata( _fi, data, "set.percTax;%ld\r\n", NonVolatileSetup.percTax );
        saveMMCdata( _fi, data, "set.WinValue;%ld\r\n", NonVolatileSetup.WinValue );

        saveMMCdata( _fi, data, "set.discountFlag;%ld\r\n", NonVolatileSetup.discountFlag );
        saveMMCdata( _fi, data, "set.discountPerc1;%ld\r\n", NonVolatileSetup.discountPerc1 );
        saveMMCdata( _fi, data, "set.discountDays1;%ld\r\n", NonVolatileSetup.discountDays1 );
        saveMMCdata( _fi, data, "set.discountPerc2;%ld\r\n", NonVolatileSetup.discountPerc2 );
        saveMMCdata( _fi, data, "set.discountDays2;%ld\r\n", NonVolatileSetup.discountDays2 );
        saveMMCdata( _fi, data, "set.discountDaysReset;%ld\r\n", NonVolatileSetup.discountDaysReset );
        saveMMCdata( _fi, data, "set.discountMaxSel;%ld\r\n", NonVolatileSetup.discountMaxSel );
        saveMMCdata( _fi, data, "set.discountDoorClear;%ld\r\n", (NonVolatileSetup.discountDoorClear==0x71)?1:0 );
        saveMMCdata( _fi, data, "set.Temperatura;%ld\r\n", NonVolatileSetup.Temperatura );

        pTd = &timeDisable[0];
        for ( i = 0; i < sizeof(timeDisable)/sizeof(struct _TIMEDISABLE_); i++, pTd++ )
        {
            if ( pTd->disable.weekDay > EVERYDAYS || pTd->disable.hour > 12 || pTd->disable.min > 59 ||
                 pTd->enable.weekDay  > EVERYDAYS || pTd->enable.hour  > 12 || pTd->enable.min  > 59 )
                continue;
            sprintf( (char *)data, "td.disable.%d;%d,%d,%d,%d\r\n", i, pTd->disable.weekDay, pTd->disable.hour, pTd->disable.min, pTd->disable.am_pm );
            xxx_write( _fi, data, strlen((char *)data) );
            sprintf( (char *)data, "td.enable.%d;%d,%d,%d,%d\r\n", i, pTd->enable.weekDay, pTd->enable.hour, pTd->enable.min, pTd->enable.am_pm );
            xxx_write( _fi, data, strlen((char *)data) );
        }   
        writeGroupSel(_SEL_UPFRONT, "selUpfront", _machineType, _fi);        
        writeGroupSel(_SEL_LOCKOUT, "selLockout", _machineType, _fi);
        writeGroupSel(_SEL_HEALTH,  "selHealth", _machineType, _fi);  
        saveMMCdata( _fi, data, "set.ledOnTimeOut;%ld\r\n", NonVolatileSetup.ledOnTimeOut );
        saveMMCdata( _fi, data, "set.flashingLedOn;%ld\r\n", NonVolatileSetup.flashingLedOn );
        saveMMCdata( _fi, data, "set.flashingLedOff;%ld\r\n", NonVolatileSetup.flashingLedOff );
    }

    return 0;
}                                               // saveSettings

byte            saveMMCsettings( byte _superUser )
{
    byte        data[64];
	uint32_t    pstart, psize;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;
    
    DispStr( 0, 0, (char *)MSG_ATTESA );
    if ( NonVolatileSetup.settingsID[0] <= ' ' || NonVolatileSetup.settingsID[0] > 0x7F )    
    {
		DispStr( 0, 0, " PROGR.FILE NAME" );
        return 1;
    }
    memset( data, 0, sizeof(data) );
    strcpy( (char *)data, (char *)NonVolatileSetup.settingsID );
    if ( data[8] <= ' ' )
        strcpy( (char *)&data[8], ".CSV" );
    
    if ( mmcInit() != mmc_noerr )
    {
		DispStr( 0, 0, " NO MMC/SD FOUND" );
        return 2;
    }

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff ) 
    {
		DispStr( 0, 0, " PARTITION ERROR" );
		return 3;
	}

	if ( DFS_GetVolInfo(0, sector, pstart, &vi) )
    {
		DispStr( 0, 0, " VOLUME ERROR   " );
		return 4;
	}
                                        // delete file before write
    DFS_UnlinkFile(&vi, data, sector);
                                        // open file to write
	if ( DFS_OpenFile(&vi, data, DFS_WRITE, sector, &fi) != 0 ) 
    {
		DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
		return 3;
    }

    return sendSettings( _superUser, &fi, machineType );
}                                               // saveMMCsettings


/*--------------------------------------------------------------------------
 | buildUniqueFileName:biuld a unique file name ( 8.3 )
 |                              --------------
 | In:  pointer to array with the filename ( 11 characters 
 | Out: --
 +--------------------------------------------------------------------------*/

void  buildUniqueFileName( char *data )
{
    char        pName[8];
	uint8_t     pactive, ptype;
    uint32_t    pstart;
    
    pstart = (dateTime.year-2008)&0x07;
    pstart = pstart*12 + (dateTime.month-1);
    pstart = pstart*31 + (dateTime.day-1);
    pstart = pstart*24 + (dateTime.hour-1);
    pstart = pstart*60 + (dateTime.min);
    pstart = pstart*2  + (dateTime.sec/30);
    _longtoa ( pstart, pName, 32, FALSE, 'A' );     // convert long to character string, base 32, max 7 charactres
    strcpy( data, "________.___" );
    memcpy( (char *)&data[8-strlen(pName)], pName, strlen(pName) );
    pactive = 0;
    for ( ptype = 0; ptype < strlen((char *)NonVolatileSetup.assetID) && pactive < 3; ptype++ )
    {
        if ( isalnum(NonVolatileSetup.assetID[ptype]) ) 
            data[pactive++] = NonVolatileSetup.assetID[ptype];
    }
}

/*--------------------------------------------------------------------------
 | saveMMCphoto:save images to MMC/SD
 |                              --------------
 | In:
 | Out: 0       ok
 |      1       file name not present
 |      2       no mmc/sd found
 |      3       partition error
 |      4       volume error
 |      5       file not present
 +--------------------------------------------------------------------------*/

extern  byte linebuffer[];
#define SAVE_BMP    1
#define bmp_hdr ((bmp_fileheader_type *)linebuffer)
#define bmp_inf ((bmp_infoheader_type *)linebuffer)

byte            initMMCphoto( void )
{
    iSavePhoto = 0;
    return 0;
}                                               //  initMMCphoto

byte            saveMMCphoto( void )
{
    byte        data[64];
	uint8_t     pactive, ptype;
	uint32_t    psize;
    uint32_t    pstart;
    uint32_t    successcount;

    if ( iSavePhoto )
        return 0;

    memset( &fiSavePhoto, 0, sizeof(fiSavePhoto) );
    memset( &viSavePhoto, 0, sizeof(viSavePhoto) );
    
    buildUniqueFileName( (char *)&data[0] );    
    data[9] = 'B';
    data[10] = 'M';
    data[11] = 'P';
    
    if ( mmcInit() != mmc_noerr )
    {
		DispStr( 0, 0, " NO MMC/SD FOUND" );
        return 2;
    }

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff ) 
    {
		DispStr( 0, 0, " PARTITION ERROR" );
		return 3;
	}

	if ( DFS_GetVolInfo(0, sector, pstart, &viSavePhoto) )
    {
		DispStr( 0, 0, " VOLUME ERROR   " );
		return 4;
	}

	if ( DFS_OpenFile(&viSavePhoto, data, DFS_WRITE, sector, &fiSavePhoto) != 0 ) 
    {
		DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
		return 5;
    }
    BuzzerOn(500);
                                        // scrive header del file BMP
    memset( &linebuffer[0], 0, sizeof(bmp_fileheader_type) );
    bmp_hdr->bfType[0] = 'B';
    bmp_hdr->bfType[1] = 'M';
    bmp_hdr->biSizeLL = 0x36;
    bmp_hdr->biSizeLH = 0x10;
    bmp_hdr->biSizeHL = 0x0E;
    bmp_hdr->bfOffBitsLL = 0x36;
    DFS_WriteFile( &fiSavePhoto, sector, linebuffer, &successcount, sizeof(bmp_fileheader_type) );

    memset( &linebuffer[0], 0, sizeof(bmp_infoheader_type) );
    bmp_inf->biSizeLL = 40;
    bmp_inf->biWidthLL = 0x80;
    bmp_inf->biWidthLH = 0x02;
    bmp_inf->biHeightLL = 0xE0;
    bmp_inf->biHeightLH = 0x01;
    bmp_inf->biPlanesL = 1;
    bmp_inf->biBitCountL = 24;
    bmp_inf->biSizeImageLL = 0x00;
    bmp_inf->biSizeImageLH = 0x10;
    bmp_inf->biSizeImageHL = 0x0E;
    DFS_WriteFile( &fiSavePhoto, sector, linebuffer, &successcount, sizeof(bmp_infoheader_type) );

    addrSavePhoto = OFFSET_PHOTO*0x00080000L + 640*(480-1);
    iSavePhoto = 1;

    return 0;
}                                               // saveMMCphoto


byte            copyMMCphoto( void )
{
    word        w, dataw;
    byte        *pB, *pW;
    uint32_t    successcount;

    if ( iSavePhoto == 0 )
        return 0;
                                        // suspend if motor moving
    if ( vendingCycle() )
        return 1;
    
                                        // write a single line
    flushSSP0();
    memset( linebuffer, 0xFF, 5+640*2 );
    linebuffer[ 0] = ND_RAM_READ;
    linebuffer[ 1] = (char)(addrSavePhoto    );
    linebuffer[ 2] = (char)(addrSavePhoto>> 8);
    linebuffer[ 3] = (char)(addrSavePhoto>>16);
    sendRecvSSP0( (byte *)linebuffer, (byte *)linebuffer, 5+640*2 );

    pB = &linebuffer[4+640*2];
    pW = &linebuffer[4+640*3];
    pB--;
    pW--;
    for ( w = 0; w < 640; w++ )
    {
        dataw = (((word)(*pB--)));
        dataw += (((word)(*pB--))<<8);
        *pW-- = (byte)(((dataw&0x001F)>> 0)<<3);
        *pW-- = (byte)(((dataw&0x07E0)>> 5)<<2); 
        *pW-- = (byte)(((dataw&0xF800)>>11)<<3); 
    }

#if 0 // only for debug
    linebuffer[ 4] = (iSavePhoto<256)?iSavePhoto:0;
    linebuffer[ 5] = 0x00;
    linebuffer[ 6] = (iSavePhoto>=256)?(iSavePhoto-256):0;
    linebuffer[ 7] = (iSavePhoto<256)?iSavePhoto:0;
    linebuffer[ 8] = 0x00;
    linebuffer[ 9] = (iSavePhoto>=256)?(iSavePhoto-256):0;
#endif
    DFS_WriteFile( &fiSavePhoto, sector, &linebuffer[4], &successcount, 640*3 );

    addrSavePhoto -= 640;

    if ( iSavePhoto == 480 )
    {
BuzzerOn(500);
        iSavePhoto = 0;                 // end of save
        return 0;
    }
    else
        iSavePhoto++;
    
    return 1;
}                                               // copyMMCphoto

/*--------------------------------------------------------------------------
 | checkCoupling: verify if selection is already coupled
 |                              --------------
 | In:  _tray, _column      selection position
 | Out: TRUE    selection already coupled
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/

BOOL            checkCoupling( byte _tray, byte _column )
{
    byte k;
    
    if ((_column&0x01) != 0x01)
        return FALSE;
    for (k=0;k<MAXCOLUMN;k+=2) {
        if (NonVolatileSetup.motorCoupled[_tray][k] == _column) 
            return TRUE;             
    }
    return FALSE;
}

/*--------------------------------------------------------------------------
 | checkNotConsecutiveCoupling: verify if selection is already coupled
 |                              --------------
 | In:  _tray               tray
 |      _column             master column
 |      _coupled_column     slave column
 | Out: TRUE    selection already coupled
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/

BOOL            checkNotConsecutiveCoupling( byte _tray, byte _column, byte _coupled_column )
{
    byte k;    

    for (k=0;k<MAXCOLUMN;k+=2) {
        if ( _column > k  && _column < NonVolatileSetup.motorCoupled[_tray][k])
            return TRUE;       
    }         
    if (_coupled_column != 0)
    {
        for (k=0;k<MAXCOLUMN;k+=2) {
            if ( _coupled_column > k  && _coupled_column < NonVolatileSetup.motorCoupled[_tray][k])
                return TRUE;       
        } 
    }    
    return FALSE;    
}

/*--------------------------------------------------------------------------
 | ledMaskInitialization: set led mask value for machine model selected
 |                              --------------
 | In:  _machineType      machine type set
 | Out: 
 |
 +--------------------------------------------------------------------------*/

//(model): an7 used for tray and NOT for led
//			    pin1	pin2	pin3	pin4	pin5	pin6

//rsr654f		an9		an8		an7		gnd		gnd		gnd			ap113
//rsr765g		an9		an8		an7		gnd		gnd		gnd			ap123-veidoor-(veilcm)
//rsr762c1	    an9		an8		an7		gnd		gnd		gnd			(lcm123)

//rsr715b		an7		an8		an9		gnd		gnd		gnd			ap7000

//rsr714b		an5		an6		an7		gnd		gnd		gnd			nat157-vei147-ved1000
//rsr642f		an5		an6		an7		gnd		gnd		gnd			nat147-nat145

//rsr675f		24V		24V		24V		k13		k12		k11			rowe5900
//rsr857a1	    24V		24V		24V		k13		k12		k11			ams39

void            ledMaskInitialization( byte _machineType )
{
    switch(_machineType) {
        case MACHINA_AP113:/*aux led an7 an8 an9*/
        case MACHINA_AP123:
        case MACHINA_VEIDOOR:  
            LED1_MASK_AA = 0x00;
            LED1_MASK_AK = 0x80;
            LED1_MASK_KK = 0x00;
            LED2_MASK_AA = 0x00;
            LED2_MASK_AK = 0x40;
            LED2_MASK_KK = 0x00;
            LED3_MASK_AA = 0x80;
            LED3_MASK_AK = 0x00;
            LED3_MASK_KK = 0x00;
            break;            
        case MACHINA_VEILCM:            
        case MACHINA_LCM123: 
            LED1_MASK_AA = 0x00;
            LED1_MASK_AK = 0x80;
            LED1_MASK_KK = 0x00;
            LED2_MASK_AA = 0x00;
            LED2_MASK_AK = 0x40;
            LED2_MASK_KK = 0x00;
            LED3_MASK_AA = 0x00;    //VEILCM & LCM123 AN7 used for selection NOT for led
            LED3_MASK_AK = 0x00;
            LED3_MASK_KK = 0x00;
            break;       
        case MACHINA_AP7000:   
            LED1_MASK_AA = 0x80;
            LED1_MASK_AK = 0x00;
            LED1_MASK_KK = 0x00;
            LED2_MASK_AA = 0x00;
            LED2_MASK_AK = 0x40;
            LED2_MASK_KK = 0x00;
            LED3_MASK_AA = 0x00;
            LED3_MASK_AK = 0x80;
            LED3_MASK_KK = 0x00;
            break;             
        case MACHINA_NAT145:/*aux led an5 an6 an7*/
        case MACHINA_NAT147:
        case MACHINA_NAT157:
        case MACHINA_VEI147:
            LED1_MASK_AA = 0x20;            
            LED1_MASK_AK = 0x00;
            LED1_MASK_KK = 0x00;
            LED2_MASK_AA = 0x40;
            LED2_MASK_AK = 0x00;
            LED2_MASK_KK = 0x00;
            LED3_MASK_AA = 0x80;
            LED3_MASK_AK = 0x00;
            LED3_MASK_KK = 0x00;
            break;
        case MACHINA_ROWE5900:/*aux led k11 k12 k13*/
//        case MACHINA_AMS39: //2 wires motors 
//the leds driven by catode can generate some problems with current sensor and
//motor presence; the current is measured on the same input for leds and motors
//hw must be modified           
            LED1_MASK_AA = 0x00;
            LED1_MASK_AK = 0x00;
            LED1_MASK_KK = 0x08;
            LED2_MASK_AA = 0x00;
            LED2_MASK_AK = 0x00;
            LED2_MASK_KK = 0x10;
            LED3_MASK_AA = 0x00;
            LED3_MASK_AK = 0x00;
            LED3_MASK_KK = 0x20;
            break;
        default: 
            LED1_MASK_AA = 0x00;
            LED1_MASK_AK = 0x00;
            LED1_MASK_KK = 0x00;
            LED2_MASK_AA = 0x00;
            LED2_MASK_AK = 0x00;
            LED2_MASK_KK = 0x00;
            LED3_MASK_AA = 0x00;
            LED3_MASK_AK = 0x00;
            LED3_MASK_KK = 0x00;
            break;
    }    
}

/*--------------------------------------------------------------------------
 | GetMachineAddress: read address from gpio P0_17 P0_18
 |                              --------------
 | In: 
 | Out:read address 
 |
 +--------------------------------------------------------------------------*/

unsigned char   GetMachineAddress( void )
{
    unsigned char j, p17, p18;
    
    p17 = IO0PIN_bit.P0_17;
    p18 = IO0PIN_bit.P0_18;
    j = (((unsigned char)(p17))<<1) + (unsigned char)(p18);

    switch(j) {
        case 3:
            return 0x40;
        case 2:
            return 0x48;
        case 1:
            return 0x50;
        default:
            return 0x00;
    }    
}

/*--------------------------------------------------------------------------
 | DisplayMenuPriceSlave1: read SlaveStatus and return if slave is present
 |                              --------------
 | In:
 | Out:TRUE/FALSE 
 |
 +--------------------------------------------------------------------------*/

byte   DisplayMenuPriceSlave1( void )
{
    return GetSlaveOffLine(1);
}

/*--------------------------------------------------------------------------
 | DisplayMenuPriceSlave2: read SlaveStatus and return if slave is present
 |                              --------------
 | In:
 | Out:TRUE/FALSE 
 |
 +--------------------------------------------------------------------------*/

byte   DisplayMenuPriceSlave2( void )
{
    return GetSlaveOffLine(2);
}

/*--------------------------------------------------------------------------
 | DisplayMenuPriceSlave3: read SlaveStatus and return if slave is present
 |                              --------------
 | In:
 | Out:TRUE/FALSE 
 |
 +--------------------------------------------------------------------------*/

byte   DisplayMenuPriceSlave3( void )
{
    return GetSlaveOffLine(3);
}

/*--------------------------------------------------------------------------
 | GetSlaveOffLine: read SlaveStatus and return if slave is present
 |                              --------------
 | In:index         slave address
 | Out:TRUE         slave offline
 |     FALSE        slave online
 |
 +--------------------------------------------------------------------------*/

byte   GetSlaveOffLine( byte index )
{
    if (SlaveStatus[index] < SLAVE_POLL) 
        return TRUE;       
    return FALSE;
}

/*--------------------------------------------------------------------------
 | InitSlavesStatus: slaves status initialization
 |                              --------------
 | In:
 | Out: 
 |
 +--------------------------------------------------------------------------*/

void   InitSlavesStatus( void )
{
    byte i;
    
    for(i=0;i<MAX_MACHINE_NUM;i++)
        SlaveStatus[i] = SLAVE_RESET;
}

/*--------------------------------------------------------------------------
 | GetMasterSlavesMaxPrice: set network max price
 |                              --------------
 | In:
 | Out: 
 |
 +--------------------------------------------------------------------------*/

void   GetMasterSlavesMaxPrice( void )
{
    byte i;
    
    maxPrice = localmaxprice[0];
    minPrice = localminprice[0];
    for( i=1; i < MAX_MACHINE_NUM; i++ )
    {
        if ( GetSlaveOffLine(i) == FALSE ) 
        {        
            if ( localmaxprice[i] > maxPrice )  
                maxPrice = localmaxprice[i];
            if ( localminprice[i] < minPrice )  
                minPrice = localminprice[i];            
        }
    }
   
    // maxcredit is also read at interrupt, MUST be assigned only once or changed with interrupt disabled
    if( NonVolatileSetup.maxCreditFromPC < maxPrice )    	
        maxCredit = maxPrice;
    else
        maxCredit = NonVolatileSetup.maxCreditFromPC;
}

/*--------------------------------------------------------------------------
 | getKeyParam: get key from serial port
 |                              --------------
 | In:
 | Out: 
 |
 +--------------------------------------------------------------------------*/

extern const byte tab_K_OK [TOTAL_MACHINE];
extern const byte tab_K_ESC [TOTAL_MACHINE];
extern DWORD      GestioneMenuForcedByHost;
extern byte       exitMenuForcedByHost;
extern BOOL       inProgramm;

void            getKeyParam( char *_buf )
{
    char tab_index, kkk;
    
    do {        
        if (*_buf != CR && *_buf != LF) 
        {
            if (*_buf >= 0x30 && *_buf <= 0x39)
                kkk = *_buf-0x08;
            else if (*_buf >= 0x41 && *_buf <= 0x5A)
                kkk = *_buf - 0x40; 
            else if (*_buf >= 0x61 && *_buf <= 0x7A)
                kkk = *_buf - 0x60;
            else if (*_buf == 0x2a)
                kkk = tab_K_OK[machineType];
            else if (*_buf == 0x23)
                kkk = tab_K_ESC[machineType];
            else if (*_buf == 0x7E)
            {
                if( GestioneMenuForcedByHost || inProgramm == TRUE ) 
                {
                  GestioneMenuForcedByHost = 0; 
                  exitMenuForcedByHost = TRUE;
                }
                else {
                  GestioneMenuForcedByHost = GetTickCount();
                  exitMenuForcedByHost = FALSE;
                }
                _buf++;
                continue;
            }
            else 
                kkk = KNULL;
            if( GestioneMenuForcedByHost ) GestioneMenuForcedByHost = GetTickCount(); // reset program mode timeout
            tab_index = 0;
            if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_LCM123 )
            {
                putKey( kkk );
                _buf++;
            }
            else {
                while (tab_index < MAXKEYNUM)
                {                    
                    if (kkk == tabKeyRemap[machineType][tab_index])
                    {
                        putKey( tab_index );
                        break;
                    }
                    tab_index++;
                }
                _buf++;
            }
        }
        else
            return;
    }while (-1);
}

