/******************************************************************************
lcd.c
init 2 vetri e modulo lcd
*******************************************************************************/

#include "ram.h"
#include "lcd7seg.h"
#include "HWINIT.H"
#include "display.h"
#include "keyboard.h"
#include "messaggi.h"
#ifndef __WIN32__
#include "LPC_VIC.h"
#endif
#include <stdio.h>
#include <string.h>


/******************************************************************************
       Variables
*******************************************************************************/

char DisplayPresence;
char presence1, presence2;
unsigned char cur_pos[2];
unsigned char currntcurs;
unsigned char bufLcd[20];
unsigned char bufLcdIIC[20];
unsigned char bufLcdIICInt[20];
unsigned char *bufLcdIICPtr;
unsigned char bufLcdIICNData;
unsigned char flagSpiBusy;




void            LcdErase( unsigned char unit )
{
  memset(bufLcdIIC, 0, sizeof(bufLcdIIC));
  memset(bufLcd, 0, sizeof(bufLcd));
}



void            LcdIIC0Init( void )
{
#ifndef __WIN32__
    I20CONCLR = 0x2c;                     // clr err
    I20CONSET = 0x40;                     // master
    I20SCLL = (PERIFREQ / 90000) / 2;     // 90k
    I20SCLH = (PERIFREQ / 90000) / 2;     // 90k

    VIC_SetVectoredIRQ(I2C_ISR,VIC_Slot9,VIC_I2C0);
    VIC_EnableInt(1<<VIC_I2C0);
#endif
    flagSpiBusy = 0;
}

// restituisce 1 se ok, 1 se iic busy
unsigned char   WriteI2c0( unsigned char *bufferPtr, unsigned char nData )
{
#ifndef __WIN32__
    if ( flagSpiBusy == 0 )
    {
        bufLcdIICNData = nData;
        memcpy(bufLcdIICInt, bufferPtr, nData);
        bufLcdIICPtr = bufLcdIICInt;
        flagSpiBusy = 1;
        I20CONCLR = 0x0C;     // clr stop
        I20CONSET = 0x60;     // master + start
        return 0;
    }
#endif
    return 1;
}

// restituisce 1 se ok, 1 se iic busy
unsigned char   ReadI2c0( unsigned char *bufferPtr, unsigned char nData )
{
#ifndef __WIN32__
    if ( flagSpiBusy == 0 )
    {
        bufLcdIICNData = nData;
        bufLcdIICInt[0] = *bufferPtr;  // copio ind scrittura nel buffer
        bufLcdIICPtr = bufLcdIICInt;
        flagSpiBusy = 1;
        I20CONCLR = 0x0C;     // clr stop
        I20CONSET = 0x60;     // master + start
        while(flagSpiBusy != 0);
        memcpy(bufferPtr+1, bufLcdIICInt+1, nData);
        return 0;
    }
#endif
    return 1;
}

//interrupt subroutine i2c0
void I2C_ISR(void)
{
#ifndef __WIN32__
  unsigned char temp;

  temp = I20STAT;
  if(temp == 0x08){
    I20CONCLR = 0x28;
    I20DAT = *bufLcdIICPtr;
    bufLcdIICPtr++;
  }
  else if((temp == 0x18 && flagSpiBusy == 1) ||  // transmit
          (temp == 0x28 && flagSpiBusy < bufLcdIICNData)){
    I20CONCLR = 0x08;
    I20DAT = *bufLcdIICPtr;
    bufLcdIICPtr++;
    flagSpiBusy++;
  }
  else if((temp == 0x40 && flagSpiBusy == 1) ||   // receive
          (temp == 0x50 && flagSpiBusy < bufLcdIICNData)){
    I20CONCLR = 0x08;
    flagSpiBusy++;
    if(flagSpiBusy < bufLcdIICNData) I20CONSET = 0x04;    // iic continuos mode
    else                             I20CONCLR = 0x04;
    if(temp != 0x40){
      *bufLcdIICPtr = I20DAT;
      bufLcdIICPtr++;
    }
  }
  else{
    if(temp == 0x58) *bufLcdIICPtr = I20DAT;
    I20CONCLR = 0x08;
    if(flagSpiBusy != 0){
      I20CONSET = 0x10;      // STOP
      flagSpiBusy = 0;
    }
  }
  VICAddress = 0;         // Clear interrupt in VIC.
#endif
}

// inizializza il contrasto dei due LCD
void            contrastInit( void )
{
#ifndef __WIN32__
    DACR = 0x8000;                      // contrasto a meta
#endif
}

// regolazione contrasto dei due LCD
void            setContrastLCD( byte _contrast )
{
#ifndef __WIN32__
#if 1
    DACR = _contrast<<8;
#else
    unsigned long temp;

    temp = ((unsigned long)_contrast * PERIFREQ) / (F_PWM * 256);
    PWMMR2 = temp;
    PWMLER = 0X04;                // 00000100  pwm2 value loaded
#endif
#endif
}                                               //  setContrastLCD

void TestOra(void)
{
    _dateTime temp;
    char msg[20];

    DispClrScr();
    DispStr(0,0,"Data Ora");

    temp.sec = 50;
    temp.min = 55;
    temp.hour = 16;
    temp.year = 7;
    temp.day = 8;
    temp.month = 8;
    sendDate(&temp);

    memset((char*)&temp,0,sizeof(temp));
    do {
        recvDate(&temp);
        sprintf(msg, "%02d:%02d:%02d %02d/%02d/%02d",temp.hour,temp.min,temp.sec,temp.day,temp.month,temp.year);
        DispStr(0,0,msg);
    } while( temp.sec < 53 );
}
