/*
dex.c

*/
#define __DEX

#ifdef  __WIN32__
#include <io.h>
#endif
#include <stdio.h>
#include <string.h>
#include "hwinit.h"
#include "uart.h"
#include "def.h"
#include "main.h"
#include "ram.h"
#include "event.h"
#include "crc16.h"
#include "funzioni.h"
#include "keyboard.h"
#include "modem.h"
#include "optical.h"
#include "timer.h"
#include "ds2341.h"
#include "dex.h"

// per includere scrittura file su MMC
#include	"mmc.h"
#include	"messaggi.h"
#include	"display.h"
char * _longtoa ( long value, char *strP, int radix, char maybeSigned, char hexStyle );
byte            getSelectionParam( byte *_data, byte *_i, byte *_j, byte _reverse, byte machineForm );

extern struct S_SelectionData SelectionData;
extern struct S_EVENT sEvent[], *pEventW;
extern struct S_EVENT *pEventCreditR;
extern struct _HOST_DATA_  hostData;

unsigned short 	G85;

// debug se metto unsigned short BCC il programma di download dex non funziona
// unsigned short BCC_0, BCC_1, BCC_14, DATA_0, X2, X15, X16;
static void G85_calc(char data)
{
/*
   short j;
   for (j=0;j<8;j++)
   {
     DATA_0 = (data >> j) & 0x0001;
     BCC_0 = (BCC & 0x0001);
     BCC_1 = (BCC >> 1) & 0x0001;
     BCC_14 = (BCC >> 14) & 0x0001;
     X16 = (BCC_0 ^ DATA_0) & 0x0001; 	// bit15 of BCC after shift
     X15  = (BCC_1 ^ X16) & 0x0001;		// bit0 of BCC after shift
     X2  = (BCC_14 ^ X16) & 0x0001;		// bit13 of BCC after shift
     BCC = BCC >> 1;
     BCC = BCC & 0x5FFE;
     BCC = BCC | (X15);
     BCC = BCC | (X2 << 13);
     BCC = BCC | (X16 << 15);
   }

*/  G85 = (G85>>8)^crc16tab[(G85^data)&0xFF];
}

static byte AuditSelectionInsert( byte _machine, byte _tray, byte _column );

enum  eDexStat {  DEX_SLAVE_FIRST_ENQ = 0,
                  DEX_SLAVE_FIRST_DLE0,
                  DEX_SLAVE_CRC1,
                  DEX_SLAVE_CRC2,
                  DEX_MASTER_START,
                  DEX_MASTER_ENQ,
                  DEX_MASTER_FIRST_ENQ,
                  DEX_DATA_START,
                  DEX_DATA_ACK,
                  DEX_DATA_SET,
                  DEX_DATA_SET_DELAY,
                  DEX_SET_CONFIG,
                  DEX_DATA_SEND,
                  DEX_DATA_RDY,
#if PRODUCT_RECOGNITION
                  DEX_GET_PRODUCT,
#endif
#if BIG_SCREEN
				  DEX_SELL_PRODUCT,
#endif
               };

byte    DEXiPrice, DEXbufPrice[16];

#if PRODUCT_RECOGNITION
void newProdName( char *_str );
#endif

#pragma pack(1)
union S_CommID {
  struct {
    char MFG[3], seriale[7];
  };
  struct {
    char UCC[6], serial[4];
  };
};

struct  S_DEXRxData {
  union  S_CommID CommID;
  char operation;
  char Revision[3], Level[3];
} *pDEXRxData;


const struct  S_DEXTxData {
  char  Response[2];
  union  S_CommID CommID;
  char  Revision[3], Level[3];
} DEXTxData
#ifndef  __WIN32__
 = { "00", { "VEE", "1234567" }, "R00", "L06" }
#endif
            ;
#pragma pack()

struct	S_MDBerror {
	byte        status;
	byte        counter;
} MDBerror[MDB_ERROR_ARRAY_SIZE];

struct	S_EA1_exact_change_event {
	byte        status;
	dword       date;
    dword       time;
} EA1_exact_change_event[EA1_EXACT_CHANGE_EVENT_ARRAY_SIZE];

#define RESPONSE_TIMER      10
#if DEX_BY_MODEM
#define serINTERSESSION_PAUSE   1500
#define serTIMER_A_MARGIN       2000
#define serTIMER_B_MARGIN       1500
#else
#define serINTERSESSION_PAUSE    100
#define serTIMER_A_MARGIN       1000
#define serTIMER_B_MARGIN        100
#endif
#define ethINTERSESSION_PAUSE    100
#define ethTIMER_A_MARGIN       9000
#define ethTIMER_B_MARGIN       7500
#define TIMER_D_MARGIN          2200
#define TIMER_O_MARGIN         60000
#define INFINITE_TIMEOUT           0

char  DEXStatus = DEX_SLAVE_FIRST_ENQ, DEXChannel = 0xFF, DEXBufferSize = 0;
word  DEXWait = INFINITE_TIMEOUT, DEXtimer = RESPONSE_TIMER;
word  DEXb, DEXe, DEXsent, DEXstart, DEXcount, DEXold;
long  DEXtimerStart, DEXWaitStart;
// #if MODEM_HTTP
word  DEXChars;
// #endif
char  DEXSequence;
dword AuditData[AUDIT_DATA_SIZE];

word    tIntersessionPause = serINTERSESSION_PAUSE;
word    tMarginA = serTIMER_A_MARGIN;
word    tMarginB = serTIMER_B_MARGIN;

/*
  Preparazione file di audit
  Il file si ottiene interpretando il seguenta array di interi
  - i valori compresi fra 0x8000 e 0x8000+AUDIT_DATA_SIZE sono indici di variabili LONG lette del file di audit
  - i valori maggiori di 0x8000+AUDIT_DATA_SIZE sono interpretati in una appropriato switch del programma
  - 0xc000 indica di accedere all-array dei prezzi delle selezioni
  - i caratteri sono copiati come tali, fanno eccezione alcuni caratteri
    '<' e '>' delimitano una zona che viene inserita solo opzionalmente nel file, precisamente se il contenuto
              di tutte le variabili nella zona e' zero la zona NON viene inclusa
    '{' e '}' delimitano una zona che viene interpretata piu' volte, il numero di volte e' specificato da carattere che segue
              '}'; la variabilid della zona sono ottenute sommando i loro indici al valore della variabile di loop
    '&' e '^' interpretano la variabile di loop come "tray" e "column" nella compilazione di PA101
  - G85 ei una sequenza speciale per inserire, appunto, il campo G85 nel file.

  Per aggiungere un elemento di audit ( numerico )
  - inserire la variabile relativa all'elemento da aggiungere, se _LR_ o _IN_ nell'area relativa
  - inserire il record nel file EVA-DTS DEXData, con gli eventuali elementi di controllo <, >, {, }, etc....

- versione 'W'
    . aggiunto modello macchina dopo numero di serie ID101
    . aggiunta versione firmware dopo codice prodotto ID102

*/
const unsigned short  DEXData[] = {
'D','X','S','*','V','E','I','7','6','5','4','3','2','1','*','V','A','*','V','0','/','6','*','1',0x0D,0x0A,
'S','T','*','0','0','1','*','0','0','0','1',0x0D,0x0A,
'I','D','1','*','V','E','I',ID101+0x8000,'*','V','E','I','6','4','1',ID102+0x8000,'*','0','0','0','W','*','*','*',ID106+0x8000,0x0D,0x0A,
'E','A','3','*',EA301+0x8000,'*',EA302+0x8000,'*',EA303+0x8000,'*',EA304+0x8000,'*',EA305+0x8000,'*',EA306+0x8000,0x0D,0x0A,
'V','A','1','*',VA101+0x8000,'*',VA102+0x8000,'*',VA103+0x8000,'*',VA104+0x8000,'*',VA105+0x8000,'*',VA106+0x8000,'*',VA107+0x8000,'*',VA108+0x8000,0x0D,0x0A,
'C','A','1','*',CA101+0x8000,'*',CA102+0x8000,0x0D,0x0A,
'C','A','2','*',CA201+0x8000,'*',CA202+0x8000,'*',CA203+0x8000,'*',CA204+0x8000,0x0D,0x0A,
'C','A','3','*',CA301+0x8000,'*',CA302+0x8000,'*',CA303+0x8000,'*',CA304+0x8000,'*',CA305+0x8000,'*',CA306+0x8000,'*',CA307+0x8000,'*',CA308+0x8000,'*',CA309+0x8000,'*',CA310+0x8000,'*',CA311+0x8000,'*',CA312+0x8000,0x0D,0x0A,
'C','A','4','*',CA401+0x8000,'*',CA402+0x8000,'*',CA403+0x8000,'*',CA404+0x8000,'*',CA405+0x8000,'*','*',CA407+0x8000,'*',CA408+0x8000,'*',CA409+0x8000,'*',CA410+0x8000,0x0D,0x0A,
'C','A','5','*',CA501+0x8000,'*',CA502+0x8000,0x0D,0x0A,
'C','A','6','*',CA601+0x8000,'*',CA602+0x8000,0x0D,0x0A,
'C','A','9','*',CA901+0x8000,'*',CA902+0x8000,0x0D,0x0A,
'C','A','1','0','*',CA1001+0x8000,'*',CA1002+0x8000,'*',CA1003+0x8000,'*',CA1004+0x8000,0x0D,0x0A,
'<','C','A','1','1','*','5','*',CA1102_5+0x8000,'*',CA1103_5+0x8000,'*',CA1104_5+0x8000,'*',CA1105_5+0x8000,'*',CA1106_5+0x8000,'*',CA1107_5+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','1','0','*',CA1102_10+0x8000,'*',CA1103_10+0x8000,'*',CA1104_10+0x8000,'*',CA1105_10+0x8000,'*',CA1106_10+0x8000,'*',CA1107_10+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','2','5','*',CA1102_25+0x8000,'*',CA1103_25+0x8000,'*',CA1104_25+0x8000,'*',CA1105_25+0x8000,'*',CA1106_25+0x8000,'*',CA1107_25+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','5','0','*',CA1102_50+0x8000,'*',CA1103_50+0x8000,'*',CA1104_50+0x8000,'*',CA1105_50+0x8000,'*',CA1106_50+0x8000,'*',CA1107_50+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','1','0','0','*',CA1102_100+0x8000,'*',CA1103_100+0x8000,'*',CA1104_100+0x8000,'*',CA1105_100+0x8000,'*',CA1106_100+0x8000,'*',CA1107_100+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','2','0','0','*',CA1102_200+0x8000,'*',CA1103_200+0x8000,'*',CA1104_200+0x8000,'*',CA1105_200+0x8000,'*',CA1106_200+0x8000,'*',CA1107_200+0x8000,0x0D,0x0A,'>',
'<','C','A','1','1','*','5','0','0','*',CA1102_500+0x8000,'*',CA1103_500+0x8000,'*',CA1104_500+0x8000,'*',CA1105_500+0x8000,'*',CA1106_500+0x8000,'*',CA1107_500+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','5','*',CA1202_5+0x8000,'*',CA1203_5+0x8000,'*',CA1204_5+0x8000,'*',CA1205_5+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','1','0','*',CA1202_10+0x8000,'*',CA1203_10+0x8000,'*',CA1204_10+0x8000,'*',CA1205_10+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','2','5','*',CA1202_25+0x8000,'*',CA1203_25+0x8000,'*',CA1204_25+0x8000,'*',CA1205_25+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','5','0','*',CA1202_50+0x8000,'*',CA1203_50+0x8000,'*',CA1204_50+0x8000,'*',CA1205_50+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','1','0','0','*',CA1202_100+0x8000,'*',CA1203_100+0x8000,'*',CA1204_100+0x8000,'*',CA1205_100+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','2','0','0','*',CA1202_200+0x8000,'*',CA1203_200+0x8000,'*',CA1204_200+0x8000,'*',CA1205_200+0x8000,0x0D,0x0A,'>',
'<','C','A','1','2','*','5','0','0','*',CA1202_500+0x8000,'*',CA1203_500+0x8000,'*',CA1204_500+0x8000,'*',CA1205_500+0x8000,0x0D,0x0A,'>',
'<','C','A','1','4','*','1','0','0','*',CA1402_100+0x8000,'*',CA1403_100+0x8000,'*',CA1404_100+0x8000,'*',CA1405_100+0x8000,0x0D,0x0A,'>',
'<','C','A','1','4','*','2','0','0','*',CA1402_200+0x8000,'*',CA1403_200+0x8000,'*',CA1404_200+0x8000,'*',CA1405_200+0x8000,0x0D,0x0A,'>',
'<','C','A','1','4','*','5','0','0','*',CA1402_500+0x8000,'*',CA1403_500+0x8000,'*',CA1404_500+0x8000,'*',CA1405_500+0x8000,0x0D,0x0A,'>',
    'C','A','1','5','*',CA1501+0x8000,0x0D,0x0A,
'{','<','C','A','1','7','*','^','*',CA1702_1+0x8000,'*',CA1703_1+0x8000,'*',CA1704_1+0x8000,'*',CA1705_1+0x8000,'*',CA1706_1+0x8000,0x0D,0x0A,'>','}',8,
'B','A','1','*',BA101+0x8000,'*',BA102+0x8000,0x0D,0x0A,
'D','A','1','*',DA101+0x8000,'*',DA102+0x8000,0x0D,0x0A,
'<','D','A','2','*',DA201+0x8000,'*',DA202+0x8000,'*',DA203+0x8000,'*',DA204+0x8000,'*',0x0D,0x0A,'>',
'D','B','1','*',DB101+0x8000,'*',DB102+0x8000,0x0D,0x0A,
'<','D','B','2','*',DB201+0x8000,'*',DB202+0x8000,'*',DB203+0x8000,'*',DB204+0x8000,'*',0x0D,0x0A,'>',
'{','#','<','P','A','1','*','&','%','*',PA101+0x8000,0x0D,0x0A,
            'P','A','2','*',PA201_00+0x8000,'*',PA202_00+0x8000,'*',PA203_00+0x8000,'*',PA204_00+0x8000,0x0D,0x0A,
            'P','A','3','*',PA301_00+0x8000,'*',PA302_00+0x8000,'*',PA303_00+0x8000,'*',PA304_00+0x8000,0x0D,0x0A,'>','}',99,
'{','<','E','A','1','*',EA101_01+0x8000,'*',EA102_01+0x8000,'*',EA103_01+0x8000,0x0D,0x0A,'>','}',8,
'{','<','E','A','1','*',EA101_EC+0x4000,'*',EA102_EC+0x4000,'*',EA103_EC+0x4000,0x0D,0x0A,'>','}',16,
'<','E','A','2','*','E','N','U','_','0','1','*',BILLV_MOTOR_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','2','*',BILLV_SENSOR_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','3','*',BILLV_VAIDATOR_BUSY+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','4','*',BILLV_ROM_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','C','*',BILLV_JAMMED_VALIDATOR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','6','*',BILLV_VALIDATOR_RESET+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','7','*',BILLV_BILL_REMOVED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','F','*',BILLV_BOX_REMOVED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','1','F','*',BILLV_DISABLED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','B','*',BILLV_DETECTING_FRAUDS+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','B','*',BILLV_BILL_REJECTED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','0','C','*',BILLV_POSSIBLE_CREDIT_BILL_REMOVAL+0x4000,0x0D,0x0A,'>',

'<','E','A','2','*','E','N','U','_','2','1','*',BILLV_ESCROW_REQUEST+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','2','*',BILLV_DISPENSER_PAYOUT_BUSY+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','3','*',BILLV_DISPENSER_BUSY+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','4','*',BILLV_DISPENSER_DEFECTIVE_SENSOR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','2','5','*',BILLV_NOT_USED1+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','6','*',BILLV_DISPENSER_DID_NOT_START+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','D','*',BILLV_JAMMED_STACKER+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','8','*',BILLV_DISPENSER_ROM_CHECKSUM_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','9','*',BILLV_DISPENSER_DISABLED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','A','*',BILLV_BILL_WAITING+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','2','B','*',BILLV_NOT_USED2+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','2','C','*',BILLV_NOT_USED3+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','2','D','*',BILLV_NOT_USED4+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','2','E','*',BILLV_NOT_USED5+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','N','U','_','2','F','*',BILLV_FILLED_KEY_PRESSED+0x4000,0x0D,0x0A,'>',

//'<','E','A','2','*','E','N','1','E','*',_BILLV_STACKER_FULL+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','E','*',_BILLV_BILL_BOX_FULL+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','G','*',_BILLV_FAILED_VALIDATOR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','H','*',_BILLV_FAILED_STACKER+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','I','*',_BILLV_FAILED_PCB+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','J','*',_BILLV_FAILED_POWER_SUPPLY+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','K','*',_BILLV_NO_COMMS+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','*',_BILLV_MDB_ERROR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','0','5','*',_BILLV_ACCEPTOR_JAMMED+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','N','U','_','0','8','*',_BILLV_STACKER_ERROR+0x4000,0x0D,0x0A,'>',

//'<','E','A','2','*','L','O','W','C','H','A','N','G','E','*',LOW_CHANGE+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','O','U','T','O','F','S','E','R','V','I','C','E','*',OUT_OF_SERVICE+0x4000,0x0D,0x0A,'>',

'<','E','A','2','*','E','A','U','_','0','0','0','1','*',COIN_ESCROW_REQUEST+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','2','*',COIN_CHANGER_PAYOUT_BUSY+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','3','*',COIN_NO_CREDIT+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','2','F','*',COIN_MDB_ALL_TUBES_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','5','*',COIN_DOUBLE_ARRIVAL+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','6','*',COIN_MDB_ACCEPTOR_UNPLUGGED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','7','*',COIN_MDB_TUBE_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','8','*',COIN_MDB_ROM_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','A','*',COIN_ENTRY_CHUTE+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','A','*',COIN_CHANGER_BUSY+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','B','*',COIN_CHANGER_WAS_RESET+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','C','*',COIN_MDB_ACCEPTOR_JAMMED+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','U','_','0','0','0','D','*',COIN_POSSIBLE_CREDITED_COIN_REMOVAL+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','A','S','*',COIN_REJECTED+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','2','J','*',_COIN_DISABLED+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','2','K','*',_COIN_EXEC_PRICE_ERROR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','B','*',_COIN_REJECT_SYSTEM+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','M','*',_COIN_FAILED_SEPARATOR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','N','*',_COIN_FAILED_DISPENSER+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','O','*',_COIN_FAILED_CONTROL_PCB+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','R','*',_COIN_MECH_NO_COMMS+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','U','*',_COIN_MDB_ERROR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','A','U','_','0','0','0','4','*',_COIN_MDB_SENSOR_ERROR+0x4000,0x0D,0x0A,'>',

'<','E','A','2','*','E','G','S','*',DOOR_OPEN+0x4000,0x0D,0x0A,'>',

'<','E','A','2','*','E','K','U','_','0','0','*',CARD_READER_PAYMENT_MEDIA_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','K','U','_','0','1','*',CARD_READER_INVALID_PAYMENT_MEDIA+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','K','U','_','0','2','*',CARD_READER_TAMPER_ERROR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','K','U','_','0','3','*',CARD_READER_MANUF_TRANSF_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','K','U','_','0','4','*',CARD_READER_COMMS_ERROR+0x4000,0x0D,0x0A,'>',
'<','E','A','2','*','E','K','U','_','0','5','*',CARD_READER_SERVICE_ERROR+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','K','U','_','0','6','*',CARD_READER_UNASSIGNED1+0x4000,0x0D,0x0A,'>',
//'<','E','A','2','*','E','K','U','_','0','7','*',CARD_READER_MANUFACT_ERROR+0x4000,0x0D,0x0A,'>', 
'<','E','A','2','*','E','K','U','_','0','8','*',CARD_READER_FAILED_OOS_ERROR+0x4000,0x0D,0x0A,'>', 
'<','E','A','2','*','E','K','U','_','0','9','*',CARD_READER_COMMS_OOS_ERROR+0x4000,0x0D,0x0A,'>', 
'<','E','A','2','*','E','K','U','_','0','A','*',CARD_READER_JAM_OOS_ERROR+0x4000,0x0D,0x0A,'>', 
//'<','E','A','2','*','E','K','U','_','0','B','*',CARD_READER_MANUFACT_OOS_ERROR+0x4000,0x0D,0x0A,'>', 
'<','E','A','2','*','E','K','U','_','0','C','*',CARD_READER_REFUND_ERROR+0x4000,0x0D,0x0A,'>', 
//'<','E','A','2','*','E','K','U','_','0','D','*',CARD_READER_UNASSIGNED2+0x4000,0x0D,0x0A,'>', 
//'<','E','A','2','*','E','K','U','_','0','E','*',CARD_READER_UNASSIGNED3+0x4000,0x0D,0x0A,'>', 
//'<','E','A','2','*','E','K','U','_','0','F','*',CARD_READER_UNASSIGNED4+0x4000,0x0D,0x0A,'>', 
//'<','E','A','2','*','E','A','M','*',_CARD_READER_NO_COMMS+0x4000,0x0D,0x0A,'>',

'<','M','A','5','*',MA501+0x4000,0x0D,0x0A,'>',

'G','8','5','*',0x0D,0x0A,
'S','E','*',SE01+0x8000,'*','0','0','0','1',0x0D,0x0A,
'D','X','E','*','1','*','1',0x0D,0x0A };

static char *pDEXbuf = NULL;

void  DEXPutChar( byte _data )
{
    word        idx;
    _RING_BUF_  *p;
    
    DEXChars++;
    if ( DEXChannel >= nCOMM )
    {
        if( pDEXbuf != NULL )
            *pDEXbuf++ = _data;
        return;
    }
    
    p = &commObuf[DEXChannel];
    if ( p->w == (COMM_BUF-1) )
        idx = 0;
    else
        idx = p->w + 1;
    if ( idx == p->r )
        return; 
    p->buf[p->w] = _data;
    p->w = idx;
    if( DEXStatus == DEX_DATA_RDY || DEXStatus == DEX_DATA_SEND )
        commTxIntEn( DEXChannel );
    else  
    {
        DEXtimer = RESPONSE_TIMER; DEXtimerStart = GetTickCount(); 
    }   
} 

#if MODEM_HTTP
BOOL            DEXtransfer( void )
{
    return (DEXStatus != DEX_SLAVE_FIRST_ENQ);
}
#endif

void  DEX( void )
{
 /* 09.2012
#if ENABLE_COMM1
    return;
#endif    */
#ifndef __WIN32__
  byte ch, i;
#if BIG_SCREEN
  byte j;
#endif

/////  if( DEXtimer != 0 && DEXChannel <= COMM4)         // gestione RESPONSE_TIMER
  if( DEXtimer != 0 )         // gestione RESPONSE_TIMER
  {
//    if( --DEXtimer == 0 )
    if( ( GetTickCount() - DEXtimerStart ) > DEXtimer )
    {
      DEXtimer = 0;                                 // infinite timeout
      // invio COMM1
      while( commObuf[COMM1].r != commObuf[COMM1].w )
      {
        if( U0LSR_bit.THRE )   // buffer vuoto, inserisce carattere
        {
          UART_readTxBuf( &commObuf[COMM1], (byte *)&U0THR );
        }
        else
        {                     // avvia interrupt
          U0IER |=  IER_THRE;
          return;
        }
        U0TER_bit.TXEN = 1;   // avvia trasmissione
      }
#if RSR903_MDB
#else
      // invio COMM2
      while( commObuf[COMM2].r != commObuf[COMM2].w )
      {
        if( U1LSR_bit.THRE )   // buffer vuoto, inserisce carattere
        {
          UART_readTxBuf( &commObuf[COMM2], (byte *)&U1THR );
        }
        else
        {                     // avvia interrupt
          U1IER |=  IER_THRE;
          return;
        }
        U1TER_bit.TXEN = 1;   // avvia trasmissione
      }
#endif
    }
    return;
  }

#if MODEM_HTTP
  if ( modemUpdate() == 0 )
      return;
#endif

  if( DEXChannel <= COMM4 )
  {
    if( commObuf[DEXChannel].r != commObuf[DEXChannel].w )  // wait end of transmission
      return;
  }
  // to send DEX over the HOST serial line
  if( DEXStatus == DEX_DATA_RDY )
  {
//mmm      
//      if( DEXstart < sizeof( DEXData )/sizeof(unsigned short) )
//      {
          DEXStatus = DEX_DATA_SEND;
          DEXstart = DEXsent;
          DEXtimer = INFINITE_TIMEOUT;     // only to enable MAIN to compile the file, reset to RESPONSE_TIMER in prepareDEX
//      }
//      else
//      {
//          DEXPutChar( ETX );
//          DEXStatus = DEX_SLAVE_FIRST_ENQ;
//          DEXWait = INFINITE_TIMEOUT;
//          DEXChannel = 0xFF;
//          InsertEvent1( EVENT_AUDIT_READOUT, AuditData[EA302], AuditData[EA303] );
//      }
      return;
  }
  if( DEXStatus == DEX_DATA_SEND )
  {
      return;
  }

  
  if( DEXChannel == 0xFF )
  {
    if( commIsEmpty( COMM1 ) == FALSE && hostData.comPort != COMM1 )
    {
      DEXChannel = COMM1;
      DEXBufferSize = 245-12-3;   // DEBUG lascio spazio per inserire una stringa ( processo non interrompibile )
    }
#if RSR903_MDB
#else
    else if( commIsEmpty( COMM2 ) == FALSE )
    {
      DEXChannel = COMM2;
      DEXBufferSize = 70-12-3;   // DEBUG lascio spazio per inserire una stringa ( processo non interrompibile )
    }
#endif
    else
      return;
  }

  if( commGetChar( DEXChannel, &ch ) == COMM_RX_EMPTY )
  {
    if( DEXWait == 0 )      // timeout di ricezione
      return;               // scaduto
//    if( --DEXWait != 0 )
    if( ( GetTickCount() - DEXWaitStart ) < DEXWait )
      return;
    DEXWait = 0;
    ch = 0;                 // qui se timeout scaduto in questo interrupt
  }
  else
  {
    DEXWait = tMarginB; DEXWaitStart = GetTickCount();
  }

  switch( DEXStatus )
  {
    // nel caso si parte come master ( retry infinito )
    case DEX_MASTER_START:
                          if( DEXWait == 0 )
                          {
                            DEXPutChar( ENQ );
                            DEXtimer = tIntersessionPause; DEXtimerStart = GetTickCount();
                            DEXWait = tMarginA+tIntersessionPause; DEXWaitStart = GetTickCount();
                          }
                          else if( ch == DLE )
                          {
                            DEXStatus = DEX_MASTER_FIRST_ENQ;
                            DEXWait = 100; DEXWaitStart = GetTickCount();
                            break;
                          }
                          else if( ch == ENQ )
                            DEXStatus = DEX_SLAVE_FIRST_ENQ;
                            // continua automaticamente verso lo slave handshake
                          else
                            // DEBUG retry?? nessuna risposta significativa
                          break;

    // si parte come slave ( default )
    case DEX_SLAVE_FIRST_ENQ:
                          if( DEXWait == 0 )
                          {
                            DEXChannel = 0xFF;
                            break;
                          }
                          switch( ch ) {
                            case '?':
                              DEXStatus = DEX_SET_CONFIG;
                              DEXiPrice = 0;
                              break;
#if MODEM_HTTP
                            case '+':
                            case 0x0D:
                            case 0x0A:
                              if ( DEXChannel == COMM1 )
                                  modemReceive = 1;
                              break;
#endif
#if PRODUCT_RECOGNITION
                            case '_':
                              DEXStatus = DEX_GET_PRODUCT;
                              DEXiPrice = 0;
                              break;
#endif
#if BIG_SCREEN
                            case '*':
                              DEXStatus = DEX_SELL_PRODUCT;
                              DEXiPrice = 0;
                              break;
#endif
                            case ENQ+0x80:
                              tIntersessionPause = ethINTERSESSION_PAUSE;
                              tMarginA = ethTIMER_A_MARGIN;
                              tMarginB = ethTIMER_B_MARGIN;
                              goto startEnq;
                            case ENQ:
                              tIntersessionPause = serINTERSESSION_PAUSE;
                              tMarginA = serTIMER_A_MARGIN;
                              tMarginB = serTIMER_B_MARGIN;
startEnq:
                              // inizio interrogazione
                              DEXPutChar( DLE );
                              DEXPutChar( '0' );
                              BCC = 0;
                              DEXWait = TIMER_D_MARGIN; DEXWaitStart = GetTickCount();
                              break;

                            case SOH:
                              // inizio buffer dati
                              DEXb = commIbuf[DEXChannel].r;
                              pDEXRxData = (struct  S_DEXRxData *)&(commIbuf[DEXChannel].buf[commIbuf[DEXChannel].r]);
                              break;

                            case ETX:
                              // fine buffer dati in ingresso
                              DEXe = commIbuf[DEXChannel].r;
                              DEXStatus = DEX_SLAVE_CRC1;
                              crc_16(ch);
                              break;

                            case EOT:
                              if( BCC == 0 )
                              {
                                DEXStatus = DEX_MASTER_ENQ;
                                goto gDEX_MASTER_ENQ;
                              }
                              else    // restart
                                DEXWait = INFINITE_TIMEOUT;
                              break;

                            case DLE:
                            case STX:
                            case SYN:   // restart timeout
                              break;

                            default:
                              crc_16(ch);
                          }
                          break;

    case DEX_SLAVE_CRC1:  DEXStatus = DEX_SLAVE_CRC2;
                          crc_16(ch);
                          break;

    case DEX_SLAVE_CRC2:  DEXStatus = DEX_SLAVE_FIRST_ENQ;
                          crc_16(ch);
                          if( BCC == 0 )
                          {
                            DEXPutChar( DLE );
                            DEXPutChar( '1' );
                          }
                          else
                          {
                            DEXPutChar( NAK );
                          }
                          break;

    // master handshake
gDEX_MASTER_ENQ:
    case DEX_MASTER_ENQ:
                          DEXPutChar( ENQ );
                          DEXtimer = tIntersessionPause; DEXtimerStart = GetTickCount();
                          DEXWait = tMarginA+tIntersessionPause; DEXWaitStart = GetTickCount();
                          DEXStatus = DEX_MASTER_FIRST_ENQ;
                          break;

    case DEX_MASTER_FIRST_ENQ:
                          if( DEXWait == 0 )
                          {
                            DEXStatus = DEX_SLAVE_FIRST_ENQ;    // DEBUG passo in slave??
                            DEXChannel = 0xFF;
                          }
                          else if( ( ch == '0' && DEXold == DLE ) || ch == NAK )
                          {
                            DEXPutChar( DLE );
                            DEXPutChar( SOH );
                            BCC = 0;
                            for( i = 0; i < sizeof( DEXTxData ); i++ )
                            {
                              DEXPutChar( ((char *)&DEXTxData)[i] );
                              crc_16( ((char *)&DEXTxData)[i] );
                            }
                            DEXPutChar( DLE );
                            DEXPutChar( ETX );
                            crc_16( ETX );
                            DEXPutChar( BCC & 0xFF);
                            DEXPutChar( BCC >> 8 );
                            DEXWait = DEXtimer+tMarginA; DEXWaitStart = GetTickCount();
                          }
                          else if( ch == '1' && DEXold == DLE )
                          {
                            DEXPutChar( EOT );
                            DEXWait = tIntersessionPause; DEXWaitStart = GetTickCount();    // wait tIntersessionPause as receive timeout
                            DEXStatus = DEX_DATA_START;
                          }
                          break;

    // third handshake
    case DEX_DATA_START:  DEXPutChar( ENQ );
//                          DEXtimer = tIntersessionPause;    e' stato usato il timeout di ricezione per "distanziare" EOT da ENQ
                          DEXWait = tMarginA; DEXWaitStart = GetTickCount();
                          DEXStatus = DEX_DATA_ACK;
                          DEXsent = 0;
                          DEXstart = 0;
                          DEXSequence = '0';
                          G85 = 0;
                          break;

    case DEX_DATA_ACK:
    case DEX_DATA_SET_DELAY:
    case DEX_DATA_SET: if( DEXWait == 0 )
                          {
                            DEXStatus = DEX_SLAVE_FIRST_ENQ;
                            DEXChannel = 0xFF;
                          }
                          else if( ch == NAK || ch == DEXSequence || ch == ';' )
                          {
                            if( ch == DEXSequence )
                            {
                              DEXstart = DEXsent;
                              DEXSequence ^= 0x01;
                            }
                            if( DEXstart < sizeof( DEXData )/sizeof(unsigned short) )
                            {
                              DEXtimer = 50; DEXtimerStart = GetTickCount();     // DEBUG posso attendere 50ms il main che prepari i dati
                              DEXStatus = DEX_DATA_SET;
                              if( ch == ';' ) {  // WACK - delay di 500ms prossimo invio
                                DEXtimer = 450; DEXtimerStart = GetTickCount();
                                DEXStatus = DEX_DATA_SET_DELAY;
                              }
                              DEXWait = DEXtimer+tMarginA; DEXWaitStart = GetTickCount();
                            }
                            else
                            {
                              DEXPutChar( EOT );
                              DEXWait = INFINITE_TIMEOUT;
                              DEXChannel = 0xFF;
                              InsertEvent1( EVENT_AUDIT_READOUT, AuditData[EA302], AuditData[EA303] );
                              DEXStatus = DEX_SLAVE_FIRST_ENQ;
                            }
                          }
                          break;
#if PRODUCT_RECOGNITION
    case DEX_GET_PRODUCT:
                          if ( ch == '_' )
                          {
                              DEXiPrice = 0;
                              break;
                          }
                          if ( ch == 0x0A || ch == 0x0D )
                          {
                              newProdName( DEXbufPrice );
                              DEXStatus = DEX_SLAVE_FIRST_ENQ;
                              DEXWait = INFINITE_TIMEOUT;
                              DEXChannel = 0xFF;
                          }
                          else
                          {
                              if ( DEXiPrice < (sizeof(DEXbufPrice)-1) )
                                  DEXbufPrice[DEXiPrice++] = toupper(ch);
                              DEXbufPrice[DEXiPrice] = '\0';
                          }
                          break;
#endif
#if BIG_SCREEN
	case DEX_SELL_PRODUCT:
                          if ( ch == '*' )
                          {
                              DEXiPrice = 0;
                              break;
                          }
                          if ( ch == 0x0A || ch == 0x0D )
                          {
				              if ( getSelectionParam((byte *)&DEXbufPrice[0],&i,&j,0, machineType) == 0 )
                              {
                                  hostData.tray = i;
                                  hostData.column = j;
                                  hostData.select = 1;
                              }
                              DEXStatus = DEX_SLAVE_FIRST_ENQ;
                              DEXWait = INFINITE_TIMEOUT;
                              DEXChannel = 0xFF;
                          }
                          else
                          {
                              if ( DEXiPrice < (sizeof(DEXbufPrice)-1) )
                                  DEXbufPrice[DEXiPrice++] = toupper(ch);
                              DEXbufPrice[DEXiPrice] = '\0';
                          }
						  break;
#endif						  

    case DEX_SET_CONFIG:
                          if ( ch == '?' )
                          {
                              DEXiPrice = 0;
                              break;
                          }
                          if ( ch == 0x0A )
                          {
                              loadConfigString( DEXbufPrice, 1, machineType, TRUE );
                              DEXPutChar( 'O' );
                              DEXPutChar( 'K' );
                              DEXPutChar( '\x0D' );
                              DEXPutChar( '\x0A' );
                              DEXStatus = DEX_SLAVE_FIRST_ENQ;
                              DEXWait = 10; DEXWaitStart = GetTickCount();
                              DEXChannel = 0xFF;
                          }
                          else
                          {
                              if ( DEXiPrice < (sizeof(DEXbufPrice)-1) )
                                  DEXbufPrice[DEXiPrice++] = toupper(ch);
                              DEXbufPrice[DEXiPrice] = '\0';
                          }
                          break;
                          
    default:              DEXStatus = DEX_SLAVE_FIRST_ENQ;// errore
                          DEXWait = INFINITE_TIMEOUT;
                          DEXChannel = 0xFF;
                          break;
  }
  DEXold = ch;
#endif
}

/* COMPILE THE DEX FILE */
word  DEXloop, DEXloopStart;

static void     DEXPutCharCount( char _ch )
{
    DEXPutChar( _ch );
    crc_16( _ch );
    G85_calc( _ch );
    DEXcount++;
}

static void            DEXCopyString( char *p, byte len )
{
    if( p == NULL )
      return;

    while( *p != 0 && len-- > 0 )
        DEXPutCharCount(*p++);
}

static void            DEXPutLong( unsigned long ltmp )
{
    byte        i, tmp[8];

    i = 0;
    do
    {
        tmp[i++] = ltmp%10 + '0';
        ltmp /= 10L;
    }while( ltmp != 0 && i <= 7 );
    do {
        DEXPutCharCount( tmp[--i] );
    } while( i != 0 );
}
/*
  Prepara un record DEX ( chiamata a main )
*/

void indexedHeapSort( unsigned short *index, unsigned long *heap, int no );

#define testDex 0
static byte DEXordered =  0;
unsigned short DEXIdx[100];

/* thie funztion will use the loop index or the index used to oredr the data */
#define DEXloopIdx( )    ( ( DEXordered ) ? DEXIdx[DEXloop] : DEXloop )

void            preparaDEX( void )
{
  char  ch;
  word  wtmp;
  dword ltmp;
  byte  _mode = 1, exact_change;
  static byte DEXmachine, DEXtray, DEXcolumn;
//mmm  unsigned short DEXIdx[100];
  
  exact_change = ChangerExactChange();
  
#if testDex
  memset(AuditData, 0xaa, sizeof(AuditData));
  memset(EA1_exact_change_event,0x01, sizeof(EA1_exact_change_event));
  memset(MDBerror,0x55, sizeof(MDBerror));
#endif
   
    if( DEXStatus == DEX_DATA_SEND )  _mode = 0;    // do not use DEX framming

    if( DEXStatus == DEX_DATA_SET || DEXStatus == DEX_DATA_SET_DELAY || DEXStatus == DEX_DATA_SEND )
    {
        if( DEXsent == 0 )    // set readout date/time ( DEBUG NON SONO MEMORIZZATI IN FLASH QUI )
        {
//          indexedHeapSort( DEXIdx, (unsigned long *)(&AuditData[ PA201_00 ]), 99 );
         
          AuditData[EA302] = dateTime.year*10000 + dateTime.month*100 + dateTime.day;
          AuditData[EA303] = dateTime.hour*10000 + dateTime.min*100 + dateTime.sec;
          AuditData[SE01] = 0;
          // if full dex needed, fill also empty fields with only the selection number available
          if ( NonVolatileSetup.fullDexSelection == 0x6A )
          {                         // send all selections available, even if zero
              byte tray, column;
              for( wtmp = 0; wtmp < 100; wtmp++ )
              {
                  if (  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                  {
                      column = wtmp/MAXCOLUMN;
                      tray = wtmp%MAXCOLUMN;
                  }
                  else
                  {
                      tray = wtmp/MAXCOLUMN;
                      column = wtmp%MAXCOLUMN;
                  }
                  if ( readMotorAvailability( tray, column ) )
                      AuditSelectionInsert( 1, tray, column );
              }
          }
          memset(DEXIdx, 0x00, sizeof(DEXIdx));
          indexedHeapSort( DEXIdx, (unsigned long *)(&AuditData[ PA201_00 ]), 99 );
        }        

        if ( _mode )
        {
            DEXPutChar( DLE );
            DEXPutChar( STX );
        }
        BCC = 0;
        for( DEXcount = 0, DEXsent = DEXstart; DEXsent < sizeof( DEXData )/sizeof(unsigned short) && DEXcount < DEXBufferSize; DEXsent++ )
        {
          if( DEXData[DEXsent] == 'S' && DEXData[DEXsent+1] == 'T' && DEXData[DEXsent+2] == '*' )
          {
            G85 = 0; DEXloop = 0;
          }
          if( DEXData[DEXsent] == 'G' && DEXData[DEXsent+1] == '8' && DEXData[DEXsent+2] == '5' )
          {
              DEXPutChar( 'G' );
              crc_16( 'G' );
              DEXPutChar( '8' );
              crc_16( '8' );
              DEXPutChar( '5' );
              crc_16( '5' );
              DEXPutChar( '*' );
              crc_16( '*' );
              DEXPutChar( tabhex[ (G85>>12 ) & 0x0F ] );
              crc_16( tabhex[ (G85>>12 ) & 0x0F ] );
              DEXPutChar( tabhex[ (G85>>8 ) & 0x0F ] );
              crc_16( tabhex[ (G85>>8 ) & 0x0F ] );
              DEXPutChar( tabhex[ (G85>>4 ) & 0x0F ] );
              crc_16( tabhex[ (G85>>4 ) & 0x0F ] );
              DEXPutChar( tabhex[ (G85 ) & 0x0F ] );
              crc_16( tabhex[ (G85 ) & 0x0F ] );
              DEXcount+=8;
              DEXsent+=3;
          }
          // special fields
          else if( DEXData[DEXsent] >= ID101+0x8000 )
          {
            switch( DEXData[DEXsent] )
            {
#ifdef __WIN32__
              case ID101+0x8000 : break;
#else
              case ID101+0x8000 : DEXCopyString( &SerialID[8], 8 ); 
                                  DEXPutCharCount( '-' );
                                  DEXCopyString( MachineTypeID, 8 );
                                  break;
#endif
              case ID102+0x8000 : DEXPutCharCount( '-' );
                                  DEXPutCharCount( fwRelease[0] );
                                  DEXPutCharCount( fwRelease[1] );
                                  DEXPutCharCount( fwRelease[2] );
                                  DEXPutCharCount( fwRelease[3] );
                                  break;
              case ID106+0x8000 : DEXCopyString( (char *)NonVolatileSetup.assetID, 12 ); break;
              case EA304+0x8000 : DEXCopyString( (char *)pDEXRxData->CommID.MFG, 10 ); break;
              case CA101+0x8000 : DEXCopyString( ChangerManufacturer_Code(), 3 );
                                  DEXCopyString( ChangerSerial_Number(), 12 ); break;
              case CA102+0x8000 : DEXCopyString( ChangerTuning_Revision(), 12 ); break;
              case BA101+0x8000 : DEXCopyString( BillManufacturer_Code(), 3 );
                                  DEXCopyString( BillSerial_Number(), 12 ); break;
              case BA102+0x8000 : DEXCopyString( BillTuning_Revision(), 12 ); break;
              
              case DA101+0x8000 : DEXCopyString( CashlessManufacturer_Code(0), 3 );
                                  DEXCopyString( CashlessSerial_Number(0), 12 ); break;
              case DA102+0x8000 : DEXCopyString( CashlessTuning_Revision(0), 12 ); break;
              
              case DB101+0x8000 : DEXCopyString( CashlessManufacturer_Code(1), 3 );
                                  DEXCopyString( CashlessSerial_Number(1), 12 ); break;
              case DB102+0x8000 : DEXCopyString( CashlessTuning_Revision(1), 12 ); break;
              
              case CA1501+0x8000: DEXPutLong( (unsigned long)ChangeTubeValue( )); break;           

              default : break;
            }
          }
          // standard audit fields ( numerici )
          // debug: andrebbe controllato che i campi "contatore" non superino la dimensione di 6 caratteri
          else if( DEXData[DEXsent] & 0x8000 )
          {
            switch( DEXData[DEXsent] )
            {
//              case PA101+0x8000 : DEXPutLong( (unsigned long)amount[0][DEXloop/MAXCOLUMN][DEXloop%MAXCOLUMN]); break;
              case PA101+0x8000 : if( DEXmachine <= MAX_MACHINE_NUM )
                                    DEXPutLong( (unsigned long)amount[DEXmachine-1][DEXtray][DEXcolumn]); 
                                  else
                                    DEXPutLong( 0 );   
                                  break;    

              case EA101_01+0x8000: if( ( ltmp = AuditData[ EA101_01 + DEXloop ] ) != 0 ) {
                                      ch = (char)(ltmp >> 24); DEXPutCharCount( ch );
                                      ch = (char)(ltmp >> 16); DEXPutCharCount( ch );
                                      if( ( ch = (char)(ltmp >>  8) ) != 0 )    DEXPutCharCount( ch );
                                      if( ( ch = (char)ltmp) != 0 )             DEXPutCharCount( ch );
                                    }
                                    break;

              case PA201_00+0x8000 : DEXPutLong( AuditData[ ( DEXData[DEXsent]&0x7FFF ) + DEXloopIdx() ] & 0x007FFFFF ); break;
              
              default     : DEXPutLong( AuditData[ ( DEXData[DEXsent]&0x7FFF ) + DEXloopIdx() ] ); break;
            }
          }  
          else if( DEXData[DEXsent] & 0x4000 )
          {
            switch( DEXData[DEXsent] )
            {
              case EA101_EC+0x4000 :
                  switch (EA1_exact_change_event[DEXloop].status)
                  {
                      case 1:
                          DEXCopyString( "EA_CHGOUT", 9 );
                          break;
                      case 2:
                          DEXCopyString( "EA_CHGIN", 8 );
                          break;
                  }
                  break;
              case EA102_EC+0x4000 :
                  DEXPutLong( EA1_exact_change_event[DEXloop].date );
                  break;
              case EA103_EC+0x4000 :
                  DEXPutLong( EA1_exact_change_event[DEXloop].time );
                  break;
              case MA501+0x4000 :
                 if (exact_change)
                    DEXCopyString( "ERROR*EXACTCHANGE", 17 );
                 break;                  
              default     : DEXPutLong( MDBerror[(DEXData[DEXsent]&0x3FFF)].counter ); break;
            }
          }          
          else if( DEXData[DEXsent] == '<' )  // test empty field ( do not send )
          {
            ltmp = 0;
            wtmp = DEXsent;
            while( DEXData[++wtmp] != '>' && ltmp == 0 )
            {
              if( ( DEXData[wtmp] & 0x8000 ) == 0x8000 && DEXData[wtmp] != PA101+0x8000 )
              {
                  ltmp = AuditData[( DEXData[wtmp]&0x7FFF ) + DEXloopIdx()];
              }
              if( ( DEXData[wtmp] & 0x4000 ) == 0x4000 ) 
              {
                  if( DEXData[wtmp] == EA101_EC+0x4000 )
                      ltmp = EA1_exact_change_event[DEXloop].status;
                  else if( DEXData[wtmp] == MA501+0x4000 )
                      ltmp = exact_change;                  
                  else {
                      if (DEXData[wtmp] != EA102_EC+0x4000 && DEXData[wtmp] != EA103_EC+0x4000)
                          ltmp = MDBerror[DEXData[wtmp]&0x3FFF].counter;
                  }
              }              
//N.0.Z              if ( AuditData[EA301] == 0 && DEXData[wtmp] != PA101+0x8000 )
              if ( NonVolatileSetup.fullDexSelection == 0x6A && DEXData[wtmp] == PA201_00+0x8000 )
              {                         // send all selections available, even if not sold
                  ltmp = AuditData[ PA201_00 + DEXloopIdx() ];
              }
            }
            if( DEXData[wtmp] == '>' ) DEXsent = wtmp;
          }          
          else if( DEXData[DEXsent] == '>' )  // end for test empty fields
            continue;
          else if( DEXData[DEXsent] == '{' )  // start loop 0...n-1
          {
            DEXloopStart = DEXsent;
            DEXloop = 0;
            DEXordered = 0;          
          }
          else if( DEXData[DEXsent] == '#' )  // dex ordered
            DEXordered = 1;
          else if( DEXData[DEXsent] == '}' )  // end loop
          {
            if( ++DEXloop < DEXData[++DEXsent] )
              DEXsent = DEXloopStart;
            else
              DEXloop = 0;
          }
          else if( DEXData[DEXsent] == '&' )  // insert TRAY counter
          {
	        /* insert machine number */
//mmm               DEXordered = 1;
              
	        DEXmachine = ( AuditData[ PA201_00 + DEXloopIdx() ] >> 23 )/(MAXCOLUMN*MAXTRAY);
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 || machineType == MACHINA_VEILCM )
              DEXPutCharCount( '0' + DEXmachine );

	    /* insert TRAY number */
 ///// DEBUG ON ROWE MACHINES TRAY/COLUMN REVERSED
            DEXtray = ch = ( ( AuditData[ PA201_00 + DEXloopIdx() ] >> 23 )/MAXCOLUMN )%MAXTRAY;
            if (  machineType != MACHINA_MERCHA6 ) {
                if (  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 ) // verificare || machineType == MACHINA_USIGVC2
                  ch = ch + '0';
                else                                
                  ch = ch + ((machineType==MACHINA_AP123||machineType==MACHINA_VEIDOOR||machineType==MACHINA_VEI147||machineType==MACHINA_VEILCM)?'1':'A');
                DEXPutCharCount( ch );
            }
          }
          else if( DEXData[DEXsent] == '%' )  //  insert COLUMN counter
          {
/*            if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
              ch = DEXloop/MAXCOLUMN + '0';
            else
              ch = DEXloop%MAXCOLUMN + '0'; */
            DEXcolumn = ( AuditData[ PA201_00 + DEXloopIdx() ] >> 23 )%MAXCOLUMN; ///// DEBUG ON ROWE MACHINES TRAY/COLUMN REVERSED
            if ( machineType == MACHINA_MERCHA6 ) {
                if (ch >= 7) {
/*
to normalize the value of PA field for additional selections
first reconstruct the value of selection and then transalte it with the following table
       111 112 211 212 311 312 411 412 511 512 611 612 711 712
        76  77  78  79  80  81  82  83  84  85  86  87  88  89
*/
    
                    ch = (ch*10+DEXcolumn-76)/2 +'1';
                    DEXPutCharCount( ch );
                    DEXPutCharCount( '1' );
                    DEXPutCharCount( DEXcolumn%2 + '1' );
                }
                else {
                    ch = ch%7 + '1';
                    DEXPutCharCount( ch );                    
                    if ( DEXcolumn < 9 ) {
                        DEXPutCharCount( '0' );
                        DEXPutCharCount( DEXcolumn + '1' );
                    }
                    else {
                        DEXPutCharCount( '1' );
                        DEXPutCharCount( '0' );
                    }
                }
            }
            else
            {
                // some machine count selection column from 1 to 10: so, when column is '0', print 10
                if ( (machineType == MACHINA_NAT145 || 
                      machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123) && DEXcolumn == 0 )
                    DEXPutCharCount( '1' );
                DEXPutCharCount( DEXcolumn + '0' ); 
            }
          }
          else if( DEXData[DEXsent] == '^' )  //  insert loop counter 
            DEXPutCharCount( DEXloop + '0' );
          // any other char
          else
          {            
            DEXPutCharCount( DEXData[DEXsent] );
            if( DEXData[DEXsent] == 0x0D )  AuditData[SE01] ++;
          }
        }
        if ( _mode )
        {
            DEXPutChar( DLE );
            if( DEXcount < DEXBufferSize )   // last frame
            {
              DEXPutChar( ETX );
              crc_16( ETX );
            }
            else
            {
              DEXPutChar( ETB );
              crc_16( ETB );
            }
            DEXPutChar( BCC & 0xFF);
            DEXPutChar( BCC >> 8 );
            if( DEXStatus == DEX_DATA_SET_DELAY )  // WACK - delay di 500ms prossimo invio
            {
                DEXtimer = 450; DEXtimerStart = GetTickCount();
            }
            DEXWait = DEXtimer+tMarginA; DEXWaitStart = GetTickCount();
            DEXStatus = DEX_DATA_ACK;
        }
        else {
            if( DEXstart == sizeof( DEXData )/sizeof(unsigned short) )
            {
                DEXPutChar( ETX );
                DEXStatus = DEX_SLAVE_FIRST_ENQ;
                DEXWait = INFINITE_TIMEOUT;
                DEXChannel = 0xFF;
                InsertEvent1( EVENT_AUDIT_READOUT, AuditData[EA302], AuditData[EA303] );              
            }
            else
                DEXStatus = DEX_DATA_RDY;
        }
    }
}

/*
    send DEX over serila line
*/
void            sendDEXfile( byte _ch )
{
    if ( _ch >= nCOMM )
        return;
    DEXChars = 0;
    DEXsent = 0;
    DEXstart = 0;
    DEXStatus = DEX_DATA_SEND;
    DEXBufferSize = 70-12-3;
    DEXtimer = INFINITE_TIMEOUT;
    DEXChannel = _ch;
}

void  buildUniqueFileName( char *data );

byte            storeDEXfile( byte _ch )
{
    byte        data[64];
	uint32_t    psize;
    uint32_t    pstart;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;
    uint32_t    successcount;

    buildUniqueFileName( (char *)&data[0] );    
    data[9] = 'D';
    data[10] = 'E';
    data[11] = 'X';
    
///////////// questa parte potrebbe diventare funzione, usata sempre sulla MMC >>>>>>>>>>>>>>>>>>    
    if ( mmcInit() != mmc_noerr )
    {
		DispStr( 0, 0, " NO MMC/SD FOUND" );
        return 2;
    }

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff ) 
    {
		DispStr( 0, 0, " PARTITION ERROR" );
		return 3;
	}

	if ( DFS_GetVolInfo(0, sector, pstart, &vi) )
    {
		DispStr( 0, 0, " VOLUME ERROR   " );
		return 4;
	}
                                        // open file to write
	if ( DFS_OpenFile(&vi, data, DFS_WRITE, sector, &fi) != 0 ) 
    {
		DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
		return 3;
    }
    BuzzerOn(500);
///////////// questa parte potrebbe diventare funzione, usata sempre sulla MMC >>>>>>>>>>>>>>>>>>    

    DispStr( 0, 0, (char *)MSG_ATTESA );
    DEXsent = 0;
    DEXstart = 0;
    do {
        DEXChars = 0;
        DEXChannel = nCOMM;
        DEXStatus = DEX_DATA_SEND;
        DEXBufferSize = 64-12-3;
        pDEXbuf = (char *)&data[0];
        preparaDEX( );
        DFS_WriteFile( &fi, sector, data, &successcount, DEXChars );
        DEXstart = DEXsent;
    } while( DEXstart < sizeof( DEXData )/sizeof(unsigned short) );
    DEXStatus = DEX_SLAVE_FIRST_ENQ;
    DEXWait = INFINITE_TIMEOUT;
    DEXChannel = 0xFF;
    InsertEvent1( EVENT_AUDIT_READOUT, AuditData[EA302], AuditData[EA303] );
    Audit();
    return(0);
}

// unsigned long DEXfile[100];
// unsigned short DEXFileIndex[100], value[10], event;
/*  Struttura CA2*                identifica il campo
                  S&2=N&3=N       filtro
                           ;      sepatore
                            1     somma parametro 1
                             *    separatore
                              ;   filtro vuoto, applica il filtro precedente
                               C  conta ( incrementa di 1 il campo
 etc..

 Esempio di campo sequenziale
  PA1*
      S;                          filtro
        1;                        usa parametro 1
          1                       solo nel campo che ha lo spesso valore del parametro 1
  PA2*
      ;                           usa il filtro calcolato nel campo precedente
       C                          conta
  Il parametro PA2 viene accodato al parametro PA1 che soddisfa al filtro impostato
*/
/*
const char DEXDATA[] = { "CA2*S&2=N&3=N;1*;C*;1*;C\nPA1*S;1;1\nPA2*;C" };

unsigned long  calcola_s( word i )
{
  unsigned long acc;

  while( -1)
  {
    switch( DEXDATA[i++] )
    {
      case '=': acc = ( acc == ( DEXDATA[i++]-'0') )?1:0;
      case '>': acc = ( acc > ( DEXDATA[i++]-'0') )?1:0;
      case '<': acc = ( acc < ( DEXDATA[i++]-'0') )?1:0;
      case '+': acc += value[DEXDATA[i++]-'0']; break;
      case '-': acc -= value[DEXDATA[i++]-'0']; break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9': acc = value[DEXDATA[i++]-'0'];
      case 'C': acc = 1; break;
      default: return( acc ); break;
    }
  }
}

unsigned long  calcola_and( word i )
{
  unsigned long acc = 1;

  if( event != DEXDATA[i++] )
  {
    while( DEXDATA[i] != '|' || DEXDATA[i] != ';' ) i++;
    return( 0 );
  }
  while( DEXDATA[i++] == '&' )
  {
    acc &= calcola_s(i);
  }
  return(acc);
}

unsigned long  calcola( word i )
{
  unsigned long acc;

  acc = calcola_and(i);
  while( DEXDATA[i++] == '|' )
  {
    acc |= calcola_and(i);
  }
  return(acc);
}

// aggiorna file DEX
void  DEXupdate( void )
{
  word i, index;
  char ch;
  unsigned long acc;

  index = 0;
  for( i = 0; i < sizeof( DEXDATA ); )
  {
    if( DEXDATA[i++] == '*' )
    {
      index++;
      if( DEXDATA[i++] != ';' )   // se nessun filtro, applica l'ultimo filtro
      {
        acc = calcola(i);         // altrimenti calcola filtro
      }
      if( acc == 0 )
        continue;
      if( DEXFileIndex[index] == 0 )  // se non esiste campo
      {
        DEXFileIndex[index] = index;   // lo crea
        DEXfile[index] = 0;
      }
      DEXfile[index] += calcola(i);   // aggiorna campo
    }
  }
}

// crea file DEX partendo dalla definizione e dai dati disponibili
void  DEXFileCreate( void )
{
  word i, index;

  index = 0;
  for( i = 0; i < sizeof( DEXDATA ); )
  {
    // send DEXDATA[i] nome del campo, separatori di campo, CrLf
    if( DEXDATA[i++] == '*' )
    {
      index++;
      if( DEXFileIndex[index] != 0 )  // se esiste campo
      {
        ltoa(DEXfile[index]);        // aggiorna campo in uscita
      }
      while( DEXDATA[i] != '*' ) i++; // go to next field
    }
  }
}
*/

/*
    AuditInserEvent

    Inerisce un evento nel file di audit, riportando l'istante in cui e' avvenuto
    L'evento e' codificato in 4 bytes ( un unsigned long ), nel file di audit.
*/
#define cvstrlong( a, b, c, d )  ( ((unsigned long)a<<24) | ((unsigned long)b<<16) |((unsigned long)c<<8) |((unsigned long)d) )

static void  AuditInserEvent( struct S_EVENT *pEventR, unsigned long ev )
{
    byte i;

    i = AuditData[EA1idx] & 0x07;
    AuditData[EA1idx] = ( AuditData[EA1idx]+1 ) & 0x07;
    AuditData[EA101_01+i] = ev;
    AuditData[EA102_01+i] = pEventR -> timeStamp.year*10000 + pEventR -> timeStamp.month*100 + pEventR -> timeStamp.day;
    AuditData[EA103_01+i] = pEventR -> timeStamp.hour*10000 + pEventR -> timeStamp.min*100 + pEventR -> timeStamp.sec;
}

// debug : inserire limite 999999 per i contatori !!
static void  AuditUpdate( unsigned int offs, unsigned long val )
{
    AuditData[ offs ] += val;
    if( AuditData[ offs ] > 99999999 )
      AuditData[ offs ] -= 100000000;
}

/*
      find an empty selection record and assign to given selection ID
*/
static byte AuditSelectionInsert( byte _machine, byte _tray, byte _column )
{
    unsigned short i, j;

    if ( machineType == MACHINA_MERCHA6 ) 
    {
/*
    to mask the escrow motor (tray 7 column 0 k = 5 an = 0) in dex                
*/                                
        if ( _tray == 7 && _column == 0) 
            return( 99 );
    }
    
    j = (_machine*MAXTRAY+_tray)*MAXCOLUMN + _column;
    for( i = 0; i <= 99; i++ )
    {
        if( AuditData[ PA201_00 + i ] == 0 )            // empty location
        {
            AuditData[ PA201_00 + i ]= ( j << 23 );       // assigned to this selection
            return( i );
        }
        if( ( AuditData[ PA201_00 + i ] & 0xFF800000 ) == ( j << 23 ) ) 
            return( i );
    }
    return( 99 );
}
/*
    Audit

    Aggiorna il file di audit
*/
extern dword AuditData[];

void AuditEventHandle( struct S_EVENT *pEventR )
{
    _Credito payed;
        
    if( pEventR->event != EVENT_AUDIT_READOUT && AuditData[_LR_] != 0 )
    {
        memset( &AuditData[_LR_], 0, ( AUDIT_DATA_SIZE - _LR_ )*sizeof( dword ) );
        AuditData[EA301] ++;
        AuditData[EA305] = AuditData[EA302];
        AuditData[EA306] = AuditData[EA303];
    }

    switch( pEventR->event )
    {
        case EVENT_COIN_IN_CASHBOX:
                            AuditUpdate( CA301 , pEventR->val );
                            AuditUpdate( CA305 , pEventR->val );
                            AuditUpdate( CA302 , pEventR->val );
                            AuditUpdate( CA306 , pEventR->val );
                            switch( pEventR->val )
                            {
                              case 5 : AuditUpdate( CA1102_5 , 1 );AuditUpdate( CA1103_5 , 1 );AuditUpdate( CA1105_5 , 1 );AuditUpdate( CA1106_5 , 1 );break;
                              case 10 : AuditUpdate( CA1102_10 , 1 );AuditUpdate( CA1103_10 , 1 );AuditUpdate( CA1105_10 , 1 );AuditUpdate( CA1106_10 , 1 );break;
                              case 25 : AuditUpdate( CA1102_25 , 1 );AuditUpdate( CA1103_25 , 1 );AuditUpdate( CA1105_25 , 1 );AuditUpdate( CA1106_25 , 1 );break;
                              case 50 : AuditUpdate( CA1102_50 , 1 );AuditUpdate( CA1103_50 , 1 );AuditUpdate( CA1105_50 , 1 );AuditUpdate( CA1106_50 , 1 );break;
                              case 100 : AuditUpdate( CA1102_100 , 1 );AuditUpdate( CA1103_100 , 1 );AuditUpdate( CA1105_100 , 1 );AuditUpdate( CA1106_100 , 1 );break;
                              case 200 : AuditUpdate( CA1102_200 , 1 );AuditUpdate( CA1103_200 , 1 );AuditUpdate( CA1105_200 , 1 );AuditUpdate( CA1106_200 , 1 );break;
                              case 500 : AuditUpdate( CA1102_500 , 1 );AuditUpdate( CA1103_500 , 1 );AuditUpdate( CA1105_500 , 1 );AuditUpdate( CA1106_500 , 1 );break;
                            default: break;
                            }
                            break;

        case EVENT_COIN_IN_TUBE:
                            AuditUpdate( CA301 , pEventR->val );
                            AuditUpdate( CA305 , pEventR->val );
                            AuditUpdate( CA303 , pEventR->val );
                            AuditUpdate( CA307 , pEventR->val );
                            switch( pEventR->val )
                            {
                              case 5 : AuditUpdate( CA1102_5 , 1 );AuditUpdate( CA1104_5 , 1 );AuditUpdate( CA1105_5 , 1 );AuditUpdate( CA1107_5 , 1 );break;
                              case 10 : AuditUpdate( CA1102_10 , 1 );AuditUpdate( CA1104_10 , 1 );AuditUpdate( CA1105_10 , 1 );AuditUpdate( CA1107_10 , 1 );break;
                              case 25 : AuditUpdate( CA1102_25 , 1 );AuditUpdate( CA1104_25 , 1 );AuditUpdate( CA1105_25 , 1 );AuditUpdate( CA1107_25 , 1 );break;
                              case 50 : AuditUpdate( CA1102_50 , 1 );AuditUpdate( CA1104_50 , 1 );AuditUpdate( CA1105_50 , 1 );AuditUpdate( CA1107_50 , 1 );break;
                              case 100 : AuditUpdate( CA1102_100 , 1 );AuditUpdate( CA1104_100 , 1 );AuditUpdate( CA1105_100 , 1 );AuditUpdate( CA1107_100 , 1 );break;
                              case 200 : AuditUpdate( CA1102_200 , 1 );AuditUpdate( CA1104_200 , 1 );AuditUpdate( CA1105_200 , 1 );AuditUpdate( CA1107_200 , 1 );break;
                              case 500 : AuditUpdate( CA1102_500 , 1 );AuditUpdate( CA1104_500 , 1 );AuditUpdate( CA1105_500 , 1 );AuditUpdate( CA1107_500 , 1 );break;
                            default: break;
                            }
                            if( doorOpen() )
                            {
                              AuditUpdate( CA1001 , pEventR->val );
                              AuditUpdate( CA1002 , pEventR->val );
                            }
                            if( pEventR->param[0] < 8 )
                            {
                                AuditData[ CA1702_1 + pEventR->param[0] ] = pEventR->val;
                                AuditData[ CA1703_1 + pEventR->param[0] ] = pEventR->param[1];
                                if( doorOpen() )
                                    AuditUpdate( CA1704_1 + pEventR->param[0], 1 );
                            }
                            break;

//        case EVENT_COIN_REJECT:
//                            AuditUpdate( EA202_EAS , 1 );
//                            break;

//            case EVENT_BILL_ESCROW: viene gestito solo quando effettivamente viene messo in stack
        case EVENT_BILL_IN: AuditUpdate( CA301 , pEventR->val );
                            AuditUpdate( CA305 , pEventR->val );
                            AuditUpdate( CA304 , (pEventR->val/100) );   // old compatibility issue USA bills
                            AuditUpdate( CA308 , (pEventR->val/100) );   // old compatibility issue USA bills
                            AuditUpdate( CA309 , pEventR->val );
                            AuditUpdate( CA310 , pEventR->val );
                            switch( pEventR->val )
                            {                                                            // stacked
                              case 100 : AuditUpdate( CA1402_100 , 1 );AuditUpdate( CA1404_100 , 1 );AuditUpdate( CA1403_100 , 1 );AuditUpdate( CA1405_100 , 1 );break;
                              case 200 : AuditUpdate( CA1402_200 , 1 );AuditUpdate( CA1404_200 , 1 );AuditUpdate( CA1403_200 , 1 );AuditUpdate( CA1405_200 , 1 );break;
                              case 500 : AuditUpdate( CA1402_500 , 1 );AuditUpdate( CA1404_500 , 1 );AuditUpdate( CA1403_500 , 1 );AuditUpdate( CA1405_500 , 1 );break;
                              default: break;
                            }
                            break;

        case EVENT_BILL_RECYCLE:
                            AuditUpdate( CA311 , pEventR->val );
                            AuditUpdate( CA312 , pEventR->val );
                            break;
                            
        case EVENT_BILL_OUT:switch( pEventR->val )
                            {                                                            // returned
                              case 100 : AuditUpdate( CA1402_100 , 1 );AuditUpdate( CA1404_100 , 1 );break;
                              case 200 : AuditUpdate( CA1402_200 , 1 );AuditUpdate( CA1404_200 , 1 );break;
                              case 500 : AuditUpdate( CA1402_500 , 1 );AuditUpdate( CA1404_500 , 1 );break;
                              default: break;
                            }
                            AuditUpdate( CA408 , pEventR->val );
                            break;

        case EVENT_BILL_MANUAL_DISPENSE:
                            AuditUpdate( CA408 , pEventR->val );
                            AuditUpdate( CA409 , pEventR->val );
                            break;
                            
        case EVENT_BILL_TRANSFER_RECYCLE:
                            AuditUpdate( CA407 , pEventR->val );
                            AuditUpdate( CA410 , pEventR->val );
                            break;

        case EVENT_BILL_MANUAL_FILL_RECYCLE:
                            AuditUpdate( CA1003 , pEventR->val );
                            AuditUpdate( CA1004 , pEventR->val );
                            break;
                            
        case EVENT_BILL_PAYOUT:
                            AuditUpdate( CA405 , pEventR->val );
                            AuditUpdate( CA408 , pEventR->val );
                            break;                            

        case EVENT_COIN_PAYOUT:
                            AuditUpdate( CA401 , pEventR->val );
                            AuditUpdate( CA403 , pEventR->val );
                            switch( pEventR->val )
                            {
                              case 5 : AuditUpdate( CA1202_5 , 1 );AuditUpdate( CA1204_5 , 1 );break;
                              case 10 : AuditUpdate( CA1202_10 , 1 );AuditUpdate( CA1204_10 , 1 );break;
                              case 25 : AuditUpdate( CA1202_25 , 1 );AuditUpdate( CA1204_25 , 1 );break;
                              case 50 : AuditUpdate( CA1202_50 , 1 );AuditUpdate( CA1204_50 , 1 );break;
                              case 100 : AuditUpdate( CA1202_100 , 1 );AuditUpdate( CA1204_100 , 1 );break;
                              case 200 : AuditUpdate( CA1202_200 , 1 );AuditUpdate( CA1204_200 , 1 );break;
                              case 500 : AuditUpdate( CA1202_500 , 1 );AuditUpdate( CA1204_500 , 1 );break;
                            default: break;
                            }
                            break;

        case EVENT_COIN_OUT:
                            AuditUpdate( CA401 , pEventR->val );
                            AuditUpdate( CA403 , pEventR->val );
                            AuditUpdate( CA402 , pEventR->val );
                            AuditUpdate( CA404 , pEventR->val );
                            switch( pEventR->val )
                            {
                              case 5 : AuditUpdate( CA1202_5 , 1 );AuditUpdate( CA1203_5 , 1 );AuditUpdate( CA1204_5 , 1 );AuditUpdate( CA1205_5 , 1 );break;
                              case 10 : AuditUpdate( CA1202_10 , 1 );AuditUpdate( CA1203_10 , 1 );AuditUpdate( CA1204_10 , 1 );AuditUpdate( CA1205_10 , 1 );break;
                              case 25 : AuditUpdate( CA1202_25 , 1 );AuditUpdate( CA1203_25 , 1 );AuditUpdate( CA1204_25 , 1 );AuditUpdate( CA1205_25 , 1 );break;
                              case 50 : AuditUpdate( CA1202_50 , 1 );AuditUpdate( CA1203_50 , 1 );AuditUpdate( CA1204_50 , 1 );AuditUpdate( CA1205_50 , 1 );break;
                              case 100 : AuditUpdate( CA1202_100 , 1 );AuditUpdate( CA1203_100 , 1 );AuditUpdate( CA1204_100 , 1 );AuditUpdate( CA1205_100 , 1 );break;
                              case 200 : AuditUpdate( CA1202_200 , 1 );AuditUpdate( CA1203_200 , 1 );AuditUpdate( CA1204_200 , 1 );AuditUpdate( CA1205_200 , 1 );break;
                              case 500 : AuditUpdate( CA1202_500 , 1 );AuditUpdate( CA1203_500 , 1 );AuditUpdate( CA1204_500 , 1 );AuditUpdate( CA1205_500 , 1 );break;
                            default: break;
                            }
                            if( pEventR->param[0] < 8 )
                            {
                              AuditData[ CA1702_1 + pEventR->param[0] ] = pEventR->val;
                              AuditData[ CA1703_1 + pEventR->param[0] ] = pEventR->param[1];
                              if( doorOpen() )
                                AuditUpdate( CA1705_1 + pEventR->param[0], 1 );
                            }
                            break;

        case EVENT_TOKEN_IN_TUBE:
                            // TO BE DONE
        case EVENT_TOKEN_IN_CASHBOX:
                            // TO BE DONE
                            break;

        case EVENT_TOKEN_IN:
                            // TO BE DONE
        case EVENT_TOKEN_ESCROW:
                            // TO BE DONE
                            break;
                            
        case EVENT_SELECTION_START:
                            exactChangeInserEvent( ChangerExactChange() );
                            break;
                            
        case EVENT_SELECTION_OK:
                            AuditUpdate( VA101 , SelectionData.price ); AuditUpdate( VA102 , 1 );
                            AuditUpdate( VA103 , SelectionData.price ); AuditUpdate( VA104 , 1 );
                            payed = SelectionData.payedCash + SelectionData.payedCashless1 + SelectionData.payedCashless2;
                            if( payed < SelectionData.price )
                            {
                              AuditUpdate( VA105 , ( SelectionData.price - payed ) ); AuditUpdate( VA106 , 1 );
                              AuditUpdate( VA107 , ( SelectionData.price - payed ) ); AuditUpdate( VA108 , 1 );
                            }
                            if( payed > SelectionData.price )
                            {
                              AuditUpdate( VA109 , ( payed - SelectionData.price ) ); AuditUpdate( VA110 , 1 );
                              AuditUpdate( VA111 , ( payed - SelectionData.price ) ); AuditUpdate( VA112 , 1 );
                            }
                            if( SelectionData.askCashless1 == 0 && SelectionData.askCashless2 == 0 )  // cash need
                            {
                              AuditUpdate( CA201 , SelectionData.price ); AuditUpdate( CA202 , 1 );
                              AuditUpdate( CA203 , SelectionData.price ); AuditUpdate( CA204 , 1 );
                            }
                            else
                            {
                              if( SelectionData.askCashless1 != 0 )
                              {
                                AuditUpdate( DA201 , SelectionData.askCashless1 ); AuditUpdate( DA202 , 1 );
                                AuditUpdate( DA203 , SelectionData.askCashless1 ); AuditUpdate( DA204 , 1 );
                              }
                              if( SelectionData.askCashless2 != 0 )
                              {
                                AuditUpdate( DB201 , SelectionData.askCashless2 ); AuditUpdate( DB202 , 1 );
                                AuditUpdate( DB203 , SelectionData.askCashless2 ); AuditUpdate( DB204 , 1 );
                              }
                            }

                            {
                              byte i;

                              if( ( i = AuditSelectionInsert( SelectionData.machine, SelectionData.tray, SelectionData.column))  <= 99 )
                              {
                                if( testVend == 0x68 )    // test vend
                                {
                                  AuditUpdate( PA301_00 + i , 1 );
                                  AuditUpdate( PA302_00 + i , SelectionData.price );
                                  AuditUpdate( PA303_00 + i , 1);
                                  AuditUpdate( PA304_00 + i , SelectionData.price );
                                }
                                else
                                {
                                  //AuditUpdate( PA201_00 + i , 1 );
                                  AuditData[ PA201_00 + i ]++; if( ( AuditData[ PA201_00 + i ] & 0x007FFFFF ) >= 8000000 ) AuditData[ PA201_00 + i ] -= 8000000;
                                  AuditUpdate( PA202_00 + i , SelectionData.price );
                                  AuditUpdate( PA203_00 + i , 1);
                                  AuditUpdate( PA204_00 + i , SelectionData.price );
                                }
                              }
                            }

                            if( SelectionData.ExactChange )
                            {
                                AuditUpdate( CA901, SelectionData.price );
                                AuditUpdate( CA902, SelectionData.price );
                            }
                            break;

        case EVENT_POWER_UP:
                            AuditUpdate( CA501 , 1 );
                            AuditUpdate( CA502 , 1 );
                            break;

        case EVENT_DOOR_OPEN:
                            AuditUpdate( CA602 , 1 );
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'G', 'S', 0x00 ) );
                            break;

        case EVENT_DOOR_CLOSE:
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'G', 'T', 0x00 ) );
                            break;
                            
        case EVENT_PROGRAMMING_OPTION_SAVING:
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'C', 'V', 0x00 ) );
                            break;

        case EVENT_STACKER_FULL:
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'N', 'E', 0x00 ) );
                            break;

        case EVENT_HEALTH_TIMEOUT_ON:
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'J', 'H', 0x00 ) );
                            break;

        case EVENT_HEALTH_TIMEOUT_OFF:
                            AuditInserEvent( pEventR, cvstrlong( 'E', 'J', 'W', 0x00 ) );
                            break; 

        case EVENT_AUDIT_READOUT:
                            AuditUpdate( CA601 , 1 );
                            AuditData[ EA302 ] = pEventR->val;
                            AuditData[ EA303 ] = pEventR->param[0];
                            AuditData[_LR_] = 1;   // clear audit flag
                            break;
        default:
            break;

    }
}

/*
*/
void            Audit( void )
{
#ifdef  __WIN32__
    static struct S_EVENT *pEventR = sEvent;

    while( pEventR != pEventCreditR/*pEventW*/ )
    {
        AuditEventHandle( pEventR );
        if( ++pEventR >= &sEvent[16] ) pEventR = sEvent;
    }
    saveAudit();
#else
    static struct S_EVENT *pEventR = sEvent;
    DWORD pFlashAddr;
    byte  FlashRecord[256];

    while( pEventR != pEventCreditR/*pEventW*/ )
    {
        AuditEventHandle( pEventR );
        // cerca prima entry libera in flash
        pFlashAddr = (DWORD)0x00070000;
        while( pFlashAddr < (DWORD)(0x00078000-256) && ((struct S_EVENT *)pFlashAddr)->event != EVENT_EMPTY )
            pFlashAddr += 256;
        memset( FlashRecord, 0xFF, sizeof(FlashRecord) );
        memcpy( FlashRecord, pEventR, sizeof( struct S_EVENT ) );
        memcpy( FlashRecord+sizeof( struct S_EVENT ), &SelectionData, sizeof( struct S_SelectionData ) );
        WriteFlash256( FlashRecord, pFlashAddr, 0 );
        pFlashAddr += 256;
        if ( pFlashAddr >= (DWORD)0x00078000 )
        {
            saveAudit();
            pFlashAddr = (DWORD)0x00070000;
            EraseBlock( pFlashAddr, 1 );
        }
/*
        saveAudit();
*/
        if( ++pEventR >= &sEvent[16] ) pEventR = sEvent;
    }
#endif
}




/*--------------------------------------------------------------------------
 | saveAudit:   save audit on non-volatile memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveAudit( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("audit.bin","wb")) == NULL )
        return;

    data1 = 0x11112222;
    data2 = 0x33334444;
    write( fileno(fin), &data1, sizeof(data1)  );
    write( fileno(fin), AuditData, sizeof(AuditData) );

    fclose(fin);
                                #else
    DWORD       m;
    char *      p;

                                        //  audit file header
    AuditData[AUDIT_REV] = DEX_REVISION;
    AuditData[AUDIT_COUNT] --;
    AuditData[AUDIT_CRC] = 0L;
    for( m = 1; m < AUDIT_DATA_SIZE; m++ )
        AuditData[AUDIT_CRC] += AuditData[m];
    // usa l'area flash che contiene il record piu' vecchio
    m = (DWORD)0x0007A000;
    if( ((DWORD *)m)[AUDIT_COUNT] < ((DWORD *)0x0007B000)[AUDIT_COUNT] )
        m = (DWORD)0x0007B000;
    EraseBlock( m, 1 );                            // 400ms
    // inizia dal fondo per scrivere per ultimo l'header del file, che contiene i dati che
    // ne permettono la verifica della congruenza
    m += ( ( (sizeof(AuditData) + 255) & 0x000FFF00U ) - 256);
    p = (char *)&AuditData[AUDIT_DATA_SIZE-256/sizeof(DWORD)];       // 16ms
    while( p >= (char *)(&AuditData[0]) )
    {
        WriteFlash256( p, m, 0 );       m -= 256;   p -= 256;
    }
    
    if( memcmp( (char *)m, (char *)AuditData, sizeof(AuditData) != 0 ) )
        ; // DEBUG visualizza qualche cosa!!
                                #endif
}                                               //  saveAudit




/*--------------------------------------------------------------------------
 | loadAudit:  load the audit from non-volatile memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            loadAudit( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("audit.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1, sizeof(data1)  );
    read( fileno(fin), AuditData, sizeof(AuditData) );

    if ( data1 != 0x11223344 || data2 != 0x55667788 )
    {
        memset( AuditData, 0,   sizeof(AuditData) );
        AuditData[AUDIT_COUNT] --;
    }

    fclose(fin);
                                #else
    DWORD       m, pFlashAddr;

    m = (DWORD)0x0007A000;
    if ( ((DWORD *)m)[AUDIT_COUNT] > ((DWORD *)0x0007B000)[AUDIT_COUNT] )
        m = (DWORD)0x0007B000;
    memcpy( AuditData, (void *)m, sizeof(AuditData) );
    for( m = 1; m < AUDIT_DATA_SIZE; m++ )
        AuditData[AUDIT_CRC] -= AuditData[m];
    if( AuditData[AUDIT_CRC] != 0 )
        AuditData[AUDIT_REV] = 0;
    if( AuditData[AUDIT_REV] != DEX_REVISION )
        initAudit();
    
    // ricostruisce l'audit dalla lista degli ultimi eventi memorizzati
    pFlashAddr = (DWORD)0x00070000;
    while( pFlashAddr < (DWORD)0x00078000 && ((struct S_EVENT *)pFlashAddr)->event != EVENT_EMPTY )
    {
        memcpy( &SelectionData, (void *)(pFlashAddr+sizeof( struct S_EVENT )), sizeof( struct S_SelectionData ) );
        AuditEventHandle( ((struct S_EVENT *)pFlashAddr) );
        cash = ((struct S_EVENT *)pFlashAddr)->credit;
        pFlashAddr += 256;
    }    
                                #endif
}                                               //  loadAudit




/*--------------------------------------------------------------------------
 | initAudit:  init the audit on non-volatile memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            initAudit( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("audit.bin","rb")) == NULL )
        return;
    memset( AuditData, 0,   sizeof(AuditData) );
    AuditData[AUDIT_COUNT] --;
    fclose(fin);
                                #else
    EraseBlock( (DWORD)0x0007A000, 1 );
    EraseBlock( (DWORD)0x0007B000, 1 );
    EraseBlock( (DWORD)0x00070000, 1 );
    memset( AuditData, 0, sizeof(AuditData) ); // il file audit non e' delle revisione corretta
    AuditData[AUDIT_COUNT] --;
    saveAudit();
                                #endif
}                                               //  initAudit

/*--------------------------------------------------------------------------
 | initMdbError:  init MDB error struct
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            initMdbError( void )
{
    memset(MDBerror, 0x00, sizeof(MDBerror));
}

/*--------------------------------------------------------------------------
 | incMdbError:  MDB event error counter increment
 |                              --------------
 | In:              MDBerror array index
 |                  MDBerror array offset
 | Out:
 +--------------------------------------------------------------------------*/

void            incMdbError( char index, char offset )
{
    MDBerror[offset+index].counter++;
}

/*--------------------------------------------------------------------------
 | InitExactChangeInserEvent:  exact change event struct init
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void  initExactChangeInserEvent( void )
{
    memset(EA1_exact_change_event, 0x00, sizeof(EA1_exact_change_event));
}

/*--------------------------------------------------------------------------
 | ExactChangeInserEvent:  exact change event on off log
 |                              --------------
 | In:              exact change present/not present
 | Out:
 +--------------------------------------------------------------------------*/

void  exactChangeInserEvent( byte _ev )
{
    static byte EA1_index;

    if ((_ev+1) != EA1_exact_change_event[EA1_index>0?EA1_index-1:EA1_EXACT_CHANGE_EVENT_ARRAY_SIZE].status)
    {
        EA1_exact_change_event[EA1_index].status = _ev+1;
        EA1_exact_change_event[EA1_index].date = dateTime.year*10000 + dateTime.month*100 + dateTime.day;
        EA1_exact_change_event[EA1_index].time = dateTime.hour*10000 + dateTime.min*100 + dateTime.sec; 
        EA1_index = (EA1_index+1)%EA1_EXACT_CHANGE_EVENT_ARRAY_SIZE;
    }
}
