/*
 * Single pin interface GPIO40 DS2431 maxim
 */

#include "io2368.h"
#include "hwinit.h"
#include "funzioni.h"
#include "crc16.h"
#include "ram.h"
#include "timer.h"

//Mette a "0"
//#define	SinglePINLow()      IO0DIR_bit.P0_30 = 1; IO0CLR_bit.P0_30 = 1;

//#define	SinglePINHigh()     IO0DIR_bit.P0_30 = 1; IO0SET_bit.P0_30 = 1;

// Rilascia
//#define	SinglePINPull()     IO0DIR_bit.P0_30 = 0


// restituisce il valore attuale del pin
//#define	SinglePINStatus()   IO0PIN_bit.P0_30

void SinglePINLow( void )
{
    if (UCB_903C == UCB) 
    {
        IO0DIR_bit.P0_30 = 1; 
        IO0CLR_bit.P0_30 = 1;
    }
    else {
        IO0DIR_bit.P0_23 = 1; 
        IO0CLR_bit.P0_23 = 1;           
    }    
}

void SinglePINHigh( void )
{
    if (UCB_903C == UCB) 
    {
        IO0DIR_bit.P0_30 = 1; 
        IO0SET_bit.P0_30 = 1;        
    }
    else {
        IO0DIR_bit.P0_23 = 1; 
        IO0SET_bit.P0_23 = 1;
    }
}

void SinglePINPull( void )
{
    if (UCB_903C == UCB) 
        IO0DIR_bit.P0_30 = 0;
    else
        IO0DIR_bit.P0_23 = 0;
}

char SinglePINStatus( void )
{
    if (UCB_903C == UCB) 
        return IO0PIN_bit.P0_30;
    else 
        return IO0PIN_bit.P0_23;
}


#define ResetDS2431()       SinglePINPull(); WaituS( 550 ); SinglePINLow(); WaituS( 550 ); SinglePINPull()

#define	WaituS( a )	    { T1TC = 0; T1TCR = 1; while( T1TC < ((a)*(TIMER_CLOCK/1000)/1000-13/4) ); T1TCR = 0;}

typedef union {
  // indice 0 meno significativo 7 pi significativo
  long l[2];
  unsigned char b[8];
} Key;
Key id;
char  SerialID[17];
char  MachineTypeID[9];

/*
==================================================================================================================================
  PROTOCOLLO BASSO LIVELLO DI COMUNICAZIONE CON I DS2431
==================================================================================================================================
*/
/* MASTER TX BYTE
   v: dato da inviare
*/
void SinglePINWrite( char v )
{
	unsigned char mask = 0x01;

	do
	{
		SinglePINLow();
		if( v & mask )
			WaituS( 6 )	        // Tlow1(max) = 15uS, 6uS to have margin
		else
			WaituS( 100 )		// Tlow0(max) < Tslot, 100uS to have margin
		SinglePINPull();
		WaituS(120);
		mask <<= 1;
	}while( mask );
        crc_16( v );
}
/* MASTER RX
   *crc: CRC del dato letto
   response: dato letto
*/
unsigned char SinglePINRead( unsigned char *crc )
{
    //volatile GPIO_REGS *v_pGPIOReg = (volatile GPIO_REGS *)GPIO_BASE_U_VIRTUAL;
    //volatile unsigned *lTimerOSCRAddress = (unsigned *)(OST_BASE_U_VIRTUAL+OSCR_OFFSET);
    //unsigned Start;
	unsigned char mask = 0x01, response = 0;


	do
	{
		SinglePINLow();
		WaituS( 2);														// timer start here
		SinglePINPull();
		WaituS( 5);
		//while( (*lTimerOSCRAddress - Start) < ( (15-3) * 36864 )/10000 );	// Trdv = 15uS, 3uS as margin
		if( SinglePINStatus() )
		{
			response |= mask;
			*crc ^= 0x80;
		}
		if( *crc & 0x80 )
		{
			*crc ^= 0x18;
			*crc <<= 1;
			*crc |= 0x01;
		}
		else
			*crc <<= 1;
		WaituS (120);
		//while( (*lTimerOSCRAddress - Start) < ( (120+10) * 36864 )/10000 );	// Tslot= 120uS, 10uS margin
		mask <<= 1;
	}while( mask );
        crc_16( response );
	return( response );
}

// Inizializzazione comunicazione restituisce 0 se errore altrimenti il codice ID del dispositivo
void  SinglePIN_ID( void )
{
    //volatile GPIO_REGS *v_pGPIOReg = (volatile GPIO_REGS *)GPIO_BASE_U_VIRTUAL;
    //volatile unsigned *lTimerOSCRAddress = (unsigned *)(OST_BASE_U_VIRTUAL+OSCR_OFFSET);
    //unsigned Start;
	unsigned char crc;//, *pEdbg;

        id.b[6] = id.b[7] = 0;  // mi servono per  riferire un eventuale errore li setto a 0xFF

	// Reset : keep line low > 480uS
        ResetDS2431();
	// wait presence pulse : within 15-60us, DS2401 will pull down line for 60-240us
	// this means input will go low from (15+60) to (60+240)us, and we will sample at 45us
    WaituS( 45 );
	if( SinglePINStatus() )
	{
		WaituS( 45 );					// if high retest 45us from now
        if( SinglePINStatus() ) {
            id.l[0] = id.l[1] = 0;
	        return;				        // high. DS2401 not present or broken
        }
	}
	while( !SinglePINStatus() );		// wait DS2401 release the line
	WaituS(120);						// wait some time
	// DS1991 in present, send ROM READ command 0x33
	SinglePINWrite( (char)0x33 );
	crc = 0;
        if( SinglePINRead( &crc ) != 0x2D ) { // 2Dh codice della famiglia DS2431
          id.b[6] = id.b[7] = 0xFF;
          return;				// ID code not known
        }
	id.b[0] = SinglePINRead(&crc);
	id.b[1] = SinglePINRead(&crc);
	id.b[2] = SinglePINRead(&crc);
	id.b[3] = SinglePINRead(&crc);
	id.b[4] = SinglePINRead(&crc);
	id.b[5] = SinglePINRead(&crc);
	
	SinglePINRead( &crc );

	if( crc == 0 )
		return;

        id.l[0] = id.l[1] = 0xFF;
	return;
}

/*
============================================================================================================================================
  COMANDI PER IL DS2431
============================================================================================================================================
*/
int PresencePulseDS2431 (void)
{
  	WaituS( 45 );
	if( SinglePINStatus() )
	{
		WaituS( 45 );					// if high retest 45us from now
		if( SinglePINStatus() )
			return( 0 );				// high. DS2401 not present or broken
	}
	while( !SinglePINStatus() );		// wait DS2401 release the line
	WaituS(120);						// wait some time
  return 1;
}
// Copia da mem nbyte nella scratchpad del dispositivo partendo da startaddress
int WriteScratchpadDS2431 (unsigned char *mem, unsigned short startaddress, unsigned char nbyte)
{
      unsigned char index, crc;

      SinglePIN_ID();
      BCC = 0;
      SinglePINWrite(0x0F);                // command write scratchpad (DS2431A pg.6)
      SinglePINWrite(startaddress & 0xFF); // address start low
      SinglePINWrite(startaddress>>8);     // address start high
      for(index = 0; (index < nbyte) && (index < 0X08); index++) SinglePINWrite((char)mem[index]);
      BCC = ~BCC;
      SinglePINRead(&crc);  // crc16
      SinglePINRead(&crc);  // crc16
      if( BCC != 0 )  return( 0 );
      return PresencePulseDS2431();
}

// Copia dalla scratchpad alla mem partendo da startaddress
int ReadScratchpadDS2431 (unsigned char *mem, unsigned short startaddress, unsigned char nbyte)
{
      unsigned char crc, index;
      SinglePIN_ID();
      BCC = 0;
      SinglePINWrite(0xAA); // command read scratchpad (DS2431A pg.5)
      SinglePINRead(&crc);  // TA1
      SinglePINRead(&crc);  // TA2
      index = SinglePINRead(&crc);  // E/S
      for(index = 0; (index < nbyte) && ( index < 0x08 ); index++) mem[index] = SinglePINRead(&crc);
      BCC = ~BCC;
      SinglePINRead(&crc);  // crc16
      SinglePINRead(&crc);  // crc16
      if( BCC != 0 )  return( 0 );
      return PresencePulseDS2431();
}

// Copia lo stratchpad nella eeprom
void CopyScratchpadDS2431(unsigned short startaddress)
{
      unsigned char crc;

      SinglePIN_ID();
      SinglePINWrite(0x55);   // command copy scratchpad (DS2431A pg.5)
      SinglePINWrite(startaddress & 0xFF); // address start
      SinglePINWrite(startaddress>>8);     // address start high
      SinglePINWrite(0x07);   // validation key E/S

      SinglePINHigh();
    
      WaituS(11000);
      SinglePINPull();
      SinglePINRead(&crc);  // crc16
      SinglePINRead(&crc);  // crc16
}

// Copia dalla EEPROM a mem partendo da startaddress
unsigned char* ReadEepromDS2431 (unsigned char *mem, unsigned short startaddress, unsigned char nbyte)
{
      unsigned char crc, index;
      SinglePIN_ID();
      SinglePINWrite(0xF0); // command read scratchpad (DS2431A pg.5)
      SinglePINWrite(startaddress & 0xFF); // address start
      SinglePINWrite(startaddress>>8);     // address start high
      for(index = 0; (index < nbyte) && (index < 0x08); index++) mem[index] = SinglePINRead(&crc);
      return mem;
}

void ReadIDDS2431 ( void )
{
      unsigned char i, j;

      SinglePIN_ID();
      for( i = 0, j = 16; i < 8; i++ )
      {
        SerialID[--j] = cvHex( id.b[i] >> 4 );
        SerialID[--j] = cvHex( id.b[i] & 0x0F );
      }
      SerialID[16] =  0;
      ReadEepromDS2431( (unsigned char *)MachineTypeID, 0, 8 );
      MachineTypeID[8] = 0;
}

/*
==================================================================================================================================
  CODICE DI CRIPTAZIONE E DECRIPTAZIONE DATI
==================================================================================================================================
*/

#define VALORE_STANDARD1 0x3D
#define VALORE_STANDARD2 0x1A

static void waitus(void)
{
  T1TC = 0;
  while( T1TC < 50);
}

void (* kk)(void);

void decode(long* v)
{
  unsigned long n=32, sum, y=v[0], z=v[1],
  delta=0x9e3779b9 ;
  sum=delta<<5 ;
  kk = waitus;

  /* start cycle */
  while (n-->0) {
    z-= (y<<4)+((long*)kk)[2] ^ y+sum ^ (y>>5)+((long*)kk)[3] ;
    y-= (z<<4)+((long*)kk)[0] ^ z+sum ^ (z>>5)+((long*)kk)[1] ;
    sum-=delta ;
  }
                       /* end cycle */
  v[0]=y ;
  v[1]=z ;
}

void code(long* v)
{
  unsigned long y=v[0],z=v[1], sum=0,   /* set up */
  delta=0x9e3779b9, n=32 ;             /* a key schedule constant */
  kk = waitus;


  while (n-->0) {                       /* basic cycle start */
  sum += delta ;
    y += (z<<4)+((long*)kk)[0] ^ z+sum ^ (z>>5)+((long*)kk)[1] ;
    z += (y<<4)+((long*)kk)[2] ^ y+sum ^ (y>>5)+((long*)kk)[3] ;   /* end cycle */
              }
  v[0]=y ; v[1]=z ;
}

/*
  Carica la chiave criptata dalla memoria, la decripta e determina se  uguale all'ID del DS2431 collegato
  Viene passato l'id del dispositivo
  restituisce 1 se successo, 0 altrimenti
*/
int loadIDcript (Key idstart, unsigned char *mem)
{
  Key pwd;
  unsigned char index_id;
  int index;

  // Trova l'offset dove andare a prendere l'ID criptato
  index_id = 0;
  for(index = 0; index < 6; index++) index_id += idstart.b[index];
      index_id %= 0X8;

  // Copia i 128bit dell'ID criptato
  for(index = 0; index < 8; index++) {
     pwd.b[index] = mem[index_id];
     index_id++;
     index_id %= 0x08;
  }

  decode(pwd.l);  // Decodifica l'ID criptato ritorna l'id corretto

  // confronta l'ID originale con quello decriptato
  for(index = 0; index < 6; index++) {
    if(idstart.b[index] != pwd.b[index]) return 0;
  }
  return 1;
}

/*
  Codifica l'ID del dispositivo DS1871 e lo inserisce in una determinata locazione di memoria nel dispositivo
  La posizione  determinata dalla somma dei byte della chiave. (la memoria  gestita ad anello)
  Viene passato l'id del dispositivo
*/
void saveIDcript (Key idstart, unsigned char *mem)
{
  unsigned char index_id;
  int index;

  // Trova l'offset dove andare a prendere l'ID criptato
  index_id = 0;
  for(index = 0; index < 6; index++) {
    index_id += idstart.b[index];
  }
  index_id %= 0x08;

  idstart.b[6] = VALORE_STANDARD1;
  idstart.b[7] = VALORE_STANDARD2;

  code(idstart.l);  // Codifica la chiave

  // Qua dovrei generare dei numeri casuali per mem

  // Copia i 128bit dell'ID criptato
  for(index = 0; index < 8; index++) {
     mem[index_id] = idstart.b[index];
     index_id++;
     index_id %= 0x08;
  }
  // Infine copia sulla Scratchpad e salva sulla EEPROM
  //SinglePIN_ID();
  WriteScratchpadDS2431(mem, 0, 0x08);
  //SinglePIN_ID();
  CopyScratchpadDS2431( 0 );
}


// Genera numeri random di dimensione max rangemax
unsigned int count, nrand;
unsigned short int numRandom(unsigned int rangemax)
{
  unsigned short int op1, op2;

  count++;
  op1 = (nrand ^ (nrand >> 1)) >>14;
    op2 = (nrand ^ (nrand << 2)) >> 5;
    if((op1 ^ op2) & 0x2) nrand = ((nrand<<1) | 1) ^ count;
    else                   nrand = (nrand<<1) ^ count;

    return nrand%rangemax;
}


// Salva la chiave ID criptata nella EEPROM 1 successo 0 insuccesso
int criptIdDS2431 (void)
{
  unsigned char mem[0x08],index;

  // Genero numeri pseudocasuali da mettere nella eeprom. NOTA: i valori casuali DIPENDONO dal valore dell'ID dell'iButton
  SinglePIN_ID();
  count = count + id.l[0] + id.l[1];
  nrand = 0;
  for(index = 0; index < 0x08; index++) mem[index] = numRandom(0xFF);

  SinglePIN_ID();
  if(id.b[6] != 0xFF && id.b[7] != 0xFF) saveIDcript(id, mem);
  else return 0;

  return 1;
}

// Test dell'ID, decripta e confronta, 1 successo 0 insuccesso
int checkDS2431 (void)
{
  unsigned char mem[0x08];

  SinglePIN_ID();
  if(id.b[6] != 0xFF && id.b[7] != 0xFF) {
    ReadEepromDS2431(mem, 0, 0x08);
    if(loadIDcript(id, mem)) return 1;
  }
  return 0;
}

/*
=======================================================================================================================================
  ROUTINE DEBUG TEST
=======================================================================================================================================
*/

void viewEEPROM(void)
{
  int index;
  unsigned char mem[0x08];

  //SinglePIN_ID();
  for(index = 0; index < 0x08; index++) mem[index] = 0x00;
  ReadEepromDS2431(mem, 0, 0x08);

  WaituS(100);
}

void viewScratchpad(void)
{
  int index;
  unsigned char mem[0x08];

  //SinglePIN_ID();
  for(index = 0; index < 0x08; index++) mem[index] = 0x00;
  ReadScratchpadDS2431(mem, 0, 0x08);

  WaituS(100);
}

void resetScratchpad(void)
{
  int index;
  unsigned char mem[0x08];

  //SinglePIN_ID();
  for(index = 0; index < 0x08; index++) mem[index] = 0x00;
  WriteScratchpadDS2431(mem, 0, 0x08);

  WaituS(100);
}

void resetEEPROM(void)
{
  resetScratchpad();
  //SinglePIN_ID();
  CopyScratchpadDS2431( 0 );

  WaituS(100);
}


/*
=========================================================================================================================
  CODICE PER CREARE L'ID CRIPTATO E SALVARLO SUL DS2431
=========================================================================================================================
*/
//#define PROGRAMMING 1
#ifdef PROGRAMMING
/* Controlla che la eeprom sia tutta a 0 dopo il reset
   0 fallimento
   1 successo
*/
int testEEPROM(void)
{
  int index;
  unsigned char mem[0x08];

  //SinglePIN_ID();
  ReadEepromDS2431(mem, 0, 0x08);
  for(index = 0; index < 0x08; index++) if(mem[index] != 0x00) return 0;

  return 1;
}

/*
  Inserisce la chiave criptata nel dispositivo
  1 successo
  0 fallimento
*/
int createIDprotect(void)
{
    resetEEPROM();
    if(testEEPROM()) {
      criptIdDS2431();
      if(checkDS2431()) return 1;
    }

    return 0;
}
#endif
