/***************************************************************************
 ************************						****************************
 ************************	  F A T . C	        ****************************
 ************************						****************************
 ***************************************************************************/
#define	__FAT_C

#include    <string.h>
#include    "def.h"
#include    "mmc.h"
#include    "mci.h"
#include    "fat.h"
#include    "crc16.h"
#include    "display.h"
#include    "ram.h"




#define ISFAT32()   (BTB.FATType == 0x0B || BTB.FATType == 0x0C)

#pragma pack(1)
// file system definitions
#define		FIRST_PARTITION_TABLE	0x1be
struct sIndex{
	byte	head, sector, cylinder;	// way of addressing hard disks
};

struct sPartitionTable {
	byte	Bootable;				// 0x80 bootable
	struct	sIndex	firstSector;	// first used sector
	byte	fatType;				// fat type
	struct	sIndex	lastSector;
	long	startSector;     		// first used sector of this partition
	long	nSectors;				// number of sectors for this partition
};

struct sBoot {
#if 1
    byte	jmp[3];				//  0
    byte	OEM[8];				//  3
    
    byte	bytesXsect[2];		// 11
    byte	sectXcluster;		// 13
    byte	resSectors[2];		// 14
    byte	nFats;				// 16
    byte	bRootFiles[2];		// 17 (N/A for FAT32)
    byte	sectXmedia[2];		// 19
    byte	mediaType;			// 21 hard disk
    byte	sectXfat[2];		// 22 (N/A for FAT32)
    byte	sectXtrack[2];		// 24
    byte	numHead[2];			// 26
    byte	nHiddenSectors[4];	// 28
    byte	totalSect[4];		// 32
    
    union {
        struct {
            byte	driveNumber[2];		// 36
            byte	extBoot;			// 38 =0x29
            byte	serialNumber[4];	// 39
            byte	label[11];			// 43
            byte	fileSystem[8];		// 54
            byte	bootCode[448];		// 62
        } fat16;
        
        struct {
            byte	sectXfat[4];   		// 0x24
            byte	flags[2];   		// 0x28
            byte	version[2];     	// 0x2A
            byte	clusterRoot[4];		// 0x2C
            byte	sectorFSinfo[2];	// 0x30
            byte    sectorBackup[2];    // 0x32
            byte    reserved[12];       // 0x34
            byte    logDrive;           // 0x40
            byte    unused;             // 0x41
            byte    extSignature;       // 0x42
            byte    serialNumber[4];    // 0x43
            byte    volumeName[11];     // 0x47
            byte    fatName[8];         // 0x52
            byte	bootCode[420];		// 0x5A
        } fat32;
    };
    byte	signature[2];		//510 = 0x55 0xAA
       
#else
	char	jmp[3];
	char	OEM[8];
	word	bytesxSect;
	byte	sectxCluster;
	word	resSectors;
	byte	nFats;
	word	bRootFiles;
	word	sectxMedia;
	char	mediaType;				// 0x18 hard disk
	word	sectxFAT;
	char	res3[4];
	long	nHiddenSectors;
	long	totalSect;
	byte	driveNumber;
	char	res4[1];
	byte	extBoot;				// 0x29
	long	serialNumber;
	char	label[11];
	char	fileSystem[8];
	byte	bootCode[448];
	word	signature;				// 0xAA55
#endif
};
#pragma pack()

#define	BYTE2WORD(a)	( ((( WORD)(*(a+1)))<<8) + (( WORD)(*(a+0))) )
#define	BYTE2DWORD(a)	( (((DWORD)(*(a+3)))<<24) + (((DWORD)(*(a+2)))<<16) + (((DWORD)(*(a+1)))<<8) + ((DWORD)(*(a+0))) )

#define	MAX_LUNGHEZZA_FILENAME	256

struct sBoot    *pBoot, bootSector;




/*---------------------------------------------------------------------------
 | findFile:	cerca un file nella directory principale
 |								--------------
 | In:	_nfile	numero del file da leggere
 |		_pfileName	puntatore al buffer con il nome del file da caricare
 |		_cluster	puntatore al primo cluster con i dati del file
 |		_fileLen	puntatore alla lunghezza del file
 | Out:	0		file trovato
 |		1		numero file impossibile
 |		2		numero file non presente
 |		3		file vuoto
 +-------------------------------------------------------------------------*/

byte            FAT_init( void)
{
	struct sPartitionTable *pFirstPartitionTable;

	                                    // read partition table
	if( mmcReadBlock(0L) != mmc_noerr )
    {
        DEBUG_MCI( "ERROR:READ MBR  " );
        return( mmcerr );
    }
	pBoot = ( struct sBoot *)mmcBuff;
	if ( pBoot->signature[0] != 0x55 && pBoot->signature[1] != 0xAA )
    {
#if 0
{

DWORD off;
for ( off = 0; off < 4096*1000; off += 512 )
{
	if( mmcReadBlock(off) != mmc_noerr )
    {
        DEBUG_MCI( "ERROR:READ MBR  " );
        return( mmcerr );
    }
	pBoot = ( struct sBoot *)mmcBuff;
	if ( pBoot->signature[0] == 0x55 && pBoot->signature[1] == 0xAA )
        goto ok;
    
    if ( (off%(4*512)) == 0 )
    {
    char buf[30];
    sprintf( buf, "%3d %2x %2x  ", off/512, pBoot->signature[0], pBoot->signature[1] );
    DEBUG_MCI( buf );
    }
}

}
#endif
        DEBUG_MCI( "ERROR:MBR SIGNAT" );
		return (mmcerr=mmc_err_illegal);
    }
#if 0
ok:;
#endif
	pFirstPartitionTable = ( struct sPartitionTable *)(&mmcBuff[ FIRST_PARTITION_TABLE ]);
	BTB.startAddr = SECTOR2ADDR( pFirstPartitionTable -> startSector );
	BTB.nSectors = pFirstPartitionTable -> nSectors;
	BTB.FATType = pFirstPartitionTable -> fatType;
    //                  FAT16               exFAT                   FAT16                   FAT32               FAT32 LBA
	if ( BTB.FATType != 0x04 && BTB.FATType != 0x05 && BTB.FATType != 0x06 && BTB.FATType != 0x0B && BTB.FATType != 0x0C )
    {
        DEBUG_MCI( "ERROR:INVALID PA" );
		return (mmcerr=mmc_err_unknown);// invalid partition
    }

	                                    // read boot sector
	if ( mmcReadBlock(BTB.startAddr) != mmc_noerr )
    {
        DEBUG_MCI( "ERROR:READ BOOT " );
		return mmcerr;
    }
    memcpy ( &bootSector, mmcBuff, sizeof(bootSector) );
    pBoot = &bootSector;
	if ( pBoot->signature[0] != 0x55 && pBoot->signature[1] != 0xAA )
    {
        DEBUG_MCI( "ERROR:BOOT SIGNA" );
		return (mmcerr=mmc_err_illegal);
    }
	BTB.bytesxSect = BYTE2WORD(pBoot->bytesXsect);
	BTB.sectxCluster = pBoot -> sectXcluster;
    if ( ISFAT32() )
    	BTB.sectxFAT = BYTE2DWORD(pBoot->fat32.sectXfat);
    else
    	BTB.sectxFAT = BYTE2WORD(pBoot->sectXfat);
	BTB.reserved = BYTE2WORD(pBoot->resSectors);
    BTB.rootSize = BYTE2WORD(pBoot->bRootFiles) * DIRENT_SIZE;
//	BTB.serialNumber = CID.SerialNumber;
	BTB.startFatAddr = BTB.startAddr + ADDR2SECTOR(BTB.reserved * BTB.bytesxSect);
	BTB.startRootAddr = BTB.startFatAddr + ADDR2SECTOR(pBoot->nFats * BTB.sectxFAT * BTB.bytesxSect);
	BTB.startDataAddr = BTB.startRootAddr + BTB.rootSize;
	if( BYTE2WORD(pBoot->sectXmedia) != 0 )
	{
		BTB.totalSect = BYTE2WORD(pBoot->sectXmedia);
	}
	else
	{
		BTB.totalSect = BYTE2DWORD(pBoot->totalSect);
	}
    
    if ( ISFAT32() )
    {
        BTB.startDataAddr = BTB.startRootAddr;
        BTB.rootSize = 0xFFFF;
    }

	return (mmcerr=mmc_noerr);
}                                               //  FAT_init




/*---------------------------------------------------------------------------
 | findFile:	cerca un file nella directory principale
 |								--------------
 | In:	_nfile	numero del file da leggere
 |		_pfileName	puntatore al buffer con il nome del file da caricare
 |		_cluster	puntatore al primo cluster con i dati del file
 |		_fileLen	puntatore alla lunghezza del file
 | Out:	0		file trovato
 |		1		numero file impossibile
 |		2		numero file non presente
 |		3		file vuoto
 +-------------------------------------------------------------------------*/

#define FILENAME(a)             (mmcBuff[ (a)&(BLOCK_LENGTH-1)    ])
#define FILEVALID(a)            (mmcBuff[((a)&(BLOCK_LENGTH-1))+ 0])
#define FILEATTRIB(a)           (mmcBuff[((a)&(BLOCK_LENGTH-1))+11])
#define pFILELENGTH(a)          &mmcBuff[((a)&(BLOCK_LENGTH-1))+28]
#define pSTARTCLUSTER(a)        &mmcBuff[((a)&(BLOCK_LENGTH-1))+26]

const int		posCharLongName[14] = { 1, 3, 5, 7, 9, 14, 16, 18, 20, 22, 24, 28, 30, 0xFF };

byte			FAT_getFileName( DWORD _nfile, char *_pfileName, WORD *_cluster, DWORD *_fileLen )
{
	WORD		j, k, sectorNum, sectorLoaded;
	DWORD		i, len;

	if ( _nfile == 0 || _nfile > (BTB.rootSize/DIRENT_SIZE) )
    {
        DEBUG_MCI( "ERROR:FILE NUMBE" );
		return 1;
    }

	/* search for ordinal "_nfile" file entry */
    sectorLoaded = (WORD)-1;
	i = (DWORD)-DIRENT_SIZE;
	do {
		i += DIRENT_SIZE;
		if ( i >= BTB.rootSize )
        {
            DEBUG_MCI( "ERROR:FILE NOT F" );
			return 2;					// file non trovato
        }
   
        sectorNum = (i/BLOCK_LENGTH);
        if ( sectorNum != sectorLoaded )
        {
            sectorLoaded = sectorNum;
        	if( mmcReadBlock(BTB.startRootAddr+SECTOR2ADDR(sectorNum)) != mmc_noerr )
            {
                DEBUG_MCI( "ERROR:READ ROOT " );
	        	return( mmcerr );
            }
        }

		if ( /*eratti ARCHIVE ((FILEATTRIB(i))&0x20) == 0x20 &&*/  /*eratti DIRECTORY*/ ((FILEATTRIB(i))&0x10) == 0x00 && FILEVALID(i) <= 0x7F && FILEVALID(i) >= 0x20 )
			_nfile--;
	} while( _nfile != 0 );

	len = BYTE2DWORD(pFILELENGTH(i));
	if( len == 0 )
    {
        DEBUG_MCI( "ERROR:EMPTY FILE" );
		return 3;						// file vuoto
    }

	if ( _fileLen )
		*_fileLen = len;
	if ( _cluster )
		*_cluster = BYTE2WORD(pSTARTCLUSTER(i));

	if ( _pfileName == NULL )
		return 0;

										// get filename
	memset( _pfileName, 0x00, MAX_LUNGHEZZA_FILENAME );
	if ( i == 0 || ( FILEATTRIB(i-DIRENT_SIZE)) != 0x0F )
	{											/* short filename	*/
		for ( j = 0; j < 8; j++ ) 
		{
			*_pfileName = toupper(FILENAME(i++));
			if( *_pfileName == 0x20 ) 
			{
				i += (8-j-1);
				break;
			}
			_pfileName++;								/* or get 8 characters	*/
		}
		*_pfileName++ = '.';
		for ( j = 0; j < 3; j++ ) 
		{
			*_pfileName = toupper(FILENAME(i++));
			if( *_pfileName == 0x20 ) 
				break;
			_pfileName++;								/* or get 8 characters	*/
		}
		*_pfileName = 0x00;
	}
	else 
	{
		j = 0; k = 0;							/* long filename	*/
		i -= DIRENT_SIZE;
		while(  FILEATTRIB(i) == 0x0F && j < MAX_LUNGHEZZA_FILENAME ) {
			do {
				*_pfileName = toupper(FILENAME( i+posCharLongName[k] ));
				if( *_pfileName == 0x00 )
					return 0;

				_pfileName++;
				k++; 
				j++;
			} while( posCharLongName[k] != 0xFF  );
			i -= DIRENT_SIZE;
			k = 0;
		}
	}

	return 0;
}												//	FAT_getFileName




/*---------------------------------------------------------------------------
 | FAT_cluster:	legge il numero del cluster della FAT corrisponde al cluster 
 |				passato
 |								--------------
 | In:	_cluster	puntatore al primo cluster con i dati del file
 | Out:	WORD	numero del cluster letto nella FAT
 +-------------------------------------------------------------------------*/

#define INVALID_SECTOR  0

DWORD           FAT_sectorAddress( DWORD _sectorNumber )
{
    return (_sectorNumber-2) * pBoot->sectXcluster;
}

BOOL			FAT_readSector( DWORD sectorNumber, byte *pSectorBuff )
{
    if ( mmcReadBlock(BTB.startDataAddr+SECTOR2ADDR(sectorNumber)) != mmc_noerr )
        return FALSE;
    if ( pSectorBuff != NULL )
        memcpy( pSectorBuff, mmcBuff, SECTOR_SIZE );
	return TRUE;
}												//	FAT_readSector

WORD			FAT_cluster( WORD _cluster )
{
    if ( ISFAT32() )
    {
        if ( mmcReadBlock( BTB.startFatAddr + SECTOR2ADDR((_cluster/(SECTOR_SIZE/sizeof(DWORD)))) ) != mmc_noerr )
        {
    //		EdbgOutputDebugString( "ERROR: FAT_sector: can't read FAT sector 0x%x\r\n", fatStartAddress+(_cluster/(SECTOR_SIZE/sizeof(WORD))) );
            return 0;
        }
    
        return BYTE2DWORD(&mmcBuff[sizeof(DWORD)*(_cluster%(SECTOR_SIZE/sizeof(DWORD)))]);
    }
    else
    {
        if ( mmcReadBlock( BTB.startFatAddr + SECTOR2ADDR((_cluster/(SECTOR_SIZE/sizeof(WORD)))) ) != mmc_noerr )
        {
    //		EdbgOutputDebugString( "ERROR: FAT_sector: can't read FAT sector 0x%x\r\n", fatStartAddress+(_cluster/(SECTOR_SIZE/sizeof(WORD))) );
            return 0;
        }
    
        return BYTE2WORD(&mmcBuff[sizeof(WORD)*(_cluster%(SECTOR_SIZE/sizeof(WORD)))]);
    }
}												//	FAT_cluster




/*---------------------------------------------------------------------------
 | FMD_ReadFATsector: legge un settore nel disco flash gestito come FAT 
 |								--------------
 | In:	sectorNumber	numero del settore da leggere
 |		pSectorBuff		puntatore al buffer dove porre i dati letti dal settore
 |		pSectorInfoBuff	puntatore al buffer dove porre i dati con le informazioni
 | Out:	TRUE	lettura effettuata correttamente
 |		FALSE	errore nella lettura 
 +-------------------------------------------------------------------------*/

byte			FAT_readFile( byte *_buf, WORD _firstCluster, DWORD *_fileLen )
{
  	DWORD		i, sector, totalSector;
	WORD		cluster;

    totalSector = ((*_fileLen+SECTOR_SIZE-1)/SECTOR_SIZE);
    cluster = _firstCluster;
//    EdbgOutputDebugString( "readFile: findFile %s len=%d firstCluster=%x totalSector=%x\r\n", fileName, *_fileLen, firstCluster, totalSector );
    do {
        if ( (cluster >= 0x0002 && cluster <= 0xFFEF) ||
             (cluster >= 0xFFF8 && cluster <= 0xFFFF) )
        {
            sector = FAT_sectorAddress(cluster);
            for ( i = 0; i < pBoot->sectXcluster && totalSector > 0; i++, totalSector-- )
            {
                if ( _buf != NULL )
                {
                    if ( !FAT_readSector(sector+i,_buf) )
                    {
//                        EdbgOutputDebugString("ERROR: readFile: can't read data sector\r\n");
                        return 8;
                    }
                }
            }
        }
        else
        {
//            EdbgOutputDebugString("ERROR: readFile: can't read cluster %x\r\n", cluster);
        }
        cluster = FAT_cluster(cluster);
    } while ( cluster < 0xFFF8 && totalSector > 0 );
    
    return 0;
}




/*---------------------------------------------------------------------------
 | FAT_openFile:open file for reading
 |								--------------
 | In:	
 | Out:
 +-------------------------------------------------------------------------*/

DWORD           fileTotalSector, fileCluster, fileSector;
DWORD           fileLength, filePointer, fileRead;

byte			FAT_openFile( WORD _firstCluster, DWORD _fileLen )
{
    fileTotalSector = ((_fileLen+SECTOR_SIZE-1)/SECTOR_SIZE);
    fileCluster = _firstCluster;
    fileLength = _fileLen;
    filePointer = 0;
    fileRead = 0;
    fileSector = 0;

    return 0;
}




/*---------------------------------------------------------------------------
 | FAT_getchFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte			FAT_getchFile( byte *_buf )
{
  	DWORD		sector;


    do {
        if ( filePointer >= fileLength )
            return 1;
        if ( filePointer < fileRead )
        {
            *_buf = mmcBuff[(filePointer++)&(BLOCK_LENGTH-1)];
            return 0;
        }

        if ( fileSector >= pBoot->sectXcluster )
        {
            fileSector = 0;
            fileCluster = FAT_cluster(fileCluster);
            if ( fileCluster >= 0xFFF8 )
                return 1;
        }
        
        if ( (fileCluster >= 0x0002 && fileCluster <= 0xFFEF) ||
             (fileCluster >= 0xFFF8 && fileCluster <= 0xFFFF) )
        {
            sector = FAT_sectorAddress(fileCluster);
            if ( !FAT_readSector(sector+fileSector,NULL) )
            {                   // ERROR: readFile: can't read data sector
                return 2;
            }
            fileSector++;
            fileRead += BLOCK_LENGTH;
        }

    } while ( fileCluster < 0xFFF8 );

    return 3;
}




/*---------------------------------------------------------------------------
 | FAT_getsFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte		    FAT_getsFile( byte *_buf, byte *_len )
{
	byte        i, dato;

    i = 0;
    *_buf = '\0';
    do {
        if ( FAT_getchFile(&dato) != 0 )
        {
            if ( i == 0 )
                return 1;
            *_len = i;
            return 0;
        }
#ifdef BOOT2
        if(dato != 0x0D)
        {
            *_buf++ = dato;
            *_buf = '\0';
        }
#else    
        *_buf++ = dato;
        *_buf = '\0';
#endif                
        i++;
        if ( i >= *_len )
            break;
#ifdef BOOT2
    } while( dato != 0x0A );
#else        
    } while( dato >= ' ' );              // till cr/lf
#endif    
    *_buf = '\0';
    *_len = i;
    return 0;
}                                               //  FAT_getsFile




/*---------------------------------------------------------------------------
 | dosfs_getchFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte			dosfs_getchFile( PFILEINFO _fileinfo, uint32_t *_pos, uint8_t *_scratch, uint8_t *_buf )
{
    byte        i, buffer[SECTOR_SIZE];
    uint32_t    successcount;
    
    for ( i = 0; i < 3; i++ ) 
    {
        if ( *_pos < _fileinfo->pointer )
        {
            *_buf = _scratch[(*_pos)&(SECTOR_SIZE-1)];
            *_pos += 1;
            return 0;
        }

        if ( _fileinfo->pointer >= _fileinfo->filelen )
            return 1;

        DFS_ReadFile( _fileinfo, buffer, _scratch, &successcount, SECTOR_SIZE );
    }

    return 3;
}                                               //  dosfs_getchFile




/*---------------------------------------------------------------------------
 | dosfs_getsFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte		    dosfs_getsFile( PFILEINFO _fileinfo, uint32_t *_pos, uint8_t *_scratch, uint8_t *_buf, uint32_t *_len )
{
	byte        i, dato;

    i = 0;
    *_buf = '\0';
    do {
        if ( dosfs_getchFile( _fileinfo, _pos, _scratch, &dato ) != 0 )
        {
            if ( i == 0 )
                return 1;
            *_len = i;
            return 0;
        }
        if ( dato == 0x0A && i == 0 ) 
        {
            dato = ' ';// per evitare che esca dal loop
            continue;
        }
        *_buf++ = dato;
        *_buf = '\0';
        i++;
        if ( i >= *_len )
            break;
    } while( dato >= ' ' );              // till cr/lf
    *_buf = '\0';
    *_len = i;
    return 0;
}                                               //  dosfs_getsFile




/*---------------------------------------------------------------------------
 | dosfs_getbFile:
 |								--------------
 | In:	
 | Out: byte    0   byte read
 |              1   EOF
 |              2   end of sector
 +-------------------------------------------------------------------------*/

byte		    dosfs_getbFile( PFILEINFO _fileinfo, uint32_t *_pos, uint8_t *_scratch, uint8_t *_buf, uint32_t *_len )
{
	byte        dato;
    word        i;

    i = 0;
    *_buf = '\0';
    do {
        if ( dosfs_getchFile( _fileinfo, _pos, _scratch, &dato ) != 0 )
        {
            if ( i == 0 )
                return 1;
            *_len = i;
            return 0;
        }
        *_buf++ = dato;
        i++;
    } while( i < *_len );
    *_len = i;
    return 0;
}                                               //  dosfs_getbFile




/*---------------------------------------------------------------------------
 | dosfs_findFile:
 |								--------------
 | In:	
 | Out: byte    0   file found
 |              1   no MMC/SD
 |              2   no partition
 |              3   no volume
 |              4   no file
 +-------------------------------------------------------------------------*/

byte            dosfs_findFile( uint8_t *_path )
{
	uint32_t    pstart, psize;
	uint8_t     pactive, ptype;
	VOLINFO     vi;
	FILEINFO    fi;

    if ( mmcInit() != mmc_noerr )
        return 1;

	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if ( pstart == 0xffffffff )
        return 2;
	if ( DFS_GetVolInfo(0, sector, pstart, &vi) )
        return 3;
	if ( DFS_OpenFile(&vi, _path, DFS_READ, sector, &fi) == 0 )
        return 0;
    
    return 4;
}
