/******************************************************************************
hwinit.h
init hw scheda
*******************************************************************************/

#ifndef __HWINIT_H
#define __HWINIT_H




#include    "def.h"

/*--------------------------------------------------------------------------
 | InitPLL:     inizializzazione PLL
 +--------------------------------------------------------------------------*/

#define PLL_MValue	       11
#define PLL_NValue		0
#define CCLKDivValue		5

/* System configuration: Fosc, Fcclk, Fcco, Fpclk must be defined */
/* PLL input Crystal frequence range 4KHz~20MHz. */
#define Fosc	 12000000
/* System frequence,should be less than 80MHz. */
#define Fcco	(2*Fosc*(PLL_MValue+1))/(PLL_NValue+1)  //288000000
#define Fcclk	Fcco/(CCLKDivValue+1)                   // 48000000



#define SYSTEMFREQ  Fcclk               // frequenza desiderata
#define VPB_DIVIDER 4                   // divisore di frequenza
#define PERIFREQ    (SYSTEMFREQ/VPB_DIVIDER)    // frequenza periferiche

#define	TIMER_CLOCK SYSTEMFREQ/VPB_DIVIDER   // timer clock
#define	T_PERIODIC  1000
#define F_PWM       4000

#ifdef __WIN32__

byte            fallSensor( void );
int             doorOpen( void );
int             MenuSwitch( void );


#define OE_OUT_DISABLE()
#define OE_OUT_ENABLE()
#define LATCH_OUT_SET()
#define LATCH_OUT_CLR()
#define LOAD_SR()

#define INP0                0
#define INP2                1

#define PWR_EN_ON()
#define PWR_EN_OFF()
#define IS_PWR_OFF()        1

#define FALL_SENSOR         fallSensor()

#define DISK_LED_ON()
#define DISK_LED_OFF()

#else

#define OE_OUT_DISABLE()    IO0SET = BIT5
#define OE_OUT_ENABLE()     IO0CLR = BIT5
#define LATCH_OUT_SET()     IO0SET = BIT4
#define LATCH_OUT_CLR()     IO0CLR = BIT4
#define LOAD_SR()           IO1CLR = BIT22;IO1SET = BIT22

#define SETRTS_MAXSTREAM()  IO0SET = BIT17
#define CLRRTS_MAXSTREAM()  IO0CLR = BIT17
#define CTS_MAXSTREAM()     ((IO0PIN & BIT18)!=0x00)

#define INP0                IO1PIN_bit.P1_18
#define INP2                IO1PIN_bit.P1_19//((machineType==MACHINA_NAT145)?(INP0):(IO1PIN_bit.P1_19))

#ifndef BOOT
#define PWR_EN_ON()         IO0SET = BIT6
#else //BOOT
#define PWR_EN_ON()         IO0CLR = BIT6
#endif //BOOT
#define PWR_EN_OFF()        IO0CLR = BIT6
#define IS_PWR_OFF()        ((IO0PIN & BIT6)==0x00)

#define FALL_SENSOR         ( (machineType == MACHINA_NAT157 ||  \
                               machineType == MACHINA_AP123 ||   \
                               machineType == MACHINA_VEIDOOR || \
                               machineType == MACHINA_AMS39 ||   \
                               machineType == MACHINA_VEI147 ||  \
                               machineType == MACHINA_USIGVC2 || \
                               machineType == MACHINA_MERCHA6 || \
                               machineType == MACHINA_VEILCM ) ? (inImage[2]&0x01) : (inImage[3]&0x80) )

#define SPI0_CLK_LOW()                  IO1CLR = BIT20
#define SPI0_CLK_HIGH()                 IO1SET = BIT20
#define SPI0_MOSI_LOW()                 IO1CLR = BIT24
#define SPI0_MOSI_HIGH()                IO1SET = BIT24
#define SPI0_MISO()                     ((IO1PIN & BIT23)!=0x00)
#define SPI0_SCL1()                     IO0PIN & BIT1

//#define DISK_LED_ON()                   {IO1SET_bit.P1_25 = 1;IO1CLR_bit.P1_26 = 1;}
//#define DISK_LED_OFF()                  {IO1SET_bit.P1_25 = 1;IO1SET_bit.P1_26 = 1;}

#define PROX_SENSOR()   ((IO1PIN & BIT27)!=0)

#endif



typedef enum {
    BOOT_LOADER = 0,
    USER_FLASH,
    USER_RAM
} INITPLL_INT_LOADER;




void            HardwareInit( void );
void            InitPLL( void );
void            InitIOPorts( void );
void            InitInterrupt( void );
void            InitPwmTimer( void );
void            initSPI0( void );
void            sendSPI0( byte *_ptr, byte _len );
void            recvSPI0( byte *_ptr, byte _len );
void            initSSP0( void );
word            sendSSP0( byte *_ptr, word _len );
word            sendRecvSSP0( byte *_ptrW, byte *_ptrR, word _len );
word            recvSSP0( byte *_ptr, word _len );
void            flushSSP0( void );
void            sendDate( _dateTime *_dateTime );
byte            recvDate( _dateTime *_dateTime );
byte            WriteFlash256( void *buf, dword _address, word _size );
byte            EraseBlock( dword _address, byte _num );
DWORD           testTimeOff( void );
void            rsr903c_detection( void );
        



#endif
