/* keyadc.c */

#include    <string.h>
#include    "def.H"
#include    "keyadc.h"
#include    "ram.h"




// oltre a inizializzare le variabili
// rileva la presenza delle tastiere collegate
// 0x01 tastiera onboard presente
// 0x02 espansione tastiera
// 0x03 tutte e due le tastiere
void            initSPI1( void )
{
}                                               //  initSPI1

// tx data usata in int ogni ms
void            sendSPI1( word *_ptr, byte _len )
{
#ifndef __WIN32__
    SSP1CPSR = 2;

    SSP1CR0 =  0x0307;                  // 0000001100000111
                                        // 00000011          SCR  = 4
                                        //         0         CPHA        =====x==
                                        //          0        CPOL        __|--|__
                                        //           00      FRF  spi
                                        //             0111  DSS 8 bit
    SSP1CR1 =  0x02;                    // 00000010
                                        // 0000       -
                                        //     0      SOD
                                        //      0     master
                                        //       1    ssp enabled
                                        //        0   no loop


    while ( _len-- > 0 )
        SSP1DR = *_ptr++;
#endif
}                                               //  StartTx

// rx data usata in int ogni ms
void ReadRx(unsigned int *rxPtr, unsigned char nRx)
{
#ifndef __WIN32__
    unsigned int temp;

    for( ;SSP1SR_bit.RNE != 0 && nRx != 0; ){
        nRx--;
        temp = SSP1DR;
        *(rxPtr + nRx) = temp;
    }
    clearSPI1();  // svuota FIFO rx
#endif
}




// pulisce FIFO in rx
void            clearSPI1( void )
{
#ifndef __WIN32__
    unsigned int dummy;

    while( SSP1SR_bit.RNE != 0 )
        dummy = SSP1DR;  // svuota FIFO rx
    dummy = dummy;
#endif
}                                               //  clearSPI0




// lettura primo bit della tastiera
unsigned char ReadMISOStatus(void)
{
  unsigned char temp;

#ifndef __WIN32__
  IO0DIR_bit.P0_18  = 0;  // pin input
  PINSEL1_bit.P0_18 = 0;  // pin sganciato da SPI
  temp = IO0PIN_bit.P0_18;     // status pin
  PINSEL1_bit.P0_18 = 2;  // pin riagganciato a SPI
#else
    temp = 0;
#endif
  return(temp);
}




/*--------------------------------------------------------------------------
 | AdcCpuInit:  inizializza convertitore analogico/digitale
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

word            iADC, nADC;
dword           totADC;
word            sampADC[64], medADC;

void            AdcCpuInit( void )
{
#ifndef __WIN32__
    AD0CR = 0x01200F04;
                                        // 00000     -
                                        //      000  start conversion
                                        // 00100000
                                        // 00        -
                                        //   1       AD on
                                        //    0      -
                                        //     000   11ck /10 bit
                                        //        1  burst
                                        // 00001111  clock / 15 = 4MHz
                                        // 00000111  canali ADC
    iADC = 0;
    nADC = 0;
    totADC = 0;
    medADC = 0;
    memset( sampADC, 0, sizeof(sampADC) );
#endif
}                                               //  AdcCpuInit




/***************************************************************************
 ADend:			fine conversione A/D, commuta sugli altri ingressi
                all'interno dell'int da 1ms
								--------------
 In:
 Out:
 ***************************/

byte            ADend( void )
{
#ifndef __WIN32__
    totADC -= sampADC[iADC];
    sampADC[iADC] = ((ADDR2 & 0x0000FFC0) >> 6);
    totADC += sampADC[iADC];
    if ( iADC >= 15/*31*/ )
        iADC = 0;
    else
    {
        iADC++;
        if ( nADC < iADC )
            nADC = iADC+1;
    }
    AD.conv[AD_2] = totADC/nADC;

#endif

    return 0;
}	                                            //  ADend
