/******************************************************************************
lcd.h
init 2 vetri e modulo lcd
*******************************************************************************/

#ifndef LCD_H

#define LCD_H

enum _POSCIFRE{
             PESO = 0,
             PREZZO,
             TARA,
             IMPORTO
              };

#define OPERATORE 1
#define CLIENTE 2
#define TUTTI 3

#define LCD_PESO        4
#define LCD_PREZZO      9
#define LCD_TARA       13
#define LCD_IMPORTO    19

#define SPY_ZERO        3
#define SPY_PT          4
#define SPY_NET         0
#define SPY_FIXT        9
#define SPY_FIXP        8
#define SPY_BAT         5
#define SPY_NETW        13

#define FIELD_WEIGHT           0
#define FIELD_PRICE_           1
#define FIELD_TARE__           2
#define FIELD_AMOUNT           3
#define FIELD_WEIGHT_NDIGIT    5
#define FIELD_PRICE__NDIGIT    5
#define FIELD_TARE___NDIGIT    4
#define FIELD_AMOUNT_NDIGIT    6

typedef struct _fieldVal_ {
	byte	    rout;
#define ROUT_MULMIN 0x04
#define ROUT_CLEAR  0x01
	byte	    nDec;
}_fieldVal;

extern void LcdErase(unsigned char unit);

extern void contrastInit(void);
void            setContrastLCD( byte _contrast );

extern unsigned char WriteI2c0(unsigned char *bufferPtr, unsigned char nData);
extern unsigned char ReadI2c0(unsigned char *bufferPtr, unsigned char nData);
extern void displayLCD( void );
extern void LcdIIC0Init(void);
extern void I2C_ISR(void);
extern void TestLCD(void);
extern void TestOra(void);
extern void LcdClrScr(unsigned char unit);


#endif
