extern unsigned char   doorCount;
int evento_just_reset;
/*--------------------------------------------------------------------------
 |  main.c
 +--------------------------------------------------------------------------*/
//
// codifica -> LITTLE ENDIAN
// char  1 byte
// short 2 byte
// int 4 byte
// long 4 byte
//risorse impiegate:
//timer0 ->  T0MR2 azzeramento buzzer e timer 1ms
//timer1 ->  T1MR1 fasi motore stampante
//           T1MR0 strobe testina
//I2C0 -> display operatore + cliente, orologio
//PWM2 -> contrasto display custom LCD
//SPI0 -> testina di stampa
//SPI1 -> AD converter
//Aout -> contrasto modulo LCD
//
// simboli: xxx aggiungere parte di programma
//
// tempi misurati -> preparazione blocco 4k o 32k 50us
//                   cancellazione blocco 4k o 32k 400ms
//                   programmazione blocco 256 @4k o 32k 1,26m
//                   programmazione blocco 4096 @4k o 32k 18m4
//
#define __MAIN_C

#define TEST_ADC_KEYBOARD   0


/////////////////////////////////////////////////////////////////////////////
//#define TEST                          // base         // tastiera-display
#define BOARD_ROWE6800      0           // RSR676
#define BOARD_ROWE5900      0           // RSR675
#define BOARD_NAT147        0           // RSR642           RSR644
#define BOARD_AP113         0           // RSR654           RSR655
#define BOARD_NAT157        0           // RSR714           RSR718
#define BOARD_AP7000        0           // RSR715           RSR723
#define BOARD_LCM123        0           // RSR762
#define BOARD_AP123         0           // RSR765           RSR767
#define BOARD_VEIDOOR       0           // RSR765           RSR767
#define BOARD_NAT145        0           // RSR642           RSR644
#define BOARD_AMS39         0           // RSR857           RSR...
#define BOARD_VEI147        0           // RSR714           RSR718
#define BOARD_USIGVC2       1           // RSR885
/////////////////////////////////////////////////////////////////////////////


#include  "def.h"
#include  <ctype.h>
#include  <stdio.h>
#include  <string.h>
#define ALLOCA_MEMORIA
#include "ram.h"
#include "hwinit.h"
#include "DISPLAY.H"
#include "crc16.h"
#include "fat.h"
#include "funzioni.h"
#include "graphics.h"
#include "lcd7seg.h"
#include "main.h"
#include "timer.h"
#include "keyboard.h"
#include "messaggi.h"
#include "menu.h"
#include "modem.h"
#include "optical.h"
#include "uart.h"
#include "ram.h"
#include "inizial.h"
#include "english.h"
#include "espana.h"
#include "event.h"
#include "ds2341.h"
#include "dex.h"
#include "mmc.h"
#include "test.h"
#include "zigbee.h"
//dosfs
#include "dosfs.h"
#include "temperatura.h"
//	uint8_t     sector[SECTOR_SIZE], fileName[SECTOR_SIZE];
//dosfs
byte            testIfMotorAvailable( byte _k, byte _an );
#ifdef  __WIN32__
#include  <io.h>
void            activateMotor( byte _tray, byte _column );
void            deactivateMotor( void );
#else  //__WIN32__
void            activateMotor( byte _tray, byte _column ) 
{
#if HOME_DEBUG//22=activate motor
                commPutChar( COMM1, 0x22 );
                commPutChar( COMM1, ((_tray&0x0f)<<4)|(_column&0x0f) );
#endif
}
void            deactivateMotor( void ) {}
#endif //__WIN32__
#ifdef BOOT
#define         enCOUPLING(a)   1
#endif
#if LED_DIMMING
DWORD           tLED1, dutyLED1;
DWORD           tLED2, dutyLED2;
DWORD           maskLED, dimmedLED;
#endif
#if ENABLE_DISCOUNT
byte            discount_doorClose( void );
void            discount_reload( byte _mode );
void            discount( _Credito *tot, byte s_tray, byte s_column );
void            discount_count( byte s_tray, byte s_column );
extern unsigned short  sels[MAXTRAY][MAXCOLUMN];
#endif
extern struct S_SelectionData SelectionData;
extern byte     K_SX, K_DX, K_UP, K_DW, K_ESC, K_OK;

byte            show_temp = 0;
extern struct S_SelectionData SelectionData;
void  displayTempFail( char *buf );

//EEE
struct S_SETUP {
  byte  Feature_Level;
  unsigned short Country_Currency_Code;
  byte  Scaling_Factor;
  byte  Decimal_Places;
  unsigned short Coin_Type_Routing;
  unsigned short Coin_Type_Credit[16];
};

struct S_TUBE_STATUS {
  unsigned short Tube_Full_Status;
  unsigned char  Tube_Status[16];
  unsigned char  Escrow_Status[16];
};

struct S_COIN_STATUS {
  unsigned short Coin_Enable;
  unsigned short Manual_Dispense_Enable;
};

struct S_LEVEL_THREE_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  unsigned short Software_Version;
  union {
    char  Optional_Features[4];
    struct {  // tengo conto dell'endianess, [0] e' LSB, [3] e' MSB
      unsigned long unusedH:24 ;
      unsigned long payout:1 ;
      unsigned long extended_diagnostic:1 ;
      unsigned long manual_fill:1 ;
      unsigned long FTL:1 ;
      unsigned long unusedL:4 ;
    }Options;
  };
};
extern struct S_CHANGE {
  struct S_SETUP Setup;
  struct S_TUBE_STATUS TubeStatus;
  struct S_COIN_STATUS CoinStatus;
  struct S_LEVEL_THREE_CAPABILITIES LevelTreeCapabilities;
} Change;
//EEE

#define N_K_ROWE    8
#define N_K_USI     7
#define N_K_AP113   10//EEE 16
#define N_K_LCM123  10//EEE 
#define N_K_AMS39   N_K_AP113
#define N_K_NAT147  16

#define N_AN_ROWE   10
#define N_AN_USI    10
#define N_AN_LCM123 10
#define N_AN_AMS39  10
#define N_AN_AP113  8
#define N_AN_NAT147 5

#define T_MAX_MOTOR 4000                // maximum timing for motor homing
#define T_MIN_MOTOR 1000                // minimum timing for motor off home

#if PRODUCT_RECOGNITION
int showImage=0;
const char *prodRecogName[] = {
  "H1",//"DORITOSRED",//H1
  "H2",//"FRITOS",//H2
  "H3",//"PIZZARIAS",   //H3
  "H4",//"RUFFLES",  //H4
  "H5",//
  "H6",//
  "H7",//
  "H8",//
  "H9",//
  "H10",//
};
int prodRecogNum[10] = {
  1,
  1,
  2,
  3,
  4,
  1,
  1,
  2,
  3,
  4
};
int procRecogTray, procRecogCol;
void            newProdName( char *_str )
{
    int n;
    for ( n = 0; n < 10; n++ )
    {
        if ( strcmp(prodRecogName[n],_str) == 0 )
        {
            amount[0][procRecogCol] = amount['H'-'A'][n+1];
            prodRecogNum[procRecogCol] = n+1;
            lpdRecalc();
            showImage=1+prodRecogNum[procRecogCol];
            return;
        }
    }
}
#endif

const struct {
    DWORD       tTimeout;
} tMaxMotor[TOTAL_MACHINE] =
{
    5000,   //AP113
    4000,   //NAT147
    4000,   //ROWE 5900
    4000,   //ROWE 6800
    4000,   //NAT157
    5000,   //AP7000
    5000,   //LCM123
    5000,   //AP123
    5000,   //VEIDOOR
    4000,   //NAT145
    4000,   //AMS39  -- da verificare
    4000,   //VEI147
    4000,   //USIGVC2  -- da verificare
};

const struct {
    byte r_k, r_an;
} abilRemap[TOTAL_MACHINE+1][MAXTRAY][MAXCOLUMN] =
{
    {//AP113
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 9,0},{ 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0}    },
    {    /*B*/   { 9,1},{ 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1}    },
    {    /*C*/   { 9,2},{ 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2}    },
    {    /*D*/   { 9,3},{ 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3}    },
    {    /*E*/   { 9,4},{ 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4}    },
    {    /*F*/   { 9,5},{ 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5}    },
    {    /*G*/   { 9,6},{ 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6}    },
    {    /*H*/   { 9,7},{ 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7}    },
    {    /*I*/   { 9,8},{ 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//NAT147
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 4,4},{ 5,4},{ 4,3},{ 5,3},{ 4,2},{ 5,2},{ 4,1},{ 5,1},{ 4,0},{ 5,0}    },
    {    /*B*/   { 6,4},{ 7,4},{ 6,3},{ 7,3},{ 6,2},{ 7,2},{ 6,1},{ 7,1},{ 6,0},{ 7,0}    },
    {    /*C*/   { 8,4},{ 9,4},{ 8,3},{ 9,3},{ 8,2},{ 9,2},{ 8,1},{ 9,1},{ 8,0},{ 9,0}    },
    {    /*D*/   {10,4},{11,4},{10,3},{11,3},{10,2},{11,2},{10,1},{11,1},{10,0},{11,0}    },
    {    /*E*/   {12,4},{13,4},{12,3},{13,3},{12,2},{13,2},{12,1},{13,1},{12,0},{13,0}    },
    {    /*F*/   {14,4},{15,4},{14,3},{15,3},{14,2},{15,2},{14,1},{15,1},{14,0},{15,0}    },
    {    /*G*/   { 2,4},{ 3,4},{ 2,3},{ 3,3},{ 2,2},{ 3,2},{ 2,1},{ 3,1},{ 2,0},{ 3,0}    },
    {    /*H*/   { 1,4},{ 0,4},{ 1,3},{ 0,3},{ 1,2},{ 0,2},{ 1,1},{ 0,1},{ 1,0},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

//    {//ROWE 5900 675A
//                  0      1      2      3      4      5      6      7      8      9
//    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
//    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,9},{ 0,8},{ 0,6},{ 0,7}    },
//    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,9},{ 1,8},{ 1,6},{ 1,7}    },
//    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,9},{ 2,8},{ 2,6},{ 2,7}    },
//    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,9},{ 3,8},{ 3,6},{ 3,7}    },
//    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
//    {    /*6*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,9},{ 4,8},{ 4,6},{ 4,7}    },
//    {    /*7*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,9},{ 5,8},{ 5,6},{ 5,7}    },
//    {    /*8*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,9},{ 6,8},{ 6,6},{ 6,7}    },
//    {    /*9*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,9},{ 7,8},{ 7,6},{ 7,7}    }
//    },

    {//ROWE 5900 675B
//                  0      1      2      3      4      5      6      7      8      9
    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*1*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,9},{ 7,8},{ 7,6},{ 7,7}    },
    {    /*2*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,9},{ 6,8},{ 6,6},{ 6,7}    },
    {    /*3*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,9},{ 5,8},{ 5,6},{ 5,7}    },
    {    /*4*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,9},{ 4,8},{ 4,6},{ 4,7}    },
    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*6*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,9},{ 3,8},{ 3,6},{ 3,7}    },
    {    /*7*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,9},{ 2,8},{ 2,6},{ 2,7}    },
    {    /*8*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,9},{ 1,8},{ 1,6},{ 1,7}    },
    {    /*9*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,9},{ 0,8},{ 0,6},{ 0,7}    }
    },

    {//ROWE 6800
//                  0      1      2      3      4      5      6      7      8      9
    {    /*0*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*1*/   { 0,7},{ 0,0},{ 0,2},{ 0,9},{ 0,8},{ 0,5},{ 0,4},{ 0,3},{ 0,1},{ 0,6}    },
    {    /*2*/   { 1,7},{ 1,0},{ 1,2},{ 1,9},{ 1,8},{ 1,5},{ 1,4},{ 1,3},{ 1,1},{ 1,6}    },
    {    /*3*/   { 2,7},{ 2,0},{ 2,2},{ 2,9},{ 2,8},{ 2,5},{ 2,4},{ 2,3},{ 2,1},{ 2,6}    },
    {    /*4*/   { 3,7},{ 3,0},{ 3,2},{ 3,9},{ 3,8},{ 3,5},{ 3,4},{ 3,3},{ 3,1},{ 3,6}    },
    {    /*5*/   { 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9},{ 9,9}    },
    {    /*6*/   { 4,7},{ 4,0},{ 4,2},{ 4,9},{ 4,8},{ 4,5},{ 4,4},{ 4,3},{ 4,1},{ 4,6}    },
    {    /*7*/   { 5,7},{ 5,0},{ 5,2},{ 5,9},{ 5,8},{ 5,5},{ 5,4},{ 5,3},{ 5,1},{ 5,6}    },
    {    /*8*/   { 6,7},{ 6,0},{ 6,2},{ 6,9},{ 6,8},{ 6,5},{ 6,4},{ 6,3},{ 6,1},{ 6,6}    },
    {    /*9*/   { 7,7},{ 7,0},{ 7,2},{ 7,9},{ 7,8},{ 7,5},{ 7,4},{ 7,3},{ 7,1},{ 7,6}    }
    },

    {//NAT157
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,0},{ 5,1},{ 4,1},{ 5,2},{ 4,2},{ 5,3},{ 4,3},{ 5,4},{ 4,4}    },
    {    /*B*/   { 3,0},{ 2,0},{ 3,1},{ 2,1},{ 3,2},{ 2,2},{ 3,3},{ 2,3},{ 3,4},{ 2,4}    },
    {    /*C*/   { 1,0},{ 0,0},{ 1,1},{ 0,1},{ 1,2},{ 0,2},{ 1,3},{ 0,3},{ 1,4},{ 0,4}    },
    {    /*D*/   { 6,0},{ 7,0},{ 6,1},{ 7,1},{ 6,2},{ 7,2},{ 6,3},{ 7,3},{ 6,4},{ 7,4}    },
    {    /*E*/   { 8,0},{ 9,0},{ 8,1},{ 9,1},{ 8,2},{ 9,2},{ 8,3},{ 9,3},{ 8,4},{ 9,4}    },
    {    /*F*/   {10,0},{11,0},{10,1},{11,1},{10,2},{11,2},{10,3},{11,3},{10,4},{11,4}    },
    {    /*G*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*H*/   {12,0},{12,1},{12,2},{12,3},{12,4},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*J*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//AP7000
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   {7, 4},{9, 4},{4, 4},{3, 4},{2, 4},{1, 4},{6, 4},{0, 4},{8, 4},{5, 4}    },
    {    /*B*/   {7, 5},{9, 5},{4, 5},{3, 5},{2, 5},{1, 5},{6, 5},{0, 5},{8, 5},{5, 5}    },
    {    /*C*/   {7, 2},{9, 2},{4, 2},{3, 2},{2, 2},{1, 2},{6, 2},{0, 2},{8, 2},{5, 2}    },
    {    /*D*/   {7, 3},{9, 3},{4, 3},{3, 3},{2, 3},{1, 3},{6, 3},{0, 3},{8, 3},{5, 3}    },
    {    /*E*/   {7, 6},{9, 6},{4, 6},{3, 6},{2, 6},{1, 6},{6, 6},{0, 6},{8, 6},{5, 6}    },
    {    /*F*/   {7, 0},{9, 0},{4, 0},{3, 0},{2, 0},{1, 0},{6, 0},{0, 0},{8, 0},{5, 0}    },
    {    /*G*/   {7, 1},{9, 1},{4, 1},{3, 1},{2, 1},{1, 1},{6, 1},{0, 1},{8, 1},{5, 1}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//LCM123
//                  0      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 9,0},{ 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0}    },
    {    /*B*/   { 9,1},{ 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1}    },
    {    /*C*/   { 9,2},{ 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2}    },
    {    /*D*/   { 9,3},{ 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3}    },
    {    /*E*/   { 9,4},{ 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4}    },
    {    /*F*/   { 9,5},{ 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5}    },
    {    /*G*/   { 9,6},{ 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6}    },
    {    /*H*/   { 9,7},{ 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7}    },
    {    /*I*/   { 9,8},{ 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//AP123
//                  0      1      2      3      4      5      6      7      8      9
    {/*1*//*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {/*1*//*2*/  { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1},{ 9,1}    },
    {/*1*//*3*/  { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2},{ 9,2}    },
    {/*1*//*4*/  { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3},{ 9,3}    },
    {/*1*//*5*/  { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4},{ 9,4}    },
    {/*1*//*6*/  { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5},{ 9,5}    },
    {/*1*//*7*/  { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6},{ 9,6}    },
    {/*1*//*8*/  { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7},{ 9,7}    },
    {/*1*//*9*/  { 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8},{ 9,8}    },
    {/*1*//* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//VEIDOOR
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/  { 0,0},{ 1,0},{ 2,0},{ 3,0},{ 4,0},{ 5,0},{ 6,0},{ 7,0},{ 8,0},{ 9,0}    },
    {    /*2*/  { 0,1},{ 1,1},{ 2,1},{ 3,1},{ 4,1},{ 5,1},{ 6,1},{ 7,1},{ 8,1},{ 9,1}    },
    {    /*3*/  { 0,2},{ 1,2},{ 2,2},{ 3,2},{ 4,2},{ 5,2},{ 6,2},{ 7,2},{ 8,2},{ 9,2}    },
    {    /*4*/  { 0,3},{ 1,3},{ 2,3},{ 3,3},{ 4,3},{ 5,3},{ 6,3},{ 7,3},{ 8,3},{ 9,3}    },
    {    /*5*/  { 0,4},{ 1,4},{ 2,4},{ 3,4},{ 4,4},{ 5,4},{ 6,4},{ 7,4},{ 8,4},{ 9,4}    },
    {    /*6*/  { 0,5},{ 1,5},{ 2,5},{ 3,5},{ 4,5},{ 5,5},{ 6,5},{ 7,5},{ 8,5},{ 9,5}    },
    {    /*7*/  { 0,6},{ 1,6},{ 2,6},{ 3,6},{ 4,6},{ 5,6},{ 6,6},{ 7,6},{ 8,6},{ 9,6}    },
    {    /*8*/  { 0,7},{ 1,7},{ 2,7},{ 3,7},{ 4,7},{ 5,7},{ 6,7},{ 7,7},{ 8,7},{ 9,7}    },
    {    /*9*/  { 0,8},{ 1,8},{ 2,8},{ 3,8},{ 4,8},{ 5,8},{ 6,8},{ 7,8},{ 8,8},{ 9,8}    },
    {    /* */  {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//NAT145/9
//                 10      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,4},{ 4,3},{ 4,2},{ 4,1},{ 5,4},{ 5,3},{ 5,2},{ 5,1},{ 4,0}    },
    {    /*B*/   { 7,0},{ 6,4},{ 6,3},{ 6,2},{ 6,1},{ 7,4},{ 7,3},{ 7,2},{ 7,1},{ 6,0}    },
    {    /*C*/   { 9,0},{ 8,4},{ 8,3},{ 8,2},{ 8,1},{ 9,4},{ 9,3},{ 9,2},{ 9,1},{ 8,0}    },
    {    /*D*/   {11,0},{10,4},{10,3},{10,2},{10,1},{11,4},{11,3},{11,2},{11,1},{10,0}    },
    {    /*E*/   {13,0},{12,4},{12,3},{12,2},{12,1},{13,4},{13,3},{13,2},{13,1},{12,0}    },
    {    /*F*/   {15,0},{14,4},{14,3},{14,2},{14,1},{15,4},{15,3},{15,2},{15,1},{14,0}    },
    {    /*G*/   { 0,0},{ 1,4},{ 1,3},{ 1,2},{ 1,1},{ 0,4},{ 0,3},{ 0,2},{ 0,1},{ 1,0}    },
    {    /*H*/   { 1,0},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//AMS39
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,6},{ 0,7},{ 0,8},{ 0,9}    },
    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,6},{ 1,7},{ 1,8},{ 1,9}    },
    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,6},{ 2,7},{ 2,8},{ 2,9}    },
    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,6},{ 3,7},{ 3,8},{ 3,9}    },
    {    /*5*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,6},{ 4,7},{ 4,8},{ 4,9}    },
    {    /*6*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,6},{ 5,7},{ 5,8},{ 5,9}    },
    {    /*7*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,6},{ 6,7},{ 6,8},{ 6,9}    },
    {    /*8*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,6},{ 7,7},{ 7,8},{ 7,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
    
    {//VEI147
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 5,0},{ 4,0},{ 5,1},{ 4,1},{ 5,2},{ 4,2},{ 5,3},{ 4,3},{ 5,4},{ 4,4}    },
    {    /*2*/   { 3,0},{ 2,0},{ 3,1},{ 2,1},{ 3,2},{ 2,2},{ 3,3},{ 2,3},{ 3,4},{ 2,4}    },
    {    /*3*/   { 1,0},{ 0,0},{ 1,1},{ 0,1},{ 1,2},{ 0,2},{ 1,3},{ 0,3},{ 1,4},{ 0,4}    },
    {    /*4*/   { 6,0},{ 7,0},{ 6,1},{ 7,1},{ 6,2},{ 7,2},{ 6,3},{ 7,3},{ 6,4},{ 7,4}    },
    {    /*5*/   { 8,0},{ 9,0},{ 8,1},{ 9,1},{ 8,2},{ 9,2},{ 8,3},{ 9,3},{ 8,4},{ 9,4}    },
    {    /*6*/   {10,0},{11,0},{10,1},{11,1},{10,2},{11,2},{10,3},{11,3},{10,4},{11,4}    },
    {    /*7*/   {12,0},{12,1},{12,2},{12,3},{12,4},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*8*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

    {//USIGVC2
//                  0      1      2      3      4      5      6      7      8      9
    {    /*1*/   { 0,0},{ 0,1},{ 0,2},{ 0,3},{ 0,4},{ 0,5},{ 0,6},{ 0,7},{ 0,8},{ 0,9}    },
    {    /*2*/   { 1,0},{ 1,1},{ 1,2},{ 1,3},{ 1,4},{ 1,5},{ 1,6},{ 1,7},{ 1,8},{ 1,9}    },
    {    /*3*/   { 2,0},{ 2,1},{ 2,2},{ 2,3},{ 2,4},{ 2,5},{ 2,6},{ 2,7},{ 2,8},{ 2,9}    },
    {    /*4*/   { 3,0},{ 3,1},{ 3,2},{ 3,3},{ 3,4},{ 3,5},{ 3,6},{ 3,7},{ 3,8},{ 3,9}    },
    {    /*5*/   { 4,0},{ 4,1},{ 4,2},{ 4,3},{ 4,4},{ 4,5},{ 4,6},{ 4,7},{ 4,8},{ 4,9}    },
    {    /*6*/   { 5,0},{ 5,1},{ 5,2},{ 5,3},{ 5,4},{ 5,5},{ 5,6},{ 5,7},{ 5,8},{ 5,9}    },
    {    /*7*/   { 6,0},{ 6,1},{ 6,2},{ 6,3},{ 6,4},{ 6,5},{ 6,6},{ 6,7},{ 6,8},{ 6,9}    },
    {    /*8*/   { 7,0},{ 7,1},{ 7,2},{ 7,3},{ 7,4},{ 7,5},{ 7,6},{ 7,7},{ 7,8},{ 7,9}    },
    {    /*9*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },

//MUST BE ALWAYS last entry ( see checkMotorMap code, lines machineMotor = TOTAL_MACHINE )
    {//NAT145/13
//                 10      1      2      3      4      5      6      7      8      9
    {    /*A*/   { 5,0},{ 4,4},{ 4,3},{ 4,2},{ 4,1},{ 4,0},{ 5,4},{ 5,3},{ 5,2},{ 5,1}    },
    {    /*B*/   { 7,0},{ 6,4},{ 6,3},{ 6,2},{ 6,1},{ 6,0},{ 7,4},{ 7,3},{ 7,2},{ 7,1}    },
    {    /*C*/   { 9,0},{ 8,4},{ 8,3},{ 8,2},{ 8,1},{ 8,0},{ 9,4},{ 9,3},{ 9,2},{ 9,1}    },
    {    /*D*/   {11,0},{10,4},{10,3},{10,2},{10,1},{10,0},{11,4},{11,3},{11,2},{11,1}    },
    {    /*E*/   {13,0},{12,4},{12,3},{12,2},{12,1},{12,0},{13,4},{13,3},{13,2},{13,1}    },
    {    /*F*/   {15,0},{14,4},{14,3},{14,2},{14,1},{14,0},{15,4},{15,3},{15,2},{15,1}    },
    {    /*G*/   { 0,0},{ 1,4},{ 1,3},{ 1,2},{ 1,1},{ 1,0},{ 0,4},{ 0,3},{ 0,2},{ 0,1}    },
    {    /*H*/   { 1,0},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,4},{ 1,3},{ 0,2},{ 1,1},{ 0,0}    },
    {    /*I*/   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    },
    {    /* */   {99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9},{99,9}    }
    },
};

#if SLAVE_MACHINE
byte k_mask[10]  = { 12, 11, 12, 13, 11, 12, 13, 11, 12, 13 };
byte an_mask[10] = {  2,  0,  0,  3,  3,  3,  0,  2,  1,  2 };
#endif


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#define BOOT_RELEASE        "0002"
    #if PRODUCT_RECOGNITION
        #if MOTOR_SIMULATION
            #define FIRWMARE_RELEASE    "0FnZ"
        #else
            #define FIRWMARE_RELEASE    "0R01"
        #endif
    #else
        #if MODEM_HTTP
            #if MOTOR_SIMULATION
                #define FIRWMARE_RELEASE    "01x1"
            #else
#if BIG_SCREEN
                #define FIRWMARE_RELEASE    "0B2B"
#else
                #define FIRWMARE_RELEASE    "012P"
#endif
            #endif
        #else
            #if MOTOR_SIMULATION
                #define FIRWMARE_RELEASE    "07xZ"
            #else
                #define FIRWMARE_RELEASE    "072K"
            #endif
        #endif
    #endif

#ifdef  __WIN32__
#define FLASH
#else
#define FLASH _Pragma("location=\"VENDNAME\"")
#endif
#ifdef BOOT
// from 2.1.0 FLASH const char    vendName[] = "<<<<<<<<>>>>>>>>";
FLASH const char    vendName[16];
FLASH const DWORD   baseLanguage = 0;
_Pragma("location=0x7FF0") const char release[] = "RSR641  "BOOT_RELEASE;

char            *getBootVer( void )
{
    return (char *)release;
}

#else //BOOT
#ifdef __USA
FLASH const char    vendName[] = "VENDORS-EXCHANGE";
FLASH const DWORD   baseLanguage = 0;
#endif
#ifdef __ESP
FLASH const char    vendName[] = "    BIMBO  SA   ";
FLASH const DWORD   baseLanguage = 1;
#endif
#ifdef  __WIN32__
#else
_Pragma("location=0x80E8") const char fwRelease[4] = FIRWMARE_RELEASE;//firmware release
#endif

void            getFirmwareRelease( char *_buf )
{
#ifdef __WIN32__
#else
    if ( fwRelease[0] >= '0' && fwRelease[0] && fwRelease[1] >= '0' && fwRelease[1] <= 'Z'  )
        sprintf( _buf, " %8.8s #%c.%c.%c", MachineTypeID, fwRelease[1], fwRelease[2], fwRelease[3] );
    else
        sprintf( _buf, " %8.8s  %5.5s", MachineTypeID, __TIME__ );
#endif
}

char            *getBootVer( void )
{
    return (char *)BOOT_VER;
}
#endif//BOOT
#if ENABLE_TAX_PRINT || ENABLE_TAX_VISUA
struct {
    _Credito    tax, sale, total;
    dword       phase, hello;
} taxes;
#endif
#if ENABLE_TAX_PRINT
#define COMMp   COMM4
#include "VEIIlogo.c"
#include "qr_code.c"
void    commPutBin( unsigned char *_str, word _len )
{
    while ( _len-- > 0 )
    {
        commPutChar( COMMp, *_str );
        _str++;
    }
}
char            *selection2ASCII( char *_buf, byte _tray, byte _column, byte _reverse, byte machineForm  );
void PRINT_TAX_RECEIPT( byte _tray, byte _column, _Credito _amount )
{
    char        buffer[48];
    static word receipt = 0;
    int         ii;
    _Credito    ppp, sss, ttt;
    
    ttt = _amount;
    sss = (_amount*NonVolatileSetup.percTax/10000);
    ppp = ttt-sss;

//    commPutStr( COMMp, "\x1B\x45\31""VENDORS EXCHANGE""\x0A" );
    commPutStr( COMMp, "\x0A\x1B\x33\x8\x0A" );
//    commPutBin( "\x1D\x70\x01\x00\x0A", 5 );
    for ( ii = 0; ii < sizeof(VEIIlogo); ii++ )
        commPutChar( COMMp, VEIIlogo[ii] );
    Delay(100);
    commPutStr( COMMp, "8700 Brookpark Road \x0A" );Delay(20);
    commPutStr( COMMp, "Cleveland,OH 44129(www.veii.com)\x0A" );Delay(20);
    commPutStr( COMMp, "O 800.321.2311,loc. 216.432.1800\x0A" );Delay(20);
    commPutStr( COMMp, "F 800.249.1855,loc. 216.432.2786\x0A\x0A\x0A" );Delay(20);
    commPutStr( COMMp, "\x1B\x33\x0A\x0A" );Delay(20);
    sprintf( buffer, "Date: %02d-%02d-%04d   Receipt: %4d\x0A", dateTime.month, dateTime.day, dateTime.year, ++receipt );Delay(20);
    commPutStr( COMMp, (byte *)buffer );Delay(20);
    commPutStr( COMMp, "\x1B\x45\30""--------------------------------""\x0A" );Delay(20);
    commPutStr( COMMp, "Product sold: " );Delay(20);
    strcpy ( buffer, "N/A" );Delay(20);
    selection2ASCII( buffer, _tray, _column, 0, machineType );Delay(20);
    commPutStr( COMMp, (byte *)buffer );Delay(20);
    commPutStr( COMMp, "\x0A" );Delay(20);
    sprintf( buffer, "Price:          %2d.%02d$\x0A", ppp/100, ppp%100 );Delay(20);
    commPutStr( COMMp, (byte *)buffer );Delay(20);
    sprintf( buffer, "Sales Tax 7,5%%: %2d.%02d$\x0A", sss/100, sss%100 );Delay(20);
    commPutStr( COMMp, (byte *)buffer );Delay(20);
    commPutStr( COMMp, "----------------------\x0A" );Delay(20);
    sprintf( buffer, "Total:          %2d.%02d$\x0A", ttt/100, ttt%100 );Delay(20);
    commPutStr( COMMp, (byte *)buffer );Delay(20);
    commPutStr( COMMp, "----------------------\x0A" );Delay(20);
    commPutStr( COMMp, "Thank you for your patronage\x0A\x0A" );Delay(20);
//    commPutStr( COMMp, "\x1D\x68\x3F" );           // barcode height
//    commPutBin( "\x1D\x6B\x4VENDORS-EXCHANGE\x00\x0A", 21 );           // print barcode code93
    commPutStr( COMMp, "\x1B\x33\x8\x0A" );
//    commPutBin( "\x1D\x70\x01\x00\x0A", 5 );
    Delay(100);
    for ( ii = 0; ii < sizeof(qr_code); ii++ )
        commPutChar( COMMp, qr_code[ii] );
    commPutStr( COMMp, "\x1B\x33\x0A\x0A" );
    Delay(20);
//    commPutStr( COMMp, "\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A\x0A" );// feed
    commPutStr( COMMp, "\x0A\x0A\x0A\x0A\x0A" );// feed
    Delay(20);
    commPutStr( COMMp, "\x1C\xC0\x34" );// total cut
//    commPutStr( COMMp, "\x1B\x69" );           // total cut
}
void LoadBitmapLogo( void )
{
//    commPutStr( COMMp, "\x0A" );
//    commPutStr( COMMp, "\x0A" );
//    commPutStr( COMMp, "\x1D\x2A\x01" );           // send bitmap
//    commPutBin( (unsigned char *)&logo_VEI[0], 8574 );
}
#else
#define PRINT_TAX_RECEIPT(a,b,c)
#endif
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////




extern  byte    stopInt;

byte            flagTimeDisable, lastTestTimeDisable, lastTestDiscount;
int             i;

DWORD           tTimeoutMaxMotor;
DWORD           initialInp;
DWORD           exeSaveSettings;
byte            nfront;
BOOL            inProgramm;

struct {
    byte        status;
    enum {  SELECTION_NO = 0,
            SELECTION_START,
            SELECTION_RETRY,
            SELECTION_HOMING,
            SELECTION_OK,
            SELECTION_FAILED
    } SELECTION_MODES;
    dword       timeout;
} prodSel;
#define SET_SELECTION_STATUS(a)     {prodSel.status=(a);prodSel.timeout=GetTickCount();}
#define ON_SELECTING()              (prodSel.status != SELECTION_NO)
#define CHECK_SELECTION_STATUS()    {if( ON_SELECTING() && (GetTickCount()-prodSel.timeout) > 20000 ) prodSel.status=SELECTION_FAILED;}

unsigned int    timeBacklight;

byte            motorMap[N_K_MAX][N_AN_MAX];
byte            machineMotor;

const char * const *message;

extern word    ldpFlag[6];
extern word    ldpBlink[6];
extern byte    ldpCnt;


BOOL            testActiveMotor( byte _s_tray, byte _s_column)
{
    byte        k, an;
    GET_ACTIVE_MOTOR(k,an, _s_tray,_s_column);
    if ( k == 99 || motorMap[k][an] == 0 )
        return FALSE;
    return TRUE;
}



/*--------------------------------------------------------------------------
 | programMachineType:program machine card
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            programMachineType( void )
{
    ///// write machine type
#if BOARD_ROWE6800
    memcpy( MachineTypeID, "ROWE6800", 9 ); // RSR676
#endif
#if BOARD_ROWE5900
    memcpy( MachineTypeID, "ROWE5900", 9 ); // RSR675
#endif
#if BOARD_NAT147
    memcpy( MachineTypeID, "NAT147\0\0", 9 );
#endif
#if BOARD_AP113
    memcpy( MachineTypeID, "AP113\0\0\0", 9 );
#endif
#if BOARD_NAT157
    memcpy( MachineTypeID, "NAT157\0\0", 9 );
#endif
#if BOARD_AP7000
    memcpy( MachineTypeID, "AP7000\0\0", 9 );
#endif
#if BOARD_LCM123
    memcpy( MachineTypeID, "LCM123\0\0", 9 );
#endif
#if BOARD_AP123
    memcpy( MachineTypeID, "AP123\0\0\0", 9 );
#endif
#if BOARD_VEIDOOR
    memcpy( MachineTypeID, "VEI-DOOR", 9 );
#endif
#if BOARD_NAT145
    memcpy( MachineTypeID, "NAT145\0\0", 9 );
#endif
#if BOARD_AMS39
    memcpy( MachineTypeID, "AMS39\0\0\0", 9 );
#endif
#if BOARD_VEI147
    memcpy( MachineTypeID, "VEI147\0\0", 9 );
#endif
#if BOARD_USIGVC2
    memcpy( MachineTypeID, "USIGVC2\0", 9 );
#endif
                                        // check machine type on mmc
    if ( mmcInit() == mmc_noerr )
    {
        if ( dosfs_findFile( "AP7000.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP7000\0\0", 9 );
        else if ( dosfs_findFile( "NAT147.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT147\0\0", 9 );
        else if ( dosfs_findFile( "NAT157.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT157\0\0", 9 );
        else if ( dosfs_findFile( "LCM123.UCB" ) == 0 )
            memcpy( MachineTypeID, "LCM123\0\0", 9 );
        else if ( dosfs_findFile( "AP123.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP123\0\0\0", 9 );
        else if ( dosfs_findFile( "AP113.UCB" ) == 0 )
            memcpy( MachineTypeID, "AP113\0\0\0", 9 );
        else if ( dosfs_findFile( "VEI-DOOR.UCB" ) == 0 )
            memcpy( MachineTypeID, "VEI-DOOR", 9 );
        else if ( dosfs_findFile( "NAT145.UCB" ) == 0 )
            memcpy( MachineTypeID, "NAT145\0\0", 9 );
        else if ( dosfs_findFile( "AMS39.UCB" ) == 0 )
            memcpy( MachineTypeID, "AMS39\0\0\0", 9 );
        else if ( dosfs_findFile( "VEI147.UCB" ) == 0 )
            memcpy( MachineTypeID, "VEI147\0\0", 9 );
        else if ( dosfs_findFile( "USIGVC2.UCB" ) == 0 )
            memcpy( MachineTypeID, "USIVGC2\0", 9 );
    }

    __disable_interrupt();
    WriteScratchpadDS2431( (unsigned char *)MachineTypeID, 0, 8);
    CopyScratchpadDS2431( 0 );
    ReadIDDS2431( );
    __enable_interrupt();
    return TRUE;
}                                               //  programMachineType




/*--------------------------------------------------------------------------
 | checkMachineType:verify type of machine programmed
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            checkMachineType( void )
{
    ReadIDDS2431( );

    ////// select machine type
    if( strcmp( MachineTypeID, "NAT147") == 0 ) machineType = MACHINA_NAT147;
    else if( strcmp( MachineTypeID, "AP113"   ) == 0 ) machineType = MACHINA_AP113;
    else if( strcmp( MachineTypeID, "ROWE5900") == 0 ) machineType = MACHINA_ROWE5900;
    else if( strcmp( MachineTypeID, "ROWE6800") == 0 ) machineType = MACHINA_ROWE6800;
    else if( strcmp( MachineTypeID, "NAT157"  ) == 0 ) machineType = MACHINA_NAT157;
    else if( strcmp( MachineTypeID, "AP7000"  ) == 0 ) machineType = MACHINA_AP7000;
    else if( strcmp( MachineTypeID, "LCM123"  ) == 0 ) machineType = MACHINA_LCM123;
    else if( strcmp( MachineTypeID, "AP123"   ) == 0 ) machineType = MACHINA_AP123;
    else if( strcmp( MachineTypeID, "VEI-DOOR") == 0 ) machineType = MACHINA_VEIDOOR;
    else if( strcmp( MachineTypeID, "NAT145"  ) == 0 ) machineType = MACHINA_NAT145;
    else if( strcmp( MachineTypeID, "AMS39"   ) == 0 ) machineType = MACHINA_AMS39;
    else if( strcmp( MachineTypeID, "VEI147"  ) == 0 ) machineType = MACHINA_VEI147;
    else if( strcmp( MachineTypeID, "USIGVC2"  ) == 0 ) machineType = MACHINA_USIGVC2;
    else {
        machineType = MACHINA_UNKNOWN;
        return FALSE;
    }
    return TRUE;
}                                               //  checkMachineType




/*--------------------------------------------------------------------------
 | checkTimeFrames:check if selection time locked
 |                              --------------
 | In:  _tray, _column      selection position
 | Out: TRUE    selection in timeframes
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/
 #if SEL_LOCKOUT
byte            testTimeLockout( byte group );
 #endif

BOOL            checkTimeFrames( byte _tray, byte _column )
{
#if GROUP_SELECTION
    byte        i, j, dd;
    struct _TIMEFRAMES_ *p;
    struct _GROUP_ *g;

    dd = dateTime_weekDay;//weekDay( dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.min );

    for ( i = 0; i < MAXTIMEFRAMES; i++ )
    {
        p = &timeFrames[i];
        if ( p->weekDay != 0 && p->weekDay != dd )
            continue;
        if ( dateTime.hour < p->disable.hour )
            continue;
        if ( dateTime.hour == p->disable.hour && dateTime.min < p->disable.min )
            continue;
        if ( dateTime.hour > p->enable.hour )
            continue;
        if ( dateTime.hour == p->enable.hour && dateTime.min > p->enable.min )
            continue;
                                        // time is within range check group
        if ( p->group < MAXGROUP )
            g = &group[p->group];
        else if ( p->group < 2*MAXGROUP )
            g = &selGroup[p->group-MAXGROUP];
        else
            continue;

        for ( j = 0; j < MAXselGROUP; j++ )
        {
            if ( g->info[j].row == 0 || g->info[j].col == 0 )
                continue;
            if ( g->info[j].row == (_tray+1) && g->info[j].col == (_column+1) )
                return TRUE;
        }
    }
#else
 #if SEL_LOCKOUT
    byte        i, j;

    for ( i = 0; i < MAXTIMEDISABLE; i++ )
    {
        for ( j = 0; j < MAXEntriesTimeDisable; j++ )
        {
            if ( selGroup[i].info[j].row == 0 || selGroup[i].info[j].col == 0 )
                continue;
            if ( selGroup[i].info[j].row == (_tray+1) && selGroup[i].info[j].col == (_column+1) )
            {                           // group found, check which selection to activate
                return( testTimeLockout( i+5 ) == FALSE );   // see function edDisableLx in menu.c will asiign group 5-9 to time 0-4
            }
        }
    }
 #else
    _tray = _tray;
    _column = _column;
 #endif
#endif
    return FALSE;
}                                               //  checkTimeFrames




/*--------------------------------------------------------------------------
 | selectionLocked:check if selection available or locked by exaust selection or health temperature problem
 |                              --------------
 | In:  _tray, _column      selection position
 | Out: TRUE    selection not available
 |      FALSE   selection available
 +--------------------------------------------------------------------------*/

BOOL            selectionLocked( byte _tray, byte _column )
{
    byte j;
    
    if ( NonVolatileSetup.motorCoupled[_tray][(_column&0xFE)] == 1 && (_column&0x01) == 0x01 )
        return TRUE;                    // only even selection if motor coupled
    if ( nF.nFails[_tray][_column] >= MAX_SEL_FAILED &&
//        ( NonVolatileSetup.fallSensorMode == FALLSENSOR_3x ||
//          NonVolatileSetup.fallSensorMode == FALLSENSOR_3r ) )
        ( enDrop[_tray][_column] == FALLSENSOR_3x ||
          enDrop[_tray][_column] == FALLSENSOR_3r ) )
        return TRUE;
    
    if ( machineType != MACHINA_AMS39 && machineType != MACHINA_USIGVC2)
        return FALSE;
    
    for ( j = 0; j < MAXselGROUP; j++ )
    {
        if ( selGroup[MAXTIMEDISABLE+MAXGROUPNUM].info[j].row == 0 || selGroup[MAXTIMEDISABLE+MAXGROUPNUM].info[j].col == 0 )
            continue;
        if ( selGroup[MAXTIMEDISABLE+MAXGROUPNUM].info[j].row == (_tray+1) && selGroup[MAXTIMEDISABLE+MAXGROUPNUM].info[j].col == (_column+1) )
            return FALSE;
    }
    if( HealthProblem == HEALTH_FAIL )
        return TRUE;
    return FALSE;
}                                               //  selectionLocked




/*--------------------------------------------------------------------------
 | checkMotorGroupSelection:verify if the selection is a part of a group and
 |              change automatically from the group
 |                              --------------
 | In:  _tray, _column      selection position
 | Out:
 +--------------------------------------------------------------------------*/

void            checkMotorGroupSelection( byte *_tray, byte *_column )
{
    byte        i, j, l, n, k, an;
    byte        s_tray, s_column;

#if GROUP_SELECTION
    for ( i = 0; i < MAXGROUP; i++ )
#else
    for ( i = MAXTIMEDISABLE; i <= MAXTIMEDISABLE+2; i++ )
#endif
    {
        for ( j = 0; j < MAXEntriesGroupSel; j++ )
        {
            if ( selGroup[i].info[j].row == 0 || selGroup[i].info[j].col == 0 )
                continue;
            if ( selGroup[i].info[j].row == (*_tray+1) && selGroup[i].info[j].col == (*_column+1) )
            {                           // group found, check which selection to activate
                for ( l = idxGroup[i], n = 0; n < MAXEntriesGroupSel; n++ )
                {
                    s_tray = selGroup[i].info[l].row;
                    s_column = selGroup[i].info[l].col;
                    if ( s_tray != 0 && s_column != 0 && s_tray != 0xFF && s_column != 0xFF )
                    {
                        s_tray--;
                        s_column--;
                                        // check motor presence ...
                        if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                        {
                            GET_ACTIVE_MOTOR(k,an, s_column,s_tray);
                        }
                        else
                        {
                            GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                        }
                        if ( k == 99 || motorMap[k][an] == 0 )
                        {                   // motor not present
                            l++;
                            if ( l >= MAXEntriesGroupSel )
                                l = 0;
                            continue;
                        }

                        if ( !checkTimeFrames( s_tray, s_column ) )
                        {
                            if ( !selectionLocked(s_tray,s_column) )
                            {                   // selection found, ok
                                l++;
                                if ( l >= MAXEntriesGroupSel )
                                    l = 0;
                                idxGroup[i] = l;

                                *_tray = s_tray;
                                *_column = s_column;
                                return;
                            }
                        }
                    }
                    l++;
                    if ( l >= MAXEntriesGroupSel )
                        l = 0;
                }
                return;
            }
        }
    }
}                                               //  checkMotorGroupSelection




/*--------------------------------------------------------------------------
 | testKey:     read a key
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/

_UCHAR          testKey( void )
{
    if( kbhit() )                 //  TASTIERA
        return (_UCHAR)getKey();

    return 0;
}                                               //  testKey




/*--------------------------------------------------------------------------
 | checkMotorMap:verify motor map
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/

byte            checkMotorMap( void )
{
    byte        k, an, flag, iTray;
    DWORD       inp, tStartMotor;
    char        buf[20];
    
#if LED_DIMMING
    DWORD       saveDimming;
    saveDimming = dutyLED2;
    dutyLED1 = dutyLED2 = 0;
#endif
    lpdMode(0);
    getFirmwareRelease( buf );
    DispStr( 0, 0, buf );
    Delay(1000);

    inp = 0xFF;
    initialInp = inp;
    memset( motorMap, 0, sizeof(motorMap) );
    machineMotor = machineType;
    k = 0;
    an = 0xFF;
    PWR_EN_ON();
    for ( ;; )
    {
        STOP_MOTORS();
#ifndef __WIN32__
        Delay(10);
#endif
        PWR_EN_ON();

        // attivando solo i catodi attivo INP0, INP2 in NAT147
        ATTIVA_CATODO( k );
        
        testMotorPresence = 0;
        if ( an != 0xFF )
        {
#ifndef __WIN32__
            Delay(50);
#endif
            __disable_interrupt();
            ATTIVA_ANODO( an );
            if ( machineType == MACHINA_NAT145  || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || 
                 machineType == MACHINA_AP113   || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || 
                 machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39  || machineType == MACHINA_VEI147 || 
                 machineType == MACHINA_USIGVC2 )
            {
                testMotorPresence = 2;//must be after START_MOTOR
                testMotorHoming = 2;
            }
            __enable_interrupt();
        }

#if HOME_DEBUG//99=check motor map
        commPutChar( COMM1, 0x99 );
        commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
#ifndef __WIN32__
        Delay(4);
#endif
                                        // scansione anodi e catodi
        if ( an == 0xFF )
        {                           // test tray presence
            if ( machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
            {
                if ( INP0 == 1 && INP2 == 1 )
                {                   // no tray connected
                    for ( an = 0; an < N_AN_NAT147; an++ )
                        motorMap[k][an] = 0;
                    an = 0xFF;
                    k++;
                    if ( k >= N_K_NAT147 )
                        break;
                }
                else                // at least one motor connected on this tray
                    an = 0;         // start scan for motors connected
            }
            else
                an = 0;
        }
        else
        {                           // verifica presenza motori
            if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 )
            {
                if ( IS_PWR_OFF() ) //if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( ( machineType == MACHINA_AMS39 && an >= N_AN_AMS39 ) ||
                     ( machineType != MACHINA_AMS39 && an >= N_AN_AP113 ) )
                {
                    an = 0;
                    k++;
                    if ( k >= N_K_AP113 )
                        break;
                }
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_USIGVC2 )
            {
                if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( an >= N_AN_ROWE  )
                {
                    an = 0;
                    k++;
                    if ( k >= N_K_ROWE )
                        break;
                }
            }
            else if ( machineType == MACHINA_LCM123 )
            {
                if ( AD.conv[AD_I_MOTORS] > 20 )
                    motorMap[k][an] = 1;
                else
                    motorMap[k][an] = 0;
                PWR_EN_OFF();
                an++;
                if ( an >= N_AN_LCM123  )
                {
                    an = 0;
                    k++;
                    if ( k >= N_K_LCM123 )
                        break;
                }
            }
            else // machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147
            {
/**/
                if ( IS_PWR_OFF() ) 
                {
                    motorMap[k][an] = 1;
#if HOME_DEBUG//91=motor map=1
                    commPutChar( COMM1, 0x91 );
                    commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                }
                else
                {
#if HOME_DEBUG//90=motor map=0
                    commPutChar( COMM1, 0x90 );
                    commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                }
/*
                if ( INP0 == 1 || INP2 == 1 )
                    motorMap[k][an] = 1;
*/
                an++;
                if ( an >= N_AN_NAT147 )
                {
                    an = 0xFF;
                    k++;
                    if ( k >= N_K_NAT147 )
                        break;
                }
            }
        }
    }
    STOP_MOTORS();
    testMotorPresence = 0;

#if MOTOR_SIMULATION == 1
    memset( motorMap, 1, sizeof(motorMap) );
#endif
#if FULL_MOTOR
    memset( motorMap, 1, sizeof(motorMap) );
#endif

                                        // try to identify NAT145 from NAT146
    if ( machineType == MACHINA_NAT145 )
    {                                   // change machine type to 10 wide        
        flag = 0;
        for ( iTray = 0; iTray <= 5;iTray++ )
        {
            PWR_EN_ON();
            GET_ACTIVE_MOTOR(k,an, iTray,0);// test tray last position
            if ( testIfMotorAvailable(k,an) )
            {
                machineMotor = TOTAL_MACHINE;   // 5/10 wide NAT145
                flag = 1;
                break;
            }
            PWR_EN_ON();
            GET_ACTIVE_MOTOR(k,an, iTray,9);// test tray last-1 position
            if ( testIfMotorAvailable(k,an) )
            {
                machineMotor = TOTAL_MACHINE;   // 5/10 wide NAT145
                flag = 1;
                break;
            }
        }
        if ( flag == 0 )
        {                                   // 4/ 8 wide NAT146
            for ( k = 0; k < N_K_MAX; k++ )
                motorMap[k][0] = 0;
        }
/*
        for ( k = 0; k < N_K_MAX; k++ )
        {
            for( an = 0; an < N_AN_NAT147; an++ )
            {
                if ( motorMap[k][an] != 0 )
                {
                    PWR_EN_ON();
                    if ( !testIfMotorAvailable(k,an) )
                        motorMap[k][an] = 0;
                }
            }
        }
*/
    }

#if LED_DIMMING
    dutyLED1 = dutyLED2 = saveDimming;
#endif
    lpdMode(1);
    tStartMotor = tStartMotor;

                                        // count motors found
    iTray = 0;
    for ( k = 0; k < N_K_MAX; k++ )
    {
        for ( an = 0; an < N_AN_MAX; an++ )
        {
             if ( motorMap[k][an] )
                iTray++;
        }
    }
    sprintf( buf, " OUTPUT TOT.:%3d", iTray );
    DispStr(0,0,buf);
    Delay(1000);
    DispStr( 0, 0, (char *)MSG_ATTESA );

    return 1;
}                                               //  checkMotorMap




/*--------------------------------------------------------------------------
 | testIfMotorAvailable:check motor availability
 |                              --------------
 | In:
 | Out: _UCHAR  character code
 |      0       no char available
 +--------------------------------------------------------------------------*/

byte            testIfMotorAvailable( byte _k, byte _an )
{
#if MOTOR_SIMULATION == 1
    return 1;
#else//MOTOR_SIMULATION
#if FULL_MOTOR
    memset( motorMap, 1, sizeof(motorMap) );
    return 1;
#endif
    byte        avail = 1;
    DWORD       tStartMotor;

    if ( machineType == MACHINA_NAT145 )
    {                                   // use AP113 method to verify motor availability
        PWR_EN_ON();
    }

    STOP_MOTORS();
#ifndef __WIN32__
    Delay(10);
#endif

    // attivando solo i catodi attivo INP0, INP2 in NAT147/NAT157
    ATTIVA_CATODO( _k );

    testMotorPresence = 0;
#ifndef __WIN32__
    Delay(50);
#endif
    __disable_interrupt();
    ATTIVA_ANODO( _an );
    
#if HOME_DEBUG//44=home motor test
    commPutChar( COMM1, 0x44 );
    commPutChar( COMM1, ((_k&0x0f)<<4)|(_an&0x0f) );
#endif
    
    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || 
         machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR ||
         machineType == MACHINA_AMS39 ) // DEBUG da verificare AMS39 e 
    {
        testMotorPresence = 2;//must be after START_MOTOR
        testMotorHoming = 2;
    }
    __enable_interrupt();


#ifndef __WIN32__
    Delay(4);
#endif
    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || 
         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 )
    {
        if ( IS_PWR_OFF() )
            avail = 1;
        else
            avail = 0;
    }
    else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_LCM123 || machineType == MACHINA_USIGVC2 )
    {
        if ( AD.conv[AD_I_MOTORS] > 20 )
            avail = 1;
        else
            avail = 0;
    }
    else // machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147
    {
        if ( IS_PWR_OFF() )
            avail = 1;
    }
    STOP_MOTORS();
#ifndef __WIN32__
    Delay(3);
#endif
    PWR_EN_ON();
    testMotorPresence = 0;
    testMotorHoming = 0;
#ifndef __WIN32__
    Delay(10);
#endif

    tStartMotor = tStartMotor;
    return avail;
#endif//MOTOR_SIMULATION
}                                               //  testIfMotorAvailable




/*--------------------------------------------------------------------------
 | readMotorAvailability:verify if motor it's present or not
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            readMotorAvailability( byte _tray, byte _column )
{
    byte        k, an;
    
    GET_ACTIVE_MOTOR(k,an, _tray,_column);
    if ( motorMap[k][an] != 0 )
        return TRUE;
    return FALSE;
}                                               //  readMotorAvailability




/*--------------------------------------------------------------------------
 | vendingCycle:verify if vending cycle
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            vendingCycle( void )
{
    return (stopInt == 1);
}                                               //  vendingCycle




/*--------------------------------------------------------------------------
 | programmingMode:verify if vending cycle
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

BOOL            programmingMode( void )
{
    return inProgramm;
}                                               //  programmingMode




/*--------------------------------------------------------------------------
 | isTimedDisable:verify if machine disabled depending on timing
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

struct _DAY_TIME_ {
    word    val;
    byte    en;
};

static void     insTime( struct _DAY_TIME_ *_p, word _val, byte _en )
{
    byte        t;

    for ( t = 0; t < MAXTIMEDISABLE*2; t++, _p++ )
    {
        if ( _val < _p->val )
        {
            memmove( _p+1, _p, sizeof(struct _DAY_TIME_)*(MAXTIMEDISABLE*2-t-1) );
            _p->val = _val;
            _p->en  = _en; 
            return;
        }
    }
}

static word     convTime( byte _hour, byte _am_pm, byte _min )
{
    if ( _hour == 12 )
    {
        if ( _am_pm == 0 )
            return          _min;// morning, midnight
        else
            return _hour*60+_min;// afternoon, noon
    }
    return ((_hour+_am_pm)*60)+_min;
}

static BOOL     weekTestTimeDisable( byte abil, byte _weekDay, struct _TIMEDISABLE_ *ptimeDisable, byte numgroups )
{
    byte        d, e, j;
    word        actualTime, disTime, enTime;
    struct _TIMEDISABLE_ *pTd;
    struct _DAY_TIME_ dayTime[MAXTIMEDISABLE*2];

    if ( _weekDay >= 7 )
        e = 7;
    else
        e = _weekDay;
    
    for ( d = 0; d < e; d++ )           // find enables of the week
    {
        for ( j = 0, pTd = ptimeDisable; j < numgroups; j++, pTd++ )
        {
//            pTd = &timeDisable[j];
            if ( pTd->disable.weekDay > EVERYDAYS || pTd->disable.hour == 0 || pTd->disable.hour > 12 || pTd->disable.min > 59 )
                continue;           // time not set
            enTime = 0xFFFF;
            disTime = 0xFFFF;
            if ( (pTd->disable.weekDay == d                 ) ||
                 (pTd->disable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->disable.weekDay == EVERYDAYS         ) )
                disTime = convTime(pTd->disable.hour,pTd->disable.am_pm,pTd->disable.min);
            if ( (pTd->enable.weekDay == d                 ) ||
                 (pTd->enable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->enable.weekDay == EVERYDAYS         ) )
                enTime  = convTime(pTd->enable.hour, pTd->enable.am_pm, pTd->enable.min );
            
            if ( disTime == 0xFFFF && enTime == 0xFFFF )
                ;                       // no time variation
            else if ( disTime == 0xFFFF )
                abil = TRUE;            // enable sometimes
            else if ( enTime == 0xFFFF )
                abil = FALSE;           // disable sometimes
            else if ( disTime > enTime )
                abil = FALSE;           // disable at the end of the day
            else
                abil = TRUE;            // enable at the end of the day
        }
    }
    if ( _weekDay != 0xFF )
    {
        memset( &dayTime[0], 0xFF, sizeof(dayTime) );
        for ( j = 0, pTd = ptimeDisable; j < numgroups; j++, pTd++ )
        {
//            pTd = &timeDisable[j];
            if ( pTd->disable.weekDay > EVERYDAYS || pTd->disable.hour == 0 || pTd->disable.hour > 12 || pTd->disable.min > 59 )
                continue;           // time not set
            enTime = 0xFFFF;
            disTime = 0xFFFF;
            if ( (pTd->disable.weekDay == d                 ) ||
                 (pTd->disable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->disable.weekDay == EVERYDAYS         ) )
                disTime = convTime(pTd->disable.hour,pTd->disable.am_pm,pTd->disable.min);
            if ( (pTd->enable.weekDay == d                 ) ||
                 (pTd->enable.weekDay == WEEKDAYS && d <= 5) ||
                 (pTd->enable.weekDay == EVERYDAYS         ) )
                enTime  = convTime(pTd->enable.hour ,pTd->enable.am_pm, pTd->enable.min );
            if ( disTime != 0xFFFF )
                insTime(&dayTime[0],disTime,0);
            if ( enTime != 0xFFFF )
                insTime(&dayTime[0],enTime,1);
        }
        
        actualTime = (dateTime.hour*60) + (dateTime.min);
        for ( j = 0; j < MAXTIMEDISABLE*2; j++ )
        {
            if ( dayTime[j].val == 0xFFFF || dayTime[j].en == 0xFF )
                break;
            if ( dayTime[j].val > actualTime )
                break;
            abil = dayTime[j].en;
        }
    }
    return abil;    
}

void            testTimeDisable( void )
{
    byte        abil;

    abil = TRUE;                        // start with enabled
    abil = weekTestTimeDisable( abil, 0xFF, &timeDisable[0], MAXTIMEDISABLE );
    abil = weekTestTimeDisable( abil, ((dateTime_weekDay>1)?(dateTime_weekDay-1):0), &timeDisable[0], MAXTIMEDISABLE );

    flagTimeDisable = abil;
}                                               //  testTimeDisable

BOOL            isTimedDisable( void )
{
    return (flagTimeDisable==FALSE);
}                                               //  isTimedDisable

#if SEL_LOCKOUT
byte            testTimeLockout( byte group )
{
    byte        abil;

    abil = TRUE;                        // start with enabled
    abil = weekTestTimeDisable( abil, 0xFF, &timeDisable[group], 1 );
    abil = weekTestTimeDisable( abil, ((dateTime_weekDay>1)?(dateTime_weekDay-1):0), &timeDisable[group], 1 );
    return( abil );
}
#endif



/*--------------------------------------------------------------------------
 | setLedDimming:set led dimming mode
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            setLedDimming( void )
{
#if LED_DIMMING
    byte        i;

    dimmedLED = 0x00000000; 
    if ( NonVolatileSetup.percDimming > 95 )
        dimmedLED = 0xFFFFFFFF;
    else if ( NonVolatileSetup.percDimming != 0 )
    {
#if 1
        for ( i = 0; i < NonVolatileSetup.percDimming; i += 12 )
        {
            dimmedLED <<= 1;
            dimmedLED |= 0x01010101;
        }
#else
        for ( i = 0; i < NonVolatileSetup.percDimming; i += 6 )
        {
            dimmedLED <<= 1;
            dimmedLED |= 0x00010001;
        }
#endif
    }
    dutyLED1 = dimmedLED;
    dutyLED2 = dimmedLED;
#endif
}                                               //  setLedDimming




/*--------------------------------------------------------------------------
 | testSaveSettings:verify save setting conditions
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            testSaveSettings( void )
{
    if ( exeSaveSettings == 1 )
    {                               // save changed settings on main
        exeSaveSettings = 0;
        saveAmount();
        saveGroup();
        saveSettings();
    }
}                                               // testSaveSettings




/*--------------------------------------------------------------------------
 | currencyStr: convert currency value to string
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

char            *currencyStr( _Credito _money, byte _size )
{
    static char strCurr[16];

    if ( posVirgola == 2 )
        sprintf( strCurr, "%*ld.%02ld", _size-3, _money/100, _money%100 );
    else
        sprintf( strCurr, "%*ld", _size, _money );

    return strCurr;
}                                               // currencyStr




/*--------------------------------------------------------------------------
 | main:        main program
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#if LED_DIMMING
#define         LED_FULL_ON()   tLED1 = GetTickCount();dutyLED1 = 0xFFFFFFFF;dutyLED2 = 0xFFFFFFFF;
#else
#define         LED_FULL_ON()
#endif

//eee
//DWORD testtempo, testimmagine;

#ifdef  __WIN32__
int             mainVEI( void )
#else
int             main( void )
#endif
{
#ifdef BOOT
    byte        resp;
    char        fileName[100], i;
    WORD        cluster;
    DWORD       filelen;
    void        (*firmwareEntryPoint)( void );
#else
    byte        kkk, k, an, nread, doorIsOpen, LCDmsg, flag, inpMask;
    byte        alt_k, alt_an;
    byte        s_machine, s_tray, s_column, last_s_tray, last_s_column;
    DWORD       tsinc, tMsgDelay, tStartFall, tTimeoutFall, tStartMotor, tTimeoutMotor, tLCDtimer, tPartialSelection, mask, inp;
    DWORD       tReadDate;
    byte        nTestFall;
    byte        disDoubleTurn;          // FALSE: standard drop sensor #5 functionality
                                        // TRUE: if sensor always on, disable double turn, go standard home position

    _Credito    money, tot;
    char        buf[20];
#endif
    DWORD       tled;
#if ANTI_V
    byte        oldXY;
    DWORD       tiltXY, frontXY, tiltON;
    byte        oldIR;
#endif
#if LED_DIMMING
    DWORD       tiltIR;
#endif

    testMode = 0x00000000;
    flagTimeDisable = 0;
    lastTestTimeDisable = 0xFF;
    lastTestDiscount = 0xFF;
                                        // select machine, before all
    HardwareInit();
    // DEX - MDB DEBUG port
#if TESTCCD
    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
#else
  #if MODEM_HTTP
    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
  #else
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
  #endif
#endif

    // ZIGBEE port
    commCfgPort( COMM2, Baud9600, WordLength8, ParitySelNone, StopBit1 );

    // MicroMech init
#ifndef __WIN32__
    FIO3CLR_bit.P3_26 = 1;   // switch MDB/Micromach to Micromach
#endif
    commCfgPort( COMM3, Baud600, WordLength8, ParitySelNone, StopBit1 );
#if ENABLE_COMM4
    #if ENABLE_COMM1
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM1 );
    #else
    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM4 );
    #endif
#endif

#if LED_DIMMING
    dutyLED1 = 0;
    dutyLED2 = 0;
    maskLED = 0x0;
#endif

#ifndef BOOT
    STOP_MOTORS();
    startCredit();
    money = 0;
    tot = 0;
// 07.02.2011    doorIsOpen = FALSE;
    doorIsOpen = 0xAA;    // 07.02.2011, neither TRUE or FALSE after power on
#endif

    switch ( baseLanguage )
    {
        case 1:     message = &textEspana[0];               break;
        default:    message = &textEnglish[0];              break;
    }
    timeBacklight = GetTickCount();
    DisplayBacklighOn();
    DispClrScr();
    LcdErase(TUTTI);
    if ( isprint(vendName[0]) && isprint(vendName[1]) && vendName[0] != '<' && vendName[1] != '<' && vendName[2] != '<' )
        DispStr( 0, 0, (char*)vendName );
    else
    {
#ifdef BOOT
        strcpy( bufferLCD, &MENU_82[2] );
        sprintf( &bufferLCD[8], "  #%c.%c.%c", release[9], release[10], release[11] );
        DispStr( 0, 0, bufferLCD );
#else
        DispStr( 0, 0, (char *)MSG_ATTESA );
#endif
    }
    BuzzerOn(500);

    nPasscode = 0;
                                        // memory initialize
    memset( usable,     0xFF, sizeof(usable)    );
    memset( &nF,        0,    sizeof(nF)        );
    memset( enDrop,     0,    sizeof(enDrop)    );
    memset( group,      0,    sizeof(group)     );
    memset( amount,     0,    sizeof(amount)    );
    memset( idxGroup,   0,    sizeof(idxGroup)  );// da dove prendo questo valore?????
    posVirgola = 0;
#if ENABLE_DISCOUNT
    memset( sels,       0xFF, sizeof(sels)    );    // DEBUG
#endif

#ifdef TEST
    saveSettings();
    {
extern dword AuditData[AUDIT_DATA_SIZE];
    memset( AuditData,0,  sizeof(AuditData) );
    saveAudit();
    }
#endif
    
#ifndef BOOT
    loadSettings();
    exeSaveSettings = 0;
    if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 1;
    setContrastLCD( NonVolatileSetup.contrasto_lcd );
#if TESTKEYBOARD == 0
    mmdStatus = mmdLoadProg();
    mmdRestartAds();
    loadAmount();
    loadGroup();
    loadAudit();
#endif
#else
    if( NonVolatileSetup.contrasto_lcd > 100 ) NonVolatileSetup.contrasto_lcd = 1;
    setContrastLCD( NonVolatileSetup.contrasto_lcd );
#endif

//EEE
    posVirgola = DECIMAL_PLACE;
//EEE

#if 0
    // DEX - MDB DEBUG port  >>>>>>>>>> spostato sopra >>>>>>>>>>>>>>>>>
#if TESTCCD
    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
#else
  #if MODEM_HTTP
    commCfgPort( COMM1, Baud57600, WordLength8, ParitySelNone, StopBit1 );
  #else
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
  #endif
#endif

    // ZIGBEE port
    commCfgPort( COMM2, Baud9600, WordLength8, ParitySelNone, StopBit1 );

    // MicroMech init
#ifndef __WIN32__
    FIO3CLR_bit.P3_26 = 1;   // switch MDB/Micromach to Micromach
#endif
    commCfgPort( COMM3, Baud600, WordLength8, ParitySelNone, StopBit1 );
#if ENABLE_COMM4
    #if ENABLE_COMM1
    commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM1 );
    #else
    commCfgPort( COMM4, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    hostInit( COMM4 );
    #endif
#endif
#endif

#ifdef TEST
    //#########################################################################
    programMachineType();
    do {
        getFirmwareRelease( buf );
        DispStr( 0, 0, buf );
        Delay(1000);
        BuzzerOn(100);
        DispStr( 0, 0, " HW REL. FORCED " );
        Delay(1000);
        
        checkMachineType();
        for( i = 0; i < machineType; i++ )
        {
            IO1CLR_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
            Delay(400);
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
            Delay(400);
        }
        
    } while(-1);
#endif


#ifdef BOOT

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
////////////// boot loader (firmware upgrade, program launch) ////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//rego:;// provare senza MMC !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! o file errati
    Delay(500);
//    DispStr( 0, 0, "   mmcInit      " );
    if ( mmcInit() != mmc_noerr )
    {
//        DispStr( 0, 0, "ERROR: mmcInit  " );
//        goto rego;
        goto launch;
    }
//    DispStr( 0, 0, "   FAT_init     " );
    FAT_init();
    for ( i = 1; i <= 250; i++ )
    {
        resp = FAT_getFileName( i, fileName, &cluster, &filelen );
        if ( resp == 3 )
            continue;
        if ( resp != 0 )
            break;
        if ( i == 10 )
            DispStr( 0, 0, (char *)MSG_ATTESA );//DispStr( 0, 0, fileName );
        if ( strcmp(fileName,FIRMWAREFILE) == 0 )
        {
            DispStr( 0, 0, (char *)MSG_FW_LOADING );
            switch ( flashIntelFile( cluster, filelen ) )
            {
                case 0:     DispStr( 0, 0, (char *)MSG_FW_LOADED );     break;
                case 1:     DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );    break;
                case 2:     DispStr( 0, 0, (char *)MSG_FW_FILE_FORM );  break;
                case 3:     DispStr( 0, 0, (char *)MSG_FW_SIZE_ERR );   break;
                case 4:     DispStr( 0, 0, (char *)MSG_FW_CHK_ERR );    break;
                case 99:    DispStr( 0, 0, (char *)MSG_FW_OK );         break;
                default:    DispStr( 0, 0, (char *)MSG_FW_FLASH_FILE ); break;
            }
            break;
        }
    }

launch:;
    if ( checkFirmware() == 0 )
    {                                   // if a good firmware, jump on it
        __disable_interrupt();
        firmwareEntryPoint = (void (*)())FIRMWARESTART;
        (*firmwareEntryPoint)();
        DispStr( 0, 0, (char *)MSG_FW_EXIT );
    }
    else
        DispStr( 0, 0, (char *)MSG_FW_BAD_CRC );
                                        // else error
    while( 1 )
    {
                                        // LED blinking
        tled = GetTickCount()%400;
        if ( tled < 200 )
        {                                   // off
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else
        {                                   // red
            IO1CLR_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
    }

#else//BOOT

    
    stopInt = 1;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
////////////////////////// main program //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#if BOARDTEST
    //#########################################################################
    testBoard();
#endif
    

#ifndef __WIN32__
    DispStr( 0, 0, (char *)vendName );
    Delay(500);
    getFirmwareRelease( buf );
    DispStr( 0, 0, buf );
#endif
    keyStart();//stopInt = 0;
#ifndef __WIN32__
    Delay(500);                         // set maximum A/D value

    IO1SET_bit.P1_25 = 1;
    IO1CLR_bit.P1_26 = 1;
#endif

//////////////////////////////////////////////////////////////////////////////
// verify motor map reading back current

    checkMotorMap();
    ChangerSetTubeValue();
    
//////////////////////////////////////////////////////////////////////////////
// product selection
    lpdInit();
    lpdRecalc();
    resetAdv();
    mmdRestartAds();
//eee
//    testtempo = GetTickCount();


    tTimeoutMaxMotor = tMaxMotor[machineType].tTimeout;
    
    SET_SELECTION_STATUS(SELECTION_NO);
    
    k = 0xFF;
    an = 0xFF;
    s_machine = 0xFF;
    s_tray = 0xFF;
    s_column = 0xFF;
    inp = 0;
    initialInp = inp;
    tsinc = 0;
    tMsgDelay = 0;
    nread = 0;
    nfront = 0;
    testVend = 0;
    disDoubleTurn = FALSE;
    tTimeoutFall = 5000; tStartFall = 0;
    tTimeoutMotor = tTimeoutMaxMotor;

    timeOFF = 0L;
    if(  machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 ) 
    {
      timeOFF = testTimeOff( );
      {
          sprintf( buf, " timeoff %4dh%02d", timeOFF/60, timeOFF%60 );
          DispStr(0,0,buf);
      }   
    }
    recvDate(&dateTime);
    tReadDate = GetTickCount();
    InsertEvent( EVENT_POWER_UP, 0 );
    tLCDtimer = GetTickCount(); LCDmsg = 0;
    tPartialSelection = 0;
    inProgramm = FALSE;

    if ( doorOpen() )
        cash = 0;
                                        // loop main sempre eseguito
#if ANTI_V
    tiltXY = 0;
    frontXY = 0;
    tiltON = 0;
    oldIR = ((IO1PIN & BIT23)!=0x00) ? 1 : 0;
#endif
#if LED_DIMMING
    tiltIR = 0;

    LED_FULL_ON();
    setLedDimming();
#endif
    oldProxSensor = PROX_SENSOR();
    deltaProxSensor = 0;

    
//#ifdef CCQ
    testMMCpresence();
    BuzzerOn(500);
    if ( mmdStatus == 0 )
    {
        if ( imageLib.cnt == 0xFF || imageLib.cnt == 0 )
            sprintf( buf, "NO IMAGES LOADED" );
        else
            sprintf( buf, "LOADED %2d IMAGES", imageLib.cnt );
        DispStr(0,0,buf);
        Delay(3000);
    }
//#endif

#if ENABLE_COMM1
#else
 #if MODEM_HTTP
  #if ENABLE_TAX_PRINT
    commCfgPort( COMMp, Baud57600, WordLength8, ParitySelNone, StopBit2 );
  #else  
    if ( !modemVerify() )
    {
        commCfgPort( COMM1, Baud9600, WordLength8, ParitySelNone, StopBit1 );
    }
    else
    {
        DispStr(0,0,"  MODEM READY   ");
        Delay(1000);
    }
  #endif
    if ( zigbeeTest(COMM2) == 0 )
    {
        DispStr(0,0,"  ZIGBEE READY  ");
        Delay(1000);
    }
 #endif
#endif
    
#if MOTOR_SIMULATION == 1
    BuzzerOn(500);
    DispStr(0,0," MOTOR SIMULATOR");
    Delay(2000);
#endif
#if MDB_DEBUG
    BuzzerOn(500);
    DispStr(0,0,"--MDBline DEBUG-");
    Delay(2000);
#endif
#if ENABLE_TAX_PRINT
    BuzzerOn(500);
    DispStr(0,0,"--RECEIPT PRINT-");
    LoadBitmapLogo();
    Delay(2000);
#endif
#if ENABLE_COMM4
    BuzzerOn(500);
    DispStr(0,0,"--MIND-UCB-COMM-");
    Delay(2000);
#endif

                                        // check versions
    InitGestioneMenu();
    if ( NonVolatileSetup.setupVersion != SETUP_VERSION )
    {
        k = 0;
        an = edToggle( &k, 0, 1, (char *)MENU_NEWFWn, (char *)MENU_NEWFWy );
        if ( an == K_OK && k == 1 )
            menuInitialization(0);
        if ( NonVolatileSetup.setupVersion != SETUP_VERSION )
            saveSettings();
    }

                                        // >>>>>>>>>>>>>>>>>>>>>>>>>>>>> LOOP
    PWR_EN_ON();
    while( 1 )
    {
        mmcLogData();                   // log data on mmc if available
        lpdMode(1);
        lpdUpdate();
#if ANTI_V
        i =  ((IO1PIN & (BIT29|BIT30))!=0x00) ? 1 : 0;
        if ( i != oldXY )
        {
            oldXY = i;
            frontXY++;
            tiltXY = GetTickCount();
        }
        else
        {
            if ( tiltXY != 0 && (GetTickCount()-tiltXY) > 500 )
            {
                if ( frontXY >= 2 )
                {
                    outImage[OUT_COIN_BILL] = 0x00;// attiva uscita
                    BuzzerOn(10);
                    tiltON = GetTickCount();
                }
                frontXY = 0;
                tiltXY = 0;
            }
        }
        if( tiltON != 0 && (GetTickCount()-tiltON) > 1000 )
        {
            outImage[OUT_COIN_BILL] = 0xFF;
            tiltON = 0;
        }
////////
        i = ((IO1PIN & BIT23)!=0x00) ? 1 : 0;
        if ( i != oldIR )
        {
            oldIR = i;
            tiltIR = GetTickCount();
        }
        else
        {
            if ( tiltIR != 0 && (GetTickCount()-tiltIR) > 250 )
            {
                BuzzerOn(50);
                tiltIR = 0;
//
                tLED1 = GetTickCount();
                dutyLED1 = 0x0F;
                tLED2 = GetTickCount();
                dutyLED2 = 0;
//
            }
        }
        if ( tLED1 != 0 && (GetTickCount()-tLED1) > 3000 )
        {
            tLED1 = 0;
            dutyLED1 = 0;
        }
        if ( tLED2 != 0 && (GetTickCount()-tLED2) > 60000 )
        {
            tLED2 = 0;
            dutyLED2 = 0xFFFFFFFF;
        }
#endif
#if LED_DIMMING
        if ( !(machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800) )
        {
            if ( PROX_SENSOR() )
            {
                if ( tiltIR != 0 && (GetTickCount()-tiltIR) > 250 )
                {
                    tiltIR = 0;
                    LED_FULL_ON();
                    if ( oldProxSensor == 0 )
                        deltaProxSensor = 1;
                    oldProxSensor = 1;
                }
            }
            else
            {
                tiltIR = GetTickCount();
                oldProxSensor = 0;
            }
            if ( NonVolatileSetup.timeDimming != 0 )
            {
                if ( tLED1 != 0 && (GetTickCount()-tLED1) > (NonVolatileSetup.timeDimming*1000) )
                {
                    tLED1 = 0;
                    dutyLED1 = dimmedLED;// dimmed
                    dutyLED2 = dimmedLED;
                }
            }
            else
            {
                LED_FULL_ON();
            }
        }
#endif


        startMDB();
        /* DEBUG - ECHO COM2
        {
        char pCh;

        while( commGetChar( COMM2, &pCh) != COMM_RX_EMPTY ) commPutChar( COMM2, pCh );
        }
        DEBUG */
        if ( (GetTickCount()-tReadDate) >= 1000 )
        {
            tReadDate = GetTickCount();
            recvDate(&dateTime);
            dateTime_weekDay = weekDay( dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.min );
            flag = FALSE;
            if ( dateTime.min != lastTestTimeDisable )
            {
                testTimeDisable();
                lastTestTimeDisable = dateTime.min;
                flag = TRUE;
            }
            if ( dateTime.day != lastTestDiscount )
            {
                discount( NULL, 1, 1 );
                lastTestDiscount = dateTime.day;
                flag = TRUE;
            }
            if ( flag )
                lpdRecalc();
        }
        flag = doorOpen();
        if ( flag != doorIsOpen )
            testMMCpresence();          // door status changed, re-check mmc
        if ( flag )
        {                               // door opened
            if ( doorIsOpen == FALSE )
            {
                InsertEvent( EVENT_DOOR_OPEN, 0 );
                hostStatus(HOST_DOOR_OPEN);
                memset( &nF, 0x00, sizeof(nF.nFails) );   // unlock all selections
                if( enHome( 0 ) == 0 && ( NonVolatileSetup.DropHome & 0x01 ) )
                  homeMotors( 0 );
                saveSettings();
#if MODEM_HTTP
                if ( modemData.present )
                    modemSend = 1;      // send data through modem
                else if ( zigbeeData.avail && !DEXtransfer() )
                    zigbeeDexRequest(); // send data with zigbee request
#endif
            }
            doorIsOpen = TRUE;
        }
        else
        {                               // door closed
            if ( doorIsOpen == TRUE )
            {
                clearPhoto();
                InsertEvent( EVENT_DOOR_CLOSE, 0 );
                hostStatus(HOST_DOOR_CLOSE);
                checkMotorMap();
                ChangerSetTubeValue();
                ChangerReadTubeStatus();
                discount_doorClose();
                PWR_EN_ON();
            }
            doorIsOpen = FALSE;
            testVend = 0;
        }
#if MODEM_HTTP
        if ( modemSend )
        {
            modemSend = 0;
            modemTransfer("test");
            modemReceive = 0;
        }
        modemManager();
#endif
        hostManager();


                                        // LED blinking
#ifndef __WIN32__
        tled = GetTickCount()%5000;
        if ( tled < 1000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else if ( tled < 2000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1CLR_bit.P1_26 = 1;
        }
        else if ( tled < 3000 )
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else if ( tled < 4000 )
        {
            IO1CLR_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
        else
        {
            IO1SET_bit.P1_25 = 1;
            IO1SET_bit.P1_26 = 1;
        }
#endif

/*        
if ( FALL_SENSOR )
{
    BuzzerOn(100);
}
 */

        /*
            HANDLE PRODUCT SENSOR
        */
        if ( GetTickCount() != tsinc )
        {                               // every ms
            tsinc = GetTickCount();
            flag = 0;                   //  28.07.2010, stop motore
                                        // verifica se selezione completata (cosa
                                        // succede se si effettua una nuova selezione
            if ( tStartFall != 0 && (GetTickCount()-tStartFall) > 200 )      // prima che sia terminata tutta la sequenza)
            {
                if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_OFF )
                {                       // sensor disable, wait for home position
                    RESET_FALL_FAILS(last_s_tray,last_s_column);
                    tStartFall = 0;
                    SET_SELECTION_STATUS(SELECTION_HOMING);
                }
                else
                {                       // check sensor status
                    if ( (GetTickCount()-tStartFall) < tTimeoutFall )
                    {                   // wait for a product falling in the tTimeoutFall after motor start
                        if ( FALL_SENSOR )
                        {
                            if( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t )
                            {
                                if ( (GetTickCount()-tStartFall) > 250 )//added to avoid motor stop when fall_sensor is always activated
                                    flag = 1; // stop motor, selection OK
                                else
                                    disDoubleTurn = TRUE; // sensor already activate, standard home position
                            }
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_OK);
                        }
                    }
                    else
                    {                   // tStartFall elapsed
                        if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t)
                        {               // stop motor and set EVENT_SELECTION_FAILED
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                            flag = 1;
                        }
                        else if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_5s)
                        {               // only set EVENT_SELECTION_FAILED
                            RESET_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                        }
                        else if ( enDrop[last_s_tray][last_s_column] == FALLSENSOR_3x )
                        {               // count failures, and after MAX_SEL_FAILED selection is no more available
                            INC_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                        }
                        else // FALLSENSOR_3r, FALLSENSOR_3n, 
                        {               // retry selection, count failures, and after MAX_SEL_FAILED5 selection is no more available
                            INC_FALL_FAILS(last_s_tray,last_s_column);
                            tStartFall = 0;
                            if ( nTestFall >= MAX_SEL_FAILED5 )
                            {
                                SET_SELECTION_STATUS(SELECTION_FAILED);
                            }
                            else
                            {           // retry positioning, running motors for 150ms
                                GET_ACTIVE_MOTOR(k,an, last_s_tray,last_s_column);
                                GET_ALTERNATE_MOTOR(alt_k,alt_an, last_s_tray,last_s_column);

                                tStartFall = GetTickCount();
                                tTimeoutFall = 2000;
                                nTestFall++;

                                RESTART_CURRENT_CALCULATION();
                                STOP_MOTORS();
                                START_MOTOR(k,an,150);
                                START_ALTERNATE_MOTOR(alt_k,alt_an,150);
                                SET_SELECTION_STATUS(SELECTION_RETRY);
                            }
                        }
                    }
                }
            }

#if HOME_DEBUG//88=tick
            __disable_interrupt();
            commPutChar( COMM1, 0x88 );
            commPutChar( COMM1, GetTickCount() );
            __enable_interrupt();
#endif
                                        // test per stop del motore
            if ( RUNNING_MOTOR(k,an) )
            {
#if SLAVE_MACHINE
                if( s_machine == 2 )
                {
                    flag = 0;
                    if( (GetTickCount()-tStartMotor) > 900 )  { flag = 2; }
                    else if( (GetTickCount()-tStartMotor) > 700 )  { ATTIVA_CATODO( (k = k_mask[s_column]) );
                                                                     ATTIVA_ANODO( ( an = an_mask[s_column]) );
                                                                }
                    else if( (GetTickCount()-tStartMotor) > 200 )  { outImage[OUT_AN0_AN7] = 0xFF; outImage[OUT_SG8_SG15] = 0x00; }
                    goto ENDMA2;
                }                   
#endif
                // cerca fronte
                if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                {
                    mask = ~inImage[2];
                }
                else
                {
                    mask = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi;
                    nfront = 0xFF;      // disable test motor off (attention, not fixed for NAT147/NAT157 coupling motor)
                }
                // fronte di salita
// 28.07.2010                flag = 0;
                       // aspetta che il motore parta   &&   ( verifica variazione ingressi    ||    se supera il timeout ), ferma tutto
#if MOTOR_SIMULATION == 0
#if FULL_MOTOR
                if ( (GetTickCount()-tStartMotor) > 5*((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2)?600:300) && 
                     ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) > 5*tTimeoutMotor) )   // do not test HOMING
#else
                if ( (GetTickCount()-tStartMotor) > ((machineType==MACHINA_LCM123 || machineType==MACHINA_USIGVC2)?600:300) && 
                     ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) >   tTimeoutMotor) )   // do not test HOMING
#endif
#endif
                {                           // stop motor
#if MOTOR_SIMULATION == 0
                    if ( ++nread > 10 )
#else
                    if ( ++nread > 100 )
#endif
                    {
                        if ( (GetTickCount()-tStartMotor) > tTimeoutMotor )
                            flag = 2;// not at home
                        else
                        {
                            // se modo drop sensor FALLSENSOR_2t aspetta 2 giri prima di fermarlo se non cade prodotto
                            if( enDrop[last_s_tray][last_s_column] == FALLSENSOR_2t && motorTurns == 0 )  
                            {
                                motorTurns++ ;
                                nread = 0;
                                inp = mask;
                            }
                            // altrimenti verifica per fermare il motore
                            else
                            {
///// TEST39                                if ( inpMask == 0xFF || inpMask == 0x01 || inpMask == 0x04 || ((mask^inp)& mask & inpMask ) == inpMask )
                                if ( inpMask == 0xFF || ((mask^inp)& mask & inpMask ) == inpMask )
                                    flag = 1;// home position, stop
                                else 
                                {           // check which input is at home, and wait for the other
                                    if ( ((mask^inp)& mask & inpMask ) == 0x01 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = k;    // exchange line on NAT157
                                        else
                                            kkk = alt_k;
                                        inpMask = 0x04;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x04 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = alt_k;// exchange line on NAT157
                                        else
                                            kkk = k;
                                        inpMask = 0x01;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x40 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x40;
                                        outImage[OUT_AN0_AN7] |= 0x55;
                                        inpMask = 0x20;
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x20 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x80;
                                        outImage[OUT_AN0_AN7] |= 0xAA;
                                        inpMask = 0x40;
                                    }
                                    nread = 0;
                                    inp = mask;
                                }
                            }
                        }
                    }
                }
#if MOTOR_SIMULATION == 0
                else
                {
                    nread = 0;
                    inp = mask;
                                        // check when off home, if always the same
                                        // input, after timeout give error
                                        // if input changed, wait for antidebounce
                    if ( nfront != 0xFF )
                    {                       // !!!! only on ROWE, fix for NAT147/NAT157 if coupling motor
                        if ( initialInp == inp )
                        {
                            nfront = 0;
#if FULL_MOTOR
                            if ( (GetTickCount()-tStartMotor) > 5*T_MIN_MOTOR )
#else
                            if ( (GetTickCount()-tStartMotor) > T_MIN_MOTOR )
#endif
                            {               //disable selection
                                flag = 2;
                                DISABLE_MOTOR_MAP(k,an);
                                DISABLE_MOTOR_MAP(alt_k,alt_an);
                            }
                        }
                        else
                        {
                            if ( ++nfront > 10 )
                                nfront = 0xFF;// out of home, ok !!! disable test
                        }
                    }
                }
#endif
#if SLAVE_MACHINE
ENDMA2:
#endif
                if ( flag )
                {
                    if ( flag == 2 )
                    {                   // not at home, what we have to do ?
                        if ( prodSel.status == SELECTION_HOMING )
                            SET_SELECTION_STATUS(SELECTION_FAILED);
                    }
                    else
                    {
                        if ( prodSel.status == SELECTION_HOMING )
                        {
                            SET_SELECTION_STATUS(SELECTION_OK);
                        }
                    }
                    STOP_MOTORS();
                    k = 0xFF;
                    an = 0xFF;
                    s_machine = 0xFF;
                    s_tray = 0xFF;
                    s_column = 0xFF;
                    nfront = 0;
                    nread = 0;
                    keyFlush();
#if PRODUCT_RECOGNITION
Delay(300);
commPutChar( COMM1, 'G' );
commPutChar( COMM1, 'O' );
commPutChar( COMM1, '\x0d' );
#endif
                }
            }
        }

                                        // delete partial selection after 20s
        if ( tPartialSelection != 0 && (GetTickCount()-tPartialSelection) > 20000 )
        {
            s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
            tPartialSelection = 0;
        }

        // show error message : tMsgDelay is not zero to lock machine when dsiplaying error messages
        if ( tMsgDelay != 0 )
        {
            resetAdv();
            if ( (GetTickCount()-tMsgDelay) < 3000 )
                continue;
            tMsgDelay = 0;
        }

#if PRODUCT_RECOGNITION
        if (showImage)
        {
            mmdShowImage('H'-'A',showImage-1);
            showImage =0;
        }
#endif
/*EEE
if ( evento_just_reset )
{
    if ( (evento_just_reset&0x3F) == 0x00 )
        BuzzerOn(50);
    evento_just_reset--;
}
EEE*/
                                        // lock selection if motor running or drop sensor enabled
        kkk = testKey();
        if ( ON_SELECTING() || RUNNING_MOTOR(k,an) )
        {
            kkk = 0;
            stopInt = 1;
        }
        else
            stopInt = 0;

                                        // check for a new selection 
        if ( hostSelection( &s_machine, &s_tray, &s_column ) == 0 )
            kkk = K_Z;                  // simulate keyboard selection
        if ( kkk != 0 && (s_tray == 0xFF || s_column == 0xFF || kkk == K_Z) )
        {
            LED_FULL_ON();

#ifdef MAPPA_MOTORI
            if ( ( kkk == K_AST && machineType != MACHINA_ROWE5900 && machineType != MACHINA_ROWE6800 && doorOpen() ) ||
                 ( kkk == K_RESET && ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) && doorOpen() ) )
            {
                // visualizzazione mappa dei motori
                sprintf( buf, "MOTOR MAP---    " );
                DispStr(0,0,buf);
                while( testKey() == 0 )
                    ;
                for ( k = 0; ;  )
                {
                    if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123 || 
                         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR )
                        sprintf( buf, "K%02d   %c%c%c%c%c%c%c%c  ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.',
                                                motorMap[k][5]?'X':'.',
                                                motorMap[k][6]?'X':'.',
                                                motorMap[k][7]?'X':'.' );
                    if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
                        sprintf( buf, "K%02d  %c%c%c%c%c%c%c%c%c%c ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.',
                                                motorMap[k][5]?'X':'.',
                                                motorMap[k][6]?'X':'.',
                                                motorMap[k][7]?'X':'.',
                                                motorMap[k][8]?'X':'.',
                                                motorMap[k][9]?'X':'.' );
                    if ( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                        sprintf( buf, "K%02d   %c %c %c %c %c  ",
                                        k,
                                                motorMap[k][0]?'X':'.',
                                                motorMap[k][1]?'X':'.',
                                                motorMap[k][2]?'X':'.',
                                                motorMap[k][3]?'X':'.',
                                                motorMap[k][4]?'X':'.' );
                    DispStr(0,0,buf);

                    if ( (kkk=testKey()) != 0 )
                        k++;
                    if ( ( ( machineType == MACHINA_AP113    || machineType == MACHINA_AP7000    || machineType == MACHINA_LCM123 || machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR ) && k >= N_K_AP113 ) ||
                         ( ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 || machineType == MACHINA_AMS39 ) && k >= N_K_ROWE ) ||
                         ( ( machineType == MACHINA_NAT145   || machineType == MACHINA_NAT147   || machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147   )&& k >= N_K_NAT147 ) )
                        break;
                }
                // visualizzazione mappa ingressi
                do {
                    k = 7; mask = inImage[2];
                    do {
                        buf[k]=(mask&0x01)+'0';
                        mask >>= 1;
                    }while( k-- != 0 );
                    k = 15; mask = inImage[3];
                    do {
                        buf[k]=(mask&0x01)+'0';
                        mask >>= 1;
                    }while( k-- != 8 );
                    DispStr(0,0,buf);
                } while( testKey() == 0 );
                continue;
            }
#endif
            // input selezione
            if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 || machineType == MACHINA_USIGVC2)
            {
                if ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 ) s_machine = 1;  // not used in AMS39
                if ( s_machine == 0xFF )
                {
#if SLAVE_MACHINE
                    if ( kkk >= K_1 && kkk <= K_2 )
#else
                    if ( kkk == K_1 )
#endif
                    {
                        s_machine = kkk - K_0;
                        tPartialSelection = GetTickCount();
                    }
                }
                else
                {
                    if ( s_tray == 0xFF )
                    {
                        if ( kkk >= K_1 && kkk <= K_9 )
                        {
                            s_tray = kkk - K_1;
                            tPartialSelection = GetTickCount();
                        }
                        if ( ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 ) && kkk == K_0 && show_temp == 0 )
                            show_temp = 1;
                        else
                            show_temp = 0;         
                    }
                    else if ( kkk >= K_0 && kkk <= K_9 )
                    {
                        s_column = kkk - K_0;
                        tPartialSelection = GetTickCount();
                    }
                }
                if ( kkk == K_RESET )
                {
                    s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
                    tPartialSelection = 0;
                }
            }
            else if ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
            {
                if ( kkk >= K_0 && kkk <= K_9 && s_column == 0xFF )
                {
                    s_column = kkk - K_0;
                    tPartialSelection = GetTickCount();
                }
                else if ( kkk >= K_1 && kkk <= K_9 )
                {
                    s_tray = kkk - K_0;
                    tPartialSelection = GetTickCount();
                }
                if( kkk == K_RESET )
                {
                    s_machine = 0xFF; s_column = 0xFF; s_tray = 0xFF;
                    tPartialSelection = 0;
                }
            }
            else
            {
                if ( kkk >= K_A && kkk <= K_I )
                {
                    s_tray = kkk - K_A;
                    tPartialSelection = GetTickCount();
                }
                if ( kkk >= K_0 && kkk <= K_9 )
                {
                    s_column = kkk - K_0;
                    tPartialSelection = GetTickCount();
                 }
            }
#if SLAVE_MACHINE
            if ( s_tray != 0xFF && s_column != 0xFF && s_machine == 2 )
            {
                  tot = amount[9-1][s_column];
                  pay_selection_start( tot, s_tray, s_column );
                  k = 0xFD;  an = 0xFF; // wait selection price enable
            }
            if ( s_tray != 0xFF && s_column != 0xFF && s_machine == 1 )
#else
            if ( s_tray != 0xFF && s_column != 0xFF )
#endif
            {
#if HOME_DEBUG//00=selection
    __disable_interrupt();
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, 0x00 );
    commPutChar( COMM1, ((s_tray&0x0f)<<4)|(s_column&0x0f) );
    __enable_interrupt();
#endif
                tPartialSelection = 0;
                                        // check group selection automatic change
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    checkMotorGroupSelection(&s_column,&s_tray);
                else
                    checkMotorGroupSelection(&s_tray,&s_column);
                if(  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    flag = checkTimeFrames( s_column, s_tray );
                else
                    flag = checkTimeFrames( s_tray, s_column );
                if ( flag || isTimedDisable() )
                {
                    hostStatus(HOST_SELECTION_LOCKED);
                    k = 0xFE;
                    an = 3;
                }
                else
                {
                                        // check motor presence ...
                    GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                    GET_ALTERNATE_MOTOR(alt_k,alt_an, s_tray,s_column);
#if PRODUCT_RECOGNITION
                    procRecogTray = s_tray;
                    procRecogCol = s_column;
                    if ( s_tray == 0 )
                        mmdShowImage('H'-'A',prodRecogNum[s_column]);
                    else
                        mmdShowImage(s_tray,s_column);
                    if ( s_tray == 8 && s_column == 9 )
                    {
                        commPutChar( COMM1, 'I' );
                        commPutChar( COMM1, '9' );
                        commPutChar( COMM1, '\x0d' );
                    }
#else
                    mmdShowImage(s_tray,s_column);
#endif
#if FULL_MOTOR
    memset( motorMap, 1, sizeof(motorMap) );
#endif
                    if ( k == 99 || motorMap[k][an] == 0 )
                    {                           // ... not available
                        hostStatus(HOST_SELECTION_UNAVAIL);
                        k = 0xFE;
                        an = 0;
                    }
                    else                        // ... drive motor
                    {
                        last_s_tray = s_tray;
                        last_s_column = s_column;
                                        // verify if selection locked
                        if ( selectionLocked(last_s_tray,last_s_column) )
                        {
                            hostStatus(HOST_SELECTION_LOCKED);
                            k = 0xFE;
                            an = 1;
                        }
                        else
                        {
                            if ( !testIfMotorAvailable(k,an) )
                            {
                                hostStatus(HOST_SELECTION_UNAVAIL);
                                k = 0xFE;
                                an = 0;
                            }
                            else
                            {
                                        // test if amount available
                                if ( testVend == 0x68 )
                                    tot = 0;
                                else
                                    tot = amount[s_tray][s_column];
                                
                                SelectionData.price = tot;
#if ENABLE_DISCOUNT
                                discount( &tot, s_tray, s_column );
                                lpdRecalc();
#endif
#if ANTI_V
                                if ( tLED2 != 0 )
                                {
                                    tot = tot * 90 / 100;
                                    tot = ((tot+4)/5)*5;
                                }
                                tLED2 = 0;
#endif
#if ENABLE_TAX_VISUA
                                if ( tot != 0 )
                                {
                                    taxes.tax = (tot*NonVolatileSetup.percTax/10000);
                                    taxes.sale = tot-taxes.tax;
                                    taxes.total = tot;
                                    if ( taxes.tax == 0 )
                                        taxes.phase = GetTickCount()-2000;
                                    else
                                        taxes.phase = GetTickCount();
                                }
#endif
#if PRODUCT_RECOGNITION
commPutChar( COMM1, s_tray+'A' );
commPutChar( COMM1, s_column+'0' );
commPutChar( COMM1, '\x0d' );
#endif                                
                                pay_selection_start( tot, s_tray, s_column );
                                k = 0xFD;  an = 0xFF; // wait selection price enable
                            }
                        }
                    }
                }
            }
        }

        // wait selection price enable
        if ( k == 0xFD && an == 0xFF ) {
            switch( pay_selection( &tot ) ) {
                        // ok
                case 0: 
#if ENABLE_DISCOUNT
                        discount_count( s_tray, s_column );
                        lpdRecalc();
#endif
                        InsertEvent( EVENT_SELECTION_START, tot );
                        tStartFall = GetTickCount();
                        tTimeoutFall = 5000;
                        nTestFall = 0;
                        disDoubleTurn = FALSE;
                        hostStatus(HOST_SELECTION_START);
#if SLAVE_MACHINE
                        if( s_machine == 2 )
                        {
                            ATTIVA_CATODO( ( k = k_mask[s_tray+1]) );
                            ATTIVA_ANODO( ( an = an_mask[s_tray+1] ) );
                            tStartMotor = GetTickCount();
                            break;
                        }
#endif
                        RESTART_CURRENT_CALCULATION();
                        STOP_MOTORS();
                        GET_ACTIVE_MOTOR(k,an, s_tray,s_column);
                        GET_ALTERNATE_MOTOR(alt_k,alt_an, s_tray,s_column);
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an,tTimeoutMaxMotor);
                        activateMotor(s_tray,s_column);
                        SET_SELECTION_STATUS(SELECTION_START);
                        break;
                
                        // fail
                case 1: k = 0xFE;
                        an = 2;
                        hostStatus(HOST_SELECTION_COST);
                        break;
                        // wait
                default: break;
            }

        }
/*
        Display working informations
*/
        // if selection failed, show failure message
        if ( k == 0xFE )
        {
            if ( an == 2 )
            {
                if ( posVirgola == 2 )
                    sprintf( buf, (char *)MSG_SEL_PRICE, tot/100, tot%100 );
                else
                    sprintf( buf, (char *)" SEL.PRICE %5ld", tot );
            }
            else if (an==1||an==3)  sprintf( buf, (char *)MSG_SEL_LOCKED );
            else                    sprintf( buf, (char *)MSG_NOT_AVAILABLE );
            k = 0xFF;
            an = 0xFF;
            s_machine = 0xFF;
            s_tray = 0xFF;
            s_column = 0xFF;
            tMsgDelay = GetTickCount(); // start timer to display error messages for a fized amount of time
        }
        // handle standby messages
        else
        {
            // Prepare display amount if any amount available but no selection made
            if ( money != 0 && s_machine == 0xFF && s_tray == 0xFF && s_column == 0xFF )
            {
                if ( money == ID_TOKEN )
                    sprintf( buf, " FREE VEND TOKEN" );
                else
                    sprintf( buf, " AMOUNT   %s", currencyStr(money,6) );
                i = 1;  // msg_ID
            }
            // Prepare display "Selection - - -", no selecon made
            else if( s_machine == 0xFF && s_tray == 0xFF && s_column == 0xFF )
            {
                sprintf( buf, (char *)MSG_SELECT );
                if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 )
                    buf[11] = '-';
                displayTempFail( buf );
                i = 2;  // msg_ID
            }
            else if( show_temp )
            {
                if( HealthProblem == HEALTH_DOOR )
                    sprintf( buf, " %02dmin Temp=%3dF", 30 - (GetTickCount() - doorTimeClose )/(60L*1000L), Temperatura/100 );
                else
                    sprintf( buf, " TEMPERAT.  %3dF", Temperatura/100 );                  
//                if( NonVolatileSetup.Temperatura > 32 )
//                    buf[15] = 'F';
                tLCDtimer = GetTickCount();
                i = 4;  // msg_ID
            }
            // Prepare display "Selection X Y Z", when selection is inputted
            else
            {
                sprintf( buf, (char *)MSG_SELECT );
                if ( machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_VEI147 )
                {
                  if ( s_machine != 0xFF )  buf[11] = s_machine+'0';
                  if ( s_tray != 0xFF )     buf[13] = s_tray+'1';
                  if ( s_column != 0xFF )   buf[15] = s_column+'0';
                }
                else if ( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
                {
                  if ( s_tray != 0xFF )     buf[13] = s_tray+'1';
                  if ( s_column != 0xFF )   buf[15] = s_column+'0';
                }
                else if (  machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                {
                  if ( s_tray != 0xFF )     buf[15] = s_tray+'0';
                  if ( s_column != 0xFF )   buf[13] = s_column+'0';
                }
                else
                {
                    if ( s_tray != 0xFF )
                    {
                        buf[13] = s_tray+'A';
                        if(  (machineType == MACHINA_NAT157 || machineType == MACHINA_NAT147)&& s_tray == 8 )
                            buf[13] += 1; // salta I e passa a J
                    }
                    if ( s_column != 0xFF )
                    {
                        buf[15] = s_column+'0';
                        if ( (machineType == MACHINA_NAT145 || machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123) && s_column == 0 )
                            buf[14] = '1';
                    }
                }
                displayTempFail( buf );
                i = 3;  // msg_ID
                tLCDtimer = GetTickCount();
            }

            if( LCDmsg != i ) // if msg_ID is changed, a new message need to be displayed immediately ( at least for some time )
            {
                LCDmsg = i;
                tLCDtimer = GetTickCount();
            }
            else if( ( GetTickCount() - tLCDtimer ) > 2000 && ChangerExactChange() != 0 )
            {
                sprintf( buf, (char *)MSG_EXACT_CHANGE );
#if 0
                // debug start EEE
                if( ( GetTickCount() - tLCDtimer ) > 4000 )
                  sprintf( buf, "%1d(%1d %1d %1d) %2d.%02d", ChangerExactChange(), ChangerTubes(0), ChangerTubes(1), ChangerTubes(2), ChangeTubeValue()/100, ChangeTubeValue()%100 );
                if( ( GetTickCount() - tLCDtimer ) > 6000 ) tLCDtimer = GetTickCount();
                // debug end
#else
                if( ( GetTickCount() - tLCDtimer ) > 4000 ) tLCDtimer = GetTickCount();
#endif
            }
#if 0
            // debug start EEE
            if( ( GetTickCount() - tLCDtimer ) > 2000 && ChangerExactChange() == 0 )
            {
                sprintf( buf, "%1d(%1d %1d %1d) %2d.%02d", ChangerExactChange(), ChangerTubes(0), ChangerTubes(1), ChangerTubes(2), ChangeTubeValue()/100, ChangeTubeValue()%100 );
                if( ( GetTickCount() - tLCDtimer ) > 4000 ) tLCDtimer = GetTickCount();
            }
            // debug end
#endif
        }
#if ANTI_V
//        if( tiltON != 0 && (GetTickCount()-tiltON) < 1000 )
//        {
//            strcpy( buf, (char *)"  TILT!         " );
//        }
//        else
//            tiltON = 0;
#endif
#if 0
if( ( GetTickCount() - tLCDtimer ) > 4000 )
{
buf[ 0] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>>12)&0x0F];
buf[ 1] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>> 8)&0x0F];
buf[ 2] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing>> 4)&0x0F];
buf[ 3] = "0123456789ABCDEF"[(Change.Setup.Coin_Type_Routing    )&0x0F];
for( i = 0; i < 16-4; i++ )
{
    buf[ 4+i] = Change.TubeStatus.Tube_Status[i]+'0';
}
if( ( GetTickCount() - tLCDtimer ) > 6000 ) tLCDtimer = GetTickCount();//EEE
}
#endif

                                        // show adverting message
        showAdv( ((LCDmsg==2)&&(tMsgDelay==0)), buf );
// 2011.05.27        mmdShowAds();
        
        if ( isTimedDisable() )
            sprintf( buf, (char *)MSG_MACH_DISABLED );

#if ENABLE_TAX_VISUA
        if ( taxes.phase != 0 )
        {
            tMsgDelay = 0;
            if ( (GetTickCount()-taxes.phase) < 1000 )
                sprintf( buf, " SALE     $%s", currencyStr(taxes.sale,5) );
            else if ( (GetTickCount()-taxes.phase) < 2000 )
                            // " TAX      $xx.xx"
                sprintf( buf, " TAX      $%s", currencyStr(taxes.tax,5) );
            else if ( (GetTickCount()-taxes.phase) < 5000 )
                sprintf( buf, " TOTAL    $%s", currencyStr(taxes.total,5) );
            else
                taxes.phase = 0;
            if ( taxes.hello != 0 )
                taxes.hello = GetTickCount();// delayed message
        }
        else if ( taxes.hello != 0 )
        {
            tMsgDelay = 0;
            if ( (GetTickCount()-taxes.hello) < 1000 )
                sprintf( buf, "    Thank you   " );
            else if ( (GetTickCount()-taxes.hello) < 2000 )
                sprintf( buf, " Have a nice day" );
            else
                taxes.hello = 0;
        }
#endif

//DEB_EN();
//buf[ 0] = ' ';
//buf[ 1] = '0'+((dateTime.min/10)%10);
//buf[ 2] = '0'+((dateTime.min/ 1)%10);
//buf[ 3] = ':';
//buf[ 4] = '0'+((dateTime.sec/10)%10);
//buf[ 5] = '0'+((dateTime.sec/ 1)%10);
//buf[ 6] = ' ';

#if TEST_ADC_KEYBOARD
buf[ 0] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/1000)%10);//AP113
buf[ 1] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/ 100)%10);
buf[ 2] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/  10)%10);
buf[ 3] = '0'+(((ADkey.lastAn*1000)/ADkey.maxAn/   1)%10);
buf[ 4] = '-';
buf[ 5] = '0'+((ADkey.maxAn/ 100)%10);
buf[ 6] = '0'+((ADkey.maxAn/  10)%10);
buf[ 7] = '0'+((ADkey.maxAn/   1)%10);
buf[ 8] = '-';
buf[ 9] = '0'+((ADkey.lastAn/ 100)%10);
buf[10] = '0'+((ADkey.lastAn/  10)%10);
buf[11] = '0'+((ADkey.lastAn/   1)%10);
buf[12] = '-';
buf[13] = '0'+((AD.conv[AD_2]/ 100)%10);
buf[14] = '0'+((AD.conv[AD_2]/  10)%10);
buf[15] = '0'+((AD.conv[AD_2]/   1)%10);
#endif
/**/
#if TESTCCD        
{
static signed px = 0, py = 0, ex = 0;
DWORD filelen;
DEB_EN();
DEB_1();
#if 1
for ( filelen = 0; filelen < 5000; filelen++ );
sendSPI0( "\x08", 1 );
recvSPI0( &buf[0], 1 );
commPutChar( COMM1, buf[0] );
if ( buf[0] & 0x80 )
{
    px=0;
    ex++;
    if ( ex >= 18*18 )
    {
        ex = 0;
        sendSPI0( "\x80\x01", 2 );
        sprintf( buf, " ERR " );
        DispStr( 0, 0, buf );
        for ( filelen = 0; filelen < 5000; filelen++ );
        sendSPI0( "\x88\x00", 2 );
    }
}
else
{
    ex = 0;
    px++;
    if ( px == (18*18)-1 )
    {
        sendSPI0( "\x80\x01", 2 );
        sprintf( buf, " %ld ", GetTickCount() );
        DispStr( 0, 0, buf );
        for ( filelen = 0; filelen < 5000; filelen++ );
        sendSPI0( "\x88\x00", 2 );
    }
}
py=buf[0]&0x3F;
buf[ 6] = ':';
buf[ 5] = "0123456789ABCDEF"[(py       )&0x0F];
buf[ 4] = "0123456789ABCDEF"[(py    >>4)&0x0F];
buf[ 3] = ':';
#else
sendSPI0( "\x80\x01", 2 );
Delay(10);
sendSPI0( "\x01", 1 );
recvSPI0( &buf[0], 1 );
sendSPI0( "\x02", 1 );
recvSPI0( &buf[1], 1 );
sendSPI0( "\x03", 1 );
recvSPI0( &buf[2], 1 );
sendSPI0( "\x04", 1 );
recvSPI0( &buf[3], 1 );
sendSPI0( "\x07", 1 );
recvSPI0( &buf[4], 1 );
py += (signed char)buf[1];buf[1] = py;
px += (signed char)buf[2];buf[2] = px;
buf[15] = ' ';
buf[14] = "0123456789ABCDEF"[(buf[4]   )&0x0F];
buf[13] = "0123456789ABCDEF"[(buf[4]>>4)&0x0F];
buf[12] = ' ';
buf[11] = "0123456789ABCDEF"[(buf[3]   )&0x0F];
buf[10] = "0123456789ABCDEF"[(buf[3]>>4)&0x0F];
buf[ 9] = ' ';
buf[ 8] = "0123456789ABCDEF"[(buf[2]   )&0x0F];
buf[ 7] = "0123456789ABCDEF"[(buf[2]>>4)&0x0F];
buf[ 6] = ':';
buf[ 5] = "0123456789ABCDEF"[(buf[1]   )&0x0F];
buf[ 4] = "0123456789ABCDEF"[(buf[1]>>4)&0x0F];
buf[ 3] = ':';
buf[ 2] = "0123456789ABCDEF"[(buf[0]   )&0x0F];
buf[ 1] = "0123456789ABCDEF"[(buf[0]>>4)&0x0F];
buf[ 0] = ' ';
        DispStr( 0, 0, buf );
#endif
DEB_0();
}
#endif
/**/
#if TESTCCD
#else
        DispStr( 0, 0, buf );
#endif

                                        // verifica completamento selezione
#if ENABLE_TAX_PRINT
if ( RUNNING_MOTOR(k,an) )
goto eee;
#endif
        CHECK_SELECTION_STATUS();
        if ( prodSel.status == SELECTION_OK )
        {
            InsertEvent( EVENT_SELECTION_OK, tot );
            SET_SELECTION_STATUS(SELECTION_NO);
            hostStatus(HOST_SELECTION_OK);
#if ENABLE_TAX_PRINT
            PRINT_TAX_RECEIPT(last_s_tray,last_s_column,tot);
#endif
#if ENABLE_TAX_VISUA
            taxes.hello = GetTickCount();
#endif
        }
        else if ( prodSel.status == SELECTION_FAILED )
        {
            InsertEvent( EVENT_SELECTION_FAILED, tot );
            SET_SELECTION_STATUS(SELECTION_NO);
            hostStatus(HOST_SELECTION_FAILED);
        }
#if ENABLE_TAX_PRINT
eee:;
#endif

        
//eee
/*
        if ( (GetTickCount()-testtempo) > 2000 )
        {
            testtempo = GetTickCount();
            testimmagine ^= 1;
            if ( testimmagine & 0x01 )
                mmdShowImage( 7, 1 );
            else
                mmdShowImage( 7, 2 );
        }
*/        
        

                                        // gestione pagamenti
        money = Credit();
        // memorizza NAMA rule failure, if there is a change
        i = HealthProblem;
        if( HealthProblem == HEALTH_DOOR ) i = HEALTH_NORM;
        if( nF.HealthProblem != i )
        {
            nF.HealthProblem = i;
            saveSettings();
        }
        Audit();
        preparaDEX(TRUE);
        
        hostMoney(money);
                                        // gestione programmazione
        if ( !ON_SELECTING() )
        {
            if ( MenuSwitch() )
            {

#if 0
{//dosfs
    byte        resp;
	uint32_t    pstart, psize;
	uint8_t     pactive, ptype;
    WORD        cluster;
    DWORD       filelen, ttime;
	VOLINFO     vi;
	FILEINFO    fi;
	DIRINFO     di;
	DIRENT      de;
    DWORD       successcount;

    if ( mmcInit() == mmc_noerr )
    {
#if 0
    FAT_init();
    for ( i = 1; i <= 250; i++ )
    {
        resp = FAT_getFileName( i, (char *)fileName, &cluster, &filelen );
        if ( resp == 3 )
            continue;
        if ( resp != 0 )
            break;
         DispStr( 0, 0, (char *)fileName );
#if 1
        if ( strcmp((char *)fileName,"VISUA11.BMP") == 0 )
        {
            if ( FAT_openFile(cluster,filelen) == 0 )
            {
                DispStr( 0, 0, (char *)MSG_FW_LOADING );
                ttime = GetTickCount();
                filelen = 0;
                do {
                    resp = 100;
                    if ( FAT_getsFile(sector,&resp) != 0 )
                        break;
                    filelen += resp;
                } while( resp != 0 );
                sprintf( (char *)fileName, "%6ld  %6ld  ", (GetTickCount()-ttime), filelen );
                DispStr( 0, 0, (char *)fileName);
            }
        }
#endif
    }
#endif
	// Obtain pointer to first partition on first (only) unit
	pstart = DFS_GetPtnStart(0, sector, 0, &pactive, &ptype, &psize);
	if (pstart == 0xffffffff) {
		DispStr( 0, 0, "Cannot find first partition\n");
//		return -1;
	}

//	printf("Partition 0 start sector 0x%-08.8lX active %-02.2hX type %-02.2hX size %-08.8lX\n", pstart, pactive, ptype, psize);

	if (DFS_GetVolInfo(0, sector, pstart, &vi)) {
		DispStr( 0, 0, "Error getting volume information\n");
//		return -1;
	}

#if 1
// File read test
	if ( DFS_OpenFile(&vi, "VISUA11.BMP", DFS_READ, sector, &fi) == 0 ) 
    {
        ttime = GetTickCount();
        filelen = 0;
        do {
            if ( DFS_ReadFile(&fi, sector, fileName, &successcount, SECTOR_SIZE) )
                break;
            filelen += successcount;
        } while(successcount!=0);
        sprintf( fileName, "%6ld  %6ld  ", (GetTickCount()-ttime), filelen );
        DispStr( 0, 0, fileName);
    }
#endif
#if 0
//------------------------------------------------------------
// File write test
	if ( DFS_OpenFile(&vi, "PROVA.TXT", DFS_WRITE, sector, &fi) == 0 ) 
    {
        strcpy( fileName, "Hello world!\r\n" );
        DFS_WriteFile( &fi, sector, fileName, &successcount, strlen(fileName) );
    }

//------------------------------------------------------------
// File read test
	if (DFS_OpenFile(&vi, "PROVA.TXT", DFS_READ, sector, &fi)) {
////		printf("error opening file\n");
		return -1;
	}
    
    do {
        DFS_ReadFile(&fi, sector, fileName, &successcount, 16);
		DispStr( 0, 0, fileName);
    } while(successcount!=0);
#endif
    
/*
	// At this point, if our path was MYDIR/MYDIR2/FILE.EXT, filename = "FILE    EXT" and
	// tmppath = "MYDIR/MYDIR2".
	di.scratch = sector;
	if (DFS_OpenDir(&vi, "/", &di))
		DispStr( 0, 0, " DFS_NOTFOUND ");

	while (!DFS_GetNext(&vi, &di, &de)) {
		DispStr( 0, 0, de.name );
    }
*/    
    }//no_err
}
#endif
                inProgramm = TRUE;
                stopInt = 0;
                hostStatus(HOST_PROGRAMMING);
                GestioneMenu();
                discount( NULL, 1, 1 );
                lpdRecalc();
                clearPhoto();
                resetAdv();
                mmdRestartAds();
                hostStatus(HOST_STATUS_READY);
                lastTestTimeDisable = 0xFF;
                inProgramm = FALSE;
            }
        }
        testSaveSettings();
    }
#endif//BOOT

}                                               //  main


/*--------------------------------------------------------------------------
 | enHome:   verify if motors home position can be checked
 |                              --------------
 | In:  typeVar             type of var to be inputed
 | Out: 0       motors homing position can be checked
 |      1       motors homing position cannot be checked
 +--------------------------------------------------------------------------*/

byte            enHome( unsigned char _typeVar )
{
    if ( machineType == MACHINA_LCM123 || machineType == MACHINA_USIGVC2 )
        return 1;
    return 0;
}                                               //  enHome

/*--------------------------------------------------------------------------
 | loadSettings:load the settings from permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            initialSettings( void )
{
    memset( &NonVolatileSetup, 0x00, sizeof(NonVolatileSetup) );
    memset( &nF,        0x00,   sizeof(nF)          );
    memset( enDrop,     0x00,   sizeof(enDrop)      );
    memset( timeDisable,0,      sizeof(timeDisable) );

    NonVolatileSetup.setSingleVend = 1;//single vending
    NonVolatileSetup.slideDelay = 10;
    NonVolatileSetup.setFillTube = 0x68;//tube fill:no
    NonVolatileSetup.DropHome = 1;      // YES
    NonVolatileSetup.percDimming = 100;
}

void            loadSettings( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("set.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1, sizeof(data1)  );
    read( fileno(fin), &NonVolatileSetup, sizeof(NonVolatileSetup) );
    read( fileno(fin), nF,     sizeof(nF)     );
    read( fileno(fin), enDrop, sizeof(enDrop) );
    read( fileno(fin), &data2, sizeof(data2)  );

    if ( data1 != 0x11112222 || data2 != 0x33334444 )
    {
        memset( &NonVolatileSetup, 0, sizeof(NonVolatileSetup) );
        memset( &nF,    0,   sizeof(nF)     );
        memset( enDrop, 0,   sizeof(enDrop) );

        NonVolatileSetup.setSingleVend = 1;//single vending
        HealthProblem = nF.HealthProblem;
    }
    if ( enCOUPLING(0) != 0 )
        memset( NonVolatileSetup.motorCoupled, 0, sizeof(NonVolatileSetup.motorCoupled) );

    fclose(fin);
                                #else
    DWORD       m;
    char        marca[16];

    m = (DWORD)0x79000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp( marca, MEM_MARKER, 16 ) != 0 )
    {
        initialSettings();
        HealthProblem = nF.HealthProblem;
        return;
    }
    m += 256;
    memcpy( &NonVolatileSetup, (void *)m, sizeof(NonVolatileSetup) );
    m += 256;
    memcpy( &nF, (void *)m, sizeof(nF) );
    HealthProblem = nF.HealthProblem;
    m += 256;
    memcpy( enDrop, (void *)m, sizeof(enDrop) );
    m += 256;

    if ( enCOUPLING(0) != 0 )
        memset( NonVolatileSetup.motorCoupled, 0, sizeof(NonVolatileSetup.motorCoupled) );
    if ( NonVolatileSetup.slideDelay == 0 )
        NonVolatileSetup.slideDelay = 10;
    
    discount_reload(1);
                                #endif
}                                               //  loadSettings




/*--------------------------------------------------------------------------
 | saveSettings:save the settings on permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveSettings( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("set.bin","wb")) == NULL )
        return;

    data1 = 0x11112222;
    data2 = 0x33334444;
    write( fileno(fin), &data1, sizeof(data1)  );
    write( fileno(fin), &NonVolatileSetup, sizeof(NonVolatileSetup) );
    write( fileno(fin), &nF,    sizeof(nF) );
    write( fileno(fin), enDrop, sizeof(enDrop) );
    write( fileno(fin), &data2, sizeof(data2)  );

    fclose(fin);
                                #else
    byte        fChanged;
    DWORD       m;
    char        marca[16];

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x79000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp(marca,MEM_MARKER,16) != 0 )
        fChanged = TRUE;
    m += 256;
    NonVolatileSetup.setupVersion = SETUP_VERSION;
    if ( memcmp(&NonVolatileSetup,(void *)m,sizeof(NonVolatileSetup)) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(&nF,(void *)m,sizeof(nF)) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(enDrop,(void *)m,sizeof(enDrop)) != 0 )
        fChanged = TRUE;
    m += 256;

    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x79000;
    EraseBlock( m, 1 );
    memcpy( marca, MEM_MARKER, 16 );
    WriteFlash256( marca,  m, sizeof(marca) );                          m += 256;       // 0x0000, 0x00FF
    WriteFlash256( &NonVolatileSetup, m, sizeof(NonVolatileSetup) );    m += 256;       // 0x0100, 0x01FF
    WriteFlash256( &nF,    m, sizeof(nF)     );                         m += 256;       // 0x0200, 0x02FF
    WriteFlash256( enDrop, m, sizeof(enDrop) );                         m += 256;       // 0x0300, 0x03FF
                                #endif
}                                               //  saveSettings




/*--------------------------------------------------------------------------
 | loadAmount:  load the amount from permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            loadAmount( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("mem.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1,      sizeof(data1)   );
    read( fileno(fin), usable,      sizeof(usable)  );
    read( fileno(fin), group,       sizeof(group)   );
    read( fileno(fin), amount,      sizeof(amount)  );
    read( fileno(fin), &data2,      sizeof(data2)   );

    if ( data1 != 0x11223344 || data2 != 0x55667788 )
    {
        memset( usable,     0xFF,   sizeof(usable)  );
        memset( group,      0,      sizeof(group)   );
        memset( amount,     0,      sizeof(amount)  );
    }

    fclose(fin);
                                #else
    byte        i, j;
    DWORD       m;
    char        marca[16];

    m = (DWORD)0x78000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp( marca, MEM_MARKER, 16 ) != 0 )
        return;
    m += 256;
    memcpy( usable, (void *)m, sizeof(usable) );
    m += 256;
    for ( i = 0; i < MAXGROUP; i++ )
    {
#if GROUP_SELECTION
        memcpy( &group[i],  (void *)m, sizeof(group[0])  );
#else
        memset( &group[i],          0, sizeof(group[0])  );
#endif
        m += 256;
    }
    memcpy( amount, (void *)m, sizeof(amount) );
    maxPrice = 0; minPrice = 0xFFFF;
    for ( i = 0; i < MAXTRAY; i++ )
    {
        for ( j = 0; j < MAXCOLUMN; j++ )
        {
            if ( amount[i][j] > maxPrice )  maxPrice = amount[i][j];
            if ( amount[i][j] < minPrice )  minPrice = amount[i][j];
        }
    }
                                #endif
}                                               //  loadAmount




/*--------------------------------------------------------------------------
 | saveAmount:  save the amount on permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveAmount( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("mem.bin","wb")) == NULL )
        return;

    data1 = 0x11223344;
    data2 = 0x55667788;
    write( fileno(fin), &data1,     sizeof(data1)       );
    write( fileno(fin), usable,     sizeof(usable)      );
    write( fileno(fin), group,      sizeof(group)       );
    write( fileno(fin), amount,     sizeof(amount)      );
    write( fileno(fin), &data2,     sizeof(data2)       );

    fclose(fin);
                                #else
    byte        i, j, fChanged;
    DWORD       m;
    char        marca[16];

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x78000;
    memcpy( marca, (void *)m, sizeof(marca) );
    if ( memcmp(marca,MEM_MARKER,16) != 0 )
        fChanged = TRUE;
    m += 256;
    if ( memcmp(usable,(void *)m,sizeof(usable)) != 0 )
        fChanged = TRUE;
    m += 256;
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if ( memcmp(&group[i],(void *)m,sizeof(group[0])) != 0 )
            fChanged = TRUE;
        m += 256;
    }
    if ( memcmp(amount,(void *)m,sizeof(amount)) != 0 )
        fChanged = TRUE;
    m += 256;

    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x78000;
    EraseBlock( m, 1 );

    memcpy( marca, MEM_MARKER,16 );
    WriteFlash256( marca, m, sizeof(marca) );               m += 256;       // 0x0000, 0x00FF
    WriteFlash256( usable, m, sizeof(usable) );             m += 256;       // 0x0100, 0x01FF
    for ( i = 0; i < MAXGROUP; i++ )
    {
        WriteFlash256( &group[i],  m, sizeof(group[0]) );   m += 256;       // 0x0200, 0x0BFF
    }
    WriteFlash256( amount, m, sizeof(amount) );             m += 256;       // 0x0C00, 0x0CFF
                                #endif
    maxPrice = 0; minPrice = 0xFFFF;
    for ( i = 0; i < MAXTRAY; i++ )
    {
        for ( j = 0; j < MAXCOLUMN; j++ )
        {
            if ( amount[i][j] > maxPrice )  maxPrice = amount[i][j];
            if ( amount[i][j] < minPrice )  minPrice = amount[i][j];
        }
    }
    
}                                               //  saveAmount




/*--------------------------------------------------------------------------
 | loadGroup:  load the amount from permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            loadGroup( void )
{
                                #ifdef __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("memGroup.bin","rb")) == NULL )
        return;

    read( fileno(fin), &data1,      sizeof(data1)       );
    read( fileno(fin), &selGroup,   sizeof(selGroup)    );
    read( fileno(fin), &timeFrames, sizeof(timeFrames)  );
    read( fileno(fin), &timeDisable,sizeof(timeDisable) );
    read( fileno(fin), &data2,      sizeof(data2)       );

    if ( data1 != 0x11223344 || data2 != 0x55667788 )
    {
        memset( selGroup,   0,      sizeof(selGroup)    );
        memset( timeFrames, 0,      sizeof(timeFrames)  );
        memset( timeDisable,0,      sizeof(timeDisable) );
    }

    fclose(fin);
                                #else
    byte        i;
    DWORD       m;

    m = (DWORD)0x7C000;
    memset( selGroup,          0, sizeof(selGroup) );
    for ( i = 0; i < MAXGROUP; i++ )
    {
#if GROUP_SELECTION || SEL_LOCKOUT
        memcpy( &selGroup[i],  (void *)m, sizeof(selGroup[0])  );
#endif
        m += 256;
    }
    memcpy( &timeDisable[0], (void *)m, sizeof(timeDisable)  );
    m += 256;
#if GROUP_SELECTION
    memcpy( &timeFrames[0], (void *)m, sizeof(timeFrames)  );
    m += 256;
#endif

    mmdImageLibBuild();
                                #endif
}                                               //  loadGroup




/*--------------------------------------------------------------------------
 | saveGroup:  save the amount on permanent memory
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            saveGroup( void )
{
                                #ifdef  __WIN32__
    FILE        *fin;
    DWORD       data1, data2;

    if ( (fin=fopen("memGroup.bin","wb")) == NULL )
        return;

    data1 = 0x11223344;
    data2 = 0x55667788;
    write( fileno(fin), &data1,     sizeof(data1)       );
    write( fileno(fin), selGroup,   sizeof(selGroup)    );
    write( fileno(fin), timeFrames, sizeof(timeFrames)  );
    write( fileno(fin), timeDisable,sizeof(timeDisable) );
    write( fileno(fin), &data2,     sizeof(data2)       );

    fclose(fin);
                                #else
    byte        i, fChanged;
    DWORD       m;

                                        // check if memory changed before saving
    fChanged = FALSE;
    m = (DWORD)0x7C000;
    for ( i = 0; i < MAXGROUP; i++ )
    {
        if ( memcmp(&selGroup[i],(void *)m,sizeof(selGroup[0])) != 0 )
            fChanged = TRUE;
        m += 256;
    }
#if GROUP_SELECTION
    if ( memcmp(&timeFrames[0],(void *)m,sizeof(timeFrames)) != 0 )
        fChanged = TRUE;
    m += 256;
#endif
    if ( memcmp(&timeDisable[0],(void *)m,sizeof(timeDisable)) != 0 )
        fChanged = TRUE;
    m += 256;

    if ( !fChanged )
        return;                         // memory not changed, exit


    m = (DWORD)0x7C000;
    EraseBlock( m, 1 );

    for ( i = 0; i < MAXGROUP; i++ )
    {
        WriteFlash256( &selGroup[i],  m, sizeof(selGroup[0]) );         m += 256;       // 0x0000, 0x09FF
    }
    WriteFlash256( &timeDisable[0], m, sizeof(timeDisable) );           m += 256;       // 0x0A00, 0x0AFF
#if GROUP_SELECTION
    WriteFlash256( &timeFrames[0],  m, sizeof(timeFrames) );            m += 256;       // 0x0B00, 0x0BFF
#endif
                                #endif
}                                               //  saveGroup




/*--------------------------------------------------------------------------
 | homeMotors:  homing motors
 |                              --------------
 | In:  all     0   check if motor at home don't move
 |              1   force motor homing
 | Out:
 +--------------------------------------------------------------------------*/

void            homeMotors( char all )
{
#ifndef __WIN32__
    char        i, r, j, k, an, buf[17], kkk;
    char        alt_k, alt_an;
    DWORD       tsinc, tStartMotor, inp, mask, oldmask, debcnt, tTimeoutMotor, inpMask;
#if FULL_MOTOR
    memset( motorMap, 1, sizeof(motorMap) );
    return ;
#endif

    if ( machineType == MACHINA_LCM123 )
        return;                         // LCM123 doesn't home motors !
    
#if LED_DIMMING
    DWORD       saveDimming;
    saveDimming = dutyLED2;
    dutyLED1 = dutyLED2 = 0;
#endif
    lpdMode(0);
    for( r = 0; r < 10; r++ )
    {
        for( j = 0; j < 10; j++ )
        {
            GET_ACTIVE_MOTOR(k,an, r,j);
            if( machineType == MACHINA_AMS39 || machineType == MACHINA_USIGVC2 )
            {
                alt_k = alt_an = 0xFF;
            }
            else
            {
                GET_ALTERNATE_MOTOR(alt_k,alt_an, r,j);
            }
            if ( k == 99 && an == 9 )
                continue;
            if ( motorMap[k][an] != 0 )
            {
                PWR_EN_ON();

                sprintf( buf, "HOMING X:%2d Y:%2d", k, an );
                DispStr( 0, 0, buf );
                Delay(30);  // delay between motor activation

                if( machineType == MACHINA_USIGVC2 )    // there is no HONE posiztion switch
                {
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                }
                else if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) // verificare || machineType == MACHINA_USIGVC2
                {
                    ATTIVA_ANODO( an );
                    Delay(4);
                    if( ( inImage[2] & ( 1 << ( 7 - k ) ) ) == 0 )
                    {
                        STOP_MOTORS();
                        continue;
                    }
                    START_MOTOR(k,an,tTimeoutMaxMotor);
                    START_ALTERNATE_MOTOR(alt_k,alt_an,tTimeoutMaxMotor);
                }
                else if( machineType == MACHINA_NAT145 || machineType == MACHINA_NAT147 || machineType == MACHINA_AP113 || 
                         machineType == MACHINA_AP7000 || machineType == MACHINA_LCM123 || machineType == MACHINA_NAT157 || 
                         machineType == MACHINA_AP123 || machineType == MACHINA_VEIDOOR || machineType == MACHINA_AMS39 || machineType == MACHINA_VEI147 )
                {                    
                    if ( all == 0 )
                    {                   // check if motor homed
#if HOME_DEBUG//55=home motor test
                        commPutChar( COMM1, 0x55 );
                        commPutChar( COMM1, ((k&0x0f)<<4)|(an&0x0f) );
#endif
                        __disable_interrupt();
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an,tTimeoutMaxMotor);
                        testMotorHoming = 2;//must be after START_MOTOR
                        __enable_interrupt();
                        Delay(4);
                        if ( IS_PWR_OFF() )
                        {
                            STOP_MOTORS();    // already at home ( tested at interrupt ), do nothing
                            Delay(4);
                            testMotorHoming = 0;
                            PWR_EN_ON();
                            continue;
                        }
                        testMotorHoming = 0;
                        if ( machineType == MACHINA_AP113 || machineType == MACHINA_AP7000 || 
                             machineType == MACHINA_LCM123 || machineType == MACHINA_AMS39 )
                        {
                            RESTART_CURRENT_CALCULATION();
                            START_MOTOR(k,an,tTimeoutMaxMotor);
                            START_ALTERNATE_MOTOR(alt_k,alt_an,tTimeoutMaxMotor);
                        }
                    }
                    else
                    {                   // force motor homing
                        START_MOTOR(k,an,tTimeoutMaxMotor);
                        START_ALTERNATE_MOTOR(alt_k,alt_an,tTimeoutMaxMotor);
                    }
                }
                oldmask = inp;
                debcnt = 0;

                              // cerca fronte
                tsinc = GetTickCount();
                do
                {
                    while( GetTickCount() == tsinc );   // every ms
                    tsinc = GetTickCount();

                    if( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 )
                    {
                        mask = ~inImage[2];
                    }
                    else
                    {
                        mask = ((INP0)?0x01:0x00) | ((INP2)?0x04:0x00) | INPi;
                    }
                    if ( (GetTickCount()-tStartMotor) < 300 )
                        inp = mask;

                    if( mask == oldmask )
                    {
                        if( debcnt >= 25 )
                        {
#if MOTOR_SIMULATION == 0
                            if ( ((mask^inp)& mask & inpMask ) != 0x00 || (GetTickCount()-tStartMotor) > tTimeoutMotor )
#endif
                            {                           // stop motor
                                if ( inpMask == 0xFF || ((mask^inp)& mask & inpMask ) == inpMask )
                                {
                                    STOP_MOTORS();
                                    k = 0xFF; an = 0xFF;
                                }
                                else 
                                {           // check which input is at home, and wait for the other
                                    if ( ((mask^inp)& mask & inpMask ) == 0x01 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = k;    // exchange line on NAT157
                                        else
                                            kkk = alt_k;
                                        inpMask = 0x04;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x04 )
                                    {
                                        if ( machineType == MACHINA_NAT157 || machineType == MACHINA_VEI147 )
                                            kkk = alt_k;// exchange line on NAT157
                                        else
                                            kkk = k;
                                        inpMask = 0x01;
                                        STOP_SINGLE_MOTOR(kkk);
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x40 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x40;
                                        outImage[OUT_AN0_AN7] |= 0x55;
                                        inpMask = 0x20;
                                    }
                                    else if ( ((mask^inp)& mask & inpMask ) == 0x20 )
                                    {
                                        outImage[OUT_SG8_SG15] |= 0x80;
                                        outImage[OUT_AN0_AN7] |= 0xAA;
                                        inpMask = 0x40;
                                    }
                                    debcnt = 0;
                                }
                            }
                            inp = mask;                              
                        }
                        else
                            debcnt++;
                    }
                    else
                        debcnt = 0;

                    oldmask = mask;

                } while( RUNNING_MOTOR(k,an) );
#if MOTOR_SIMULATION == 0
                Delay(200);  // delay between motor activation
#endif
            }
        }
    }
    
#if LED_DIMMING
    dutyLED1 = dutyLED2 = saveDimming;
#endif
    lpdMode(1);
#endif
}                                               //  homeMotors

void  displayTempFail( char *buf )
{
    if( HealthProblem == HEALTH_FAIL )
    {
        if( doorOpen() )
            sprintf( buf, (char *)MSG_TEMP_FAIL );
        else
            buf[8] = '*';
    }
}
