/***************************************************************************
 ************************						****************************
 ************************	  M M C . C	        ****************************
 ************************						****************************
 ***************************************************************************/
#define	__MMC_C

#include  "def.h"
#include  <stdio.h>
#include  <string.h>
#include "ram.h"
#include "hwinit.h"
#include "DISPLAY.H"
#include "lcd7seg.h"
#include "funzioni.h"
#include "timer.h"
#include "mci.h"
#include "mmc.h"
#include "fat.h"
#include "dosfs.h"

byte	hexDump( char *d, char *s );


word			mmcTimeout, maxWriteWait;			// Timeout in 8xSPI clock
char			mmcEraseBuff[8192];
word			mmcEraseSize;
byte            cardType;

unsigned long	mmcGroupMask;
unsigned long	mmcParam;

// DEBUG
char			lastCmd, lastAns, sTmpF[80], sTmp[80];
unsigned long	lastAddr;
#define   mmc_DISABLE( )
#define   mmc_ENABLE( )
// DEBUG

char			mmcDebug;

// definizione strutture mmc: il dettaglio DIPENDE DALLA ENDIANESS DELLA CPU
unsigned long           OCR;
union	sCID 		CID;
union	sCSD 		CSD;

#define		R1			1
#define		R1b			2
#define		R2                      3
#define		R3			4

#define		GO_IDLE_STATE		0
#define         SEND_OP_COND		1
#define         ALL_SEND_CID		2
#define         SET_REL_ADDR            3
#define         SET_DSR                 4
#define         SELECT_DESELECT         7
#define     SEND_IF_COND    8
#define		SEND_CSD		9
#define		SEND_CID		10
#define		STOP_TRANSMISSION	12
#define		SEND_STATUS		13
#define		SET_BLOCKLEN		16
#define		READ_SINGLE_BLOCK	17
#define		READ_MULTIPLE_BLOCK	18
#define		SET_BLOCK_COUNT		23
#define		WRITE_BLOCK		24
#define		WRITE_MULTIPLE_BLOCK    25
#define		PROGRAM_CSD		27
#define		SET_WRITE_PROT		28
#define		CLR_WRITE_PROT		29
#define		SEND_WRITE_PROT		30
#define		TAG_SECTOR_START	32
#define		TAG_SECTOR_END		33
#define		UNTAG_SECTOR		34
#define		TAG_ERASE_GROUP_START   35
#define		TAG_ERASE_GROUP_END	36
#define		UNTAG_ERASE_GROUP	37
#define		ERASE			38
#define     SEND_APP_OP_COND    41      /* ACMD41 for SD card */		
#define		LOCK_UNLOCK		42
// only SPI mode
#define     SEND_APP_CMD        55
//#define		GEN_CND			56
//#define		READ_OCR		58
//#define		CRC_ON_OFF		59

#define         MMC_Ncr                 64  // timeout for CMD response


#define printLOW( a, b )
#define print_2( a )

void			printErr( void )
{
	printLOW( (byte *)Font_16x16, sTmp );
}

void            DISK_LED_ON( void )                   
{
    IO1SET_bit.P1_25 = 1;
    IO1CLR_bit.P1_26 = 1;
}
void            DISK_LED_OFF( void )                  
{
    IO1SET_bit.P1_25 = 1;
    IO1SET_bit.P1_26 = 1;
}



/***************************************************************************
 SECTOR2ADDR:convert sector index to MMC address
								--------------
 In:      	_sect
 var:
 Out:	   	unsigned long
 Call:
 ***************************/

unsigned long SECTOR2ADDR( unsigned long _sect )
{
    if ( cardType == SDHC_CARD )
        return _sect;
    return _sect * SECTOR_SIZE;
}



/***************************************************************************
 ADDR2SECTOR:address to sector conversion
								--------------
 In:      	_addr
 var:
 Out:	   	unsigned long
 Call:
 ***************************/

unsigned long ADDR2SECTOR( unsigned long _addr )
{
    if ( cardType == SDHC_CARD )
        return _addr / SECTOR_SIZE;
    return _addr;
}            
            
/***************************************************************************
 mmcWaitBusy:			attende termine busy su mmc
								--------------
 In:      	timeout in cicli di attesa ( circa 8 clock SPI per ciclo )
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/

MMCERR			mmcWaitBusy( word t )				// attende busy per il timeout passato
{
//	word maxT;
//
	t = 30000;
//
//	maxT = t;
	do
	{
//		U2TB = 0xFF; while( !(U2C1 & SCI_RI ) );	// wait data
		if( t-- == 0 )
		{
			mmc_DISABLE();
//			sprintf( sTmpF, "mmcWait  %04X %04x", maxT, lastAns ); printLOW( (byte *)Font_16x16, sTmpF );          // DEBUG
//			sprintf( sTmpF, "mmcWait1 %04X %08lX", lastCmd, lastAddr ); printLOW( (byte *)Font_16x16, sTmpF );	  	// DEBUG
			return( mmcerr = mmc_err_timeout );		// timeout error
		}
	}while( /*(char)U2RB == */ 0x00 ); 					// busy
	mmc_DISABLE();
/* DEBUG
	if( ( maxT-t ) > maxWriteWait )
	{
		maxWriteWait = ( maxT-t );
		sprintf( sTmp, "mmcWait %04X %04X", maxT, maxWriteWait ); printLOW( (byte *)Font_16x16, sTmp );
	}
// DEBUG */
	return( mmcerr = mmc_noerr );
}




/***************************************************************************
 mmcCmd:			manda comando ad MMC ed attende risposta
								--------------
 In:
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/
const byte response_type[64] = {
//                0   1   2   3   4   5   6    7   8    9    A    B    C    D    E    F  
                  0, R3, R2, R1,  0,  0,  0, R1b,  0,  R2,  R2,  R1, R1b,  R1,   0,   0,        // 0
				 R1, R1, R1,  0, R1,  0,  0,  R1, R1,  R1,  R1,   0, R1b, R1b,  R1,   0,        // 1
				 R1, R1, R1, R1, R1, R1,R1b,   0,  0,  R3, R1b,   0,   0,   0,   0,   0,        // 2
				  0,  0,  0,  0,  0,  0,  0,   0,  0,   0,   0,   0,   0,   0,   0,   0   };    // 3

unsigned long swapDword( unsigned long _dword )
{
    return  ((_dword&0xFF000000)>>24)|
            ((_dword&0x00FF0000)>> 8)|
            ((_dword&0x0000FF00)<< 8)|
            ((_dword&0x000000FF)<<24);
}

MMCERR          _mmcCmd_( byte cmd, tParam param )
{
#ifndef __WIN32__
    unsigned long st;

    if ( cmd > 0x3f )
        return( mmcerr = mmc_err_illegal );

//	if( response_type[ cmd ] == 0 )
//		return( mmcerr = mmc_err_illegal );

    mmcParam = param;
// DEBUG
    lastCmd = cmd;
    lastAddr = param;
// DEBUG
    mmc_ENABLE();
    MCICLEAR = MCISTATUS;               // reset MCISTATUS
    MCIARGUMENT = param;                // set param
    MCICOMMAND =  cmd |                 // set command
                    ( (response_type[ cmd ] == 0  )?0x00:0x40 ) |
                    ( (response_type[ cmd ] == R2 )?0x80:0x00 ) |
                    0x400;              // send CMD
    do {
        st = MCISTATUS;
        if ( (st & MCI_CMD_CRC_FAIL) != 0 )
        {
            if ( response_type[cmd] == R3 )
                break;
            mmc_DISABLE();
            return( mmcerr = mmc_err_crc );
        }
        if ( response_type[cmd] != 0 && (st & MCI_CMD_TIMEOUT) != 0 )   // fixed 64 clock
        {
            mmc_DISABLE();
            return( mmcerr = mmc_err_timeout );
        }
        if ( response_type[cmd] == 0 && (st & MCI_CMD_SENT) != 0  )
        {
            return( mmcerr = mmc_noerr );
        }
    } while( response_type[cmd] != 0 && (st & MCI_CMD_RESP_END) == 0 );	// wait end of comand

	switch( response_type[cmd] )
	{
		case R1:    return( mmcerr = ( (MMCERR)MCIRESPCMD & mmc_err_mask ) ); 

		case R1b:   if ( (mmcerr=((MMCERR)MCIRESPCMD)) != mmc_noerr )
                        return mmcerr;
                    return mmcWaitBusy(CSD.R2W_FACTOR*mmcTimeout*mmcEraseSize);

		case R2:    if( cmd == SEND_CSD || cmd == ALL_SEND_CID )
                    {  
                        CSD.CSD[0] = swapDword(MCIRESPONSE0);//127-96//31-0
                        CSD.CSD[1] = swapDword(MCIRESPONSE1);//95-64
                        CSD.CSD[2] = swapDword(MCIRESPONSE2);//63-32
                        CSD.CSD[3] = swapDword(MCIRESPONSE3);//31-1
                        return( mmcerr = mmc_noerr );
                    }
                    if( cmd == SEND_CID )
                    {  
                        CID.CID[0] = swapDword(MCIRESPONSE0);
                        CID.CID[1] = swapDword(MCIRESPONSE1);
                        CID.CID[2] = swapDword(MCIRESPONSE2);
                        CID.CID[3] = swapDword(MCIRESPONSE3);
                        return( mmcerr = mmc_noerr );
                    }
					break;

		case R3:    OCR = MCIRESPONSE0;
                    return( mmcerr = ~OCR & 0x80000000 ); // READY

		default : break;
	}
	mmc_DISABLE();
#endif
	return( mmcerr = mmc_err_illegal );
}                                               //  _mmcCmd_

MMCERR          mmcCmd( byte cmd, tParam param )
{
    if( _mmcCmd_( cmd, param ) != mmc_noerr && mmcDebug )
    {
//        sprintf( sTmpF, "mmcCmd %02X %08lX %04X", cmd, param, mmcerr );
//        printLOW( (byte *)Font_16x16, sTmpF );
    }
    return mmcerr;
}


/***************************************************************************
 mmcRead:			legge dati da mmc, segue un comando valido di read
								--------------
 In:
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/

#if 0
MMCERR			_mmcRead_( byte *buf, word count )
{
								#if	!SIMULATORE
	word i;
	char *pBuf, ch;

//	i = (char)U2RB;         			// reset RI
	i = mmcTimeout;						// timeout
	do
	{
//		U2TB = 0xFF;	while( !(U2C1 & SCI_RI ) );		// wait data Token
		if( i-- == 0 )
		{
			mmc_DISABLE();
			return( mmcerr = mmc_err_timeout );	// timeout error
		}
	}while( /* ( ch = (char)U2RB ) == */ 0xFF );

	mmcCache = 0L;
	if( ch == 0xFE )
	{
		i = count;
		pBuf = buf;
		while( i-- != 0 )
		{
//			U2TB = 0xFF;	while( !(U2C1 & SCI_RI ) );
//			crc16( *pBuf++ = (char)U2RB );
		};
//		U2TB = 0xFF;	while( !(U2C1 & SCI_RI ) );
//		crc16( (char)U2RB );
//		U2TB = 0xFF;	while( !(U2C1 & SCI_RI ) );
//		crc16( (char)U2RB );
		mmc_DISABLE();
//		if( iCrc16 == 0 )
		{
			mmcCache = mmcParam;
			return( mmcerr = mmc_noerr );
		}
//		else
			return( mmcerr = mmc_err_crc );
	}
	mmcerr = mmc_err_unknown;
	if( ch & 0xE0 )
	{
		if( ch & 0x10 )	mmcerr |= mmc_err_locked;
		if( ch & 0x08 )	mmcerr |= mmc_err_out_rng;
		if( ch & 0x04 )	mmcerr |= mmc_err_ecc;
		if( ch & 0x02 )	mmcerr |= mmc_err_cc;
	}
	mmc_DISABLE();
	return( mmcerr );
								#endif
	return( mmc_noerr );
}


MMCERR mmcRead( byte *buf, word count )
{
	if( _mmcRead_( buf, count ) != mmc_noerr && mmcDebug )
	{
//		sprintf( sTmpF, "mmcRead %08lX %04X", lastAddr, mmcerr );
//		printLOW( (byte *)Font_16x16, sTmpF );
	}
	return( mmcerr );
}
#endif

/***************************************************************************
 mmcReadBlock:			legge singolo bloccoo dati dati da mmc, segue un comando valido di read
								--------------
 In:
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/

MMCERR			mmcReadBlock( long addr )
{
    int         blockLen, retry, rit;
    byte        cpBuff[SECTOR_SIZE];
    
    for ( retry = 0; retry < 0x100; retry++ )
    {
        DISK_LED_ON();
        blockLen = sizeof(mmcBuff);
        if ( MCI_Read_Block(addr,cpBuff,&blockLen) != TRUE )
            continue;

        blockLen = sizeof(mmcBuff);
        if ( MCI_Read_Block(addr,mmcBuff,&blockLen) != TRUE )
            continue;

        DISK_LED_OFF();
        if ( memcmp(cpBuff,mmcBuff,sizeof(mmcBuff)) == 0 )
            return mmc_noerr;

        BuzzerOn(100);
        for ( rit = 0; rit < 30000; rit++ );
    }
    DISK_LED_OFF();
    return mmc_err_unknown;
}

/***************************************************************************
 mmcWriteBlock:			legge singolo bloccoo dati dati da mmc, segue un comando valido di read
								--------------
 In:
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/

MMCERR			mmcWriteBlock( long addr )
{
    int         blockLen, retry, rit, maxretry;

    DISK_LED_ON();    
    
    maxretry = 0;
    for ( retry = 0; retry < 0x100; retry++ )
    {
        blockLen = sizeof(mmcBuff);
        if ( MCI_Write_Block(addr,mmcBuff,&blockLen) == TRUE )
        {
            if ( maxretry > 16 )
                BuzzerOn(100);
            DISK_LED_OFF();
            return mmc_noerr;
        }

        for ( rit = 0; rit < 30000; rit++ );
        maxretry++;
    }
    DISK_LED_OFF();
    return mmc_err_unknown;
}

/***************************************************************************
 mmcWrite:			scrive su mmc, segue un comando valido di write
								--------------
 In:
 var:
 Out:	   	errore, aggiornando anche mmcerr
 Call:
 ***************************/

#if 0
MMCERR			_mmcWrite_( byte *buf, word count )
{
	word i;
	char *pBuff, ch;

//	U2TB = 0xFF;	while( !(U2C1 & SCI_TI ) );		// Nwr time
//	U2TB = 0xFE;	while( !(U2C1 & SCI_TI ) );		// Data Token
	pBuff = buf;
	for( i = count; i >0 ; i-- )                   	// data block
	{
//		crc16( U2TB = *pBuff++ );	while( !(U2C1 & SCI_TI ) );
	}
//	U2TB = ( iCrc16 >> 8 );	while( !(U2C1 & SCI_TI ) ); 	// Crc high
//	U2TB = ( char ) iCrc16;	while( !(U2C1 & SCI_TI ) );    	// Crc low
//	while( !(U2C0 & SCI_TXEPT ) );					// wait end of character

//	i = (char)U2RB;         						// reset RI
//	U2TB = 0xFF; while( !(U2C1 & SCI_RI ) );		// wait data response
	switch( /* ( lastAns = (char)U2RB & 0x1f ) */ 0 )
	{
		case 0x05:  break;
		case 0x0B:  mmc_DISABLE();
					return( mmcerr = mmc_err_crc );
		case 0x0D:  mmc_DISABLE();
					return( mmcerr = mmc_err_wp );			// usato come Write Error
		default:    mmc_DISABLE();
					return( mmcerr = mmc_err_unknown );
	}

	return( mmcWaitBusy(  2 * CSD.R2W_FACTOR * mmcTimeout ) );
}

MMCERR mmcWrite( byte *buf, word count )
{
	if( _mmcWrite_( buf, count ) != mmc_noerr && mmcDebug )
	{
//		sprintf( sTmpF, "mmcWrite %08lX %04X", lastAddr, mmcerr );
//		printLOW( (byte *)Font_16x16, sTmpF );
	}
	return( mmcerr );
}
#endif

/***************************************************************************
 mmcEraseGroup : cancella un gruppo di blocchi
								--------------
 In: 		indirizzo di un byte nel gruppo da cancellare
 var:
 Out:
 Call:
 ***************************/

MMCERR		mmcEraseGroup( long addr )
{
	// erase data groups
	if( mmcCmd( TAG_ERASE_GROUP_START, addr ) != mmc_noerr )
		return( mmcerr );
	if( mmcCmd( TAG_ERASE_GROUP_END, addr ) != mmc_noerr )
		return( mmcerr );
	return( mmcCmd( ERASE, addr ) );
}


/***************************************************************************
 mmcInit:			inizializza strutture dati che dipendono dalla multi media card
								--------------
 In:
 var:
 Out:
 Call:
 ***************************/

byte const tabtaac[16] = { 0, 10, 12, 13, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 70, 80 };
int  const tabocr[25] = { 360, 350, 340, 330, 320, 310, 300, 290, 280, 270, 260, 250, 240, 230,
						  220, 210, 200, 190, 180, 170, 165, 160, 155, 150, 145 };
MMCERR          mmcInit( void)
{
	byte        locked;

    //////////////////////////////////////////////////////////////////////////
    // MMC initialization

	memset( ( void *)&BTB, 0, sizeof( BTB ) );
	memset( ( void *)&CID, 0, sizeof( CID ) );
	memset( ( void *)&CSD, 0, sizeof( CSD ) );
	mmcDebug = 0;	                    // DEBUG per debug mettere a 1.
    locked = 0;

    DEBUG_MCI( "   MCI_init     " );
    MCI_Init();
    DEBUG_MCI( "  MCI_CardInit  " );
    if ( (cardType=MCI_CardInit()) == CARD_UNKNOWN )
    {
        DEBUG_MCI( "ERROR:MCI_CardIn" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }
    DEBUG_MCI( "   MCI_Check_CID" );
	if ( MCI_Check_CID() != TRUE )
    {
        DEBUG_MCI( "ERROR:MCI_CheckC" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }
    DEBUG_MCI( "   MCI_Set_Addre" );
	if ( MCI_Set_Address() != TRUE )
    {
        DEBUG_MCI( "ERROR:MCI_Set_Ad" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }
	if ( MCI_Send_CSD(&CSD) != TRUE )
    {
        DEBUG_MCI( "ERROR:MCI_Send_C" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }
	if ( MCI_Select_Card() != TRUE )
    {
        DEBUG_MCI( "ERROR:MCI_Select" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }
/*EEE*/
#if 0
    if ( cardType == SD_CARD )
    {
		MCICLOCK |= (1 << 11);		/* Use wide bus for SD */
		for ( i = 0; i < 0x20; i++ );
		if ( MCI_Send_ACMD_Bus_Width( BUS_WIDTH_4BITS ) == FALSE )
		{
			while ( 1 );	/* fatal error */
		}
    }
#endif
/*EEE*/        
    
	if ( MCI_Set_BlockLen( BLOCK_LENGTH ) != TRUE )
    {
        DEBUG_MCI( "ERROR:MCI_Set_Bl" );
		return (mmcerr=mmc_err_unknown);// fatal error
    }


    Set_MCIClock( NORMAL_RATE );


#if 0
	i = tabtaac[ CSD.TAAC >> 3 ];		// calcola timeout per read
	switch( tabtaac[ ( CSD.TAAC & 0x07 ) / 3 ] )
	{
		case 0: lt = i; break;
		case 1: lt = i*1000L; break;
		default:lt = i*1000000L; break;
	}
	switch( ( CSD.TAAC & 0x07 ) % 3 ){
		case 0: lt /= 10L; break;
		case 2: lt *= 10L; break;
		default: break;
	};
//	SPIperiod = 2000000L * ( FREQ / 8 / SPISpeed / 2 ) / ( FREQ /8 / 1000L );	// calcola esattamente SPI period in ns, tenendo conto
							// dei troncamenti causati dal calcolo sugli interi
//	lt /= SPIperiod;			// converte in cicli di clock
	lt += ( 100L*CSD.NSAC );	// somma NSAC
	mmcTimeout = lt/8;			// timeout totale in clock SPI

	i = ( CSD.C_SIZE_MULT_H << 1 ) | CSD.C_SIZE_MULT_L ;
	mmcCapacitySectors = ( 1L + ( ( (unsigned long)CSD.C_SIZE_H << 10 ) | ((unsigned long)CSD.C_SIZE << 2 ) ) ) << ( 2 + i );

	i = ( CSD.ERASE_GRP_MULT_H << 3 ) | CSD.ERASE_GRP_MULT_L ;
	mmcEraseSize = (word)( i + 1 ) * (word)(CSD.ERASE_GRP_SIZE +1 );

	// test if File system is present
	if( CSD.FILE_FORMAT_GRP != 0 || CSD.FILE_FORMAT != 0 )
		return( mmcerr = mmc_err_unknown );

	// unlock, if locked

	locked = 0;
	if( ( mmcCmd( SEND_STATUS, 0L ) & 0xFF00 ) != mmc_noerr )
		return( mmcerr );
	if( mmcerr & mmc_err_locked )		   					// locked? NO, exit
	{
		if( mmcCmd( SET_BLOCKLEN, 18L ) != mmc_noerr )        	// YES, test PWD
			return( mmcerr );
		if( mmcCmd( LOCK_UNLOCK, 0L ) != mmc_noerr )
			return( mmcerr );
//		memcpy( sTmp, PWD, sizeof( PWD ) );
		if( mmcWrite( sTmp, 18 ) != mmc_noerr )
			return( mmcerr );
		if( mmcCmd( SET_BLOCKLEN, 512L ) != mmc_noerr )        			// YES, reset block lengh
			return( mmcerr );
		locked = 1;
	}    
#endif/////////////////////////////////////////////////////////////////////
    
	if( locked )
		return( mmcerr = mmc_err_locked );
	return( mmcerr = mmc_noerr );
}

/***************************************************************************
 stMmcData : stampa caratteristiche mmc
								--------------
 In:
 var:
 Out:
 Call:
 ***************************/

#if 0
void			_stMmcData_( void)
{
	word vmin, vmax;
	long lt;
	byte i;
	char c;
//	struct sPartitionTable *pFirstPartitionTable;
	struct sBoot *pBoot;
	struct	dirent	*pDir;

	mmcInit();

	strcpy( sTmp, "          " );
	hexDump( sTmp+10, (byte *)&CSD );
	print_2( sTmp );

	sprintf( sTmp, "STRUCTURE             %02d", CSD.CSD_STRUCTURE ); printErr();
	sprintf( sTmp, "VERS                  %02d", CSD.SPEC_VERS ); printErr();
	i = tabtaac[ CSD.TAAC >> 3 ];
	switch( tabtaac[ ( CSD.TAAC & 0x07 ) / 3 ] )
	{
		case 0: c = 'n'; break;
		case 1: c = 'u'; break;
		default: c = 'm'; break;
	}
	switch( ( CSD.TAAC & 0x07 ) % 3 ){
		case 0: sprintf( sTmp, "TAAC      %2d.%01d%cs      %02X", i/10, i%10, c, CSD.TAAC ); break;
		case 2: i *= 10;
		case 1: sprintf( sTmp, "TAAC      %3d%cs     %02X", i, c, CSD.TAAC ); break;
	};
	printErr();
	sprintf( sTmp, "NSAC                  %02X", CSD.NSAC ); printErr( );
	sprintf( sTmp, "TRAN_SPEED            %02X", CSD.TRAN_SPEED ); printErr( );
	sprintf( sTmp, "CardCommandClasses   %03X", ((word)CSD.CCC_H << 4 ) | CSD.CCC_L ); printErr( );
	sprintf( sTmp, "READ_BLK_LEN  %5d   %02u", ( 1 << CSD.READ_BLK_LEN ), CSD.READ_BLK_LEN ); printErr( );
	sprintf( sTmp, "READ_BLK_PARTIAL       %01u", CSD.READ_BLK_PARTIAL ); printErr( );
	sprintf( sTmp, "WRITE_BLK_MISALIGN     %01u", CSD.WRITE_BLK_MISALIGN ); printErr( );
	sprintf( sTmp, "READ_BLK_MISALIGN      %01u", CSD.READ_BLK_MISALIGN ); printErr( );
	sprintf( sTmp, "DSR_IMP                %01u", CSD.DSR_IMP ); printErr( );
	sprintf( sTmp, "C_SIZE               %03X", (( (word)CSD.C_SIZE_H << 10 ) | ((word)CSD.C_SIZE << 2 ) | (word)CSD.C_SIZE_L ) ); printErr( );
	sprintf( sTmp, "VDD_R_CURR_MIN        %02u", CSD.VDD_R_CURR_MIN ); printErr( );
	sprintf( sTmp, "VDD_R_CURR_MAX        %02u", CSD.VDD_R_CURR_MAX ); printErr( );
	sprintf( sTmp, "VDD_W_CURR_MIN        %02u", CSD.VDD_W_CURR_MIN ); printErr( );
	sprintf( sTmp, "VDD_W_CURR_MAX        %02u", CSD.VDD_W_CURR_MAX ); printErr( );
	i = ( CSD.C_SIZE_MULT_H << 1 ) | CSD.C_SIZE_MULT_L ;
	sprintf( sTmp, "C_SIZE_MULT           %02u", i ); printErr( );
	sprintf( sTmp, "ERASE_GRP_SIZE        %02u", CSD.ERASE_GRP_SIZE ); printErr( );
	i = ( CSD.ERASE_GRP_MULT_H << 3 ) | CSD.ERASE_GRP_MULT_L ;
	sprintf( sTmp, "ERASE_GRP_MULT        %02u", i ); printErr( );
	sprintf( sTmp, "WP_GRP_SIZE           %02u", CSD.WP_GRP_SIZE ); printErr( );
	sprintf( sTmp, "WP_GRP_ENABLE         %02u", CSD.WP_GRP_ENABLE ); printErr( );
	sprintf( sTmp, "DEFAULT_ECC            %01u", CSD.DEFAULT_ECC ); printErr( );
	sprintf( sTmp, "R2W_FACTOR             %01u", CSD.R2W_FACTOR ); printErr( );
	i = ( CSD.WRITE_BLK_LEN_H << 2 ) | CSD.WRITE_BLK_LEN_L;
	sprintf( sTmp, "WRITE_BLK_LEN %5d   %02u", (1 << i), i ); printErr( );
	sprintf( sTmp, "WRITE_BLK_PARTIAL      %01u", CSD.WRITE_BLK_PARTIAL ); printErr( );
	sprintf( sTmp, "FILE_FORMAT_GRP        %01u", CSD.FILE_FORMAT_GRP ); printErr( );
	sprintf( sTmp, "COPY                   %01u", CSD.COPY ); printErr( );
	sprintf( sTmp, "PERM_WRITE_PROTECT     %01u", CSD.PERM_WRITE_PROTECT ); printErr( );
	sprintf( sTmp, "TMP_WRITE_PROTECT      %01u", CSD.TMP_WRITE_PROTECT ); printErr( );
	sprintf( sTmp, "FILE_FORMAT            %01u", CSD.FILE_FORMAT ); printErr( );
	sprintf( sTmp, "ECC CODE               %01u", CSD.ECC ); printErr( );
	sprintf( sTmp, "CRC7                  %02X", CSD.CRC ); printErr( );

	strcpy( sTmp, "          " );
	hexDump( sTmp+10, (byte *)&CID );
	print_2( sTmp );

	sprintf( sTmp, "ManufacturerID        %02X", CID.ManufacturerID ); printErr( );
	sprintf( sTmp, "ApplicationID       %04X", CID.ApplicationID ); printErr( );
	sprintf( sTmp, "Name             %6.6s", (byte *)CID.Name ); printErr( );
	sprintf( sTmp, "Revision              %02u", CID.Revision ); printErr( );
	sprintf( sTmp, "SerialNumber    %08lX", CID.SerialNumber ); printErr( );
	sprintf( sTmp, "MfgDate               %02X", CID.MfgDate ); printErr( );
	sprintf( sTmp, "CRC7                  %02X", CID.CRC ); printErr( );

	lt = 0x00800000; i = 0;
	while( ( OCR & lt ) == 0 && lt != 0 ){
		lt >>= 1;
		i++;
	}
	vmax = tabocr[i];
	while( ( OCR & lt ) != 0 ){
		lt >>= 1;
		i++;
	}
	vmin = tabocr[i];
	sprintf( sTmp, "VCC  %01d.%02d-%01d.%02dV", vmin/100, vmin%100, vmax/100, vmax%100 ); printErr( );
	if( ( OCR & 0x00200000 ) == 0 )
	{
		sprintf( sTmp, "VCC out of range" ); printErr( );
	}

	if( ( 1 << CSD.READ_BLK_LEN ) > sizeof( mmcBuff ) ){	// data block too large
		sprintf( sTmp, "Read Block too large" ); printErr( );
		return;
	}

//	if( mmcEraseSize * CSD.WRITE_BLK_LEN > sizeof( mmcEraseBuff ) ){	// data block too large
/* 02.02.2007	if( mmcEraseSize * 512L > sizeof( mmcEraseBuff ) ){	// data block too large
		sprintf( sTmp, "Erase Block too large" ); printErr( );
		return;
	}  */

	// file system data
	mmcReadBlock( 0L );
	sprintf( sTmp, "Addr. start   0x%08lX", BTB.startAddr ); printErr( );
	sprintf( sTmp, "numero sett.    %8lu", BTB.nSectors ); printErr( );
	switch( BTB.FATType ){
		case 0x01 : strcpy( sTmp, "FAT12" ); break;
		case 0x04 : strcpy( sTmp, "FAT16 ( < 32MB )" ); break;
		case 0x06 : strcpy( sTmp, "FAT16 ( >= 32MB )" ); break;
		default	: strcpy( sTmp, "tipo FAT ignoto" ); break;
	}
	printErr( );
	if( *(word *)(mmcBuff+0x1fe) != 0xAA55 ){
		sprintf( sTmp, "Firma part. table errata" ); printErr( );
	}

	mmcReadBlock( BTB.startAddr );

	pBoot = ( struct sBoot *)mmcBuff;
	sprintf( sTmp, "OEM label       %8.8s", (byte *)(pBoot -> OEM) ); printErr( );
	sprintf( sTmp, "Bytes/sector        %4u", pBoot -> bytesxSect ); printErr( );
	sprintf( sTmp, "Sector/cluster        %2u", pBoot -> sectxCluster ); printErr( );
	sprintf( sTmp, "Numero FAT            %2u", pBoot -> nFats ); printErr( );
	sprintf( sTmp, "Numero files root   %4u", pBoot -> bRootFiles ); printErr( );
	sprintf( sTmp, "Media descriptor    0x%02X", pBoot -> mediaType ); printErr( );
	sprintf( sTmp, "Settori per FAT    %5u", pBoot -> sectxFAT ); printErr( );
	if( pBoot -> sectxMedia != 0 ){
		sprintf( sTmp, "Totale settori     %5u", pBoot -> sectxMedia );
		BTB.totalSect = pBoot -> sectxMedia;
	}
	else{
		sprintf( sTmp, "Totale settori  %8lu", pBoot -> totalSect );
		BTB.totalSect = pBoot -> totalSect;
	}
	printErr( );
	sprintf( sTmp, "Numero di serie %08lX", pBoot -> serialNumber ); printErr( );
	sprintf( sTmp, "Disk Label   %11.11s", (byte *)pBoot -> label ); printErr( );
	sprintf( sTmp, "Filse sys       %8.8s", (byte *)pBoot -> fileSystem ); printErr( );
	if( pBoot -> signature != 0xAA55 ){
		sprintf( sTmp, "Firma boot record errata" ); printErr( );
	}

	mmcReadBlock( lt = BTB.startFatAddr );
	strcpy( sTmp, "Prima area FAT          " ); printErr( );
	sprintf( sTmp, "%08lX  ", lt );
	hexDump( sTmp+10, mmcBuff );
	print_2( sTmp );

	lt += (long)(BTB.sectxFAT)*(long)BTB.bytesxSect;
	mmcReadBlock( lt );
	strcpy( sTmp, "Seconda area FAT        " ); printErr( );
	sprintf( sTmp, "%08lX  ", lt );
	hexDump( sTmp+10, mmcBuff );
	print_2( sTmp );

	lt =  BTB.startRootAddr;
	mmcReadBlock( lt );
	strcpy( sTmp, "directory ROOT          " ); printErr( );
	for( i = 0; i < 64; i+= 16 )
	{
		sprintf( sTmp, "%08lX  ", lt+i );
		hexDump( sTmp+10, mmcBuff+i );
		print_2( sTmp );
	}

	pDir = ( struct dirent *)mmcBuff;
	for(i = 0; i < 2; i++, pDir++ )
	{
		sprintf( sTmp, "File name   %8.8s.%3.3s", (byte *)(pDir -> dir_name), (byte *)(pDir -> dir_ext) ); printErr( );
		sprintf( sTmp, "Attribute    %02X", pDir -> dir_attrib ); printErr( );
		sprintf( sTmp, "%02d-%02d-%04d  %02d-%02d-%02d",
				DT_DAY(pDir -> dir_date),DT_MONTH(pDir -> dir_date), DT_YEAR(pDir -> dir_date),
				TM_HOUR(pDir -> dir_time),TM_MIN(pDir -> dir_time),TM_DEC(pDir -> dir_time) ); printErr( );
		sprintf( sTmp, "Start cluster %04X", pDir -> dir_start ); printErr( );
		sprintf( sTmp, "Size %09lu", pDir -> dir_size ); printErr( );
	}


	mmcReadBlock( lt = BTB.startDataAddr );
	strcpy( sTmp, "Data Area               " ); printErr( );
	for( i = 0; i < 64; i+= 16 )
	{
		sprintf( sTmp, "%08lX  ", lt+i );
		hexDump( sTmp+10, mmcBuff+i );
		print_2( sTmp );
	}
}
#endif

#if 0
/***************************************************************************
 mmcGet : legge un carattere da memory card
								--------------
 In:
 var:
 Out:
 Call:
 ***************************/

char		mmcGet( void )
{
	if( ( pFile - mmcCache ) & 0xFFFFFE00L )
	{
		if( mmcReadBlock( pFile & 0xFFFFFE00L ) != mmc_noerr )
			return( 0 );	// fine per errore !!
	}
	return( *(mmcBuff + ( pFile++ & 0x1FFL )));
}

void		mmcGetRow( void )
{
	char ch;
	byte i;

	while( ( sTmp[0] = mmcGet()) <= 0x0d );			  	// skip Cr Lf
	i = 1;
	while( ( sTmp[i] = mmcGet()) > 0x0d  && i < 24 )		// copy till CrLf or 24 characters
		i++;
	sTmp[i] = '\0';
}

void		mmcSeek( long v, byte mode )
{
	switch( mode )
	{
		case SEEK_SET: 	pFile = BTB.startDataAddr + v;
						break;

		case SEEK_CUR: 	pFile += v;
						break;

		default:		break;
	}
}


/***************************************************************************
 mmcStringWrite : appende stringa a giornale di fondo
								--------------
 In:		indirizzo stringa.
			Se NULL effettua formattazione e registrazione nuovo DGFE
 var:
 Out:		mmc_noerr se ok
 Call:
 ***************************/

void	mmcStringWrite( char *buff )
{
	long	addr;
	word	cluster, i, offsetFAT;
	char	*pData;
	struct dirent dFileEntry, *pDir;

        memset( (void *)&dFileEntry, 0x00, sizeof( struct dirent ));

	if( dFileEntry.dir_size != 0 )
		cluster = ( dFileEntry.dir_size - 1 ) / ( BTB.sectxCluster * 512L );
	else
		cluster = 0;
	// prepara la FAT del file, che e' sequenziale ( non gestisce buchi i settori guasti )
	// la FAT e' caricata e mantenuta in memoria RAM, in mmcEraseBuff

	// DEBUG
	if( BTB.startFatAddr == 0L || BTB.startDataAddr == 0L || BTB.startRootAddr == 0L )
	{
		long lt;

		mmcReadBlock( lt = BTB.startRootAddr );
//		strcpy( sTmp, "Root Area               " ); printErr( );
		for( i = 0; i < 64; i+= 16 )
		{
//			sprintf( sTmp, "%08lX  ", lt+i );
			hexDump( sTmp+10, mmcBuff+i );
			print_2( sTmp );
		}
		mmcReadBlock( lt = BTB.startFatAddr );
//		strcpy( sTmp, "FAT  Area               " ); printErr( );
		for( i = 0; i < 64; i+= 16 )
		{
//			sprintf( sTmp, "%08lX  ", lt+i );
//			hexDump( sTmp+10, mmcBuff+i );
//			print_2( sTmp );
		}
		mmcReadBlock( lt = BTB.startDataAddr );
		strcpy( sTmp, "Data Area               " ); printErr( );
		for( i = 0; i < 64; i+= 16 )
		{
			sprintf( sTmp, "%08lX  ", lt+i );
			hexDump( sTmp+10, mmcBuff+i );
			print_2( sTmp );
		}
		while( -1 );
	}

/* 24.10.2003
	memset( mmcEraseBuff, 0x00, sizeof( mmcEraseBuff ));
	startFATaddr = BTB.startFatAddr;
	mmcEraseBuff[ 0 ] = 0xF8;
	mmcEraseBuff[ 1 ] = 0xFF;
	mmcEraseBuff[ 2 ] = 0xFF;
	mmcEraseBuff[ 3 ] = 0xFF;
	i = 3;
	j = 4;
	while( i <= cluster + 2 )						  	// prime 2 entry FAT non usate
	{
		mmcEraseBuff[ j   ] = ( i & 0xFF );
		mmcEraseBuff[ j+1 ] = ( i >> 8 );
		j += 2;
		i ++;
		if( j >= mmcEraseSize * 512L )
		{
			j = 0;
			memset( mmcEraseBuff, 0x00, sizeof( mmcEraseBuff ));
			startFATaddr += ( mmcEraseSize * 512L );
		}
	}
	mmcEraseBuff[ j ] = 0xFF;
	mmcEraseBuff[ j+1 ] = 0xFF;


	if( buff == NULL )       							// scrive FAT default
	{
		if( mmcEraseGroup( startFATaddr ) != mmc_noerr )
			return;
		if( mmcWriteGroup( startFATaddr ) != mmc_noerr )
			return;
		if( mmcEraseGroup( startFATaddr + BTB.sectxFAT * 512L  ) != mmc_noerr )
			return;
		if( mmcWriteGroup( startFATaddr + BTB.sectxFAT * 512L ) != mmc_noerr )
			return;
	}  24.10.2003 */

	addr = dFileEntry.dir_size + BTB.startDataAddr;		// indirizzo primo byte libero a cui accodare

//	if( mmcTestMemoria( addr ) != mmc_noerr )
//		return;

	pData = mmcBuff + ( addr & ( 512L -1L )) ;			// cluster mask ( 512 bytes )
	addr = addr & 0xFFFFFE00L;
	if( mmcReadBlock( addr ) != mmc_noerr ) 			// blocco dati
		return;
	while( buff != NULL && *buff != 0 )
	{
		crc32( *pData++ = *buff++ );					// calcola crc32

		if( pData >= mmcBuff + 512 || *buff == 0 )
		{
			if( mmcCmd( WRITE_BLOCK, addr ) != mmc_noerr )
				return;
			if( mmcWrite( mmcBuff, 512L ) != mmc_noerr )
				return;
			addr += 512L;
			if( mmcReadBlock( addr ) != mmc_noerr )
				return;
			pData = mmcBuff;
		}

		if( addr >= mmcCapacitySectors * 512L )
			break;

 /* 24.10.2003
		if( ( dFileEntry.dir_size / ( BTB.sectxCluster * 512L )) != cluster )
		{
			cluster = dFileEntry.dir_size / ( BTB.sectxCluster * 512L );
			mmcEraseBuff[ j ] = ( (cluster+2) & 0xFF );
			mmcEraseBuff[ j + 1 ] = ( (cluster+2) >> 8 );
			j += 2;
			if( j >= mmcEraseSize * 512L )
			{
				if( mmcEraseGroup( startFATaddr ) != mmc_noerr )
					return;
				if( mmcWriteGroup( startFATaddr ) != mmc_noerr )
					return;
				if( mmcEraseGroup( startFATaddr + BTB.sectxFAT * 512L ) != mmc_noerr )
					return;
				if( mmcWriteGroup( startFATaddr + BTB.sectxFAT * 512L ) != mmc_noerr )
					return;
				j = 0;
				memset( mmcEraseBuff, 0x00, sizeof( mmcEraseBuff ));
				startFATaddr += ( mmcEraseSize * 512L );
			}
			mmcEraseBuff[ j ] = 0xFF;
			mmcEraseBuff[ j+1 ] = 0xFF;
			if( mmcEraseGroup( startFATaddr ) != mmc_noerr )
				return;
			if( mmcWriteGroup( startFATaddr ) != mmc_noerr )
				return;

			if( mmcEraseGroup( startFATaddr + BTB.sectxFAT * 512L ) != mmc_noerr )
				return;
			if( mmcWriteGroup( startFATaddr + BTB.sectxFAT * 512L ) != mmc_noerr )
				return;
		}   24.10.2003 */
		dFileEntry.dir_size++;
	}

	// prepara Directory di default
	if( buff != NULL )
	{
		mmcReadBlock( BTB.startRootAddr );
	}
	else
	{
		memset( mmcBuff, 0x00, 512 );
		pDir = ( struct dirent *)(mmcBuff + sizeof( struct dirent ) );
//		sprintf( (char *)pDir, "330%05lu\x17\x18\x16", matricola );
//		leggiClock();
		pDir -> dir_time = TM_ENCODE( dateTime.hour, dateTime.min, dateTime.sec );// data registrazione
		pDir -> dir_date = DT_ENCODE( dateTime.month, dateTime.day, dateTime.year );
		pDir -> dir_attrib = D_VOLID;
//      pDir -> dir_start = 0;
	}

	pDir = ( struct dirent *)mmcBuff;
//	sprintf( (char *)pDir, "DGFE%04dTXT", TotFiscale.mem.nDGFE + TotFiscale.ram.nDGFE  );
//	leggiClock();
	pDir -> dir_time = TM_ENCODE( dateTime.hour, dateTime.min, dateTime.sec );
	pDir -> dir_date = DT_ENCODE( dateTime.month, dateTime.day, dateTime.year );
	pDir -> dir_attrib = D_RDONLY | D_ARCHIVE;
	pDir -> dir_start = 2;
	pDir -> dir_size = dFileEntry.dir_size;

	if( mmcCmd( WRITE_BLOCK, BTB.startRootAddr ) != mmc_noerr )
		return;
	if( mmcWrite( mmcBuff, 512L ) != mmc_noerr )
		return;
/*	if( buff != NULL )		// aggiorna dati registrati
	{
		memcpy( (void *)registeredDir, mmcBuff, sizeof( registeredDir ) );
		memset( (void *)(registeredDir[0].dir_reserved ), 0, 10 );
		memset( (void *)(registeredDir[1].dir_reserved ), 0, 10 );
	}   	20.07.2003 */
}
#endif

unsigned long	getCrcSeed( void )
{
	return( CID.SerialNumber );
}


uint32_t DFS_ReadSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
{
    if ( count != 1 )
        return 2;
    if ( mmcReadBlock( SECTOR2ADDR(sector) ) )
        return 1;
    memcpy( buffer, mmcBuff, sizeof(mmcBuff) );
	return 0;
}
/*
	Write sector to image
	Returns 0 OK, nonzero for any error
*/
uint32_t DFS_WriteSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
{
    if ( count != 1 )
        return 2;
    memcpy( mmcBuff, buffer, sizeof(mmcBuff) );
    return mmcWriteBlock( SECTOR2ADDR(sector) );
}
