/***************************************************************************
 ************************						****************************
 ************************	  M M C . H	        ****************************
 ************************						****************************
 ***************************************************************************/
#ifndef	__MMC_H
#define	__MMC_H

#ifdef __MMC_C
#define typemmc
#else
#define typemmc extern
#endif




#include    "fat.h"
#include    "mci.h"




typedef		unsigned long	MMCERR;
typedef         unsigned long   tParam;

unsigned long SECTOR2ADDR( unsigned long _addr );
unsigned long ADDR2SECTOR( unsigned long _addr );
void		initSPI2( void );
MMCERR		mmcInit( void );
MMCERR	   	mmcCmd( byte cmd, tParam param );
MMCERR		mmcRead( byte *buf, word count );
MMCERR		mmcWrite( byte *buf, word count );
MMCERR		mmcReadBlock( long addr );
MMCERR		mmcReadGroup( long iaddr );
MMCERR		mmcEraseGroup( long addr );
MMCERR		mmcWriteGroup( long iaddr );
word		dgfeVerificaMedesima( void );
word		dgfeVerificaFile( void );
char		mmcGet( void );
void		mmcGetRow( void );
void	        mmcSeek( long val, byte mode );


typemmc unsigned long pFile;		// puntatore per le funzioni mmcGet e mmcGetRow
// struttura di controllo file system
struct sBTB {
	byte	FATType;
	long    startAddr;
	long    startFatAddr;
	long    startRootAddr;
	long    startDataAddr;
    long    rootSize;
	long	nSectors;
	UINT	bytesxSect;
	byte	sectxCluster;
	UINT	sectxFAT;
	UINT	reserved;
	long	totalSect;
	long	serialNumber;
};
typemmc struct sBTB BTB;
typemmc unsigned long mmcCache;
typemmc MMCERR  mmcerr;
typemmc byte    mmcBuff[BLOCK_LENGTH];



//          MMC ERROR DEFINTIONE AND GLOBALS
#define mmc_err_out_rng         0x80000000
#define	mmc_err_busy            0x80000000
#define	mmc_err_param           0x80000000
#define	mmc_err_addr            0x40000000
#define	mmc_err_len             0x20000000
#define	mmc_err_eras_seq        0x10000000
#define	mmc_err_eras_par        0x08000000
#define	mmc_err_writep          0x04000000
#define	mmc_err_locked          0x02000000
#define	mmc_err_lock_fail       0x01000000
#define	mmc_err_crc             0x00800000
#define	mmc_err_illegal         0x00400000
#define	mmc_err_ecc             0x00200000
#define	mmc_err_cc              0x00100000
#define	mmc_err_unknown         0x00080000
#define mmc_err_underrun        0x00040000
#define mmc_err_overrun         0x00020000
#define mmc_err_cid_csd_over    0x00010000
#define	mmc_err_wp              0x00008000
#define mmc_err_ecc_dis         0x00004000
#define mmc_err_erase           0x00002000
#define mmc_status_state        0x00001E00
#define mmc_status_emtry        0x00000100
// rsvd  2 bits
#define mmc_status_app_enab     0x00000020
// rsvd 4 bits
#define mmc_err_timeout         0x00000001  // rsvd
#define mmc_noerr               0x00000000
#define mmc_err_mask            0xFFFFE000


// definizione strutture mmc: il dettaglio DIPENDE DALLA ENDIANESS DELLA CPU
#pragma pack(1)
union	sCID{
  struct {
	byte	ManufacturerID;
	word	ApplicationID;
	char	Name[6];
	byte	Revision;
	long	SerialNumber;
	byte	MfgDate;
	byte	CRC:7, STOP:1;
  };

  struct {
        unsigned long CID[4];
  };
};

union	sCSD{
  struct {
	byte	CSD_STRUCTURE:2, SPEC_VERS:4, res1:2;  		// ordinati da LSB ad MSB
	byte	TAAC;
	byte	NSAC;
	byte	TRAN_SPEED;
	byte	CCC_H;
	byte	CCC_L:4, READ_BLK_LEN:4;
	byte	READ_BLK_PARTIAL:1, WRITE_BLK_MISALIGN:1, READ_BLK_MISALIGN:1, DSR_IMP:1, res2:2, C_SIZE_H:2;
	byte	C_SIZE;
	byte	C_SIZE_L:2, VDD_R_CURR_MIN:3, VDD_R_CURR_MAX:3;
	byte	VDD_W_CURR_MIN:3, VDD_W_CURR_MAX:3, C_SIZE_MULT_H:2;
	byte	C_SIZE_MULT_L:1, ERASE_GRP_SIZE:5, ERASE_GRP_MULT_H:2;
	byte	ERASE_GRP_MULT_L:3, WP_GRP_SIZE:5;
	byte	WP_GRP_ENABLE:1, DEFAULT_ECC:2, R2W_FACTOR:3, WRITE_BLK_LEN_H:2;
	byte	WRITE_BLK_LEN_L:2, WRITE_BLK_PARTIAL:1, res3:5;
	byte	FILE_FORMAT_GRP:1, COPY:1, PERM_WRITE_PROTECT:1, TMP_WRITE_PROTECT:1, FILE_FORMAT:2, ECC:2;
	byte	CRC:7, stop:1;
//	byte	READ_BLK_LEN:4,	CCC_L:4;
//	byte	C_SIZE_H:2, res2:2, DSR_IMP:1, READ_BLK_MISALIGN:1, WRITE_BLK_MISALIGN:1, READ_BLK_PARTIAL:1;
//	byte	C_SIZE;
//	byte	VDD_R_CURR_MAX:3, VDD_R_CURR_MIN:3, C_SIZE_L:2;
//	byte	C_SIZE_MULT_H:2, VDD_W_CURR_MAX:3, VDD_W_CURR_MIN:3;
//	byte	ERASE_GRP_MULT_H:2, ERASE_GRP_SIZE:5, C_SIZE_MULT_L:1;
//	byte	WP_GRP_SIZE:5, ERASE_GRP_MULT_L:3;
//	byte	WRITE_BLK_LEN_H:2, R2W_FACTOR:3, DEFAULT_ECC:2, WP_GRP_ENABLE:1;
//	byte	res3:5, WRITE_BLK_PARTIAL:1, WRITE_BLK_LEN_L:2;
//	byte	ECC:2, FILE_FORMAT:2, TMP_WRITE_PROTECT:1, PERM_WRITE_PROTECT:1, COPY:1, FILE_FORMAT_GRP:1;
//	byte	stop:1, CRC:7 ;
  };

  struct {
        unsigned long CSD[4];
  };
};
#pragma pack()

typemmc	union  sCID	registeredCID;
typemmc struct dirent	registeredDir[2];
typemmc unsigned long 	mmcCapacitySectors;




byte			findFile( DWORD _nfile, char *_pfileName, WORD *_cluster, DWORD *_fileLen );




#undef	typemmc
#endif

