/***************************************************************************
 ************************						****************************
 ************************		M O D E M      	****************************
 ************************						****************************
 ***************************************************************************/
#ifndef __MODEM_H
#define __MODEM_H
#define MODEM_TRANSFER  1
#define MODEM_NEW_SRVR  1




#include    "def.h"




#if MODEM_TRANSFER

struct  _MODEM_DATA_ {
    BOOL    present;
    byte    status;
    byte    comPort;
    byte    rxi;
    char    ucbID[16];
    char    rxbuf[256];
    byte    command;
    DWORD   lastrx;
} ;

extern struct _MODEM_DATA_ modemData;
extern byte modemSend, modemReceive;

byte            modemInit( byte _channel );
byte            modemVerify( void );
byte            modemUpdate( void );
byte            modemTransfer( char *_fname );
byte            modemManager( void );
#else
#define modemInit(ch)       0
#define modemVerify()       0
#define modemUpdate()       1
#define modemTransfer(a)    0
#define modemManager()
#endif




#define HOST_STATUS_READY       0
#define HOST_EXACT_CHANGE       1
#define HOST_SELECTION_START    2
#define HOST_SELECTION_OK       3
#define HOST_SELECTION_FAILED   4
#define HOST_SELECTION_LOCKED   5
#define HOST_SELECTION_UNAVAIL  6
#define HOST_SELECTION_COST     7
#define HOST_PROGRAMMING        9
#define HOST_DOOR_CLOSE         10
#define HOST_DOOR_OPEN          11
#define HOST_COMMAND_OK         68
#define HOST_COMMAND_UNKNOWN    99
#define HOST_READ_PRICE         0xFE
#define HOST_READ_STATUS        0xFF

#if MIND_UCB_COMM4

struct  _HOST_DATA_ {
    BOOL    present;
    byte    status;
    byte    door;
    byte    comPort;
    byte    rxi;
    char    rxbuf[256];
    byte    tray, column, select;
    _Credito money, price, discounted, cashlessprice;
    DWORD   lastrx;
};

byte            hostInit( byte _channel );
byte            hostManager( void );
byte            hostStatus( byte _stat );
void            hostMoney( _Credito _val );
byte            hostSelection( byte *_machine, byte *_tray, byte *_column, _Credito *_tot );

#else

#define hostInit(ch)            0
#define hostManager()           
#define hostStatus(a)           
#define hostSelection(a,b,c)    1
#define hostMoney(a)

#endif


#endif
