/***************************************************************************
 ************************						****************************
 ************************		O P T I C A L  	****************************
 ************************						****************************
 ***************************************************************************/
#define	__OPTICAL_C




#include    <string.h>
#include    "def.H"
#include    "funzioni.h"
#include    "optical.h"
#include    "ram.h"
#include    "timer.h"


#if LED_DISPLAY_PRICE


#define MAX_LDP_TRAY    6




/*--------------------------------------------------------------------------
 | lpdInit:     init Led Price Display
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

word    ldpFlag[MAX_LDP_TRAY];          // flag price updated
word    ldpBlink[MAX_LDP_TRAY];         // flag price updated
byte    ldpCnt;
byte    lpdEnabled;

byte            lpdInit( void )
{
    memset( ldpFlag, 0, sizeof(ldpFlag) );
    memset( ldpBlink, 0, sizeof(ldpBlink) );

    ldpCnt = 0;
    lpdEnabled = 1;
    return 0;
}                                               //  lpdInit




/*--------------------------------------------------------------------------
 | lpdRecalc:   force price display
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            lpdRecalc( void )
{
    byte        iTray, iColumn;
    
//DEB_EN();
//DEB_1();

    memset( ldpFlag, 0xFF, sizeof(ldpFlag) );// update all data
    if ( NonVolatileSetup.discountFlag == DISCOUNT_MACHINE )
    {
        if ( valid_discount_selection( 0, 0 ) )
            memset( ldpBlink, 0xFF, sizeof(ldpBlink) );
        else
            memset( ldpBlink, 0x00, sizeof(ldpBlink) );
    }
    else 
    {
        memset( ldpBlink, 0x00, sizeof(ldpBlink) );
        if ( NonVolatileSetup.discountFlag == DISCOUNT_SELECTION )
        {
            for ( iTray = 0; iTray < MAX_LDP_TRAY; iTray++ )
            {
                for ( iColumn = 0; iColumn < MAXCOLUMN; iColumn++ )
                {
                    if ( valid_discount_selection( iTray, iColumn ) )
                    {
                        ldpBlink[iTray] |= (0x01<<iColumn);
                    }
                }
            }
            
        }
    }
    ldpCnt = 1;
//DEB_EN();
//DEB_0();
 
    return 0;
}                                               //  lpdRecalc



/*--------------------------------------------------------------------------
 | lpdSendPrice:get value to disp
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            lpdSendPrice( byte *_row, byte *_col, dword *_val  )
{
    byte        i, j;
    word        mask;

    if ( ldpCnt == 0 )
        return 1;
    
    for ( i = 0; i < 6; i++ )
    {
        mask = 1;
        for ( j = 0; j < 10; j++ )
        {
            if ( ldpFlag[i]&mask )
            {
                ldpFlag[i] &= ~mask;

                *_row = i;
                *_col = j;
                *_val = amount[0][i][j];
                return 0;
            }
            mask <<= 1;
        }
    }

    ldpCnt = 0;
    return 2;
}                                               //  lpdSendPrice




/*--------------------------------------------------------------------------
 | lpdSendTray:get value to disp
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            lpdSendTray( byte *_row )
{
    byte        i, j;
    word        mask;

    if ( ldpCnt == 0 )
        return 1;
    
    for ( i = 0; i < 6; i++ )
    {
        mask = 1;
        for ( j = 0; j < 10; j++ )
        {
            if ( ldpFlag[i]&mask )
            {
                ldpFlag[i] = 0;

                *_row = i;
                return 0;
            }
            mask <<= 1;
        }
    }

    ldpCnt = 0;
    return 2;
}                                               //  lpdSendTray




/*--------------------------------------------------------------------------
 | lpdMode:     mode
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

byte            lpdMode( byte _mode )
{
    lpdEnabled = _mode;
    return 0;
}                                               //  lpdMode

#endif//LED_DISPLAY_PRICE
