//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "sender.h"
#include "MonitorGest.h"
#include "rs232.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSerMonitor *SerMonitor;
char			*serMode( void );
extern bool forceClose;
//---------------------------------------------------------------------------
__fastcall TSerMonitor::TSerMonitor(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
//#define	SIMULATORE
#ifdef	SIMULATORE
int		iinfile = 0;
byte	infile[] = {
	"ABADECO\x0d\x0a\x02 FRESCO \x03"
};
#endif
unsigned char 	direction = 0, crea = false;
char			stringa[256] = {0}, istringa = 0;
char			strout[256];
static	Rs232		*com = NULL;
TFileStream	    *outFile = NULL;
void		TSerMonitor::RxMonitor( void )
{
	char		buffer[256], sTmp[32];
	int			i, j, k;
	DWORD		sTm, aTm, rTm, dTm;

#ifdef	SIMULATORE
	iinfile = 0;
#endif

	forceClose = false;

	com = new Rs232( (char)(Form1->COMnumber->ItemIndex+1), serMode() );
	if( com == NULL ) {
		Application->MessageBox( "Unable to open serial port", "Error", MB_OK );
		forceClose = false;
		return;
	}

	try {
		outFile = new TFileStream( "mom.dat", fmOpenWrite | fmShareDenyNone );
	}
	catch (...)
	{
		crea = true;
	}
	if( crea ) {
		try {
			outFile = new TFileStream( "mom.dat", fmOpenReadWrite | fmCreate | fmShareCompat );
		}
		catch (...)
		{
			Application->MessageBox( "Unable to open output file", "Error", MB_OK );
			delete com;
			com = NULL;
			return;
		}
	}
	outFile->Seek( 0, soFromEnd );

	sTm = GetTickCount();
	rTm = GetTickCount();
	j = 0;
	k = 0;
	while( !forceClose ) {
		Application->ProcessMessages();

		aTm = (GetTickCount()-sTm)/1000;
		if( (GetTickCount()-rTm) < 1000 ) {
			sprintf( sTmp, "Connection timer: %dh %dm %ds", aTm/3600, (aTm/60)%60, aTm%60 );
		}
		else {
			dTm = (GetTickCount()-rTm)/1000;
			sprintf( sTmp, "Connection timer: %dh %dm %ds (waiting %02d:%02d)", aTm/3600, (aTm/60)%60, aTm%60, (dTm/60)%60, dTm%60 );
		}
		StatusBar1->Panels->Items[0]->Text = sTmp;

		sprintf( sTmp, "Bytes received: %ld", j );
		StatusBar1->Panels->Items[1]->Text = sTmp;


do {
		i = com->ReadComm( &buffer[k], 1 );
#ifdef	SIMULATORE
		if( infile[iinfile] != 0 ) {
			buffer[k] = infile[iinfile++];
			i = 1;
		}
#endif

		if( i != 0 ) {
			rTm = GetTickCount();
			j++;
//			if( Form1->StdConf->ItemIndex == RSR275 )
			if( VisuaMode->ItemIndex == 3 ) {
				k++;
				switch( buffer[0] ) {
					case ' ':
						if( k == 1 )
							continue;

						if( (buffer[1] == '<' || buffer[1] == '>') ) {
							if( buffer[1] != direction ) {
								direction = buffer[1];

								spostaCursore( 0x0a, 1 );

								sprintf( strout, "%c %s", direction, stringa );
								VisuaStr( strout );

								stringa[0] = 0;
								istringa = 0;

								outFile->Write( "\n", 1 );
								outFile->Write( strout, strlen(strout) );
							}
						}
						else {
							if( buffer[1] == '\n' ) {
								VisuaStr( stringa );
								spostaCursore( 0x0a, 1 );

								outFile->Write( stringa, strlen(stringa) );
								outFile->Write( "\n", 1 );
								stringa[0] = 0;
								istringa = 0;
							}
							else {
								stringa[istringa++] = buffer[1];
								stringa[istringa+0] = ' ';
								stringa[istringa+1] = '\0';
							}
						}
						break;

					case 'H':
						if( k == 1 )
							continue;
						buffer[0] = buffer[1];

					default:
						sprintf( strout, "%s%02X ", stringa, (unsigned char)buffer[0] );
						VisuaStr( strout );

						outFile->Write( strout, strlen(strout) );

						stringa[0] = 0;
						istringa = 0;
						break;
				}
			}
			else {
				VisuaChar( buffer[0] );
				outFile->Write( &buffer[0], i );
			}
			k = 0;
		}
}while( i != 0 );
	}

	delete outFile;
    outFile = NULL;
	delete com;
	com = NULL;
	forceClose = false;
}
//---------------------------------------------------------------------------
void __fastcall TSerMonitor::FormClose(TObject *Sender, TCloseAction &Action)
{
	forceClose = true;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static int x = 0, y = 0;
#define	SIZ	8
void		TSerMonitor::VisuaChar( byte _char )
{
	char	s[4];
//	int		hy = y+(-Image1->Canvas->Font->Height);

	Image1->Canvas->Font->Style = Image1->Canvas->Font->Style >> fsBold;
	switch( VisuaMode->ItemIndex ) {
		case 1:
//			Image1->Canvas->Font->Size = SIZ/2;
			sprintf( s, "%02X", _char );
			Image1->Canvas->TextOut( x, y, s );
			break;

		case 2:
			if( !isprint(_char) ) {
				switch( _char ) {
					case 0x02:
						strcpy( s, "Stx" );
						break;

					case 0x03:
						strcpy( s, "Etx" );
						break;

					case 0x04:
						strcpy( s, "Eot" );
						break;

					case 0x0D:
						strcpy( s, "Cr" );
						break;

					case 0x0A:
						strcpy( s, "Lf" );
						break;

					default:
						sprintf( s, "%02X", _char );
				}
				Image1->Canvas->Font->Style = Image1->Canvas->Font->Style << fsBold;
				Image1->Canvas->TextOut( x, y, s );
				break;
			}

		default:
//			Image1->Canvas->Font->Size = SIZ;
			s[0] = _char;
			s[1] = 0;
			Image1->Canvas->TextOut( x, y, s );
			break;
	}
	spostaCursore( _char, strlen(s) );
}
//---------------------------------------------------------------------------
void		TSerMonitor::VisuaStr( char *_str )
{
	while( *_str != 0 ) {
		VisuaChar( *_str );
		_str++;
	}
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void		TSerMonitor::spostaCursore( byte _char, int _sl )
{
	int		ny;

	if( _char != 0x0a ) {
		x += Image1->Canvas->Font->Size*_sl;
	}
	if( _char == 0x0a || x > Image1->Width ) {
		x = 0;
		y += 10*(-Image1->Canvas->Font->Height)/8;
		ny = y + 30*(-Image1->Canvas->Font->Height)/8;
		if( ny > Image1->Height ) {
			y = 0;
			ny = y + 30*(-Image1->Canvas->Font->Height)/8;
		}
		Image1->Canvas->Pen->Color = clWhite;
		Image1->Canvas->Rectangle( x, y, Image1->Width, ny );
		Image1->Canvas->Pen->Color = clBlack;
	}
}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::FormResize(TObject *Sender)
{
	Image1->Height = SerMonitor->Height-110;
}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::Clearbuffer1Click(TObject *Sender)
{
	Image1->Canvas->Pen->Color = clWhite;
	Image1->Canvas->Rectangle( 0, 0, Image1->Width, Image1->Height );
	Image1->Canvas->Pen->Color = clBlack;
	x = y = 0;
}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::WriteDischargeConfirmation1Click(TObject *Sender)
{
	char		buffer[256], sTmp[32];
	TFileStream	*inpFile;
	int			i, k;
	DWORD		sTm;


	if( com == NULL )
		return;


	if( Form1->OpenDialog2->Execute() ) {

		try {
			inpFile = new TFileStream( Form1->OpenDialog2->FileName, fmOpenRead | fmShareExclusive );
		}
		catch (...)
		{
			Application->MessageBox( "Unable to open input file", "Error", MB_OK );
			delete com;
			return;
		}

		com->WriteComm( " ", 1 );
		sTm = GetTickCount();
		while( (GetTickCount()-sTm) < 100 );
		com->WriteComm( "D", 1 );

		k = 0;
		sTm = GetTickCount();
		while( !forceClose ) {

			i = inpFile->Read( &buffer[0], 1 );
			k++;
			if( i == 0 )
				break;
			if( (k == 1 && buffer[0] != 0x20) ) {
				sprintf( sTmp, "Incorrect file format: %02X (expected 0x20)", buffer[0] );
				Application->MessageBox( sTmp, "Error", MB_OK );
				forceClose = true;
				break;
			}

			com->WriteComm( buffer, i );

			Application->ProcessMessages();

			if( k == 99 )
				break;
		}

		delete inpFile;
	}
}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::Exit1Click(TObject *Sender)
{
	SerMonitor->Close();	
}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::ReadDischargeClick(TObject *Sender)
{
	DWORD		sTm;


	if( com == NULL )
		return;

	if( Application->MessageBox( "Send to file monitor (MOM.DAT)?", "DEBUG DISHARGE", MB_YESNO ) != IDYES )
		return;

	com->WriteComm( " ", 1 );
	sTm = GetTickCount();
	while( (GetTickCount()-sTm) < 100 );
	com->WriteComm( "L", 1 );	// avvia discharge


}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::ReadLastLogClick(TObject *Sender)
{
	DWORD		sTm;


	if( com == NULL )
		return;


	com->WriteComm( " ", 1 );
	sTm = GetTickCount();
	while( (GetTickCount()-sTm) < 100 );
	com->WriteComm( "R0", 2 );	// avvia lettura dell'ultimo LOG

}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::ReadPrevLogClick(TObject *Sender)
{
	DWORD		sTm;


	if( com == NULL )
		return;


	com->WriteComm( " ", 1 );
	sTm = GetTickCount();
	while( (GetTickCount()-sTm) < 100 );
	com->WriteComm( "R1", 2 );	// avvia lettura del penultimo LOG

}
//---------------------------------------------------------------------------

void __fastcall TSerMonitor::SEND1Click(TObject *Sender)
{
	char		buffer[256], sTmp[32];
	TFileStream	*inpFile;
	int			i, k, f, j;
	DWORD		sTm;


	if( com == NULL )
		return;


    j = 0;
	if( Form1->OpenDialog2->Execute() ) {

		try {
			inpFile = new TFileStream( Form1->OpenDialog2->FileName, fmOpenRead | fmShareExclusive );
		}
		catch (...)
		{
			Application->MessageBox( "Unable to open input file", "Error", MB_OK );
			delete com;
			return;
		}

		k = 0;
        f = 0;
		while( !forceClose ) {

			i = inpFile->Read( &buffer[0], 1 );
			k++;
			if( i == 0 )
				break;

			com->WriteComm( buffer, i );

            if( (buffer[0] == 0x0d || buffer[0] == 0x0a) && f == 0 )
            {
                f = 1;
                sTm = GetTickCount();
                while( (GetTickCount()-sTm) < 150 )
                {
                    i = com->ReadComm( &buffer[0], 1 );
                    if( i != 0 )
                    {
                        sTm = GetTickCount();
                        j++;
                        if( buffer[0] == 0x06 )
                            outFile->Write( "ACK", 3 );
                        else if( buffer[0] == 0x15 )
                            outFile->Write( "NACK", 4 );
                        else
                            outFile->Write( buffer, 1 );
                    }
                    else
                        Sleep(10);
                }

		        sprintf( sTmp, "Bytes tx: %ld rx: %ld", k, j );
        		StatusBar1->Panels->Items[1]->Text = sTmp;

            }
            else
                f = 0;
			Application->ProcessMessages();
		}

		delete inpFile;
	}

}
//---------------------------------------------------------------------------

