void        debuggaTutto( void );
extern int evento_just_reset;//EEE
/*
uart.c

-- EZIO : in vece di usare tanti switch, inserire una struttura che usa _ch come offset nei puntatori
          alla struttura stessa
*/

#define __UART_C

#include <stdio.h>
#include <string.h>
#ifndef __WIN32__
#include "LPC_Vic.h"
#endif
#include "uart.h"
#include "def.h"
#include "dex.h"
#include "ram.h"
#include "hwinit.h"
#include "display.h"
#include "messaggi.h"
#include "optical.h"
#include "timer.h"
#include "inizial.h"
#include "keyboard.h"
#include "event.h"
#include "crc16.h"
#include "funzioni.h"
#include "ds2341.h"
#include "main.h"
#include "modem.h"

/* per MDB */
#define T_RESPONSE    8000              // 8ms - vedi FAGE
#define T_INTERBYTE     4000    // deve essere > 3.5ms + tempo carattere - vedi MARS TRC6512 dopo reset puo' rispondere con tempi maggiori di 3,5ms
#define MAX_MDB_FRAME   36

byte            discount_test( _Credito *_amount, byte s_tray, byte s_column );

extern const char  VMCManufacturer[];
extern char  VMCSerial[13];
extern char  VMCModel[13];
extern char  VMCSwRevision[3];

#ifdef BOOT
#else
extern char en_test_seriale;
#endif

// credito
_Credito        card;
_Credito        token;

struct S_SelectionData SelectionData;

/*
#define __IO_REG8_X(NAME, ATTRIBUTE)              \
                   volatile unsigned char NAME

#define __IO_REG16_X(NAME, ATTRIBUTE)             \
                   volatile unsigned short NAME

#define __IO_REG32_X(NAME, ATTRIBUTE)             \
                   volatile unsigned long NAME

#define __IO_REG8_BIT_X(NAME, ATTRIBUTE, BIT_STRUCT)\
                       volatile union \
                        {                                 \
                          unsigned char B;             \
                          BIT_STRUCT bit;      \
                        } NAME

#define __IO_REG16_BIT_X(NAME, ATTRIBUTE,BIT_STRUCT)\
                        volatile union \
                         {                                 \
                           unsigned short B;            \
                           BIT_STRUCT _bit;      \
                         } NAME

#define __IO_REG32_BIT_X(NAME, ATTRIBUTE, BIT_STRUCT)\
                        volatile union \
                         {                                 \
                           unsigned long B;             \
                           BIT_STRUCT _bit;      \
                         } NAME
#pragma pack(4)
struct  S_UART_units {
__IO_REG8_X(     UxRBRTHR,__READ_WRITE);
#define UxDLL UxRBRTHR
#define UxRBR UxRBRTHR
#define UxTHR UxRBRTHR

__IO_REG32_BIT_X(UxIER,__READ_WRITE ,__uartier0_bits);
#define UxDLM      UxIER

__IO_REG32_BIT_X(UxFCR,__READ_WRITE ,__uartfcriir_bits);
#define UxIIR      UxFCR
#define UxIIR_bit  UxFCR_bit

__IO_REG8_BIT_X( UxLCR,__READ_WRITE ,__uartlcr_bits);
  unsigned long dummy0;
__IO_REG8_BIT_X( UxLSR,__READ       ,__uartlsr_bits);
  unsigned long dummy1;
__IO_REG8_X(     UxSCR,__READ_WRITE);
__IO_REG32_BIT_X(UxACR,__READ_WRITE ,__uartacr_bits);
  unsigned long dummy2;
__IO_REG32_BIT_X(UxFDR,__READ_WRITE ,__uartfdr_bits);
  unsigned long dummy3;
__IO_REG8_BIT_X( UxTER,__READ_WRITE ,__uartter_bits);

};
#pragma pack()

struct Scomm_units{
  struct  S_UART_units *uart;
  typeu   _RING_BUF_  commIbuf;
  typeu   _RING_BUF_  commObuf;
} comm[4]; // = { (struct  S_UART_units *)0xE000C000, (struct  S_UART_units *)0xE0010000, (struct  S_UART_units *)0xE0078000, (struct  S_UART_units *)0xE007C000 };
*/

#if MDB_DEBUG
extern unsigned long random;
#define DEBUG_MDB_CHAR(_dir,_data)                                          \
    random = T2TC;                                                          \
    if ( random > 0x1E )                                                    \
    {                                                                       \
        commPutChar( COMM1, 0x80|_dir|0x20|( random    &0x1f) );            \
        commPutChar( COMM1, 0x80|_dir|     ((random>>5)&0x1f) );            \
    }                                                                       \
    else                                                                    \
    {                                                                       \
        commPutChar( COMM1, 0x80|_dir|(random&0x1f) );                      \
    }                                                                       \
    random = 0;                                                             \
    T2TC = 0;                                                               \
    commPutChar( COMM1, _data );
#define DEBUG_MDB_EXTRA(_data)                                              \
    commPutChar( COMM1, _data );
#else
#define DEBUG_MDB_CHAR(_dir,_data)
#define DEBUG_MDB_EXTRA(_data)
#endif


/*--------------------------------------------------------------------------
 | commCfgPort: inizializza seriale 0
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 |      _baud   9600,19200,38400,57600,115200
 |      _bits   7,8
 |      _parity 0,1,2
 |      _stops  1,2
 | Out: 0       ok
 |      1       com non disponibile
 +--------------------------------------------------------------------------*/

BOOL            UART_readTxBuf( _RING_BUF_ *_p, byte *_txReg )
{
/*    _RING_BUF_ *_pp = &(comm[*_txReg].commObuf);
    if ( _pp->r == _pp->w )
        return FALSE;
*/
    if ( _p->r == _p->w )
        return FALSE;
    *_txReg = _p->buf[_p->r];
#if MDB_DEBUG
    if ( _txReg == &U2THR )
    {
        DEBUG_MDB_CHAR(0x00,_p->buf[_p->r]);
    }
#endif
    if ( _p->r == (COMM_BUF-1) )
        _p->r = 0;
    else
        _p->r = _p->r+1;
    return TRUE;
}

void            UART_writeRxBuf( _RING_BUF_ *_p, byte _rxReg )
{
    word        idx;

    if ( _p->w == (COMM_BUF-1) )
        idx = 0;
    else
        idx = _p->w + 1;
    if ( idx != _p->r )
    {
        _p->buf[_p->w] = _rxReg;
        _p->w = idx;
    }
    else
        _p->flag |= RC_FIFO_OVERRUN_ERR;
}

byte  MDBWaitTime = 255;  // deve essere maggiore di 200ms, il tempo di reset bus MDB
byte  MDBmaxWaitTime = 30;
byte  MDBtotDevice = 0;

byte            commCfgPort( byte _ch, LPC_Uart_Baud_t _baud, LPC_Uart_WordLenth_t _bits, LPC_Uart_ParitySelect_t _parity, LPC_Uart_StopBit_t _stops )
{
#ifdef  __WIN32__
    return TRUE;
#else //__WIN32__
    dword       divisor;

    switch( _baud )
    {
        case Baud600:       divisor = (SYSTEMFREQ >>6) /    600;    break;
        case Baud9600:      divisor = (SYSTEMFREQ >>6) /   9600;    break;
        case Baud19200:     divisor = (SYSTEMFREQ >>6) /  19200;    break;
        case Baud38400:     divisor = (SYSTEMFREQ >>6) /  38400;    break;
        case Baud57600:     divisor = (SYSTEMFREQ >>6) /  57600;    break;
        case Baud115200:    divisor = (SYSTEMFREQ >>6) / 115200;    break;
        case Baud230400:    divisor = (SYSTEMFREQ >>6) / 230400;    break;
        case Baud460800:    divisor = (SYSTEMFREQ >>6) / 460800;    break;
        case Baud921600:    divisor = (SYSTEMFREQ >>6) / 921600;    break;
        default:            return COMM_BAD_PARAM;
    }
#ifndef BOOT
    if ( _ch == COMM1 )
    {
        U0LCR_bit.DLAB = 1;	            // DLAB = 1
        U0DLM = divisor >> 8;
        U0DLL = divisor;
        U0LCR_bit.DLAB = 0;	            // DLAB = 0
        U0FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
        commConfig[COMM1].FIFOenable = TRUE;
        U0LCR = 0x03 | ((_stops==2)?4:0);
        U0TER_bit.TXEN = 0;
        U0IER = 0x00;

        commIbuf[COMM1].flag = commIbuf[COMM1].r = commIbuf[COMM1].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
        commObuf[COMM1].flag = commObuf[COMM1].r = commObuf[COMM1].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
                                        // UART0 interrupt
        VIC_SetVectoredIRQ( UART0_ISR, (LPC_VicIrqSlots_t)VIC_UART0, VIC_UART0 );
        VIC_EnableInt( 1<<VIC_UART0 );
    }    
    else if ( _ch == COMM2 )
    {
        U1LCR_bit.DLAB = 1;	            // DLAB = 1
        U1DLM = divisor >> 8;
        U1DLL = divisor;
        U1LCR_bit.DLAB = 0;	            // DLAB = 0
        U1FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN;   // fifo enable, 1 level rx
        commConfig[COMM2].FIFOenable = TRUE;
#if RSR903_MDB
        U1LCR = 0x03 | 0x38;                // enable parity as stick 0
#else
        U1LCR = 0x03 | ((_stops==2)?4:0);
#endif
        U1TER_bit.TXEN = 0;
        U1IER = 0x00;

        commIbuf[COMM2].flag = commIbuf[COMM2].r = commIbuf[COMM2].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
        commObuf[COMM2].flag = commObuf[COMM2].r = commObuf[COMM2].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
                                        // UART1 interrupt
        VIC_SetVectoredIRQ( UART1_ISR, (LPC_VicIrqSlots_t)VIC_UART1, VIC_UART1 );
        VIC_EnableInt( 1<<VIC_UART1 );       
    }
    else if ( _ch == COMM3 )
    {       
        U2LCR_bit.DLAB = 1;	            // DLAB = 1
        U2DLM = divisor >> 8;
        U2DLL = divisor;
        U2LCR_bit.DLAB = 0;	            // DLAB = 0
        U2FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
        commConfig[COMM3].FIFOenable = TRUE;
        U2LCR = 0x03 | ((_stops==2)?4:0);
        U2TER_bit.TXEN = 0;
        U2IER = 0x00;

        commIbuf[COMM3].flag = commIbuf[COMM3].r = commIbuf[COMM3].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
        commObuf[COMM3].flag = commObuf[COMM3].r = commObuf[COMM3].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
                                        // UART1 interrupt
        VIC_SetVectoredIRQ( UART2_ISR, (LPC_VicIrqSlots_t)VIC_UART2, VIC_UART2 );
        VIC_EnableInt( 1<<VIC_UART2 );       
    }
    else if ( _ch == COMM3_MDB )
    {       
        // inizializzazione hardware il bus MDB tenendo bassa uscita TXD per 200ms
        PINSEL0 &= ~0x00300000;             // disable TXD, GPIO0.10
        IO0CLR  = 0x00000400;               // GPIO0.10 low
        MDBWaitTime = 200;                  // MDB parte fra 200ms ( tempo di reset )

        U2LCR_bit.DLAB = 1;	            // DLAB = 1
        U2DLM = divisor >> 8;
        U2DLL = divisor;
        U2LCR_bit.DLAB = 0;	            // DLAB = 0
        U2FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
        commConfig[COMM3].FIFOenable = TRUE;
        U2LCR = 0x03 | 0x38;                // enable parity as stick 0
        U2TER_bit.TXEN = 0;
        U2IER = 0x00;

        commIbuf[COMM3].flag = commIbuf[COMM3].r = commIbuf[COMM3].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
        commObuf[COMM3].flag = commObuf[COMM3].r = commObuf[COMM3].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
                                        // UART2 interrupt
        VIC_SetVectoredIRQ( UART2_ISR, (LPC_VicIrqSlots_t)VIC_UART2, VIC_UART2 );
        VIC_EnableInt( 1<<VIC_UART2 );
// DEBUG non funziona ?        (&VICVectPriority0)[VIC_UART2] = 0x0E;  // deve essere prioritario rispetto a timer3 per evitare che scattino i timeout anche se arrivano i caratteri

        //  init timer 3, free running with match
        T3TCR = 0X03;                       // counter reset
        T3IR  = 0XFF;                       // clear int flag
        T3CTCR = 0;                         //  00000000
                                            //        00  every rising PCLK
                                            //      00    -
                                            //  0000      -
        T3TC = 0;                           // clear counter
        T3PR = (TIMER_CLOCK / 1000000) - 1; // 60M/4/15 1 count = 1us
        T3PC = 0;                           // clear prescaler
#if RSR903_MDB
        T3MCR = 0x0000;                     // 00000000 00000000
        T3TCR = 0x01;                       // start timer
#else
        T3MCR = 0x0A00;                     // 00001010 00000000
                                            //     101           stop + int on TMR3
#endif
        T3MR3 = 0;
        T3CCR = 0;
        T3EMR = 0X0000;                     //  00000001 00000000 out = 0
                                            //  0000             -
                                            //      00           EMC3 off
                                            //        00         EMC2 off
                                            //          00       EMC1 off
                                            //            00     EMC0 off
                                            //              0000 -
//        T3TCR = 0X01;                            // start counter
        // Timer 3 interrupt
        VIC_SetVectoredIRQ(TIMER3_ISR, (LPC_VicIrqSlots_t)VIC_TIMER3,VIC_TIMER3);
        VIC_EnableInt(1<<VIC_TIMER3);
        _ch = COMM3;                                            //  InitTimer3
    }
    else if ( _ch == COMM4 )
#else  
    if ( _ch == COMM4 )    
#endif//BOOT         
    {       
        U3LCR_bit.DLAB = 1;	            // DLAB = 1
        U3DLM = divisor >> 8;
        U3DLL = divisor;
        U3LCR_bit.DLAB = 0;	            // DLAB = 0
        U3FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
        commConfig[COMM4].FIFOenable = TRUE;
#if RSR903
        U3LCR = 0x03 | 0x38;                // enable parity as stick 0
#else
        U3LCR = 0x03 | ((_stops==2)?4:0);
#endif
        U3TER_bit.TXEN = 0;
        U3IER = 0x00;

        commIbuf[COMM4].flag = commIbuf[COMM4].r = commIbuf[COMM4].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
        commObuf[COMM4].flag = commObuf[COMM4].r = commObuf[COMM4].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
                                        // UART1 interrupt
        VIC_SetVectoredIRQ( UART3_ISR, (LPC_VicIrqSlots_t)VIC_UART3, VIC_UART3 );
        VIC_EnableInt( 1<<VIC_UART3 );        
    }   
    else
        return COMM_BAD_CH;

    commRxFlash( _ch );
    return commRxIntEn( _ch );
#endif //__WIN32__
}                                               //  commCfgPort




/*--------------------------------------------------------------------------
 | commRxFlash: pulisce buffer seriali
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out:
 +--------------------------------------------------------------------------*/

byte            commRxFlash( byte _ch )
{
#ifndef __WIN32__
#ifndef BOOT
    if ( _ch == COMM1 )
    {
        U0FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
//        memset( &commIbuf[COMM1], 0, sizeof(commIbuf[COMM1]) );
        commIbuf[COMM1].flag = commIbuf[COMM1].r = commIbuf[COMM1].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
    }
    else if ( _ch == COMM2 )
    {
        U1FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
//        memset( &commIbuf[COMM2], 0, sizeof(commIbuf[COMM2]) );
        commIbuf[COMM2].flag = commIbuf[COMM2].r = commIbuf[COMM2].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
    }
    else if ( _ch == COMM3 )
    {
        U2FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
//        memset( &commIbuf[COMM3], 0, sizeof(commIbuf[COMM3]) );
        commIbuf[COMM3].flag = commIbuf[COMM3].r = commIbuf[COMM3].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
    }
    else if ( _ch == COMM4 )
#else
    if ( _ch == COMM4 ) 
#endif        
    {
        U3FCR = (FCR_FIFORXR|FCR_FIFOTXR)|FCR_FIFOEN; // fifo enable, 1 level rx
        commIbuf[COMM4].flag = commIbuf[COMM4].r = commIbuf[COMM4].w = 0; // DEBUG : interrupt potrebbe modificare .r o .w
    }
    else
        return COMM_BAD_CH;
#endif //__WIN32__

    return COMM_NO_ERR;
}                                               //  commRxFlash




/*--------------------------------------------------------------------------
 | commRxIntDis:disabilita interrupt ricezione
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out:
 +--------------------------------------------------------------------------*/

byte            commRxIntDis( byte _ch )
{
#ifndef __WIN32__
#ifndef BOOT    
    if ( _ch == COMM1 )
        U0IER &= ~IER_RBR;
    else if ( _ch == COMM2 )
        U1IER &= ~IER_RBR;
    else if ( _ch == COMM3 )
        U2IER &= ~IER_RBR;    
    else if ( _ch == COMM4 )
#else
    if ( _ch == COMM4 )
#endif        
        U3IER &= ~IER_RBR;
    else
        return COMM_BAD_CH;
#endif //__WIN32__
    return COMM_NO_ERR;
}                                               //  commRxIntDis




/*--------------------------------------------------------------------------
 | commRxIntEn: abilita interrupt ricezione
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out:
 +--------------------------------------------------------------------------*/

byte            commRxIntEn( byte _ch )
{
#ifndef __WIN32__
#ifndef BOOT     
    if ( _ch == COMM1 )
        U0IER |=  IER_RBR;
    else if ( _ch == COMM2 )
        U1IER |=  IER_RBR;
    else if ( _ch == COMM3 )
        U2IER |=  IER_RBR;
    else if ( _ch == COMM4 )
#else
    if ( _ch == COMM4 )        
#endif        
        U3IER |=  IER_RBR;
    else
        return COMM_BAD_CH;
#endif //__WIN32__
    return COMM_NO_ERR;
}                                               //  commRxIntEn




/*--------------------------------------------------------------------------
 | commTxIntDis:disabilita interrupt trasmissione
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out:
 +--------------------------------------------------------------------------*/

byte            commTxIntDis( byte _ch )
{
#ifndef __WIN32__
#ifndef BOOT    
    if ( _ch == COMM1 )
    {
        U0IER &= ~IER_THRE;
        U0TER_bit.TXEN = 0;
    }
    else if ( _ch == COMM2 )
    {
        U1IER &= ~IER_THRE;
        U1TER_bit.TXEN = 0;
    }
    else if ( _ch == COMM3 )
    {
        U2IER &= ~IER_THRE;
        U2TER_bit.TXEN = 0;
    }
    else if ( _ch == COMM4 )
#else
    if ( _ch == COMM4 )
#endif        
    {
        U3IER &= ~IER_THRE;
        U3TER_bit.TXEN = 0;
    }
    else
        return COMM_BAD_CH;
#endif //__WIN32__
    return COMM_NO_ERR;
}                                               //  commTxIntDis




/*--------------------------------------------------------------------------
 | commTxIntEn: abilita interrupt trasmissione
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out:
 +--------------------------------------------------------------------------*/
#if RSR903_MDB
byte  bT_INTERBYTE2 = 0x00;
byte  bT_INTERBYTE3 = 0x00;
byte  bT_INTERBYTE4 = 0x00;
byte  chTemp;
#endif

byte            commTxIntEn( byte _ch )
{
#ifndef __WIN32__
#ifndef BOOT    
    if ( _ch == COMM1 )
    {
        __disable_interrupt();
        if ( U0LSR_bit.THRE )   // buffer vuoto, inserisce carattere
        {
            UART_readTxBuf( &commObuf[COMM1], (byte *)&U0THR );
        }
        else
        {
            U0IER |=  IER_THRE; //
        }
        __enable_interrupt();
        U0TER_bit.TXEN = 1;
    }   
    else if ( _ch == COMM2 )
    {
#if RSR903_MDB
        if (en_test_seriale == FALSE)
        {
            if ( ( T3MCR & 0x0008 ) == 0 )   // inserisce 1' carattere
            {
                UART_readTxBuf( &commObuf[COMM2], &chTemp );  // read
                if( commObuf[COMM2].r == commObuf[COMM2].w )  // if first is also last ( ACK )
                {
                    U1LCR = 0x03 | 0x28;                      // enable STICKY as stick 1
                }
                else
                {
                    U1LCR = 0x03 | 0x38;                      // enable STICKY as stick 0            
                    T3MR1 = T3TC + 104*12;                    // timer to next character
                    T3MCR |= 0x0008;
                }
                U1THR = chTemp;
                U1TER_bit.TXEN = 1;
            }
        }
        else { 
            __disable_interrupt();
            if ( U1LSR_bit.THRE )
            {
                UART_readTxBuf( &commObuf[COMM2], (byte *)&U1THR );
            }
            else
            {
                U1IER |=  IER_THRE;
            }
            __enable_interrupt();        
            U1TER_bit.TXEN = 1;            
        }
#else   
        __disable_interrupt();
        if ( U1LSR_bit.THRE )
        {
            UART_readTxBuf( &commObuf[COMM2], (byte *)&U1THR );
        }
        else
        {
            U1IER |=  IER_THRE;
        }
        __enable_interrupt();        
        U1TER_bit.TXEN = 1;
#endif         
    }
    else if ( _ch == COMM3 )
    {        
        if ( U2LSR_bit.TEMT )   // inserisce 1' carattere
        {
            U2LCR = 0x03 | 0x28;          // enable parity as stick 1
            UART_readTxBuf( &commObuf[COMM3], (byte *)&U2THR );
#if RSR903_MDB
            T3MR3 = T3TC + 104*12;        // timer to reset STICKY bit
            T3MCR |= 0x0200;
#else
            T3TC = 0;
            T3MR3 = 104*12;               // attesa 11*104ms, carattere a 9600 baud trasmesso completamente
            T3TCR = 0x01;
#endif
        }
        U2TER_bit.TXEN = 1;       
    }
    else if ( _ch == COMM4 )
#else
    if ( _ch == COMM4 )        
#endif        
    {
#if RSR903
        if ( ( T3MCR & 0x0040 ) == 0 )   // inserisce 1' carattere
        {
            UART_readTxBuf( &commObuf[COMM4], &chTemp );  // read
            if( commObuf[COMM4].r == commObuf[COMM4].w )  // if first is also last ( ACK )
            {
                U3LCR = 0x03 | 0x28;                      // enable STICKY as stick 1
            }
            else
            {
                U3LCR = 0x03 | 0x38;                      // enable STICKY as stick 0            
                T3MR2 = T3TC + 104*12;                    // timer to next character
                T3MCR |= 0x0040;
            }
            U3THR = chTemp;
            U3TER_bit.TXEN = 1;
        }
#else
        __disable_interrupt();
        if ( U3LSR_bit.THRE )
        {
            UART_readTxBuf( &commObuf[COMM4], (byte *)&U3THR );
        }
        else
        {
            U3IER |=  IER_THRE;
        }
        __enable_interrupt();
        U3TER_bit.TXEN = 1;
#endif
    }   
    else
        return COMM_BAD_CH;
#endif //__WIN32__
    return COMM_NO_ERR;
}                                               //  commTxIntEn




/*--------------------------------------------------------------------------
 | commGetChar: legge un carattere dal buffer della seriale
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out: byte    COMM_NO_ERR     ok, dato letto
 |              COMM_BAD_CH     numero seriale non valido
 |              COMM_RX_EMPTY   nessun dato disponibile
 +--------------------------------------------------------------------------*/

byte            commGetChar( byte _ch, byte *_data )
{
    _RING_BUF_  *p;
    word        r;

    if ( _ch != COMM1 && _ch != COMM2 && _ch != COMM3 && _ch != COMM4 )
        return COMM_BAD_CH;

    p = &commIbuf[_ch];
    r = p->r;
    if ( r == p->w )
        return COMM_RX_EMPTY;
    if ( _data != NULL )
        *_data = p->buf[r];
    if ( r == (COMM_BUF-1) )
        p->r = 0;
    else
        p->r = r + 1;

    return COMM_NO_ERR;
}                                               //  commGetChar




/*--------------------------------------------------------------------------
 | commPutChar: inserisce un carattere dal buffer della seriale
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out: byte    COMM_NO_ERR     ok, dato letto
 |              COMM_BAD_CH     numero seriale non valido
 |              COMM_TX_FULL    overflow buffer trasmissione
 +--------------------------------------------------------------------------*/

#if MDB_DEBUG_MMC
static  byte        mmcdebug_started = 0;
static  uint32_t    mmcdebug_pstart,  mmcdebug_psize;
static	uint8_t     mmcdebug_pactive, mmcdebug_ptype;
static	VOLINFO     mmcdebug_vi;
static	FILEINFO    mmcdebug_fi;
static  word        mmcdebug_w;

byte            mmcLogData( void )
{
    uint32_t    successcount;
    word        nb;
   
    if ( mmcPresent )
    {
        if ( mmcdebug_started == 0 )
        {
            MDBsafeMode();

            mmcdebug_started = 1;
            mmcdebug_w = 0;

            // Obtain pointer to first partition on first (only) unit
            mmcdebug_pstart = DFS_GetPtnStart(0, sector, 0, &mmcdebug_pactive, &mmcdebug_ptype, &mmcdebug_psize);
            if ( mmcdebug_pstart == 0xffffffff )
            {
                DispStr( 0, 0, " PARTITION ERROR" );
                return 3;
            }

            if ( DFS_GetVolInfo(0, sector, mmcdebug_pstart, &mmcdebug_vi) )
            {
                DispStr( 0, 0, " VOLUME ERROR   " );
                return 4;
            }

            if ( DFS_OpenFile(&mmcdebug_vi, "DATALOG.DAT", DFS_WRITE, sector, &mmcdebug_fi) != 0 )
            {
                DispStr( 0, 0, (char *)MSG_FW_NO_OPEN );
                return 3;
            }
        }
        if ( commObuf[COMM1].w >= mmcdebug_w )
            nb = commObuf[COMM1].w-mmcdebug_w;
        else
            nb = SECTOR_SIZE;
        if ( nb >= SECTOR_SIZE )
        {
            DispStr( 0, 0, " WRITE LOG FILE " );
            MDBsafeMode();
            DFS_WriteFile( &mmcdebug_fi, sector, &commObuf[COMM1].buf[mmcdebug_w], &successcount, SECTOR_SIZE );
            mmcdebug_w = (mmcdebug_w+SECTOR_SIZE)&(COMM_BUF-1);
        }
    }
    return 0;
}
#endif

static byte     _commPutChar( byte _ch, byte _data )
{
    word        idx;
    _RING_BUF_  *p;

    if ( _ch != COMM1 && _ch != COMM2 && _ch != COMM3 && _ch != COMM4 )
        return COMM_BAD_CH;

    p = &commObuf[_ch];   
    if ( p->w == (COMM_BUF-1) )
        idx = 0;
    else
        idx = p->w + 1;
    if ( idx == p->r )
        return COMM_TX_FULL;
    p->buf[p->w] = _data;
    p->w = idx;
    return( COMM_NO_ERR );      
}
byte            commPutChar( byte _ch, byte _data )
{
    byte ret;
    
    if( ret = _commPutChar( _ch, _data ) )
        return( ret );
    // abilita trasmissione
    return commTxIntEn( _ch );
}                                               //  commPutChar

void            commPutStr( byte _ch, byte *_str )
{
    while ( *_str != '\0' )
    {
        while( commPutChar( _ch, *_str ) );
        _str++;
    }
}                                               //  commPutStr


void            commPutDecimal( byte _ch, unsigned long val, byte len )
{
    if( len >= 6 )      commPutChar( _ch, '0'+((val/100000)%10) );
    if( len >= 5 )      commPutChar( _ch, '0'+((val/10000 )%10) );
    if( len >= 4 )      commPutChar( _ch, '0'+((val/1000  )%10) );
    if( len >= 3 )      commPutChar( _ch, '0'+((val/100   )%10) );
    if( len >= 2 )      commPutChar( _ch, '0'+((val/10    )%10) );
    if( len >= 1 )      commPutChar( _ch, '0'+((val/1     )%10) );
}


/*--------------------------------------------------------------------------
 | commIsEmpty: verifica se ci sono byte disponibili nel buffer della seriale
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out: BOOL    FALSE           ok, dati disponibili
 |              TRUE            nessun dato disponibile
 +--------------------------------------------------------------------------*/

BOOL            commIsEmpty( byte _ch )
{
    if ( _ch != COMM1 && _ch != COMM2 && _ch != COMM3 && _ch != COMM4 )
        return TRUE;

    if ( commIbuf[_ch].r == commIbuf[_ch].w )
        return TRUE;

    return FALSE;
}                                               //  commIsEmpty




/*--------------------------------------------------------------------------
 | commIsFull:  verifica se ci sono byte disponibili nel buffer della seriale
 |                              --------------
 | In:  _ch     0,1                             numero seriale
 | Out: BOOL    TRUE            ok, dati disponibili
 |              FALSE           nessun dato disponibile
 +--------------------------------------------------------------------------*/

BOOL            commIsFull( byte _ch )
{
    if ( _ch != COMM1 && _ch != COMM2 && _ch != COMM3 && _ch != COMM4 )
        return TRUE;

    if ( commIbuf[_ch].r == commIbuf[_ch].w )
        return TRUE;

    return FALSE;
}                                               //  commIsFull




/*--------------------------------------------------------------------------
 | UART0_ISR:   interrupt routine per UART0 (COMM1)
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#ifndef __WIN32__
void            UART0_ISR( void )
{  
    byte        i, temp;

    switch( (U0IIR>>1)&0x7 )
    {
        case IIR_THRE:                  // continue sending data
                                        // Check for Transmitter FIFO enable
            if ( commConfig[COMM1].FIFOenable )
                i = FIFODEEP;           // when FIFO is enable load FIFODEEP bytes
            else
                i = 1;                  // when FIFO is disable load 1 byte
            do {
            // Check for software FIFO state and load data into transmitter hold register
            // disable interups imediatly aftre write when FIFO is empty
                if ( !UART_readTxBuf(&commObuf[COMM1], (byte *)&U0THR) || commObuf[COMM1].r == commObuf[COMM1].w )
                {
                                        // Disable interrupt when TX BUFFER is empty
                    U0IER_bit.THREIE = FALSE;
                    break;
                }
            } while( --i );
            break;

        case IIR_RSL:	                // error manage
            temp = U0LSR;
            commIbuf[COMM1].flag |= (temp & 0x9E);
            break;

        case IIR_RDA:	                // receive data
        case IIR_CTI:	                // time out
            UART_writeRxBuf( &commIbuf[COMM1], U0RBR );
            break;

        default:
            break;
    }
    VICAddress = 0;                     // Clear interrupt in VIC.
}                                               //  UART0_ISR
#endif //__WIN32__




/*--------------------------------------------------------------------------
 | UART1_ISR:   interrupt routine per UART1 (COMM2)
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#ifndef __WIN32__
void            UART1_ISR( void )
{
    byte        i, temp;

    switch( (U1IIR>>1)&0x7 )
    {
        case IIR_THRE:                  // continue sending data
                                        // Check for Transmitter FIFO enable
            if ( commConfig[COMM2].FIFOenable )
                i = FIFODEEP;           // when FIFO is enable load FIFODEEP bytes
            else
                i = 1;                  // when FIFO is disable load 1 byte
            do {
            // Check for software FIFO state and load data into transmitter hold register
            // disable interups imediatly aftre write when FIFO is empty
                if ( !UART_readTxBuf(&commObuf[COMM2], (byte *)&U1THR) || commObuf[COMM2].r == commObuf[COMM2].w )
                {                       // Disable interrupt when TX BUFFER is empty
                    U1IER_bit.THREIE = FALSE;
                    break;
                }
            } while(--i);
            break;

        case IIR_RSL:	                // error manage
            temp = U1LSR;
            commIbuf[COMM2].flag |= (temp & 0x9E);
#if RSR903_MDB
            T3MCR &= (~0x0008 );
#endif
            break;

        case IIR_RDA:	                // receive data
        case IIR_CTI:	                // time out
#if RSR903_MDB
            T3MR1 = T3TC + T_INTERBYTE;        // attesa 2ms
            T3MCR |= 0x0008;
            bT_INTERBYTE2 = 0x20;
#endif
            UART_writeRxBuf( &commIbuf[COMM2], U1RBR );
            break;

        default:
            break;
    }
    VICAddress = 0;                     // Clear interrupt in VIC.
}                                               //  UART1_ISR
#endif //__WIN32__




/*--------------------------------------------------------------------------
 | UART2_ISR:   interrupt routine per UART2 (COMM3)
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#ifndef __WIN32__
void            UART2_ISR( void )
{
    byte        i, temp;

    switch( (U2IIR>>1)&0x7 )
    {
        case IIR_THRE:                  // continue sending data
                                        // Check for Transmitter FIFO enable
            if ( commConfig[COMM3].FIFOenable )
                i = FIFODEEP;           // when FIFO is enable load FIFODEEP bytes
            else
                i = 1;                  // when FIFO is disable load 1 byte
            T3MR3 = T_RESPONSE;
            do {
            // Check for software FIFO state and load data into transmitter hold register
            // disable interups imediatly aftre write when FIFO is empty
                commIbuf[COMM3].r = commIbuf[COMM3].w;//flush input
                if ( !UART_readTxBuf(&commObuf[COMM3], (byte *)&U2THR) || commObuf[COMM3].r == commObuf[COMM3].w )
                {                       // Disable interrupt when TX BUFFER is empty
                    U2IER_bit.THREIE = FALSE;
#if RSR903_MDB  
                    T3MR3 += T3TC;
                    T3MCR |= 0x0200;
                    bT_INTERBYTE3 = 0x40;
#else
                    T3TC = 0;           // start t-response time
                    T3TCR = 0x01;
#endif
                    break;
                }
                T3MR3 += 104*11;        // timeout aumenta per tenere conto del tempo di trasmissione dei caratteri inseriti nella FIFO
            } while(--i);
            break;

        case IIR_RSL:	                // error manage
            if( ( temp = U2LSR ) == 0x04 ) // parity error, corrisponde all'ultimo carattere in MDB ( MODE BIT ALTO )
              ;
            commIbuf[COMM3].flag |= (temp & 0x9E);
#if RSR903_MDB
            T3MCR &= (~0x0200 );
#else
            T3TCR = 0X00;               // ferma t-response time
#endif
            break;

        case IIR_CTI:	                // time out ( interbyte time !! with NO activity)

        case IIR_RDA:	                // receive data
            UART_writeRxBuf( &commIbuf[COMM3], ( temp = U2RBR ) );
            DEBUG_MDB_CHAR(0x40,temp);
#if RSR903_MDB
            T3MR3 = T3TC + T_INTERBYTE;        // attesa 2ms
            T3MCR |= 0x0200;
            bT_INTERBYTE3 = 0x20;
#else
            T3TC = 0;                   // start interbyte time
            T3MR3 = T_INTERBYTE;        // attesa 2ms
            T3TCR = 0x01;
#endif
            break;

        default:
            break;
    }
    VICAddress = 0;                     // Clear interrupt in VIC.
}                                               //  UART2_ISR
#endif //__WIN32__


/*
    Timer in asservimento al canale che supporta MDB
    Timer3/Match3 >> MDB Master
    - in trasmissione, gestisce il primo carattere ( STICK ) per gestire MODE bits
    - in ricezione, gestisce l'interbyte time da 5ms
    Timer3/Match2 >> MDB Slave
    - in trasmissione, gestisce il primo carattere ( STICK ) per gestire MODE bits
    - in ricezione, gestisce l'interbyte time da 5ms
*/
#ifndef __WIN32__
void	        TIMER3_ISR( void )
{
#if RSR903
    // MDB Slave
    if( T3IR & 0x04 )
    {
        T3IR = 0x04;         // disable interrupt
        T3MCR &= (~0x0040 );  // disable match
        
        if( commObuf[COMM4].r != commObuf[COMM4].w ) {  // sono in trasmissione
            UART_readTxBuf( &commObuf[COMM4], &chTemp );  // read
            if( commObuf[COMM4].r == commObuf[COMM4].w )  // if last
            {
                U3LCR = 0x03 | 0x28;                      // enable STICKY as stick 1
                T3MR2 = T3TC + 104*12 + T_RESPONSE;
                bT_INTERBYTE4 = 0x40;
//                T3MCR |= 0x0040;                        // needed to receive ACK TODO+++
            }
            else
            {
                U3LCR = 0x03 | 0x38;          // enable parity as stick 0
                T3MR2 = T3TC + 104*12;                    // timer to reset STICKY bit
                T3MCR |= 0x0040;
            }
            U3THR = chTemp;
        }
        else {                                          // sono in ricezione
            // scaduto t-response o interbyte time
            commIbuf[COMM4].flag |= bT_INTERBYTE4;
        }
    }
#endif
#if RSR903_MDB    
    // MDB Slave1
    if( T3IR & 0x02 )
    {
        T3IR = 0x02;         // disable interrupt
        T3MCR &= (~0x0008 );  // disable match
        
        if( commObuf[COMM2].r != commObuf[COMM2].w ) {  // sono in trasmissione
            UART_readTxBuf( &commObuf[COMM2], &chTemp );  // read
            if( commObuf[COMM2].r == commObuf[COMM2].w )  // if last
            {
                U1LCR = 0x03 | 0x28;                      // enable STICKY as stick 1
                T3MR1 = T3TC + 104*12 + T_RESPONSE;
                bT_INTERBYTE2 = 0x40;
//                T3MCR |= 0x0008;                        // needed to receive ACK TODO+++
            }
            else
            {
                U1LCR = 0x03 | 0x38;          // enable parity as stick 0
                T3MR1 = T3TC + 104*12;                    // timer to reset STICKY bit
                T3MCR |= 0x0008;
            }
            U1THR = chTemp;
        }
        else {                                          // sono in ricezione
            // scaduto t-response o interbyte time
            commIbuf[COMM2].flag |= bT_INTERBYTE2;
        }
    }
    
    // MDB Master
    if( T3IR & 0x08 )
    {
        T3IR = 0x08;         // disable interrupt
        T3MCR &= (~0x0200 );  // disable match
        
        if( commObuf[COMM3].r != commObuf[COMM3].w ) {  // sono in trasmissione
            U2LCR = 0x03 | 0x38;                        // enable parity as stick 0
            U2IER |=  IER_THRE;
        }
        else {                                          // sono in ricezione
            // scaduto t-response o interbyte time
            commIbuf[COMM3].flag |= bT_INTERBYTE3;
        }
    }
#else
    T3IR = 0XFF;

    if( commObuf[COMM3].r != commObuf[COMM3].w ) {  // sono in trasmissione
        U2LCR = 0x03 | 0x38;          // enable parity as stick 0
        U2IER |=  IER_THRE;
    }
    else {                                          // sono in ricezione
        // scaduto t-response o interbyte time
        if( T3MR3 == T_INTERBYTE )
          commIbuf[COMM3].flag |= 0x20;
        else
          commIbuf[COMM3].flag |= 0x40;
    }
#endif
    VICAddress = 0;                     // Clear interrupt in VIC.
}                                               //  TIMER3_ISR
#endif //__WIN32__




/*--------------------------------------------------------------------------
 | UART3_ISR:   interrupt routine per UART3 (COMM4)
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

#ifndef __WIN32__
void            UART3_ISR( void )
{
    byte        i, temp;
//FIO2CLR = 0x1L;
    switch( (U3IIR>>1)&0x7 )
    {
        case IIR_THRE:                  // continue sending data
                                        // Check for Transmitter FIFO enable
            if ( commConfig[COMM4].FIFOenable )
                i = FIFODEEP;           // when FIFO is enable load FIFODEEP bytes
            else
                i = 1;                  // when FIFO is disable load 1 byte
            do {
            // Check for software FIFO state and load data into transmitter hold register
            // disable interups imediatly after write when FIFO is empty
                if ( !UART_readTxBuf(&commObuf[COMM4], (byte *)&U3THR) || commObuf[COMM4].r == commObuf[COMM4].w )
                {                       // Disable interrupt when TX BUFFER is empty
                    U3IER_bit.THREIE = FALSE;
                    break;
                }
            } while(--i);
            break;

        case IIR_RSL:	                // error manage
            temp = U3LSR;
            commIbuf[COMM4].flag |= (temp & 0x9E);
#if RSR903
            T3MCR &= (~0x0040 );
#endif
            break;

        case IIR_RDA:	                // receive data
        case IIR_CTI:	                // time out
#if RSR903
            T3MR2 = T3TC + T_INTERBYTE;        // attesa 2ms
            T3MCR |= 0x0040;
            bT_INTERBYTE4 = 0x20;
#endif
            UART_writeRxBuf( &commIbuf[COMM4], U3RBR );
            break;

        default:
            break;
    }
    VICAddress = 0;                     // Clear interrupt in VIC.
//FIO2SET = 0x1L;
}                                               //  UART3_ISR
#endif //__WIN32__




/*
    Event buffer
*/

struct S_EVENT sEvent[16], *pEventW = sEvent;

void            InsertEvent( unsigned short  event, unsigned long  val )
{
    DEBUG_MDB_EXTRA(0xFE);
    DEBUG_MDB_EXTRA(event);
    DEBUG_MDB_EXTRA(val);

    pEventW->event = event;
    pEventW->val = val;
    memcpy( &(pEventW->timeStamp), &dateTime, sizeof( dateTime ) );
    if( ++pEventW >= &sEvent[16] ) pEventW = sEvent;
}

void            InsertEvent1( unsigned short  event, unsigned long  val, unsigned long  param0 )
{
    DEBUG_MDB_EXTRA(0xFD);
    DEBUG_MDB_EXTRA(event);
    DEBUG_MDB_EXTRA(val);
    DEBUG_MDB_EXTRA(param0);

    pEventW->event = event;
    pEventW->val = val;
    pEventW->param[0] = param0;
    memcpy( &(pEventW->timeStamp), &dateTime, sizeof( dateTime ) );
    if( ++pEventW >= &sEvent[16] ) pEventW = sEvent;
}

void            InsertEvent2( unsigned short  event, unsigned long  val, unsigned long  param0, unsigned long  param1 )
{
    DEBUG_MDB_EXTRA(0xFC);
    DEBUG_MDB_EXTRA(event);
    DEBUG_MDB_EXTRA(val);
    DEBUG_MDB_EXTRA(param0);
    DEBUG_MDB_EXTRA(param1);

    pEventW->event = event;
    pEventW->val = val;
    pEventW->param[0] = param0;
    pEventW->param[1] = param1;
    memcpy( &(pEventW->timeStamp), &dateTime, sizeof( dateTime ) );
    if( ++pEventW >= &sEvent[16] ) pEventW = sEvent;
}

/*
    Macchina a stati MASTER MDB

    Chiamata ogni ms.

    Vi e' una macchina a stati di alto livello che controlla il bus
    - ciclicamente interroga le varie periferiche, concedendo a ciascuna un po di tempo
      ed all'interno di ogni periferica gestisce i comandi per la stessa
    - se una periferica NON risponde per oltre il suo MAX_NONRESPONSE_TIME deve essere
      interrogata con un RESET almeno ogni 10 secondi
*/
#define MDB_ACK   0x00
#define MDB_NAK   0xAA
#define MDB_RET   0xFF

byte            Changer( void );
byte            BillValidator( void );
byte            CashLess( void );
static void     SetMicroMechSpeed( void );
void            StartBillMicromech( void );
byte            BillMicromech( void );
void            EndBillMicromech( void );
byte            PriceDisplay( void );
byte            SimpleSlave( void );
byte            CoinMicromech( void );
static BOOL     CoinMicromechAttached( void );

#define RESETPOLL   0

struct  S_MDBPerif {
  char          addr;
  dword         max_noresponse_time, max_noresponse_timer;
  dword         reset_poll_time, reset_poll_timer;
  unsigned short  status;
  byte          cmd[MAX_MDB_FRAME], cmd_len, cmd_repeat;
  byte          (*fnz)(void);
} MDBPerif[] =   { { 0x08, 2000, 1, 0, 0, RESETPOLL, { 0x08, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 1, 0, Changer },
                   { 0x10, 2000, 1, 0, 0, RESETPOLL, { 0x10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 1, 0, CashLess },
//                   { 0x18, 2000, 1, 0, 0, RESETPOLL, { 0x18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x20, 2000, 1, 0, 0, RESETPOLL, { 0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x28, 2000, 1, 0, 0, RESETPOLL, { 0x28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
                   { 0x30, 5000, 1, 0, 0, RESETPOLL, { 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 1, 0, BillValidator },
//                   { 0x38, 2000, 1, 0, 0, RESETPOLL, { 0x38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
#if SLAVE_MACHINE
                   { 0x40, 2000, 1, 0, 0, RESETPOLL, { 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, SimpleSlave },
                   { 0x48, 2000, 1, 0, 0, RESETPOLL, { 0x48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, SimpleSlave },
                   { 0x50, 2000, 1, 0, 0, RESETPOLL, { 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, SimpleSlave },
#endif
//                   { 0x58, 2000, 1, 0, 0, RESETPOLL, { 0x58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
                   { 0x60, 2000, 1, 0, 0, RESETPOLL, { 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 1, 0, CashLess },
//                   { 0x68, 2000, 1, 0, 0, RESETPOLL, { 0x68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x70, 2000, 1, 0, 0, RESETPOLL, { 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x78, 2000, 1, 0, 0, RESETPOLL, { 0x78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x80, 2000, 1, 0, 0, RESETPOLL, { 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x88, 2000, 1, 0, 0, RESETPOLL, { 0x88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x90, 2000, 1, 0, 0, RESETPOLL, { 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0x98, 2000, 1, 0, 0, RESETPOLL, { 0x98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xA0, 2000, 1, 0, 0, RESETPOLL, { 0xA0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xA8, 2000, 1, 0, 0, RESETPOLL, { 0xA8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xB0, 2000, 1, 0, 0, RESETPOLL, { 0xB0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xB8, 2000, 1, 0, 0, RESETPOLL, { 0xB8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xC0, 2000, 1, 0, 0, RESETPOLL, { 0xC0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xC8, 2000, 1, 0, 0, RESETPOLL, { 0xC8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xD0, 2000, 1, 0, 0, RESETPOLL, { 0xD0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xD8, 2000, 1, 0, 0, RESETPOLL, { 0xD8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
#if LED_DISPLAY_PRICE
                   { 0xE0, 2000, 1, 0, 0, RESETPOLL, { 0xE0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 1, 0, PriceDisplay },
#endif              
//                   { 0xE8, 2000, 1, 0, 0, RESETPOLL, { 0xE8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, NULL },
//                   { 0xF0, 2000, 1, 0, 0, RESETPOLL, { 0xF0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, CoinMicromech },
#if SERIAL_BILL_VALIDATOR
                   { 0xF8, 2000, 1, 0, 0, RESETPOLL, { 0xF8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0}, 0, 0, BillMicromech },
#endif
                 };

//#define MDBReset(a) { pMDBPerif->cmd[0] = a; pMDBPerif->cmd_len = 1; pMDBPerif->cmd_repeat = 0; pMDBPerif -> status = RESETPOLL; }
#define MDBReset(a) { pMDBPerif -> status = RESETPOLL; (pMDBPerif->fnz)(); }

BOOL            MDB_started = FALSE;
#define         MDB_in_use()  (FIO3PIN & BIT26)
byte            Micromech_needs_uart = 1;

byte            ans[64], ans_len;
struct S_MDBPerif *pMDBPerif = &MDBPerif[0];
dword           MDBTime = 0L;

byte            MDBsafeMode( void )
{
    DWORD       maxloop;

    if( !MDB_started )
        return 0;
                                        // place MDB in a safe condition
    for ( maxloop = 0 ; maxloop < 1000000; maxloop++ )
    {
        if ( MDBWaitTime == 1 )
            return 0;
    }
    return 1;
}

#if RSR903
void    MDBSlave( void );
#endif
#if RSR903_MDB
void    MDBSlave1( void );
#endif

//byte vv[256], vvidx = 0;
//DEBUG : MDB dovrebbe partire DOPO che e' stata inizializzata la seriale COMM3
void  MDB( void )
{
#ifndef __WIN32__
    char        i;
    byte        *pCh, crc;

    if( !MDB_started )
      return;

#if RSR903
    MDBSlave( );
#endif
#if RSR903_MDB    
    MDBSlave1( );
#endif
//    vv[vvidx++] = pMDBPerif->cmd[0]; vvidx &= 0xFF;
//    vv[vvidx++] = commIbuf[COMM3].flag; vvidx &= 0xFF;
//    vv[vvidx++] = commIbuf[COMM3].w; vvidx &= 0xFF;
//    vv[vvidx++] = commIbuf[COMM3].r; vvidx &= 0xFF;
//    vv[vvidx++] = commObuf[COMM3].r; vvidx &= 0xFF;
//    vv[vvidx++] = commObuf[COMM3].w; vvidx &= 0xFF;


// MDBWaitTime stabilisce anche la massima velocita' di interrogazione del BUS
// se interrogo troppo rapidamente, es. MARS TRC6512 non accetta i tasti di dispense
// e talvolta invia le monete in cassa invece che nei tubi
    
    MDBTime++;
    if ( pMDBPerif->fnz == BillMicromech )
    {
        if( BillMicromech() != 0 )
            goto MDB1;
        return;
    }
    if ( pMDBPerif->fnz == Changer && CoinMicromechAttached( ) )  // micromech is connected, MDB changer is disabled
    {
        if( Micromech_needs_uart )
        {
            SetMicroMechSpeed();
            return;
        }
        EndBillMicromech();
        goto MDB1;
    }

    if( MDBWaitTime != 0 )
    {
      if( --MDBWaitTime != 0 )
        return;
      goto MDB1;
    }
    if( (PINSEL0 & 0x00100000) == 0 )
    {
        MDBWaitTime = 200;              // attesa dopo reset HW
        PINSEL0 |=  0x00100000;             // enable TXD2 ( fine reset MDB )
    }
    if( commIbuf[COMM3].flag == 0 )     // attesa risposta di qualsiasi genere
      return;

    if( ( commIbuf[COMM3].flag & 0x40 ) != 0 &&  // scaduto t-response
          commIsEmpty(COMM3)                     // senza nessun carattere nel buffer ( timer3 potrebbe essere servito prima di IRQ_UART2 perche' piu' prioritario )
//          commIbuf[COMM3].flag == 0x20 ||  // scaduto interbyte
/*        ( commIbuf[COMM3].flag & 0x04 ) == 0 */ )   // non arrivato MODE bit
    {
      ans_len = 0;
    }
    else
    {
      // check CRC, length
      ans_len = 0; crc = 0; pCh = ans;
      while( commGetChar( COMM3, pCh) != COMM_RX_EMPTY )
      {
        if ( (ans_len+1) < sizeof(ans) )
        {
          crc += *pCh++;
          ans_len++;
        }
      }
      --pCh;
      crc -= (*pCh*2);                // verifica CRC
    }

    if(   ans_len == 0 ||                       // nessuna risposta significativa, probabilmente solo rumore
        ( ans_len == 1 && crc == MDB_NAK ) ||   // NAK
        ( ans_len > 1  && crc != 0   ) )        // errore di CRC
    {
      // ciclo di ricerca periferica inviando periodicamente RESET
      if( pMDBPerif->cmd[0] == pMDBPerif->addr )
      {
        if( (MDBTime-pMDBPerif->reset_poll_timer) >= 10000 )  // scaduto tempo attesa reset
        {
          MDBReset( pMDBPerif->addr );
          pMDBPerif -> reset_poll_timer = MDBTime;// restart reset
        }
        else
          pMDBPerif->cmd_len = 0;                 // nessun comando, attesa
      }
      // periferica connessa, ciclo retry comandi
      else
      {
        // scaduto max_noresponse : reset periferica, restart Reset Poll
        if( (MDBTime-pMDBPerif->max_noresponse_timer ) > pMDBPerif->max_noresponse_time )
        {
          MDBReset( pMDBPerif->addr );
          pMDBPerif -> reset_poll_timer = MDBTime - 10000L;
          pMDBPerif->max_noresponse_time = 2000;          // riporta al valore defauls (DEBUG : dipende dall'indirizzo della periferica !!)
        }
        // ripete comando ( non ho avuto nessuna risposta al comando )
        else if( ans_len == 0 )
        {
          // ripete comando, che potrebbe essere RET se l'ultimo comando e' un RET
        }
        // se comando va ripetuto, ho un massimo di volte per cui la ripetizione e' ammessa
        // scaduto il numero di ripetizioni, reset periferica
        else if( pMDBPerif->cmd_repeat != 0 )
        {
          if( pMDBPerif->cmd_repeat != 0xFF )
          {
            if( --pMDBPerif->cmd_repeat == 0 )
            {
              MDBReset( pMDBPerif->addr );
              pMDBPerif -> reset_poll_timer = MDBTime - 10000;
            }
          }
          // ripete comando, che potrebbe essere RET se l'ultimo comando e' un RET
        }
        else  // invia RET, cambiando definitivamente il comando inviato.
        {
          pMDBPerif->cmd[0] = MDB_RET;
          pMDBPerif->cmd_len = 1;
          pMDBPerif->cmd_repeat = 0;  // attende max_noresponsetime
        }
      }
    }
    else
    {
      // answer is ok, with correct CRC and mode bit
      pMDBPerif-> max_noresponse_timer = MDBTime;
      // Handle peripheral
      // set next cmd
      if ( (pMDBPerif->fnz)() != 0 )
      {
        U2THR = MDB_ACK;      // send ACK
        DEBUG_MDB_CHAR(0x00,MDB_ACK);
      }
      MDBWaitTime = MDBmaxWaitTime;     // wait ms prima di mandare altro comando
      return;
    }

    // passa alla periferica successiva ( che sia definita )
MDB1:
    if( pMDBPerif->cmd[0] == MDB_RET )  // RET
    {
      U2THR = MDB_RET;        // send RET
      DEBUG_MDB_CHAR(0x00,MDB_RET);
      // attende risposta
#if RSR903_MDB
      T3MR3 = T3TC + T_RESPONSE;
      T3MCR |= 0x0200;
#else
      T3TC = 0;               // start t-response time
      T3MR3 = T_RESPONSE;
      T3TCR = 0x01;
#endif
      commIbuf[COMM3].flag = 0;
    }
    else
    {
        do {
            if ( ++pMDBPerif >= &MDBPerif[sizeof(MDBPerif)/sizeof(struct S_MDBPerif)] )
            {
                pMDBPerif = MDBPerif;
                if ( MDBtotDevice == 0 )
                    MDBmaxWaitTime = 30;
                else
                    MDBmaxWaitTime = 30/MDBtotDevice;
                MDBtotDevice = 0;
            }
        } while( pMDBPerif->fnz == NULL );
        if ( pMDBPerif->fnz == BillMicromech )
            StartBillMicromech();
        else if ( pMDBPerif->fnz == Changer && CoinMicromechAttached( ) )
            return;
        else
            EndBillMicromech();
#if MDB_DEBUG        
        debuggaTutto();
#endif
        if ( pMDBPerif->status != RESETPOLL )
            MDBtotDevice++;

        if( ( i = pMDBPerif->cmd_len) != 0 )
        {
            pCh = pMDBPerif->cmd;
            crc = 0;
            while( i-- != 0 )
            {
                _commPutChar( COMM3, *pCh );  // store in buffer
                crc += *pCh++;
            }
            commPutChar( COMM3, crc );        // start transmission
            // attende risposta
            commIbuf[COMM3].flag = 0;
        }

    }
#endif //__WIN32__
}

/*
    Gestione periferica Changer
*/

struct S_SETUP {
  byte  Feature_Level;
  unsigned short Country_Currency_Code;
  byte  Scaling_Factor;
  byte  Decimal_Places;
  unsigned short Coin_Type_Routing;
  unsigned short Coin_Type_Credit[16];
};

struct S_TUBE_STATUS {
  unsigned short Tube_Full_Status;
  unsigned char  Tube_Status[16];
  unsigned char  Escrow_Status[16];
};

struct S_COIN_STATUS {
  unsigned short Coin_Enable;
  unsigned short Manual_Dispense_Enable;
};

struct S_LEVEL_THREE_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  unsigned short Software_Version;
  union {
    char  Optional_Features[4];
    struct {  // tengo conto dell'endianess, [0] e' LSB, [3] e' MSB
      unsigned long unusedH:24 ;
      unsigned long payout:1 ;
      unsigned long extended_diagnostic:1 ;
      unsigned long manual_fill:1 ;
      unsigned long FTL:1 ;
      unsigned long unusedL:4 ;
    }Options;
  };
};

struct S_CHANGE_CCMD {
  unsigned short Coin_Enable;       // desired coin enable state
};


struct S_CHANGE {
  struct S_SETUP Setup;
  struct S_TUBE_STATUS TubeStatus;
  struct S_COIN_STATUS CoinStatus;
  struct S_LEVEL_THREE_CAPABILITIES LevelTreeCapabilities;
  struct S_CHANGE_CCMD Cmd;
  byte          tubeStatus;             // 1=tube status read, 0=tube status need to be readed
  byte          tubeCountOverride;      // 0=override tube status with minimum value, 1=standard count
} Change;

enum  eChangerCmd { CHANGE_RESET=0,
                    CHANGE_SETUP,
                    CHANGE_TUBE_STATUS,
                    CHANGE_POLL,
                    CHANGE_COIN_TYPE,
                    CHANGE_DISPENSE,
                    CHANGE_NULL,
                    CHANGE_EXPANSION_ID = 0x0007,
                    CHANGE_EXPANSION_FEATURES_ENABLE = 0x0107,
                    CHANGE_EXPANSION_PAYOUT = 0x0207,
                    CHANGE_EXPANSION_PAYOUT_STATUS = 0x0307,
                    CHANGE_EXPANSION_PAYOUT_POLL = 0x0407,
                    CHANGE_EXPANSION_DIAGNOSTIC = 0x0507,
                    CHANGE_TUBE_STATUS_PAYOUT
                  };

// ChangerCmd indica un comando da eseguire da parte del Changer
// Implementato 1 solo comando : PAYOUT, evente come paranetro CASH, e restituisce il credito NON restituito.
// dovrebbe essere implementato come una coda di messaggi, ciascuno comando-parametri, e l'uscita e'
// una coda di messaggi
#define CHANGER_CMD_PAYOUT  1

struct S_CHANGER_CMD {
  byte  cmd;
  unsigned short val;
  short  response;   // 1 : request, 0 : end comand OK, -1 : end comand with errors
} ChangerCmd, *pChangerCmd = NULL;

void  MDBcmd( byte a, byte b, byte c )
{
    pMDBPerif->cmd[0] =  (a)+pMDBPerif->addr;
    pMDBPerif->cmd_len = b;
    pMDBPerif->cmd_repeat = c;
}

DWORD ChangeCoinInTime = 0;
byte  ChangeInsertedCoin = 0;
byte  ChangeNumberOfCoin = 0;

//#define MDBcmd( a, b, c )   pMDBPerif->cmd[0] =  ((a)+pMDBPerif->addr);      
//                            pMDBPerif->cmd_len = (b);      
//                            pMDBPerif->cmd_repeat = (c);
/*
  Funzionamento tubi MARS TRC6512-MDB
    Se accesa conta le monete che vanno nei tubi, ma indica 0 finche' il numero di monete non raggiunge un minimo
    ( 4 monete da 0.05 e 0,25; 8 monete da 0,10 che sono piu' sottili ); se la gettoniere viene spenta e le monete
    nei tubi sono tali da NON oscurare il sensore di minimo alla riaccensione la gettoniera dice di avere 0 monete
    nei tubi; se ( viceversa ) le monete nei tubi sono tali da raggiungere almeno il minimo, la gettoniera mantiene
    il valore delle monete precedentemente calcolato.
    In pratica la gettoniere indica semple il numero minimo di monete di cui e' sicura essere presenti nei tubi,
    dove i sensori di vuoto hanno la priorita'.
    L'unico problema di questo sistema e' che se inserisco una moneta a tubi vuoti e premo la leva di Escrow,
    la moneta e' nei tubi ma non viene erogata. Per tale motivo e' stato aggiunto il Escrow_Status che conta le monete
    nei tubi quando Tube_Status e' zero, ma che viene sempre azzerato quando si preme la leva di escrow; per tale motivo
    Escrow_Status non viene riportato nello stato dei tubi.
*/
word  ChangerTubes( byte tube )
{
  return( Change.TubeStatus.Tube_Status[tube] );
}

word  ChangerTubesEscrow( byte tube )
{
  return( Change.TubeStatus.Tube_Status[tube] + Change.TubeStatus.Escrow_Status[tube] );
}

/*
  verify tube status for exact change (1) enable, or normal operation (0)
  i Changer is not connected, the function will answer normal operation (0)
*/

byte            ChangerExactChange( void )
{
    byte        i;

    for ( i = 0; i < 16; i++ )
    {
        if ( ( Change.Setup.Coin_Type_Routing & (1<<i) ) &&     // go on tube
             ( Change.Setup.Coin_Type_Credit[i] == 5 ||
               Change.Setup.Coin_Type_Credit[i] == 10 ||
               Change.Setup.Coin_Type_Credit[i] == 25 )  &&     // 5,10,25 only
                Change.TubeStatus.Tube_Status[i] == 0 )         // empty
            return 1;
    }
    return 0;
}

_Credito        ChangeTubeValue( void )
{
    _Credito    val;
    byte        i;
    
    val = 0;
    for( i = 0; i < 16; i++ )
    {
        if( Change.Setup.Coin_Type_Routing & (1<<i) )
            val += Change.TubeStatus.Tube_Status[i] * Change.Setup.Coin_Type_Credit[i];
    }
    return( val );
}

void            ChangerSetTubeValue( void )
{
    if ( NonVolatileSetup.tubeValue != 0 )
        Change.tubeCountOverride = 0;
}

void            ChangerTubeValueOverride( void )
{
    _Credito    tubeValues[16], total, max;
    byte        i, j, k, c;
    
    if ( Change.tubeCountOverride != 0 )
        return;                         // normal coin count
    Change.tubeCountOverride = 1;
    if ( NonVolatileSetup.tubeValue == 0 )
        return;                         // no fixed minimum value

    if ( ChangeTubeValue() > NonVolatileSetup.tubeValue )
        return;                         // no need to do the calculation
    
    for( i = 0; i < 16; i++ )
    {
        if ( Change.Setup.Coin_Type_Routing & (1<<i) )
            tubeValues[i] = Change.Setup.Coin_Type_Credit[i];
        else
            tubeValues[i] = 0;
    }

    total = NonVolatileSetup.tubeValue;
    for( i = 0; i < 16; i++ )
    {
        c = 0;
        max = 1;                        // find the higher money in the tubes
        for( j = 0; j < 16; j++ )
        {
            if ( tubeValues[j] != 0 )
                c++;
            if ( tubeValues[j] > max )
            {
                max = tubeValues[j];
                k = j;
            }
        }
        if ( max == 1 )
            break;
        if ( c == 1 )
            j = (byte)( total   /tubeValues[k]);
        else
            j = (byte)((total/2)/tubeValues[k]);
        if ( Change.TubeStatus.Tube_Status[k] < j && Change.TubeStatus.Tube_Status[i] > 0 )
            Change.TubeStatus.Tube_Status[k] = j;// hope that when there are no coins, it's reported correctly
        total -= j*tubeValues[k];
        tubeValues[k] = 0;
        if ( c == 1 )
            break;                      // finish
    }
}

char *ChangerManufacturer_Code( void )
{
  return( Change.LevelTreeCapabilities.Manufacturer_Code );
}

char            *ChangerSerial_Number( void )
{
  return( Change.LevelTreeCapabilities.Serial_Number );
}

char            *ChangerTuning_Revision( void )
{
  return( Change.LevelTreeCapabilities.Tuning_Revision );
}

void            ChangerReadTubeStatus( void )
{
    Change.tubeStatus = 0;
}

#define         Coinco()    ((Change.LevelTreeCapabilities.Manufacturer_Code[0] == 0x00 && \
                              Change.LevelTreeCapabilities.Manufacturer_Code[1] == 0x00 && \
                              Change.LevelTreeCapabilities.Manufacturer_Code[2] == 0x00 )?1:0)

void            CoincoChangerTubes( char coinType, char TubeStatus, int mode )
{
    if ( Coinco() || NonVolatileSetup.tubeValue != 0 )
    {
        if ( TubeStatus == 0 || // tubi vuoti
             TubeStatus > 20 || // tubi pieni
             TubeStatus > Change.TubeStatus.Tube_Status[coinType] ) // in ogni caso il numero di monete indicato e' sicuramente il minimo disponibile
            Change.TubeStatus.Tube_Status[coinType] = TubeStatus;
        else 
            Change.TubeStatus.Tube_Status[coinType] += mode;
    }
    else
        Change.TubeStatus.Tube_Status[coinType] = TubeStatus;
}

void            SendChangeCoinType ( void )
{
    MDBcmd( CHANGE_COIN_TYPE, 5, 0xFF );    // Coin Status
    pMDBPerif->cmd[1] = hibyte(Change.Cmd.Coin_Enable);
    pMDBPerif->cmd[2] = lobyte(Change.Cmd.Coin_Enable);
    pMDBPerif->cmd[3] = hibyte(Change.CoinStatus.Manual_Dispense_Enable);
    pMDBPerif->cmd[4] = lobyte(Change.CoinStatus.Manual_Dispense_Enable);
    pMDBPerif->status = CHANGE_COIN_TYPE;  // wait ACK
    Change.CoinStatus.Coin_Enable = Change.Cmd.Coin_Enable;
}

/*
  Changer MDB
*/
byte  Changer( void )
{
    char i, monete_da_erogare, ch;
    dword restoReso;

// protocollo
    switch( pMDBPerif->status ) {
                      // attesa ACK dopo RESET
      case CHANGE_RESET: if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CHANGE_POLL, 1, 0xFF );    // poll
                        pMDBPerif->status = CHANGE_POLL;
                      }
                      else
                      {
                        MDBcmd( CHANGE_RESET, 1, 0xFF );    // reset
                      }
                      memset( &Change, 0x00, sizeof( Change ) );
                      Change.CoinStatus.Coin_Enable = 0xFFFF;
                      Change.Cmd.Coin_Enable = 0xFFFF;
                      Change.CoinStatus.Manual_Dispense_Enable = 0xFFFF;
                      if( pChangerCmd != NULL ) pChangerCmd->response = -1;
                      break;

      case CHANGE_COIN_TYPE:
      case CHANGE_DISPENSE: if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CHANGE_POLL, 1, 0xFF );    // poll
                        pMDBPerif->status = CHANGE_POLL;
                      }
                      // repeat comand
                      break;

                      // attesa risposta al POLL
      case CHANGE_POLL:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        // comandi alternativi al POLL
                        if( pChangerCmd != NULL && pChangerCmd->response == 1 )
                        {
                          switch( pChangerCmd->cmd )
                          {
                                    // va inserito un timeout di esecuzione del comando!!
                                    // PAYOUT
                                    // DEBUG : cosa succede se mentre faccio payout entra una moneta ? POLL rende valore moneta ?
                            case CHANGER_CMD_PAYOUT :
                                    if( pChangerCmd->val != 0 )
                                    {
                                      if( Change.LevelTreeCapabilities.Optional_Features[3] & 0x01 )
                                      {
                                        MDBcmd( (byte)CHANGE_EXPANSION_PAYOUT, 3, 0x01);
                                        pMDBPerif->cmd[1] = CHANGE_EXPANSION_PAYOUT>>8;
                                        if( (pChangerCmd->val)/Change.Setup.Scaling_Factor > 255 )		// [04.04.2008]
                                        	pMDBPerif->cmd[2] = 255;									// [04.04.2008]
                                        else															// [04.04.2008]
                                        	pMDBPerif->cmd[2] = (pChangerCmd->val)/Change.Setup.Scaling_Factor;
                                        pMDBPerif->status = CHANGE_EXPANSION_PAYOUT;
                                        pChangerCmd->val -= pMDBPerif->cmd[2]*Change.Setup.Scaling_Factor; // [04.04.2008] calcola resto residuo DOPO la restituzione
                                        if( pChangerCmd->val < Change.Setup.Scaling_Factor )            // [04.04.2008] se inferiore al minimo
                                        	pChangerCmd->val = 0;										// [04.04.2008] azzera il residuo
                                        for( i = 0; i < 16; i++ )
                                          Change.TubeStatus.Escrow_Status[i] = 0;
                                      }
                                      else {
                                        MDBcmd( CHANGE_TUBE_STATUS, 1, 0xFF );    // Tube Status
                                        pMDBPerif->status = CHANGE_TUBE_STATUS_PAYOUT;
                                      }
                                    }
                                    else
                                    {
                                      pChangerCmd->response = 0;
                                      MDBcmd( CHANGE_TUBE_STATUS, 1, 0xFF );    // Tube Status
                                      pMDBPerif->status = CHANGE_TUBE_STATUS;
                                    }
                                    break;
                                    
                            default:
                                    pChangerCmd->response = -1;
                                    break;
                          }
                        }
                        else if( Change.Cmd.Coin_Enable != Change.CoinStatus.Coin_Enable )
                        {
                          SendChangeCoinType();
                        }
                        else if( Change.tubeStatus == 0 && GetTickCount() > 30000 )
                        {
                          
                          MDBcmd( CHANGE_TUBE_STATUS, 1, 0xFF );    // Tube Status
                          pMDBPerif->status = CHANGE_TUBE_STATUS;
                          Change.tubeStatus = 1;
                        }
                        else 
                        {
                          MDBcmd( CHANGE_POLL, 1, 0xFF );    // poll
                        }
                      }
                      else
                      {
                        i = 0;
                        while( i < ans_len-1 )
                        {
                          ch = ans[i];
                          if( ch & 0x80 )
                          {
                            // coin dispense ( dovrebbe essere un messaggio in cui sono in attesa credito, audit, etc )
                            InsertEvent2( EVENT_COIN_OUT, ((ans[i]>>4)&0x07)*Change.Setup.Coin_Type_Credit[ans[i] & 0x0F], ans[i] & 0x0F, ans[i+1] ); // manca correzione per punto decimale
                            CoincoChangerTubes( ch & 0x0f, ans[i+1], -1 );
                            if( ans[i+1] != 0 )
                               Change.TubeStatus.Escrow_Status[ch & 0x0F] = 0;
                            else if( Change.TubeStatus.Escrow_Status[ch & 0x0F] != 0 )
                               Change.TubeStatus.Escrow_Status[ch & 0x0F]--;
                            i++;
                          }
                          else if( ch & 0x40 )
                          {
                            // coin deposit
                            if ( (GetTickCount()-ChangeCoinInTime) < 100 && ChangeInsertedCoin == ch && ChangeNumberOfCoin == ans[i+1] )
                            {           // too close, same as before ?
                              ChangeCoinInTime = GetTickCount();
                              i += 2;
                              continue;
                            }
                            ChangeCoinInTime = GetTickCount();
                            ChangeInsertedCoin = ch;
                            ChangeNumberOfCoin = ans[i+1];

                            switch( ch & 0x30 )
                            {
                              case 0x00:
                                if ( Change.Setup.Coin_Type_Credit[ch & 0x0F] != ID_TOKEN )
                                    InsertEvent( EVENT_COIN_IN_CASHBOX, Change.Setup.Coin_Type_Credit[ch & 0x0F] ); // manca correzione per punto decimale
                                else
                                    InsertEvent( EVENT_TOKEN_IN_CASHBOX, Change.Setup.Coin_Type_Credit[ch & 0x0F] ); // manca correzione per punto decimale
                                CoincoChangerTubes( ch & 0x0f, ans[i+1], 0 );
                                break;
                              case 0x10:
                                if ( Change.Setup.Coin_Type_Credit[ch & 0x0F] != ID_TOKEN )
                                    InsertEvent2( EVENT_COIN_IN_TUBE, Change.Setup.Coin_Type_Credit[ch & 0x0F], ( ch & 0x0F ), ans[i+1] ); // manca correzione per punto decimale
                                else
                                    InsertEvent2( EVENT_TOKEN_IN_TUBE, Change.Setup.Coin_Type_Credit[ch & 0x0F], ( ch & 0x0F ), ans[i+1] ); // manca correzione per punto decimale
                                CoincoChangerTubes( ch & 0x0f, ans[i+1], +1 );
                                if( ans[i+1] != 0 )
                                  Change.TubeStatus.Escrow_Status[ch & 0x0F] = 0;
                                else
                                  Change.TubeStatus.Escrow_Status[ch & 0x0F]++;
                                break;
                              case 0x30:
                                InsertEvent( EVENT_COIN_REJECT, Change.Setup.Coin_Type_Credit[ch & 0x0F] ); // manca correzione per punto decimale
                                incMdbError(COIN_REJECTED, 0);
                                break;

                              default:
                                break;
                            }
                            i++;
                          }
                          else
                          {
                            // MDB error counter inc  
                            if( ch >= 0x01 && ch <= 0x0d )
                                incMdbError(ch-1, COIN_ESCROW_REQUEST);
                            // status
                            switch( ch )
                            {
                              case 0x01 : // ESCROW
                                InsertEvent( EVENT_ESCROW, 0 );
                                break;

                              case 0x02 : // BUSY
                                break;

                              case 0x0B : // just reset
                                MDBcmd( CHANGE_SETUP, 1, 0xFF );    // SETUP
                                pMDBPerif->status = CHANGE_SETUP;
                                memset( &Change, 0x00, sizeof( Change ) );
                                Change.CoinStatus.Coin_Enable = 0xFFFF;
                                Change.CoinStatus.Manual_Dispense_Enable = 0xFFFF;
                                if( pChangerCmd != NULL ) pChangerCmd->response = -1;
                                break;
                                 
                              default :   // errori, per audit e diagnostica!!
                                break;
                            }
                          }
                          i++;
                        }
                        return(1);
                      }
                      break;

                      // answer to SETUP
      case CHANGE_SETUP:if( ans_len <= 23+1 && ans_len >= 8+1 )
                      {
                        Change.Setup.Feature_Level = ans[0];
                        Change.Setup.Country_Currency_Code  = Cv2ushort(ans[1],ans[2]) ;
                        Change.Setup.Scaling_Factor = ans[3];
                        Change.Setup.Decimal_Places = ans[4];
                        Change.Setup.Coin_Type_Routing = Cv2ushort(ans[5],ans[6]) ;
                        for( i = 0; i < (ans_len -1 -7); i++ )
                        {
                            if( ans[7+i] == 0xFF )
                                Change.Setup.Coin_Type_Credit[i] = ID_TOKEN;
                            else
                                Change.Setup.Coin_Type_Credit[i] = (unsigned short)ans[7+i]*(unsigned short)Change.Setup.Scaling_Factor; // DEBUG DEBUG
                        }
                        while( i < 16 )
                          Change.Setup.Coin_Type_Credit[i++] = 0;

                        if( Change.Setup.Feature_Level >= 3 )
                        {
                          MDBcmd( CHANGE_EXPANSION_ID, 2, 0xFF );      // Expansion command
                          pMDBPerif->cmd[1] = CHANGE_EXPANSION_ID>>8;
                          pMDBPerif->status = CHANGE_EXPANSION_ID;
                        }
                        else
                        {
                          MDBcmd( CHANGE_TUBE_STATUS, 1, 0xFF );    // Tube Status
                          pMDBPerif->status = CHANGE_TUBE_STATUS;
                        }
                        return(1);    // send ACK
                      }
                      // else repeat SETUP
                      break;

                      // answer to TUBE_STATUS
      case CHANGE_TUBE_STATUS_PAYOUT:
      case CHANGE_TUBE_STATUS:if( ans_len <= 18+1 && ans_len >= 2+1 )
                      {
                        Change.TubeStatus.Tube_Full_Status = Cv2ushort( ans[1],ans[0]);
                        for( i = 0; i < ans_len -1 -2; i++ )
                        {
                          CoincoChangerTubes( i, ans[i+2], 0 );
                          if( ans[i+2] != 0 )
                            Change.TubeStatus.Escrow_Status[i] = 0;
                        }
                        while( i < 16 ) {
                          Change.TubeStatus.Escrow_Status[i] = 0;
                          Change.TubeStatus.Tube_Status[i++] = 0;
                        }
                        ChangerTubeValueOverride();

                        if( pMDBPerif->status == CHANGE_TUBE_STATUS_PAYOUT )
                        {
                          i = 15;
                          while( ( Change.Setup.Coin_Type_Credit[i] == 0 ||                 // moneta esistente
                                   Change.Setup.Coin_Type_Credit[i] > pChangerCmd->val ||   // di valore maggiore del resto
                                   ( Change.TubeStatus.Tube_Status[i] +
                                     Change.TubeStatus.Escrow_Status[i] ) == 0 ) &&         // tubo non vuoto
                                 i != 0 ) i--;                                              // scansione di tutte le monete
                          if( ( Change.TubeStatus.Tube_Status[i] + Change.TubeStatus.Escrow_Status[i] ) != 0 &&
                                pChangerCmd->val > 0 )
                          {
                            monete_da_erogare = min( (pChangerCmd->val/Change.Setup.Coin_Type_Credit[i]), ( Change.TubeStatus.Tube_Status[i] + Change.TubeStatus.Escrow_Status[i] ) );
                            if( monete_da_erogare >= 15 ) monete_da_erogare = 15;           // sono disponibili solo 4 bits per ogni erogazione
                            MDBcmd( CHANGE_DISPENSE, 2, 0x01 );
                            pMDBPerif->cmd[1] = ( monete_da_erogare << 4 ) | i;
                            pMDBPerif->status = CHANGE_DISPENSE;
                            pChangerCmd->val -= monete_da_erogare*Change.Setup.Coin_Type_Credit[i]; // nel caso di caduta alimentazione si potrebbe riprendere
                                                                                                    // payout da dove sospeso, usando pChangerCmd->val
                            InsertEvent( EVENT_COIN_PAYOUT, monete_da_erogare*Change.Setup.Coin_Type_Credit[i] ); // manca correzione per punto decimale
                            if( Coinco() && monete_da_erogare > Change.TubeStatus.Escrow_Status[i] ) 
                            {
                                Change.TubeStatus.Tube_Status[i] -= ( monete_da_erogare - Change.TubeStatus.Escrow_Status[i] );
                            }
                            Change.TubeStatus.Escrow_Status[i] = 0;                         // libera eventuali monete in escrow
                          }
                          else
                          {
                            MDBcmd( CHANGE_POLL, 1, 0xFF );    // poll
                            pMDBPerif->status = CHANGE_POLL;
                            pChangerCmd->response = 0;;       // end dispense
                          }
                        }
                        else
                        {
                          SendChangeCoinType();
                        }
                        return(1);    // send ACK
                      }
                      // else repeat TUBE_STATUS, retry command
                      break;

                      // answer to CHANGE_EXPANSION_ID
      case CHANGE_EXPANSION_ID:if( ans_len == 33+1 )
                      {
                        Change.LevelTreeCapabilities.Manufacturer_Code[0] = ans[0];
                        Change.LevelTreeCapabilities.Manufacturer_Code[1] = ans[1];
                        Change.LevelTreeCapabilities.Manufacturer_Code[2] = ans[2];
                        memcpy( Change.LevelTreeCapabilities.Serial_Number, &ans[3], 12);
                        memcpy( Change.LevelTreeCapabilities.Tuning_Revision, &ans[15], 12);
                        Change.LevelTreeCapabilities.Software_Version = Cv2ushort(ans[27],ans[28]);
                        Change.LevelTreeCapabilities.Optional_Features[0] = ans[29] & 0x00;
                        Change.LevelTreeCapabilities.Optional_Features[1] = ans[30] & 0x00;
                        Change.LevelTreeCapabilities.Optional_Features[2] = ans[31] & 0x00;
                        Change.LevelTreeCapabilities.Optional_Features[3] = ans[32] & 0x01;    // enable optional features

                        if( Change.LevelTreeCapabilities.Optional_Features[0] | Change.LevelTreeCapabilities.Optional_Features[1] |
                            Change.LevelTreeCapabilities.Optional_Features[2] | Change.LevelTreeCapabilities.Optional_Features[3] )
                        {
                          memcpy( &pMDBPerif->cmd[2], &Change.LevelTreeCapabilities.Optional_Features[0], 4 );
                          MDBcmd( (byte)CHANGE_EXPANSION_FEATURES_ENABLE, 6, 0xFF );    // Coin Status
                          pMDBPerif->cmd[1] = CHANGE_EXPANSION_FEATURES_ENABLE>>8;
                          pMDBPerif->status = CHANGE_EXPANSION_FEATURES_ENABLE;  // wait ACK
                        }
                        else
                        {
                          MDBcmd( CHANGE_TUBE_STATUS, 1, 0xFF );    // Tube Status
                          pMDBPerif->status = CHANGE_TUBE_STATUS;
                        }
                        return(1);    // send ACK
                      }
                      // else repeat LEVEL_CAP, retry command
                      break;

                      // ack to CHANGE_EXPANSION_FEATURES_ENABLE
      case CHANGE_EXPANSION_FEATURES_ENABLE:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( 0x02, 1, 0xFF );    // Tube Status
                        pMDBPerif->status = CHANGE_TUBE_STATUS;
                      }
                      // retry comand
                      break;

                      // alternative payout execute
      case CHANGE_EXPANSION_PAYOUT_STATUS:
      case CHANGE_EXPANSION_PAYOUT:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( (byte)CHANGE_EXPANSION_PAYOUT_STATUS, 2, 0xFF );
                        pMDBPerif->cmd[1] = CHANGE_EXPANSION_PAYOUT_STATUS>>8;
// [04.04.2008 ]        pMDBPerif->cmd[2]			non deve essere modificato, contiene il resto chiesto alla gettoniera da rendere
                        pMDBPerif->status = CHANGE_EXPANSION_PAYOUT_STATUS;
                      }
                      else if( ans_len > 1 )  // payout status end
                      {
                        pChangerCmd->val += pMDBPerif->cmd[2]*Change.Setup.Scaling_Factor; 				// [04.04.2008] resto di cui  stata chiesta la restituzione
                        restoReso = 0;
                        for( i = 0; i < ans_len -1; i++ )
                        {
                          if( ans[i] != 0 )
                          {
                            restoReso += ans[i]*Change.Setup.Coin_Type_Credit[i];
                            InsertEvent( EVENT_COIN_PAYOUT, ans[i]*Change.Setup.Coin_Type_Credit[i] ); // manca correzione per punto decimale
                          }
                        }
                        pChangerCmd->val -= restoReso; // calcola cash residuo ( non restituito )
                        if ( restoReso == 0 )
                        {
                            pChangerCmd->response = 0;  // payout end
                            MDBcmd( 0x02, 1, 0xFF );    // Tube Status
                            pMDBPerif->status = CHANGE_TUBE_STATUS;
						}
                        else
                        {
                            MDBcmd( CHANGE_POLL, 1, 0xFF );    	// poll [4.04.2008]
                            pMDBPerif->status = CHANGE_POLL;		// [04.04.2008]
                        }
                        return(1);
                      }
                      // repeat comand
                      break;

      default:        break;
    }
    return( 0 );
}

/*
    Gestione periferica Bill
*/
#define BILL_CMD_ESCROW 1
#define BILL_CMD_PAYOUT 2


struct S_BILL_CMD {
  byte  cmd;
  unsigned short val;
  short  response;   // 1 : request, 0 : end comand OK, -1 : end comand with errors
} BillCmd, *pBillCmd = NULL;

struct S_BILLSETUP {
  byte  Feature_Level;
  unsigned short Country_Currency_Code;
  unsigned short Scaling_Factor;
  byte  Decimal_Places;
  unsigned short Stacker_Capacity;
  unsigned short Bill_Security_level;
  byte  Escrow;
  unsigned short Bill_Type_Credit[16];
};

struct S_BILL_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  unsigned short Software_Version;
  char  Optional_Features[4];   // tengo conto dell'endianess, [0] e' LSB, [3] e' MSB
};

struct S_BILL_STATUS {
  unsigned short Bill_Enable;       // actual bill enable state
  unsigned short Bill_Escrow_Enable;
  byte           Bill_Escrow;       // a bill is waiting in escrow
  byte           Bill_Removed;      // a bill has been renoved from Escrow
};

struct S_BILL_CCMD {
  unsigned short Bill_Enable;       // desired bill enable state
  unsigned short Bill_Escrow_Enable;
};

struct S_RECYCLE {
  unsigned short Bill_Type_routing;       // bill enabled on recycle
  unsigned short Bill_ManulaDispense_Enable;
  unsigned short Bill_Recycle_Enabled[16];
  unsigned short Bill_Recycle[16];        // bills available in recycle
};

struct S_BILL {
  struct S_BILLSETUP Setup;
  struct S_BILL_CAPABILITIES Capabilities;
  struct S_BILL_STATUS Status;
  struct S_BILL_CCMD Cmd;
  struct S_RECYCLE Recycle;
} Bill;

unsigned short BillStacker = 0;

struct S_BILL_MICROMECH {
  byte  present;
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  word  BillEnable;
} Bill_Micromech;

enum  eBillCmd { BILL_RESET=0,
                 BILL_SETUP,
                 BILL_SECURITY,
                 BILL_POLL,
                 BILL_BILL_TYPE,
                 BILL_ESCROW,
                 BILL_STACKER,
                 BILL_EXPANSION_ID = 0x0007,
                 BILL_EXPANSION_FEATURES_ENABLE = 0x0107,
                 BILL_EXPANSION_OPTIONS = 0x0207,
                 BILL_EXPANSION_RECYCLER_SETUP = 0x0307,
                 BILL_EXPANSION_RECYCLER_ENABLE = 0x0407,
                 BILL_DISPENSE_STATUS = 0x0507,
                 BILL_DISPENSE = 0x0707,
                 BILL_PAYOUT_STATUS = 0x0807,
                 BILL_PAYOUT_VALUE_POLL = 0x0907
               };

char            *BillManufacturer_Code( void )
{
  return( Bill.Capabilities.Manufacturer_Code );
}

char            *BillSerial_Number( void )
{
  return( Bill.Capabilities.Serial_Number );
}

char            *BillTuning_Revision( void )
{
  return( Bill.Capabilities.Tuning_Revision );
}

void            SendBillType ( void )
{
    MDBcmd( BILL_BILL_TYPE, 5, 0xFF );    // bill type
    pMDBPerif->cmd[1] = hibyte(Bill.Cmd.Bill_Enable);
    pMDBPerif->cmd[2] = lobyte(Bill.Cmd.Bill_Enable);
    pMDBPerif->cmd[3] = hibyte(Bill.Cmd.Bill_Escrow_Enable);
    pMDBPerif->cmd[4] = lobyte(Bill.Cmd.Bill_Escrow_Enable);
    Bill.Status.Bill_Enable = Bill.Cmd.Bill_Enable;
    Bill.Status.Bill_Escrow_Enable = Bill.Cmd.Bill_Escrow_Enable;
    pMDBPerif->status = BILL_BILL_TYPE;
}

/*
 * calculate how much credit can be returned by the bill recycler
 * The valure is calculated by returring as much as possible starting
 * from the highest bills available
 IN : cash value to return
 OUT: remaining value after bills are returned
 */
_Credito  BillRecycleResto( _Credito cash )
{
  byte i;
  unsigned long val;
  _Credito resto;
  
  i = 15; resto = cash;         // start check with the highest bill
  do {
    if( ( Bill.Setup.Bill_Type_Credit[i] != 0 ) && 
        ( ( ( val = resto / Bill.Setup.Bill_Type_Credit[i] ) != 0 ) ) )
    {
      if( Bill.Recycle.Bill_Recycle[i] < val )  val = Bill.Recycle.Bill_Recycle[i];
      resto -= ( val*Bill.Setup.Bill_Type_Credit[i] );
    }
  } while( i-- != 0 );
  return( cash - resto );
}

/*
 * Credit available into the bill recycler
 */
_Credito BillRecycleValue( void )
{
    _Credito    val;
    byte        i;
    
    val = 0;
    for( i = 0; i < 16; i++ )
    {
        val += Bill.Recycle.Bill_Recycle[i] * Bill.Setup.Bill_Type_Credit[i];
    }
    return( val );
  
}

/*
  Manage bill validator
 */
byte  BillValidator( void )
{
    char i;
    dword payout;

    switch( pMDBPerif->status ) {
                      // attesa ACK dopo RESET
      case BILL_RESET: if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( BILL_POLL, 1, 0xFF );    // poll
                        pMDBPerif->status = BILL_POLL;
                      }
                      else
                      {
                        MDBcmd( BILL_RESET, 1, 0xFF );    // reset
                      }
                      memset( &Bill, 0x00, sizeof( Bill ) );
                      if( pBillCmd != NULL ) pBillCmd->response = -1;
                      break;

                      // attesa risposta al POLL
      case BILL_ESCROW:
      case BILL_BILL_TYPE:
      case BILL_POLL:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
#if 0
                        if( pBillCmd != NULL && pBillCmd->response == 1 )
                        {
                          switch( pBillCmd->cmd )
                          {
                                    // va inserito un timoeut di esecuzione del comando!!
                                    // STACK
                                    // DEBUG : cosa succede se mentre faccio payout entra una moneta ? POLL rende valore moneta ?
                            case BILL_CMD_ESCROW :
                                    MDBcmd( BILL_ESCROW, 2, 0xFF );
                                    pMDBPerif->cmd[1] = pBillCmd->val;
                                    pMDBPerif->status = BILL_ESCROW;
                                    pBillCmd->response = 2;   // command is in exec
                                    break;

                            case BILL_CMD_PAYOUT :
                                    MDBcmd( (byte)BILL_DISPENSE, 4, 0xFF );
                                    pMDBPerif->cmd[1] = BILL_DISPENSE>>8;
                                    pMDBPerif->cmd[2] = hibyte((pBillCmd->val)/Bill.Setup.Scaling_Factor);
                                    pMDBPerif->cmd[3] = lobyte((pBillCmd->val)/Bill.Setup.Scaling_Factor);
                                    pMDBPerif->status = BILL_DISPENSE;
                                    pBillCmd->response = 2;   // command is in exec
                                    break;

                            default:
                                    pBillCmd->response = -1;
                                    break;
                          }
                        }
                        else if( Bill.Cmd.Bill_Enable != Bill.Status.Bill_Enable || Bill.Cmd.Bill_Escrow_Enable != Bill.Status.Bill_Escrow_Enable )
                          SendBillType();
                        else
#endif
                        {
                          MDBcmd( BILL_POLL, 1, 0xFF );    // poll
                          pMDBPerif->status = BILL_POLL;
                        }
                      }
                      else
                      {
                        i = 0;
                        while( i < ans_len-1 ){
                          if( ans[i] & 0x80 )
                          {
                            switch( ans[i] & 0xF0 )
                            {
                              case 0x80:  // bill stacked  ( dovrebbe essere un messaggio in cui sono in attesa credito, audit, etc )
                                    Bill.Status.Bill_Escrow = 0;
                                    if( Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] == ID_TOKEN )
                                        InsertEvent( EVENT_TOKEN_IN, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] );
                                    else
                                        InsertEvent( EVENT_BILL_IN, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    MDBcmd( BILL_STACKER, 1, 0xFF );                    // check stacker Status
                                    pMDBPerif->status = BILL_STACKER; // reeneble bill
                                    if( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW && pBillCmd->response == 2 )
                                        pBillCmd->response = 0;
                                    break;

                              case 0x90:  // bill escrow   ( dovrebbe essere un messaggio in cui sono in attesa credito, audit, etc )
                                    Bill.Status.Bill_Escrow = 1;
                                    if( Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] == ID_TOKEN )
                                        InsertEvent( EVENT_TOKEN_ESCROW, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] );
                                    else
                                        InsertEvent( EVENT_BILL_ESCROW, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    MDBcmd( BILL_POLL, 1, 0xFF );    // poll
                                    if( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW && pBillCmd->response == 2 )
                                        pBillCmd->response = -1;
                                    pMDBPerif->status = BILL_POLL;
                                    break;

                              case 0xA0:  // bill returned  ( dovrebbe essere un messaggio in cui sono in attesa credito, audit, etc )
                                    if( Bill.Status.Bill_Removed == 0 || Bill.Status.Bill_Escrow != 0 )  // MDB ask to send a "returned" after a "removed" status
                                    {                                                                    // if bill not yet detected in escrow, "returned"
//mmm    timeout recycler                                  
//                                        if( Bill.Status.Bill_Escrow == 0 )
                                          InsertEvent( EVENT_BILL_OUT, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                      Bill.Status.Bill_Escrow = 0;                                       // will do nothing
                                      // RETURN DEL TOKEN DA GESTORE??
                                    }
                                    Bill.Status.Bill_Removed = 0; 
                                    MDBcmd( BILL_STACKER, 1, 0xFF );                    // check stacker Status
                                    pMDBPerif->status = BILL_STACKER;                   // reeneble bill
                                    if( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW && pBillCmd->response == 2 )
                                        pBillCmd->response = -1;
                                    break;

                              case 0xB0:  // bill to recycler  ( dovrebbe essere un messaggio in cui sono in attesa credito, audit, etc )
                                    Bill.Status.Bill_Escrow = 0;
                                    InsertEvent( EVENT_BILL_RECYCLE, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    Bill.Recycle.Bill_Recycle[ans[i] & 0x0F]++;         // count bills in recycle
                                    
                                    MDBcmd( BILL_STACKER, 1, 0xFF );                    // check stacker Status
                                    pMDBPerif->status = BILL_STACKER;                   // reeneble bill
                                    if( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW && pBillCmd->response == 2 )
                                        pBillCmd->response = 0;
                                    break;

                              case 0xD0:  // bill to recycler, manual fill  // DEBUG AUDIT update
                                    InsertEvent( EVENT_BILL_MANUAL_FILL_RECYCLE, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    Bill.Status.Bill_Escrow = 0;
                                    if( pBillCmd != NULL ) pBillCmd->response = -1;
                                    break;

                              case 0xE0:  // manual dispense                // DEBUG AUDIT update
                                    InsertEvent( EVENT_BILL_MANUAL_DISPENSE, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    Bill.Status.Bill_Escrow = 0;
                                    if( pBillCmd != NULL ) pBillCmd->response = -1;
                                    break;

                              case 0xF0:  // bill transfer from recycler to cashbox // DEBUG AUDIT update
                                    InsertEvent( EVENT_BILL_TRANSFER_RECYCLE, Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] ); // manca correzione per punto decimale
                                    Bill.Status.Bill_Escrow = 0;
                                    if( pBillCmd != NULL ) pBillCmd->response = -1;
                                    break;

                              case 0xC0:  // disabled bill recycled
                              default:
                                    Bill.Status.Bill_Escrow = 0;
                                    if( pBillCmd != NULL ) pBillCmd->response = -1;
                                    break;
                            }
                          }
                          else
                          {
                            // MDB error counter inc  
                            if( ans[i] >= 0x01 && ans[i] <= 0x0c )
                                incMdbError(ans[i]-1, BILLV_MOTOR_ERROR); 
                            // there is the Recycler VNR2700 from MEI which alwyas answer 0x29 to POLL when there is a bill on ESCROW 1014.12.04
                            if( ans[i] >= 0x21 && ans[i] <= 0x2f )
                                incMdbError(ans[i]-1, BILLV_ESCROW_REQUEST);
                            // status
                            switch( ans[i] )
                            {
                              case 0x06 : // just reset
                                MDBcmd( BILL_SETUP, 1, 0xFF );    // SETUP
                                pMDBPerif->status = BILL_SETUP;
                                return(1);

                              case 0x07 : // bill removed, a BILL RETURNED is also sent
                                MDBcmd( BILL_STACKER, 1, 0xFF );    // stacker Status
                                pMDBPerif->status = BILL_STACKER;
                                Bill.Status.Bill_Removed = 1;
                                return(1);
                                
                              case 0x09 : // disabled
                                // DEBUG l'abilitazione automatica e' stata inserita per il
                                // Piramid che dopo il reset ( anche dopo il comando di Enable )
                                // si disabilita per i fatti propri per qualche tempo
                                MDBcmd( BILL_STACKER, 1, 0xFF );    // stacker Status
                                pMDBPerif->status = BILL_STACKER;
                                break;
                                
                              case 0x0B : // reject
                                InsertEvent( EVENT_BILL_REJECT, 0 );
                                MDBcmd( BILL_POLL, 1, 0xFF );    // poll
                                pMDBPerif->status = BILL_POLL;
                                break;                                                             

                              default :
                                break;
                            }
                          }
                          i++;
                        }
                     }
                     // next status is POLL, eventually send command
                     if( pMDBPerif->status == BILL_POLL )
                     {
                        if( pBillCmd != NULL && pBillCmd->response == 1 )
                        {
                          switch( pBillCmd->cmd )
                          {
                                    // va inserito un timoeut di esecuzione del comando!!
                                    // STACK
                                    // DEBUG : cosa succede se mentre faccio payout entra una moneta ? POLL rende valore moneta ?
                            case BILL_CMD_ESCROW :
                                    MDBcmd( BILL_ESCROW, 2, 0xFF );
                                    pMDBPerif->cmd[1] = pBillCmd->val;
                                    pMDBPerif->status = BILL_ESCROW;
                                    pBillCmd->response = 2;   // command is in exec
                                    break;

                            case BILL_CMD_PAYOUT :
                                    MDBcmd( (byte)BILL_DISPENSE, 4, 0xFF );
                                    pMDBPerif->cmd[1] = BILL_DISPENSE>>8;
                                    pMDBPerif->cmd[2] = hibyte((pBillCmd->val)/Bill.Setup.Scaling_Factor);
                                    pMDBPerif->cmd[3] = lobyte((pBillCmd->val)/Bill.Setup.Scaling_Factor);
                                    pMDBPerif->status = BILL_DISPENSE;
                                    pBillCmd->response = 2;   // command is in exec
                                    break;

                            default:
                                    pBillCmd->response = -1;
                                    break;
                          }
                        }
                        else if( Bill.Cmd.Bill_Enable != Bill.Status.Bill_Enable || Bill.Cmd.Bill_Escrow_Enable != Bill.Status.Bill_Escrow_Enable )
                          SendBillType();
                      }
                      // send ACK is receivde any non empty frame
                      if( ans_len != 1 )
                          return(1);
                      break;

                      // answer to SETUP
      case BILL_SETUP:if( ans_len >= 12+1 && ans_len <= 27+1)
                      {
                        Bill.Setup.Feature_Level = ans[0];
                        Bill.Setup.Country_Currency_Code  = Cv2ushort(ans[1],ans[2]);
                        Bill.Setup.Scaling_Factor = Cv2ushort(ans[3],ans[4]);
                        Bill.Setup.Decimal_Places = ans[5];
                        Bill.Setup.Stacker_Capacity = Cv2ushort(ans[6],ans[7]);
                        Bill.Setup.Bill_Security_level = Cv2ushort(ans[8],ans[9]);
                        Bill.Setup.Escrow = ans[10];
                        for( i = 0; i < ans_len -1 -11; i++ )
                        {
                            if( ans[11+i] == 0xFF )
                                Bill.Setup.Bill_Type_Credit[i] = ID_TOKEN;
                            else
                                Bill.Setup.Bill_Type_Credit[i] = (unsigned short)ans[11+i]*Bill.Setup.Scaling_Factor; // DEBUG DEBUG
                        }
                        while( i < 16 )
                          Bill.Setup.Bill_Type_Credit[i++] = 0;

                        MDBcmd( BILL_EXPANSION_ID, 2, 0xFF );      // Expansion command 37 00
                        if( Bill.Setup.Feature_Level == 1 )
                        {
                          pMDBPerif->cmd[1] = BILL_EXPANSION_ID>>8;
                        }
                        else
                        {
                          pMDBPerif->cmd[1] = BILL_EXPANSION_OPTIONS>>8;
                        }
                        pMDBPerif->status = BILL_EXPANSION_ID;
                        return(1);    // send ACK
                      }
                      // else repeat SETUP
                      break;
                      // answer to LEVEL_CAP
      case BILL_EXPANSION_ID:if( ans_len == 33+1 || ans_len == 29+1 )
                      {
                        Bill.Capabilities.Manufacturer_Code[0] = ans[0];
                        Bill.Capabilities.Manufacturer_Code[1] = ans[1];
                        Bill.Capabilities.Manufacturer_Code[2] = ans[2];
                        memcpy( Bill.Capabilities.Serial_Number, &ans[3], 12);
                        memcpy( Bill.Capabilities.Tuning_Revision, &ans[15], 12);
                        Bill.Capabilities.Software_Version = Cv2ushort(ans[27],ans[28]);
                        if( ans_len == 33+1 )
                        {
                          Bill.Capabilities.Optional_Features[0] = ans[29] & 0x00;
                          Bill.Capabilities.Optional_Features[1] = ans[30] & 0x00;
                          Bill.Capabilities.Optional_Features[2] = ans[31] & 0x00;
                          Bill.Capabilities.Optional_Features[3] = ans[32] & 0x02;    // enable optional features ; RECYCLE
                          memcpy( &pMDBPerif->cmd[2], &Bill.Capabilities.Optional_Features[0], 4 );
                          MDBcmd( (byte)BILL_EXPANSION_FEATURES_ENABLE, 6, 0xFF );    // Coin Status
                          pMDBPerif->cmd[1] = BILL_EXPANSION_FEATURES_ENABLE>>8;
                          pMDBPerif->status = BILL_EXPANSION_FEATURES_ENABLE;  // wait ACK
                        }
                        else
                        {
                          Bill.Capabilities.Optional_Features[0] = 0;
                          Bill.Capabilities.Optional_Features[1] = 0;
                          Bill.Capabilities.Optional_Features[2] = 0;
                          Bill.Capabilities.Optional_Features[3] = 0;
                          MDBcmd( BILL_STACKER, 1, 0xFF );    // stacker Status
                          pMDBPerif->status = BILL_STACKER;
                        }
                        return(1);    // send ACK
                      }
                      // else repeat LEVEL_CAP, retry command
                      break;

                      // ack to BILL_EXPANSION_FEATURES_ENABLE
      case BILL_EXPANSION_FEATURES_ENABLE:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        if( Bill.Capabilities.Optional_Features[3] & 0x02 )
                        {
                          MDBcmd( BILL_EXPANSION_RECYCLER_SETUP & 0xFF, 2, 0xFF );    // recycler Status
                          pMDBPerif->cmd[1] = BILL_EXPANSION_RECYCLER_SETUP>>8;
                          pMDBPerif->status = BILL_EXPANSION_RECYCLER_SETUP;
                        }
                        else
                        {
                          MDBcmd( BILL_STACKER, 1, 0xFF );    // stacker Status
                          pMDBPerif->status = BILL_STACKER;
                        }
                      }
                      // retry comand
                      break;

      case BILL_EXPANSION_RECYCLER_SETUP: if( ans_len == 2+1 )
                      {
                        Bill.Recycle.Bill_Type_routing = Cv2ushort(ans[0],ans[1]);
                        
                        MDBcmd( BILL_EXPANSION_RECYCLER_ENABLE & 0xFF, 2+18, 0xFF );    // recycler Status
                        pMDBPerif->cmd[1] = BILL_EXPANSION_RECYCLER_ENABLE>>8;
                        pMDBPerif->cmd[2] = hibyte(Bill.Recycle.Bill_ManulaDispense_Enable);
                        pMDBPerif->cmd[3] = lobyte(Bill.Recycle.Bill_ManulaDispense_Enable);
                        for( i = 0; i < 16; i++ )
                          pMDBPerif->cmd[i+3] = ( Bill.Recycle.Bill_Recycle_Enabled[i] = 0x03 );
                        pMDBPerif->status = BILL_EXPANSION_RECYCLER_ENABLE;
                        return(1);    // send ACK
                      }
                      // retry command
                      break;
                      
      case BILL_EXPANSION_RECYCLER_ENABLE: if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                          MDBcmd( BILL_STACKER, 1, 0xFF );    // stacker Status
                          pMDBPerif->status = BILL_STACKER;                        
                      }
                      // retry command
                      break;

      case BILL_STACKER:if( ans_len == 2+1 )
                      {
                        if ( (ans[0] & 0x80) == 0x80 )
                        {               // insert event if not present before
                          if ( (BillStacker&0x8000) == 0x0000 )
                            InsertEvent( EVENT_STACKER_FULL, 0 );
                            incMdbError(BILLV_STACKER_FULL, 0);
                        }
                        BillStacker = Cv2ushort(ans[0],ans[1]);
                        if( Bill.Capabilities.Optional_Features[3] & 0x02 )
                        {
                          MDBcmd( BILL_DISPENSE_STATUS & 0xFF, 2, 0xFF );    // recycler Status
                          pMDBPerif->cmd[1] = BILL_DISPENSE_STATUS>>8;
                          pMDBPerif->status = BILL_DISPENSE_STATUS;
                        }
                        else
                        {
                          SendBillType();
                        }
                        return(1);    // send ACK
                      }
                      // retry comand
                      break;
                      
      case BILL_DISPENSE_STATUS:if( ans_len == 34+1 )
                      {
                        for( i = 0; i < 16; i++)
                          Bill.Recycle.Bill_Recycle[i] = Cv2ushort(ans[2*i+2],ans[2*i+3]);
                          SendBillType();
                      }
                      // retry
                      break;
        
      case BILL_DISPENSE:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                          MDBcmd( BILL_PAYOUT_VALUE_POLL & 0xFF, 2, 0xFF );    // recycler Status
                          pMDBPerif->cmd[1] = BILL_PAYOUT_VALUE_POLL>>8;
                          pMDBPerif->status = BILL_PAYOUT_VALUE_POLL;
                      }
                      break;
                      
      case BILL_PAYOUT_VALUE_POLL: if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                          MDBcmd( BILL_PAYOUT_STATUS & 0xFF, 2, 0xFF );    // recycler finish
                          pMDBPerif->cmd[1] = BILL_PAYOUT_STATUS>>8;
                          pMDBPerif->status = BILL_PAYOUT_STATUS;
                      }
                      else if( ans_len == 2+1 )
                      {
                          MDBcmd( BILL_PAYOUT_VALUE_POLL & 0xFF, 2, 0xFF );    // recycler Status
                          pMDBPerif->cmd[1] = BILL_PAYOUT_VALUE_POLL>>8;
                          pMDBPerif->status = BILL_PAYOUT_VALUE_POLL;
                      }
                      // retry
                      break;
                      
      case BILL_PAYOUT_STATUS:if( ans_len == 32+1 )
                      {
                          // answer
                          if( pBillCmd != NULL ) pBillCmd->response = 0;  // end
                          
                          payout = 0;
                          for( i = 0; i < 16 && Bill.Setup.Bill_Type_Credit[i] != 0 ; i++)
                                payout += ( Cv2ushort(ans[2*i+2],ans[2*i+3]) * Bill.Setup.Bill_Type_Credit[i] );
                          InsertEvent( EVENT_BILL_PAYOUT,Bill.Setup.Bill_Type_Credit[ans[i] & 0x0F] );
                          
                          MDBcmd( BILL_POLL, 1, 0xFF );    // poll
                          pMDBPerif->status = BILL_POLL;
                      }
                      // retry
                      break;
                      
      default:        break;
    }
    return( 0 );
}

/*
    Gestione periferica Cashless
*/

#define     VMCLevel      3

// queste strutture sono da raddoppiare, una per ogni cashless eventualmente installato!! DEBUG
#define CASHLESS_CMD_VEND       1
#define CASHLESS_CMD_VEND_OK    2
#define CASHLESS_CMD_VEND_FAIL  3
#define CASHLESS_CMD_ENABLE     4
#define CASHLESS_CMD_DISABLE    5
#define CASHLESS_CMD_SESSION_COMPLETE 6
#define CASHLESS_CMD_REVALUE    7
#define CASHLESS_CMD_CASH_VEND  8

struct S_CASHLESS_CMD {
  byte  cmd;
  unsigned short val, param;
  short  response;
} CashlessCmd, *pCashlessCmd = NULL;


struct S_CASHLESSSETUP {
  byte  Feature_Level;
  unsigned short Country_Currency_Code;
  byte Scaling_Factor;
  byte Decimal_Places;
  byte Application_Maximum_Response_Time;
  union {
    char  Options_byte;
    struct {
      unsigned long refund:1 ;
      unsigned long multivend:1 ;
      unsigned long display:1 ;
      unsigned long vend_cash_cmd:1 ;
      unsigned long unused:28 ;
    }Options;
  };
  unsigned short maxCredit;
};

struct S_CASHLESS_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[12];
  char  Tuning_Revision[12];
  unsigned short Software_Version;
  union {
    char  Optional_Features[4];
    struct {   // tengo conto dell'endianess, [0] e' LSB, [3] e' MSB
      unsigned long unusedH:24 ;
      unsigned long FTL:1 ;
      unsigned long Monatary32bits:1 ;
      unsigned long MultiCurrency:1 ;
      unsigned long NegativeVend:1 ;
      unsigned long DataEntry:1 ;
      unsigned long unusedL:3 ;
    }Options;
  };
};

struct S_CASHLESS {
  byte          State;
  byte          CmdEnable, StatusEnable;
  struct S_CASHLESSSETUP Setup;
  struct S_CASHLESS_CAPABILITIES Capabilities;
  _Credito  revalue_limit;
} Cashless[3], *pCashless;

#define CASHLESS_EXPANDED_CURRECY ( pCashless->Capabilities.Options.Monatary32bits || pCashless->Capabilities.Options.MultiCurrency )

enum  eCasStatus {  CASHLESS_RESET=0,
                    CASHLESS_SETUP,
                    CASHLESS_POLL,
                    CASHLESS_VEND = 0x0003,
                    CASHLESS_VEND_CANCEL = 0x0103,
                    CASHLESS_VEND_SUCCESS = 0x0203,
                    CASHLESS_VEND_FAILURE = 0x0303,
                    CASHLESS_SESSION_COMPLETE = 0x0403,
                    CASHLESS_CASH_SALES = 0x0503,
                    CASHLESS_NEGATIVE_VEND = 0x0603,
                    CASHLESS_DISABLE = 0x0004,
                    CASHLESS_ENABLE = 0x0104,
                    CASHLESS_CANCEL = 0x0204,
                    CASHLESS_DATA_ENTRY_RESP = 0x0304,
                    CASHLESS_REVALUE = 0x0005,
                    CASHLESS_REVALUE_LIMIT_REQ = 0x0105,
                    CASHLESS_EXPANSION_ID = 0x0007,
                    CASHLESS_EXPANSION_READ_FILE = 0x0107,
                    CASHLESS_EXPANSION_WRITE_FILE = 0x0207,
                    CASHLESS_EXPANSION_WRITE_DATE = 0x0307,
                    CASHLESS_EXPANSION_FEATURES_ENABLE = 0x0407,
                    CASHLESS_SET_MAXMIN = 0x0101
                  };

enum  eCasPoll  { CASHLESS_JUST_RESET = 0,
                  CASHLESS_READER_CONFIG_DATA,
                  CASHLESS_DISPLAY_REQUEST,
                  CASHLESS_BEGIN_SESSION,
                  CASHLESS_SESSION_CANCEL_REQUEST,
                  CASHLESS_VEND_APPROVED,
                  CASHLESS_VEND_DENIED,
                  CASHLESS_END_SESSION,
                  CASHLESS_CANCELLED,
                  CASHLESS_PERIPHERAL_ID,
                  CASHLESS_ERROR,
                  CASHLESS_OUT_SEQUENCE,
                  CASHLESS_REVALUE_APPROVED = 0x0D,
                  CASHLESS_REVALUE_DENIED,
                  CASHLESS_REVALUE_LIMIT,
                  CASHLESS_USER_FILE_DATA,
                  CASHLESS_TIME_DATE_REQUEST,
                  CASHLESS_DATA_ENTRY_REQUEST,
                  CASHLESS_DATA_ENTRY_CANCEL,
                  CASHLESS_DIAGNOSTIC = 0xFF
                };

enum  eCasStateMachine {
                  CASHLESS_STATE_NOT_PRESENT = 0,
                  CASHLESS_STATE_INACTIVE,          // after a reset
                  CASHLESS_STATE_DISABLED,          // after SETUP or CASHLESS_DISABLE
                  CASHLESS_STATE_ENABLED,           // after CASHLESS_ENABLE
                  CASHLESS_STATE_IDLE,              // ENABLED with a valid paymen media inserted
                  CASHLESS_STATE_VEND,              // after a VEND_REQUEST
                  CASHLESS_STATE_REVALUE,
                  CASHLESS_STATE_NEGATIVE_VEND,
                  CASHLESS_STATE_SINGLE_POLL
               };

char            *CashlessManufacturer_Code( byte id )
{
  if( id > 2 )
    return( NULL );
  return( Cashless[id].Capabilities.Manufacturer_Code );
}

char            *CashlessSerial_Number( byte id )
{
  if( id > 2 )
    return( NULL );
  return( Cashless[id].Capabilities.Serial_Number );
}
char            *CashlessTuning_Revision( byte id )
{
  if( id > 2 )
    return( NULL );
  return( Cashless[id].Capabilities.Tuning_Revision );
}
unsigned short  *CashlessSoftware_Version( byte id )
{
  if( id > 2 )
    return( NULL );
  return( &Cashless[id].Capabilities.Software_Version );
}

byte  CashlessConfig( byte *ans)
{
  pCashless->Setup.Feature_Level = ans[1];
  pCashless->Setup.Country_Currency_Code  = Cv2ushort(ans[2],ans[3]);
  pCashless->Setup.Scaling_Factor = ans[4];
  pCashless->Setup.Decimal_Places = ans[5];
  pCashless->Setup.Application_Maximum_Response_Time = ans[6];
  pMDBPerif->max_noresponse_time = ans[6]*1000;
  pCashless->Setup.Options_byte = ans[7];
  return(7);
}

byte  CashlessID( byte *ans)
{
  pCashless->Capabilities.Manufacturer_Code[0] = ans[1];
  pCashless->Capabilities.Manufacturer_Code[1] = ans[2];
  pCashless->Capabilities.Manufacturer_Code[2] = ans[3];
  memcpy( pCashless->Capabilities.Serial_Number, &ans[4], 12);
  memcpy( pCashless->Capabilities.Tuning_Revision, &ans[16], 12);
  pCashless->Capabilities.Software_Version = Cv2ushort(ans[28],ans[29]);
  if( pCashless->Setup.Feature_Level >= 3 && VMCLevel == 3 )
  {
    pCashless->Capabilities.Optional_Features[0] = ans[30] & 0x00;
    pCashless->Capabilities.Optional_Features[1] = ans[31] & 0x00;
    pCashless->Capabilities.Optional_Features[2] = ans[32] & 0x00;
    pCashless->Capabilities.Optional_Features[3] = ans[33] & 0x00;    // enable optional features
    return( 33 );
  }
  else
  {
    pCashless->Capabilities.Optional_Features[0] = 0;
    pCashless->Capabilities.Optional_Features[1] = 0;
    pCashless->Capabilities.Optional_Features[2] = 0;
    pCashless->Capabilities.Optional_Features[3] = 0;
  }
  return( 29);
}

byte            CashLess( void )
{
    char i;
    unsigned short val;

//    if( pMDBPerif->addr == 0x10 ) 
//    {
//        if ( Cashless[1].State != CASHLESS_STATE_NOT_PRESENT )
//            return 0;                 
//    }
//    else {
//        if ( Cashless[0].State != CASHLESS_STATE_NOT_PRESENT )
//            return 0;              
//    } 
    
    if( pMDBPerif->addr == 0x10 ) pCashless = &Cashless[0]; else pCashless = &Cashless[1];
     
    switch( pMDBPerif->status ) {
                      // attesa ACK dopo RESET
      case CASHLESS_RESET:
                      if( pCashless->State >= CASHLESS_STATE_IDLE )
                        InsertEvent( EVENT_CARD_OUT, 0 );     // default card out when reset 7.6.K
                      if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                        pMDBPerif->status = CASHLESS_POLL;
                        pCashless->State = CASHLESS_STATE_INACTIVE;
                      }
                      else
                      {
                        MDBcmd( CASHLESS_RESET, 1, 0xFF );      // reset
                      }
                      memset( pCashless, 0x00, sizeof( struct S_CASHLESS ) );
                      pCashless->State = CASHLESS_STATE_NOT_PRESENT;
                      if( cashless_active_addr != 0xff && pMDBPerif->addr == cashless_active_addr )
                      {
                            if( pCashlessCmd != NULL ) pCashlessCmd->response = -1;
                            cashless_active_addr = 0xff;
                      }
                      break;

      case CASHLESS_REVALUE_LIMIT_REQ:
      case CASHLESS_VEND:
      case CASHLESS_POLL:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll

                                                // COMAND TO EXECUTE INSTEAD OF POLL ( DEBUG when POLL risponde ACK!! ma non va bene
                        if ( pCashlessCmd != NULL && pCashlessCmd->response == 1 )
                        {
                          switch( pCashlessCmd->cmd )
                          {
                            case CASHLESS_CMD_VEND:
                              // TODO : handling of ALWAYS IDLE status
//mmm                                if( pCashless->State == CASHLESS_STATE_IDLE )
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;  
                                if( pCashless->State == CASHLESS_STATE_IDLE )                                
                                {
                                  MDBcmd( CASHLESS_VEND, 6, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_VEND>>8;
                                  pMDBPerif->cmd[2] = hibyte(pCashlessCmd->val);   // price
                                  pMDBPerif->cmd[3] = lobyte(pCashlessCmd->val);
                                  pMDBPerif->cmd[4] = SelectionData.tray;   // selection
                                  pMDBPerif->cmd[5] = SelectionData.column;
                                  pCashlessCmd->response = 2;           // command is executing, cashless reply is CASHLESS_VEND_APPROVED or CASHLESS_VEND_DENIED
                                  pMDBPerif->status = CASHLESS_VEND;
                                  pCashless->State = CASHLESS_STATE_VEND; 
                                }
                                else
                                  pCashlessCmd->response = -1;           // abort comand
                                break;

                            case CASHLESS_CMD_VEND_OK:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                 
                                if( pCashless->State == CASHLESS_STATE_VEND )
                                { // vend OK
                                  MDBcmd( (byte)CASHLESS_VEND_SUCCESS, 4, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_VEND_SUCCESS>>8;
                                  pMDBPerif->cmd[2] = hibyte(pCashlessCmd->val);   // selection
                                  pMDBPerif->cmd[3] = lobyte(pCashlessCmd->val);
                                  pMDBPerif->status = CASHLESS_POLL;
                                  pCashless->State = CASHLESS_STATE_IDLE;
                                  
////mmm                                  
//cashless_active_addr = 0xff;                                   

                                  if( pCashless->Setup.Options.multivend == 1 && NonVolatileSetup.setSingleVend == 0 ) // multivend,
                                    pCashlessCmd->response = 0;           // no cashless reply is needed, command executed
                                } // se SINGLE VEND chiede di chiudere la sessione
                                else if( pCashless->State == CASHLESS_STATE_IDLE )
                                {
//mmm                                  
cashless_active_addr = 0xff;                                      
                                  InsertEvent( EVENT_CARD_OUT, 0 ); // manca correzione per punto decimale
                                  MDBcmd( (byte)CASHLESS_SESSION_COMPLETE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_SESSION_COMPLETE>>8;
                                  pCashless->State = CASHLESS_STATE_ENABLED;
                                  pCashlessCmd->response = 0;
                                }
                                else
                                  pCashlessCmd->response = -1;           // abort comand
                                break;

                            case CASHLESS_CMD_VEND_FAIL:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                
                                if( pCashless->State == CASHLESS_STATE_VEND )
                                { // vend FAIL
                                  MDBcmd( (byte)CASHLESS_VEND_FAILURE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_VEND_FAILURE>>8;
                                  pMDBPerif->status = CASHLESS_POLL;
                                  pCashless->State = CASHLESS_STATE_IDLE;
                                  
////mmm                                  
//cashless_active_addr = 0xff; 

                                  if( pCashless->Setup.Options.multivend == 1 && NonVolatileSetup.setSingleVend == 0 ) // multivend
                                    pCashlessCmd->response = 0;           // no cashless reply is needed, command executed
                                } // se SINGLE VEND chiede di chiudere la sessione
                                else if( pCashless->State == CASHLESS_STATE_IDLE )
                                {
                                  MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                                  pCashless->State = CASHLESS_STATE_SINGLE_POLL;
                                }
                                else if( pCashless->State == CASHLESS_STATE_SINGLE_POLL )
                                {
//mmm                                  
cashless_active_addr = 0xff;                                      
                                  InsertEvent( EVENT_CARD_OUT, 0 ); // manca correzione per punto decimale
                                  MDBcmd( (byte)CASHLESS_SESSION_COMPLETE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_SESSION_COMPLETE>>8;
                                  pCashless->State = CASHLESS_STATE_ENABLED;
                                  pCashlessCmd->response = 0;
                                }
                                else
                                  pCashlessCmd->response = -1;           // abort comand
                                break;

                            case CASHLESS_CMD_ENABLE:
sendCashlessEnable:;
                                if( pCashless->State == CASHLESS_STATE_DISABLED )
                                {
                                  MDBcmd( (byte)CASHLESS_ENABLE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_ENABLE>>8;
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = 2;           // command is executing
                                  pMDBPerif->status = CASHLESS_POLL;
                                  pCashless->State = CASHLESS_STATE_ENABLED;
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = 0;           // no cashless reply is needed, command executed
                                }
                                else
                                {
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = -1;           // abort comand
                                }
                                pCashless->StatusEnable = pCashless->CmdEnable;
                                break;

                            case CASHLESS_CMD_DISABLE:
sendCashlessDisable:;
                                if( pCashless->State == CASHLESS_STATE_ENABLED/*CASHLESS_STATE_IDLE*/ )
                                {
                                  MDBcmd( CASHLESS_DISABLE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_DISABLE>>8;
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = 2;           // command is executing
                                  pMDBPerif->status = CASHLESS_POLL;
                                  pCashless->State = CASHLESS_STATE_DISABLED;
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = 0;           // no cashless reply is needed, command executed
                                  pCashless->StatusEnable = pCashless->CmdEnable;
                                }
                                else
                                {
                                  if ( pCashlessCmd != NULL )
                                      pCashlessCmd->response = -1;           // abort comand
                                }
                                break;

                            case CASHLESS_CMD_SESSION_COMPLETE:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                
                                if( pCashless->State == CASHLESS_STATE_IDLE )
                                {
//mmm                                  
cashless_active_addr = 0xff;                                      
                                  InsertEvent( EVENT_CARD_OUT, 0 );
                                  MDBcmd( (byte)CASHLESS_SESSION_COMPLETE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_SESSION_COMPLETE>>8;
                                  pCashlessCmd->response = 2;           // command is executing, cashless reply is CASHLESS_END_SESSION
                                  pMDBPerif->status = CASHLESS_POLL;
                                }
                                else
                                  pCashlessCmd->response = -1;           // abort comand
                                break;

                          case CASHLESS_CMD_REVALUE:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                
                                if( pCashless->State == CASHLESS_STATE_IDLE && pCashless->Setup.Feature_Level >= 2 )
                                {
                                  if( CASHLESS_EXPANDED_CURRECY )
                                  {
                                    // put value in 4 bytes
                                  }
                                  else
                                  {
                                   MDBcmd( CASHLESS_REVALUE, 4, 0xFF );
                                   pMDBPerif->cmd[1] = CASHLESS_REVALUE>>8;
                                   pMDBPerif->cmd[2] = hibyte((pCashlessCmd->val)/pCashless->Setup.Scaling_Factor);
                                   pMDBPerif->cmd[3] = lobyte((pCashlessCmd->val)/pCashless->Setup.Scaling_Factor);
                                   pCashlessCmd->response = 2;           // command is executing, cashless reply is CASHLESS_END_SESSION
                                  }
                                  pMDBPerif->status = CASHLESS_POLL;
                                }
                                else
                                  pCashlessCmd->response = -1;           // abort comand
                                break;
                                
                            case CASHLESS_CMD_CASH_VEND:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                 
                                MDBcmd( (byte)CASHLESS_CASH_SALES, 6, 0xFF );
                                pMDBPerif->cmd[1] = CASHLESS_CASH_SALES>>8;
                                pMDBPerif->cmd[2] = hibyte((pCashlessCmd->val)/pCashless->Setup.Scaling_Factor);
                                pMDBPerif->cmd[3] = lobyte((pCashlessCmd->val)/pCashless->Setup.Scaling_Factor);
                                pMDBPerif->cmd[4] = hibyte( pCashlessCmd->param );
                                pMDBPerif->cmd[5] = lobyte( pCashlessCmd->param );
                                pMDBPerif->status = CASHLESS_POLL;
                                pCashlessCmd->response = 0;
                                break;
                                
                            default:
                                break;
                          }
                        }
                        else if ( cashless_active_addr != 0xff && pMDBPerif->addr != cashless_active_addr )
                        {
                           //goto sendCashlessDisable; TODO
                           if( pCashless->State == CASHLESS_STATE_ENABLED/*CASHLESS_STATE_IDLE*/ )
                           {
                                MDBcmd( CASHLESS_DISABLE, 2, 0xFF );
                                pMDBPerif->cmd[1] = CASHLESS_DISABLE>>8;
                                pMDBPerif->status = CASHLESS_POLL;
                                pCashless->State = CASHLESS_STATE_DISABLED;
                                pCashless->StatusEnable = pCashless->CmdEnable;
                           }
                           break;
                        }
                        else if ( pCashless->CmdEnable != pCashless->StatusEnable )
                        {
                            if ( pCashless->CmdEnable == 0 )
                                goto sendCashlessDisable;
                            else
                                goto sendCashlessEnable;
                        }
                        else if( pCashless->Setup.maxCredit != maxCredit && pCashless->State == CASHLESS_STATE_ENABLED ) // 7.6.K
                        {
                            MDBcmd( CASHLESS_RESET, 1, 0xFF );    // reset to reload maxCredit
                            pMDBPerif->status = CASHLESS_RESET;
                            return(1);
                        }
                      }
                      else
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll is default next comand
                        i = 0;
                        while( i < ans_len-1 ){
                          if( ans[i] & 0x80 )
                          {
                            // bill deposit
//                            cash += BillSetup.Bill_Type_Credit[ans[i] & 0x0F]*BillSetup.Scaling_Factor; // manca correzione per punto decimale
                          }
                          else
                          {
                            // status
                            switch( ans[i] )
                            {
                              case CASHLESS_JUST_RESET:
                                // DEBUG il lettore di carta di credito MEI non risponde JUST RESET dopo un reset hardware, solo dopo
                                // il comando di reset dal VMC!!
                                MDBcmd( CASHLESS_SETUP, 6, 0xFF );
                                pMDBPerif->cmd[1] = 0x00;
                                pMDBPerif->cmd[2] = VMCLevel; // VMC level
                                pMDBPerif->cmd[3] = 16;   // display columns
                                pMDBPerif->cmd[4] = 1;    // display rows
                                pMDBPerif->cmd[5] = 1;    // display ASCII
                                pMDBPerif->status = CASHLESS_SETUP;
                                if( pCashless->State != CASHLESS_STATE_NOT_PRESENT )
                                  InsertEvent( EVENT_CARD_OUT, 0 );     // manca correzione per punto decimale
                                memset( pCashless, 0x00, sizeof( struct S_CASHLESS ) );
                                pCashless->State = CASHLESS_STATE_NOT_PRESENT;
                                if( pCashlessCmd != NULL ) pCashlessCmd->response = -1;
#if MDB_DEBUG
evento_just_reset = 2000;//EEE
#endif
                                break;

                              case CASHLESS_READER_CONFIG_DATA:
                                i += CashlessConfig( &ans[i]);
                                break;

                              case CASHLESS_DISPLAY_REQUEST:
                                if( pCashless->State != CASHLESS_STATE_INACTIVE )  // almeno il comando di setup deve essere stato inviato
                                {
                                  //  byte      time
                                  //  byte[16]  ascii data
                                }
                                i += 17;  // potrebbe non essere corretto, dipende dal comando di SETUP
                                break;

                              case CASHLESS_BEGIN_SESSION:
                                if( pCashless->Setup.Feature_Level == 1 || VMCLevel == 1 )
                                {
                                  // unsigned int found available
                                  val = Cv2ushort( ans[i+1], ans[i+2] )*pCashless->Setup.Scaling_Factor;
                                  i += 2;
                                }
                                else
                                {
                                  if( CASHLESS_EXPANDED_CURRECY )
                                  {
                                    // unsigned long found available
                                    // unsigned long : payment media ID
                                    // byte payment type
                                    // unsigned short : media type
                                    // unsigned short : user language
                                    // unsigned short : user currency
                                    // byte : card options
                                    i += 16;
                                  }
                                  else
                                  {
                                    // unsigned int found available
                                    val = Cv2ushort( ans[i+1], ans[i+2] )*pCashless->Setup.Scaling_Factor;
                                    // unsigned long : payment media ID -- il test su I fatto tutte le volte perche' qualche CASHLESS
                                    // byte payment type
                                    // unsigned short : media type
                                    i += 9;
                                  }
                                }
                                if( pCashless->State == CASHLESS_STATE_ENABLED && cashless_active_addr == 0xff )
                                {
                                  pCashless->State = CASHLESS_STATE_IDLE;
                                  
//mmm                                  
cashless_active_addr = pMDBPerif->addr;                                  
if( cashless_active_addr == 0x10 )  
    cashless_idx = 0;
else
    cashless_idx = 1;                                  
                                  
                                  InsertEvent( EVENT_CARD_IN, val ); // manca correzione per punto decimale
                                }
                                if( pCashless->Setup.Feature_Level == 2 && VMCLevel > 1 )
                                {
                                  MDBcmd( (byte)CASHLESS_REVALUE_LIMIT_REQ, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_REVALUE_LIMIT_REQ>>8;
                                  pMDBPerif->status = CASHLESS_REVALUE_LIMIT_REQ;
                                }
                                break;

                              case CASHLESS_SESSION_CANCEL_REQUEST:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                   
                                pCashless->revalue_limit = 0;
//mmm                                  
cashless_active_addr = 0xff;                                  
                                InsertEvent( EVENT_CARD_OUT, 0 ); // manca correzione per punto decimale
                                MDBcmd( (byte)CASHLESS_SESSION_COMPLETE, 2, 0xFF );
                                pMDBPerif->cmd[1] = CASHLESS_SESSION_COMPLETE>>8;
                                pCashless->State = CASHLESS_STATE_ENABLED;
                                if( pCashlessCmd != NULL ) pCashlessCmd->response = -1;  // abort aby VMC pending request
                                break;

                              case CASHLESS_VEND_APPROVED:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                   
                                if( pCashless->State == CASHLESS_STATE_VEND )
                                {
                                  if ( pCashlessCmd != NULL )
                                  {
                                  // ( messaggio al VMC cha la vendita e' autorizzata )
                                    pCashlessCmd->response = 0;
                                  // parametro e' il prezzo delle vendita
                                    pCashlessCmd->val = Cv2ushort( ans[i+1], ans[i+2] );
                                  }
                                  pMDBPerif->status = CASHLESS_POLL;
////mmm                                  
//cashless_active_addr = 0xff; 
                                }
                                else {
                                  // non fare nulla
                                }
                                i += 2;
                                break;

                              case CASHLESS_VEND_DENIED:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                   
                                if( pCashless->State == CASHLESS_STATE_VEND )
                                {
                                  if ( pCashlessCmd != NULL )
                                  {
                                  // ( messaggio al VMC cha la vendita non e' autorizzata
                                    pCashlessCmd->response = -1;
                                  }
//L.0.Z                                  pMDBPerif->status = CASHLESS_POLL;
//mmm                                  
cashless_active_addr = 0xff;                                    
                                  InsertEvent( EVENT_CARD_OUT, 0 ); //N.0.Z manca correzione per punto decimale
                                  MDBcmd( (byte)CASHLESS_SESSION_COMPLETE, 2, 0xFF );
                                  pMDBPerif->cmd[1] = CASHLESS_SESSION_COMPLETE>>8;
                                  pMDBPerif->status = CASHLESS_POLL;
                                  pCashless->State = CASHLESS_STATE_IDLE;
                                }
                                else
                                  // non fare nulla
                                break;

                              case CASHLESS_END_SESSION:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                    
                                pCashless->State = CASHLESS_STATE_ENABLED;
                                pCashless->revalue_limit = 0;
                                if( pCashlessCmd != NULL ) pCashlessCmd->response = -1;  // abort aby VMC pending request
//mmm                                  
cashless_active_addr = 0xff;
                                break;

                              case CASHLESS_CANCELLED:
                                break;

                              case CASHLESS_PERIPHERAL_ID:
                                i += CashlessID( &ans[0] );
                                break;
                                
                              case CASHLESS_ERROR:
                                // MDB error counter inc  
                                if( ans[i+1] <= 0x0f )
                                    incMdbError(ans[i+1], CARD_READER_PAYMENT_MEDIA_ERROR);                                                                 
                                break;

                              case CASHLESS_OUT_SEQUENCE:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;  
                                MDBcmd( CASHLESS_RESET, 1, 0xFF );    // reset
                                pMDBPerif->status = CASHLESS_RESET;
                                break;

                              case CASHLESS_REVALUE_APPROVED:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                  
                                MDBcmd( (byte)CASHLESS_REVALUE_LIMIT_REQ, 2, 0xFF );
                                pMDBPerif->cmd[1] = CASHLESS_REVALUE_LIMIT_REQ>>8;
                                pMDBPerif->status = CASHLESS_REVALUE_LIMIT_REQ;
                                if( pCashlessCmd != NULL ) pCashlessCmd->response = 0;  // ok, revalue approved
                                break;

                              case CASHLESS_REVALUE_DENIED:
//                                if ( cashless_active_addr != pMDBPerif->addr )
//                                    break;                                
//L.0.Z                                MDBcmd( (byte)CASHLESS_REVALUE_LIMIT_REQ, 2, 0xFF );
//L.0.Z                                pMDBPerif->cmd[1] = CASHLESS_REVALUE_LIMIT_REQ>>8;
//L.0.Z                                pMDBPerif->status = CASHLESS_REVALUE_LIMIT_REQ;
                                MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                                pMDBPerif->status = CASHLESS_POLL;
                                if( pCashlessCmd != NULL ) pCashlessCmd->response = -1;  // ko, revalue denied
                                break;

                              case CASHLESS_REVALUE_LIMIT:
                                if ( cashless_active_addr != pMDBPerif->addr )
                                {
                                    pCashlessCmd->response = -1;           // abort comand
                                    break;    
                                }                                  
                                // read revalue limit
                                if( pCashless->Setup.Feature_Level == 1 || VMCLevel == 1 )
                                {
                                  // unsigned int found available
                                  val = Cv2ushort( ans[i+1], ans[i+2] )*pCashless->Setup.Scaling_Factor;
                                  i += 2;
                                }
                                else
                                {
                                  if( CASHLESS_EXPANDED_CURRECY )
                                  {
                                    // unsigned long found available
                                    i += 4;
                                  }
                                  else
                                  {
                                    // unsigned int found available
                                    val = Cv2ushort( ans[i+1], ans[i+2] )*pCashless->Setup.Scaling_Factor;
                                    i += 2;
                                  }
                                }
                                InsertEvent( EVENT_CARD_REVALUE_LIMIT, val );
                                pCashless->revalue_limit = val;
                                break;

                              default :
                                break;
                            }
                          }
                          i++;
                        }
                        return(1);
                      }
                      break;

                      // answer to SETUP
      case CASHLESS_SETUP:
                      if( ans_len == 8+1 )    // full answer
                      {
                        CashlessConfig( &ans[0] );

                        MDBcmd( CASHLESS_EXPANSION_ID, 31, 0xFF );
                        pMDBPerif->cmd[1] = CASHLESS_EXPANSION_ID >> 8;
                        memcpy( &pMDBPerif->cmd[2], VMCManufacturer, 3 );
                        memcpy( &pMDBPerif->cmd[5], VMCSerial, 12 );
                        memcpy( &pMDBPerif->cmd[17], VMCModel, 12 );
                        memcpy( &pMDBPerif->cmd[29], VMCSwRevision, 2 );
                        pMDBPerif->status = CASHLESS_EXPANSION_ID;
                        pCashless->State = CASHLESS_STATE_DISABLED;
                        return(1);    // send ACK
                      }                       // ACK answer, send POLL to retrive full answer ( status will not change, SETUP NEEDS an answer )
                      else if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                      }
                      else 
                      {
                        MDBcmd( CASHLESS_RESET, 1, 0xFF );      // reset
                        pMDBPerif->status = CASHLESS_RESET;
                        return(1);    // send ACK
                      }
                      // else repeat CASHLESS_SETUP
                      break;

      case CASHLESS_EXPANSION_ID:if( ans_len == 34+1 || ans_len == 30+1 )
                      {
                        i = 1;
                        CashlessID( &ans[0] );
                        if( pCashless->Setup.Feature_Level >= 3 )
                        {
                          memcpy( &pMDBPerif->cmd[2], &pCashless->Capabilities.Optional_Features[0], 4 );
                          MDBcmd( (byte)CASHLESS_EXPANSION_FEATURES_ENABLE, 6, 0xFF );    // Coin Status
                          pMDBPerif->cmd[1] = CASHLESS_EXPANSION_FEATURES_ENABLE>>8;
                          pMDBPerif->status = CASHLESS_EXPANSION_FEATURES_ENABLE;  // wait ACK
                        }
                        else
                        {
SET_PRICE:
                          MDBcmd( (byte)CASHLESS_SET_MAXMIN, 6, 0xFF );      // SET_MAXMIN
                          pMDBPerif->cmd[1] = CASHLESS_SET_MAXMIN >> 8;
//                          pMDBPerif->cmd[2] = hibyte(maxPrice);
//                          pMDBPerif->cmd[3] = lobyte(maxPrice);
                          pCashless->Setup.maxCredit = maxCredit;
                          pMDBPerif->cmd[2] = hibyte( pCashless->Setup.maxCredit );
                          pMDBPerif->cmd[3] = lobyte( pCashless->Setup.maxCredit );
                          pMDBPerif->cmd[4] = hibyte(minPrice);
                          pMDBPerif->cmd[5] = lobyte(minPrice);
                          pMDBPerif->status = CASHLESS_SET_MAXMIN;
                        }
                        return(i);    // send ACK ( if needed )
                      }
                      if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                      }
                      // else repeat LEVEL_CAP, retry command
                      break;

      case CASHLESS_EXPANSION_FEATURES_ENABLE:
                      i = 0;
                      if( ans_len == 1 && ans[0] == MDB_ACK ) goto SET_PRICE;
                      break;

                      // answer to SETUP_MAXMIN
      case CASHLESS_SET_MAXMIN:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( (byte)CASHLESS_ENABLE, 2, 0xFF );
                        pMDBPerif->cmd[1] = CASHLESS_ENABLE >> 8;
                        pMDBPerif->status = CASHLESS_ENABLE;
                      }
                      // else repeat SETUP
                      break;

      case CASHLESS_ENABLE:if( ans_len == 1 && ans[0] == MDB_ACK )
                      {
                        MDBcmd( CASHLESS_POLL, 1, 0xFF );    // poll
                        pMDBPerif->status = CASHLESS_POLL;
                        pCashless->State = CASHLESS_STATE_ENABLED;
                      }
                      else
                      // repeat
                      break;

      default : break;
    }
    return(0);
}                                               //  CashLess

/*
    Micromech interface
*/
enum  eMicroMech { MICROMECH_RESET_START = 0,
                   MICROMECH_RESET_END,
                   MICROMECH_RESET_INT_WAIT,
                   MICROMECH_INT_WAIT,
                   MICROMECH_CMD_WAIT,
                   MICROMECH_CMD_END,
                   MICROMECH_INT_END,
                   MICROMECH_TUBE_ASK,
                   MICROMECH_TUBE_WAIT,
                   MICROMECH_DISPENSE,
                   MICROMECH_MDB_WAIT,
                   MICROMECH_MDB_TUBE_WAIT,
                   MICROMECH_ERR
                  };

enum  eMicroMechCmd { MICROMECH_CMD_POWERUP_LOW = 0x63,
                      MICROMECH_CMD_POWERUP_HIGH = 0x73,
                      MICROMECH_CMD_ESCROW_LOW = 0x6E,
                      MICROMECH_CMD_ESCROW_HIGH = 0x7E,
                      MICROMECH_CMD_JAM_LOW = 0x27,
                      MICROMECH_CMD_JAM_HIGH = 0x37,
                      MICROMECH_CMD_SENSOR_LOW = 0x27,
                      MICROMECH_CMD_SENSOR_HIGH = 0x77,
                      MICROMECH_CMD_NOSTROBE_LOW = 0x6F,
                      MICROMECH_CMD_NOSTOBE_HIGH = 0x7F,
                      MICROMECH_CMD_SLUG_LOW = 0x6B,
                      MICROMECH_CMD_SLUG_HIGH = 0x7B,
                      MICROMECH_CMD_DOLLAR_LOW = 0x03,
                      MICROMECH_CMD_DOLLAR_HIGH = 0x13,
                      MICROMECH_CMD_DUALCOIN_LOW = 0x23,
                      MICROMECH_CMD_DUALCOIN_HIGH = 0x33
                  };

byte  CoinMicromechStatus = MICROMECH_RESET_START;
byte  BillMicromechStatus = MICROMECH_RESET_START;
unsigned int CoinMicromechTimer = 0, MicromechAETimer = 0, MicromechReset = 0;
unsigned int BillMicromechTimer = 0;

#define micromech_enBill  0x40
//#define micromech_100     0x40
#define micromech_reset   0x20
#define micromech_send    0x10
#define micromech_AE      0x08
#define micromech_5c      0x04
#define micromech_10c     0x02
#define micromech_25c     0x01

#define micromech_int     0x08

#define micromech_wait()  ( ( machineType == MACHINA_ROWE5900 || machineType == MACHINA_ROWE6800 ) ? inImage[3] & 0x08 :  inImage[2] & micromech_int )

byte            CoinMicromech( void )
{
    byte        ch, i;

    if( MicromechAETimer != 0 ) MicromechAETimer--;   // min low timer for AE
    
    switch( CoinMicromechStatus )
    {
        case MICROMECH_RESET_START: 
#if ANTI_V
#else
                      if( ++CoinMicromechTimer < 100 )
                      {
                          outImage[OUT_COIN_BILL] |= micromech_reset;
                          outImage[OUT_COIN_BILL] &= ~( micromech_send | micromech_AE | micromech_5c | micromech_10c | micromech_25c ); // | micromech_100 );
                          break;
                      }
                      outImage[OUT_COIN_BILL] &= ~micromech_reset;     // reset high
#endif
                      memset( &Change, 0x00, sizeof( Change ) );
                      Change.CoinStatus.Coin_Enable = 0x0000;
                      Change.Cmd.Coin_Enable = 0xFFFF;
                      Change.CoinStatus.Manual_Dispense_Enable = 0x0000;
                      if( pChangerCmd != NULL ) pChangerCmd->response = -1;
                      
                      CoinMicromechTimer = 11;                  // start 10ms reset
                      MicromechReset = 0;
                      CoinMicromechStatus = MICROMECH_RESET_END;
                      break;

        case MICROMECH_RESET_END:
                      if( --CoinMicromechTimer != 0 )  break;
#if ANTI_V
#else
                      outImage[OUT_COIN_BILL] |= micromech_reset;      // reset low
#endif
                      CoinMicromechTimer = 2000;                // wait 2000ms for answer
                      CoinMicromechStatus = MICROMECH_RESET_INT_WAIT;
                      break;

        case MICROMECH_RESET_INT_WAIT:
                      if( micromech_wait() )      // wait INT low
                      {
                        if( --CoinMicromechTimer != 0 )  break;// answer timeout
                        {
                          // end timeout > no coin mech attached!
                          CoinMicromechStatus = MICROMECH_ERR;
                          break;
                        }
                      }
                      CoinMicromechStatus = MICROMECH_MDB_WAIT;
                      break;
                      
       case MICROMECH_MDB_WAIT:
                      if( MDB_in_use() )
                      {
                          Micromech_needs_uart = 1;
                          break;
                      }
#if ANTI_V
#else
                      outImage[OUT_COIN_BILL] |= micromech_send;      // send
#endif
                      CoinMicromechTimer = 50;                            // timeout, inclusing data byte trasmission time ( 17ms )
                      CoinMicromechStatus = MICROMECH_CMD_WAIT;
                      break;

        case MICROMECH_CMD_WAIT:
        case MICROMECH_TUBE_WAIT:
                      if( commGetChar( COMM3, &ch ) == COMM_RX_EMPTY ) // wait command on serial line
                      {
                        if( --CoinMicromechTimer == 0 )         // answer timeout
                          CoinMicromechStatus = MICROMECH_ERR;// end timeout > retry
                        break;
                      }
                      MicromechReset = 0;
                      if( CoinMicromechStatus == MICROMECH_TUBE_WAIT )
                      {
                          if( ( ch & 0xA3 ) == 0x23 )
                          {
                              if( ch & 0x04 ) { Change.TubeStatus.Tube_Status[2] = 4; Change.TubeStatus.Escrow_Status[2] = 0; }
                              if( ch & 0x08 ) { Change.TubeStatus.Tube_Status[1] = 6; Change.TubeStatus.Escrow_Status[1] = 0; }
                              if( ch & 0x10 ) { Change.TubeStatus.Tube_Status[0] = 4; Change.TubeStatus.Escrow_Status[0] = 0; }
                              if( ch & 0x40 ) { Change.TubeStatus.Tube_Status[3] = 0; Change.TubeStatus.Escrow_Status[3] = 0; }
                          }
                      }
                      else if( ( ch & 0x02 ) == 0x00 )           // coin message
                      {
                        switch( ch & 0x60 )
                        {
                          case 0x20:  i = 2; break;
                          case 0x40:  i = 1; break;
                          case 0x60:  i = 0; break;
                          default:    i = 3; break;
                        }
                        // TRC6000
                        // 0x10    5 tube empty   >> set tube to empty level of 4 coins
                        // 0x08   10 tube empty   >> set tube to empty level of 6 coins
                        // 0x04   25 tube empty   >> set tube to empty level of 4 coins
                        // 0x01    to tubes       >> when sent to cashbox set tube to full level
                        //                          5 cent : 66, 10 cent : 96, 25 cent : 63
                        // coin deposit
                        if( ch & 0x01 )
                        {
                            InsertEvent2( EVENT_COIN_IN_TUBE, Change.Setup.Coin_Type_Credit[i], i, 0 );
                            Change.TubeStatus.Escrow_Status[i]++;
                        }
                        else
                            InsertEvent( EVENT_COIN_IN_CASHBOX, Change.Setup.Coin_Type_Credit[i] );
                      }
                      else
                      {
                        // non coin messages
                        switch( ch & 0xEF )
                        {
                          case 0x63:  // power-up
                                      MicromechReset = 1;
                                      memcpy( &Change.LevelTreeCapabilities.Manufacturer_Code[0], "MEI", 3 );
                                      memcpy( &Change.LevelTreeCapabilities.Serial_Number[0], "MICROMECH   ", 12 );
                                      memcpy( &Change.LevelTreeCapabilities.Tuning_Revision[0], "            ", 12 );
                                      Change.Setup.Country_Currency_Code  = 0x0001; // USA  DEBUG:::: 
                                      Change.Setup.Scaling_Factor = 5;
                                      Change.Setup.Decimal_Places = 0;
                                      Change.Setup.Coin_Type_Routing = 0x0007;
                                      Change.Setup.Coin_Type_Credit[0] = 5;
                                      Change.Setup.Coin_Type_Credit[1] = 10;
                                      Change.Setup.Coin_Type_Credit[2] = 25;
                                      Change.Setup.Coin_Type_Credit[3] = 100;
                                      break;
                          case 0x6E:  // escrow
                                      InsertEvent( EVENT_ESCROW, 0 );
                                      break;
                          case 0x27:  // coin jam
                          case 0x67:  // defective sensor 
                          case 0x6F:  // no strobe
                          case 0x6B:  // slug
                          case 0x03:  // dollar not accepted
                          case 0x23:  // double arrival
                          default:    break;
                        }
                      }
                      CoinMicromechTimer = 2;                 // delay 2ms
                      CoinMicromechStatus = MICROMECH_CMD_END;
                      break;

        case MICROMECH_CMD_END:
                      if( CoinMicromechTimer-- != 0 ) break;
#if ANTI_V
#else
                      outImage[OUT_COIN_BILL] &= ~micromech_send;   // clear SEND
#endif
                      CoinMicromechStatus = MICROMECH_INT_END;
                      break;

        case MICROMECH_INT_END:
                      if( micromech_wait() )
                      {
                          if( MicromechReset )
                          {
                              outImage[OUT_COIN_BILL] |= micromech_AE;    // enable AE to request tube status
                              Change.CoinStatus.Coin_Enable = Change.Cmd.Coin_Enable; // force only to make effective enable status aligned with requested status
                              MicromechAETimer = 100;
                              CoinMicromechStatus = MICROMECH_TUBE_ASK;
                          }
                          else
                              CoinMicromechStatus = MICROMECH_INT_WAIT;
                      }
                      break;

        case MICROMECH_INT_WAIT:
                      if( pChangerCmd != NULL && pChangerCmd->response == 1 )
                      {
                        switch( pChangerCmd->cmd )
                        {
                                  // va inserito un timeout di esecuzione del comando!!
                                  // PAYOUT
                                  // DEBUG : cosa succede se mentre faccio payout entra una moneta ? POLL rende valore moneta ?
                          case CHANGER_CMD_PAYOUT :
                                  if( pChangerCmd->val != 0 )
                                  {                                      
                                      if( pChangerCmd->val < Change.Setup.Scaling_Factor )          // [04.04.2008] se inferiore al minimo
                                          pChangerCmd->val = 0;										// [04.04.2008] azzera il residuo
                                      // erogazione ( solo 4 tipi di monete )
                                      i = 3;
                                      while( ( Change.Setup.Coin_Type_Credit[i] == 0 ||                 // moneta esistente
                                               Change.Setup.Coin_Type_Credit[i] > pChangerCmd->val ||   // di valore maggiore del resto
                                             ( Change.TubeStatus.Tube_Status[i] +
                                               Change.TubeStatus.Escrow_Status[i] ) == 0 ) &&         // tubo non vuoto
                                             i != 0 ) i--;                                              // scansione di tutte le monete
                                      if( ( Change.TubeStatus.Tube_Status[i] + Change.TubeStatus.Escrow_Status[i] ) != 0 &&
                                            pChangerCmd->val > 0 )
                                      {
                                            switch( i )
                                            {
                                                case 0 : ch = micromech_5c; break;
                                                case 1 : ch = micromech_10c; break;
                                                case 2 : ch = micromech_25c; break;
                                                // case 3 : ch = micromech_100; break;
                                                default : ch = 0; break;
                                            }
                                            outImage[OUT_COIN_BILL] |= ch;
                                            
                                            pChangerCmd->val -= Change.Setup.Coin_Type_Credit[i];
                                            if( Change.TubeStatus.Escrow_Status[i] )
                                                Change.TubeStatus.Escrow_Status[i]--;
                                            else if( Change.TubeStatus.Tube_Status[i] )
                                                Change.TubeStatus.Tube_Status[i]--;
                                            InsertEvent( EVENT_COIN_PAYOUT, Change.Setup.Coin_Type_Credit[i] );
                                            CoinMicromechTimer = 100;                 // impulso 100ms
                                            CoinMicromechStatus = MICROMECH_DISPENSE;
                                      }
                                      else
                                      {
                                        pChangerCmd->response = 0;;       // end dispense
                                      }
                                  }
                                  else
                                  {
                                    pChangerCmd->response = 0;
                                  }
                                  break;
                                  
                          default:
                                  pChangerCmd->response = -1;
                                  break;
                        }
                      }
                      // handle enable/disable coin changer
                      else if( Change.Cmd.Coin_Enable != Change.CoinStatus.Coin_Enable )
                      {
                        if( Change.Cmd.Coin_Enable & 0x0007 )   // abilitazione globale
                        {
                            outImage[OUT_COIN_BILL] |= micromech_AE;    // enable AE
                            Change.CoinStatus.Coin_Enable = Change.Cmd.Coin_Enable;
                            MicromechAETimer = 10+10;                      // not less than 10ms ( 20ms to be safe with COINCO changegiver )
                        }
                        else
                        {
                          if( ( MicromechAETimer == 0 ) && ( outImage[OUT_COIN_BILL] & micromech_AE ) )  // disable and read tube status
                          {
//z                             outImage[OUT_COIN_BILL] &= ~micromech_AE;   // clear AE
                              Change.CoinStatus.Coin_Enable = Change.Cmd.Coin_Enable;
//Z                              MicromechTimer = 200;                       // timeout
                              CoinMicromechStatus = MICROMECH_MDB_TUBE_WAIT;
                          }
                        }
                        break;
                      }
                      // wait INT signal
                      Micromech_needs_uart = 0;
                      if( micromech_wait() )          // wait INT low
                          break;
                      CoinMicromechStatus = MICROMECH_MDB_WAIT;
                      break;
#if ANTI_V
#else
           //           outImage[OUT_COIN_BILL] |= micromech_send;      // send
#endif
           //           MicromechTimer = 200;                 // timeout
           //           CoinMicromechStatus = MICROMECH_CMD_WAIT;
           //           break;

        case MICROMECH_DISPENSE:
                      if( CoinMicromechTimer-- != 0 ) break;
                      if( outImage[OUT_COIN_BILL] & ( micromech_5c | micromech_10c | micromech_25c ) ) // | micromech_100 )  )
                      {
                          outImage[OUT_COIN_BILL] &= ~( micromech_5c | micromech_10c | micromech_25c ); //| micromech_100 );
                          CoinMicromechTimer = 400;              // timeout
                      }
                      else
                          CoinMicromechStatus = MICROMECH_INT_WAIT;
                      break;
                        
                      
        case MICROMECH_TUBE_ASK:
                      if( ( MicromechAETimer == 0 ) && ( outImage[OUT_COIN_BILL] & micromech_AE ) )  // disable and read tube status
                      {
// Z                          outImage[OUT_COIN_BILL] &= ~micromech_AE;   // clear AE
                          Change.CoinStatus.Coin_Enable = ~Change.Cmd.Coin_Enable; // to force following realigment of the enable status
// Z                          MicromechTimer = 200;                       // timeout
                          CoinMicromechStatus = MICROMECH_MDB_TUBE_WAIT;
                      }
                      break;
                      
        case MICROMECH_MDB_TUBE_WAIT:
                      if( MDB_in_use() )
                      {
                          Micromech_needs_uart = 1;
                          break;
                      }
                      outImage[OUT_COIN_BILL] &= ~micromech_AE;   // clear AE    
                      CoinMicromechTimer = 50;                        // timeout, spec is 20ms, 50ms for some spare, including data send time 17ms
                      CoinMicromechStatus = MICROMECH_TUBE_WAIT;
                      break;
      
        default:      CoinMicromechStatus = MICROMECH_ERR;
                      CoinMicromechTimer = 0;
                      Micromech_needs_uart = 0;
                      break;
    }
    return Micromech_needs_uart;
}                                               //  CoinMicromech

BOOL CoinMicromechAttached( void )
{
    return( CoinMicromechStatus != MICROMECH_ERR );
}

// out /SEND,     ENAB5$ (pin34) 0x80
// out /ACCEPT,   ENAB1$ (pin33) 0x40

// in  /IRQ,      /IRQ   (pin36) 0x04
// in  STACKFULL, /FULL STACKER (pin....)
// in  %1 ACCEPT, $1 IN  (pin39) 0x80

static void SetMicroMechSpeed( void )
{
      dword       divisor;

#if ANTI_V
#else
    if ( (FIO3PIN & BIT26) == 0x00 )
        return;
#endif

    divisor = (SYSTEMFREQ >>6) /    600;
    U2LCR_bit.DLAB = 1;	            // DLAB = 1
    U2DLM = divisor >> 8;
    U2DLL = divisor;
    U2LCR_bit.DLAB = 0;	            // DLAB = 0
    U2LCR = 0x03;
//    commCfgPort( COMM3_MDB, Baud600, WordLength8, ParitySelStickHigh, StopBit1 );

#if ANTI_V
#else
    FIO3CLR_bit.P3_26 = 1;              // switch to Micromech
    outImage[OUT_COIN_BILL] |= 0x80;    // enable bill send
#endif
    pMDBPerif->reset_poll_timer = MDBTime;
}


void            StartBillMicromech( void )
{
    if ( Bill.Capabilities.Manufacturer_Code[0] != 0 || Bill.Capabilities.Software_Version != 0  )
        return;
    
    SetMicroMechSpeed();
}

void            EndBillMicromech( void )
{
    dword       divisor;
    
#if ANTI_V
#else
    if ( (FIO3PIN & BIT26) != 0x00 )
        return;

    outImage[OUT_COIN_BILL] &= ~0x80;   // disable bill send
    FIO3SET_bit.P3_26 = 1;              // switch to MDB
#endif

    divisor = (SYSTEMFREQ >>6) /   9600;
    U2LCR_bit.DLAB = 1;	            // DLAB = 1
    U2DLM = divisor >> 8;
    U2DLL = divisor;
    U2LCR_bit.DLAB = 0;	            // DLAB = 0
    U2LCR = 0x03 | 0x28;                // enable parity as stick 0
//    commCfgPort( COMM3_MDB, Baud9600, WordLength8, ParitySelStickHigh, StopBit1 );
#if RSR903_MDB
    T3MR3 = T3TC + T_RESPONSE;
    T3MCR |= 0x0200;
#else    
    T3TC = 0;               // start t-response time
    T3MR3 = T_RESPONSE;
    T3TCR = 0x01;
#endif
}

byte            BillMicromech( void )
{
    byte        ch;

    if ( Bill.Capabilities.Manufacturer_Code[0] != 0 || Bill.Capabilities.Software_Version != 0  )
        return 1;
    
    if ( (MDBTime-pMDBPerif->reset_poll_timer) > 50 )
        return 1;

    switch( BillMicromechStatus )
    {
        case MICROMECH_RESET_START: 
#if ANTI_V
#else
            outImage[OUT_COIN_BILL] |= 0x80;      // bill send
            outImage[OUT_COIN_BILL] |= 0x40;      // bill accept enable
#endif
            BillMicromechTimer = 100;                 // timeout
            BillMicromechStatus = MICROMECH_CMD_WAIT;
            break;

        case MICROMECH_CMD_WAIT:
            if ( Bill_Micromech.BillEnable == 0x0000 )
            {
#if ANTI_V
#else
                outImage[OUT_COIN_BILL] &= ~0x80;      // bill send
                outImage[OUT_COIN_BILL] &= ~0x40;      // bill accept enable
#endif
            }
            else
            {
#if ANTI_V
#else
                outImage[OUT_COIN_BILL] |= 0x80;      // bill send
                outImage[OUT_COIN_BILL] |= 0x40;      // bill accept enable
#endif
            }

/*
            if( pBillCmd != NULL && pBillCmd->response == 1 )
            {
                switch( pBillCmd->cmd )
                {
                                    // va inserito un timoeut di esecuzione del comando!!
                                    // STACK
                                    // DEBUG : cosa succede se mentre faccio payout entra una moneta ? POLL rende valore moneta ?
                    case BILL_CMD_ESCROW :
outImage[OUT_COIN_BILL] &= 0x40;      // bill accept enable
                        pMDBPerif->status = BILL_ESCROW;
                        pBillCmd->response = 2;   // command is in exec
                        break;

                    default:
                        pBillCmd->response = -1;
                        break;
                }
            }
*/

                        if( commGetChar( COMM3, &ch ) == COMM_RX_EMPTY ) // wait command on serial line
                        {
                            if( BillMicromechTimer-- == 0 )         // answer timeout
                                BillMicromechStatus = MICROMECH_CMD_WAIT;// end timeout > retry
                            break;
                        }
                        if ( (ch & 0xF0) == 0x80 )
                        {
                            switch( ch & 0x0F )
                            {
                                case 0x01:  InsertEvent( EVENT_BILL_IN, 100 ); break;
                                default:    break;
                            }
                            outImage[OUT_COIN_BILL] &= 0x40;      // bill accept enable
                        }

                        Bill_Micromech.present = 1;
                        memcpy( &Bill_Micromech.Manufacturer_Code[0], "MEI", 3 );
                        memcpy( &Bill_Micromech.Serial_Number[0], "MICROMECH   ", 12 );
                        memcpy( &Bill_Micromech.Tuning_Revision[0], "            ", 12 );

                        BillMicromechTimer = 20;                 // delay 2ms
                        BillMicromechStatus = MICROMECH_CMD_END;
                        break;

        case MICROMECH_CMD_END:
                        if( BillMicromechTimer-- != 0 ) break;
#if ANTI_V
#else
                        outImage[OUT_COIN_BILL] &= ~0x10;   // clear SEND
                        outImage[OUT_COIN_BILL] |= 0x40;      // bill accept enable
#endif
                        BillMicromechStatus = MICROMECH_INT_END;
                        break;

        case MICROMECH_INT_END:
                        BillMicromechStatus = MICROMECH_CMD_WAIT;
                        break;

        default:        BillMicromechStatus = MICROMECH_ERR;
                        break;
    }
    
    return 0;
}                                               //  BillMicromech


enum  eParallel  { PARALLEL_RESET_START = 0,
                   PARALLEL_PULSE_WAIT,
                   PARALLEL_PULSE_MEASURE,
                   PARALLEL_ESCROW_DONE,
                   PARALLEL_PULSE_DISABLE,
                   PARALLEL_ERR
                  };

struct {
    byte        status;
    byte        waitEscrow;
    byte        ncount;
    byte        Escrow;
    DWORD       tHigh, tLow;
    struct S_BILLSETUP Setup;
    struct S_BILL_CCMD Cmd;
} billParallel = {
    PARALLEL_RESET_START,
    0,
    0,
    0,
    0, 0,
    {0},
    {0,0}
};
byte            parallelBillEscrow = 1;
// used pin 32-31-30 ... O5-O4-O3
//              ESCROW              ENAB.BILL           IRQ
// AP113:       pin25-K12-0x10      pin34-O7-0x80       pin36-I1-0x04
// NAT147:      pin42-I7-0x10       pin33-O6-0x40       pin36-I1-0x04
// ROWE5900:    pin12-              pin34-O7-0x80       pin16-       
// ROWE6800:    pin12-              pin34-O7-0x80       pin16-       
// NAT157:      pin39-I4-0x80       pin34-O7-0x80       pin40-I5-0x40
// AP7000:      pin28-O1-0x02       pin27-O0-0x01       pin35-I0-0x08
// LCM123:      pin37-I2-0x02       pin33-O6-0x40       pin36-I1-0x04
// AP123:       pin27-O0-0x01      pin33-O6-0x40       pin36-I1-0x04
// VEIDOOR:     pin27-O0-0x01      pin33-O6-0x40       pin36-I1-0x04
// NAT145:      pin42-I7-0x10       pin33-O6-0x40       pin36-I1-0x04
// AMS39:       ?????
// NAT157:      pin39-I4-0x80       pin34-O7-0x80       pin40-I5-0x40
// USIGVC2:     ?????

const byte    escrowMask[TOTAL_MACHINE][2] = {//escrow-out
    {OUT_SG8_SG15, 0x10},// MACHINA_AP113     
    {OUT_COIN_BILL,0x80},// MACHINA_NAT147    
    {OUT_COIN_BILL,0x40},// MACHINA_ROWE5900  
    {OUT_COIN_BILL,0x40},// MACHINA_ROWE6800  
    {OUT_COIN_BILL,0x40},// MACHINA_NAT157    
    {OUT_COIN_BILL,0x02},// MACHINA_AP7000    
    {OUT_COIN_BILL,0x80},// MACHINA_LCM123    
    {OUT_COIN_BILL,0x01},// MACHINA_AP123     
    {OUT_COIN_BILL,0x01},// MACHINA_VEIDOOR     
    {OUT_COIN_BILL,0x80},// MACHINA_NAT145
    {OUT_COIN_BILL,0x00},// MACHINA_AMS39  -- debug, NOT USED
    {OUT_COIN_BILL,0x40},// MACHINA_VEI147    
    {OUT_COIN_BILL,0x00},// MACHINA_USIGVC2  -- debug, NOT USED
    {OUT_COIN_BILL,0x00},// MACHINA_MERCHA6  -- debug, NOT USED
    {OUT_COIN_BILL,0x01},// MACHINA_VEILCM 
};

const byte    enabBillMask[TOTAL_MACHINE] = {//enab-out
                   0x80,// MACHINA_AP113     
                   0x40,// MACHINA_NAT147    
                   0x80,// MACHINA_ROWE5900  
                   0x80,// MACHINA_ROWE6800  
                   0x80,// MACHINA_NAT157    
                   0x01,// MACHINA_AP7000    
                   0x40,// MACHINA_LCM123    
                   0x40,// MACHINA_AP123      
                   0x40,// MACHINA_VEIDOOR      
                   0x40,// MACHINA_NAT145
                   0x00,// MACHINA_AMS39   -- debug, NOT USED
                   0x80,// MACHINA_VEI147    
                   0x00,// MACHINA_USIGVC2   -- debug, NOT USED
                   0x00,// MACHINA_MERCHA6   -- debug, NOT USED
                   0x40,// MACHINA_VEILCM 
};

const byte    irqMask[TOTAL_MACHINE][2] = {//irq-in
    {            2,0x04},// MACHINA_AP113     
    {            2,0x04},// MACHINA_NAT147    
    {            3,0x20},// MACHINA_ROWE5900  
    {            3,0x20},// MACHINA_ROWE6800  
    {            2,0x40},// MACHINA_NAT157    
    {            2,0x08},// MACHINA_AP7000    
    {            2,0x04},// MACHINA_LCM123    
    {            2,0x04},// MACHINA_AP123       
    {            2,0x04},// MACHINA_VEIDOOR       
    {            2,0x04},// MACHINA_NAT145
    {            2,0x00},// MACHINA_AMS39  -- debug, NOT USED
    {            2,0x40},// MACHINA_VEI147    
    {            2,0x00},// MACHINA_USIGVC2  -- debug, NOT USED
    {            2,0x00},// MACHINA_MERCHA6  -- debug, NOT USED
    {            2,0x04},// MACHINA_VEILCM 
};

byte            BillParallel( void )
{
    DWORD       deltaT;

    if ( Bill.Capabilities.Manufacturer_Code[0] != 0 || Bill.Capabilities.Software_Version != 0 )
    {                                   // bill disable
        outImage[OUT_COIN_BILL] &= ~enabBillMask[machineType];      
        return 1;
    }

    switch ( billParallel.status )
    {
        case PARALLEL_RESET_START: 
            BillMicromechTimer = 100;                 // timeout
            memset ( &billParallel, 0, sizeof(billParallel) );
            billParallel.Setup.Bill_Type_Credit[0] = 100;
            billParallel.Setup.Bill_Type_Credit[1] = 200;
            billParallel.Setup.Bill_Type_Credit[2] = 500;
            billParallel.status = PARALLEL_PULSE_WAIT;
            break;

        case PARALLEL_PULSE_WAIT:
            billParallel.Escrow = 1;
            if ( billParallel.waitEscrow )
            {                           // 
                outImage[OUT_COIN_BILL] &= ~enabBillMask[machineType];      // bill disable
                if ( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW )
                {
                    if ( pBillCmd->val == 0 )
                    {
                        parallelBillEscrow = 1;// return bill, escrow disable
                        pBillCmd = NULL;
                    }
                    else
                    {
                        parallelBillEscrow = 0;// accept bill, escrow enable
                        InsertEvent( EVENT_BILL_IN, 100*billParallel.ncount );
                    }
                    billParallel.status = PARALLEL_ESCROW_DONE;
                    billParallel.tLow = GetTickCount();
                    break;
                }
            }
            else
            {                           // set escrow output line
                if ( billParallel.Cmd.Bill_Escrow_Enable == 0  )
                    parallelBillEscrow = 1;// escrow disable
                else
                    parallelBillEscrow = 0;// escrow enable

                if ( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW )
                    pBillCmd->response = 0;//done

                if ( billParallel.Cmd.Bill_Enable == 0x0000 )
                    outImage[OUT_COIN_BILL] &= ~enabBillMask[machineType];      // bill disable
                else
                    outImage[OUT_COIN_BILL] |=  enabBillMask[machineType];      // bill enable
            }

            if ( (inImage[irqMask[machineType][0]]&irqMask[machineType][1]) != 0 )
            {                           // signal high
                if ( billParallel.tHigh != 0 && (GetTickCount()-billParallel.tHigh) > 100 )
                {                       // over time, end of count
                    if ( billParallel.ncount != 0 )
                    {                   // number of counts, add bill
                        if ( billParallel.Cmd.Bill_Escrow_Enable )
                            InsertEvent( EVENT_BILL_ESCROW, 100*billParallel.ncount );
                        else
                            InsertEvent( EVENT_BILL_IN, 100*billParallel.ncount );
                    }
                    billParallel.tHigh = 0;
                    if ( billParallel.Cmd.Bill_Escrow_Enable )
                        billParallel.waitEscrow = 1;
                }
            }
            else
            {
                Bill_Micromech.present = 1;
                memcpy( &Bill_Micromech.Manufacturer_Code[0], "VEI", 3 );
                memcpy( &Bill_Micromech.Serial_Number[0], "PARALLEL    ", 12 );
                memcpy( &Bill_Micromech.Tuning_Revision[0], "            ", 12 );

                if( billParallel.tHigh == 0 )
                    billParallel.ncount = 0;
                billParallel.status = PARALLEL_PULSE_MEASURE;
                billParallel.tLow = GetTickCount();
            }
            break;

        case PARALLEL_PULSE_MEASURE:
            if ( (inImage[irqMask[machineType][0]]&irqMask[machineType][1]) != 0 )
            {
                deltaT = (GetTickCount()-billParallel.tLow);
                if ( deltaT > 20 && deltaT < 40 )
                    billParallel.ncount++;
                billParallel.status = PARALLEL_PULSE_WAIT;
                billParallel.tHigh = GetTickCount();
                if ( billParallel.tHigh == 0 )
                    billParallel.tHigh++;
            }
            break;

        case PARALLEL_ESCROW_DONE:
            if ( (GetTickCount()-billParallel.tLow) > 40 )
            {
                billParallel.waitEscrow = 0;
                parallelBillEscrow = 0;// escrow enable
                outImage[OUT_COIN_BILL] |=  enabBillMask[machineType];      // bill enable
                billParallel.status = PARALLEL_PULSE_DISABLE;
                billParallel.tLow = GetTickCount();
            }
            break;
            
        case PARALLEL_PULSE_DISABLE:
            if ( (GetTickCount()-billParallel.tLow) > 1250 )
            {
                billParallel.status = PARALLEL_PULSE_WAIT;
                if ( pBillCmd != NULL )
                    pBillCmd->response = 0;//done
            }
            break;
            
        default:        
            billParallel.status = PARALLEL_RESET_START;
            break;
    }

    return 0;
}                                               //  BillParallel

void            MicroMech( void )
{
    if( machineType != MACHINA_USIGVC2 )
        CoinMicromech();
    else
        CoinMicromechStatus = MICROMECH_ERR;
}




/*--------------------------------------------------------------------------
 | startMDB:    activate MDB communication if no Micromech devices
 |              after reset, micromech coin is enabled, and Micromech_needs_uart is set
 |              after Micromech initializaztion, MDB is started, once
 |                              --------------
 | In:
 | Out:
 +--------------------------------------------------------------------------*/

void            startMDB( void )
{
    if ( ( Micromech_needs_uart == 0 ) && !MDB_started )    // micromech coin connected, received respone to reset
    {
        // MDB port
#ifndef __WIN32__
        FIO3SET_bit.P3_26 = 1;   // switch MDB/Micromach to MDB
#endif
        commCfgPort( COMM3_MDB, Baud9600, WordLength8, ParitySelStickHigh, StopBit1 );
        MDB_started = TRUE;
    }
}                                               //  startMDB

/*--------------------------------------------------------------------------
 | Simple Slave MDB : send a command to enable slave, send send to slave the
 |                    request for a selection. The selection is by default
 |                    executed, no selection fail
 |                              --------------
 | In:
 | Out: 
 +--------------------------------------------------------------------------*/
#if SLAVE_MACHINE
byte SlaveTray = 0xFF, SlaveRow = 0xFF, SlaveForceReset = 0, SlaveAddrOffset = 0;
byte SlaveStatus[MAX_MACHINE_NUM];
byte SlaveSelectionStatus[MAX_MACHINE_NUM];

struct S_SLAME_CAPABILITIES {
  char  Manufacturer_Code[3];
  char  Serial_Number[8];
  char  Tuning_Revision[4];
  char  MaxSelectionTimeout;
} Slave_capabilities;
 
byte            GetSlaveAddr( byte slave) 
{
    switch (slave) {
        case 2:
            return 0x40;
        case 3:
            return 0x48;
        case 4:
            return 0x50;
        default:    
            return 0x00;
    }
}

byte            GetSlaveIndex( byte addr )
{
    switch (addr) {
        case 0x40:
            return 2;
        case 0x48:
            return 3;
        case 0x50:
            return 4;
        default:    
            return 0;
    }
}


/*--------------------------------------------------------------------------
 |  SimpleSlave :  manage a simple slave VMC ( see Slave 1 )
 |                              --------------
 +--------------------------------------------------------------------------*/

byte            sels_map_slaves[MAX_MACHINE_NUM][13];

byte            SimpleSlave( void )
{    
    byte s_machine;
    
    s_machine = GetSlaveIndex(pMDBPerif->addr);
    
    if( SlaveForceReset )
    {
        MDBcmd( SLAVE_RESET, 1, 0xFF );     // reset
        pMDBPerif->status = SLAVE_RESET;
        SlaveForceReset = 0;
        return 0;
    }
    
    switch( pMDBPerif->status ) {
                      // attesa ACK dopo RESET
        case SLAVE_RESET:
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
                MDBcmd( SLAVE_SETUP, 1, 0xFF );      // poll
                pMDBPerif->status = SLAVE_SETUP;
/*
                MDBcmd( SLAVE_SETUP, 1+1, 0xFF );   // set-up
                pMDBPerif->cmd[1] = 1;              // enable
                pMDBPerif->status = SLAVE_SETUP;
*/            }
            else
            {
                MDBcmd( SLAVE_RESET, 1, 0xFF );     // reset
                memset( (void *)&Slave_capabilities, 0x00, sizeof( struct S_SLAME_CAPABILITIES ) );
            }
            break;

        case SLAVE_SETUP:
            if ( ans_len >= 16 )
            {
                memcpy( (void *)&Slave_capabilities, ans, sizeof( struct S_SLAME_CAPABILITIES ) );
                if ( ans_len >= 16+13 )
                {
                      memcpy( (void *)&sels_map_slaves[s_machine-1][0], &ans[16], 13 );
                }
                else
                      memset( (void *)&sels_map_slaves[s_machine-1][0], 0xFF, 13 );
                MDBcmd( SLAVE_POLL, 1, 0xFF );      // poll
                pMDBPerif->status = SLAVE_POLL;
            }
            else
            {
                MDBcmd( SLAVE_RESET, 1, 0xFF );     // reset
            }
            break;

        case SLAVE_POLL:                            // attesa al POLL
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
                if( SlaveTray != 0xFF && SlaveRow != 0xFF && pMDBPerif->addr == GetSlaveAddr(SlaveAddrOffset) )
                {
                    MDBcmd( SLAVE_SELECTION, 1+2, 0xFF );                    
                    pMDBPerif->cmd[1] = SlaveTray;
                    pMDBPerif->cmd[2] = SlaveRow;
                    pMDBPerif->status = SLAVE_SELECTION;
                    SlaveSelectionStatus[SlaveAddrOffset-1] = 0;
                    return 0;
                }
            }
            MDBcmd( SLAVE_POLL, 1, 0xFF );    // poll
            break;
                                                    // attesa risposta al SELECTION
        case SLAVE_SELECTION:
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
                MDBcmd( SLAVE_POLL, 1, 0xFF );      // poll
            }
            else if( ans_len == 2 )
            {
                SlaveSelectionStatus[s_machine-1] = ans[0];
                pMDBPerif->status = SLAVE_POLL;
                MDBcmd( SLAVE_POLL, 1, 0xFF );      // poll
            }
            else
            {
                MDBcmd( SLAVE_RESET, 1, 0xFF );     // reset
                pMDBPerif->status = SLAVE_RESET;
            }

        default:        
            break;
    }
    SlaveStatus[s_machine-1] = ( ( pMDBPerif->status < SLAVE_POLL )?0:(pMDBPerif->status) );

    return 0;
}                                               //  SimpleSlave
#endif


/*--------------------------------------------------------------------------
 | Digital Prices MDB
 |                              --------------
 | In:
 | Out: 
 +--------------------------------------------------------------------------*/
#if LED_DISPLAY_PRICE
extern word ldpBlink[6];

enum  ePriceCmd {   LDP_RESET = 0,
                    LDP_SETUP,
                    LDP_POLL,
                    LDP_PRICE,
                    LDP_TRAY,
                  };

byte            PriceDisplay( void )
{
    word        disc;
    byte        row, col, i;//, j;
    _Credito    val;

    switch( pMDBPerif->status ) {
                      // attesa ACK dopo RESET
        case LDP_RESET:
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
                MDBcmd( LDP_SETUP, 2, 0xFF );    // set-up
                pMDBPerif->cmd[1] = 100;            // brightness=100%
                pMDBPerif->status = LDP_SETUP;
            }
            else
            {
                MDBcmd( LDP_RESET, 1, 0xFF );    // reset
            }
            break;

        case LDP_SETUP:
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
                MDBcmd( LDP_POLL, 1, 0xFF );    // poll
                pMDBPerif->status = LDP_POLL;
            }
            break;

                      // attesa risposta al POLL
        case LDP_POLL:
            if ( ans_len == 1 && ans[0] == MDB_ACK )
            {
/*
                if ( lpdSendPrice( &row, &col, &val  ) == 0 )
                {
                    j = val;//(row*10 + col);
                    i = (row*10 + col)*3 + 1;
                    MDBcmd( LDP_PRICE, 1+6, 0xFF );    // 
                    pMDBPerif->cmd[1] = i++;
                    pMDBPerif->cmd[2] = ((j/100)%10)+'0';
                    pMDBPerif->cmd[3] = i++;
                    pMDBPerif->cmd[4] = ((j/ 10)%10)+'0';
                    pMDBPerif->cmd[5] = i++;
                    pMDBPerif->cmd[6] = ((j/  1)%10)+'0';
                }
                else
                    MDBcmd( LDP_POLL, 1, 0xFF );    // set-up
*/
                if ( lpdSendTray( &row ) == 0 )
                {
                    MDBcmd( LDP_TRAY, 1+1+30, 0xFF );    // 
                    pMDBPerif->cmd[1] = row + 1;
                    col = 0;
                    for ( i = 2; i < 2+30; )
                    {
                        disc = (ldpBlink[row] & (0x01<<col));
                        val = amount[0][row][col];
                        if ( disc )
                            discount_test( &val, row, col );//discount( &val, row, col );
                        pMDBPerif->cmd[i++] = (((val/100)%10)+'0')|0x80;
                        pMDBPerif->cmd[i++] =  ((val/ 10)%10)+'0';
                        pMDBPerif->cmd[i++] = (((val/  1)%10)+'0')|( disc?0x80:0x00 );
                        col++;
                    }
                }
                else
                    MDBcmd( LDP_POLL, 1, 0xFF );    // set-up
            }
            break;

        default:        
            break;
    }
    return 0;
}                                               //  PriceDisplay
#endif


/*--------------------------------------------------------------------------
 | disablePaymentSystem:verify disable condition
 |              - vending cycle
 |              - cash over max price
 |              - time disabled
 |                              --------------
 | In:
 | Out: TRUE    disable payment system
 |      FALSE   machine operative
 +--------------------------------------------------------------------------*/

byte            nSelFailed, selection_started = FALSE;
_Credito        BillEscrow;
struct S_EVENT *pEventCreditR = sEvent;

BOOL            disablePaymentSystem( void )
{
    if ( programmingMode() || vendingCycle() )
        return TRUE;
//    if ( cash >= maxPrice )
    if ( cash + BillEscrow >= maxCredit )
        return TRUE;
    if ( isTimedDisable() )
    {
        if ( (cash + card + BillEscrow) == 0 )
        {                               // disable only if credit 0
            Cashless[0].CmdEnable = 0;
            Cashless[1].CmdEnable = 0;
        }
        return TRUE;
    }
    else
    {                                   // immediatly enable cashless
        Cashless[0].CmdEnable = 1;
        Cashless[1].CmdEnable = 1;
    }

    return FALSE;
}                                               // disablePaymentSystem()


/*--------------------------------------------------------------------------
 | defineCurrency:define the currecny used by the machine
 |              - teking the currencies from Coin change giver
 |              - in Coin change giver not present, bill is used 
 |              - if bill is missing, cashless is used
 |              - if no payment, use last currecny value
 |                              --------------
 | In:
 | Out: cuccency code
 |   
 +--------------------------------------------------------------------------*/
unsigned short machineCurrency = 0;
char currencyString[3];

void defineCurrency( void )
{
  if( Change.Setup.Country_Currency_Code )
  {
      machineCurrency = Change.Setup.Country_Currency_Code;
  }
  else if( Bill.Setup.Country_Currency_Code )
  {
      machineCurrency = Bill.Setup.Country_Currency_Code;
  }
  else if(  Cashless[0].Setup.Country_Currency_Code )
  {
      machineCurrency = Cashless[0].Setup.Country_Currency_Code;
  }
  else if(  Cashless[1].Setup.Country_Currency_Code )
  {
      machineCurrency = Cashless[1].Setup.Country_Currency_Code;
  }
  else if(  Cashless[2].Setup.Country_Currency_Code )
  {
      machineCurrency = Cashless[2].Setup.Country_Currency_Code;
  }
  switch( machineCurrency )
  {
      case 0x1978 : 
      case 0x0039 : currencyString[0] = 0x04; currencyString[1] = 0; break;  // EURO
      case 0x1826 : 
      case 0x0044 : currencyString[0] = 0x03; currencyString[1] = 0; break;  // Pound
      default:      currencyString[0] = '$';  currencyString[1] = 0; break;  // default $
  }
  
}                                               // defineCurrency()

/*
    Credit handling
    Will check event list to update credit value
    Will handle payment systems
    - coins enabled, bills enabled, cashless enabled
*/

void            startCredit( void )
{
    cash = 0;
    BillEscrow = 0;
    card = 0;
    nSelFailed = 0;
    token = 0;
}

_Credito        Credit( void )
{
static _Credito askResto = 0;

    byte        i;
    word        tw;
    _Credito    tv, total;


    if( cash & 0x80000000 ) cash = 0;
    
    defineCurrency( );
    
    // reset Cashless command after being executed
    if ( pCashlessCmd != NULL && pCashlessCmd->cmd == CASHLESS_CMD_REVALUE )
    {
        if ( pCashlessCmd->response == 0 )
        {
            card += pCashlessCmd->val;
            pCashlessCmd = NULL;
        }
        else if ( pCashlessCmd->response == -1 )// attenzione pCashlessCmd potrebbe essere NULL dall'istruzione precedente
        {
            cash += pCashlessCmd->val;  // revalue fallito, recupera credito
            pCashlessCmd = NULL;
        }
    }
    if ( pCashlessCmd != NULL &&
       ( pCashlessCmd->cmd == CASHLESS_CMD_VEND_FAIL || 
         pCashlessCmd->cmd == CASHLESS_CMD_VEND_OK || 
         pCashlessCmd->cmd == CASHLESS_CMD_SESSION_COMPLETE ) &&
         pCashlessCmd->response != 1 && pCashlessCmd->response != 2 )
        pCashlessCmd = NULL;


    // reset Changer command after being executed
    if ( pChangerCmd != NULL && pChangerCmd->response != 1 && pChangerCmd->response != 2 )
        pChangerCmd = NULL;

    // handle events to upate available credir
    while ( pEventCreditR != pEventW )
    {
        switch ( pEventCreditR->event )
        {
            case EVENT_TOKEN_ESCROW:
                BillEscrow = ID_TOKEN;
            case EVENT_TOKEN_IN_TUBE:
            case EVENT_TOKEN_IN_CASHBOX:
            case EVENT_TOKEN_IN:
                token = ID_TOKEN;                           // free vend token
                break;
                
            case EVENT_BILL_ESCROW:
                BillEscrow = pEventCreditR->val;
                lampOn();
                if ( Cashless[cashless_idx].State == CASHLESS_STATE_IDLE && pCashlessCmd == NULL )            // revalue
                goto CARD_REVALUE;
                
//                if ( NonVolatileSetup.setEscrow == 2 && BillEscrow && ( cash + BillEscrow ) < maxPrice )
                if ( NonVolatileSetup.setEscrow == 2 && BillEscrow && ( cash + BillEscrow ) < maxCredit )
                {                                                         // last-escrow function enabled
                    BillCmd.cmd = BILL_CMD_ESCROW;
                    BillCmd.val = 1;
                    BillCmd.response = 1;
                    pBillCmd = &BillCmd;
                    BillEscrow = 0;
                }

                break;

            case EVENT_COIN_IN_TUBE:
                if( doorOpen() && NonVolatileSetup.setFillTube != 0x68 )    // manual fill tubes
                    break;
            case EVENT_COIN_IN_CASHBOX:
            case EVENT_BILL_IN:
            case EVENT_BILL_RECYCLE:
                lampOn();
                cash += pEventCreditR->val;
                if ( Cashless[cashless_idx].State == CASHLESS_STATE_IDLE && pCashlessCmd == NULL )            // revalue
                    goto CARD_REVALUE;
                break;

            case EVENT_COIN_OUT:
                if ( cash >= pEventCreditR->val )
                    cash -= pEventCreditR->val;
                break;

            case EVENT_BILL_OUT:
                if( BillEscrow )              // DEBUG : verificare se funziona !!
                    BillEscrow = 0;
                else if ( cash >= pEventCreditR->val )
                    cash -= pEventCreditR->val;
                break;
                
            case EVENT_COIN_PAYOUT:
                cash += askResto;
                askResto = 0;
                if ( cash >= pEventCreditR->val )
                    cash -= pEventCreditR->val;
                break;

            case EVENT_CARD_IN:
                card = pEventCreditR->val;    // DEBUG se ci sono 2 cashless cosa succede
                break;

            case EVENT_CARD_REVALUE_LIMIT:
                CARD_REVALUE:
                if ( BillEscrow != 0 && BillEscrow < Cashless[cashless_idx].revalue_limit )
                  {
                // prima debbo mandare la banconota in stack ( se in escrow )
                // poi posso accreditare ( avverra' poi sull'event di BILL_IN
                    BillCmd.cmd = BILL_CMD_ESCROW;
                    BillCmd.val = 1;
                    BillCmd.response = 1;
                    pBillCmd = &BillCmd;
                    BillEscrow = 0;
                    break;
                }
                lampOn();
                if ( pCashlessCmd == NULL && cash != 0 && Cashless[cashless_idx].revalue_limit != 0 )   // revalue
                {
                    pCashlessCmd = &CashlessCmd;
                    pCashlessCmd->cmd = CASHLESS_CMD_REVALUE;
                    if ( cash < Cashless[cashless_idx].revalue_limit )
                    {
                        pCashlessCmd->val = cash;
                        Cashless[cashless_idx].revalue_limit -= cash;
                        cash = 0;                        
                    }
                    else
                    {

                        pCashlessCmd->val = Cashless[cashless_idx].revalue_limit;
                        cash -= Cashless[cashless_idx].revalue_limit;
                        Cashless[cashless_idx].revalue_limit = 0;                        
                    }
                    pCashlessCmd->response = 1;
                }
                break;

            case EVENT_CARD_OUT:
                card = 0;   // DEBUG se ci sono 2 cashless cosa succede
                break;

            case EVENT_SELECTION_START:
                break;

            case EVENT_SELECTION_FAILED:
/* e-mail 24.08.2007
                if ( ++nSelFailed >= MAX_SEL_FAILED )
                    nSelFailed = 0;
                else
                { */
                  if ( pCashlessCmd != NULL )
                  {
                      pCashlessCmd->cmd = CASHLESS_CMD_VEND_FAIL;
                      pCashlessCmd->val = 0xFFFF;
                      pCashlessCmd->response = 1;
                    // debug : deve essere analizzato il caso in cui NON sia possibile il riaccredito per vendita fallita
                      card += SelectionData.payedCashless1;
                      card += SelectionData.payedCashless2;
                    // debug : eventuale gestione cashless2
                  }
                  cash += SelectionData.payedCash;
                  // resto erogato ( single vend )
                  if ( NonVolatileSetup.setSingleVend != 0 )
                      goto gESCROW;
//              }
                break;

            case EVENT_SELECTION_OK:
                nSelFailed = 0;
                if ( pCashlessCmd != NULL )
                {                       // cashless system cashless vend
                    pCashlessCmd->cmd = CASHLESS_CMD_VEND_OK;
                    pCashlessCmd->val = (((word)SelectionData.tray)<<8) + (word)SelectionData.column;
                    pCashlessCmd->response = 1;
                }
                else if ( pCashless->Setup.Options.vend_cash_cmd )
                {                       // cashless system cash vend
                    pCashlessCmd = &CashlessCmd;
                    pCashlessCmd->cmd = CASHLESS_CMD_CASH_VEND;
                    pCashlessCmd->val = SelectionData.payedCash;
                    pCashlessCmd->param = (((word)SelectionData.tray)<<8) + (word)SelectionData.column;
                    pCashlessCmd->response = 1;
                }
                // resto erogato ( single vend )
                if ( NonVolatileSetup.setSingleVend != 0 )
                    goto gESCROW;
                break;

            case EVENT_FORCE_ESCROW:
            case EVENT_ESCROW:
                if ( pChangerCmd != NULL )
                    break;
gESCROW:        if ( NonVolatileSetup.setForceVend == 0x69 && selection_started != TRUE && pEventCreditR->event != EVENT_FORCE_ESCROW )
                    break;              // escrow disabilitato in caso di "force vend" tranne se:
                                        // - restituzione monete dopo selezione avvenuta
                                        // - in exact change, selezione impossibile, restituzione monete
                                        // disable escrow if cash has been assigned for a selection waiting authorization
                if( SelectionData.askCash != 0 )
                    break;
                                        // disable escrow during vend cycle
                if ( vendingCycle() && pEventCreditR->event == EVENT_ESCROW )
                    break;
                                
                if ( Cashless[cashless_idx].State == CASHLESS_STATE_IDLE && pCashlessCmd == NULL )
                {
                    CashlessCmd.cmd = CASHLESS_CMD_SESSION_COMPLETE;
                    CashlessCmd.response = 1;
                    pCashlessCmd = &CashlessCmd;
                    // debug : eventuale gestione cashless2
                }

                if ( BillEscrow )
                {
                    BillCmd.cmd = BILL_CMD_ESCROW;
                    BillCmd.val = 0;      // return bill
                    BillCmd.response = 1;
                    pBillCmd = &BillCmd;
                    BillEscrow = 0;
                    token = 0;            // toglie free vend
                }
                else if ( cash != 0 && ( BillCmd.val = BillRecycleResto( cash )) != 0 )
                {
                    BillCmd.cmd = BILL_CMD_PAYOUT;
                    BillCmd.response = 1;
                    pBillCmd = &BillCmd;
                    token = 0;            // toglie free ven
                    if (cash >= BillCmd.val)
                        cash -= BillCmd.val;
                    else
                        cash = 0;
                }
                
                if ( cash != 0 )
                {
                    ChangerCmd.cmd = CHANGER_CMD_PAYOUT;
                    ChangerCmd.val = cash;    // DEBUG in cash va immediatamente reso indisponibile, per essere poi riaccreditato se non reso
                                              // DEBUG qui aggiungere le regole di payout, es max payout etc...
                    ChangerCmd.response = 1;  // payout is running
                    pChangerCmd = &ChangerCmd;
                    
                    askResto = cash;
                    cash = 0;
                    InsertEvent( EVENT_ASK_CHANGE, askResto );
                }
                break;

            default:
                break;
        }
        
        switch ( pEventCreditR->event )
        {
            case EVENT_SELECTION_START:
            case EVENT_SELECTION_OK:
            case EVENT_SELECTION_FAILED:
                selection_started = TRUE;
                SelectionData.askCash = 0;
                break;
                
            case EVENT_ESCROW:
                break;

            default:
                selection_started = FALSE;
                break;
        }

        pEventCreditR->credit = cash;
        
        if ( ++pEventCreditR >= &sEvent[16] )   pEventCreditR = sEvent;
    }                                   // end handle events to upate available credir
    
    total = cash + card + BillEscrow;   // total available credit
                                        ///////////////////////////////////////
                                        // check for payment system valid
    if ( disablePaymentSystem() )
    {
        Bill.Cmd.Bill_Enable = 0x0000;
        Change.Cmd.Coin_Enable = 0x0000;
        Bill_Micromech.BillEnable = 0x0000;
        billParallel.Cmd.Bill_Enable = 0x0000;
    }
    else
    {
                                        ///////////////////////////////////////
                                        // set Bill enable mode
        tw = 0;
        tv = ChangeTubeValue() + BillRecycleValue();
          // cash potrebbe essere maggiore del contenuto dei tubi poiche' le gettoniere indicano spesso il numero
          // di monete di cui sono certe, che puo' essere inferiore a quelle entrare, oppure perche' alcune monete
          // sono andate in cassa. In ogni caso quello che posso restiture in nuove banconote e' quello che resta dopo
          // aver reso il cash presente
          // free_vend_token ( if present ) is always enabled
          // il lettore banconote MARS AE2602U3 non accetta i free token quando disabilitata la banconota da 1 dollaro
        if ( tv < cash ) tv = 0; else tv -= cash;
        
        if ( ChangerExactChange() )
        {
            for ( i = 0; i < 16; i++ )    // if YES exact change set max bill to "highest vend price" or go to recycle
            {
                if ( ( Bill.Setup.Bill_Type_Credit[i] != 0 &&
                       Bill.Setup.Bill_Type_Credit[i] <= tv &&
//                       ( Bill.Setup.Bill_Type_Credit[i]+total) <= maxPrice )  ||
                       ( Bill.Setup.Bill_Type_Credit[i]+total) <= maxCredit )  ||
                     ( Bill.Recycle.Bill_Recycle_Enabled[i] != 0 &&
                       ( Bill.Recycle.Bill_Type_routing & ( 1 << i ) ) != 0 &&
                       ( Bill.Setup.Bill_Type_Credit[i]+total) <= maxCredit ) ||
                     Bill.Setup.Bill_Type_Credit[i] == ID_TOKEN )
                    tw |= ( 1 << i );
            }
            Bill_Micromech.BillEnable = 0x0000;
        }
        else
        {
          for ( i = 0; i < 16; i++ )    // if NO exact change set max bill to available change or go to recycle
            {
                if ( ( Bill.Setup.Bill_Type_Credit[i] != 0 &&
                       Bill.Setup.Bill_Type_Credit[i] <= tv )  ||
                    
                    ( Bill.Setup.Bill_Type_Credit[i] != 0 &&
                       Bill.Setup.Bill_Type_Credit[i] <= maxBills )  ||
                      
                     ( Bill.Recycle.Bill_Recycle_Enabled[i] != 0 &&
                       ( Bill.Recycle.Bill_Type_routing & ( 1 << i ) ) != 0 &&
                       ( Bill.Setup.Bill_Type_Credit[i]+total) <= maxCredit ) ||
                       
                       Bill.Setup.Bill_Type_Credit[i] == ID_TOKEN )
                    tw |= ( 1 << i );
            }
            if ( 100 <= tv )
                Bill_Micromech.BillEnable = 0x0001;
            else
                Bill_Micromech.BillEnable = 0x0000;
        }
        
        for ( i = 0; i < 16; i++ )    // if cashless available, set max bill to revelue limit (( DEBUG : IF BILLRECYCLE available ?? ))
        {
            if ( Bill.Setup.Bill_Type_Credit[i] != 0 &&
                 Bill.Setup.Bill_Type_Credit[i] <= Cashless[cashless_idx].revalue_limit )
                tw |= ( 1 << i );
        }
        Bill.Cmd.Bill_Enable = tw;
        billParallel.Cmd.Bill_Enable = Bill_Micromech.BillEnable;
                                        // set escrow mode
        if ( Bill.Setup.Escrow == 0 || (NonVolatileSetup.setEscrow == 0 && !ChangerExactChange()) )
            Bill.Cmd.Bill_Escrow_Enable = 0;
        else
            Bill.Cmd.Bill_Escrow_Enable = Bill.Cmd.Bill_Enable;
        if ( billParallel.Escrow == 0 || (NonVolatileSetup.setEscrow == 0 && !ChangerExactChange()) )
            billParallel.Cmd.Bill_Escrow_Enable = 0;
        else
            billParallel.Cmd.Bill_Escrow_Enable = billParallel.Cmd.Bill_Enable;

                                        ///////////////////////////////////////
                                        // set coin enable mode
        
                                        // - token always enabled
                                        // - in tube fill mode, all coins enabled
        tw = 0xFFFF;
        if ( ChangerExactChange() )     // if YES exact change :  - disable coins non routed to tubes
        {                               //                        - disable coins if higher than max price
            if( !(doorOpen() && NonVolatileSetup.setFillTube != 0x68) )
            {
                for ( i = 0; i < 16; i++ )
                {
                    if ( Change.Setup.Coin_Type_Credit[i] == ID_TOKEN )
                        continue;
                    if ( (Change.Setup.Coin_Type_Routing & (1 << i)) == 0 ||
//                         (Change.Setup.Coin_Type_Credit[i]+total) > maxPrice
                         (Change.Setup.Coin_Type_Credit[i]+total) > maxCredit
                       )
                        tw &= ~( 1 << i );
                }
            }
        }
        else
        {                                 // if NO exact change set max coin accepted to available change
            for ( i = 0; i < 16; i++ )
            {
                    if ( Change.Setup.Coin_Type_Credit[i] == ID_TOKEN )
                        continue;
                    if ( (Change.Setup.Coin_Type_Routing & (1 << i)) == 0 &&
                     (Change.Setup.Coin_Type_Credit[i] > tv )
                   )
                    tw &= ~( 1 << i );
            }
        }
                  
        for ( i = 0; i < 16; i++ )        // if cashless available, set max coin to revelue limit
        {
            if ( Change.Setup.Coin_Type_Credit[i] != 0 &&
                 Change.Setup.Coin_Type_Credit[i] <= Cashless[cashless_idx].revalue_limit )                
                tw |= ( 1 << i );
        }

        Change.Cmd.Coin_Enable = tw;
    }


    if ( token )
        return ID_TOKEN;
    else
        return total;
}                                               //  Credit

/*
    pay_selection_start : test if enought credit available to make selection, cash available escrow bills
    IN :  _Credito tot    : selection selling price
        byte tray, byte column : selection column/row
    OUT : _
*/
dword WinnerModeCount = 0;

void  pay_selection_start( _Credito tot, byte machine, byte tray, byte column )
{
    DEBUG_MDB_EXTRA(0xFE);
    DEBUG_MDB_EXTRA(0xFE);
    DEBUG_MDB_EXTRA(tot);
   
//    SelectionData.price = tot;  see main.c, will use the given selection price
    SelectionData.machine = machine;
    SelectionData.tray = tray;
    SelectionData.column = column;
    SelectionData.payedCashless1= 0; SelectionData.payedCashless2 = 0; SelectionData.payedCash = 0;
    SelectionData.askCash = 0; SelectionData.askCashless1 = 0; SelectionData.askCashless2 = 0;
    SelectionData.ExactChange = ChangerExactChange();
    
    if( NonVolatileSetup.WinValue >= 50 )
    {
        if( WinnerModeCount >= NonVolatileSetup.WinValue )
        {            
            pCashlessCmd = NULL;
            return;
        }
    }
    else
        WinnerModeCount = 0;
    
    if( token == ID_TOKEN )
    {
        if( BillEscrow )                // se e' un FREE VEND TOKEN che ' andato in escrow, lo incamero
        {
            BillCmd.cmd = BILL_CMD_ESCROW;
            BillCmd.val = 1;
            BillCmd.response = 1;
            pBillCmd = &BillCmd;
            BillEscrow = 0;
        }
        SelectionData.FreeVendTokenUsed = 1;
        return;                         // free vend tokem, abilita qualsiasi selezione
    }
    SelectionData.FreeVendTokenUsed = 0;
                                        // in exact change e cash > valore, non accetta selezione e
                                        // restituisce i soldi (probabile mancanza di resto)
//9.0.Z    if ( SelectionData.ExactChange && (cash+BillEscrow) != tot ) // sostituito >
//N.0.Z    if ( SelectionData.ExactChange && (cash+BillEscrow) != tot && (cash+card+BillEscrow) < tot ) // sostituito >
//7.5.F    if ( SelectionData.ExactChange && (cash+BillEscrow) != tot && (card+BillEscrow) < tot ) // sostituito >
    if ( SelectionData.ExactChange && (card != 0 || (cash+BillEscrow) != tot) && (card+BillEscrow) < tot )
        return;                         // v. sotto per la gestione dell'escrow delle monete
#if 0
    // 11.08.2010 : do not cash bill here, wait to be sure the selection CAN be made
    if( BillEscrow )
    {
        BillCmd.cmd = BILL_CMD_ESCROW;
        BillCmd.val = 1;    // stack bill
        BillCmd.response = 1;
        pBillCmd = &BillCmd;
        BillEscrow = 0;
    }
#endif
    if( ( cash + BillEscrow ) < tot &&
        Cashless[cashless_idx].State == CASHLESS_STATE_IDLE )       
    {
        CashlessCmd.cmd = CASHLESS_CMD_VEND;
        CashlessCmd.val = tot - ( cash + BillEscrow );
        CashlessCmd.response = 1;
        pCashlessCmd = &CashlessCmd;
        SelectionData.askCash = ( cash + BillEscrow );
        if ( cashless_idx == 1 )
        {
          SelectionData.askCashless1 = 0;
          SelectionData.askCashless2 = tot - ( cash + BillEscrow ); 
        }
        else
        {
          SelectionData.askCashless1 = tot - ( cash + BillEscrow ); 
          SelectionData.askCashless2 = 0;
        }
    }
    else                   // abbastanza contante per pagare DEBUG in lacuni casi bisogna chiedere IN OGNI CASO al cashless autorizzazione (es. age verification )
    {                      //  ma potrebbe generare problemi con sisemi a carta di credito, che a seguito dell richiesta potrebbero aprire un credito on line
        SelectionData.askCash = tot; SelectionData.askCashless1 = 0; SelectionData.askCashless2 = 0;
        pCashlessCmd = NULL;
    }
}

/*
    Avendo deciso di incamerare una banconota presente in ESCROW, attendo la fine della procedura
    di stacking prima di dare OK alla selezione.
*/
static byte do_escrow( void )
{
    if( pBillCmd != NULL && pBillCmd->cmd == BILL_CMD_ESCROW )
    {
        if( pBillCmd->response == -1 ) // fail
        {
            pBillCmd = NULL;
            return(1);
        }
        if( pBillCmd->response != 0 ) // ok
            return( 0xFF );                 // wait
        pBillCmd = NULL;
    }
    return 0;
}

byte  pay_selection( _Credito *tot )
{
    byte    resp;
    
    if( NonVolatileSetup.WinValue >= 50 && WinnerModeCount >= NonVolatileSetup.WinValue )
    {
        WinnerModeCount = 0;
        InsertEvent( EVENT_SELECTION_WIN, *tot );
        SelectionData.payedCash = 0;
        SelectionData.askCash = 0;
        InsertEvent( EVENT_FORCE_ESCROW, 0 );
        return(0);
    }

    if ( SelectionData.FreeVendTokenUsed )
    {
        if( BillEscrow )    // 12.08.2010 cash bill ( in this case is a VEND-TOKEN 
        {
            BillCmd.cmd = BILL_CMD_ESCROW;
            BillCmd.val = 1;    // stack bill
            BillCmd.response = 1;
            pBillCmd = &BillCmd;
            BillEscrow = 0;
        }
        token = 0;
        if( ( resp = do_escrow()) == 0 ){
          WinnerModeCount++;  // count made selections
          SelectionData.askCash = 0;
        }
        return resp;
    }

    if ( (resp=do_escrow()) != 0 )
        return resp;
                                  // v. sopra, probabile mancanza di resto, non accetta selezione
//9.0.Z    if ( SelectionData.ExactChange && (cash+BillEscrow) != *tot ) // sostituito >
//    resp = 1;
//    if ( Cashless[0].State == CASHLESS_STATE_IDLE && card > *tot )
//        resp = 0;
//    if ( SelectionData.ExactChange && (cash+BillEscrow) != *tot && resp ) // sostituito >
//N.0.Z    if ( SelectionData.ExactChange && (cash+BillEscrow) != *tot && (cash+card+BillEscrow) < *tot ) // sostituito >
//7.5.F    if ( SelectionData.ExactChange && (cash+BillEscrow) != *tot && (card+BillEscrow) < *tot ) // sostituito >
    if ( SelectionData.ExactChange && (card != 0 || (cash+BillEscrow) != *tot) && (card+BillEscrow) < *tot )    
    {
        InsertEvent( EVENT_FORCE_ESCROW, 0 );
        SelectionData.askCash = 0;
        return 1;
    }

    if( pCashlessCmd != NULL && pCashlessCmd->cmd == CASHLESS_CMD_VEND)
    {
      if( pCashlessCmd->response == -1 ) // fail
      {
        pCashlessCmd = NULL;
        return(1);
      }
      if( pCashlessCmd->response == 0 ) // ok
      {
        *tot = pCashlessCmd->val;       // selection value from cashless
        if( *tot <= card ) card -= *tot; else card = 0;
        if ( cashless_idx == 1 )
        {
            SelectionData.payedCashless1 = 0;SelectionData.payedCashless2= pCashlessCmd->val; 
        }
        else
        {
            SelectionData.payedCashless1= pCashlessCmd->val; SelectionData.payedCashless2 = 0;
        }
        SelectionData.payedCash = SelectionData.askCash; SelectionData.askCash = 0;
        if (cash >= SelectionData.payedCash) 
            cash -= SelectionData.payedCash;  // vedi pay_selection_start, il cash viene consumato prima del cashless
        else
            cash = 0;
        WinnerModeCount++;

        if( BillEscrow )    // 12.08.2010 cash bill
        {
            BillCmd.cmd = BILL_CMD_ESCROW;
            BillCmd.val = 1;    // stack bill
            BillCmd.response = 1;
            pBillCmd = &BillCmd;
            BillEscrow = 0;
            return( 0xFF );
        }

        return(0);
      }
      return( 0xFF );                   // wait
    }
    else if( pChangerCmd == NULL && ( cash + BillEscrow ) >= *tot ) // abbastanza contante per pagare DEBUG in lacuni casi bisogna chiedere IN OGNI CASO al cashless autorizzazione (es. age verification )
    {
      if( BillEscrow )    // 12.08.2010 cash bill
      {
          BillCmd.cmd = BILL_CMD_ESCROW;
          BillCmd.val = 1;    // stack bill
          BillCmd.response = 1;
          pBillCmd = &BillCmd;
          BillEscrow = 0;
          return( 0xFF );               // wait till bancknote is cashed in
      }
      SelectionData.payedCash = *tot;
      if (cash >= *tot) 
        cash -= *tot;
      else
        cash = 0;
      SelectionData.askCash = 0;
      pCashlessCmd = NULL;
      WinnerModeCount++;
      return(0);                        // ok, cash pay
    }
    SelectionData.askCash = 0;
    return(1);                          // ko
}




#if NODE_IDENTIFIER

/****************************************************************************
 spegnimentoControllato:toglie alimentazione ed attende che la scheda si
                spenga oppure se dopo 5 secondi si preme un tasto, riaccende
                la scheda ed esegue un jump al vettore di reset
                                --------------
 In:
 Out:
***************/

char			zigBee_send( byte _ch, byte *_cmd, DWORD _to )
{
    byte        ch, i, buf[8];
    DWORD       t;

    countDown = _to;
    while ( *_cmd != '\0' )
        commPutChar( _ch, *_cmd++ );

    i = 0;
	t = GetTickCount();
	while( (GetTickCount()-t) < _to ) {
        if( commGetChar( _ch, &ch ) == COMM_RX_EMPTY )
            Delay(10);
        else
            buf[i++] = ch;
        if ( i >= 3 && buf[i-3] == 'O' && buf[i-2] == 'K' && buf[i-1] == '\r' )
            return 0;
        if ( ch == '\r' || ch == '\n' || i >= sizeof(buf) )
            i = 0;
	}
	return 1;
}

byte            zigBee_commandMode( byte _ch )
{
    byte        retry;
    
    for ( retry = 3; retry > 0; retry-- )
    {
        Delay(1500);
    
        if ( zigBee_send( _ch, "+++", 1500 ) == 0 )
            return 0;
        if ( zigBee_send( _ch, "AT\r", 500 ) == 0 )
            return 0;
    }
    return 1;
}

byte            zigBee_normalMode( byte _ch )
{
    if ( zigBee_send( _ch, "ATWR\r", 500 ) != 0 )
        return 1;
    if ( zigBee_send( _ch, "ATCN\r", 500 ) != 0 )
        return 2;
    return 0;
}

byte            zigBee_NI( byte *_assetID )
{
    byte        wrcmd[32], *p;
    
    testMode = 0x47681022;
    DispStr( 0, 0, (char *)MSG_ATTESA );
    if ( zigBee_commandMode(COMM2) != 0 )
    {
        testMode = 0;
        return 1;
    }

    strcpy( (char *)wrcmd, "ATNI" );
    strncat( (char *)wrcmd, (char*)_assetID, sizeof(wrcmd)-6 );
    p = &wrcmd[sizeof(wrcmd)-2];
    *p-- = '\0';
    while ( *p == ' ' )
        *p-- = '\0';
    strcat( (char *)wrcmd, "\r" );

    if ( zigBee_send( COMM2, wrcmd, 500 ) != 0 )
    {
        testMode = 0;
        return 2;
    }
    
    if ( zigBee_normalMode(COMM2) != 0 )
    {
        testMode = 0;
        return 3;
    }
    
    testMode = 0;
    return 0;
}                                               //  zigBee_NI

#endif

#if MDB_DEBUG 
void        debuggaTutto( void )
{
    if ( pMDBPerif->addr == 0x60 )
        return;
    
        DEBUG_MDB_EXTRA(0xFF);
        DEBUG_MDB_EXTRA(pMDBPerif->addr);
        DEBUG_MDB_EXTRA(pMDBPerif->status);
        DEBUG_MDB_EXTRA(pMDBPerif->cmd_len);

        if ( pMDBPerif->addr == 0x08 )
        {
            if ( pChangerCmd == NULL )
            {
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
            }
            else
            {
                DEBUG_MDB_EXTRA( *(((byte *)pChangerCmd)+0) );
                DEBUG_MDB_EXTRA( *(((byte *)pChangerCmd)+2) );
                DEBUG_MDB_EXTRA( *(((byte *)pChangerCmd)+3) );
            }
        }
        else if ( pMDBPerif->addr == 0x10 )
        {
            if ( pCashlessCmd == NULL )
            {
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
            }
            else
            {
                DEBUG_MDB_EXTRA( *(((byte *)pCashlessCmd)+0) );
                DEBUG_MDB_EXTRA( *(((byte *)pCashlessCmd)+2) );
                DEBUG_MDB_EXTRA( *(((byte *)pCashlessCmd)+3) );
            }
        }
        else if ( pMDBPerif->addr == 0x30 )
        {
            if ( pBillCmd == NULL )
            {
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
                DEBUG_MDB_EXTRA(0);
            }
            else
            {
                DEBUG_MDB_EXTRA( *(((byte *)pBillCmd)+0) );
                DEBUG_MDB_EXTRA( *(((byte *)pBillCmd)+2) );
                DEBUG_MDB_EXTRA( *(((byte *)pBillCmd)+3) );
            }
        }
        else
        {
            DEBUG_MDB_EXTRA(0);
            DEBUG_MDB_EXTRA(0);
            DEBUG_MDB_EXTRA(0);
        }
}
#endif

#if RSR903_MDB
static  byte MDBSlaveCheck( char _comm, byte *slv_ans )
{
    byte slv_ans_len, slv_crc, *slv_pCh;

    if( !MDB_started )
        return( 0 );

    if( commIbuf[_comm].flag == 0 )     // attesa risposta di qualsiasi genere
      return( 0 );

    if( ( commIbuf[_comm].flag & 0x60 ) != 0 &&  // scaduto t-response
          commIsEmpty(_comm) )                   // senza nessun carattere nel buffer ( timer3 potrebbe essere servito prima di IRQ_UART2 perche' piu' prioritario )
    {
      return( 0 );
    }
    else
    {
      // check CRC, length
      slv_ans_len = 0; slv_crc = 0; slv_pCh = slv_ans;
      while( commGetChar( _comm, slv_pCh) != COMM_RX_EMPTY )
      {
        if ( (slv_ans_len+1) < MAX_MDB_FRAME ) 
        {
          slv_crc += *slv_pCh++;
          slv_ans_len++;
        }
      }
      --slv_pCh;
      slv_crc -= (*slv_pCh*2);                // verifica CRC
    }
    // attende risposta
    commIbuf[_comm].flag = 0;
    if( slv_crc == 0 ) return slv_ans_len;
    return 0;
}
#endif
#if RSR903
/*--------------------------------------------------------------------------
 |  MDBSlave :  emulate a simple cashless payment system.
 |                              --------------
 |  Used to emulate a cashless payment system to control the selection status
 |  As soon as the selection has to be started by the host VMC, the CASHLESS_VEND
 |  command is received and asknowledged. When this command is received, a 
 |  selection timeout is started on main.c; when the selection ends one
 |  of the commands CASHLESS_VEND_FAILURE, CASHLESS_VEND_CANCEL, CASHLESS_VEND_SUCCESS
 |  is received.
 +--------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------
   FROM BEVMAX operation, track ( no timing )
0x10 0x10 >> Poll

0x11 0x00 0x02 0x00 0x00 0x00 0x00 0x13 0x00 0x11 0x01 0x00 0x64 0x00 0x64 0xDA  >> SETUP

0x17 0x00 0x44 0x4e 0x43 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x44 0x4E 0x02 0x35 0x38
0x30 0x30 0x2d 0x34 0x00 0x00 0x00 0x7 0x04 0x40 0x00  >> Expansion ID

0x14 0x01 0x15 >> Enable

0x10 0x10 >> Poll

0x13 0x00 0x00 0x64 0x00 0x01 0x78 0x00 >>VEND
( after the VEND command Bevmax will not send any command to cashless till the end of the VEND )
0x13 0x02 0x00 0x0A 0x1F  >> VEND SUCCESS
( after the VEND SUCCESS command Bevmax will not send any command to cashless till the end of the SESSUON CONPLETE )
0x13 0x04 0x17 >> SESSION COMPLETE

0x10 0x10 >> Poll

0x14 0x00 0x14 >> Disable

and immediately an Enable command is sent and cycle restat on the Enable command 
 --------------------------------------------------------------------------*/
/*  THESE STATUS ARE THE UCB CASHLESS STATUS DEFINITIONS
enum  eCasStatus {  CASHLESS_RESET=0,
                    CASHLESS_SETUP,
                    CASHLESS_POLL,
                    CASHLESS_VEND = 0x0003,
                    CASHLESS_VEND_CANCEL = 0x0103,
                    CASHLESS_VEND_SUCCESS = 0x0203,
                    CASHLESS_VEND_FAILURE = 0x0303,
                    CASHLESS_SESSION_COMPLETE = 0x0403,
                    CASHLESS_CASH_SALES = 0x0503,
                    CASHLESS_NEGATIVE_VEND = 0x0603,
                    CASHLESS_DISABLE = 0x0004,
                    CASHLESS_ENABLE = 0x0104,
                    CASHLESS_CANCEL = 0x0204,
                    CASHLESS_DATA_ENTRY_RESP = 0x0304,
                    CASHLESS_REVALUE = 0x0005,
                    CASHLESS_REVALUE_LIMIT_REQ = 0x0105,
                    CASHLESS_EXPANSION_ID = 0x0007,
                    CASHLESS_EXPANSION_READ_FILE = 0x0107,
                    CASHLESS_EXPANSION_WRITE_FILE = 0x0207,
                    CASHLESS_EXPANSION_WRITE_DATE = 0x0307,
                    CASHLESS_EXPANSION_FEATURES_ENABLE = 0x0407,
                    CASHLESS_SET_MAXMIN = 0x0101
                  };

enum  eCasPoll  { CASHLESS_JUST_RESET = 0,
                  CASHLESS_READER_CONFIG_DATA,
                  CASHLESS_DISPLAY_REQUEST,
                  CASHLESS_BEGIN_SESSION,
                  CASHLESS_SESSION_CANCEL_REQUEST,
                  CASHLESS_VEND_APPROVED,
                  CASHLESS_VEND_DENIED,
                  CASHLESS_END_SESSION,
                  CASHLESS_CANCELLED,
                  CASHLESS_PERIPHERAL_ID,
                  CASHLESS_ERROR,
                  CASHLESS_OUT_SEQUENCE,
                  CASHLESS_REVALUE_APPROVED = 0x0D,
                  CASHLESS_REVALUE_DENIED,
                  CASHLESS_REVALUE_LIMIT,
                  CASHLESS_USER_FILE_DATA,
                  CASHLESS_TIME_DATE_REQUEST,
                  CASHLESS_DATA_ENTRY_REQUEST,
                  CASHLESS_DATA_ENTRY_CANCEL,
                  CASHLESS_DIAGNOSTIC = 0xFF
                };

enum  eCasStateMachine {
                  CASHLESS_STATE_NOT_PRESENT = 0,
                  CASHLESS_STATE_INACTIVE,          // after a reset
                  CASHLESS_STATE_DISABLED,          // after SETUP or CASHLESS_DISABLE
                  CASHLESS_STATE_ENABLED,           // after CASHLESS_ENABLE
                  CASHLESS_STATE_IDLE,              // ENABLED with a valid paymen media inserted
                  CASHLESS_STATE_VEND,              // after a VEND_REQUEST
                  CASHLESS_STATE_REVALUE,
                  CASHLESS_STATE_NEGATIVE_VEND,
                  CASHLESS_STATE_SINGLE_POLL
               };
*/

dword validFrame = 0;
byte  Slave_Cashless_Status = CASHLESS_STATE_NOT_PRESENT;
byte  crc;
byte  MDBSlavePoll = 0;
byte  SlaveSelection = 0;
_Credito price = 0;

static  void MDBSlaveSend( char ch )
{
    _commPutChar( COMM4, ch );
    crc += ch;
}

void    MDBSlave( void ) 
{
    byte slv_ans_len, slv_ans[MAX_MDB_FRAME];

    if( ( slv_ans_len = MDBSlaveCheck( COMM4, slv_ans ) ) == 0 )
        return;

    // MDB SLAVE_CASHLESS
    if( ( slv_ans[0] & 0xF8 ) == 0x10 )      
//mmm     if( ( slv_ans[0] & 0xF8 ) == 0x60 )
    {
        crc = MDB_ACK;
        if( ( slv_ans[0] & 0x07 ) == CASHLESS_POLL )
        {
            if( MDBSlavePoll )
            {
                MDBSlaveSend( MDBSlavePoll );
                commPutChar( COMM4, crc );    // send MDB_ACK ( as single byte ) or CRC in multibyte commands
                MDBSlavePoll = 0;
                return;
            }
            switch( Slave_Cashless_Status )
            {
                case CASHLESS_STATE_NOT_PRESENT : MDBSlaveSend( 0x00 );
                                                  Slave_Cashless_Status = CASHLESS_STATE_INACTIVE; 
                                                  break;
                                                  
                case CASHLESS_STATE_ENABLED :     /*if( cash + card )*/ //mmm
                                                  {
                                                      MDBSlaveSend( CASHLESS_BEGIN_SESSION ); 
//                                                      MDBSlaveSend( 0xFF );  // set to maxprice, maybe 0xFFFF not handled
//                                                      MDBSlaveSend( 0xFF );  // set to maxprice
                                                      MDBSlaveSend( maxPrice >> 8 );    // set to maxprice, maybe 0xFFFF not handled
                                                      MDBSlaveSend( maxPrice & 0xFF );  // set to maxprice */
//mmm                                                       MDBSlaveSend( cash >> 8 );
//mmm                                                       MDBSlaveSend( cash & 0xFF );                                                 
                                                      Slave_Cashless_Status = CASHLESS_STATE_IDLE;
                                                  }
                                                  break;
                                                  
                case CASHLESS_STATE_IDLE :        /*if( cash + card )
                                                  {
                                                      break;
                                                  }
                                                  else
                                                  {
                                                      MDBSlaveSend( CASHLESS_SESSION_CANCEL_REQUEST ); // wait for session complete
                                                      Slave_Cashless_Status = CASHLESS_STATE_IDLE;
                                                  }*/
                                                  break;
                                                  
                case CASHLESS_STATE_IDLE+10 :     MDBSlaveSend( CASHLESS_SESSION_CANCEL_REQUEST ); // wait for session complete
                                                  Slave_Cashless_Status = CASHLESS_STATE_IDLE;
                                                  break;
                                                  
                default:                          break;
            }
        }
        /* single byte commands */
        switch( slv_ans[0] & 0x07 )
        {
            case CASHLESS_RESET:  Slave_Cashless_Status = CASHLESS_STATE_NOT_PRESENT; break;
            
            case CASHLESS_SETUP: if( slv_ans[1] == 0x00 )
                                 {/*      CASHLESS_SETUP, noy used
                                    pMDBPerif->cmd[1] = 0x00;
                                    pMDBPerif->cmd[2] = VMCLevel; // VMC level
                                    pMDBPerif->cmd[3] = 16;   // display columns
                                    pMDBPerif->cmd[4] = 1;    // display rows
                                    pMDBPerif->cmd[5] = 1;    // display ASCII */
                                    MDBSlaveSend( 0x01 ); // Reader config Data
                                    MDBSlaveSend( 0x01 ); // Feature_Level
                                    MDBSlaveSend( 0x19 ); // Country_Currency_Code low EURO ( USD is 18 )
                                    MDBSlaveSend( 0x78 ); // Country_Currency_Code high EURO ( USD is 40 )
                                    MDBSlaveSend( 0x01 ); // Scaling_Factor = 1
                                    MDBSlaveSend( 0x02 ); // Decimal_Places = 2
                                    MDBSlaveSend( 0x01 ); // Application_Maximum_Response_Time
                                    MDBSlaveSend( 0x01 ); // Options_byte, refund possible
                                 }
                                 else
                                 {
                                    /* set min-max price */
                                 }
                                 break;
                                 
            default :            break;     // POLL
        }
        /* two byte commands */
        switch( ( (dword)slv_ans[0] & 0x07 ) | ( (dword)slv_ans[1] << 8 ) )
        {
            // inactive
            case CASHLESS_EXPANSION_ID: 
                                    MDBSlaveSend( 0x09 ); // Expansion ID anseer
                                    MDBSlaveSend( 'R' ); // Manufacturer code
                                    MDBSlaveSend( 'S' ); // Manufacturer code
                                    MDBSlaveSend( 'R' ); // Manufacturer code
                                    MDBSlaveSend( '0' ); // Serial Z5 -- read from single wire memory
                                    MDBSlaveSend( '0' ); // Serial Z6
                                    MDBSlaveSend( '0' ); // Serial Z7
                                    MDBSlaveSend( '0' ); // Serial Z8
                                    MDBSlaveSend( '0' ); // Serial Z9
                                    MDBSlaveSend( '0' ); // Serial Z10
                                    MDBSlaveSend( '0' ); // Serial Z11
                                    MDBSlaveSend( '0' ); // Serial Z12
                                    MDBSlaveSend( '0' ); // Serial Z13
                                    MDBSlaveSend( '9' ); // Serial Z14
                                    MDBSlaveSend( '0' ); // Serial Z15
                                    MDBSlaveSend( '3' ); // Serial Z16
                                    MDBSlaveSend( '0' ); // Model number Z17
                                    MDBSlaveSend( '0' ); // Model number Z18
                                    MDBSlaveSend( '0' ); // Model number Z19
                                    MDBSlaveSend( '0' ); // Model number Z20
                                    MDBSlaveSend( '0' ); // Model number Z21
                                    MDBSlaveSend( '0' ); // Model number Z22
                                    MDBSlaveSend( '0' ); // Model number Z23
                                    MDBSlaveSend( '0' ); // Model number Z24
                                    MDBSlaveSend( '0' ); // Model number Z25
                                    MDBSlaveSend( '9' ); // Model number Z26
                                    MDBSlaveSend( '0' ); // Model number Z27
                                    MDBSlaveSend( '3' ); // Model number Z28
                                    MDBSlaveSend( '0' ); // SW revision Z29
                                    MDBSlaveSend( '0' ); // SW revision Z30
                                    Slave_Cashless_Status = CASHLESS_STATE_DISABLED; 
                                    break;
            // disabled
            case CASHLESS_ENABLE:   if( Slave_Cashless_Status == CASHLESS_STATE_DISABLED )
                                       Slave_Cashless_Status = CASHLESS_STATE_ENABLED;
                                    //else
                                        // out_of_sequence
                                    break;
            // enabled
            case CASHLESS_DISABLE:  if( Slave_Cashless_Status == CASHLESS_STATE_ENABLED  ||
                                        Slave_Cashless_Status == CASHLESS_STATE_IDLE  )
                                    {
                                        Slave_Cashless_Status = CASHLESS_STATE_DISABLED;
                                    }
                                     break;

            case CASHLESS_CANCEL:   if( Slave_Cashless_Status == CASHLESS_STATE_ENABLED  ||
                                        Slave_Cashless_Status == CASHLESS_STATE_IDLE  )
                                    {
                                        MDBSlavePoll = CASHLESS_CANCELLED;
                                        Slave_Cashless_Status = CASHLESS_STATE_DISABLED;
                                    }
                                    break;
            // idle
            case CASHLESS_SESSION_COMPLETE:
                                    if( Slave_Cashless_Status == CASHLESS_STATE_IDLE || 
                                        Slave_Cashless_Status == (CASHLESS_STATE_IDLE+10) )
                                    {
                                        MDBSlavePoll = CASHLESS_END_SESSION;
                                        //Slave_Cashless_Status = CASHLESS_STATE_ENABLED; 
                                        Slave_Cashless_Status = CASHLESS_STATE_NOT_PRESENT; 
                                    }
                                    break;

                                    
            case CASHLESS_VEND:     if( Slave_Cashless_Status == CASHLESS_STATE_IDLE  )
                                    {
                                        price=( ( (dword)slv_ans[2] )<<8) +(dword)slv_ans[3];
                                        MDBSlaveSend( CASHLESS_VEND_APPROVED ); 
                                        MDBSlaveSend( price >> 8 );   // set to same are selection price
                                        MDBSlaveSend( price & 0xFF ); 
                                        Slave_Cashless_Status = CASHLESS_STATE_VEND;
                                        SlaveSelection = 0x80;        // used to start wait timeout on selection completion
                                    }
                                    break;
            // vend
            case CASHLESS_VEND_FAILURE:
                                    Slave_Cashless_Status = CASHLESS_STATE_IDLE+10;
                                    SlaveSelection = 0x02;
                                    break;

            case CASHLESS_VEND_CANCEL:   MDBSlaveSend( CASHLESS_VEND_DENIED );
                                    SlaveSelection = 0x02;
                                    // must return to idle
                                    Slave_Cashless_Status = CASHLESS_STATE_IDLE+10; 
                                    break;

            case CASHLESS_VEND_SUCCESS:   // must return to idle
                                    SlaveSelection = 0x01;
                                    Slave_Cashless_Status = CASHLESS_STATE_IDLE+10; 
                                    break;

            default :               break;
        }
        commPutChar( COMM4, crc );    // send MDB_ACK ( as single byte ) or CRC in multibyte commands
    }
}
#endif

#if RSR903_MDB
BOOL  testActiveMotor( byte _s_tray, byte _s_column);
byte  sels_map[MAXTRAY*MAXCOLUMN/8+1];

void            testSels( void )
{
    byte        i, j, idx, mask;

    idx = 0;
    mask = 0x01;
    memset( sels_map, 0x00, sizeof( sels_map ));
    for( i = 0; i < MAXTRAY; i++)
    {
        for( j = 0; j < MAXCOLUMN; j++)
        {
            if( testActiveMotor(i,j) == TRUE && checkCoupling(i, j) == FALSE && checkNotConsecutiveCoupling(i, j, 0) == FALSE )
            {
                sels_map[idx] |= mask;
            }
            if( mask & 0x80 ) 
            {
                mask = 0x01;
                idx++;
            }
            else
                mask <<= 1;
        }
    }
}

/*--------------------------------------------------------------------------
 |  SLAVE 1 :  emulate a simple slave VMC
 |                              --------------
 |  Used to emulate a slave VMC
 +--------------------------------------------------------------------------*/

extern struct _HOST_DATA_  hostData;

byte crc1 = 0;
static  MDBSlave1Send( char ch )
{
    _commPutChar( COMM2, ch );
    crc1 += ch;
}


void    MDBSlave1( void ) 
{
#ifndef BOOT
static  struct S_EVENT *pEventR = sEvent;
static  byte mySelection = 0, mySelectionStatus = 0;
static  dword validFrame1 = 0;
    byte slv_ans_len, slv_ans[MAX_MDB_FRAME];

    /* check selection status */
    while ( pEventR != pEventW )
    {
        switch ( pEventR->event )
        {                
            case EVENT_SELECTION_START:
                 if( mySelection ) mySelectionStatus = 1;
                 break;
                 
            case EVENT_SELECTION_OK:
                 if( mySelection ) mySelectionStatus = 2;
                 mySelection = 0;
                 break;
                
            case EVENT_SELECTION_UNAVAIL:
            case EVENT_SELECTION_FAILED:
                 if( mySelection ) mySelectionStatus = 3;
                 mySelection = 0;
                 break;
                
            default:
                 break;
        }        
        if ( ++pEventR >= &sEvent[16] )   pEventR = sEvent;
    }                                   // end handle events to upate available credir
   
    if( ( slv_ans_len = MDBSlaveCheck( COMM2, slv_ans ) ) == 0 )
        return;

    // MDB SLAVE_DEVICE
    crc1 = MDB_ACK;
    if( ( slv_ans[0] & 0xF8 ) == machine_address )    
    {
          // valid frame
          validFrame1++;
          // SETUP
          if( ( slv_ans[0] & 0x07 ) == 0x01 )
          {
              MDBSlave1Send( 'R' ); // Manufacturer code
              MDBSlave1Send( 'S' ); // Manufacturer code
              MDBSlave1Send( 'R' ); // Manufacturer code
              MDBSlave1Send( SerialID[0] );  // serilaID
              MDBSlave1Send( SerialID[1] );
              MDBSlave1Send( SerialID[2] );
              MDBSlave1Send( SerialID[3] );
              MDBSlave1Send( SerialID[4] );
              MDBSlave1Send( SerialID[5] );
              MDBSlave1Send( SerialID[6] );
              MDBSlave1Send( SerialID[7] );
              MDBSlave1Send( fwRelease[0] );
              MDBSlave1Send( fwRelease[1] );
              MDBSlave1Send( fwRelease[2] );
              MDBSlave1Send( fwRelease[3] );
              MDBSlave1Send( 0x1E ); // selection timeout in seconds

              // machine active selections
              MDBSlave1Send( sels_map[0] ); // 0..7
              MDBSlave1Send( sels_map[1] ); // 8..15
              MDBSlave1Send( sels_map[2] ); // 16..23
              MDBSlave1Send( sels_map[3] ); // 24..31
              MDBSlave1Send( sels_map[4] ); // 32..39
              MDBSlave1Send( sels_map[5] ); // 40..47
              MDBSlave1Send( sels_map[6] ); // 48..55
              MDBSlave1Send( sels_map[7] ); // 56..63
              MDBSlave1Send( sels_map[8] ); // 64..71
              MDBSlave1Send( sels_map[9] ); // 72..79
              MDBSlave1Send( sels_map[10] ); // 80..87
              MDBSlave1Send( sels_map[11] ); // 88..95
              MDBSlave1Send( sels_map[12] ); // 96..99, [MAXTRAY*MAXCOLUMN/8]
              
          }
          // POLL
          if( ( slv_ans[0] & 0x07 ) == 0x02 && mySelectionStatus )
          {
              MDBSlave1Send( mySelectionStatus );
              mySelectionStatus = 0;
          }
          // smake selection
          if( ( slv_ans[0] & 0x07 ) == 0x03 && mySelection == 0 ) // TODO 
          {
              hostData.tray = slv_ans[1];
              hostData.column = slv_ans[2];
              hostData.select = 1;
              slave_mac = 1;
              mySelection = 1;
          }
          maxPrice = 100;   // DEBUG SOLO PER TEST SE OK
          commPutChar( COMM2, crc1 );
          IO1CLR_bit.P1_25 = 1;
    }
#endif    
}
#endif
